/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.base.dto.ShareTarget;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.model.pub.entity.SyncLog;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.model.user.entity.WorkGroup;
import com.geoway.landteam.landcloud.core.model.user.entity.WorkGroupMember;
import com.geoway.landteam.landcloud.core.model.user.entity.YXUser;
import com.geoway.landteam.landcloud.core.repository.base.AppBasicRepository;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.pub.CloudDiskOfPersonRepository;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OrganizationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OssConfigRepository;
import com.geoway.landteam.landcloud.core.repository.pub.SyncLogRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRoleinfoRepository;
import com.geoway.landteam.landcloud.core.repository.user.WorkGroupMemberRepository;
import com.geoway.landteam.landcloud.core.repository.user.WorkGroupRepository;
import com.geoway.landteam.landcloud.core.repository.user.YXUserRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.service.util.CloudMsgUtil;
import com.geoway.landteam.landcloud.servface.base.AppBasicService;
import com.geoway.landteam.landcloud.servface.suishoupai.JctbService;
import com.geoway.landteam.suishoupai.model.pub.entity.APicShare;
import com.geoway.landteam.suishoupai.repository.pub.APicShareRepository;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MShareService {
    @Autowired
    APicShareRepository aPicShareRepository;
    @Autowired
    AppBasicRepository appBasicRepository;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    APicShareRepository picShareDao;
    @Autowired
    YXUserRepository yxUserRepository;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    AppBasicService appBasicService;
    @Autowired
    JctbService jctbService;
    @Autowired
    WorkGroupRepository workGroupRepository;
    @Autowired
    WorkGroupMemberRepository workGroupMemberRepository;
    @Autowired
    Organization2UserRepository organization2UserDao;
    @Autowired
    OrganizationRepository OrganizationDao;
    @Autowired
    LandUserRoleinfoRepository landUserRoleDao;
    @Autowired
    DefaultOssOperatorService ossService;
    @Autowired
    CloudDiskOfPersonRepository cloudDiskOfPersonDao;
    @Autowired
    SyncLogRepository syncLogDao;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    protected String innerImgUrl;
    @Autowired
    OssConfigRepository ossConfigRepository;

    public List<APicShare> launchShare(Long userId, String id, String targetUsers, boolean sm, String message, String appBasicInfo, String title) throws Exception {
        String[] targetUsersArr;
        if (StringUtils.isBlank((CharSequence)targetUsers)) {
            throw new RuntimeException("\u63a5\u6536\u5206\u4eab\u7684\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        appBasicInfo = this.completeAppBasicInfo(id, appBasicInfo);
        ArrayList<APicShare> list = new ArrayList<APicShare>();
        for (String targetUser : targetUsersArr = targetUsers.split(",")) {
            boolean flag = this.hasYXAccount(targetUser);
            APicShare share = this.generateShareRecord(userId, id, targetUser, flag, 1, appBasicInfo);
            share.setTargetHasYXAccount(Boolean.valueOf(flag));
            if (sm && flag) {
                this.sendYXMessage(userId, id, share.getId(), targetUser, message, title);
            }
            String userTargetName = ((LandUser)this.landUserRepository.findById((Object)Long.valueOf(targetUser)).orElse(null)).getName();
            share.setUserTargetName(userTargetName);
            list.add(share);
        }
        return list;
    }

    private String completeAppBasicInfo(String id, String appBasicInfo) throws Exception {
        if (StringUtils.isBlank((CharSequence)appBasicInfo)) {
            AppBasic appBasic = this.appBasicService.getDetailById(id);
            if (appBasic == null) {
                throw new RuntimeException("\u968f\u624b\u62cd\u4e0d\u5b58\u5728");
            }
            AppBasic basic = new AppBasic();
            BeanUtils.copyProperties((Object)appBasic, (Object)basic);
            ArrayList<AppMedia> mediaList = new ArrayList<AppMedia>();
            List appMediaList = appBasic.getList();
            for (AppMedia appMedia : appMediaList) {
                String suffix;
                String serverPath = appMedia.getServerpath();
                String downloadUrl = appMedia.getDownloadUrl();
                if (!StringUtils.isBlank((CharSequence)serverPath) || !StringUtils.isNotBlank((CharSequence)downloadUrl)) continue;
                switch (appMedia.getType()) {
                    case 1: {
                        suffix = ".jpg";
                        break;
                    }
                    case 2: {
                        suffix = ".mp4";
                        break;
                    }
                    case 3: {
                        suffix = ".mp3";
                        break;
                    }
                    default: {
                        suffix = ".jpg";
                    }
                }
                String fileName = appMedia.getId() + suffix;
                File tempFile = new File(System.getProperty("java.io.tmpdir") + "/" + fileName);
                FileUtils.copyURLToFile((URL)new URL(downloadUrl), (File)tempFile);
                String url = this.ossService.sendObject2Oss(fileName, tempFile);
                AppMedia tempMedia = new AppMedia();
                BeanUtils.copyProperties((Object)appMedia, (Object)tempMedia);
                tempMedia.setFileId("");
                tempMedia.setDownloadUrl("");
                tempMedia.setServerpath(url);
                mediaList.add(tempMedia);
                tempFile.delete();
            }
            basic.setList(mediaList);
            appBasicInfo = JSON.toJSONString((Object)basic, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        }
        return appBasicInfo;
    }

    public List<APicShare> launchShares(Long userId, String ids, String targetUsers, boolean sm, String message, String appBasicInfo) throws Exception {
        String[] idArr;
        if (StringUtils.isBlank((CharSequence)ids)) {
            throw new RuntimeException("\u5206\u4eab\u7684\u968f\u624b\u62cd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<APicShare> list = new ArrayList<APicShare>();
        for (String id : idArr = ids.split(",")) {
            List<APicShare> aPicShares = this.launchShare(userId, id, targetUsers, sm, message, appBasicInfo, "\u968f\u624b\u62cd\u5206\u4eab");
            list.addAll(aPicShares);
        }
        return list;
    }

    private Map<String, String> createYXMessageMap(String id) throws Exception {
        AppBasic appBasic = this.appBasicRepository.findById((Object)id).orElse(null);
        if (appBasic == null) {
            throw new RuntimeException("\u63d0\u4ea4\u5230\u5355\u4f4d\u4e91\u7684\u968f\u624b\u62cd\u6682\u65f6\u4e0d\u652f\u6301\u5206\u4eab\u529f\u80fd");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        String heading = appBasic.getHeading();
        if (heading == null) {
            heading = "";
        }
        map.put("heading", heading);
        map.put("loc", appBasic.getName());
        map.put("type", appBasic.getType());
        map.put("username_from", appBasic.getUsername());
        map.put("image_url", this.getFirstImageUrl(id));
        return map;
    }

    private String createOuterMap(YXUser sharer, String id, YXUser receiver, String shareId, String shareType) throws Exception {
        Map<String, String> map = this.createYXMessageMap(id);
        HashMap<String, String> outerMap = new HashMap<String, String>();
        outerMap.put("shareJson", JSON.toJSONString(map));
        outerMap.put("shareType", shareType);
        outerMap.put("userName", sharer.getName());
        outerMap.put("name", sharer.getName());
        outerMap.put("userId", sharer.getId().toString());
        outerMap.put("receiverName", receiver.getName());
        outerMap.put("shareId", shareId);
        LandUser landUser = this.landUserRepository.findById((Object)sharer.getId()).orElse(null);
        this.innerImgUrl = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.OSS_INNER_IMAGEURL.getKey());
        outerMap.put("userIconUrl", this.innerImgUrl + landUser.getImgUrl());
        return JSON.toJSONString(outerMap);
    }

    private String createOuterMapForWorkGroup(YXUser sharer, String id, WorkGroup receiver, String shareId, String shareType) throws Exception {
        Map<String, String> map = this.createYXMessageMap(id);
        HashMap<String, String> outerMap = new HashMap<String, String>();
        outerMap.put("shareJson", JSON.toJSONString(map));
        outerMap.put("shareType", shareType);
        outerMap.put("userName", sharer.getName());
        outerMap.put("userId", sharer.getId().toString());
        outerMap.put("name", receiver.getName());
        outerMap.put("workId", receiver.getId());
        outerMap.put("shareId", shareId);
        LandUser landUser = this.landUserRepository.findById((Object)sharer.getId()).orElse(null);
        this.innerImgUrl = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.OSS_INNER_IMAGEURL.getKey());
        outerMap.put("userIconUrl", this.innerImgUrl + landUser.getImgUrl());
        return JSON.toJSONString(outerMap);
    }

    private String getFirstImageUrl(String id) {
        List appMedias = this.appMediaRepository.queryOfPhoto(id, (Pageable)PageRequest.of((int)0, (int)1));
        if (!appMedias.isEmpty()) {
            String downLoadUrl = ((AppMedia)appMedias.get(0)).getDownloadUrl();
            if (StringUtils.isNotBlank((CharSequence)downLoadUrl)) {
                return downLoadUrl;
            }
            String serverPath = ((AppMedia)appMedias.get(0)).getServerpath();
            if (StringUtils.isNotBlank((CharSequence)serverPath)) {
                return serverPath;
            }
        }
        return "";
    }

    private String getFirstImage(AppBasic appBasic) {
        List appMedias = appBasic.getList();
        for (AppMedia appMedia : appMedias) {
            if (appMedia.getType() != 1 && appMedia.getType() != 2) continue;
            return appMedia.getServerpath();
        }
        return "";
    }

    private String getFirstImage(JSONArray arrList) {
        for (int i = 0; i < arrList.size(); ++i) {
            JSONObject jsonObject = arrList.getJSONObject(i);
            Integer type = jsonObject.getInteger("type");
            if (type != 2 && type != 1) continue;
            return jsonObject.getString("serverpath");
        }
        return "";
    }

    private APicShare generateShareRecord(Long userId, String id, String targetUser, boolean flag, int shareType, String appBaiscInfo) {
        APicShare share = new APicShare();
        share.setId(UUID.randomUUID().toString());
        share.setOldId(id);
        share.setUserShare(userId);
        share.setShareTime(new Date());
        share.setUserTarget(targetUser);
        share.setStatus(Integer.valueOf(0));
        share.setShareType(Integer.valueOf(shareType));
        JSONObject jsonObject = JSONObject.parseObject((String)appBaiscInfo);
        JSONArray list = jsonObject.getJSONArray("list");
        if (this.workGroupRepository.findById((Object)targetUser).orElse(null) == null) {
            AppBasic appBasic = (AppBasic)JSON.parseObject((String)appBaiscInfo, AppBasic.class);
            appBasic.setUserid(targetUser);
            appBasic.setTime(new Date());
            this.appBasicRepository.save((Object)appBasic);
        } else {
            List usersIdinWorkGroup = this.workGroupMemberRepository.queryMembersId(targetUser);
            ArrayList<AppBasic> appBasics = new ArrayList<AppBasic>();
            Date date = new Date();
            for (Long uId : usersIdinWorkGroup) {
                AppBasic appBasic = (AppBasic)JSON.parseObject((String)appBaiscInfo, AppBasic.class);
                appBasic.setId(UUID.randomUUID().toString());
                appBasic.setUserid(uId.toString());
                appBasic.setTime(date);
                appBasics.add(appBasic);
            }
            this.appBasicRepository.saveAll(appBasics);
        }
        if (list != null && list.size() > 0) {
            share.setImage(this.getFirstImage(list));
        }
        share.setAppBasicInfo(appBaiscInfo);
        if (flag) {
            this.picShareDao.save((Object)share);
        }
        return share;
    }

    private boolean hasYXAccount(String userId) {
        YXUser yxUser = this.yxUserRepository.findOneByUserId(Long.valueOf(Long.parseLong(userId)));
        return yxUser != null;
    }

    private void sendYXMessage(Long userId, String id, String shareId, String targetUser, String message, String title) throws Exception {
        YXUser sharer = this.yxUserRepository.findOneByUserId(userId);
        YXUser receiver = this.yxUserRepository.findOneByUserId(Long.valueOf(Long.parseLong(targetUser)));
        String ope = "0";
        String type = "0";
        String ext = this.createOuterMap(sharer, id, receiver, shareId, "1");
        String body = "{'msg':'" + title + "'}";
        CloudMsgUtil.sendMsg((String)sharer.getAccid(), (String)ope, (String)receiver.getAccid(), (String)type, (String)body, (String)ext);
        if (StringUtils.isNotBlank((CharSequence)message)) {
            String ext2 = this.createOuterMap(sharer, id, receiver, shareId, "0");
            String body2 = "{'msg':'" + message + "'}";
            CloudMsgUtil.sendMsg((String)sharer.getAccid(), (String)ope, (String)receiver.getAccid(), (String)type, (String)body2, (String)ext2);
        }
    }

    public AppBasic acceptShare(Long userId, String id) throws Exception {
        List list = this.picShareDao.getNewestShare(userId + "", id, (Pageable)PageRequest.of((int)0, (int)1));
        if (list.size() == 0) {
            throw new RuntimeException("\u8be5\u968f\u624b\u62cd\u5206\u4eab\u5df2\u88ab\u53d6\u6d88,\u4e0d\u652f\u6301\u67e5\u770b/\u4e0b\u8f7d");
        }
        APicShare share = (APicShare)list.get(0);
        if (share.getStatus() == 1) {
            throw new RuntimeException("\u5df2\u63a5\u6536\u8be5\u5206\u4eab\uff0c\u65e0\u6cd5\u91cd\u590d\u63a5\u6536");
        }
        LandUser user = this.landUserRepository.findById((Object)userId).orElse(null);
        AppBasic appBasic = this.appBasicRepository.findById((Object)share.getOldId()).orElse(null);
        AppBasic newbasic = new AppBasic();
        BeanUtils.copyProperties((Object)appBasic, (Object)newbasic);
        newbasic.setMj(appBasic.getMj());
        newbasic.setId(UUID.randomUUID().toString());
        newbasic.setShareUser(Long.valueOf(appBasic.getUserid()));
        newbasic.setUserid(userId + "");
        newbasic.setUsername(user.getName());
        newbasic.setShareId(share.getOldId());
        newbasic.setShareType(Integer.valueOf(1));
        newbasic.setOri("907");
        this.appBasicRepository.save((Object)newbasic);
        share.setStatus(Integer.valueOf(1));
        share.setAcceptTime(new Date());
        share.setNewId(newbasic.getId());
        this.picShareDao.save((Object)share);
        List mds = this.appMediaRepository.queryByGid(appBasic.getId());
        ArrayList<AppMedia> newMedias = new ArrayList<AppMedia>();
        for (AppMedia appMedia : mds) {
            AppMedia appMediaShare = new AppMedia();
            BeanUtils.copyProperties((Object)appMedia, (Object)appMediaShare);
            appMediaShare.setId(UUID.randomUUID().toString());
            appMediaShare.setGalleryid(newbasic.getId());
            appMediaShare.setUsername(user.getName());
            newMedias.add(appMediaShare);
        }
        this.appMediaRepository.saveAll(newMedias);
        newbasic.setList(newMedias);
        return newbasic;
    }

    public AppBasic acceptShareNew(Long userId, String shareId) throws Exception {
        APicShare share = this.picShareDao.findById((Object)shareId).orElse(null);
        if (share == null) {
            throw new RuntimeException("\u8be5\u5206\u4eab\u5df2\u88ab\u53d6\u6d88\u6216\u5220\u9664");
        }
        if (!share.getUserTarget().equals(userId.toString())) {
            throw new RuntimeException("\u65e0\u6cd5\u63a5\u6536");
        }
        if (share.getStatus() == 1) {
            throw new RuntimeException("\u5df2\u63a5\u6536\u8be5\u5206\u4eab\uff0c\u65e0\u6cd5\u91cd\u590d\u63a5\u6536");
        }
        AppBasic appBasic = this.completeAppBasic(share);
        LandUser user = this.landUserRepository.findById((Object)userId).orElse(null);
        AppBasic newbasic = new AppBasic();
        BeanUtils.copyProperties((Object)appBasic, (Object)newbasic);
        newbasic.setId(UUID.randomUUID().toString());
        newbasic.setShareUser(share.getUserShare());
        newbasic.setIsDeleted(Integer.valueOf(0));
        newbasic.setTime(new Date());
        newbasic.setUserid(userId + "");
        newbasic.setUsername(user.getName());
        newbasic.setShareId(share.getOldId());
        newbasic.setShareType(Integer.valueOf(1));
        newbasic.setOri("907");
        share.setStatus(Integer.valueOf(1));
        share.setAcceptTime(new Date());
        share.setNewId(newbasic.getId());
        this.picShareDao.save((Object)share);
        List mds = newbasic.getList() == null ? new ArrayList() : newbasic.getList();
        ArrayList<AppMedia> newMedias = new ArrayList<AppMedia>();
        for (AppMedia appMedia : mds) {
            AppMedia appMediaShare = new AppMedia();
            BeanUtils.copyProperties((Object)appMedia, (Object)appMediaShare);
            appMediaShare.setId(UUID.randomUUID().toString());
            appMediaShare.setGalleryid(newbasic.getId());
            appMediaShare.setUsername(user.getName());
            newMedias.add(appMediaShare);
        }
        this.saveNewAppMediasAndLogs(userId, newMedias);
        newbasic.setList(newMedias);
        this.appBasicRepository.save((Object)newbasic);
        this.saveAppBasicLog(userId, newbasic);
        return newbasic;
    }

    public String acceptShareTask(Long userId, String shareId) throws Exception {
        APicShare share = this.picShareDao.findById((Object)shareId).orElse(null);
        if (share == null) {
            throw new RuntimeException("\u8be5\u5206\u4eab\u5df2\u88ab\u53d6\u6d88\u6216\u5220\u9664");
        }
        if (!share.getUserTarget().equals(userId.toString())) {
            throw new RuntimeException("\u65e0\u6cd5\u63a5\u6536");
        }
        if (share.getStatus() == 1) {
            throw new RuntimeException("\u5df2\u63a5\u6536\u8be5\u5206\u4eab\uff0c\u65e0\u6cd5\u91cd\u590d\u63a5\u6536");
        }
        share.setStatus(Integer.valueOf(1));
        share.setAcceptTime(new Date());
        share.setNewId("");
        this.picShareDao.save((Object)share);
        return share.getAppBasicInfo();
    }

    private void saveAppBasicLog(Long userId, AppBasic newbasic) {
        SyncLog syncLog = new SyncLog();
        syncLog.setId(UUID.randomUUID().toString());
        syncLog.setObjtype(Integer.valueOf(1));
        syncLog.setObjid(newbasic.getId());
        syncLog.setOpttype(Integer.valueOf(1));
        syncLog.setOpttime(new Date());
        syncLog.setOptori(Integer.valueOf(2));
        syncLog.setState(Integer.valueOf(2));
        syncLog.setData(JSONObject.toJSONString((Object)newbasic));
        syncLog.setOptuserid(userId);
        this.syncLogDao.save((Object)syncLog);
    }

    private void saveNewAppMediasAndLogs(Long userId, List<AppMedia> newMedias) throws Exception {
        ArrayList syncLogs = new ArrayList();
        for (AppMedia appMedia : newMedias) {
            String fileId = appMedia.getFileId();
            String serverPath = appMedia.getServerpath();
            Object newSimpleFileId = null;
            if (!StringUtils.isNotBlank((CharSequence)serverPath)) continue;
            serverPath = this.temporarySignedUrlService.getTemporarySignedUrl("", serverPath, null);
            File file = this.getFileFromUrl(serverPath);
            String url = this.ossService.sendObject2Oss("media/" + UUID.randomUUID().toString(), file);
            appMedia.setServerpath(url);
        }
        this.appMediaRepository.saveAll(newMedias);
    }

    private SyncLog generateOperateLogOfAppMedia(Long userId, AppMedia appMedia) {
        SyncLog syncLog = new SyncLog();
        syncLog.setId(UUID.randomUUID().toString());
        syncLog.setObjtype(Integer.valueOf(3));
        syncLog.setObjid(appMedia.getId());
        syncLog.setOpttype(Integer.valueOf(1));
        syncLog.setOpttime(new Date());
        syncLog.setOptori(Integer.valueOf(2));
        syncLog.setState(Integer.valueOf(2));
        syncLog.setData(JSONObject.toJSONString((Object)appMedia));
        syncLog.setParentobjid(appMedia.getGalleryid());
        syncLog.setOptuserid(userId);
        return syncLog;
    }

    private boolean isNationalLevel(Long userId) {
        List roleIds = this.landUserRoleDao.findRoleIdByUserId(userId);
        return roleIds.contains("10012");
    }

    private File getFileFromUrl(String url) throws Exception {
        String fileName = url.substring(url.lastIndexOf("/") + 1);
        if (fileName.indexOf("?") > -1) {
            fileName = fileName.substring(0, fileName.indexOf("?"));
        }
        File file = new File(System.getProperty("java.io.tmpdir") + "/" + fileName);
        FileUtils.copyURLToFile((URL)new URL(url), (File)file);
        return file;
    }

    public Page<APicShare> getShareList(Long userId, int start, int limit) throws Exception {
        String sortParam = "SORT_shareTime_DESC";
        String filterParam = "Q_userTarget_S_EQ=" + userId;
        Page basics = this.picShareDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        for (APicShare share : basics) {
            this.setTheShareTarget(share);
            String gid = share.getOldId();
            AppBasic basic = this.appBasicRepository.findById((Object)gid).orElse(null);
            basic.setCurMedia(this.appBasicService.getFirstPhont(gid));
        }
        return basics;
    }

    public Page<APicShare> getMyShareList(String filterParam, String sortParam, Long userId, int start, int limit) {
        if (!"".equals(filterParam)) {
            filterParam = filterParam + ";";
        }
        filterParam = filterParam + "Q_userShare_N_EQ=" + userId + ";(Q_shareType_N_EQ=1;QOR_shareType_N_EQ=4)";
        Page shares = this.picShareDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        for (APicShare share : shares) {
            AppBasic basic;
            String gid = share.getOldId();
            if (StringUtils.isNotBlank((CharSequence)share.getAppBasicInfo())) {
                basic = (AppBasic)JSON.parseObject((String)share.getAppBasicInfo(), AppBasic.class);
                List list = basic.getList();
                if (list != null) {
                    for (AppMedia appMedia : list) {
                        if (appMedia.getType() != 1 && appMedia.getType() != 2) continue;
                        basic.setCurMedia(appMedia);
                        break;
                    }
                }
            } else {
                basic = this.appBasicRepository.findById((Object)gid).orElse(null);
                basic.setCurMedia(this.appBasicService.getFirstPhont(gid));
            }
            this.setTheShareTarget(share);
            share.setOldBasic(basic);
        }
        return shares;
    }

    public int cancleShare(Long userId, String shareIds) throws Exception {
        String[] ids = shareIds.split(",");
        int count = 0;
        for (String id : ids) {
            APicShare aPicShare = this.picShareDao.findById((Object)id).orElse(null);
            if (aPicShare == null) {
                throw new RuntimeException("\u8be5\u968f\u624b\u62cd\u5df2\u88ab\u53d6\u6d88\u6216\u5220\u9664");
            }
            if (userId.equals(aPicShare.getUserShare())) {
                this.picShareDao.delete((Object)aPicShare);
                ++count;
                continue;
            }
            throw new RuntimeException("\u672a\u5206\u4eab\u8fc7\u8be5\u968f\u624b\u62cd");
        }
        return count;
    }

    public int cancleShareByOid(Long userId, String oids) throws Exception {
        String[] ids = oids.split(",");
        int count = 0;
        for (String id : ids) {
            List list = this.aPicShareRepository.getApicShareByOldId(id);
            if (list.isEmpty()) continue;
            for (APicShare aPicShare : list) {
                if (!userId.equals(aPicShare.getUserShare())) continue;
                this.picShareDao.delete((Object)aPicShare);
                ++count;
            }
        }
        return count;
    }

    public void shareToWorkGroups(Long userId, String ids, String workGroupIds, boolean cover, String sharetype) throws Exception {
        if (StringUtils.isBlank((CharSequence)workGroupIds)) {
            throw new RuntimeException("\u5de5\u4f5c\u7ec4id\u4e3a\u7a7a");
        }
        if (!cover) {
            this.checkRepeatedSubmission(ids, workGroupIds, userId);
        }
        for (String id : ids.split(",")) {
            for (String workGroupId : workGroupIds.split(",")) {
                this.submitOneToTarget(id, workGroupId, userId, 2, sharetype);
            }
        }
    }

    private void checkRepeatedSubmission(String ids, String targetIds, Long userId) {
        int count = 0;
        for (String id : ids.split(",")) {
            for (String workGroupId : targetIds.split(",")) {
                List list = this.picShareDao.getApicShareByConditions(userId, id, workGroupId);
                if (list.isEmpty()) continue;
                ++count;
            }
        }
        if (count > 0) {
            throw new RuntimeException(count + "\u6761\u8bb0\u5f55\u5df2\u5b58\u5728");
        }
    }

    private void submitOneToTarget(String id, String targetId, Long userId, int shareType, String shareObjType) {
        APicShare share = new APicShare();
        List list = this.picShareDao.getApicShareByConditions(userId, id, targetId);
        if (list.isEmpty()) {
            share.setId(UUID.randomUUID().toString());
        } else {
            share.setId(((APicShare)list.get(0)).getId());
        }
        share.setOldId(id);
        share.setUserShare(userId);
        share.setShareTime(new Date());
        share.setUserTarget(targetId);
        share.setStatus(Integer.valueOf(0));
        share.setShareType(Integer.valueOf(shareType));
        String newId = "";
        if (StringUtils.isBlank((CharSequence)shareObjType) || "0".equalsIgnoreCase(shareObjType)) {
            newId = this.saveAppBasic(id, share, targetId);
        } else if ("1".equalsIgnoreCase(shareObjType)) {
            newId = this.saveTaskTB(id, share, targetId);
        }
        List mds = this.appMediaRepository.queryByGid(id);
        ArrayList<AppMedia> newMedias = new ArrayList<AppMedia>();
        for (AppMedia appMedia : mds) {
            AppMedia appMediaShare = new AppMedia();
            BeanUtils.copyProperties((Object)appMedia, (Object)appMediaShare);
            appMediaShare.setGalleryid(newId);
            appMediaShare.setId(UUID.randomUUID().toString());
            newMedias.add(appMediaShare);
        }
        this.appMediaRepository.saveAll(newMedias);
    }

    public String saveAppBasic(String oid, APicShare share, String targetId) {
        AppBasic appBasic = this.appBasicRepository.findById((Object)oid).orElse(null);
        AppBasic newbasic = new AppBasic();
        BeanUtils.copyProperties((Object)appBasic, (Object)newbasic);
        newbasic.setId(UUID.randomUUID().toString());
        newbasic.setShareUser(Long.valueOf(appBasic.getUserid()));
        newbasic.setUserid(targetId);
        newbasic.setShareId(share.getOldId());
        newbasic.setShareType(Integer.valueOf(3));
        newbasic.setTime(share.getShareTime());
        this.appBasicRepository.save((Object)newbasic);
        share.setStatus(Integer.valueOf(1));
        share.setAcceptTime(new Date());
        share.setNewId(newbasic.getId());
        this.picShareDao.save((Object)share);
        return newbasic.getId();
    }

    public String saveTaskTB(String oid, APicShare share, String targetId) {
        return "";
    }

    public Page<APicShare> getShareListToWorkGroup(Long userId, int start, int limit, String workGroupId) throws Exception {
        List list = this.workGroupMemberRepository.getAdmin(workGroupId);
        boolean flag = false;
        for (WorkGroupMember member : list) {
            if (!userId.equals(member.getUserId())) continue;
            flag = true;
        }
        if (!flag) {
            throw new RuntimeException("\u4e0d\u662f\u5de5\u4f5c\u7ec4\u7ba1\u7406\u5458");
        }
        String filterParam = "Q_userTarget_S_EQ=" + workGroupId + ";Q_shareType_N_EQ=2";
        String sortParam = "SORT_shareTime_DESC";
        Page shares = this.picShareDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        for (APicShare aPicShare : shares) {
            this.setTheShareTarget(aPicShare);
        }
        return shares;
    }

    private void setTheShareTarget(APicShare share) {
        if (share.getShareType() == 1) {
            LandUser user = this.landUserRepository.findById((Object)Long.parseLong(share.getUserTarget())).orElse(null);
            ShareTarget target = new ShareTarget();
            target.setId(share.getUserTarget());
            target.setName(user.getName());
            share.setTarget(target);
        } else if (share.getShareType() == 4) {
            WorkGroup workGroup = this.workGroupRepository.findById((Object)share.getUserTarget()).orElse(null);
            ShareTarget target = new ShareTarget();
            target.setId(share.getUserTarget());
            target.setName(workGroup.getName());
            share.setTarget(target);
        }
    }

    public AppBasic previewShare(String shareId) throws Exception {
        APicShare share = this.picShareDao.findById((Object)shareId).orElse(null);
        if (share != null && StringUtils.isNotBlank((CharSequence)share.getAppBasicInfo())) {
            AppBasic appBasic = this.completeAppBasic(share);
            return appBasic;
        }
        throw new RuntimeException("\u8be5\u5206\u4eab\u5df2\u88ab\u53d6\u6d88");
    }

    public String previewShareTask(String shareId) throws Exception {
        APicShare share = this.picShareDao.findById((Object)shareId).orElse(null);
        if (share != null && StringUtils.isNotBlank((CharSequence)share.getAppBasicInfo())) {
            return share.getAppBasicInfo();
        }
        throw new RuntimeException("\u8be5\u5206\u4eab\u5df2\u88ab\u53d6\u6d88");
    }

    private AppBasic completeAppBasic(APicShare share) {
        String appBasicInfo = share.getAppBasicInfo();
        if (StringUtils.isBlank((CharSequence)appBasicInfo)) {
            throw new RuntimeException("\u5206\u4eab\u6570\u636e\u5f02\u5e38");
        }
        AppBasic appBasic = (AppBasic)JSON.parseObject((String)appBasicInfo, AppBasic.class);
        return appBasic;
    }

    public void appCancleShare(String id, String userTarget) throws Exception {
        List list = this.picShareDao.getNewestShare(userTarget, id, (Pageable)PageRequest.of((int)0, (int)100));
        if (list.isEmpty()) {
            throw new RuntimeException("\u8be5\u5206\u4eab\u5df2\u88ab\u53d6\u6d88\u6216\u5220\u9664");
        }
        for (APicShare share : list) {
            this.picShareDao.delete((Object)share);
        }
    }

    public int shareToOrganization(Long userId, String ids, String organizationId, boolean cover) throws Exception {
        if (StringUtils.isBlank((CharSequence)organizationId)) {
            List list = this.organization2UserDao.queryByUserId(userId);
            if (list.size() == 0) {
                throw new RuntimeException("\u7528\u6237\u65e0\u5355\u4f4d");
            }
            organizationId = ((Organization2User)list.get(0)).getOrganizationId();
        }
        int count = 0;
        String[] idArr = ids.split(",");
        if (!cover) {
            this.checkRepeatedSubmission(ids, organizationId, userId);
        }
        for (String id : idArr) {
            this.submitOneToTarget(id, organizationId, userId, 3, "");
            ++count;
        }
        return count;
    }

    public void shareToOrgAndGroups(Long userId, String ids, String organizationId, String workGroupIds, boolean cover) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)workGroupIds)) {
            this.shareToWorkGroups(userId, ids, workGroupIds, cover, "");
        }
        if (StringUtils.isNotBlank((CharSequence)organizationId)) {
            this.shareToOrganization(userId, ids, organizationId, cover);
        }
    }

    public List<APicShare> shareByWorkGroupIds(Long userId, String ids, String workGroupIds, boolean sm, String message, String appBasicInfo, String title) throws Exception {
        if (StringUtils.isBlank((CharSequence)ids) || StringUtils.isBlank((CharSequence)workGroupIds)) {
            throw new RuntimeException("\u53c2\u6570\u6709\u8bef");
        }
        ArrayList<APicShare> list = new ArrayList<APicShare>();
        for (String id : ids.split(",")) {
            appBasicInfo = this.completeAppBasicInfo(id, appBasicInfo);
            for (String workGroupId : workGroupIds.split(",")) {
                APicShare aPicShare = this.generateShareRecord(userId, id, workGroupId, true, 4, appBasicInfo);
                aPicShare.setUserTargetName(((WorkGroup)this.workGroupRepository.findById((Object)workGroupId).orElse(null)).getName());
                list.add(aPicShare);
                if (!sm) continue;
                this.sendYXMessageToWorkGroup(userId, id, aPicShare.getId(), workGroupId, message, title);
            }
        }
        return list;
    }

    private void sendYXMessageToWorkGroup(Long userId, String id, String shareId, String workGroupId, String message, String title) throws Exception {
        YXUser sharer = this.yxUserRepository.findOneByUserId(userId);
        WorkGroup workGroup = this.workGroupRepository.findById((Object)workGroupId).orElse(null);
        String ope = "1";
        String type = "0";
        String ext = this.createOuterMapForWorkGroup(sharer, id, workGroup, shareId, "1");
        String body = "{'msg':'" + title + "'}";
        CloudMsgUtil.sendMsg((String)sharer.getAccid(), (String)ope, (String)workGroup.getAccid(), (String)type, (String)body, (String)ext);
        if (StringUtils.isNotBlank((CharSequence)message)) {
            String ext2 = this.createOuterMapForWorkGroup(sharer, id, workGroup, shareId, "0");
            String body2 = "{'msg':'" + message + "'}";
            CloudMsgUtil.sendMsg((String)sharer.getAccid(), (String)ope, (String)workGroup.getAccid(), (String)type, (String)body2, (String)ext2);
        }
    }

    public AppBasic acceptShareInWorkGroup(Long userId, String shareId) throws Exception {
        APicShare share = this.picShareDao.findById((Object)shareId).orElse(null);
        if (share == null) {
            throw new RuntimeException("\u8be5\u5206\u4eab\u5df2\u88ab\u53d6\u6d88\u6216\u5220\u9664");
        }
        String workGroupId = share.getUserTarget();
        WorkGroupMember member = this.workGroupMemberRepository.queryByUserIdAndGroupId(userId, workGroupId);
        if (member == null) {
            throw new RuntimeException("\u65e0\u6cd5\u63a5\u6536");
        }
        AppBasic appBasic = this.completeAppBasic(share);
        AppBasic newbasic = new AppBasic();
        BeanUtils.copyProperties((Object)appBasic, (Object)newbasic);
        newbasic.setId(UUID.randomUUID().toString());
        newbasic.setShareUser(share.getUserShare());
        newbasic.setUserid(userId.toString());
        newbasic.setUsername(((LandUser)this.landUserRepository.findById((Object)userId).orElse(null)).getName());
        newbasic.setShareId(share.getOldId());
        newbasic.setShareType(Integer.valueOf(4));
        newbasic.setTime(new Date());
        newbasic.setIsDeleted(Integer.valueOf(0));
        newbasic.setOri("907");
        List mds = newbasic.getList();
        ArrayList<AppMedia> newMedias = new ArrayList<AppMedia>();
        for (AppMedia appMedia : mds) {
            AppMedia appMediaShare = new AppMedia();
            BeanUtils.copyProperties((Object)appMedia, (Object)appMediaShare);
            appMediaShare.setId(UUID.randomUUID().toString());
            appMediaShare.setGalleryid(newbasic.getId());
            newMedias.add(appMediaShare);
        }
        this.saveNewAppMediasAndLogs(userId, newMedias);
        newbasic.setList(newMedias);
        this.appBasicRepository.save((Object)newbasic);
        this.saveAppBasicLog(userId, newbasic);
        return newbasic;
    }

    public String acceptShareInWorkGroupTask(Long userId, String shareId) throws Exception {
        APicShare share = this.picShareDao.findById((Object)shareId).orElse(null);
        if (share == null) {
            throw new RuntimeException("\u8be5\u5206\u4eab\u5df2\u88ab\u53d6\u6d88\u6216\u5220\u9664");
        }
        String workGroupId = share.getUserTarget();
        WorkGroupMember member = this.workGroupMemberRepository.queryByUserIdAndGroupId(userId, workGroupId);
        if (member == null) {
            throw new RuntimeException("\u65e0\u6cd5\u63a5\u6536");
        }
        return share.getAppBasicInfo();
    }
}

