/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.FlowStep;
import com.geoway.landteam.customtask.repository.task.TbtskApproveRecordRepository;
import com.geoway.landteam.customtask.repository.task.TskAssignRecordRepository;
import com.geoway.landteam.customtask.task.enm.FlowTypeEnum;
import com.geoway.landteam.customtask.task.entity.TbtskFlowDef;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionTownRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskFlowService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskObjectinfoService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MStatisticalAnalysisService {
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    MTbtskFlowService tbtskFlowService;
    @Autowired
    RegionService regionService;
    @Autowired
    MTbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    MTskTaskBizService tskTaskBizService;
    @Resource
    TbtskApproveRecordRepository tbtskApproveRecordRepository;
    @Resource
    TskAssignRecordRepository tskAssignRecordRepository;
    @Autowired
    RegionRepository regionRepository;
    @Autowired
    RegionTownRepository regionTownRepository;
    @Autowired
    RegionVillageRepository regionVillageRepository;

    public JSONObject getTaskData(String taskId) {
        List maps;
        JSONObject object = new JSONObject();
        Integer assignCount = 0;
        Integer submitCount = 0;
        Integer submissionCount = 0;
        Integer allCount = 0;
        TskTaskBiz taskBiz = this.tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableInfo = this.tbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
        String findSql = "select f_status,f_review_stage,count(1) from " + tableInfo.getfTablename() + " group byf_status,f_review_stage;";
        List steps = new ArrayList();
        if (taskBiz.getIsApprove() == 1) {
            List<TbtskFlowDef> flowStep = this.tbtskFlowService.findFlow(taskId, FlowTypeEnum.AUDIT.getCode());
            if (flowStep == null || flowStep.size() == 0) {
                return null;
            }
            Gson gson = new Gson();
            steps = (List)gson.fromJson(flowStep.get(0).getSteps(), new TypeToken<List<FlowStep>>(){}.getType());
        }
        if (CollectionUtils.isNotEmpty((Collection)(maps = this.jdbcTemplate.queryForList(findSql)))) {
            for (Map map : maps) {
                if (Integer.valueOf(map.get("f_status").toString()) >= 2) {
                    assignCount = assignCount + Integer.valueOf(map.get("count").toString());
                } else if (Integer.valueOf(map.get("f_status").toString()) >= 4) {
                    assignCount = assignCount + Integer.valueOf(map.get("count").toString());
                    submitCount = submitCount + Integer.valueOf(map.get("count").toString());
                } else if (Integer.valueOf(map.get("f_status").toString()) >= 10) {
                    assignCount = assignCount + Integer.valueOf(map.get("count").toString());
                    submitCount = submitCount + Integer.valueOf(map.get("count").toString());
                    submissionCount = submissionCount + Integer.valueOf(map.get("count").toString());
                }
                allCount = allCount + Integer.valueOf(map.get("count").toString());
                if (steps.isEmpty()) continue;
                for (FlowStep step : steps) {
                    if (Integer.valueOf(map.get("f_status").toString()) < Integer.valueOf(step.getPost_status()) || Integer.valueOf(map.get("f_review_stage").toString()) < Integer.valueOf(step.getPost_stage())) continue;
                    object.put(step.getName(), (Object)(object.getInteger(step.getName()) + Integer.valueOf(map.get("count").toString())));
                }
            }
        }
        object.put("assignCount", (Object)assignCount);
        object.put("submitCount", (Object)submitCount);
        object.put("submissionCount", (Object)submissionCount);
        object.put("allCount", (Object)allCount);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray getTaskOperData(String taskId) {
        JSONArray jsonArray = new JSONArray();
        List<Object> timeList = new ArrayList();
        TskTaskBiz taskBiz = this.tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableInfo = this.tbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
        List steps = new ArrayList();
        if (taskBiz.getIsApprove() == 1) {
            List<TbtskFlowDef> flowStep = this.tbtskFlowService.findFlow(taskId, FlowTypeEnum.AUDIT.getCode());
            if (flowStep == null || flowStep.size() == 0) {
                return null;
            }
            Gson gson = new Gson();
            steps = (List)gson.fromJson(flowStep.get(0).getSteps(), new TypeToken<List<FlowStep>>(){}.getType());
        }
        Calendar start = Calendar.getInstance();
        start.setTime(taskBiz.getCreateTime());
        Calendar end = Calendar.getInstance();
        end.setTime(new Date());
        if (MStatisticalAnalysisService.testMonth(start, end)) {
            Long oneDay = 86400000L;
            Long l = start.getTimeInMillis();
            while (start.getTimeInMillis() <= end.getTimeInMillis()) {
                void var10_11;
                Date d = new Date(var10_11.longValue());
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                timeList.add(df.format(d));
                Long l2 = var10_11.longValue() + oneDay;
            }
        } else {
            timeList = this.getMonth(new SimpleDateFormat("yyyy-MM").format(start.getTime()), new SimpleDateFormat("yyyy-MM").format(end.getTime()));
        }
        for (String string : timeList) {
            int count;
            List maps;
            String findSql;
            JSONObject parJsonObject = new JSONObject();
            JSONObject jsonObject = new JSONObject();
            if (MStatisticalAnalysisService.testMonth(start, end)) {
                findSql = "select f_id from " + tableInfo.getfTablename() + " where f_committime between '" + string + " 00:00:00' and '" + string + " 23:59:59';";
                maps = this.jdbcTemplate.queryForList(findSql);
                jsonObject.put("submitCount", (Object)maps.size());
                jsonObject.put("assignCount", (Object)this.tskAssignRecordRepository.countByTaskidAndtTimeByDay(taskId, string));
                if (!steps.isEmpty()) {
                    for (FlowStep step : steps) {
                        count = this.tbtskApproveRecordRepository.countByTaskidAndStepAndtTime(taskId, step.getName(), string + " 00:00:00", string + " 23:59:59");
                        jsonObject.put(step.getName(), (Object)count);
                    }
                }
            } else {
                findSql = "select f_id from " + tableInfo.getfTablename() + " where to_char(to_timestamp(TO_NUMBER(SUBSTR(f_committime, 0,11), '9999999999')),'yyyy-MM') > '" + string + "'";
                maps = this.jdbcTemplate.queryForList(findSql);
                jsonObject.put("submitCount", (Object)maps.size());
                jsonObject.put("assignCount", (Object)this.tskAssignRecordRepository.countByTaskidAndtTimeByMonth(taskId, string));
                if (!steps.isEmpty()) {
                    for (FlowStep step : steps) {
                        count = this.tbtskApproveRecordRepository.countByTaskidAndStepAndtTimeByMonth(taskId, step.getName(), string);
                        jsonObject.put(step.getName(), (Object)count);
                    }
                }
            }
            parJsonObject.put(string, (Object)jsonObject);
            jsonArray.add((Object)parJsonObject);
        }
        return jsonArray;
    }

    public JSONArray getTaskDataByRegion(String taskId, Integer level) {
        JSONArray jsonArray = new JSONArray();
        Integer num = 7;
        if (level == 1) {
            num = 3;
        } else if (level == 2) {
            num = 5;
        } else if (level == 3) {
            num = 7;
        } else if (level == 4) {
            num = 10;
        } else if (level == 5) {
            num = 13;
        }
        TskTaskBiz taskBiz = this.tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableInfo = this.tbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
        List steps = new ArrayList();
        if (taskBiz.getIsApprove() == 1) {
            List<TbtskFlowDef> flowStep = this.tbtskFlowService.findFlow(taskId, FlowTypeEnum.AUDIT.getCode());
            if (flowStep == null || flowStep.size() == 0) {
                return null;
            }
            Gson gson = new Gson();
            steps = (List)gson.fromJson(flowStep.get(0).getSteps(), new TypeToken<List<FlowStep>>(){}.getType());
        }
        List regionGroupCount = this.jdbcTemplate.queryForList("select substring(f_xzqdmsys,0," + num + ") xzqdm,count(1) from " + tableInfo.getfTablename() + " group by substring(f_xzqdmsys,0," + num + ")");
        String findSql = "select substring(f_xzqdmsys,0," + num + ") xzqdm,f_status,f_review_stage,count(1) from " + tableInfo.getfTablename() + " group by substring(f_xzqdmsys,0," + num + "),f_status,f_review_stage";
        List maps = this.jdbcTemplate.queryForList(findSql);
        if (CollectionUtils.isNotEmpty((Collection)regionGroupCount)) {
            for (Map map : regionGroupCount) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("xzqdm", (Object)(level == 1 ? map.get("xzqdm").toString() + "0000" : (level == 2 ? map.get("xzqdm").toString() + "00" : map.get("xzqdm").toString())));
                String xzqdmName = "";
                if (level < 4) {
                    xzqdmName = this.regionRepository.getNameByCodeAndVersion(jsonObject.getString("xzqdm"), taskBiz.getVersion() != null ? taskBiz.getVersion() : "2018");
                } else if (level == 4) {
                    xzqdmName = this.regionTownRepository.getNameByCodeAndVersion(jsonObject.getString("xzqdm"), taskBiz.getVersion() != null ? taskBiz.getVersion() : "2018");
                } else if (level == 5) {
                    xzqdmName = this.regionVillageRepository.getNameByCodeAndVersion(jsonObject.getString("xzqdm"), taskBiz.getVersion() != null ? taskBiz.getVersion() : "2018");
                }
                jsonObject.put("xzqdmName", (Object)xzqdmName);
                jsonObject.put("allCount", (Object)map.get("count").toString());
                Integer assignCount = 0;
                Integer submitCount = 0;
                Integer submissionCount = 0;
                for (Map map1 : maps) {
                    if (!map.get("xzqdm").toString().equals(map1.get("xzqdm").toString())) continue;
                    if (Integer.valueOf(map.get("f_status").toString()) >= 2) {
                        assignCount = assignCount + Integer.valueOf(map.get("count").toString());
                    } else if (Integer.valueOf(map.get("f_status").toString()) >= 4) {
                        assignCount = assignCount + Integer.valueOf(map.get("count").toString());
                        submitCount = submitCount + Integer.valueOf(map.get("count").toString());
                    } else if (Integer.valueOf(map.get("f_status").toString()) >= 10) {
                        assignCount = assignCount + Integer.valueOf(map.get("count").toString());
                        submitCount = submitCount + Integer.valueOf(map.get("count").toString());
                        submissionCount = submissionCount + Integer.valueOf(map.get("count").toString());
                    }
                    if (steps.isEmpty()) continue;
                    for (FlowStep step : steps) {
                        if (Integer.valueOf(map.get("f_status").toString()) < Integer.valueOf(step.getPost_status()) || Integer.valueOf(map.get("f_review_stage").toString()) < Integer.valueOf(step.getPost_stage())) continue;
                        jsonObject.put(step.getName(), (Object)(jsonObject.getInteger(step.getName()) + Integer.valueOf(map.get("count").toString())));
                    }
                }
                jsonObject.put("assignCount", (Object)assignCount);
                jsonObject.put("submitCount", (Object)submitCount);
                jsonObject.put("submissionCount", (Object)submissionCount);
                jsonArray.add((Object)jsonObject);
            }
        }
        return jsonArray;
    }

    public JSONObject getTaskRoleData(String taskId) {
        String findSql;
        List maps;
        JSONObject object = new JSONObject();
        object.put("1", (Object)0);
        object.put("3", (Object)0);
        TskTaskBiz taskBiz = this.tskTaskBizService.findByTaskId(taskId);
        if (taskBiz.getIsApprove() == 1) {
            List<TbtskFlowDef> flowStep = this.tbtskFlowService.findFlow(taskId, FlowTypeEnum.AUDIT.getCode());
            Boolean isContainReview = false;
            if (CollectionUtils.isNotEmpty(flowStep)) {
                object.put("2", (Object)0);
                isContainReview = flowStep.get(0).getName().contains("\u5ba1\u590d\u6838");
                if (isContainReview.booleanValue()) {
                    object.put("3", (Object)0);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(maps = this.jdbcTemplate.queryForList(findSql = "select f_role,count(1)  from tbsys_user_biz2 where f_bizid =" + taskId + " group  by f_role")))) {
            for (Map map : maps) {
                Integer role = Integer.valueOf(map.get("f_role").toString());
                if (role == 1) {
                    object.put("1", (Object)Integer.valueOf(map.get("count").toString()));
                    continue;
                }
                if (role == 2) {
                    object.put("2", (Object)Integer.valueOf(map.get("count").toString()));
                    continue;
                }
                if (role == 3) {
                    object.put("3", (Object)Integer.valueOf(map.get("count").toString()));
                    continue;
                }
                if (role != 4) continue;
                object.put("4", (Object)Integer.valueOf(map.get("count").toString()));
            }
        }
        return object;
    }

    public JSONArray getTaskRoleDataByXzqdm(String taskId, Integer level) {
        JSONArray jsonArray = new JSONArray();
        String findSql = "select p.xzqdm,p.role,count(1) from(\n--\u4f5c\u4e1a\u5458\nselect b.f_role  as role ,a.f_userid userId,a.f_xzqdm xzqdm,count(1) from tbsys_user_biz2 b,tbtsk_right_area a where a.f_userid=cast(b.f_userid as varchar(12)) and\n a.f_taskid= b.f_bizid and b.f_bizid ='" + taskId + "' and b.f_role='3' GROUP BY b.f_role,a.f_userid,a.f_xzqdm \n union all\n --\u7ba1\u7406\u5458\n select b.f_role  as role,a.f_userid userId,a.f_regioncode xzqdm,count(1) from tbsys_user_biz2 b,tbtsk_user_manage_area a where a.f_userid=cast(b.f_userid as varchar(12)) and\n a.f_taskid= b.f_bizid and b.f_bizid ='" + taskId + "' and b.f_role='1' GROUP BY b.f_role,a.f_userid,a.f_regioncode \n  union all\n --\u5ba1\u6838\u5458\n  select b.f_role  as role,a.f_userid userId,a.f_regioncode xzqdm,count(1) from tbsys_user_biz2 b,tbtsk_user_manage_area a where a.f_userid=cast(b.f_userid as varchar(12)) and\n a.f_taskid= b.f_bizid and b.f_bizid ='" + taskId + "' and and b.f_role='2' GROUP BY b.f_role,a.f_userid,a.f_regioncode \n  union all\n --\u590d\u6838\u5458\n   select b.f_role  as role,a.f_userid userId,a.f_regioncode xzqdm,count(1) from tbsys_user_biz2 b,tbtsk_user_manage_area a where a.f_userid=cast(b.f_userid as varchar(12)) and\n a.f_taskid= b.f_bizid and b.f_bizid ='" + taskId + "' and b.f_role='4' GROUP BY b.f_role,a.f_userid,a.f_regioncode ) p group by p.xzqdm,p.role ";
        List maps = this.jdbcTemplate.queryForList(findSql);
        if (CollectionUtils.isNotEmpty((Collection)maps)) {
            for (Map map : maps) {
                if (jsonArray.size() > 0) {
                    for (Object o : jsonArray) {
                        JSONObject jsonObject = JSONObject.parseObject((String)o.toString());
                        if (jsonObject.getString("xzqdm").equals(map.get("xzqdm").toString())) {
                            jsonObject.put("count", (Object)(jsonObject.getInteger("count") + Integer.valueOf(map.get("count").toString())));
                            continue;
                        }
                        JSONObject object = new JSONObject();
                        object.put("xzqdm", (Object)map.get("xzqdm").toString());
                        object.put("regionName", (Object)this.regionService.getFullName(map.get("xzqdm").toString()));
                        object.put("role", (Object)Integer.valueOf(map.get("role").toString()));
                        object.put("count", (Object)Integer.valueOf(map.get("count").toString()));
                        jsonArray.add((Object)object);
                    }
                    continue;
                }
                JSONObject object = new JSONObject();
                object.put("xzqdm", (Object)map.get("xzqdm").toString());
                object.put("regionName", (Object)this.regionService.getFullName(map.get("xzqdm").toString()));
                object.put("role", (Object)Integer.valueOf(map.get("role").toString()));
                object.put("count", (Object)Integer.valueOf(map.get("count").toString()));
                jsonArray.add((Object)object);
            }
        }
        return jsonArray;
    }

    public JSONArray getTaskOverallDataByXzqdm(String taskId, Integer granularity, String startTime, String endTime) {
        JSONArray jsonArray = new JSONArray();
        TskTaskBiz taskBiz = this.tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableInfo = this.tbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
        String findSql = "select substring(f_xzqdmsys,0,10) xzqdm,f_status,f_review_stage,count(1) from " + tableInfo.getfTablename() + " group by substring(f_xzqdmsys,0,10),f_status,f_review_stage;";
        List maps = this.jdbcTemplate.queryForList(findSql);
        if (CollectionUtils.isNotEmpty((Collection)maps)) {
            for (Map map : maps) {
                if (jsonArray.size() > 0) {
                    for (Object o : jsonArray) {
                        JSONObject jsonObject = JSONObject.parseObject((String)o.toString());
                        if (jsonObject.getString("xzqdm").equals(map.get("xzqdm").toString())) {
                            if ("101".equals(map.get("f_review_stage").toString())) {
                                jsonObject.put("assignCount", (Object)(jsonObject.getInteger("assignCount") + Integer.valueOf(map.get("count").toString())));
                                jsonObject.put("submitCount", (Object)(jsonObject.getInteger("submitCount") + Integer.valueOf(map.get("count").toString())));
                                jsonObject.put("submissionCount", (Object)(jsonObject.getInteger("submissionCount") + Integer.valueOf(map.get("count").toString())));
                                jsonObject.put("completeCount", (Object)(jsonObject.getInteger("completeCount") + Integer.valueOf(map.get("count").toString())));
                                continue;
                            }
                            if (Integer.valueOf(map.get("f_status").toString()) >= 2) {
                                jsonObject.put("assignCount", (Object)(jsonObject.getInteger("assignCount") + Integer.valueOf(map.get("count").toString())));
                                continue;
                            }
                            if (Integer.valueOf(map.get("f_status").toString()) >= 4) {
                                jsonObject.put("assignCount", (Object)(jsonObject.getInteger("assignCount") + Integer.valueOf(map.get("count").toString())));
                                jsonObject.put("submitCount", (Object)(jsonObject.getInteger("submitCount") + Integer.valueOf(map.get("count").toString())));
                                continue;
                            }
                            if (Integer.valueOf(map.get("f_status").toString()) < 10) continue;
                            jsonObject.put("assignCount", (Object)(jsonObject.getInteger("assignCount") + Integer.valueOf(map.get("count").toString())));
                            jsonObject.put("submitCount", (Object)(jsonObject.getInteger("submitCount") + Integer.valueOf(map.get("count").toString())));
                            jsonObject.put("submissionCount", (Object)(jsonObject.getInteger("submissionCount") + Integer.valueOf(map.get("count").toString())));
                            continue;
                        }
                        JSONObject object = new JSONObject();
                        Integer assignCount = 0;
                        Integer submitCount = 0;
                        Integer submissionCount = 0;
                        Integer completeCount = 0;
                        object.put("xzqdm", (Object)map.get("xzqdm").toString());
                        object.put("regionName", (Object)this.regionService.getFullName(map.get("xzqdm").toString()));
                        if ("101".equals(map.get("f_review_stage").toString())) {
                            assignCount = Integer.valueOf(map.get("count").toString());
                            submitCount = Integer.valueOf(map.get("count").toString());
                            submissionCount = Integer.valueOf(map.get("count").toString());
                            completeCount = Integer.valueOf(map.get("count").toString());
                        } else if (Integer.valueOf(map.get("f_status").toString()) >= 2) {
                            assignCount = Integer.valueOf(map.get("count").toString());
                        } else if (Integer.valueOf(map.get("f_status").toString()) >= 4) {
                            assignCount = Integer.valueOf(map.get("count").toString());
                            submitCount = Integer.valueOf(map.get("count").toString());
                        } else if (Integer.valueOf(map.get("f_status").toString()) >= 10) {
                            assignCount = Integer.valueOf(map.get("count").toString());
                            submitCount = Integer.valueOf(map.get("count").toString());
                            submissionCount = Integer.valueOf(map.get("count").toString());
                        }
                        object.put("assignCount", (Object)assignCount);
                        object.put("submitCount", (Object)submitCount);
                        object.put("submissionCount", (Object)submissionCount);
                        object.put("completeCount", (Object)completeCount);
                        jsonArray.add((Object)object);
                    }
                    continue;
                }
                JSONObject object = new JSONObject();
                Integer assignCount = 0;
                Integer submitCount = 0;
                Integer submissionCount = 0;
                Integer completeCount = 0;
                object.put("xzqdm", (Object)map.get("xzqdm").toString());
                object.put("regionName", (Object)this.regionService.getFullName(map.get("xzqdm").toString()));
                if ("101".equals(map.get("f_review_stage").toString())) {
                    assignCount = Integer.valueOf(map.get("count").toString());
                    submitCount = Integer.valueOf(map.get("count").toString());
                    submissionCount = Integer.valueOf(map.get("count").toString());
                    completeCount = Integer.valueOf(map.get("count").toString());
                } else if (Integer.valueOf(map.get("f_status").toString()) >= 2) {
                    assignCount = Integer.valueOf(map.get("count").toString());
                } else if (Integer.valueOf(map.get("f_status").toString()) >= 4) {
                    assignCount = Integer.valueOf(map.get("count").toString());
                    submitCount = Integer.valueOf(map.get("count").toString());
                } else if (Integer.valueOf(map.get("f_status").toString()) >= 10) {
                    assignCount = Integer.valueOf(map.get("count").toString());
                    submitCount = Integer.valueOf(map.get("count").toString());
                    submissionCount = Integer.valueOf(map.get("count").toString());
                }
                object.put("assignCount", (Object)assignCount);
                object.put("submitCount", (Object)submitCount);
                object.put("submissionCount", (Object)submissionCount);
                object.put("completeCount", (Object)completeCount);
                jsonArray.add((Object)object);
            }
        }
        return jsonArray;
    }

    public static boolean testYear(Date date, Date date2) {
        boolean result = false;
        if (date2.getTime() / 1000L - date.getTime() / 1000L > 31536000L) {
            result = true;
        }
        return result;
    }

    public static boolean testMonth(Calendar start, Calendar end) {
        boolean result = false;
        int subMonthCount = end.get(1) - start.get(1) == 0 ? end.get(2) - start.get(2) : (end.get(1) - start.get(1) >= 2 ? (end.get(1) - start.get(1) - 1) * 12 + start.getActualMaximum(2) - start.get(2) + end.get(2) + 1 : start.getActualMaximum(2) - start.get(2) + end.get(2) + 1);
        result = subMonthCount >= 1;
        return result;
    }

    public List<String> getMonth(String startTime, String endTime) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Date startDate = new SimpleDateFormat("yyyy-MM").parse(startTime);
            Date endDate = new SimpleDateFormat("yyyy-MM").parse(endTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            int startYear = calendar.get(1);
            int startMonth = calendar.get(2);
            calendar.setTime(endDate);
            int endYear = calendar.get(1);
            int endMonth = calendar.get(2);
            for (int i = startYear; i <= endYear; ++i) {
                int j;
                String date = "";
                if (startYear == endYear) {
                    for (j = startMonth; j <= endMonth; ++j) {
                        date = j < 9 ? i + "-0" + (j + 1) : i + "-" + (j + 1);
                        list.add(date);
                    }
                    continue;
                }
                if (i == startYear) {
                    for (j = startMonth; j < 12; ++j) {
                        date = j < 9 ? i + "-0" + (j + 1) : i + "-" + (j + 1);
                        list.add(date);
                    }
                    continue;
                }
                if (i == endYear) {
                    for (j = 0; j <= endMonth; ++j) {
                        date = j < 9 ? i + "-0" + (j + 1) : i + "-" + (j + 1);
                        list.add(date);
                    }
                    continue;
                }
                for (j = 0; j < 12; ++j) {
                    date = j < 9 ? i + "-0" + (j + 1) : i + "-" + (j + 1);
                    list.add(date);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

