/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.entity.SyncLog;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.pub.SyncLogRepository;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.base.AppBasicService;
import com.geoway.landteam.landcloud.service.user.MLandUserService;
import com.geoway.landteam.landcloud.service.util.RedisSessionUtils;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
@Transactional(rollbackFor={Exception.class})
public class MSyncLogService {
    private final GiLoger logger = GwLoger.getLoger(MSyncLogService.class);
    @Autowired
    SyncLogRepository syncLogRepository;
    @Autowired
    AppBasicService appBasicService;
    @Autowired
    AppMediaRepository appMediaRepository;
    protected String uploadDir;
    @Autowired
    MLandUserService landUserService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Transactional(rollbackFor={Exception.class})
    public boolean syncData(HttpServletRequest request, String ids) {
        block30: {
            LandUser landUser;
            Long userid;
            Connection connection;
            File tempUploadFile;
            block29: {
                boolean isMultipart;
                tempUploadFile = null;
                connection = null;
                userid = RedisSessionUtils.checkWebLogin(request);
                landUser = this.landUserService.queryUserById(userid);
                if (StringUtils.isNotBlank((CharSequence)ids)) {
                    List<String> idList = Arrays.asList(ids.split(","));
                    this.syncLogRepository.updateSyncLog(Integer.valueOf(2), idList);
                }
                if (isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request)) break block29;
                boolean bl = true;
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    if (tempUploadFile != null) {
                        tempUploadFile.delete();
                    }
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage(), new Object[]{ex});
                }
                return bl;
            }
            MultipartFile fileOfDB = ((MultipartHttpServletRequest)request).getFile("file");
            tempUploadFile = this.buildTempUploadFile();
            FileUtils.copyInputStreamToFile((InputStream)fileOfDB.getInputStream(), (File)tempUploadFile);
            SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
            connection = connPool.getConnection();
            Statement statement = connection.createStatement();
            String tableName = "operrecord";
            boolean isExists = this.isTableExists(statement, tableName);
            if (!isExists) {
                throw new RuntimeException("\u540c\u6b65\u6587\u4ef6\u51fa\u9519\uff0c\u4e0d\u5b58\u5728\u8868[operrecord]");
            }
            ResultSet rs = null;
            String querysql = "select * from " + tableName;
            rs = statement.executeQuery(querysql);
            ArrayList<AppBasic> appBasicList = new ArrayList<AppBasic>();
            ArrayList<String> appBasicDelList = new ArrayList<String>();
            ArrayList<AppMedia> appMediaList = new ArrayList<AppMedia>();
            ArrayList<String> appMediaDelList = new ArrayList<String>();
            ArrayList<SyncLog> appSyncLogList = new ArrayList<SyncLog>();
            while (rs.next()) {
                SyncLog syncLogApp = this.getSyncLog(rs);
                if (syncLogApp == null) continue;
                syncLogApp.setOptuserid(userid);
                syncLogApp.setState(Integer.valueOf(2));
                appSyncLogList.add(syncLogApp);
                if (syncLogApp.getObjtype() == 1) {
                    if (syncLogApp.getOpttype() == 1 || syncLogApp.getOpttype() == 2) {
                        AppBasic appBasic = this.getAppBasic(syncLogApp.getData());
                        appBasic.setIsDeleted(Integer.valueOf(0));
                        appBasic.setUserid(String.valueOf(userid));
                        appBasic.setUsername(landUser.getName());
                        appBasicList.add(appBasic);
                        continue;
                    }
                    if (syncLogApp.getOpttype() != 3) continue;
                    appBasicDelList.add(syncLogApp.getObjid());
                    continue;
                }
                if (syncLogApp.getObjtype() != 3) continue;
                if (syncLogApp.getOpttype() == 1 || syncLogApp.getOpttype() == 2) {
                    AppMedia appMedia = this.getAppMedia(syncLogApp.getData());
                    appMedia.setUsername(landUser.getName());
                    appMediaList.add(appMedia);
                    continue;
                }
                if (syncLogApp.getOpttype() != 3) continue;
                appMediaDelList.add(syncLogApp.getObjid());
            }
            this.appBasicService.saveAll(appBasicList);
            if (appBasicDelList != null && appBasicDelList.size() > 0) {
                this.appBasicService.deleteByIds(appBasicDelList);
            }
            this.appMediaRepository.saveAll(appMediaList);
            if (appMediaDelList != null && appMediaDelList.size() > 0) {
                this.appMediaRepository.deleteByIds(appMediaDelList);
            }
            this.syncLogRepository.saveAll(appSyncLogList);
            connPool.closeAll(connection, statement, rs);
            connection.close();
            tempUploadFile.delete();
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
                if (tempUploadFile != null) {
                    tempUploadFile.delete();
                }
                break block30;
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage(), new Object[]{ex});
            }
            break block30;
            catch (Exception ex) {
                boolean bl;
                try {
                    this.logger.error("syncData:" + ex.getMessage(), new Object[0]);
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null && !connection.isClosed()) {
                            connection.close();
                        }
                        if (tempUploadFile != null) {
                            tempUploadFile.delete();
                        }
                    }
                    catch (Exception ex2) {
                        this.logger.error(ex2.getMessage(), new Object[]{ex2});
                    }
                    throw throwable;
                }
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    if (tempUploadFile != null) {
                        tempUploadFile.delete();
                    }
                }
                catch (Exception ex3) {
                    this.logger.error(ex3.getMessage(), new Object[]{ex3});
                }
                return bl;
            }
        }
        return true;
    }

    public List<SyncLog> queryByFilter(String filterParam, String sortParam) {
        ArrayList<SyncLog> result = new ArrayList();
        try {
            result = this.syncLogRepository.findAll((Specification)new QuerySpecification(filterParam), QueryParamUtil.parseSortParams((String)sortParam));
        }
        catch (Exception ex) {
            this.logger.error("queryByFilter:" + ex.getMessage(), new Object[0]);
        }
        return result;
    }

    private boolean isTableExists(Statement statement, String tableName) throws SQLException {
        String sql = String.format("select count(1) from sqlite_master where type = 'table' and name = '%s'", tableName);
        ResultSet rs = statement.executeQuery(sql);
        int iResult = 0;
        while (rs.next()) {
            iResult = rs.getInt(1);
        }
        return iResult > 0;
    }

    private File buildTempUploadFile() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        String fileName = String.format("%s-%s.db", sdf.format(new Date()), UUID.randomUUID().toString());
        return new File(this.uploadDir, fileName);
    }

    private SyncLog getSyncLog(ResultSet rs) {
        SyncLog syncLog = null;
        try {
            syncLog = new SyncLog();
            syncLog.setId(rs.getString("f_id"));
            syncLog.setObjtype(Integer.valueOf(rs.getInt("f_objtype")));
            syncLog.setObjid(rs.getString("f_objid"));
            syncLog.setParentobjid(rs.getString("f_parentobjid"));
            syncLog.setOpttime(this.stampToDate(rs.getString("f_opttime")));
            syncLog.setOptori(Integer.valueOf(rs.getInt("f_optori")));
            syncLog.setOpttype(Integer.valueOf(rs.getInt("f_opttype")));
            syncLog.setData(rs.getString("f_data"));
        }
        catch (Exception ex) {
            this.logger.error("getSyncLog:" + ex.getMessage(), new Object[0]);
        }
        return syncLog;
    }

    private AppBasic getAppBasic(String json) {
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        AppBasic appBasic = new AppBasic();
        appBasic.setId(jsonObject.getString("f_id"));
        appBasic.setName(jsonObject.getString("f_name"));
        appBasic.setCreatetime(jsonObject.getString("f_createtime"));
        appBasic.setTime(this.stampToDate(jsonObject.getString("f_createtime")));
        appBasic.setType(jsonObject.getString("f_type"));
        appBasic.setDesc(jsonObject.getString("f_desc"));
        appBasic.setShape(jsonObject.getString("f_shape"));
        appBasic.setLon(jsonObject.getDouble("f_lon"));
        appBasic.setLat(jsonObject.getDouble("f_lat"));
        try {
            appBasic.setMj(jsonObject.getDouble("f_mj"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        appBasic.setOri(jsonObject.getString("f_gallery_type"));
        appBasic.setCloudId(jsonObject.getString("f_cloudId"));
        appBasic.setVipCloudId(jsonObject.getString("f_vipCloudId"));
        appBasic.setMyCloudId(jsonObject.getString("f_webCloudId"));
        appBasic.setHeading(jsonObject.getString("f_GalleryName"));
        appBasic.setRequestId(jsonObject.getString("f_requestid"));
        return appBasic;
    }

    private AppMedia getAppMedia(String json) {
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        AppMedia appMedia = new AppMedia();
        appMedia.setId(jsonObject.getString("f_id"));
        appMedia.setGalleryid(jsonObject.getString("f_galleryid"));
        appMedia.setAzimuth(jsonObject.getString("f_azimuth"));
        appMedia.setDownloadUrl(jsonObject.getString("f_downloadurl"));
        appMedia.setFileId(jsonObject.getString("f_fileid"));
        appMedia.setLat(jsonObject.getDouble("f_lat"));
        appMedia.setLon(jsonObject.getDouble("f_lon"));
        appMedia.setMediasize(jsonObject.getDouble("f_mediasize"));
        appMedia.setMediatimelength(jsonObject.getInteger("f_mediatimelength"));
        appMedia.setPitch(jsonObject.getString("f_pitch"));
        appMedia.setServerpath(jsonObject.getString("f_serverpath"));
        appMedia.setShape(jsonObject.getString("f_shape"));
        String time = jsonObject.getString("f_time");
        if (StringUtils.isNotBlank((CharSequence)time)) {
            Long timeLong = null;
            try {
                timeLong = Long.valueOf(time);
            }
            catch (NumberFormatException e) {
                try {
                    Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time);
                    timeLong = date.getTime();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (timeLong != null) {
                appMedia.setTime(String.valueOf(timeLong));
            }
        }
        appMedia.setType(jsonObject.getInteger("f_type"));
        appMedia.setVideorecord(jsonObject.getString("f_videorecord"));
        appMedia.setMark(Integer.valueOf(jsonObject.get((Object)"mark") == null ? 0 : jsonObject.getInteger("mark")));
        appMedia.setTypetype(Integer.valueOf(jsonObject.get((Object)"typetype") == null ? 0 : jsonObject.getInteger("typetype")));
        appMedia.setDeviceSource(Integer.valueOf(0));
        return appMedia;
    }

    private Date stampToDate(String s) {
        long lt = new Long(s);
        Date date = new Date(lt);
        return date;
    }
}

