/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.http.HttpsUtil;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PDFService {
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    private final Map<String, String> errInfo = new HashMap<String, String>();

    public PDFService() {
        this.errInfo.put("photo", "\u65e0\u73b0\u573a\u7167\u7247");
        this.errInfo.put("image_Analyze", "\u67e5\u8be2\u8303\u56f4\u5185\u65e0\u5f53\u5e74\u5f71\u50cf\u4fe1\u606f");
        this.errInfo.put("landType_Analyze", "\u67e5\u8be2\u8303\u56f4\u5185\u65e0\u5f53\u5e74\u73b0\u72b6\u4fe1\u606f");
        this.errInfo.put("ownership_Analyze", "\u67e5\u8be2\u8303\u56f4\u65e0\u6743\u5c5e\u5173\u7cfb\u4fe1\u606f");
        this.errInfo.put("plan_Analyze", "\u67e5\u8be2\u8303\u56f4\u5185\u65e0\u57fa\u672c\u571f\u5730\u89c4\u5212\u4fe1\u606f");
        this.errInfo.put("landGrade_Analyze", "\u67e5\u8be2\u8303\u56f4\u5185\u65e0\u8015\u5730\u7b49\u522b\u4fe1\u606f");
        this.errInfo.put("primeFarm_Analyze", "\u67e5\u8be2\u8303\u56f4\u5185\u4e0d\u6d89\u53ca\u6c38\u4e45\u57fa\u672c\u519c\u7530");
        this.errInfo.put("spba_Analyze", "\u67e5\u8be2\u8303\u56f4\u5185\u65e0\u5ba1\u6279\u5907\u6848\u4fe1\u606f");
        this.errInfo.put("natureReserve_Analyze", "\u67e5\u8be2\u8303\u56f4\u5185\u4e0d\u6d89\u53ca\u81ea\u7136\u4fdd\u62a4\u533a");
        this.errInfo.put("jsydgmbj_Analyze", "\u67e5\u8be2\u8303\u56f4\u5185\u4e0d\u6d89\u53ca\u5efa\u8bbe\u7528\u5730\u8fb9\u754c");
        this.errInfo.put("cxydgh_Analyze", "\u67e5\u8be2\u8303\u56f4\u5185\u4e0d\u6d89\u53ca\u57ce\u4e61\u89c4\u5212");
        this.errInfo.put("gqzrbhq_Analyze", "\u67e5\u8be2\u8303\u56f4\u5185\u4e0d\u6d89\u53ca\u4fdd\u62a4\u533a(\u56fd\u60c5)");
        this.errInfo.put("keyArea_Analyze", "\u67e5\u8be2\u8303\u56f4\u5185\u4e0d\u6d89\u53ca\u4fdd\u62a4\u533a(\u62a5\u5907)");
    }

    public PdfPCell getImageCell(Integer columnwidth, Integer minColumnHeight, byte[] imgb, Boolean isBorder) {
        try {
            if (imgb == null) {
                return null;
            }
            Image image = Image.getInstance((byte[])imgb);
            if (null != minColumnHeight && columnwidth != null) {
                image.scaleToFit((float)(columnwidth * 4 - 5), (float)(minColumnHeight - 5));
            }
            PdfPCell vcell = new PdfPCell(image);
            vcell.setHorizontalAlignment(1);
            vcell.setVerticalAlignment(5);
            if (!isBorder.booleanValue()) {
                vcell.setBorder(0);
            }
            if (null != minColumnHeight) {
                vcell.setMinimumHeight((float)minColumnHeight.intValue());
            }
            return vcell;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public PdfPCell getPDFCell(Font font, Integer columnHeight, String cellValue, Boolean isBorder, int align) {
        PdfPCell dcell = new PdfPCell(new Phrase(cellValue, font));
        dcell.setHorizontalAlignment(align);
        dcell.setVerticalAlignment(5);
        if (!isBorder.booleanValue()) {
            dcell.setBorder(0);
        }
        dcell.setMinimumHeight((float)columnHeight.intValue());
        return dcell;
    }

    public String getCellValue(JSONObject jsonObject, String template, String format) {
        String val = "";
        try {
            List<String> extraValue = this.getExtraValue(template);
            for (int i = 0; i < extraValue.size(); ++i) {
                Object o = this.getJSONValue(jsonObject, extraValue.get(i));
                if (o == null) {
                    template = template.replace("{" + extraValue.get(i) + "}", "");
                    continue;
                }
                String valStr = o.toString();
                if (StringUtils.isNotEmpty((CharSequence)format)) {
                    Double valDouble = Double.valueOf(valStr);
                    DecimalFormat decimalFormat = new DecimalFormat(format);
                    valStr = decimalFormat.format(valDouble);
                }
                template = template.replace("{" + extraValue.get(i) + "}", valStr);
            }
        }
        catch (Exception e) {
            return "";
        }
        return template;
    }

    public String getCellValue(JSONObject jsonObject, String template) {
        return this.getCellValue(jsonObject, template, null);
    }

    private Object getJSONValue(JSONObject jsonObject, String template) {
        try {
            if (jsonObject == null) {
                return null;
            }
            String[] arr = template.split("\\.");
            if (arr.length < 2) {
                return jsonObject.getString(template);
            }
            int j = 0;
            if (j < arr.length - 1) {
                if (arr[j].contains("[")) {
                    String key = arr[j].substring(0, arr[j].indexOf("["));
                    JSONArray jsonArray = jsonObject.getJSONArray(key);
                    Integer index = Integer.valueOf(this.getExtraValue1(template).get(0));
                    JSONObject temp = jsonArray.getJSONObject(index.intValue());
                    if ((template = template.substring(arr[j].length())).startsWith(".")) {
                        template = template.substring(1);
                    }
                    return this.getJSONValue(temp, template);
                }
                if (j == arr.length - 1) {
                    return this.getJSONValue(jsonObject, arr[j]);
                }
                JSONObject temp = jsonObject.getJSONObject(arr[j]);
                if ((template = template.substring(arr[j].length())).startsWith(".")) {
                    template = template.substring(1);
                }
                return this.getJSONValue(temp, template);
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    public List<String> getExtraValue(String value) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            Pattern p = Pattern.compile("(?<=\\{)(.+?)(?=\\})");
            Matcher m = p.matcher(value);
            while (m.find()) {
                list.add(m.group());
            }
            return list;
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<String> getExtraValue1(String value) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern p = Pattern.compile("(?<=\\[)(.+?)(?=\\])");
        Matcher m = p.matcher(value);
        while (m.find()) {
            list.add(m.group());
        }
        return list;
    }

    public PdfPTable getImageTable(JSONObject result, JSONObject object, Font font, Font imgTitleFont, Font kai, Integer width) {
        int[] widths = new int[]{width};
        PdfPTable imgTable = new PdfPTable(1);
        JSONObject title = object.getJSONObject("title");
        String titleVal = title.getString("value");
        Integer titleHt = title.getInteger("height");
        JSONObject img = object.getJSONObject("img");
        Integer imgHeight = img.getInteger("height");
        String mode = object.getString("mode");
        byte[] bytes = null;
        try {
            imgTable.setWidths(widths);
            if (StringUtils.isNotEmpty((CharSequence)titleVal)) {
                PdfPCell titleCell = this.getPDFCell(imgTitleFont, titleHt, titleVal, false, 1);
                titleCell.setBorder(2);
                titleCell.setBorderWidth(0.5f);
                titleCell.setBorderColor(BaseColor.LIGHT_GRAY);
                imgTable.addCell(titleCell);
            }
            String url = this.parseImgUrl(mode, result, object);
            String year = "";
            if ("image_Analyze".equalsIgnoreCase(mode)) {
                year = url.split(",")[1];
                url = url.split(",")[0];
            }
            if (!url.contains("obs.cn") || !url.contains("AWSAccessKeyId")) {
                // empty if block
            }
            bytes = HttpsUtil.httpRequest((String)url, (String)"GET", (String)"");
            Image image = Image.getInstance((byte[])bytes);
            if (null != imgHeight && null != width) {
                image.scaleToFit((float)width.intValue() * 4.5f - 3.0f, (float)(imgHeight - 3));
            }
            PdfPCell imgCell = new PdfPCell(image);
            imgCell.setHorizontalAlignment(1);
            imgCell.setVerticalAlignment(5);
            imgCell.setBorder(0);
            imgCell.setPadding(0.0f);
            if (null != imgHeight) {
                imgCell.setMinimumHeight((float)imgHeight.intValue());
            }
            imgTable.addCell(imgCell);
            JSONObject attr = object.getJSONObject("attr");
            if (attr != null && attr.getBoolean("show").booleanValue()) {
                String key = attr.getString("key");
                String desc = "";
                if ("photo".equals(mode)) {
                    JSONObject basic = result.getJSONObject("basic");
                    desc = this.parseAttr(basic, key);
                } else {
                    String yearTmp = "";
                    yearTmp = "image_Analyze".equalsIgnoreCase(mode) ? year : object.getJSONObject("img").getString("url");
                    JSONObject detail = result.getJSONObject("detail");
                    desc = this.parseAttr(detail, mode, key, yearTmp);
                }
                PdfPCell descCell = this.getPDFCell(kai, 18, desc, false, 1);
                descCell.setBorder(1);
                descCell.setBorderColor(BaseColor.LIGHT_GRAY);
                descCell.setBorderWidth(0.5f);
                imgTable.addCell(descCell);
            }
        }
        catch (Exception e) {
            String msg = this.errInfo.get(mode);
            PdfPCell noResult = this.getPDFCell(font, imgHeight, msg, false, 1);
            imgTable.addCell(noResult);
        }
        return imgTable;
    }

    private String parseImgUrl(String mode, JSONObject result, JSONObject object) {
        String urlStr = object.getJSONObject("img").getString("url");
        if (StringUtils.isEmpty((CharSequence)urlStr)) {
            throw new RuntimeException("url\u4e3a\u7a7a");
        }
        String imgUrl = urlStr;
        String imgMode = object.getJSONObject("img").getString("yearMode");
        switch (mode) {
            case "photo": {
                JSONObject photo;
                JSONArray jsonArray = result.getJSONObject("basic").getJSONArray("list");
                jsonArray = "task".equalsIgnoreCase(object.getString("target")) ? result.getJSONObject("basic").getJSONObject("prj").getJSONObject("tb").getJSONArray("list") : result.getJSONObject("basic").getJSONArray("list");
                Integer index = Integer.valueOf(urlStr);
                Integer fromIndex = -1;
                JSONObject photoObject = null;
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject obj = jsonArray.getJSONObject(i);
                    if (obj.getInteger("type") != 1) continue;
                    Integer n = fromIndex;
                    Integer n2 = fromIndex = Integer.valueOf(fromIndex + 1);
                    if (!fromIndex.equals(index)) continue;
                    photoObject = obj;
                    break;
                }
                if (StringUtils.isNotEmpty((CharSequence)(photo = photoObject).getString("downloadUrl"))) {
                    imgUrl = photo.getString("downloadUrl");
                    break;
                }
                if (StringUtils.isNotEmpty((CharSequence)photo.getString("serverpath"))) {
                    imgUrl = photo.getString("serverpath");
                    break;
                }
                imgUrl = "";
                break;
            }
            case "landType_Analyze": {
                boolean match = false;
                JSONArray history = result.getJSONObject("detail").getJSONArray(mode + "_History");
                for (int i = 0; i < history.size(); ++i) {
                    JSONObject landType = history.getJSONObject(i);
                    String date = landType.getString("date");
                    if (!date.startsWith(urlStr)) continue;
                    imgUrl = landType.getString("images");
                    match = true;
                    break;
                }
                if (match) break;
                imgUrl = this.getCellValue(result, urlStr);
                break;
            }
            case "image_Analyze": {
                JSONArray history = result.getJSONObject("detail").getJSONArray(mode + "_History");
                int lastYear = 0;
                for (int i = 0; i < history.size(); ++i) {
                    JSONObject landType = history.getJSONObject(i);
                    String date = landType.getString("date");
                    int year = Integer.parseInt(date.substring(0, 4));
                    if ("maxYear".equalsIgnoreCase(imgMode)) {
                        if (year <= lastYear) continue;
                        lastYear = year;
                        imgUrl = landType.getString("images") + "," + lastYear;
                        continue;
                    }
                    if (!String.valueOf(year).equalsIgnoreCase(imgUrl)) continue;
                    imgUrl = landType.getString("images") + "," + year;
                }
                break;
            }
            case "cxydgh_Analyze": {
                if (urlStr.contains("Cxydgh_Analyze")) {
                    imgUrl = this.getCellValue(result, urlStr.replace("Cxydgh_Analyze", "cxydgh_Analyze"));
                    break;
                }
                imgUrl = this.getCellValue(result, urlStr);
                break;
            }
            case "jsydgmbj_Analyze": {
                if (urlStr.contains("Jsydgmbj_Analyze")) {
                    imgUrl = this.getCellValue(result, urlStr.replace("Jsydgmbj_Analyze", "jsydgmbj_Analyze"));
                    break;
                }
                imgUrl = this.getCellValue(result, urlStr);
                break;
            }
            case "keyArea_Analyze": {
                if (urlStr.contains("KeyArea_Analyze")) {
                    imgUrl = this.getCellValue(result, urlStr.replace("KeyArea_Analyze", "keyArea_Analyze"));
                    break;
                }
                imgUrl = this.getCellValue(result, urlStr);
                break;
            }
            default: {
                imgUrl = this.getCellValue(result, urlStr);
            }
        }
        UrlValidator urlValidator = new UrlValidator();
        if (urlValidator.isValid(imgUrl)) {
            return imgUrl;
        }
        throw new RuntimeException("\u56fe\u7247url\u4e0d\u5408\u6cd5");
    }

    private String parseAttr(JSONObject detail, String mode, String key, String sj) {
        String result = "";
        JSONObject modeDetail = detail.getJSONObject(mode);
        JSONArray attrs = modeDetail.getJSONArray("attributes");
        JSONObject base = detail.getJSONObject("data");
        switch (mode) {
            case "image_Analyze": {
                JSONArray imgAttrs = detail.getJSONArray("image_Analyze_History");
                JSONObject attr = new JSONObject();
                for (int i = 0; i < imgAttrs.size(); ++i) {
                    if (!imgAttrs.getJSONObject(i).getString("date").startsWith(sj)) continue;
                    attr = imgAttrs.getJSONObject(i).getJSONArray("attributes").getJSONObject(0);
                    break;
                }
                String sjy = attr.getString("sjy");
                String sx = attr.getString("sx");
                String year = sx.substring(0, 4);
                String month = sx.substring(4, 6);
                String day = sx.substring(6, 8);
                result = String.format("\u536b\u661f\uff1a%s   \u65e5\u671f\uff1a%s-%s-%s", sjy, year, month, day);
                break;
            }
            case "landType_Analyze": {
                JSONArray landTypeAttrs = detail.getJSONArray("landType_Analyze_History");
                for (int i = 0; i < landTypeAttrs.size(); ++i) {
                    if (!landTypeAttrs.getJSONObject(i).getString("date").startsWith(sj)) continue;
                    attrs = landTypeAttrs.getJSONObject(i).getJSONArray("attributes");
                    break;
                }
                float max1 = 0.0f;
                float max2 = 0.0f;
                float total = 0.0f;
                String max1Code = "";
                String max2Code = "";
                ArrayList<String> codes = new ArrayList<String>();
                for (int i = 0; i < attrs.size(); ++i) {
                    JSONObject attr = attrs.getJSONObject(i);
                    Float mj = attr.getFloat("mj");
                    String code = attr.getString(key);
                    codes.add(code);
                    total += mj.floatValue();
                    if (mj.floatValue() > max1) {
                        max2 = max1;
                        max2Code = max1Code;
                        max1 = mj.floatValue();
                        max1Code = code;
                        continue;
                    }
                    if (!(mj.floatValue() >= max2)) continue;
                    max2 = mj.floatValue();
                    max2Code = code;
                }
                float other = total - max1 - max2;
                codes.remove(max1Code);
                codes.remove(max2Code);
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                String max1Str = decimalFormat.format(max1);
                String max2Str = decimalFormat.format(max2);
                String otherStr = decimalFormat.format(other);
                if (max2 <= 0.0f) {
                    result = String.format("%s-%s\u4ea9", max1Code, decimalFormat.format(max1));
                    break;
                }
                if (codes.size() == 0) {
                    result = String.format("%s-%s\u4ea9/%s-%s\u4ea9", max1Code, max1Str, max2Code, max2Str);
                    break;
                }
                if (codes.size() == 1) {
                    result = String.format("%s-%s\u4ea9/%s-%s\u4ea9/%s-%s\u4ea9", max1Code, max1Str, max2Code, max2Str, codes.get(0), otherStr);
                    break;
                }
                result = String.format("%s-%s\u4ea9/%s-%s\u4ea9/\u5176\u4ed6-%s\u4ea9", max1Code, max1Str, max2Code, max2Str, otherStr);
                break;
            }
            case "landGrade_Analyze": 
            case "plan_Analyze": 
            case "ownership_Analyze": {
                float max1 = 0.0f;
                float max2 = 0.0f;
                float total = 0.0f;
                String max1Code = "";
                String max2Code = "";
                ArrayList<String> codes = new ArrayList<String>();
                for (int i = 0; i < attrs.size(); ++i) {
                    JSONObject attr = attrs.getJSONObject(i);
                    Float mj = attr.getFloat("mj");
                    String code = attr.getString(key);
                    codes.add(code);
                    total += mj.floatValue();
                    if (mj.floatValue() > max1) {
                        max2 = max1;
                        max2Code = max1Code;
                        max1 = mj.floatValue();
                        max1Code = code;
                        continue;
                    }
                    if (!(mj.floatValue() >= max2)) continue;
                    max2 = mj.floatValue();
                    max2Code = code;
                }
                float other = total - max1 - max2;
                codes.remove(max1Code);
                codes.remove(max2Code);
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                String max1Str = decimalFormat.format(max1);
                String max2Str = decimalFormat.format(max2);
                String otherStr = decimalFormat.format(other);
                if (max2 <= 0.0f) {
                    result = String.format("%s-%s\u4ea9", max1Code, decimalFormat.format(max1));
                    break;
                }
                if (codes.size() == 0) {
                    result = String.format("%s-%s\u4ea9/%s-%s\u4ea9", max1Code, max1Str, max2Code, max2Str);
                    break;
                }
                if (codes.size() == 1) {
                    result = String.format("%s-%s\u4ea9/%s-%s\u4ea9/%s-%s\u4ea9", max1Code, max1Str, max2Code, max2Str, codes.get(0), otherStr);
                    break;
                }
                result = String.format("%s-%s\u4ea9/%s-%s\u4ea9/\u5176\u4ed6-%s\u4ea9", max1Code, max1Str, max2Code, max2Str, otherStr);
                break;
            }
            case "natureReserve_Analyze": {
                Float total = base.getFloat("area");
                float yba = 0.0f;
                for (int i = 0; i < attrs.size(); ++i) {
                    JSONObject attr = attrs.getJSONObject(i);
                    Float mj = attr.getFloat("mj");
                    yba += mj.floatValue();
                }
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                String wbaStr = decimalFormat.format(total.floatValue() - yba);
                String ybaStr = decimalFormat.format(yba);
                result = String.format("\u81ea\u7136\u4fdd\u62a4\u533a-%s\u4ea9/\u975e\u81ea\u7136\u4fdd\u62a4\u533a-%s\u4ea9", ybaStr, wbaStr);
                break;
            }
            case "primeFarm_Analyze": {
                Float total = base.getFloat("area");
                float yba = 0.0f;
                for (int i = 0; i < attrs.size(); ++i) {
                    JSONObject attr = attrs.getJSONObject(i);
                    Float mj = attr.getFloat("mj");
                    yba += mj.floatValue();
                }
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                String wbaStr = decimalFormat.format(total.floatValue() - yba);
                String ybaStr = decimalFormat.format(yba);
                result = String.format("\u57fa\u672c\u519c\u7530-%s\u4ea9/\u975e\u57fa\u672c\u519c\u7530-%s\u4ea9", ybaStr, wbaStr);
                break;
            }
            case "spba_Analyze": {
                Float total = base.getFloat("area");
                float yba = 0.0f;
                for (int i = 0; i < attrs.size(); ++i) {
                    JSONObject attr = attrs.getJSONObject(i);
                    Float mj = attr.getFloat("mj");
                    yba += mj.floatValue();
                }
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                String wbaStr = decimalFormat.format(total.floatValue() - yba);
                String ybaStr = decimalFormat.format(yba);
                result = String.format("\u5df2\u5907\u6848-%s\u4ea9/\u672a\u5907\u6848-%s\u4ea9", ybaStr, wbaStr);
                break;
            }
            case "gqzrbhq_Analyze": {
                for (int i = 0; i < attrs.size(); ++i) {
                    JSONObject attr = attrs.getJSONObject(i);
                    String type = attr.getString("datatype");
                    Float mj = attr.getFloat("area");
                    DecimalFormat decimalFormat = new DecimalFormat("0.00");
                    if (StringUtils.isNotBlank((CharSequence)result)) {
                        result = result + "/";
                    }
                    result = result + type + "-" + decimalFormat.format(mj) + "\u4ea9";
                }
                break;
            }
            case "cxydgh_Analyze": {
                float max1 = 0.0f;
                float max2 = 0.0f;
                float total = 0.0f;
                String max1Code = "";
                String max2Code = "";
                ArrayList<String> codes = new ArrayList<String>();
                for (int i = 0; i < attrs.size(); ++i) {
                    JSONObject attr = attrs.getJSONObject(i);
                    Float mj = attr.getFloat("mj");
                    String code = attr.getString(key);
                    codes.add(code);
                    total += mj.floatValue();
                    if (mj.floatValue() > max1) {
                        max2 = max1;
                        max2Code = max1Code;
                        max1 = mj.floatValue();
                        max1Code = code;
                        continue;
                    }
                    if (!(mj.floatValue() >= max2)) continue;
                    max2 = mj.floatValue();
                    max2Code = code;
                }
                float other = total - max1 - max2;
                codes.remove(max1Code);
                codes.remove(max2Code);
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                String max1Str = decimalFormat.format(max1);
                String max2Str = decimalFormat.format(max2);
                String otherStr = decimalFormat.format(other);
                if (max2 <= 0.0f) {
                    result = String.format("%s-%s\u4ea9", max1Code, decimalFormat.format(max1));
                    break;
                }
                if (codes.size() == 0) {
                    result = String.format("%s-%s\u4ea9/%s-%s\u4ea9", max1Code, max1Str, max2Code, max2Str);
                    break;
                }
                if (codes.size() == 1) {
                    result = String.format("%s-%s\u4ea9/%s-%s\u4ea9/%s-%s\u4ea9", max1Code, max1Str, max2Code, max2Str, codes.get(0), otherStr);
                    break;
                }
                result = String.format("%s-%s\u4ea9/%s-%s\u4ea9/\u5176\u4ed6-%s\u4ea9", max1Code, max1Str, max2Code, max2Str, otherStr);
                break;
            }
            case "keyArea_Analyze": {
                float max1 = 0.0f;
                float max2 = 0.0f;
                float total = 0.0f;
                String max1Code = "";
                String max2Code = "";
                ArrayList<String> codes = new ArrayList<String>();
                for (int i = 0; i < attrs.size(); ++i) {
                    JSONObject attr = attrs.getJSONObject(i);
                    Float mj = attr.getFloat("mj");
                    String code = attr.getString(key);
                    codes.add(code);
                    total += mj.floatValue();
                    if (mj.floatValue() > max1) {
                        max2 = max1;
                        max2Code = max1Code;
                        max1 = mj.floatValue();
                        max1Code = code;
                        continue;
                    }
                    if (!(mj.floatValue() >= max2)) continue;
                    max2 = mj.floatValue();
                    max2Code = code;
                }
                float other = total - max1 - max2;
                codes.remove(max1Code);
                codes.remove(max2Code);
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                String max1Str = decimalFormat.format(max1);
                String max2Str = decimalFormat.format(max2);
                String otherStr = decimalFormat.format(other);
                if (max2 <= 0.0f) {
                    result = String.format("%s-%s\u4ea9", max1Code, decimalFormat.format(max1));
                    break;
                }
                if (codes.size() == 0) {
                    result = String.format("%s-%s\u4ea9/%s-%s\u4ea9", max1Code, max1Str, max2Code, max2Str);
                    break;
                }
                if (codes.size() == 1) {
                    result = String.format("%s-%s\u4ea9/%s-%s\u4ea9/%s-%s\u4ea9", max1Code, max1Str, max2Code, max2Str, codes.get(0), otherStr);
                    break;
                }
                result = String.format("%s-%s\u4ea9/%s-%s\u4ea9/\u5176\u4ed6-%s\u4ea9", max1Code, max1Str, max2Code, max2Str, otherStr);
                break;
            }
            case "jsydgmbj_Analyze": {
                float max1 = 0.0f;
                float max2 = 0.0f;
                float total = 0.0f;
                String max1Code = "";
                String max2Code = "";
                ArrayList<String> codes = new ArrayList<String>();
                for (int i = 0; i < attrs.size(); ++i) {
                    JSONObject attr = attrs.getJSONObject(i);
                    Float mj = attr.getFloat("mj");
                    String code = attr.getString(key);
                    codes.add(code);
                    total += mj.floatValue();
                    if (mj.floatValue() > max1) {
                        max2 = max1;
                        max2Code = max1Code;
                        max1 = mj.floatValue();
                        max1Code = code;
                        continue;
                    }
                    if (!(mj.floatValue() >= max2)) continue;
                    max2 = mj.floatValue();
                    max2Code = code;
                }
                float other = total - max1 - max2;
                codes.remove(max1Code);
                codes.remove(max2Code);
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                String max1Str = decimalFormat.format(max1);
                String max2Str = decimalFormat.format(max2);
                String otherStr = decimalFormat.format(other);
                if (max2 <= 0.0f) {
                    result = String.format("%s-%s\u4ea9", max1Code, decimalFormat.format(max1));
                    break;
                }
                if (codes.size() == 0) {
                    result = String.format("%s-%s\u4ea9/%s-%s\u4ea9", max1Code, max1Str, max2Code, max2Str);
                    break;
                }
                if (codes.size() == 1) {
                    result = String.format("%s-%s\u4ea9/%s-%s\u4ea9/%s-%s\u4ea9", max1Code, max1Str, max2Code, max2Str, codes.get(0), otherStr);
                    break;
                }
                result = String.format("%s-%s\u4ea9/%s-%s\u4ea9/\u5176\u4ed6-%s\u4ea9", max1Code, max1Str, max2Code, max2Str, otherStr);
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    private String parseAttr(JSONObject basic, String index) {
        String username = "";
        if (basic.getString("username") != null) {
            username = basic.getString("username");
        }
        JSONObject attr = null;
        attr = basic.getJSONArray("list") == null ? basic.getJSONObject("prj").getJSONObject("tb").getJSONArray("list").getJSONObject(Integer.valueOf(index).intValue()) : basic.getJSONArray("list").getJSONObject(Integer.valueOf(index).intValue());
        Date date = attr.getDate("time");
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = formater.format(date);
        Double lat = attr.getDouble("lat");
        Double lon = attr.getDouble("lon");
        Float dAzimuthDeg = attr.getFloat("azimuth");
        int azimuthDeg = Math.round(dAzimuthDeg.floatValue());
        Double direction = Math.floor((azimuthDeg + 15) / 30);
        String azimuth = "\u6b63\u5317";
        switch (direction.intValue()) {
            case 0: {
                azimuth = "\u6b63\u5317";
                break;
            }
            case 1: {
                azimuth = "\u5317\u504f\u4e1c";
                break;
            }
            case 2: {
                azimuth = "\u4e1c\u504f\u5317";
                break;
            }
            case 3: {
                azimuth = "\u6b63\u4e1c";
                break;
            }
            case 4: {
                azimuth = "\u4e1c\u504f\u5357";
                break;
            }
            case 5: {
                azimuth = "\u5357\u504f\u4e1c";
                break;
            }
            case 6: {
                azimuth = "\u6b63\u5357";
                break;
            }
            case 7: {
                azimuth = "\u5357\u504f\u897f";
                break;
            }
            case 8: {
                azimuth = "\u897f\u504f\u5357";
                break;
            }
            case 9: {
                azimuth = "\u6b63\u897f";
                break;
            }
            case 10: {
                azimuth = "\u897f\u504f\u5317";
                break;
            }
            case 11: {
                azimuth = "\u5317\u504f\u897f";
                break;
            }
            default: {
                azimuth = "\u6b63\u5317";
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        String latStr = decimalFormat.format(lat);
        String lonStr = decimalFormat.format(lon);
        return String.format("%s  %s\u00b0E %s\u00b0N  %s  %s", username, lonStr, latStr, azimuth, dateStr);
    }

    public Image addStamp(InputStream in) throws IOException, BadElementException {
        byte[] bytes = new byte[in.available()];
        in.read(bytes);
        Image img = Image.getInstance((byte[])bytes);
        img.scaleToFit(75.0f, 75.0f);
        img.setAbsolutePosition(510.0f, 756.0f);
        return img;
    }
}

