/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.dao.task.TbtskTaskFieldsAddDao;
import com.geoway.landteam.customtask.repository.pub.TbgstRepository;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.review.TbtskFlowServiceImpl;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.oss.OssConfig;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.dao.pub.AppMediaDao;
import com.geoway.landteam.landcloud.core.repository.pub.OssConfigRepository;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.pub.seo.TaskMediaGetSeo;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.base.dto.AppMediaDTO;
import com.geoway.landteam.landcloud.servface.other.ImportOtherDataService;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class TaskMediaService {
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    DataBizMapper dataBizMapper;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    AppMediaDao appMediaDao;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    ImportOtherDataService importOtherDataService;
    @Autowired
    OssConfigRepository ossConfigDao;
    @Autowired
    TbtskFlowServiceImpl tbtskFlowService;
    @Autowired
    TbgstRepository tbgstRepository;
    @Autowired
    TbtskTaskFieldsAddDao tbtskTaskFieldsAddDao;

    public JSONObject getMedias(TaskMediaGetSeo seo) throws Exception {
        if (seo == null) {
            throw new Exception("\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)seo.getTaskId())) {
            throw new Exception("\u53c2\u6570\u9519\u8bef,\u4efb\u52a1id\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)seo.getRelField())) {
            throw new Exception("\u53c2\u6570\u9519\u8bef,\u5173\u8054\u5b57\u6bb5\u4e3a\u7a7a");
        }
        if (seo.getRelValues() == null || seo.getRelValues().isEmpty()) {
            throw new Exception("\u53c2\u6570\u9519\u8bef,\u5173\u8054\u503c\u4e3a\u7a7a");
        }
        TskTaskBiz taskBiz = this.tskTaskBizService.findByTaskId(seo.getTaskId());
        if (taskBiz == null) {
            throw new Exception("\u4efb\u52a1:" + seo.getTaskId() + "\u4e0d\u5b58\u5728");
        }
        TbtskObjectinfo objectinfo = this.tskTaskBizService.findTableByTaskId(seo.getTaskId());
        if (objectinfo == null) {
            throw new Exception("\u4efb\u52a1:" + seo.getTaskId() + "\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        List fields = this.tskTaskBizService.getFieldsByTableId(taskBiz.getTableId());
        if (!fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase(seo.getRelField())).findFirst().isPresent()) {
            throw new Exception("\u4efb\u52a1:" + seo.getTaskId() + "\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728\u5b57\u6bb5:" + seo.getRelField());
        }
        ArrayList<String> selectFiels = new ArrayList<String>();
        selectFiels.add("f_id");
        if (!seo.getRelField().equals("f_id")) {
            selectFiels.add(seo.getRelField());
        }
        String where = seo.getRelField() + " in ('" + StringUtils.join((Iterable)seo.getRelValues(), (String)"','") + "')";
        List mapTbIds = this.dataBizMapper.queryAllData(objectinfo.getfTablename(), selectFiels, where);
        if (mapTbIds == null || mapTbIds.isEmpty()) {
            return null;
        }
        List tbIds = mapTbIds.stream().map(t -> t.get("f_id").toString()).collect(Collectors.toList());
        List appMedias = this.appMediaDao.queryByGalleryids(tbIds);
        ArrayList<AppMediaDTO> appMediaDTOS = new ArrayList<AppMediaDTO>();
        for (int i = 0; i < appMedias.size(); ++i) {
            AppMediaDTO newMedia = new AppMediaDTO();
            BeanUtil.copyProperties(appMedias.get(i), (Object)newMedia);
            if (StringUtils.isBlank((CharSequence)newMedia.getServerpath()) && StringUtils.isNotBlank((CharSequence)newMedia.getDownloadUrl())) {
                newMedia.setServerpath(newMedia.getDownloadUrl());
            }
            appMediaDTOS.add(newMedia);
        }
        JSONObject result = new JSONObject();
        result.put("medias", (Object)appMedias);
        ArrayList<OssConfig> configs = new ArrayList<OssConfig>();
        Iterable ossConfigs = this.ossConfigDao.findAll();
        for (OssConfig ossConfig : ossConfigs) {
            OssConfig oss = new OssConfig();
            BeanUtil.copyProperties((Object)ossConfig, (Object)oss);
            oss.setKey(Base64.getEncoder().encodeToString(oss.getKey().getBytes()));
            oss.setKeySecret(Base64.getEncoder().encodeToString(oss.getKeySecret().getBytes()));
            configs.add(oss);
        }
        result.put("ossConfigs", configs);
        if (!seo.getRelField().equals("f_id")) {
            result.put("relFields", (Object)mapTbIds);
        }
        return result;
    }
}

