/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.mapper.pub.TbsysBhmanagerMapper;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class TbsysBhmanagerService {
    private GiLoger logger = GwLoger.getLoger(TbsysBhmanagerService.class);
    @Autowired
    TbsysBhmanagerMapper tbsysBhmanagerMapper;

    public Pair<String, String> getParamKey(String paramObject, Map map) {
        String paramKey = "";
        String numLength = "";
        if (StringUtils.isNotBlank((CharSequence)paramObject)) {
            JSONArray jsonArray = JSONArray.parseArray((String)paramObject, (Feature[])new Feature[0]);
            block22: for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String paramValue = jsonObject.getString("value");
                switch (jsonObject.get((Object)"type").toString()) {
                    case "field": {
                        paramKey = paramKey + (map.get(paramValue) != null ? map.get(paramValue).toString() : "");
                        continue block22;
                    }
                    case "time": {
                        switch (paramValue) {
                            case "yyyy": {
                                paramKey = paramKey + this.getCurrentYear();
                                continue block22;
                            }
                            case "MM": {
                                paramKey = paramKey + this.getCurrentMonth();
                                continue block22;
                            }
                            case "dd": {
                                paramKey = paramKey + this.getCurrentDay();
                                continue block22;
                            }
                        }
                        continue block22;
                    }
                    case "String": {
                        paramKey = paramKey + paramValue;
                        continue block22;
                    }
                    case "sequence": {
                        numLength = paramValue;
                        continue block22;
                    }
                }
            }
        }
        return Pair.of((Object)paramKey, (Object)numLength);
    }

    public String getBhNextValue(String tableName, String fieldName, String paramKey, int numLength) {
        Integer bhNextValue = this.tbsysBhmanagerMapper.getBhNextValue(tableName, fieldName, paramKey);
        return paramKey + TbsysBhmanagerService.padNumber(bhNextValue, numLength);
    }

    public static String padNumber(int number, int numLength) {
        String numberString = String.valueOf(number);
        if (numberString.length() < numLength) {
            numberString = String.format("%0" + numLength + "d", number);
        }
        return numberString;
    }

    public String getCurrentYear() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("yyyy");
        return now.format(pattern);
    }

    public String getCurrentMonth() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("MM");
        return now.format(pattern);
    }

    public String getCurrentDay() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter pattern = DateTimeFormatter.ofPattern("dd");
        return now.format(pattern);
    }
}

