/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.entity.ImportUserResultInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskResultShare;
import com.geoway.landteam.landcloud.repository.pub.TbtskResultShareRepository;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(rollbackFor={Exception.class})
public class TbtskResultShareService {
    private GiLoger logger = GwLoger.getLoger(TbtskResultShareService.class);
    @Autowired
    TbtskResultShareRepository tbtskResultShareRepository;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    TbtskFieldsService tbtskFieldsService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    LandUserService landUserService;
    @Value(value="${project.uploadDir}")
    protected String uploadDir;

    public Map<String, Object> findResultShareRecords(Long userId, String gxbh, String sourceTaskName, String targetaskName, int pageIndex, int pageSize) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String sql = " select\n\tsh.f_id  id,\n\tsh.f_gxbh gxbh,\n\tsh.f_source_task_id  sourceTaskId,\n\tsh.f_target_task_id targetTaskId,\n\tsh.f_status status,\n\tsh.f_create_time  createTime,\n\tsh.f_update_time updateTime,\n\tsh.f_user_id userId,\n\tsh.f_param param,\n\tsh.f_log_url logUrl,\n\tttb.f_name sourceTaskName,\n\ttu.f_username userName\nfrom\n\ttbtsk_result_share sh\nleft join tbtsk_task_biz ttb on\n\t(ttb.f_id = sh.f_source_task_id)\nleft join tbsys_user tu on\n\t(tu.f_userid = sh.f_user_id ) where 1=1 ";
        String countSql = "select count(1) from\n\ttbtsk_result_share sh\nleft join tbtsk_task_biz ttb on\n\t(ttb.f_id = sh.f_source_task_id)\nleft join tbsys_user tu on\n\t(tu.f_userid = sh.f_user_id ) where 1=1 ";
        if (StringUtils.isNotBlank((CharSequence)gxbh)) {
            sql = sql + " and sh.f_gxbh like '%" + gxbh + "%'";
            countSql = countSql + " and sh.f_gxbh like '%" + gxbh + "%'";
        }
        if (StringUtils.isNotBlank((CharSequence)sourceTaskName)) {
            sql = sql + " and ttb.f_name like '%" + sourceTaskName + "%'";
            countSql = countSql + " and ttb.f_name like '%" + sourceTaskName + "%'";
        }
        if (StringUtils.isNotBlank((CharSequence)targetaskName)) {
            sql = sql + " and sh.f_target_task_id like '%" + targetaskName + "%'";
            countSql = countSql + " and sh.f_target_task_id like '%" + targetaskName + "%'";
        }
        int start = (pageIndex - 1) * pageSize;
        sql = sql + " order by sh.f_create_time desc limit " + pageSize + " offset " + start;
        List maps = this.dataBizService.queryDataBySql(sql);
        Integer count = (Integer)this.jdbcTemplate.queryForObject(countSql, Integer.class);
        if (!maps.isEmpty()) {
            for (Map map : maps) {
                if (map.get("logUrl") == null) continue;
                String accessUrl = this.temporarySignedUrlService.getTemporarySignedUrl("", map.get("logUrl").toString(), null);
                map.put("logUrl", accessUrl);
            }
        }
        result.put("datas", maps);
        result.put("totalNum", count);
        return result;
    }

    public TbtskResultShare startResultShare(Long userId, String id) {
        TbtskResultShare resultShare = (TbtskResultShare)this.tbtskResultShareRepository.gwSearchByPK((Serializable)((Object)id));
        resultShare.setStatus(Integer.valueOf(1));
        this.tbtskResultShareRepository.save((Object)resultShare);
        return resultShare;
    }

    public List<TskTaskBiz> getResultShareTasks() {
        List<Object> taskBizs = new ArrayList<TskTaskBiz>();
        SysConfig sysConfig = this.sysConfigService.findOne("shareTaskId");
        if (sysConfig != null) {
            String taskIds = sysConfig.getValue();
            taskBizs = this.tskTaskBizRepository.findByIds(Arrays.asList(taskIds.split(",")));
        }
        return taskBizs;
    }

    public void importShareData(Long userId, MultipartFile file, String sourceTaskId, String targetTaskId) throws Exception {
        String fileName = file.getOriginalFilename();
        String objectname = "resultShare/attachment/" + sourceTaskId + "/" + UUID.randomUUID().toString() + "_" + fileName;
        String result = this.ossOperatorService.sendObject2Oss(objectname, file.getInputStream());
        TbtskResultShare tbtskResultShare = new TbtskResultShare();
        tbtskResultShare.setId(UUID.randomUUID().toString());
        tbtskResultShare.setUserId(userId);
        tbtskResultShare.setCreateTime(new Timestamp(System.currentTimeMillis()));
        tbtskResultShare.setSourceTaskId(sourceTaskId);
        tbtskResultShare.setTargetTaskId(targetTaskId);
        tbtskResultShare.setParam(result);
        tbtskResultShare.setStatus(Integer.valueOf(0));
        tbtskResultShare.setGxbh(this.getgxbh());
        this.tbtskResultShareRepository.save((Object)tbtskResultShare);
    }

    public String getgxbh() {
        String sql = "select nextval('result_share_gid_seq') as id";
        Map map = this.jdbcTemplate.queryForMap(sql);
        Long bh = (Long)map.get("id");
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String gxbh = "500000" + dateFormat.format(new Date()) + decimalFormat.format(bh);
        return gxbh;
    }

    public void handlyResultShareExcel(TbtskResultShare tbtskResultShare) throws Exception {
        File excelFile = null;
        File dir = new File(this.uploadDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        excelFile = File.createTempFile("tmp", ".xls", dir);
        String accessUrl = this.temporarySignedUrlService.getTemporarySignedUrl("", tbtskResultShare.getParam(), null);
        FileUtils.copyURLToFile((URL)new URL(accessUrl), (File)excelFile);
        this.parseExcel(excelFile.getAbsolutePath(), tbtskResultShare);
        String fileName = excelFile.getName();
        String obsFilePath = "resultShare/attachment/" + tbtskResultShare.getSourceTaskId() + "/" + UUID.randomUUID().toString() + "_" + fileName;
        String url = this.ossOperatorService.sendObject2Oss(obsFilePath, excelFile.getAbsolutePath());
        tbtskResultShare.setLogUrl(url);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<ImportUserResultInfo> parseExcel(String excelFile, TbtskResultShare tbtskResultShare) throws Exception {
        SysConfig sysConfig;
        List sourceFields = null;
        String tableName = "";
        ArrayList<String> queryFieldNames = new ArrayList<String>();
        TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(tbtskResultShare.getSourceTaskId());
        if (tskTaskBiz == null) throw new Exception("\u6210\u679c\u6765\u6e90\u4efb\u52a1\u4e0d\u5b58\u5728");
        TbtskObjectinfo tableInfo = this.tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        if (tableInfo == null) throw new Exception("\u6210\u679c\u6765\u6e90\u4efb\u52a1\u56fe\u6591\u8868\u4e0d\u5b58\u5728");
        tableName = tableInfo.getfTablename();
        sourceFields = this.tbtskFieldsService.getAllFieldsByTables(tableInfo.getfTablename());
        if (sourceFields != null && sourceFields.size() > 0) {
            for (TbtskFields field : sourceFields) {
                queryFieldNames.add(field.getfFieldname());
            }
        }
        if ((sysConfig = this.sysConfigService.findOne("synchronizedata")) == null) {
            throw new Exception("\u83b7\u53d6\u7ebf\u7d22\u6750\u6599\u4e0a\u4f20\u63a5\u53e3\u5730\u5740\u5931\u8d25");
        }
        Workbook workbook = null;
        FileOutputStream out = null;
        List<ImportUserResultInfo> userResultInfos = null;
        File file = new File(excelFile);
        FileInputStream inputStream = new FileInputStream(file);
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        workbook = WorkbookFactory.create((InputStream)inputStream);
        ((InputStream)inputStream).close();
        Sheet sheet = workbook.getSheetAt(0);
        Row row = sheet.getRow(0);
        int colNumber = row.getPhysicalNumberOfCells();
        int rowCount = sheet.getPhysicalNumberOfRows();
        this.createImportResultColumn(workbook, sheet, colNumber);
        for (int i = 2; i < rowCount; ++i) {
            ImportUserResultInfo resultInfo = new ImportUserResultInfo();
            resultInfo.setRow(i);
            row = sheet.getRow(i);
            if (row == null) continue;
            try {
                String xh = this.findCellValue(row.getCell(0));
                String bsm = this.findCellValue(row.getCell(1));
                String sjkdl = this.findCellValue(row.getCell(2));
                String tbmj = this.findCellValue(row.getCell(3));
                String xcry = this.findCellValue(row.getCell(4));
                String tbbh = this.findCellValue(row.getCell(5));
                String xzdl = this.findCellValue(row.getCell(6));
                if (StringUtils.isBlank((CharSequence)tbbh)) {
                    this.writeErrorInfo(workbook, row, colNumber, "\u5fc5\u586b\u9879\u4e3a\u7a7a\uff0c\u6b64\u8bb0\u5f55\u65e0\u6548");
                }
                List sourceDatas = this.dataBizService.queryAllData(tableName, queryFieldNames, "f_tbbh = '" + tbbh + "'");
                if (sourceFields != null && sourceFields.size() > 0) {
                    if (sourceDatas == null) continue;
                    for (Map map : sourceDatas) {
                        map.put("f_bsm", bsm);
                        if (!map.containsKey("f_id")) continue;
                        List appMediaList = this.appMediaRepository.queryByGalleryids(Arrays.asList(map.get("f_id").toString()));
                        if (appMediaList.size() > 0) {
                            List<JSONObject> param = this.converParam1(appMediaList);
                            String url = sysConfig.getValue() + "/" + tbtskResultShare.getSourceTaskId() + "/" + bsm;
                            JSONObject resultObject = this.synchronizedata(url, JSON.toJSONString(param, (boolean)true));
                            this.writeParamInfo(workbook, row, colNumber, JSON.toJSONString(param, (boolean)true), resultObject);
                            this.writeSuccessInfo(workbook, row, colNumber);
                            continue;
                        }
                        this.writeErrorInfo(workbook, row, colNumber, "\u9644\u4ef6\u4e3a\u7a7a");
                    }
                    continue;
                }
                this.writeErrorInfo(workbook, row, colNumber, "\u627e\u4e0d\u5230\u56fe\u6591\u6570\u636e\uff0c\u6570\u636e\u4e3a\u7a7a");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Throwable)e);
                this.writeErrorInfo(workbook, row, colNumber, e.getMessage());
            }
        }
        out = new FileOutputStream(file);
        workbook.write((OutputStream)out);
        out.flush();
        ((OutputStream)out).close();
        return userResultInfos;
    }

    public JSONObject converParam(Map map, List<AppMedia> appMediaList) {
        JSONObject params = new JSONObject();
        params.put("type", (Object)0);
        params.put("data", (Object)map);
        ArrayList<JSONObject> medias = new ArrayList<JSONObject>();
        for (AppMedia appMedia : appMediaList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("f_type", (Object)appMedia.getType());
            String accessUrl = this.temporarySignedUrlService.getTemporarySignedUrl("", appMedia.getServerpath(), null);
            jsonObject.put("f_serverpath", (Object)accessUrl);
            jsonObject.put("f_videorecord", (Object)appMedia.getVideorecord());
            jsonObject.put("f_jym", (Object)appMedia.getJym());
            jsonObject.put("f_lon", (Object)appMedia.getLon());
            jsonObject.put("f_lat", (Object)appMedia.getLat());
            jsonObject.put("f_azimuths", (Object)appMedia.getAzimuth());
            jsonObject.put("f_pitchs", (Object)appMedia.getPitch());
            jsonObject.put("f_mediasize", (Object)appMedia.getMediasize());
            jsonObject.put("f_userid", (Object)appMedia.getUsername());
            jsonObject.put("f_username", (Object)appMedia.getUsername());
            jsonObject.put("f_device_source", (Object)appMedia.getDeviceSource());
            medias.add(jsonObject);
        }
        params.put("media", medias);
        return params;
    }

    public List<JSONObject> converParam1(List<AppMedia> appMediaList) {
        ArrayList<JSONObject> medias = new ArrayList<JSONObject>();
        for (AppMedia appMedia : appMediaList) {
            LandUser landUser;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)appMedia.getType());
            jsonObject.put("time", (Object)appMedia.getTime());
            String accessUrl = this.temporarySignedUrlService.getTemporarySignedUrl("", appMedia.getServerpath(), null);
            jsonObject.put("serverpath", (Object)accessUrl);
            jsonObject.put("videorecord", (Object)appMedia.getVideorecord());
            jsonObject.put("lon", (Object)appMedia.getLon());
            jsonObject.put("lat", (Object)appMedia.getLat());
            jsonObject.put("azimuth", (Object)appMedia.getAzimuth());
            jsonObject.put("id", (Object)appMedia.getId());
            jsonObject.put("mediasize", (Object)appMedia.getMediasize());
            jsonObject.put("deviceSource", (Object)appMedia.getDeviceSource());
            String phonemobil = "";
            if (StringUtils.isNotBlank((CharSequence)appMedia.getUsername()) && (landUser = this.landUserService.queryAppUserByUsernamePhone(appMedia.getUsername())) != null) {
                phonemobil = landUser.getPhone();
            }
            jsonObject.put("phonemobile", (Object)phonemobil);
            medias.add(jsonObject);
        }
        return medias;
    }

    public ImportUserResultInfo parseRow(Workbook wb, Row row, int colNumber) {
        ImportUserResultInfo resultInfo = new ImportUserResultInfo();
        String nameValue = this.findCellValue(row.getCell(0));
        String phoneValue = this.findCellValue(row.getCell(1));
        String unitValue = this.findCellValue(row.getCell(2));
        String deptValue = this.findCellValue(row.getCell(3));
        String regionCodeValue = this.findCellValue(row.getCell(4));
        String regionNameValue = this.findCellValue(row.getCell(5));
        String emailValue = this.findCellValue(row.getCell(6));
        String roleValue = this.findCellValue(row.getCell(7));
        String zxjgValue = this.findCellValue(row.getCell(8));
        String znglValue = this.findCellValue(row.getCell(9));
        if (StringUtils.isBlank((CharSequence)nameValue) && StringUtils.isBlank((CharSequence)phoneValue) && StringUtils.isBlank((CharSequence)unitValue) && StringUtils.isBlank((CharSequence)regionCodeValue)) {
            resultInfo.setInvalidRow(true);
            resultInfo.setState(2);
            resultInfo.setErrorInfo("\u5fc5\u586b\u9879\u4e3a\u7a7a\uff0c\u6b64\u8bb0\u5f55\u65e0\u6548");
            this.writeErrorInfo(wb, row, colNumber, "\u5fc5\u586b\u9879\u4e3a\u7a7a\uff0c\u6b64\u8bb0\u5f55\u65e0\u6548");
            return resultInfo;
        }
        return null;
    }

    private void writeErrorInfo(Workbook workbook, Row row, int colNumber, String errorInfo) {
        Cell cell;
        if (workbook != null && row != null && colNumber > -1 && StringUtils.isNotBlank((CharSequence)errorInfo) && (cell = row.createCell(colNumber)) != null) {
            cell.setCellValue("\u63a5\u53e3\u8bbf\u95ee\u5931\u8d25\uff0c" + errorInfo);
        }
    }

    private void writeSuccessInfo(Workbook workbook, Row row, int colNumber) {
        Cell cell;
        if (workbook != null && row != null && colNumber > -1 && (cell = row.createCell(colNumber)) != null) {
            cell.setCellValue("\u63a5\u53e3\u8bbf\u95ee\u6210\u529f");
        }
    }

    private void writeParamInfo(Workbook workbook, Row row, int colNumber, String param, JSONObject resultObject) {
        if (workbook != null && row != null && colNumber > -1) {
            Cell cell = row.createCell(colNumber + 1);
            Cell cell2 = row.createCell(colNumber + 2);
            if (cell != null) {
                cell.setCellValue(param);
                cell2.setCellValue(JSONObject.toJSONString((Object)resultObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            }
        }
    }

    private String findCellValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return "";
        }
        try {
            CellType cellType = cell.getCellType();
            switch (cellType) {
                case STRING: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                        cellValue = fmt.format(cell.getDateCellValue());
                        break;
                    }
                    cellValue = String.valueOf((long)cell.getNumericCellValue());
                    break;
                }
                case BOOLEAN: {
                    cellValue = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case BLANK: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case ERROR: {
                    cellValue = "\u9519\u8bef";
                    break;
                }
                case FORMULA: {
                    cellValue = "\u9519\u8bef";
                    break;
                }
                default: {
                    cellValue = "\u9519\u8bef";
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return cellValue.trim();
    }

    private void createImportResultColumn(Workbook workbook, Sheet sheet, int colNumber) {
        Row row = sheet.getRow(1);
        if (workbook != null && row != null && colNumber > -1) {
            Cell cell = row.createCell(colNumber);
            Cell cell2 = row.createCell(colNumber + 1);
            Cell cell3 = row.createCell(colNumber + 2);
            if (cell != null) {
                cell.setCellValue("\u7ed3\u679c");
                cell2.setCellValue("\u4f20\u53c2");
                cell3.setCellValue("\u8fd4\u56de\u53c2\u6570");
            }
        }
    }

    private CellStyle creatersultecolumnheadercellstyle(Workbook wb) {
        XSSFCellStyle cellStyle = this.createCommonCellStyle(wb);
        if (cellStyle != null) {
            cellStyle.setFillForegroundColor((short)13);
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.getFont().setFontHeightInPoints((short)12);
        }
        return cellStyle;
    }

    private CellStyle createErrorInfoCellStyle(Workbook wb) {
        XSSFCellStyle cellStyle = this.createCommonCellStyle(wb);
        if (cellStyle != null) {
            // empty if block
        }
        return cellStyle;
    }

    private CellStyle createSuceessinfocellstyle(Workbook wb) {
        XSSFCellStyle cellStyle = this.createCommonCellStyle(wb);
        if (cellStyle != null) {
            // empty if block
        }
        return cellStyle;
    }

    private XSSFCellStyle createCommonCellStyle(Workbook wb) {
        XSSFCellStyle cellStyle = null;
        if (wb != null && (cellStyle = (XSSFCellStyle)wb.createCellStyle()) != null) {
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            XSSFFont font = (XSSFFont)wb.createFont();
            font.setFontName("\u4eff\u5b8b_GB2312");
            font.setBold(true);
            font.setFontHeightInPoints((short)11);
            cellStyle.setFont((Font)font);
            cellStyle.setWrapText(true);
        }
        return cellStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject synchronizedata(String url, String params) {
        JSONObject result = new JSONObject();
        result.put("code", (Object)1);
        if (url != null) {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            try {
                HttpPost httpPost = new HttpPost();
                httpPost.setURI(URI.create(url));
                httpPost.setHeader("Content-Type", "application/json");
                httpPost.setHeader("AppKey", "11bf5bd2ea1c72266615f6fdcc96206f");
                StringEntity entity = new StringEntity(params, "UTF-8");
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)entity);
                HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                String httpEntityContent = TbtskResultShareService.getHttpEntityContent(response);
                result = JSONObject.parseObject((String)httpEntityContent.substring(httpEntityContent.indexOf("{"), httpEntityContent.lastIndexOf("}") + 1));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static String getHttpEntityContent(HttpResponse response) throws Exception {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream is = entity.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = br.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line + "\n");
                line = br.readLine();
            }
            br.close();
            is.close();
            return sb.toString();
        }
        return "";
    }
}

