/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.HttpConnectionUtil;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.coord.GeoPoint;
import com.geoway.landteam.landcloud.core.model.pub.dto.CommonNum;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OssConfigRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.resultshare.AppMediaCopyDto2;
import com.geoway.landteam.landcloud.servface.pub.MAppMediaService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.util.RedisSessionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.geolatte.geom.crs.Projection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class MAppMediaServiceImpl
implements MAppMediaService {
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    OssConfigRepository ossConfigDao;
    @Autowired
    MDataBizService mDataBizService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Value(value="${project.uploadDir}")
    String uploadDir;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    private LandUserRepository landUserDao;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    UserNameService userNameService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map> uploadTbTxt(HttpServletRequest request, String bizId, String fieldName, String tbId) {
        Long userId = RedisSessionUtils.checkAppOrWebLogin(request);
        TskTaskBiz tskTaskBiz = (TskTaskBiz)this.tskTaskBizRepository.gwSearchByPK((Serializable)((Object)bizId));
        if (tskTaskBiz == null) {
            throw new RuntimeException("\u65e0\u8be5\u4efb\u52a1");
        }
        TbtskObjectinfo tbtskObjectinfo = (TbtskObjectinfo)this.tbtskObjectinfoRepository.gwSearchByPK((Serializable)((Object)tskTaskBiz.getTableId()));
        ArrayList<String> tempList = new ArrayList<String>();
        MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
        List multipartFiles = multiRequest.getFiles("file");
        InputStream inputStream = null;
        OutputStream outputStream = null;
        if (!multipartFiles.isEmpty()) {
            try {
                for (MultipartFile multipartFile : multipartFiles) {
                    inputStream = multipartFile.getInputStream();
                    String filePath = "media/" + userId + "/" + tbId + "/" + multipartFile.getOriginalFilename();
                    if (!filePath.endsWith(".txt")) {
                        throw new RuntimeException("\u8bf7\u4f20\u5165.txt\u6587\u4ef6");
                    }
                    String resultUrl = this.defaultOssOperatorService.sendObject2Oss(filePath, inputStream);
                    String exist = " select f_id from tb_app_media where f_galleryid ='" + tbId + "'  and f_serverpath = '" + resultUrl + "' and f_type = 6 ";
                    List existList = this.jdbcTemplate.queryForList(exist);
                    if (!existList.isEmpty()) continue;
                    tempList.add(resultUrl);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!tempList.isEmpty()) {
            ArrayList<AppMedia> appMediaList = new ArrayList<AppMedia>();
            for (String url : tempList) {
                AppMedia appMedia = new AppMedia();
                appMedia.setId(UUID.randomUUID().toString());
                appMedia.setGalleryid(tbId);
                appMedia.setServerpath(url);
                appMedia.setType(Integer.valueOf(6));
                appMedia.setTypetype(Integer.valueOf(0));
                appMedia.setDeviceSource(Integer.valueOf(0));
                appMediaList.add(appMedia);
            }
            this.appMediaRepository.saveAll(appMediaList);
        }
        String findSql = "select f_id,f_serverpath from tb_app_media where f_galleryid='" + tbId + "'  and f_type = 6  and f_serverpath like '%.txt'";
        List list = this.jdbcTemplate.queryForList(findSql);
        ArrayList<Map> mapList = new ArrayList<Map>();
        if (!list.isEmpty()) {
            for (Map map : list) {
                String id = map.get("f_id").toString();
                String name = map.get("f_serverpath").toString().substring(map.get("f_serverpath").toString().lastIndexOf("/") + 1);
                String url = map.get("f_serverpath").toString();
                HashMap<String, String> temp = new HashMap<String, String>();
                temp.put("id", id);
                temp.put("name", name);
                temp.put("url", url);
                mapList.add(temp);
            }
        }
        return mapList;
    }

    public String delTbTxt(Long userId, String tbId, String bizId, String fileName, String fieldName) {
        String completePath;
        TskTaskBiz tskTaskBiz = (TskTaskBiz)this.tskTaskBizRepository.gwSearchByPK((Serializable)((Object)bizId));
        if (tskTaskBiz == null) {
            throw new RuntimeException("\u65e0\u8be5\u4efb\u52a1");
        }
        TbtskObjectinfo tbtskObjectinfo = (TbtskObjectinfo)this.tbtskObjectinfoRepository.gwSearchByPK((Serializable)((Object)tskTaskBiz.getTableId()));
        String sql = "select " + fieldName + " from " + tbtskObjectinfo.getfTablename() + " where f_id = '" + tbId + "'";
        String txtStr = (String)this.jdbcTemplate.queryForObject(sql, String.class);
        List<Object> txtList = null;
        txtList = txtStr == null ? new ArrayList() : Arrays.asList(txtStr.split(","));
        ArrayList tempList = new ArrayList(txtList);
        if (!fileName.endsWith(".txt")) {
            fileName = fileName + ".txt";
        }
        if (tempList.indexOf(completePath = this.defaultOssOperatorService.getDomain() + "/media/" + userId + "/" + tbId + "/" + fileName) != -1) {
            tempList.remove(completePath);
        }
        String tempTxtStr = StringUtils.join((Iterable)tempList.stream().distinct().collect(Collectors.toList()), (String)",");
        String updateSql = "update " + tbtskObjectinfo.getfTablename() + " set " + fieldName + "='" + tempTxtStr + "' where f_id = '" + tbId + "' ";
        this.jdbcTemplate.update(updateSql);
        return tempTxtStr;
    }

    public List<AppMedia> queryByGalleryids(List<String> galleryids) {
        return this.appMediaRepository.queryByGalleryids(galleryids);
    }

    public boolean isExist(String galleryId, String url) {
        return this.appMediaRepository.isExist(galleryId, url) > 0;
    }

    public void save(List<AppMedia> appMediaList) {
        this.appMediaRepository.saveAll(appMediaList);
    }

    public int saveOne(AppMedia appMedia) {
        return this.appMediaRepository.save((Object)appMedia) != null ? 1 : 0;
    }

    public boolean deleteRecordAndStorage(List<String> galleryIds) {
        List mediaList = this.appMediaRepository.queryByGalleryids(galleryIds);
        if (mediaList != null && !mediaList.isEmpty()) {
            for (AppMedia media : mediaList) {
                if (!StringUtils.isNotBlank((CharSequence)media.getServerpath())) continue;
                String url = media.getServerpath();
                if (url.startsWith("https")) {
                    url = url.replace("https", "http");
                } else if (url.startsWith("HTTPS")) {
                    url = url.replace("HTTPS", "http");
                } else if (url.startsWith("HTTP")) {
                    url = url.replace("HTTP", "http");
                }
                if (url.startsWith("http")) {
                    url = url.replace("http://", "");
                    url = url.substring(url.indexOf(47) + 1);
                }
                this.defaultOssOperatorService.deleteObject(url);
            }
            this.appMediaRepository.deleteByGalleryids(galleryIds);
        }
        return true;
    }

    public List<AppMedia> getByXYZ(Integer x, Integer y, Integer z) throws IOException {
        SysConfig poiConfig = this.sysConfigService.findOne("poiUrl");
        String url = poiConfig.getValue() + "?x=" + x + "&y=" + y + "&l=" + z;
        String result = HttpConnectionUtil.httpget((String)url);
        JSONArray array = JSONArray.parseArray((String)result, (Feature[])new Feature[0]);
        if (array.isEmpty()) {
            return null;
        }
        List<AppMedia> mediaList = this.getObjectByArray(array);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("x-image-process", "image/resize,m_fixed,w_96,h_54");
        List<AppMedia> resultList = this.getAppMedia(mediaList, false, queryParams);
        return resultList;
    }

    private List<AppMedia> getAppMedia(List<AppMedia> appMedias, boolean hasUsername, Map<String, Object> queryParams) {
        ArrayList<AppMedia> result = new ArrayList<AppMedia>();
        for (int i = 0; i < appMedias.size(); ++i) {
            AppMedia appMedia = appMedias.get(i);
            AppMedia newMedia = new AppMedia();
            BeanUtils.copyProperties((Object)appMedias.get(i), (Object)newMedia);
            if (newMedia.getServerpath() != null) {
                newMedia.setServerpath(newMedia.getServerpath());
            }
            if (hasUsername) {
                if (StringUtils.isNotBlank((CharSequence)appMedia.getUsername())) {
                    String realname = this.userNameService.getUserRealNameByUserName(appMedia.getUsername());
                    if (StringUtils.isNotBlank((CharSequence)realname)) {
                        newMedia.setUsername(realname);
                    }
                } else {
                    newMedia.setUsername("\u672a\u8bb0\u5f55");
                }
            }
            result.add(newMedia);
        }
        return result;
    }

    private List<AppMedia> getObjectByArray(JSONArray array) {
        ArrayList<AppMedia> mediaList = new ArrayList<AppMedia>();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject obj = array.getJSONObject(i).getJSONObject("properties");
            String id = obj.getString("f_id");
            String galleryid = obj.getString("f_galleryid");
            Double lon = obj.getDouble("y");
            Double lat = obj.getDouble("x");
            String serverpath = obj.getString("f_serverpath");
            String bizid = "";
            if (null != obj.get((Object)"f_bizid") && !"null".equals(obj.getString("f_bizid"))) {
                bizid = obj.getString("f_bizid");
            }
            String tablename = "";
            if (null != obj.get((Object)"f_tablename") && !"null".equals(obj.getString("f_tablename"))) {
                tablename = obj.getString("f_tablename");
            }
            String azimuth = obj.getString("f_azimuth");
            AppMedia media = new AppMedia();
            media.setId(id);
            media.setGalleryid(galleryid);
            media.setLat(lat);
            media.setLon(lon);
            media.setServerpath(serverpath);
            media.setAzimuth(azimuth);
            mediaList.add(media);
        }
        return mediaList;
    }

    private List<AppMedia> getObject(List<Map<String, Object>> list) {
        ArrayList<AppMedia> mediaList = new ArrayList<AppMedia>();
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> obj = list.get(i);
            String id = (String)obj.get("f_id");
            String galleryid = (String)obj.get("f_galleryid");
            Double lon = (Double)obj.get("f_lon");
            Double lat = (Double)obj.get("f_lat");
            String serverpath = (String)obj.get("f_serverpath");
            String bizid = (String)obj.get("f_bizid");
            String tablename = (String)obj.get("f_tablename");
            String azimuth = (String)obj.get("f_azimuth");
            AppMedia media = new AppMedia();
            media.setId(id);
            media.setGalleryid(galleryid);
            media.setLat(lat);
            media.setLon(lon);
            media.setServerpath(serverpath);
            media.setAzimuth(azimuth);
            mediaList.add(media);
        }
        return mediaList;
    }

    public List<AppMedia> getMediaByBounds(String xmin, String ymin, String xmax, String ymax, Integer num) {
        BigDecimal xDisince = new BigDecimal(xmax).subtract(new BigDecimal(xmin)).divide(new BigDecimal(num));
        BigDecimal yDisince = new BigDecimal(ymax).subtract(new BigDecimal(ymin)).divide(new BigDecimal(num));
        String sql = "";
        long time1 = System.currentTimeMillis();
        for (int x = 0; x < num; ++x) {
            for (int y = 0; y < num; ++y) {
                BigDecimal tempXmin = new BigDecimal(xmin).add(xDisince.multiply(new BigDecimal(x)));
                BigDecimal tempXmax = new BigDecimal(xmin).add(xDisince.multiply(new BigDecimal(x + 1)));
                BigDecimal tempYmin = new BigDecimal(ymin).add(yDisince.multiply(new BigDecimal(y)));
                BigDecimal tempYmax = new BigDecimal(ymin).add(yDisince.multiply(new BigDecimal(y + 1)));
                String temp = " (select f_id,f_galleryid,f_lon,f_lat,f_serverpath,f_bizid,f_tablename,f_azimuth from tb_app_media where f_lon > " + tempYmin + " and f_lon < " + tempYmax + " and  f_lat > " + tempXmin + " and f_lat < " + tempXmax + " and f_bizid is not null  limit 1 )";
                if (!"".equals(sql)) {
                    sql = sql + " union all ";
                }
                sql = sql + temp;
            }
        }
        List list = this.jdbcTemplate.queryForList(sql);
        List<AppMedia> mediaList = this.getObject(list);
        long time2 = System.currentTimeMillis();
        System.out.println(time2 - time1);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("x-image-process", "image/resize,m_fixed,w_96,h_54");
        List<AppMedia> result = this.getAppMedia(mediaList, false, queryParams);
        long time3 = System.currentTimeMillis();
        System.out.println(time3 - time2);
        return result;
    }

    public List<AppMedia> getAppMedia(List<AppMedia> appMedias) {
        return this.getAppMedia(appMedias, true, null);
    }

    public List<AppMedia> getAllByBounds(String xmin, String ymin, String xmax, String ymax, Integer num) {
        String sql = " select f_id,f_galleryid,f_lon,f_lat,f_serverpath,f_bizid,f_tablename,f_azimuth,f_shape from tb_app_media where f_lon > " + ymin + " and f_lon < " + ymax + " and  f_lat > " + xmin + " and f_lat < " + xmax + " and f_bizid is not null order by f_time desc limit " + num;
        List list = this.jdbcTemplate.queryForList(sql);
        List<AppMedia> mediaList = this.getObject(list);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("x-image-process", "image/resize,m_fixed,w_96,h_54");
        List<AppMedia> result = this.getAppMedia(mediaList, false, queryParams);
        return result;
    }

    public List<CommonNum> getStatisticsByType() {
        String sql = "select t4.f_scope,t5.f_sum from tbtsk_task_biz_application_group t4,(select t3.f_busicode, sum(t3.f_sum) as f_sum from (select t2.*,t1.f_busicode from tbtsk_task_biz t1, (select f_bizid, count(*) as f_sum from tb_app_media where f_bizid is not null GROUP BY f_bizid)t2 where t1.f_id = t2.f_bizid) t3 GROUP BY t3.f_busicode)t5 where t4.f_busicode = t5.f_busicode;";
        List dataList = this.jdbcTemplate.queryForList(sql);
        Long sum = 0L;
        for (int i = 0; i < dataList.size(); ++i) {
            Map obj = (Map)dataList.get(i);
            sum = sum + Long.valueOf(obj.get("f_sum").toString());
        }
        ArrayList<CommonNum> result = new ArrayList<CommonNum>();
        for (int i = 0; i < dataList.size(); ++i) {
            Map obj = (Map)dataList.get(i);
            CommonNum item = new CommonNum();
            item.setName((String)obj.get("f_scope"));
            Long num = Long.valueOf(obj.get("f_sum").toString());
            item.setNum(num);
            BigDecimal percent = BigDecimal.valueOf(num * 100L).divide(BigDecimal.valueOf(sum), 2, RoundingMode.DOWN);
            item.setPercent(percent);
            result.add(item);
        }
        return result;
    }

    public void mediaMount(String taskId, String tbId, JSONObject subMedias) {
        TskTaskBiz tskTaskBiz = (TskTaskBiz)this.tskTaskBizRepository.gwSearchByPK((Serializable)((Object)taskId));
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        ArrayList<AppMedia> saveList = new ArrayList<AppMedia>();
        for (String next : subMedias.keySet()) {
            this.appMediaRepository.deleteByGalleryid(next);
            if (StringUtils.isEmpty((CharSequence)next) || "0".equals(next)) {
                throw new RuntimeException("\u6302\u63a5\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u9009\u62e9\u5b50\u56fe\u6591\u6302\u63a5");
            }
            JSONArray jsonArray = subMedias.getJSONArray(next);
            if (jsonArray.size() <= 0) continue;
            for (int i = 0; i < jsonArray.size(); ++i) {
                String decode;
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String id = jsonObject.getString("id");
                List ones = this.appMediaRepository.queryByIds(Arrays.asList(id));
                AppMedia one = new AppMedia();
                if (ones.size() > 0) {
                    one = (AppMedia)ones.get(0);
                } else {
                    AppMedia entity;
                    one = entity = (AppMedia)JSONObject.toJavaObject((JSON)jsonObject, AppMedia.class);
                    try {
                        if (URLDecoder.decode(one.getServerpath(), "UTF-8").indexOf("?") > 0) {
                            decode = URLDecoder.decode(one.getServerpath(), "UTF-8");
                            one.setServerpath(decode.substring(0, decode.indexOf("?")));
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                AppMedia temp = new AppMedia();
                BeanUtils.copyProperties((Object)one, (Object)temp, (String[])new String[]{"galleryid", "id"});
                if (temp.getServerpath().contains("AWSAccessKeyId")) {
                    try {
                        decode = URLDecoder.decode(temp.getServerpath(), "UTF-8");
                        temp.setServerpath(temp.getServerpath().substring(0, decode.indexOf("?")));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                temp.setGalleryid(next);
                temp.setId(UUID.randomUUID().toString());
                Integer exist = this.appMediaRepository.isExist(temp.getGalleryid(), temp.getServerpath());
                if (exist > 0) continue;
                saveList.add(temp);
            }
        }
        this.appMediaRepository.saveAll(saveList);
    }

    public Page<AppMedia> findMediaList(String filterParam, String sortParam, int start, int limit) {
        Page results = this.appMediaRepository.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return results;
    }

    public Map<String, Object> findMediaDroneList(Integer deviceSource, Integer type, String startTime, int page, int rows, String endTime, String sortParam) {
        HashMap<String, Object> map2;
        String sql = " select s.f_id id,s.f_galleryid galleryid,s.f_type type1,s.f_time time1,s.f_lon lon,s.f_lat lat,s.f_azimuth azimuth,s.f_pitch pitch,s.f_shape shape,s.f_videorecord videorecord,s.f_serverpath serverpath,s.f_mediatimelength mediatimelength,s.f_mediasize mediasize,s.f_fileid fileId,s.f_downloadurl downloadUrl,s.f_mark mark,s.f_typetype typetype,s.f_username username,s.f_group_code groupCode,s.f_media metaInfo,s.f_jym jym,s.f_viewurl viewUrl,s.f_appkey appKey,s.f_createtime createTime,s.f_tilestate tileState,s.f_tileurl tileUrl,s.f_scale scale,s.f_psgd psgd,s.f_takeofflon takeOffLon,s.f_takeofflat takeOffLat,s.f_takeoffrelheight takeOffHeight,s.f_device_source deviceSource,s.f_takeOffAltitude takeOffAltitude,s.f_psAltitude psAltitude,s.f_copyid copyid,s.f_bizid bizId,s.f_fromsource fromSource,s.f_tablename tableName,s.f_35mmfocal f35mmfocal,s.f_roll roll,s.f_dimwidth dimWidth,s.f_dimheight dimHeight,s.f_area area1,s.f_sm3 sm3\nfrom (\n    select *, row_number() over (partition by ttt.f_galleryid  order by ttt.f_time  desc) as group_idx\n    from tb_app_media ttt where AAAAAA\n) s\nwhere s.group_idx = 1 ";
        String countsql = " select count(1)\nfrom (\n    select *, row_number() over (partition by ttt.f_galleryid  order by ttt.f_time  desc) as   group_idx\n    from tb_app_media ttt where AAAAAA\n) s\nwhere s.group_idx = 1 ";
        String where = " 1 = 1";
        if (deviceSource != null) {
            where = where + " and ttt.f_device_source ='" + deviceSource + "'";
        }
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            where = where + " and ttt.f_time >='" + MAppMediaServiceImpl.converTime(startTime) + "'";
        }
        if (StringUtils.isNotBlank((CharSequence)endTime)) {
            where = where + " and ttt.f_time <= '" + MAppMediaServiceImpl.converTime(endTime) + "'";
        }
        if (type != null) {
            where = where + " and ttt.f_type = '" + type + "'";
        }
        if (StringUtils.isNotBlank((CharSequence)sortParam)) {
            sql = sortParam.contains("DESC") ? sql + " order by s.f_time desc limit " + rows + " offset " + (page - 1) * rows : sql + " order by s.f_time asc limit " + rows + " offset " + (page - 1) * rows;
        }
        List mediaList = this.jdbcTemplate.queryForList(sql.replace("AAAAAA", where));
        ArrayList<AppMedia> appMediaList = new ArrayList<AppMedia>();
        if (mediaList.size() > 0) {
            for (HashMap<String, Object> map2 : mediaList) {
                String url;
                AppMedia appMedia = (AppMedia)JSON.parseObject((String)JSON.toJSONString((Object)map2), AppMedia.class);
                if (map2.get("type1") != null) {
                    appMedia.setType(Integer.valueOf(map2.get("type1").toString()));
                }
                if (map2.get("time1") != null) {
                    appMedia.setTime(map2.get("time1").toString());
                }
                if (map2.get("area1") != null) {
                    appMedia.setArea(Double.valueOf(map2.get("area1").toString()));
                }
                if (appMedia.getServerpath() != null && !appMedia.getServerpath().contains("AccessKeyId") && StringUtils.isNotBlank((CharSequence)(url = this.temporarySignedUrlService.getTemporarySignedUrl("", appMedia.getServerpath(), null)))) {
                    appMedia.setServerpath(url);
                }
                appMediaList.add(appMedia);
            }
        }
        Long mediaCount = (Long)this.jdbcTemplate.queryForObject(countsql.replace("AAAAAA", where), Long.class);
        map2 = new HashMap<String, Object>();
        map2.put("list", appMediaList);
        map2.put("total", mediaCount);
        return map2;
    }

    public Map<String, Object> getMediaGroupList(Long userId, String taskId, String galleryId, String groupCode, String userName, String startTime, String endTime) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("groupCode", null);
        String temsql = "select s.f_id id,s.f_galleryid galleryid,s.f_type as type1,s.f_time as time1,s.f_lon lon,s.f_lat lat,s.f_azimuth azimuth,s.f_pitch pitch,s.f_shape shape,s.f_videorecord videorecord,s.f_serverpath serverpath,s.f_mediatimelength mediatimelength,s.f_mediasize mediasize,s.f_fileid fileId,s.f_downloadurl downloadUrl,s.f_mark mark,s.f_typetype typetype,s.f_username username,s.f_group_code groupCode,s.f_media metaInfo,s.f_jym jym,s.f_viewurl viewUrl,s.f_appkey appKey,s.f_createtime createTime,s.f_tilestate tileState,s.f_tileurl tileUrl,s.f_scale scale,s.f_psgd psgd,s.f_takeofflon takeOffLon,s.f_takeofflat takeOffLat,s.f_takeoffrelheight takeOffHeight,s.f_device_source deviceSource,s.f_takeOffAltitude takeOffAltitude,s.f_psAltitude psAltitude,s.f_copyid copyid,s.f_bizid bizId,s.f_fromsource fromSource,s.f_tablename tableName,s.f_35mmfocal f35mmfocal,s.f_roll roll,s.f_dimwidth dimWidth,s.f_dimheight dimHeight,s.f_area area1,s.f_sm3 sm3 from tb_app_media s  where f_device_source in('0','1')";
        String where = " and  f_galleryid ='" + galleryId + "' ";
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            where = where + " and f_username like '%" + userName + "%'";
        }
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            where = where + " and f_time >='" + MAppMediaServiceImpl.converTime(startTime) + "'";
        }
        if (StringUtils.isNotBlank((CharSequence)endTime)) {
            where = where + " and f_time <= '" + MAppMediaServiceImpl.converTime(endTime) + "'";
        }
        if (StringUtils.isNotBlank((CharSequence)groupCode)) {
            if ("1".equals(groupCode)) {
                String timeSql = "select to_char(to_timestamp((left(f_time,10))::int),'yyyy') as groupname,count(1) from tb_app_media tam  where f_device_source in('0','1') " + where + " group by groupname";
                List mapList = this.jdbcTemplate.queryForList(timeSql);
                resultMap.put("groupCode", mapList);
                JSONObject jsonObject = new JSONObject();
                for (Map map : mapList) {
                    String time = map.get("groupname").toString();
                    String sql = temsql + where + " and to_char(to_timestamp((left(f_time,10))::int),'yyyy')  = '" + time + "' order by f_time desc";
                    List mediaList = this.jdbcTemplate.queryForList(sql);
                    jsonObject.put(time, this.mapConvertObject(mediaList));
                }
                resultMap.put("groupList", jsonObject);
            } else if ("2".equals(groupCode)) {
                String timeSql = "select to_char(to_timestamp((left(f_time,10))::int),'YYYY-MM') as groupname,count(1) from tb_app_media tam  where f_device_source in('0','1') " + where + " group by groupname";
                List mapList = this.jdbcTemplate.queryForList(timeSql);
                resultMap.put("groupCode", mapList);
                JSONObject jsonObject = new JSONObject();
                for (Map map : mapList) {
                    String time = map.get("groupname").toString();
                    String sql = temsql + where + " and to_char(to_timestamp((left(f_time,10))::int),'YYYY-MM')  = '" + time + "' order by f_time desc";
                    List mediaList = this.jdbcTemplate.queryForList(sql);
                    jsonObject.put(time, this.mapConvertObject(mediaList));
                }
                resultMap.put("groupList", jsonObject);
            } else if ("3".equals(groupCode)) {
                String timeSql = "select f_username as groupname,count(1) from tb_app_media  where f_device_source in('0','1') " + where + " group by f_username";
                List mapList = this.jdbcTemplate.queryForList(timeSql);
                resultMap.put("groupCode", mapList);
                JSONObject jsonObject = new JSONObject();
                for (Map map : mapList) {
                    String f_username = map.get("groupname").toString();
                    String sql2 = temsql + where + " and f_username  = '" + f_username + "' order by f_time desc";
                    List mediaList = this.jdbcTemplate.queryForList(sql2);
                    jsonObject.put(f_username, this.mapConvertObject(mediaList));
                }
                resultMap.put("groupList", jsonObject);
            } else if ("4".equals(groupCode)) {
                String sql;
                ArrayList groupList = new ArrayList();
                JSONObject jsonObject = new JSONObject();
                ArrayList allUserName = new ArrayList();
                String xjSql = "select distinct (tu.f_username) from tbtsk_right_area tra,tbsys_user tu  where cast(tra.f_userid AS numeric) = tu.f_userid and  f_taskid ='" + taskId + "'";
                List mapList = this.jdbcTemplate.queryForList(xjSql);
                ArrayList<String> userNames = new ArrayList<String>();
                for (Map map : mapList) {
                    userNames.add(map.get("f_username").toString());
                }
                if (userNames.size() > 0) {
                    allUserName.addAll(userNames);
                    String sql2 = temsql + where + " and f_username in('" + String.join((CharSequence)"','", userNames) + "') order by f_time desc";
                    List mediaList = this.jdbcTemplate.queryForList(sql2);
                    jsonObject.put("\u53bf\u7ea7", this.mapConvertObject(mediaList));
                    HashMap<String, Object> xjMap = new HashMap<String, Object>();
                    xjMap.put("count", mediaList.size());
                    xjMap.put("groupname", "\u53bf\u7ea7");
                    groupList.add(xjMap);
                }
                String citySql = "select distinct (tu.f_username) from tbtsk_user_audit_area tra,tbsys_user tu  where cast(tra.f_userid AS numeric) = tu.f_userid and  f_taskid ='" + taskId + "' and tra.f_level ='2'";
                List cityList = this.jdbcTemplate.queryForList(citySql);
                ArrayList<String> cityuserNames = new ArrayList<String>();
                for (Map map : cityList) {
                    cityuserNames.add(map.get("f_username").toString());
                }
                if (cityuserNames.size() > 0) {
                    allUserName.addAll(cityuserNames);
                    String sql3 = temsql + where + " and f_username  in('" + String.join((CharSequence)"','", cityuserNames) + "') order by f_time desc";
                    List mediaList = this.jdbcTemplate.queryForList(sql3);
                    jsonObject.put("\u5e02\u7ea7", this.mapConvertObject(mediaList));
                    HashMap<String, Object> cityMap = new HashMap<String, Object>();
                    cityMap.put("count", mediaList.size());
                    cityMap.put("groupname", "\u5e02\u7ea7");
                    groupList.add(cityMap);
                }
                String sjSql = "select distinct (tu.f_username) from tbtsk_user_audit_area tra,tbsys_user tu  where cast(tra.f_userid AS numeric) = tu.f_userid and  f_taskid ='" + taskId + "' and tra.f_level ='1'";
                List sjList = this.jdbcTemplate.queryForList(sjSql);
                ArrayList<String> sjuserNames = new ArrayList<String>();
                for (Map map : sjList) {
                    sjuserNames.add(map.get("f_username").toString());
                }
                if (sjuserNames.size() > 0) {
                    allUserName.addAll(sjuserNames);
                    sql = temsql + where + " and f_username in('" + String.join((CharSequence)"','", sjuserNames) + "') order by f_time desc";
                    List mediaList = this.jdbcTemplate.queryForList(sql);
                    jsonObject.put("\u7701\u7ea7", this.mapConvertObject(mediaList));
                    HashMap<String, Object> sjMap = new HashMap<String, Object>();
                    sjMap.put("count", mediaList.size());
                    sjMap.put("groupname", "\u7701\u7ea7");
                    groupList.add(sjMap);
                }
                if (!allUserName.isEmpty()) {
                    sql = temsql + where + " and f_username not in('" + String.join((CharSequence)"','", allUserName) + "') order by f_time desc";
                    List maps = this.jdbcTemplate.queryForList(sql);
                    Object xj = jsonObject.get((Object)"\u53bf\u7ea7");
                    if (xj != null) {
                        List temp = (List)xj;
                        temp.addAll(this.mapConvertObject(maps));
                        resultMap.put("\u53bf\u7ea7", temp);
                    } else {
                        resultMap.put("\u53bf\u7ea7", this.mapConvertObject(maps));
                    }
                }
                resultMap.put("groupCode", groupList);
                resultMap.put("groupList", jsonObject);
            }
        }
        return resultMap;
    }

    public List<AppMedia> getMedia(String excludeFrom, String excludeGid, String wkt, String startTime, String endTime, Integer limit) throws Exception {
        List maps;
        SimpleDateFormat df;
        String sql = "select f_id as id,f_galleryid as galleryid,f_type as type,f_time as time,f_lon as lon,f_lat as lat,f_azimuth as azimuth,f_pitch as pitch,f_serverpath as serverpath,f_mediasize as mediasize,f_mark as mark,f_typetype as typetype,f_username as username,f_group_code as groupCode,f_psgd as psgd,f_takeofflon as takeOffLon,f_takeofflat as takeOffLat,f_takeoffrelheight as takeOffHeight,f_device_source as deviceSource,f_takeoffaltitude as takeOffAltitude,f_psaltitude as psAltitude,f_copyid as copyid,f_bizid as bizId, f_fromsource as fromSource,f_psfyj as psfyj,f_zsdm as zsdm from tb_app_media where 1 =1 ";
        ArrayList<String> wheres = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)excludeGid)) {
            wheres.add("f_galleryid != '" + excludeGid + "'");
        }
        if (StringUtils.isNotBlank((CharSequence)excludeFrom)) {
            wheres.add("(f_fromsource is null or f_fromsource != '" + excludeFrom + "')");
        }
        if (StringUtils.isNotBlank((CharSequence)wkt)) {
            wheres.add(String.format("st_contains(ST_GeomFromText('%s'), st_geomfromtext('POINT(' || cast(f_lon as VARCHAR) || ' ' || cast(f_lat as VARCHAR) || ')'))", wkt));
        }
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date start = df.parse(startTime);
                wheres.add("cast(f_time as INT8) >= " + start.getTime());
            }
            catch (Exception ex) {
                throw new Exception("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u8981\u6c42\u683c\u5f0f\u5982\u4e0b:yyyy-MM-dd");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)endTime)) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date end = df.parse(endTime);
                long timestamp = end.getTime() + 86400000L;
                wheres.add("cast(f_time as INT8) <= " + timestamp);
            }
            catch (Exception ex) {
                throw new Exception("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u8981\u6c42\u683c\u5f0f\u5982\u4e0b:yyyy-MM-dd");
            }
        }
        if (!wheres.isEmpty()) {
            sql = sql + " and " + StringUtils.join(wheres, (String)" and ");
        }
        if (limit != null) {
            sql = sql + " order by f_time desc limit " + limit;
        }
        if ((maps = this.jdbcTemplate.queryForList(sql)) == null || maps.isEmpty()) {
            return null;
        }
        ArrayList<AppMedia> appMediaList = new ArrayList<AppMedia>();
        for (Map map : maps) {
            AppMedia appMedia = (AppMedia)JSON.parseObject((String)JSON.toJSONString((Object)map), AppMedia.class);
            appMediaList.add(appMedia);
        }
        return appMediaList;
    }

    public List<AppMediaCopyDto2> getMediaForHebei(String excludeFrom, String excludeGid, String wkt, String startTime, String endTime, Integer limit) throws Exception {
        List maps;
        SimpleDateFormat df;
        String sql = "select \nm.f_id as id,\nm.f_galleryid as galleryid,\nm.f_type as type,\nm.f_time as time,\nm.f_lon as lon,\nm.f_lat as lat,\nm.f_azimuth as azimuth,\nm.f_pitch as pitch,\nm.f_serverpath as serverpath,\nm.f_mediasize as mediasize,\nm.f_mark as mark,\nm.f_typetype as typetype,\nm.f_username as username,\nm.f_group_code as groupCode,\nm.f_psgd as psgd,\nm.f_takeofflon as takeOffLon,\nm.f_takeofflat as takeOffLat,\nm.f_takeoffrelheight as takeOffHeight,\nm.f_device_source as deviceSource,\nm.f_takeoffaltitude as takeOffAltitude,\nm.f_psaltitude as psAltitude,\nm.f_copyid as copyid,\nm.f_bizid as bizId, \nm.f_fromsource as fromSource,\nm.f_psfyj as psfyj,\nm.f_zsdm as zsdm \nfrom tb_app_media m\nwhere 1 =1  ";
        ArrayList<String> wheres = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)excludeGid)) {
            wheres.add("m.f_galleryid != '" + excludeGid + "'");
        }
        if (StringUtils.isNotBlank((CharSequence)excludeFrom)) {
            wheres.add("(m.f_fromsource is null or m.f_fromsource != '" + excludeFrom + "')");
        }
        if (StringUtils.isNotBlank((CharSequence)wkt)) {
            wheres.add(String.format("st_contains(ST_GeomFromText('%s'), st_geomfromtext('POINT(' || cast(m.f_lon as VARCHAR) || ' ' || cast(m.f_lat as VARCHAR) || ')'))", wkt));
        }
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date start = df.parse(startTime);
                wheres.add("cast(m.f_time as INT8) >= " + start.getTime());
            }
            catch (Exception ex) {
                throw new Exception("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u8981\u6c42\u683c\u5f0f\u5982\u4e0b:yyyy-MM-dd");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)endTime)) {
            df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date end = df.parse(endTime);
                long timestamp = end.getTime() + 86400000L;
                wheres.add("cast(m.f_time as INT8) <= " + timestamp);
            }
            catch (Exception ex) {
                throw new Exception("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u8981\u6c42\u683c\u5f0f\u5982\u4e0b:yyyy-MM-dd");
            }
        }
        if (!wheres.isEmpty()) {
            sql = sql + " and " + StringUtils.join(wheres, (String)" and ");
        }
        sql = sql + " order by m.f_time desc ";
        if (limit != null) {
            sql = sql + " limit " + limit;
        }
        if ((maps = this.jdbcTemplate.queryForList(sql)) == null || maps.isEmpty()) {
            return null;
        }
        ArrayList<AppMediaCopyDto2> appMediaList = new ArrayList<AppMediaCopyDto2>();
        for (Map map : maps) {
            AppMediaCopyDto2 appMedia = (AppMediaCopyDto2)JSON.parseObject((String)JSON.toJSONString((Object)map), AppMediaCopyDto2.class);
            appMedia.formatYearMonth();
            appMediaList.add(appMedia);
        }
        return appMediaList;
    }

    public List<AppMedia> mapConvertObject(List<Map<String, Object>> mediaList) {
        ArrayList<AppMedia> appMediaList = new ArrayList<AppMedia>();
        if (mediaList.size() > 0) {
            for (Map<String, Object> map : mediaList) {
                String url;
                AppMedia appMedia = (AppMedia)JSON.parseObject((String)JSON.toJSONString(map), AppMedia.class);
                if (map.get("type1") != null) {
                    appMedia.setType(Integer.valueOf(map.get("type1").toString()));
                }
                if (map.get("time1") != null) {
                    appMedia.setTime(map.get("time1").toString());
                }
                if (map.get("area1") != null) {
                    appMedia.setArea(Double.valueOf(map.get("area1").toString()));
                }
                if (appMedia.getServerpath() != null && StringUtils.isNotBlank((CharSequence)appMedia.getServerpath()) && !appMedia.getServerpath().contains("AccessKeyId") && StringUtils.isNotBlank((CharSequence)(url = this.temporarySignedUrlService.getTemporarySignedUrl("", appMedia.getServerpath(), null)))) {
                    appMedia.setServerpath(url);
                }
                appMediaList.add(appMedia);
            }
        }
        return appMediaList;
    }

    public static Long converTime(String time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Long resulttime = 0L;
        try {
            Date date = format.parse(time);
            resulttime = date.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return resulttime;
    }

    public static List<GeoPoint> getPhotoRangePosList(Projection proj, double altitude, double orientation, double yuntai, double angleOfView, double lon, double lat, boolean isFollowOrientation, float ratio) {
        if (yuntai >= 0.0) {
            return null;
        }
        GeoPoint gp_aircraft = new GeoPoint(lon, lat);
        double r = yuntai == -90.0 ? 0.0 : altitude / Math.tan(Math.abs(Math.toRadians(yuntai)));
        double x = gp_aircraft.getX() + r * Math.sin(Math.toRadians(orientation));
        double y = gp_aircraft.getY() + r * Math.cos(Math.toRadians(orientation));
        GeoPoint mapPos = new GeoPoint(lon, lat);
        double h = altitude * Math.tan(Math.toRadians(angleOfView / 2.0));
        ArrayList<GeoPoint> mapPosList = new ArrayList<GeoPoint>();
        if (isFollowOrientation) {
            double radOri = Math.toRadians(orientation);
            GeoPoint mapPosLeftTop = new GeoPoint(mapPos.getX() - h * (Math.cos(radOri) - (double)ratio * Math.sin(radOri)), mapPos.getY() + h * (Math.cos(radOri) + (double)ratio * Math.sin(radOri)));
            GeoPoint mapPosRightTop = new GeoPoint(mapPos.getX() + h * (Math.cos(radOri) + (double)ratio * Math.sin(radOri)), mapPos.getY() + h * (Math.cos(radOri) - (double)ratio * Math.sin(radOri)));
            GeoPoint mapPosRightBottom = new GeoPoint(mapPos.getX() + h * (Math.cos(radOri) - (double)ratio * Math.sin(radOri)), mapPos.getY() - h * (Math.cos(radOri) + (double)ratio * Math.sin(radOri)));
            GeoPoint mapPosLeftBottom = new GeoPoint(mapPos.getX() - h * (Math.cos(radOri) + (double)ratio * Math.sin(radOri)), mapPos.getY() - h * (Math.cos(radOri) - (double)ratio * Math.sin(radOri)));
            mapPosList.add(mapPosLeftTop);
            mapPosList.add(mapPosRightTop);
            mapPosList.add(mapPosRightBottom);
            mapPosList.add(mapPosLeftBottom);
        } else {
            GeoPoint mapPosLeftTop = new GeoPoint(mapPos.getX() - h, mapPos.getY() + h * (double)ratio);
            GeoPoint mapPosRightTop = new GeoPoint(mapPos.getX() + h, mapPos.getY() + h * (double)ratio);
            GeoPoint mapPosRightBottom = new GeoPoint(mapPos.getX() + h, mapPos.getY() - h * (double)ratio);
            GeoPoint mapPosLeftBottom = new GeoPoint(mapPos.getX() - h, mapPos.getY() - h * (double)ratio);
            mapPosList.add(mapPosLeftTop);
            mapPosList.add(mapPosRightTop);
            mapPosList.add(mapPosRightBottom);
            mapPosList.add(mapPosLeftBottom);
        }
        return mapPosList;
    }

    public static void main(String[] args) throws org.locationtech.jts.io.ParseException {
        List<GeoPoint> geoPoints = MAppMediaServiceImpl.getPhotoRangePosList(null, 41.8, 85.0, -14.0, 77.0, 114.496965, 30.556861, true, 1.0f);
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
        WKTReader wktReader = new WKTReader(geometryFactory);
        Geometry geometry = wktReader.read("POINT (113.53896635 22.36429837)");
        WKBReader wkbReader = new WKBReader(geometryFactory);
        Coordinate coordinate = new Coordinate(114.496965, 30.556861);
        Point point = geometryFactory.createPoint(coordinate);
        Polygon polygon = geometryFactory.createPolygon(new Coordinate[]{new Coordinate(geoPoints.get(0).getX(), geoPoints.get(0).getY()), new Coordinate(geoPoints.get(1).getX(), geoPoints.get(1).getY()), new Coordinate(geoPoints.get(2).getX(), geoPoints.get(2).getY()), new Coordinate(geoPoints.get(3).getX(), geoPoints.get(3).getY()), new Coordinate(geoPoints.get(0).getX(), geoPoints.get(0).getY())});
        Point geometry1 = point;
        Polygon geometry2 = polygon;
        WKTWriter wktWriter = new WKTWriter();
        String write = wktWriter.write((Geometry)point);
    }
}

