/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.servface.pub.MPatrolPlanScopeKeyAreaService;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanScopeKeyAreaMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanScopeMapper;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlan;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanScope;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanScopeKeyArea;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MPatrolPlanScopeKeyAreaServiceImpl
implements MPatrolPlanScopeKeyAreaService {
    @Autowired
    PatrolPlanScopeKeyAreaMapper patrolPlanScopeKeyAreaMapper;
    @Autowired
    RegionVillageRepository regionVillageRepository;
    @Autowired
    PatrolPlanMapper patrolPlanMapper;
    @Autowired
    PatrolPlanScopeMapper patrolPlanScopeMapper;

    public void createKeyArea(String planId, String scopeId, JSONArray array) throws ParseException {
        PatrolPlan one = (PatrolPlan)this.patrolPlanMapper.selectByPrimaryKey((Object)planId);
        PatrolPlanScope one1 = (PatrolPlanScope)this.patrolPlanScopeMapper.selectByPrimaryKey((Object)scopeId);
        if (one == null || one1 == null) {
            throw new RuntimeException("\u8ba1\u5212\u6216\u8ba1\u5212\u8303\u56f4\u4e0d\u5b58\u5728");
        }
        String maxId = this.patrolPlanScopeKeyAreaMapper.queryMaxByPlanIdAndScopeId(planId, scopeId);
        if (StringUtils.isBlank((CharSequence)maxId)) {
            maxId = "-1";
        }
        int index = Integer.parseInt(maxId);
        ArrayList<PatrolPlanScopeKeyArea> keyAreas = new ArrayList<PatrolPlanScopeKeyArea>();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject object = array.getJSONObject(i);
            ++index;
            PatrolPlanScopeKeyArea keyArea = new PatrolPlanScopeKeyArea();
            String wkt = object.getString("wkt");
            String area = object.getString("area");
            Geometry geometry = WKTUtil.wktToGeom((String)wkt);
            List regionVillages = this.regionVillageRepository.queryContains1(wkt);
            if (regionVillages != null && !regionVillages.isEmpty()) {
                RegionVillage regionVillage = (RegionVillage)regionVillages.get(0);
                keyArea.setfXzqdm(regionVillage.getCode());
                keyArea.setfXzqmc(regionVillage.getName());
            }
            keyArea.setfDkbh("ZD" + String.format("%04d", index));
            keyArea.setfArea(area);
            keyArea.setfPlanid(planId);
            keyArea.setfScopeid(scopeId);
            keyArea.setfShape((Object)geometry);
            keyArea.setfId(UUID.randomUUID().toString());
            keyAreas.add(keyArea);
        }
        if (!keyAreas.isEmpty()) {
            this.patrolPlanScopeKeyAreaMapper.insertList(keyAreas);
        }
    }

    public List<PatrolPlanScopeKeyArea> getByPlanId(String planId) {
        return this.patrolPlanScopeKeyAreaMapper.getByPlanId(planId);
    }

    public void deleteById(String id) {
        this.patrolPlanScopeKeyAreaMapper.deleteByPrimaryKey((Object)id);
    }
}

