/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.pub.impl;

import com.geoway.landteam.landcloud.common.oss.OssConfig;
import com.geoway.landteam.landcloud.core.repository.pub.OssConfigRepository;
import com.geoway.landteam.landcloud.servface.pub.MinIOService;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MinIOServiceImpl
implements MinIOService {
    private MinioClient minioClient;
    private MinioClient innerMinioClient;
    private OssConfig config;
    @Autowired
    private OssConfigRepository ossConfigDao;

    public void addToBucket(String bucketPath, String filePath) throws Exception {
        MinioClient client = this.getInnerMinioClient();
        OssConfig ossConfig = this.getConfig();
        bucketPath = bucketPath.replace("\\", "/");
        FileInputStream is = new FileInputStream(filePath);
        long size = ((InputStream)is).available();
        long partSize = 102400L;
        PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(ossConfig.getBucketName())).object(filePath)).stream((InputStream)is, size, partSize).build();
        client.putObject(args);
    }

    public String getUrl(String objectName) throws Exception {
        objectName = objectName.replace("\\", "/");
        OssConfig ossConfig = this.getConfig();
        GetPresignedObjectUrlArgs args = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().expiry(3600, TimeUnit.SECONDS).bucket(ossConfig.getBucketName())).object(objectName)).build();
        return this.getMinioClient().getPresignedObjectUrl(args);
    }

    public byte[] getByte(String objectName) throws Exception {
        objectName = objectName.replace("\\", "/");
        OssConfig ossConfig = this.getConfig();
        GetObjectArgs args = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(ossConfig.getBucketName())).object(objectName)).build();
        GetObjectResponse inputStream = this.getMinioClient().getObject(args);
        byte[] result = IOUtils.toByteArray((InputStream)inputStream);
        inputStream.close();
        return result;
    }

    public String getHeaderUrl() {
        return this.getConfig().getEndPoint();
    }

    private OssConfig getConfig() {
        if (null == this.config) {
            OssConfig config;
            this.config = config = this.ossConfigDao.queryByType("minio");
        }
        return this.config;
    }

    private MinioClient getMinioClient() {
        if (null == this.minioClient) {
            OssConfig config = this.getConfig();
            this.innerMinioClient = MinioClient.builder().endpoint(config.getEndPoint()).credentials(config.getKey(), config.getKeySecret()).build();
        }
        return this.minioClient;
    }

    private MinioClient getInnerMinioClient() {
        if (null == this.innerMinioClient) {
            OssConfig config = this.getConfig();
            this.innerMinioClient = MinioClient.builder().endpoint(config.getInnerEndPoint()).credentials(config.getKey(), config.getKeySecret()).build();
        }
        return this.innerMinioClient;
    }
}

