/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.satelliteCenter;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.dto.TbtskTaskPiwenDto;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.oss.OssConfig;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.dao.pub.AppMediaDao;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.pub.OssConfigRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.dao.satelliteCenter.TbWxzxRecordDao;
import com.geoway.landteam.landcloud.mapper.satelliteCenter.TbWxzxRecordFileMapper;
import com.geoway.landteam.landcloud.model.satelliteCenter.dto.ReportDataDto;
import com.geoway.landteam.landcloud.model.satelliteCenter.dto.ReportFileDto;
import com.geoway.landteam.landcloud.model.satelliteCenter.entity.TbWxzxRecord;
import com.geoway.landteam.landcloud.model.satelliteCenter.entity.TbWxzxRecordFile;
import com.geoway.landteam.landcloud.servface.base.dto.AppMediaDTO;
import com.geoway.landteam.landcloud.servface.other.ImportOtherDataService;
import com.geoway.landteam.landcloud.servface.satelliteCenter.TbWxzxRecordService;
import com.geoway.landteam.landcloud.service.customtask.task.TbtskTaskPiwenService;
import com.gw.base.gpa.entity.GiEntityAlterable;
import com.gw.base.gpa.entity.GiEntitySaveable;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilStr;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class TbWxzxRecordServiceImpl
implements TbWxzxRecordService {
    private final GiLoger logger = GwLoger.getLoger(TbWxzxRecordServiceImpl.class);
    @Value(value="${project.downloadDir}")
    String localDownload;
    @Value(value="${project.uploadDir}")
    String localUpload;
    @Value(value="${satelliteCenter.loginUrl}")
    String serverLoginUrl;
    @Value(value="${satelliteCenter.infoUrl}")
    String serverInfoUrl;
    @Value(value="${satelliteCenter.fileUrl}")
    String serverFileUrl;
    @Value(value="${satelliteCenter.username}")
    String serverUsername;
    @Value(value="${satelliteCenter.password}")
    String serverPassword;
    @Resource
    TbWxzxRecordDao tbWxzxRecordDao;
    @Resource
    TbWxzxRecordFileMapper tbWxzxRecordFileMapper;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Resource
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Autowired
    TbtskTaskPiwenService tbtskTaskPiwenService;
    @Autowired
    AppMediaDao appMediaDao;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    ImportOtherDataService importOtherDataService;
    @Autowired
    OssConfigRepository ossConfigRepository;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    private static Map<String, OssConfig> mapOssConfig = new HashMap<String, OssConfig>();

    public TbWxzxRecord saveOrUpdate(TbWxzxRecord tbWxzxRecord) {
        if (StringUtils.isNotEmpty((CharSequence)tbWxzxRecord.getId())) {
            this.tbWxzxRecordDao.gwUpdateByPK((GiEntityAlterable)tbWxzxRecord);
        } else {
            tbWxzxRecord.setId(UUID.randomUUID().toString().replace("-", ""));
            this.tbWxzxRecordDao.gwAccess((GiEntitySaveable)tbWxzxRecord);
        }
        return tbWxzxRecord;
    }

    public TbWxzxRecordFile saveOrUpdateFile(TbWxzxRecordFile tbWxzxRecordFile) {
        if (StringUtils.isNotEmpty((CharSequence)tbWxzxRecordFile.getId())) {
            this.tbWxzxRecordFileMapper.gwUpdateByPK((GiEntityAlterable)tbWxzxRecordFile);
        } else {
            tbWxzxRecordFile.setId(UUID.randomUUID().toString().replace("-", ""));
            this.tbWxzxRecordFileMapper.gwAccess((GiEntitySaveable)tbWxzxRecordFile);
        }
        return tbWxzxRecordFile;
    }

    public Map<String, TbWxzxRecordFile> findFilesInfo(String dkid, String taskid) {
        List ls = this.tbWxzxRecordFileMapper.selectByTaskidAndDkid(taskid, dkid);
        if (ls == null) {
            return new HashMap<String, TbWxzxRecordFile>();
        }
        return ls.stream().collect(Collectors.toMap(TbWxzxRecordFile::getLocalUrl, item -> item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateReportData(Map<String, Object> map, String taskId, String token) {
        TbWxzxRecord tbWxzxRecord = new TbWxzxRecord();
        tbWxzxRecord.setTbid(map.get("f_id").toString());
        tbWxzxRecord.setTaskid(taskId);
        tbWxzxRecord.setTime(new Date());
        try {
            Long times;
            String[] arr;
            String errMsg = "";
            ReportDataDto reportDataDto = new ReportDataDto();
            String zgqk = String.valueOf(map.get("f_zglsqk"));
            boolean isBb = false;
            boolean isCcfk = false;
            for (String string : arr = zgqk.split("&")) {
                if ("\u8865\u529e\u624b\u7eed".equals(string)) {
                    isBb = true;
                    continue;
                }
                if (!"\u62c6\u9664\u590d\u8015".equals(string)) continue;
                isCcfk = true;
            }
            if (map.get("f_dkbh") != null) {
                reportDataDto.setDkbh(String.valueOf(map.get("f_dkbh")));
            } else {
                errMsg = errMsg + "\u5730\u5757\u7f16\u53f7\u4e3a\u7a7a;";
            }
            if (map.get("f_xzqdm") != null) {
                String xzqdm = String.valueOf(map.get("f_xzqdm"));
                if (xzqdm.length() > 6) {
                    xzqdm = xzqdm.substring(0, 6);
                }
                reportDataDto.setXzqdm(xzqdm);
            } else {
                errMsg = errMsg + "\u884c\u653f\u533a\u4ee3\u7801\u4e3a\u7a7a;";
            }
            String year = "";
            if (map.get("f_jcpc") != null) {
                year = String.valueOf(map.get("f_jcpc"));
                reportDataDto.setYear(year);
            } else {
                errMsg = errMsg + "\u5e74\u4efd\u4e3a\u7a7a;";
            }
            reportDataDto.setZglsdw(Integer.valueOf(1));
            if (map.get("f_hftdy_n2") != null) {
                reportDataDto.setCcmj(Double.valueOf(Double.parseDouble(map.get("f_hftdy_n2").toString())));
            } else if (isCcfk) {
                errMsg = errMsg + "\u62c6\u9664\u590d\u57a6\uff08\u8015\uff09\u9762\u79ef\u4e3a\u7a7a;";
            } else {
                reportDataDto.setCcmj(Double.valueOf(0.0));
            }
            if (map.get("f_fgdwmj") != null) {
                reportDataDto.setCcgdmj(Double.valueOf(Double.parseDouble(map.get("f_fgdwmj").toString())));
            } else if (isCcfk) {
                errMsg = errMsg + "\u62c6\u9664\u590d\u57a6\uff08\u8015\uff09\u5176\u4e2d\u8015\u5730\u9762\u79ef\u4e3a\u7a7a;";
            } else {
                reportDataDto.setCcgdmj(Double.valueOf(0.0));
            }
            if (map.get("f_ccyjj_n2") != null) {
                reportDataDto.setCcyjjbntmj(Double.valueOf(Double.parseDouble(map.get("f_ccyjj_n2").toString())));
            } else if (isCcfk) {
                errMsg = errMsg + "\u62c6\u9664\u590d\u57a6\uff08\u8015\uff09\u5176\u4e2d\u6c38\u4e45\u57fa\u672c\u519c\u7530\u9762\u79ef\u4e3a\u7a7a;";
            } else {
                reportDataDto.setCcyjjbntmj(Double.valueOf(0.0));
            }
            if (map.get("f_bbmjm_n1") != null) {
                reportDataDto.setWsmj(Double.valueOf(Double.parseDouble(map.get("f_bbmjm_n1").toString())));
            } else if (isBb) {
                errMsg = errMsg + "\u5b8c\u5584\u7528\u5730\u624b\u7eed\u9762\u79ef\u4e3a\u7a7a;";
            } else {
                reportDataDto.setWsmj(Double.valueOf(0.0));
            }
            if (map.get("f_bbgdmj") != null) {
                reportDataDto.setWsgdmj(Double.valueOf(Double.parseDouble(map.get("f_bbgdmj").toString())));
            } else if (isBb) {
                errMsg = errMsg + "\u5b8c\u5584\u7528\u5730\u624b\u7eed\u5176\u4e2d\u8015\u5730\u9762\u79ef\u4e3a\u7a7a;";
            } else {
                reportDataDto.setWsgdmj(Double.valueOf(0.0));
            }
            if (map.get("f_bbjbntmj") != null) {
                reportDataDto.setWsyjjbntmj(Double.valueOf(Double.parseDouble(map.get("f_bbjbntmj").toString())));
            } else if (isBb) {
                errMsg = errMsg + "\u5b8c\u5584\u7528\u5730\u624b\u7eed\u5176\u4e2d\u6c38\u4e45\u57fa\u672c\u519c\u7530\u9762\u79ef\u4e3a\u7a7a;";
            } else {
                reportDataDto.setWsyjjbntmj(Double.valueOf(0.0));
            }
            Long l = times = this.findReportTimes(tbWxzxRecord.getTbid(), tbWxzxRecord.getTaskid());
            Long l2 = times = Long.valueOf(times + 1L);
            reportDataDto.setTimes(Integer.valueOf(times.intValue()));
            reportDataDto.setTaskStatus(Integer.valueOf(31));
            if (map.get("f_committime") != null) {
                reportDataDto.setLastSubmitTime(Long.valueOf(Long.parseLong(map.get("f_committime").toString())));
            } else {
                errMsg = errMsg + "\u586b\u62a5\u6700\u540e\u63d0\u4ea4\u65f6\u95f4\u4e3a\u7a7a;";
            }
            if (map.get("f_upload_userid") != null) {
                reportDataDto.setReportPerson(map.get("f_upload_userid").toString());
                reportDataDto.setHeadPerson(map.get("f_upload_userid").toString());
            } else {
                errMsg = errMsg + "\u586b\u62a5\u4eba\u3001\u8d1f\u8d23\u4eba\u4e3a\u7a7a;";
            }
            if (map.get("f_approve_user") != null) {
                reportDataDto.setCheckName(map.get("f_approve_user").toString());
            } else {
                errMsg = errMsg + "\u7701\u7ea7\u5ba1\u6838\u4eba\u540d\u79f0\u4e3a\u7a7a;";
            }
            if (map.get("f_approve_time") != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                reportDataDto.setCheckTime(Long.valueOf(sdf.parse(map.get("f_approve_time").toString()).getTime()));
            } else {
                errMsg = errMsg + "\u7701\u7ea7\u5ba1\u6838\u901a\u8fc7\u65f6\u95f4\u4e3a\u7a7a;";
            }
            tbWxzxRecord.setRegionCode(reportDataDto.getXzqdm());
            try {
                String dkbh = String.valueOf(map.get("f_id").toString());
                Map<String, TbWxzxRecordFile> map2 = this.findFilesInfo(dkbh, taskId);
                if (StringUtils.isEmpty((CharSequence)errMsg)) {
                    ArrayList<String> errLs = new ArrayList<String>();
                    boolean isHaveFile = false;
                    ArrayList<ReportFileDto> attatchs = new ArrayList<ReportFileDto>();
                    List<ReportFileDto> files1 = this.findTaskTbPiwen(map2, taskId, map.get("f_id").toString(), year, token, errLs);
                    if (!files1.isEmpty()) {
                        attatchs.addAll(files1);
                        isHaveFile = true;
                    }
                    HashMap<String, Boolean> flgMap = new HashMap<String, Boolean>();
                    flgMap.put("ccfkHave", false);
                    flgMap.put("bbHave", false);
                    List<ReportFileDto> files2 = this.findTaskMediaFile(map2, taskId, map.get("f_id").toString(), year, token, zgqk, flgMap, errLs);
                    if (!files2.isEmpty()) {
                        attatchs.addAll(files2);
                    }
                    if (isBb && !isHaveFile && !((Boolean)flgMap.get("bbHave")).booleanValue()) {
                        errMsg = errMsg + "\u5f53\u586b\u5199\u5b8c\u5584\u7528\u5730\u624b\u7eed\u9762\u79ef\u65f6\uff0c\u5fc5\u987b\u4e0a\u4f20\u8bc1\u660e\u6750\u6599;";
                    }
                    if (isCcfk && !((Boolean)flgMap.get("ccfkHave")).booleanValue()) {
                        errMsg = errMsg + "\u5f53\u586b\u5199\u62c6\u9664\u590d\u57a6\uff08\u8015\uff09\u9762\u79ef\u65f6\uff0c\u5fc5\u987b\u4e0a\u4f20\u5916\u4e1a\u7167\u7247;";
                    }
                    if (attatchs == null || attatchs.isEmpty()) {
                        errMsg = errMsg + "\u6ca1\u6709\u4efb\u52a1\u9644\u4ef6\u4fe1\u606f;";
                    }
                    reportDataDto.setFiles(attatchs);
                    if (StringUtils.isEmpty((CharSequence)errMsg)) {
                        tbWxzxRecord.setTbRecord(JSONObject.toJSONString((Object)reportDataDto));
                        this.reportData(token, reportDataDto, tbWxzxRecord);
                        tbWxzxRecord.setTbState(Integer.valueOf(1));
                    } else {
                        tbWxzxRecord.setTbState(Integer.valueOf(2));
                    }
                    if (!errLs.isEmpty()) {
                        errMsg = errMsg + String.join((CharSequence)"**\u9644\u4ef6\u9519\u8bef:", errLs);
                    }
                } else {
                    tbWxzxRecord.setTbState(Integer.valueOf(2));
                }
            }
            catch (Exception ex) {
                errMsg = errMsg + ex.getMessage();
                tbWxzxRecord.setTbState(Integer.valueOf(2));
            }
            tbWxzxRecord.setTbErr(errMsg);
        }
        catch (Exception e) {
            tbWxzxRecord.setTbState(Integer.valueOf(2));
            tbWxzxRecord.setTbErr(e.getMessage());
        }
        finally {
            this.saveOrUpdate(tbWxzxRecord);
        }
    }

    public void startReportData() {
        String taskId = "e6dcb7e3-0b7c-4964-b77c-6f07e8acaf01";
        try {
            String token = this.getToken();
            List<Map<String, Object>> reportList = this.findUnReportData(taskId);
            if (reportList != null && !reportList.isEmpty()) {
                for (Map<String, Object> map : reportList) {
                    this.updateReportData(map, taskId, token);
                }
            }
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage(), new Object[0]);
        }
    }

    public Long findReportTimes(String tbid, String taskid) {
        String sql = "select count(1) as ct from tb_wxzx_record where tb_state=1 and tbid='" + tbid + "' and taskid='" + taskid + "'";
        Map map = this.jdbcTemplate.queryForMap(sql);
        return Long.parseLong(map.get("ct").toString());
    }

    public List<Map<String, Object>> findUnReportData(String taskId) throws Exception {
        TskTaskBiz task = this.tskTaskBizService.findByTaskId(taskId);
        if (task == null) {
            throw new Exception("\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        TbtskObjectinfo objectinfo = this.tbtskObjectinfoRepository.getObjectByTableId(task.getTableId());
        if (objectinfo == null) {
            throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)objectinfo.getfTablename())) {
            throw new Exception("\u4efb\u52a1\u8868\u5bf9\u8c61\u8868\u540d\u4e3a\u7a7a");
        }
        String sql = " select m.bdkbh as f_dkbh,m.is_unique,t.f_id,t.f_zglsqk,t.f_xzqdm,t.f_jcpc,t.f_hftdy_n2,t.f_fgdwmj,t.f_ccyjj_n2,t.f_bbmjm_n1,t.f_bbgdmj,t.f_bbjbntmj,t.f_committime,t.f_reject_count,t.f_upload_userid,(select r.f_approve_user from tbtsk_approve_record r where r.f_tbid=t.f_id and r.f_stepname='\u7701\u7ea7\u5ba1\u6838' and r.f_taskid='" + taskId + "' and r.f_option =1 limit 1) f_approve_user,(select r.f_approve_time from tbtsk_approve_record r where r.f_tbid=t.f_id and r.f_stepname='\u7701\u7ea7\u5ba1\u6838' and r.f_taskid='" + taskId + "' and r.f_option =1 limit 1) f_approve_time from tb_1125 m left join " + objectinfo.getfTablename() + " t on m.btbbh = t.f_dkbh  where m.is_unique=0 and t.f_review_stage=101 and t.f_status=10 and  t.f_id not in (select tbid from tb_wxzx_record where (tb_state=0 or tb_state=1) and taskid='" + taskId + "') ";
        return this.jdbcTemplate.queryForList(sql);
    }

    public List<ReportFileDto> findTaskTbPiwen(Map<String, TbWxzxRecordFile> fileMap, String taskid, String tbid, String year, String token, List<String> errLs) throws Exception {
        List<TbtskTaskPiwenDto> ls = this.tbtskTaskPiwenService.findPiwenByTaskIdAndDataId(taskid, tbid, null);
        ArrayList<ReportFileDto> fileList = new ArrayList<ReportFileDto>();
        String dir = this.localDownload + File.separator + "pw";
        if (ls != null && !ls.isEmpty()) {
            for (TbtskTaskPiwenDto piwen : ls) {
                ReportFileDto dto;
                String url;
                if (StringUtils.isEmpty((CharSequence)piwen.getPzrq())) {
                    throw new Exception("\u6279\u6587\u4fe1\u606fid[" + piwen.getId() + "]:\u6279\u51c6\u65e5\u671f\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((CharSequence)piwen.getPzwh())) {
                    throw new Exception("\u6279\u6587\u4fe1\u606fid[" + piwen.getId() + "]:\u6279\u51c6\u6587\u53f7\u4e3a\u7a7a");
                }
                if (piwen.getPzmj() == null) {
                    throw new Exception("\u6279\u6587\u4fe1\u606fid[" + piwen.getId() + "]:\u6279\u51c6\u9762\u79ef\u4e3a\u7a7a");
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
                Long pzsj = sdf.parse(piwen.getPzrq()).getTime();
                String pzwh = piwen.getPzwh();
                Double pzmj = piwen.getPzmj();
                Double pznydmj = piwen.getPznydmj();
                Double pzgdmj = piwen.getPzgdmj();
                Double pzyjjbntmj = piwen.getPzyjjbntmj();
                String pzjg = piwen.getPzjg();
                String pwfj = piwen.getPwfj();
                String pwfjSl = piwen.getPwplfj();
                String pwlx = "";
                if ("1".equals(piwen.getType())) {
                    pwlx = "\u519c\u7528\u5730\u8f6c\u7528";
                } else if ("2".equals(piwen.getType())) {
                    pwlx = "\u589e\u51cf\u6302\u94a9";
                } else if ("3".equals(piwen.getType())) {
                    pwlx = "\u5de5\u77ff\u5e9f\u5f03\u5730\u590d\u57a6\u5efa\u65b0";
                } else if ("4".equals(piwen.getType())) {
                    pwlx = "\u5148\u884c\u7528\u5730";
                } else if ("5".equals(piwen.getType())) {
                    pwlx = "\u4e0d\u52a8\u4ea7\u6743\u8bc1\u4e66 \uff08\u542b\u571f\u5730\u4f7f\u7528\u6743\u8bc1\u7b49\uff09";
                } else if ("6".equals(piwen.getType())) {
                    pwlx = "\u5176\u4ed6\u5408\u6cd5\u7528\u5730\u624b\u7eed";
                } else if ("7".equals(piwen.getType())) {
                    pwlx = "\u571f\u5730\u4f9b\u5e94";
                } else if ("8".equals(piwen.getType())) {
                    pwlx = "\u8bbe\u65bd\u519c\u7528\u5730";
                } else if ("9".equals(piwen.getType())) {
                    pwlx = "\u4e34\u65f6\u7528\u5730";
                }
                if (StringUtils.isEmpty((CharSequence)piwen.getType())) {
                    throw new Exception("\u6279\u6587\u4fe1\u606fid[" + piwen.getId() + "]:\u6279\u51c6\u7c7b\u578b\u4e3a\u7a7a");
                }
                if (StringUtils.isNotEmpty((CharSequence)pwfj)) {
                    url = pwfj;
                    dto = new ReportFileDto();
                    dto.setFileType(Integer.valueOf(5));
                    dto.setPzwh(pzwh);
                    dto.setPzmj(pzmj);
                    dto.setPzsj(pzsj);
                    dto.setPznydmj(pznydmj);
                    dto.setPzgdmj(pzgdmj);
                    dto.setPzyjjbntmj(pzyjjbntmj);
                    dto.setPzjg(pzjg);
                    dto.setPwlx(pwlx);
                    try {
                        if (!this.findFileDetail(url, dto, fileMap).booleanValue()) {
                            this.getAndUploadFile(url, dto, year, token, dir);
                            this.saveFile(url, dto, taskid, tbid);
                        }
                        fileList.add(dto);
                    }
                    catch (Exception ex) {
                        errLs.add(ex.getMessage());
                        this.logger.error(ex.getMessage(), new Object[0]);
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)pwfjSl)) continue;
                url = pwfjSl;
                dto = new ReportFileDto();
                dto.setFileType(Integer.valueOf(5));
                dto.setPzwh(pzwh);
                dto.setPzmj(pzmj);
                dto.setPzsj(pzsj);
                dto.setPznydmj(pznydmj);
                dto.setPzgdmj(pzgdmj);
                dto.setPzyjjbntmj(pzyjjbntmj);
                dto.setPzjg(pzjg);
                dto.setPwlx(pwlx);
                try {
                    if (!this.findFileDetail(url, dto, fileMap).booleanValue()) {
                        this.getAndUploadFile(url, dto, year, token, dir);
                        this.saveFile(url, dto, taskid, tbid);
                    }
                    fileList.add(dto);
                }
                catch (Exception ex) {
                    errLs.add(ex.getMessage());
                    this.logger.error(ex.getMessage(), new Object[0]);
                }
            }
        }
        return fileList;
    }

    public String getToken() throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"username", (Object)this.serverUsername);
        body.add((Object)"password", (Object)this.serverPassword);
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity response = restTemplate.postForEntity(this.serverLoginUrl, (Object)requestEntity, String.class, new Object[0]);
        String res = (String)response.getBody();
        JSONObject jsonObject = JSONObject.parseObject((String)res);
        if (jsonObject.getInteger("code") == 0) {
            return jsonObject.getString("data");
        }
        throw new Exception("token\u83b7\u53d6\u5931\u8d25:" + res);
    }

    public void reportData(String token, ReportDataDto reportDataDto, TbWxzxRecord tbWxzxRecord) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        headers.setContentType(MediaType.APPLICATION_JSON);
        String jsonData = JSONObject.toJSONString((Object)reportDataDto);
        HttpEntity entity = new HttpEntity((Object)jsonData, (MultiValueMap)headers);
        ResponseEntity response = restTemplate.postForEntity(this.serverInfoUrl, (Object)entity, String.class, new Object[0]);
        String res = (String)response.getBody();
        JSONObject jsonObject = JSONObject.parseObject((String)res);
        if (jsonObject.getInteger("code") != 0) {
            if (jsonObject.getInteger("code") == 1 && "\u5df2\u586b\u62a5".equals(jsonObject.getString("message"))) {
                tbWxzxRecord.setTbErr(res);
                return;
            }
            throw new Exception("\u6570\u636e\u4e0a\u4f20\u5931\u8d25:" + res);
        }
    }

    public void saveFile(String fileUrl, ReportFileDto dto, String taskid, String dkid) {
        String tempUrl = "";
        tempUrl = fileUrl.contains("?") ? StringUtils.split((String)fileUrl, (String)"?")[0] : fileUrl;
        TbWxzxRecordFile tbWxzxRecordFile = new TbWxzxRecordFile();
        tbWxzxRecordFile.setDkid(dkid);
        tbWxzxRecordFile.setTaskid(taskid);
        tbWxzxRecordFile.setLocalUrl(tempUrl);
        tbWxzxRecordFile.setServerUrl(dto.getUrl());
        tbWxzxRecordFile.setCreateTime(new Date());
        tbWxzxRecordFile.setFilemd5(dto.getMd5());
        tbWxzxRecordFile.setFilename(dto.getFilename());
        tbWxzxRecordFile.setFilesize(dto.getSize());
        tbWxzxRecordFile.setFiletype(dto.getType());
        this.saveOrUpdateFile(tbWxzxRecordFile);
    }

    public Boolean findFileDetail(String fileUrl, ReportFileDto dto, Map<String, TbWxzxRecordFile> fileMap) {
        String tempUrl = "";
        tempUrl = fileUrl.contains("?") ? StringUtils.split((String)fileUrl, (String)"?")[0] : fileUrl;
        if (fileMap != null && fileMap.containsKey(tempUrl)) {
            TbWxzxRecordFile tbWxzxRecordFile = fileMap.get(tempUrl);
            dto.setFilename(tbWxzxRecordFile.getFilename());
            dto.setSize(tbWxzxRecordFile.getFilesize());
            dto.setMd5(tbWxzxRecordFile.getFilemd5());
            dto.setType(tbWxzxRecordFile.getFiletype());
            dto.setUrl(tbWxzxRecordFile.getServerUrl());
            return true;
        }
        return false;
    }

    public void getAndUploadFile(String fileUrl, ReportFileDto dto, String year, String token, String dir) throws Exception {
        String newUrl = "";
        String tempUrl = "";
        tempUrl = fileUrl.contains("?") ? StringUtils.split((String)fileUrl, (String)"?")[0] : fileUrl;
        String fileName = tempUrl.substring(tempUrl.lastIndexOf("/") + 1, tempUrl.length());
        if ((fileName = URLDecoder.decode(fileName, "utf-8")).contains("?")) {
            fileName = StringUtils.split((String)fileName, (String)"?")[0];
        }
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()).toUpperCase();
        dto.setFilename(fileName);
        String filePath = this.downloadFile(fileUrl, fileName, dir);
        if (StringUtils.isNotEmpty((CharSequence)filePath)) {
            File file = new File(filePath);
            try {
                if (file.length() == 0L) {
                    throw new Exception("\u6587\u4ef6size\u4e3a\u7a7a\uff1a" + fileUrl);
                }
                dto.setSize(Long.valueOf(file.length()));
                try (FileInputStream fs = new FileInputStream(filePath);){
                    byte[] md5 = DigestUtils.md5((InputStream)fs);
                    String base64Md5 = Base64.getEncoder().encodeToString(md5);
                    dto.setMd5(base64Md5);
                }
                dto.setType(fileType);
                newUrl = this.uploadFile(file, year, token);
                dto.setUrl(newUrl);
            }
            catch (Exception ex) {
                throw new Exception("\u6587\u4ef6\u5927\u5c0f:" + dto.getSize() + ex.getMessage());
            }
            finally {
                file.delete();
            }
        }
        throw new Exception("\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25:" + fileUrl);
    }

    public String uploadFile(File file, String year, String token) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"multipart/form-data");
        headers.add("token", token);
        headers.setContentType(type);
        headers.setContentLength(file.length());
        headers.setContentDispositionFormData("media", file.getName());
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        FileSystemResource resource = new FileSystemResource(file);
        param.add((Object)"file", (Object)resource);
        param.add((Object)"year", (Object)year);
        HttpEntity formEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        ResponseEntity response = restTemplate.postForEntity(this.serverFileUrl, (Object)formEntity, String.class, new Object[0]);
        String res = (String)response.getBody();
        JSONObject jsonObject = JSONObject.parseObject((String)res);
        if (jsonObject.getInteger("code") == 0) {
            return jsonObject.getString("data");
        }
        throw new Exception("\u9644\u4ef6[" + file.getPath() + "]\u4e0a\u4f20\u5931\u8d25:" + res);
    }

    public String downloadFile(String fileUrl, String fileName, String dir) throws Exception {
        String downloadUrl = dir + File.separator + fileName;
        File downdirectory = new File(dir);
        if (!downdirectory.exists()) {
            downdirectory.mkdirs();
        }
        URL url = new URL(fileUrl);
        URLConnection con = url.openConnection();
        con.setConnectTimeout(20000);
        File out = new File(downloadUrl);
        FileOutputStream outputStream = new FileOutputStream(out);
        try (InputStream inputStream = con.getInputStream();){
            int len = 0;
            byte[] bytes = new byte[1024];
            while ((len = inputStream.read(bytes)) != -1) {
                ((OutputStream)outputStream).write(bytes, 0, len);
            }
            outputStream.flush();
            ((OutputStream)outputStream).close();
        }
        catch (Exception e) {
            ((OutputStream)outputStream).close();
            if (out.exists()) {
                out.delete();
            }
            throw new Exception(fileUrl + "\u4e0b\u8f7d\u5931\u8d25:" + e.getMessage());
        }
        return downloadUrl;
    }

    public List<ReportFileDto> findTaskMediaFile(Map<String, TbWxzxRecordFile> fileMap, String taskid, String tbid, String year, String token, String zgqk, Map<String, Boolean> flgMap, List<String> errLs) throws Exception {
        Integer reportType = 0;
        if (StringUtils.isNotEmpty((CharSequence)zgqk)) {
            String[] arr;
            for (String str : arr = zgqk.split("&")) {
                if ("\u8865\u529e\u624b\u7eed".equals(str)) {
                    reportType = reportType + 1;
                    continue;
                }
                if (!"\u62c6\u9664\u590d\u8015".equals(str)) continue;
                reportType = reportType + 3;
            }
        }
        ArrayList<ReportFileDto> resList = new ArrayList<ReportFileDto>();
        List appMedias = this.appMediaDao.queryALLByGid(tbid);
        String dir = this.localDownload + File.separator + "media";
        for (int i = 0; i < appMedias.size(); ++i) {
            ReportFileDto dto;
            block31: {
                Integer type = ((AppMedia)appMedias.get(i)).getType();
                if (type != 1 && type != 2 && type != 5) continue;
                AppMediaDTO newMedia = new AppMediaDTO();
                BeanUtil.copyProperties(appMedias.get(i), (Object)newMedia);
                if (StringUtils.isBlank((CharSequence)newMedia.getServerpath()) && StringUtils.isNotBlank((CharSequence)newMedia.getDownloadUrl())) {
                    newMedia.setServerpath(newMedia.getDownloadUrl());
                }
                if (newMedia.getServerpath() != null) {
                    if (StringUtils.isBlank((CharSequence)newMedia.getFromSource())) {
                        String url = newMedia.getServerpath();
                        if (url.contains("?")) {
                            url = StringUtils.split((String)url, (String)"?")[0];
                        }
                        String fiename = url.substring(url.lastIndexOf("/") + 1, url.length());
                        newMedia.setFileName(fiename);
                        url = this.temporarySignedUrlService.getTemporarySignedUrl(this.defaultOssOperatorService.getDefaultOssConfig().getServerId().toString(), url, null);
                        if (GutilStr.isNotBlank((CharSequence)url)) {
                            newMedia.setServerpath(url);
                        }
                    } else {
                        String from = newMedia.getFromSource();
                        if (from.startsWith(this.importOtherDataService.getMediaSourcePrefix())) continue;
                        OssConfig ossConfig = null;
                        if (mapOssConfig.containsKey(from)) {
                            ossConfig = mapOssConfig.get(from);
                        } else {
                            ossConfig = this.ossConfigRepository.queryBySource(from);
                            mapOssConfig.put(from, ossConfig);
                        }
                        if (ossConfig != null) {
                            String url = newMedia.getServerpath();
                            if (url.contains("?")) {
                                url = StringUtils.split((String)url, (String)"?")[0];
                            }
                            String fiename = url.substring(url.lastIndexOf("/") + 1, url.length());
                            newMedia.setFileName(fiename);
                            url = this.temporarySignedUrlService.getTemporarySignedUrl(ossConfig.getServerId().toString(), url, null);
                            if (GutilStr.isNotBlank((CharSequence)url)) {
                                newMedia.setServerpath(url);
                            }
                        }
                    }
                }
                Integer fileType = 1;
                dto = new ReportFileDto();
                if (5 == type) {
                    if (reportType == 3) {
                        fileType = 2;
                    } else {
                        flgMap.put("bbHave", true);
                    }
                } else if (1 == type || 2 == type) {
                    if (reportType >= 3) {
                        fileType = 2;
                        flgMap.put("ccfkHave", true);
                    }
                    dto.setPsry(newMedia.getUsername());
                    String pssj = newMedia.getCreateTime();
                    if (StringUtils.isNotEmpty((CharSequence)pssj)) {
                        Long t = Long.parseLong(pssj);
                        dto.setPssj(t);
                    }
                    if (newMedia.getPsgd() != null) {
                        dto.setXdgd(newMedia.getPsgd().toString());
                    }
                    if (((AppMedia)appMedias.get(i)).getJdgd() != null) {
                        dto.setJdgd(((AppMedia)appMedias.get(i)).getJdgd().toString());
                    }
                    dto.setLongitude(newMedia.getLon());
                    dto.setLatitude(newMedia.getLat());
                    if (StringUtils.isNotEmpty((CharSequence)newMedia.getPitch())) {
                        int roundValue = (int)Math.round(Double.parseDouble(newMedia.getPitch()));
                        dto.setPsfyj(Integer.valueOf(roundValue));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)newMedia.getAzimuth())) {
                        int roundValue = (int)Math.round(Double.parseDouble(newMedia.getAzimuth()));
                        dto.setPsjd(Integer.valueOf(roundValue));
                    }
                    dto.setPshgj(((AppMedia)appMedias.get(i)).getRoll());
                    if (((AppMedia)appMedias.get(i)).getFocal() != null) {
                        int roundValue = (int)Math.round(((AppMedia)appMedias.get(i)).getFocal());
                        dto.setPsjj(Integer.valueOf(roundValue));
                    }
                    if (newMedia.getDimHeight() != null) {
                        dto.setFjysgd(newMedia.getDimHeight().toString());
                    }
                    if (newMedia.getDimWidth() != null) {
                        dto.setFjyskd(newMedia.getDimWidth().toString());
                    }
                }
                dto.setFileType(fileType);
                try {
                    if (this.findFileDetail(newMedia.getServerpath(), dto, fileMap).booleanValue()) break block31;
                    this.getAndUploadFile(newMedia.getServerpath(), dto, year, token, dir);
                    this.saveFile(newMedia.getServerpath(), dto, taskid, tbid);
                }
                catch (Exception ex) {
                    errLs.add(ex.getMessage());
                    this.logger.error(ex.getMessage(), new Object[0]);
                    continue;
                }
            }
            resList.add(dto);
        }
        return resList;
    }
}

