/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.statistics;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.dao.pub.DmDictValueDao;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.DmDictValue;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserDetailRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.servface.pub.MinIOService;
import com.google.common.base.Preconditions;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="CgjcApproveRecordDetailService")
@Transactional(rollbackFor={Exception.class})
public class CgjcApproveRecordDetailService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    private SysConfigRepository configRepository;
    private static final String TAKE_HAND_TASK_ID = "statistics";
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    LandUserService landUserService;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    RegionService regionService;
    @Resource
    private DmDictValueDao dictValueDao;
    @Autowired
    LandUserDetailRepository landUserDetailDao;
    @Autowired
    private MinIOService minIOService;
    private String resultUrl = "";
    @Value(value="${project.import.media}")
    protected String mediaFolder;
    @Autowired
    private DefaultOssOperatorService stsService;
    @Value(value="${project.applicationType}")
    protected String applicationType;
    @Autowired
    UserNameService userNameService;
    private GiLoger logger = GwLoger.getLoger(CgjcApproveRecordDetailService.class);

    public DataDownloadRecord downloadCgjcApproveDetail(String taskId, Long userId, String shsjStart, String shsjEnd, String hasPass, String approveUser) {
        this.checkParameters(taskId, userId);
        DataDownloadRecord record = this.dataDownloadRecordService.buildDataDownloadRecordBaseInfo(taskId, null, userId.longValue());
        record.setName("\u5ba1\u6838\u8be6\u7ec6\u8bb0\u5f55\u7edf\u8ba1\u4fe1\u606f\u6c47\u603b(" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + ")");
        this.dataDownloadRecordService.save(record);
        if (this.redisTemplate.hasKey((Object)record.getId()).booleanValue()) {
            this.redisTemplate.delete((Object)record.getId());
        }
        this.redisTemplate.opsForValue().set((Object)record.getId(), (Object)JSON.toJSONString((Object)record), 2L, TimeUnit.DAYS);
        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(StringUtils.isNotBlank((CharSequence)taskId) ? taskId : "");
        attachParameter.setTbIds(StringUtils.isNotBlank((CharSequence)record.getTbIds()) ? record.getTbIds() : "");
        attachParameter.setTbNames("");
        attachParameter.setUserId(userId);
        attachParameter.setBizType(TAKE_HAND_TASK_ID);
        attachParameter.setRecordId(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{record.getId()}) ? record.getId() : "");
        attachParameter.setDownloadType(Integer.valueOf(0));
        attachParameter.setDataType("approveRecordDetail");
        JSONObject condition = new JSONObject();
        condition.put("shsjStart", (Object)shsjStart);
        condition.put("shsjEnd", (Object)shsjEnd);
        condition.put("hasPass", (Object)hasPass);
        condition.put("approveUser", (Object)approveUser);
        attachParameter.setCondition(condition.toJSONString());
        String parameterString = JSON.toJSONString((Object)attachParameter);
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(parameterString);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(Integer.valueOf(1));
        taskRecord.setBizId(taskId);
        taskRecord.setUserid(userId);
        this.taskRecordService.save(taskRecord);
        return record;
    }

    public Boolean runDownloadCgjcApproveDetail(TaskRecord taskRecord, DownloadParameter downloadParameter) throws Exception {
        DataDownloadRecord dataDownloadRecord = null;
        try {
            Object value = this.redisTemplate.opsForValue().get((Object)downloadParameter.getRecordId());
            if (value != null && (dataDownloadRecord = (DataDownloadRecord)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)value.toString()), DataDownloadRecord.class)) != null) {
                if (this.dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)) {
                    throw new Exception("\u7528\u6237\u53d6\u6d88\u4e86\u4e0b\u8f7d\u4efb\u52a1");
                }
                List areas = this.landUserService.queryUserAreas(taskRecord.getUserid());
                String area = StringUtils.join((Iterable)areas, (String)",");
                String path = this.createCgjcApproveRecordDetail(taskRecord.getBizId(), area, taskRecord.getUserid(), downloadParameter);
                File srcFile = new File(path);
                this.logger.info("\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d \u5f00\u59cb\u4e0a\u4f20\u5230obs " + path, new Object[0]);
                String resultUrl = "";
                resultUrl = "lan".equals(this.applicationType) ? this.uploadFileToDisk(taskRecord.getUserid(), srcFile) : this.uploadFileToCloudDisk(taskRecord.getUserid(), srcFile);
                if (this.dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)) {
                    throw new Exception("\u7528\u6237\u53d6\u6d88\u4e86\u4e0b\u8f7d\u4efb\u52a1");
                }
                Double fileSize = (double)srcFile.length() / 1024.0;
                dataDownloadRecord.setAttachSize(fileSize);
                dataDownloadRecord.setUrl(resultUrl);
                dataDownloadRecord.setEndTime(new Date());
                dataDownloadRecord.setState(DataDownloadStateEnum.FINISTHE);
                this.dataDownloadRecordService.save(dataDownloadRecord);
                srcFile.delete();
            }
        }
        catch (Exception e) {
            dataDownloadRecord.setEndTime(new Date());
            dataDownloadRecord.setState(DataDownloadStateEnum.FAILED);
            dataDownloadRecord.setErrorMsg(e.getMessage());
            this.dataDownloadRecordService.update(dataDownloadRecord);
            throw e;
        }
        return true;
    }

    private String uploadFileToCloudDisk(Long userId, File file) {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        return this.stsService.sendObject2Oss(sendObjName, file);
    }

    private String uploadFileToDisk(Long userId, File file) throws Exception {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        String resultUrl = "";
        File destFile = new File(this.mediaFolder, "media/" + file.getName());
        FileUtils.copyFile((File)file, (File)destFile);
        resultUrl = "media/" + sendObjName;
        return resultUrl;
    }

    private void checkParameters(String taskId, Long userId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)taskId), (Object)"taskId must not be null or empty.");
        Preconditions.checkArgument((userId > -1L ? 1 : 0) != 0, (Object)"userId can not be negative number.");
    }

    public String createCgjcApproveRecordDetail(String taskId, String xzqdm, Long userId, DownloadParameter downloadParameter) throws Exception {
        int i;
        TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(taskId);
        if (tskTaskBiz == null) {
            throw new Exception("\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        if (tbtskObjectinfo == null) {
            throw new Exception("\u5f53\u524d\u4efb\u52a1table\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        SysConfig config = this.configRepository.queryByKey("xzqCode");
        String provinceCode = config.getValue().substring(0, 3) + "%";
        List result = this.regionService.queryAllRegionAndCode(provinceCode);
        ArrayList<Region> cRegions = new ArrayList<Region>();
        String includeRegion = "500100\u3001500200\u3001500000";
        if (xzqdm.equals("") || xzqdm.equals("500000")) {
            for (i = 0; i < result.size(); ++i) {
                if (includeRegion.indexOf(((Region)result.get(i)).getCode()) != -1) continue;
                cRegions.add((Region)result.get(i));
            }
        } else {
            for (i = 0; i < result.size(); ++i) {
                if (xzqdm.indexOf(((Region)result.get(i)).getCode()) == -1 || includeRegion.indexOf(((Region)result.get(i)).getCode()) != -1) continue;
                cRegions.add((Region)result.get(i));
            }
        }
        String excelPath = "";
        try {
            ArrayList<Map<String, Object>> shList = new ArrayList();
            JSONObject condition = JSONObject.parseObject((String)downloadParameter.getCondition());
            String shsjStart = condition.get((Object)"shsjStart").toString();
            String shsjEnd = condition.get((Object)"shsjEnd").toString();
            String hasPass = condition.get((Object)"hasPass").toString();
            String approveUser = condition.get((Object)"approveUser").toString();
            List dmDictValue = this.dictValueDao.queryByDictId(Long.valueOf(200913L));
            if (dmDictValue.size() == 0) {
                throw new Exception("\u5ba1\u6838\u672a\u901a\u8fc7\u63d0\u793a\u8bed\u5b57\u5178\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5b58\u5728id\u4e3a200913\u7684\u5b57\u5178\u9879");
            }
            shList = this.getShList(tbtskObjectinfo.getfTablename(), taskId, cRegions, shsjStart, shsjEnd, hasPass, approveUser, dmDictValue);
            excelPath = this.createCgjcApproveRecordDetailExcel(shList, tskTaskBiz.getName(), shsjStart, shsjEnd, hasPass, approveUser, dmDictValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return excelPath;
    }

    public List<Map<String, Object>> getShList(String tableName, String taskId, List<Region> cRegions, String shsjStart, String shsjEnd, String hasPass, String approveUser, List<DmDictValue> dmDictValue) {
        String regions = "";
        for (int i = 0; i < cRegions.size(); ++i) {
            regions = regions + "'" + cRegions.get(i).getCode() + "',";
        }
        String conditionSql = " where 1=1 ";
        if (!shsjStart.equals("")) {
            conditionSql = conditionSql + " and ar.f_approve_time >= TO_TIMESTAMP(" + shsjStart.toString().substring(0, shsjStart.toString().length() - 3) + ") ";
        }
        if (!shsjEnd.equals("")) {
            conditionSql = conditionSql + " and ar.f_approve_time <= TO_TIMESTAMP(" + shsjEnd.toString().substring(0, shsjEnd.toString().length() - 3) + ") ";
        }
        if (!hasPass.equals("")) {
            if (hasPass.equals("true")) {
                conditionSql = conditionSql + " and ar.f_stepindex = 1 AND ar.f_option='1' ";
            } else if (hasPass.equals("false")) {
                conditionSql = conditionSql + " and ( (ar.f_stepindex = 1 AND ar.f_option='2') or ar.f_stepindex = 0 or ar.f_stepindex is null )";
            }
        }
        if (!approveUser.equals("")) {
            conditionSql = conditionSql + " and ar.f_approve_user = '" + approveUser + "'";
        }
        String shListSql = "SELECT\n\tT.f_xzqdm,T.f_xzqmc1,\n\tCOUNT ( * ) spotAllCount,\n\tSUM ( f_tbmj ) tbmjAllSum,\n\tCOUNT((ar.f_stepindex=0 AND ar.f_option='1' ) OR NULL OR ( ar.f_stepindex = 1 AND ar.f_option='1' ) OR ( ar.f_stepindex =1 AND ar.f_option='2')) xjTgSpotCount,\n\tSUM( CASE WHEN (ar.f_stepindex = 0 AND ar.f_option='1' ) OR NULL OR ( ar.f_stepindex = 1 AND ar.f_remark ='\u901a\u8fc7' ) OR ( ar.f_stepindex = 1 AND ar.f_option='2') THEN T.f_tbmj ELSE 0 END ) xjTgTbmjSum,\n\tCOUNT ( ( ar.f_stepindex = 1 ) OR NULL ) sjAllSpotCount,\n\tSUM ( CASE WHEN ar.f_stepindex = 1 THEN T.f_tbmj ELSE 0 END ) sjAllTbmjSum,\n\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='1' ) OR NULL ) sjTgSpotCount,\n\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='1' THEN T.f_tbmj ELSE 0 END ) sjTgTbmjSum,\n\tCOUNT ( ( ar.f_stepindex = 1 AND T.f_bzw = '\u5df2\u7eb3\u5165\u4e8c\u4e0a' AND ar.f_option='1' ) OR NULL ) sjTgEsSpotCount,\n\tSUM ( CASE WHEN ar.f_stepindex = 1 AND T.f_bzw = '\u5df2\u7eb3\u5165\u4e8c\u4e0a' AND ar.f_option='1' THEN T.f_tbmj ELSE 0 END ) sjTgEsTbmjSum,\n\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='2' ) OR NULL ) sjWtgSpotCount,\n\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' THEN T.f_tbmj ELSE 0 END ) sjWtgTbmjSum,\n";
        for (int i = 0; i < dmDictValue.size(); ++i) {
            shListSql = shListSql + "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='" + dmDictValue.get(i).getName() + "' ) OR NULL ) " + dmDictValue.get(i).getCode() + "count,\n";
            shListSql = i == dmDictValue.size() - 1 ? shListSql + "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='" + dmDictValue.get(i).getName() + "' THEN T.f_tbmj ELSE 0 END ) " + dmDictValue.get(i).getCode() + "sum\n" : shListSql + "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='" + dmDictValue.get(i).getName() + "' THEN T.f_tbmj ELSE 0 END ) " + dmDictValue.get(i).getCode() + "sum,\n";
        }
        shListSql = shListSql + "FROM\n\t" + tableName + "\n\tAS T LEFT JOIN (\n\tSELECT\n\t\tar3.* \n\tFROM\n\t\ttbtsk_approve_record AS ar3\n\t\tINNER JOIN (\n\t\t\t SELECT f_tbid,\n\t\t\tMAX ( f_approve_time ) AS f_approve_time \n\t\tFROM\n\t\t\t( SELECT ar1.* FROM tbtsk_approve_record AS ar1 WHERE ar1.f_taskid = '" + taskId + "' ) AS tar \n\t\tGROUP BY\n\t\t\tf_tbid \n\t\t) ar2 ON ar2.f_tbid = ar3.f_tbid \n\t\tAND ar2.f_approve_time = ar3.f_approve_time \n\t) ar ON T.f_id = ar.f_tbid and  T.f_xzqdm like '50%' \n" + conditionSql;
        if (regions != "") {
            regions = regions.substring(0, regions.length() - 1);
            shListSql = shListSql + " AND t.f_xzqdm in (" + regions + ") ";
        }
        shListSql = shListSql + "GROUP BY\n\tT.f_xzqdm,T.f_xzqmc1";
        List shNumList = this.jdbcTemplate.queryForList(shListSql);
        return shNumList;
    }

    public String createCgjcApproveRecordDetailExcel(List<Map<String, Object>> dataList, String taskName, String shsjStart, String shsjEnd, String hasPass, String approveUser, List<DmDictValue> dmDictValue) throws Exception {
        ClassPathResource STSONG = new ClassPathResource("/static/excel/\u5e38\u89c4\u76d1\u6d4b\u5ba1\u6838\u8be6\u7ec6\u8bb0\u5f55\u6a21\u677f.xlsx");
        File STSONGFile = File.createTempFile("template_STSONG_copy", ".xlsx");
        FileUtils.copyInputStreamToFile((InputStream)STSONG.getInputStream(), (File)STSONGFile);
        String srcFileName = STSONGFile.getAbsolutePath();
        String ouputFile = this.uploadDir + File.separator + "excel";
        String ouputPath = this.uploadDir + File.separator + "excel" + File.separator + (taskName + "_\u8be6\u7ec6\u5ba1\u6838\u8bb0\u5f55_" + System.currentTimeMillis() + ".xlsx");
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList listMap = new ArrayList();
            ArrayList colsMap = new ArrayList();
            DecimalFormat format = new DecimalFormat("#.00");
            for (int i = 0; i < dataList.size(); ++i) {
                HashMap<String, String> cmap = new HashMap<String, String>();
                for (String key : dataList.get(i).keySet()) {
                    if (dataList.get(i).get(key) != null) {
                        cmap.put(key, dataList.get(i).get(key).toString());
                        continue;
                    }
                    if (key.contains("sum") || key.contains("count")) {
                        cmap.put(key, String.valueOf(0));
                        continue;
                    }
                    cmap.put(key, "");
                }
                Double othercount = Double.valueOf((String)cmap.get("sjwtgspotcount"));
                Double othersum = Double.valueOf((String)cmap.get("sjwtgtbmjsum"));
                for (int j = 0; j < dmDictValue.size(); ++j) {
                    othercount = othercount - Double.valueOf((String)cmap.get(dmDictValue.get(j).getCode() + "count"));
                    othersum = othersum - Double.valueOf((String)cmap.get(dmDictValue.get(j).getCode() + "sum"));
                }
                cmap.put("othercount", String.valueOf(othercount));
                cmap.put("othersum", String.valueOf(othersum));
                listMap.add(cmap);
            }
            for (int j = 0; j < dmDictValue.size(); ++j) {
                HashMap<String, String> colMap = new HashMap<String, String>();
                colMap.put("name", dmDictValue.get(j).getName());
                colMap.put("spotCountName", "\u56fe\u6591\u91cf\uff08\u4e2a\uff09");
                colMap.put("spotAreaName", "\u56fe\u6591\u9762\u79ef");
                colMap.put("spotCountCode", "n:t." + dmDictValue.get(j).getCode() + "count");
                colMap.put("spotAreaCode", "n:t." + dmDictValue.get(j).getCode() + "sum");
                colsMap.add(colMap);
            }
            map.put("maplist", listMap);
            map.put("colList", colsMap);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (!shsjStart.equals("")) {
                Date startDate = new Date(Long.valueOf(shsjStart));
                shsjStart = simpleDateFormat.format(startDate);
            }
            if (!shsjEnd.equals("")) {
                Date endDate = new Date(Long.valueOf(shsjEnd));
                shsjEnd = simpleDateFormat.format(endDate);
            }
            String passName = "\u5168\u90e8";
            if (!hasPass.equals("")) {
                if (hasPass.equals("true")) {
                    passName = "\u901a\u8fc7";
                } else if (hasPass.equals("false")) {
                    passName = "\u4e0d\u901a\u8fc7";
                }
            }
            String userName = "\u5168\u90e8";
            if (!approveUser.equals("")) {
                userName = this.userNameService.getUserPhoneByUserName(approveUser);
            }
            map.put("shsjStart", shsjStart);
            map.put("shsjEnd", shsjEnd);
            map.put("passName", passName);
            map.put("userName", userName);
            TemplateExportParams params = new TemplateExportParams(srcFileName, new Integer[0]);
            params.setColForEach(true);
            Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, map);
            File savefile = new File(ouputFile);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(ouputPath);
            workbook.write((OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return ouputPath;
    }
}

