/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.statistics;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.servface.pub.MinIOService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.google.common.base.Preconditions;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="CgjcApproveRecordService")
@Transactional(rollbackFor={Exception.class})
public class CgjcApproveRecordService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    private SysConfigRepository configRepository;
    private static final String TAKE_HAND_TASK_ID = "statistics";
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    LandUserService landUserService;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    RegionService regionService;
    @Autowired
    MTskTaskBizService mTskTaskBizService;
    @Autowired
    private MinIOService minIOService;
    private String resultUrl = "";
    @Value(value="${project.applicationType}")
    protected String mediaFolder;
    @Autowired
    private DefaultOssOperatorService stsService;
    @Value(value="${project.applicationType}")
    protected String applicationType;
    private GiLoger logger = GwLoger.getLoger(CgjcApproveRecordService.class);

    public DataDownloadRecord downloadCgjcApprove(TaskQueryParameter parameter, Long userId) {
        String taskId = parameter.getTaskId();
        this.checkParameters(taskId, userId);
        DataDownloadRecord record = this.dataDownloadRecordService.buildDataDownloadRecordBaseInfo(taskId, null, userId.longValue());
        record.setName("\u5ba1\u6838\u8bb0\u5f55\u7edf\u8ba1\u4fe1\u606f\u6c47\u603b(" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + ")");
        this.dataDownloadRecordService.save(record);
        if (this.redisTemplate.hasKey((Object)record.getId()).booleanValue()) {
            this.redisTemplate.delete((Object)record.getId());
        }
        this.redisTemplate.opsForValue().set((Object)record.getId(), (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)record), 2L, TimeUnit.DAYS);
        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(StringUtils.isNotBlank((CharSequence)taskId) ? taskId : "");
        attachParameter.setTbIds(StringUtils.isNotBlank((CharSequence)parameter.getTbIds()) ? parameter.getTbIds() : "");
        attachParameter.setTbNames("");
        attachParameter.setUserId(userId);
        attachParameter.setCondition(JSONObject.toJSONString((Object)parameter));
        attachParameter.setBizType(TAKE_HAND_TASK_ID);
        attachParameter.setRecordId(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{record.getId()}) ? record.getId() : "");
        attachParameter.setDownloadType(Integer.valueOf(0));
        attachParameter.setDataType("approveRecord");
        String parameterString = JSONObject.toJSONString((Object)attachParameter);
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(parameterString);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(Integer.valueOf(1));
        taskRecord.setBizId(taskId);
        taskRecord.setUserid(userId);
        this.taskRecordService.save(taskRecord);
        return record;
    }

    public Boolean runDownloadCgjcApprove(TaskRecord taskRecord, DownloadParameter downloadParameter) throws Exception {
        DataDownloadRecord dataDownloadRecord = null;
        try {
            Object value = this.redisTemplate.opsForValue().get((Object)downloadParameter.getRecordId());
            if (value != null && (dataDownloadRecord = (DataDownloadRecord)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)value.toString()), DataDownloadRecord.class)) != null) {
                if (this.dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)) {
                    throw new Exception("\u7528\u6237\u53d6\u6d88\u4e86\u4e0b\u8f7d\u4efb\u52a1");
                }
                List areas = this.landUserService.queryUserAreas(taskRecord.getUserid());
                String area = StringUtils.join((Iterable)areas, (String)",");
                String path = this.createCgjcApproveRecord(taskRecord.getBizId(), area, taskRecord.getUserid(), taskRecord);
                File srcFile = new File(path);
                this.logger.info("\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d \u5f00\u59cb\u4e0a\u4f20\u5230obs " + path, new Object[0]);
                String resultUrl = "";
                resultUrl = "lan".equals(this.applicationType) ? this.uploadFileToDisk(taskRecord.getUserid(), srcFile) : this.uploadFileToCloudDisk(taskRecord.getUserid(), srcFile);
                if (this.dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)) {
                    throw new Exception("\u7528\u6237\u53d6\u6d88\u4e86\u4e0b\u8f7d\u4efb\u52a1");
                }
                Double fileSize = (double)srcFile.length() / 1024.0;
                dataDownloadRecord.setAttachSize(fileSize);
                dataDownloadRecord.setUrl(resultUrl);
                dataDownloadRecord.setEndTime(new Date());
                dataDownloadRecord.setState(DataDownloadStateEnum.FINISTHE);
                this.dataDownloadRecordService.save(dataDownloadRecord);
                srcFile.delete();
            }
        }
        catch (Exception e) {
            dataDownloadRecord.setEndTime(new Date());
            dataDownloadRecord.setState(DataDownloadStateEnum.FAILED);
            dataDownloadRecord.setErrorMsg(e.getMessage());
            this.dataDownloadRecordService.update(dataDownloadRecord);
            throw e;
        }
        return true;
    }

    private String uploadFileToCloudDisk(Long userId, File file) {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        return this.stsService.sendObject2Oss(sendObjName, file);
    }

    private String uploadFileToDisk(Long userId, File file) throws Exception {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        String resultUrl = "";
        File destFile = new File(this.mediaFolder, "media/" + file.getName());
        FileUtils.copyFile((File)file, (File)destFile);
        resultUrl = "media/" + sendObjName;
        return resultUrl;
    }

    private void checkParameters(String taskId, Long userId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)taskId), (Object)"taskId must not be null or empty.");
        Preconditions.checkArgument((userId > -1L ? 1 : 0) != 0, (Object)"userId can not be negative number.");
    }

    public String createCgjcApproveRecord(String taskId, String xzqdm, Long userId, TaskRecord taskRecord) throws Exception {
        int i;
        TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(taskId);
        if (tskTaskBiz == null) {
            throw new Exception("\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        if (tbtskObjectinfo == null) {
            throw new Exception("\u5f53\u524d\u4efb\u52a1table\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        String tbIds = "";
        JSONObject paramObject = new JSONObject();
        String paramKey = "";
        if (taskRecord != null) {
            String param = taskRecord.getParam();
            DownloadParameter downloadParameter = (DownloadParameter)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)param), DownloadParameter.class);
            String condition = downloadParameter.getCondition();
            TaskQueryParameter parameter = (TaskQueryParameter)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)condition), TaskQueryParameter.class);
            Pair<Long, List<Map>> longListPair = this.mTskTaskBizService.queryWebDisplayListDataNotPage(parameter);
            Pair pair = Pair.of((Object)longListPair.getKey(), (Object)longListPair.getValue());
            List mapList = (List)pair.getRight();
            List ids = mapList.stream().map(map -> map.get("f_id").toString()).collect(Collectors.toList());
            parameter.setTbIds(StringUtils.join(ids, (String)","));
            tbIds = StringUtils.join(ids, (String)",");
            if (this.redisTemplate.hasKey((Object)(tskTaskBiz.getId() + "_CgjcApproveParamObject")).booleanValue()) {
                paramObject = (JSONObject)this.redisTemplate.opsForValue().get((Object)(tskTaskBiz.getId() + "_CgjcApproveParamObject"));
            } else {
                paramObject.put(String.valueOf(parameter), (Object)(tskTaskBiz.getId() + "_CgjcApproveParamObject_" + paramObject.size()));
                this.redisTemplate.opsForValue().set((Object)(tskTaskBiz.getId() + "_CgjcApproveParamObject"), (Object)paramObject, 21600L, TimeUnit.SECONDS);
            }
            if (paramObject.containsKey((Object)String.valueOf(parameter))) {
                paramKey = paramObject.getString(String.valueOf(parameter));
            } else {
                paramKey = tskTaskBiz.getId() + "_CgjcApproveParamObject_" + paramObject.size();
                paramObject.put(String.valueOf(parameter), (Object)paramKey);
                this.redisTemplate.opsForValue().set((Object)(tskTaskBiz.getId() + "_CgjcApproveParamObject"), (Object)paramObject, 21600L, TimeUnit.SECONDS);
            }
        }
        SysConfig config = this.configRepository.queryByKey("xzqCode");
        String provinceCode = config.getValue().substring(0, 3) + "%";
        List result = new ArrayList();
        if (this.redisTemplate.hasKey((Object)"region_all").booleanValue()) {
            result = (List)this.redisTemplate.opsForValue().get((Object)"region_all");
        } else {
            result = this.regionService.queryAllRegionAndCode(provinceCode);
            this.redisTemplate.opsForValue().set((Object)"region_all", result, 30L, TimeUnit.DAYS);
        }
        ArrayList<Region> cRegions = new ArrayList<Region>();
        String includeRegion = "500100\u3001500200\u3001500000";
        if (xzqdm.equals("") || xzqdm.equals("500000")) {
            for (i = 0; i < result.size(); ++i) {
                if (includeRegion.indexOf(((Region)result.get(i)).getCode()) != -1) continue;
                cRegions.add((Region)result.get(i));
            }
        } else {
            for (i = 0; i < result.size(); ++i) {
                if (xzqdm.indexOf(((Region)result.get(i)).getCode()) == -1 || includeRegion.indexOf(((Region)result.get(i)).getCode()) != -1) continue;
                cRegions.add((Region)result.get(i));
            }
        }
        String excelPath = "";
        try {
            List<Object> shList = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)paramKey) && this.redisTemplate.hasKey((Object)(paramKey + "_tbApproveRecords")).booleanValue()) {
                shList = (List)this.redisTemplate.opsForValue().get((Object)(paramKey + "_tbApproveRecords"));
            } else {
                shList = this.getShList(tbtskObjectinfo.getfTablename(), taskId, cRegions, tbIds);
                this.redisTemplate.opsForValue().set((Object)(paramKey + "_tbApproveRecords"), shList, 21600L, TimeUnit.SECONDS);
            }
            excelPath = this.createCgjcApproveRecordExcel(shList, tskTaskBiz.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return excelPath;
    }

    public List<Map<String, Object>> getShList(String tableName, String taskId, List<Region> cRegions, String tbIds) {
        String regions = "";
        for (int i = 0; i < cRegions.size(); ++i) {
            regions = regions + "'" + cRegions.get(i).getCode() + "',";
        }
        String tmpTable1 = "with approve as (select tar.f_taskid f_taskid,tar.f_stepindex f_stepindex,tar.f_remark f_remark,tar.f_tbid f_tbid,tar.f_approve_user  f_approve_user,tar.f_approve_time f_approve_time,tar.f_option f_option from tbtsk_approve_record tar\nunion all\nselect trr.f_taskid f_taskid,case trr.f_stepname when '\u5e02\u7ea7\u5ba1\u6838' then 1  when  '\u53bf\u7ea7\u7ea7\u5ba1\u6838' then 0 else 0 end f_stepindex,trr.f_remark f_remark,trr.f_tbid f_tbid,trr.f_username f_approve_user,trr.f_reject_time f_approve_time,2 as f_option from tbtsk_reject_record trr )";
        if (StringUtils.isNotBlank((CharSequence)tbIds)) {
            tmpTable1 = tmpTable1 + " , tmp as (select unnest(string_to_array('" + tbIds + "',',')) f_id )";
        }
        String shListSql1 = tmpTable1 + " SELECT  t.f_id,t.f_tbbh,t.f_xzqdm,t.f_xzqmc1,ar7.f_remark,ar7.f_approve_user,ar7.f_approve_time,ar7.f_option,ar7.sjnum,ar.xj_remark, ar.xj_approve_user,ar.xj_approve_time,ar.xj_option,ar.xjnum  FROM " + tableName + " AS t  inner JOIN ( SELECT ar3.f_remark as xj_remark,ar3.f_tbid, ar3.f_approve_user as xj_approve_user,ar3.f_approve_time as xj_approve_time, ar3.f_option as xj_option,ar2.xjnum FROM approve as ar3 INNER  JOIN  ( SELECT f_tbid,MAX ( f_approve_time ) AS f_approve_time,COUNT(f_tbid) as xjnum  FROM  ( SELECT ar1.* FROM approve AS ar1 where ar1.f_taskid = '" + taskId + "' AND ar1.f_stepindex = 0)  as tar GROUP BY f_tbid) ar2 on ar2.f_tbid = ar3.f_tbid and ar2.f_approve_time = ar3.f_approve_time) ar  ON  t.f_id = ar.f_tbid  LEFT JOIN (  SELECT ar4.*,ar5.sjnum  FROM approve AS ar4 INNER JOIN (  SELECT f_tbid,MAX ( f_approve_time ) AS f_approve_time ,COUNT(f_tbid) as sjnum FROM(  SELECT ar6.* FROM approve AS ar6 where ar6.f_taskid ='" + taskId + "' AND ar6.f_stepindex = 1 ) AS tar  GROUP BY f_tbid ) ar5 ON ar5.f_tbid = ar4.f_tbid AND ar5.f_approve_time = ar4.f_approve_time  ) ar7 ON T.f_id = ar7.f_tbid ";
        if (StringUtils.isNotBlank((CharSequence)tmpTable1)) {
            shListSql1 = shListSql1 + " INNER JOIN tmp on tmp.f_id = t.f_id ";
        }
        if (regions != "") {
            regions = regions.substring(0, regions.length() - 1);
            shListSql1 = shListSql1 + " where t.f_xzqdm in (" + regions + ")";
        }
        List shNumList = this.jdbcTemplate.queryForList(shListSql1);
        return shNumList;
    }

    public String createCgjcApproveRecordExcel(List<Map<String, Object>> dataList, String taskName) throws Exception {
        ClassPathResource STSONG = new ClassPathResource("/static/excel/\u5e38\u89c4\u76d1\u6d4b\u5e02\u7ea7\u5ba1\u6838\u8bb0\u5f55\u6a21\u677f.xlsx");
        File STSONGFile = File.createTempFile("template_STSONG_copy", ".xlsx");
        FileUtils.copyInputStreamToFile((InputStream)STSONG.getInputStream(), (File)STSONGFile);
        String srcFileName = STSONGFile.getAbsolutePath();
        String ouputFile = this.uploadDir + File.separator + "excel";
        String ouputPath = this.uploadDir + File.separator + "excel" + File.separator + (taskName + "_\u5e02\u7ea7\u5ba1\u6838\u8bb0\u5f55_" + System.currentTimeMillis() + ".xlsx");
        try {
            HashMap map = new HashMap();
            ArrayList listMap = new ArrayList();
            for (int i = 0; i < dataList.size(); ++i) {
                HashMap<String, String> cmap = new HashMap<String, String>();
                for (String key : dataList.get(i).keySet()) {
                    if (dataList.get(i).get(key) != null && !"null".equals(dataList.get(i).get(key))) {
                        cmap.put(key, dataList.get(i).get(key).toString());
                        continue;
                    }
                    if (key.equals("xj_remark")) {
                        if (dataList.get(i).containsKey("xj_option") && dataList.get(i).get("xj_option") != null) {
                            if (Integer.valueOf(dataList.get(i).get("xj_option").toString()) == 1) {
                                cmap.put(key, "\u901a\u8fc7");
                                continue;
                            }
                            if (Integer.valueOf(dataList.get(i).get("xj_option").toString()) == 2) {
                                cmap.put(key, "\u4e0d\u901a\u8fc7");
                                continue;
                            }
                            cmap.put(key, "\u672a\u5ba1");
                            continue;
                        }
                        cmap.put(key, "");
                        continue;
                    }
                    if (key.equals("f_remark")) {
                        if (dataList.get(i).containsKey("f_option") && dataList.get(i).get("f_option") != null) {
                            if (Integer.valueOf(dataList.get(i).get("f_option").toString()) == 1) {
                                cmap.put(key, "\u901a\u8fc7");
                                continue;
                            }
                            if (Integer.valueOf(dataList.get(i).get("f_option").toString()) == 2) {
                                cmap.put(key, "\u4e0d\u901a\u8fc7");
                                continue;
                            }
                            cmap.put(key, "\u672a\u5ba1");
                            continue;
                        }
                        cmap.put(key, "");
                        continue;
                    }
                    cmap.put(key, "");
                }
                listMap.add(cmap);
            }
            map.put("maplist", listMap);
            TemplateExportParams params = new TemplateExportParams(srcFileName, new Integer[0]);
            Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, map);
            File savefile = new File(ouputFile);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(ouputPath);
            workbook.write((OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return ouputPath;
    }
}

