/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.statistics;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.servface.pub.MinIOService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="CgjcProgressService")
public class CgjcProgressService {
    private GiLoger logger = GwLoger.getLoger(CgjcProgressService.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    private MinIOService minIOService;
    @Value(value="${project.applicationType}")
    protected String applicationType;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Resource
    TaskRecordService taskRecordService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    private SysConfigRepository configRepository;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    RegionService regionService;
    @Autowired
    MTskTaskBizService mTskTaskBizService;

    public String createCgjcProgress(TaskQueryParameter parameter, String xzqdm, Long userId) throws Exception {
        int i;
        String taskId = parameter.getTaskId();
        parameter.setUserId(userId);
        TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(taskId);
        if (tskTaskBiz == null) {
            throw new Exception("\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        if (tbtskObjectinfo == null) {
            throw new Exception("\u5f53\u524d\u4efb\u52a1table\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Pair<Long, List<Map>> longListPair = this.mTskTaskBizService.queryWebDisplayListDataNotPage(parameter);
        Pair pair = Pair.of((Object)longListPair.getKey(), (Object)longListPair.getValue());
        List mapList = (List)pair.getRight();
        ArrayList<String> ids = new ArrayList<String>();
        int submitNum = 0;
        for (Map map : mapList) {
            String f_id = map.get("f_id").toString();
            Integer f_status = map.get("f_status") != null ? Integer.valueOf(map.get("f_status").toString()) : 1;
            if (f_status >= 4) {
                ++submitNum;
            }
            ids.add(f_id);
        }
        SysConfig config = this.configRepository.queryByKey("xzqCode");
        String provinceCode = config.getValue().substring(0, 3) + "%";
        List result = new ArrayList();
        if (this.redisTemplate.hasKey((Object)"region_all").booleanValue()) {
            result = (List)this.redisTemplate.opsForValue().get((Object)"region_all");
        } else {
            result = this.regionService.queryAllRegionAndCode(provinceCode);
            this.redisTemplate.opsForValue().set((Object)"region_all", result, 30L, TimeUnit.DAYS);
        }
        ArrayList<Region> cRegions = new ArrayList<Region>();
        String includeRegion = "500100\u3001500200\u3001500000";
        if (xzqdm.equals("") || xzqdm.equals("500000")) {
            for (i = 0; i < result.size(); ++i) {
                if (includeRegion.indexOf(((Region)result.get(i)).getCode()) != -1) continue;
                cRegions.add((Region)result.get(i));
            }
        } else {
            for (i = 0; i < result.size(); ++i) {
                if (xzqdm.indexOf(((Region)result.get(i)).getCode()) == -1 || includeRegion.indexOf(((Region)result.get(i)).getCode()) != -1) continue;
                cRegions.add((Region)result.get(i));
            }
        }
        String excelPath = "";
        try {
            JSONObject paramObject = new JSONObject();
            String paramKey = "";
            if (this.redisTemplate.hasKey((Object)(tbtskObjectinfo.getfId() + "_CgjcprogressParamObject")).booleanValue()) {
                paramObject = (JSONObject)this.redisTemplate.opsForValue().get((Object)(tbtskObjectinfo.getfId() + "_CgjcprogressParamObject"));
            } else {
                paramObject.put(String.valueOf(parameter), (Object)(tbtskObjectinfo.getfId() + "_CgjcprogressParamObject_" + paramObject.size()));
                this.redisTemplate.opsForValue().set((Object)(tbtskObjectinfo.getfId() + "_CgjcprogressParamObject"), (Object)paramObject, 21600L, TimeUnit.SECONDS);
            }
            if (paramObject.containsKey((Object)String.valueOf(parameter))) {
                paramKey = paramObject.getString(String.valueOf(parameter));
            } else {
                paramKey = tbtskObjectinfo.getfId() + "_CgjcprogressParamObject_" + paramObject.size();
                paramObject.put(String.valueOf(parameter), (Object)paramKey);
                this.redisTemplate.opsForValue().set((Object)(tbtskObjectinfo.getfId() + "_CgjcprogressParamObject"), (Object)paramObject, 21600L, TimeUnit.SECONDS);
            }
            HashMap<String, Map<String, Object>> tbNumMap = new HashMap();
            HashMap<String, Map<String, Object>> shNumMap = new HashMap();
            if (StringUtils.isNotBlank((CharSequence)paramKey) && this.redisTemplate.hasKey((Object)(paramKey + "_tbNumMap")).booleanValue()) {
                tbNumMap = (Map)this.redisTemplate.opsForValue().get((Object)(paramKey + "_tbNumMap"));
            } else {
                tbNumMap = this.getTbNum(tbtskObjectinfo.getfTablename(), StringUtils.join(ids, (String)","));
                this.redisTemplate.opsForValue().set((Object)(paramKey + "_tbNumMap"), tbNumMap, 21600L, TimeUnit.SECONDS);
            }
            if (StringUtils.isNotBlank((CharSequence)paramKey) && this.redisTemplate.hasKey((Object)(paramKey + "_shNumMap")).booleanValue()) {
                shNumMap = (Map)this.redisTemplate.opsForValue().get((Object)(paramKey + "_shNumMap"));
            } else {
                shNumMap = this.getShNum(tbtskObjectinfo.getfTablename(), taskId, StringUtils.join(ids, (String)","));
                this.redisTemplate.opsForValue().set((Object)(paramKey + "_shNumMap"), shNumMap, 21600L, TimeUnit.SECONDS);
            }
            excelPath = this.createCgjcProgressExcel(cRegions, tbNumMap, shNumMap, ids.size(), submitNum);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return excelPath;
    }

    public Map<String, Map<String, Object>> getTbNum(String tableName, String tbIds) {
        String tbFilter = "";
        if (StringUtils.isNotBlank((CharSequence)tbIds)) {
            tbFilter = " with tmp as (select unnest(string_to_array('" + tbIds + "',',')) f_id ) ";
        }
        String tbSql = "";
        if (StringUtils.isNotBlank((CharSequence)tbFilter)) {
            tbSql = ",tmp where tmp.f_id = t.f_id ";
        }
        String tbNumSql = tbFilter + "select substring(f_xzqdmsys,1,6) f_xzqdm,  count(1)  tbnum , count(f_status = 1 OR NULL) wxfnum , count(f_status = 2 OR NULL) wtjnum, count(f_status = 5 OR NULL) ythnum, count((f_status>=4 and f_submit_userid is not null) or NULL ) wyhcnum,  count((f_status>=4 and f_submit_userid is null) or NULL ) nyhcnum  from " + tableName + " t " + tbSql + " group by substring(f_xzqdmsys,1,6)";
        List tbNumList = this.jdbcTemplate.queryForList(tbNumSql);
        HashMap<String, Map<String, Object>> tbNumMap = new HashMap<String, Map<String, Object>>();
        for (int i = 0; i < tbNumList.size(); ++i) {
            tbNumMap.put(((Map)tbNumList.get(i)).get("f_xzqdm").toString(), (Map<String, Object>)tbNumList.get(i));
        }
        return tbNumMap;
    }

    public Map<String, Map<String, Object>> getShNum(String tableName, String taskId, String tbIds) {
        String tbFilter = "";
        if (StringUtils.isNotBlank((CharSequence)tbIds)) {
            tbFilter = " with tmp1 as (select unnest(string_to_array('" + tbIds + "',',')) f_id ) ";
        }
        String tbSql = "";
        String tableSql = "";
        if (StringUtils.isNotBlank((CharSequence)tbFilter)) {
            tbSql = " and tb.f_id = tmp1.f_id ";
            tableSql = ",tmp1";
        }
        String sql = tbFilter + "select \nf_xzqdm,\nsum(\ncase when (code = 0 and f_stepname = '\u533a\u53bf\u5ba1\u6838') or f_review_stage > 93 then 1 else 0 \nend ) as qxtgnum,\nsum(\ncase when (code = 1 and f_stepname = '\u533a\u53bf\u5ba1\u6838') and f_review_stage < 95 then 1 else 0 \nend ) as qxwtgnum,\nsum(\ncase when (code = 0 and f_stepname = '\u5e02\u7ea7\u5ba1\u6838') or f_review_stage = 101 then 1 else 0 \nend ) as sjtgnum,\nsum(\ncase when (code = 1 and f_stepname = '\u5e02\u7ea7\u5ba1\u6838') and f_review_stage < 101 then 1 else 0 \nend ) as sjwtgnum\nfrom (\nwith tmp as (\n\tselect f_taskid,f_tbid,f_stepname,f_approve_time timedate,0 code  from tbtsk_approve_record ar where ar.f_is_revoked is null and  f_taskid = '" + taskId + "' \n\tunion all \n\tselect f_taskid,f_tbid,f_stepname,f_reject_time timedate,1 code from tbtsk_reject_record rr where f_taskid = '" + taskId + "'\n)\nselect substring(tb.f_xzqdmsys,1,6) f_xzqdm,region.f_xzqmc,tb.f_review_stage,tb.f_id,tb.f_tbbh,tmp.* from " + tableName + " tb,tmp,tb_region region" + tableSql + " where tb.f_id = tmp.f_tbid\nand not exists(select null from tmp t where t.f_tbid = tmp.f_tbid and t.timedate > tmp.timedate ) and region.f_xzqdm = substring(tb.f_xzqdmsys,1,6)\n" + tbSql + ") g group by f_xzqdm,f_xzqmc";
        List list = this.jdbcTemplate.queryForList(sql);
        HashMap<String, Map<String, Object>> shNumMap = new HashMap<String, Map<String, Object>>();
        for (Map map : list) {
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("qxtgnum", map.get("qxtgnum").toString());
            map1.put("qxwtgnum", map.get("qxwtgnum").toString());
            map1.put("sjtgnum", map.get("sjtgnum").toString());
            map1.put("sjwtgnum", map.get("sjwtgnum").toString());
            shNumMap.put(map.get("f_xzqdm").toString(), map1);
        }
        return shNumMap;
    }

    public String createCgjcProgressExcel(List<Region> cRegions, Map<String, Map<String, Object>> tbNumMap, Map<String, Map<String, Object>> shNumMap, Integer totalNum, Integer submitNum) throws Exception {
        ClassPathResource STSONG = new ClassPathResource("/static/excel/\u5e38\u89c4\u76d1\u6d4b\u8fdb\u5ea6\u7edf\u8ba1\u6a21\u677f.xls");
        File STSONGFile = File.createTempFile("template_STSONG_copy", ".xls");
        FileUtils.copyInputStreamToFile((InputStream)STSONG.getInputStream(), (File)STSONGFile);
        String srcFileName = STSONGFile.getAbsolutePath();
        String ouputFile = this.uploadDir + File.separator + "excel";
        String ouputPath = this.uploadDir + File.separator + "excel" + File.separator + ("\u5e38\u89c4\u76d1\u6d4b\u8fdb\u5ea6\u7edf\u8ba1_" + System.currentTimeMillis() + ".xls");
        try {
            ArrayList listMap = new ArrayList();
            for (int i = 0; i < cRegions.size(); ++i) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("xzqmc", cRegions.get(i).getName());
                if (tbNumMap.get(cRegions.get(i).getCode()) != null) {
                    data.put("tbnum", tbNumMap.get(cRegions.get(i).getCode()).get("tbnum").toString());
                    data.put("wxfnum", tbNumMap.get(cRegions.get(i).getCode()).get("wxfnum").toString());
                    data.put("wtjnum", tbNumMap.get(cRegions.get(i).getCode()).get("wtjnum").toString());
                    data.put("ythnum", tbNumMap.get(cRegions.get(i).getCode()).get("ythnum").toString());
                    data.put("wyhcnum", tbNumMap.get(cRegions.get(i).getCode()).get("wyhcnum").toString());
                    data.put("nyhcnum", tbNumMap.get(cRegions.get(i).getCode()).get("nyhcnum").toString());
                } else {
                    data.put("tbnum", "0");
                    data.put("wxfnum", "0");
                    data.put("wtjnum", "0");
                    data.put("ythnum", "0");
                    data.put("wyhcnum", "0");
                    data.put("nyhcnum", "0");
                }
                if (shNumMap.get(cRegions.get(i).getCode()) != null) {
                    data.put("qxtgnum", shNumMap.get(cRegions.get(i).getCode()).get("qxtgnum").toString());
                    data.put("qxwtgnum", shNumMap.get(cRegions.get(i).getCode()).get("qxwtgnum").toString());
                    data.put("sjtgnum", shNumMap.get(cRegions.get(i).getCode()).get("sjtgnum").toString());
                    data.put("sjwtgnum", shNumMap.get(cRegions.get(i).getCode()).get("sjwtgnum").toString());
                } else {
                    data.put("qxtgnum", "0");
                    data.put("qxwtgnum", "0");
                    data.put("sjtgnum", "0");
                    data.put("sjwtgnum", "0");
                }
                listMap.add(data);
            }
            HashMap map = new HashMap();
            map.put("maplist", listMap);
            TemplateExportParams params = new TemplateExportParams(srcFileName, new Integer[0]);
            Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, map);
            File savefile = new File(ouputFile);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            Sheet sheetAt = workbook.getSheetAt(0);
            int lastRowNum = 44;
            sheetAt.addMergedRegion(new CellRangeAddress(lastRowNum, lastRowNum, 0, 10));
            Row row = sheetAt.createRow(lastRowNum);
            Cell cell = row.createCell(0);
            cell.setCellValue("\u5907\u6ce8\uff1a\u56fe\u6591\u603b\u6570(" + totalNum + ")=\u672a\u63d0\u4ea4(" + (totalNum - submitNum) + ")+\u5df2\u63d0\u4ea4(" + submitNum + ")");
            row.setHeightInPoints(30.0f);
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cell.setCellStyle(cellStyle);
            FileOutputStream fos = new FileOutputStream(ouputPath);
            workbook.write((OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return ouputPath;
    }

    public DataDownloadRecord downloadCgjcProgress(TaskQueryParameter parameter, Long userId) {
        String taskId = parameter.getTaskId();
        DataDownloadRecord record = this.dataDownloadRecordService.buildDataDownloadRecordBaseInfo(taskId, null, userId.longValue());
        record.setName("\u5e38\u89c4\u76d1\u6d4b\u8fdb\u5ea6\u7edf\u8ba1(" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + ")");
        this.dataDownloadRecordService.save(record);
        if (this.redisTemplate.hasKey((Object)record.getId()).booleanValue()) {
            this.redisTemplate.delete((Object)record.getId());
        }
        this.redisTemplate.opsForValue().set((Object)record.getId(), (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)record), 2L, TimeUnit.DAYS);
        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(StringUtils.isNotBlank((CharSequence)taskId) ? taskId : "");
        attachParameter.setTbIds(StringUtils.isNotBlank((CharSequence)parameter.getTbIds()) ? parameter.getTbIds() : "");
        attachParameter.setTbNames("");
        attachParameter.setUserId(userId);
        attachParameter.setCondition(JSONObject.toJSONString((Object)parameter));
        attachParameter.setBizType("statistics");
        attachParameter.setRecordId(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{record.getId()}) ? record.getId() : "");
        attachParameter.setDownloadType(Integer.valueOf(0));
        attachParameter.setDataType("progressRecord");
        String parameterString = JSONObject.toJSONString((Object)attachParameter);
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(parameterString);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(Integer.valueOf(1));
        taskRecord.setBizId(taskId);
        taskRecord.setUserid(userId);
        this.taskRecordService.save(taskRecord);
        return record;
    }

    public void runDownloadCgjcProgress(TaskRecord taskRecord, DownloadParameter downloadParameter) throws Exception {
        DataDownloadRecord dataDownloadRecord = null;
        try {
            Object value = this.redisTemplate.opsForValue().get((Object)downloadParameter.getRecordId());
            if (value != null && (dataDownloadRecord = (DataDownloadRecord)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)value.toString()), DataDownloadRecord.class)) != null) {
                if (this.dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)) {
                    throw new Exception("\u7528\u6237\u53d6\u6d88\u4e86\u4e0b\u8f7d\u4efb\u52a1");
                }
                String condition = downloadParameter.getCondition();
                TaskQueryParameter parameter = (TaskQueryParameter)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)condition), TaskQueryParameter.class);
                String path = this.createCgjcProgress(parameter, parameter.getRegionCode(), parameter.getUserId());
                File srcFile = new File(path);
                this.logger.info("\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d \u5f00\u59cb\u4e0a\u4f20\u5230obs " + path, new Object[0]);
                String resultUrl = "";
                resultUrl = "lan".equals(this.applicationType) ? this.uploadFileToDisk(taskRecord.getUserid(), srcFile) : this.uploadFileToCloudDisk(taskRecord.getUserid(), srcFile);
                if (this.dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)) {
                    throw new Exception("\u7528\u6237\u53d6\u6d88\u4e86\u4e0b\u8f7d\u4efb\u52a1");
                }
                Double fileSize = (double)srcFile.length() / 1024.0;
                dataDownloadRecord.setAttachSize(fileSize);
                dataDownloadRecord.setUrl(resultUrl);
                dataDownloadRecord.setEndTime(new Date());
                dataDownloadRecord.setState(DataDownloadStateEnum.FINISTHE);
                this.dataDownloadRecordService.save(dataDownloadRecord);
                srcFile.delete();
            }
        }
        catch (Exception e) {
            dataDownloadRecord.setEndTime(new Date());
            dataDownloadRecord.setState(DataDownloadStateEnum.FAILED);
            dataDownloadRecord.setErrorMsg(e.getMessage());
            this.dataDownloadRecordService.update(dataDownloadRecord);
            throw e;
        }
    }

    private String uploadFileToCloudDisk(Long userId, File file) {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        return this.ossOperatorService.sendObject2Oss(sendObjName, file);
    }

    private String uploadFileToDisk(Long userId, File file) throws Exception {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        String resultUrl = "";
        File destFile = new File(this.applicationType, "media/" + file.getName());
        FileUtils.copyFile((File)file, (File)destFile);
        resultUrl = "media/" + sendObjName;
        return resultUrl;
    }
}

