/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.statistics;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.model.statistics.dto.GdLrLcTotalEntity;
import com.geoway.landteam.landcloud.servface.pub.MinIOService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="GdLcTotalService")
public class GdLcTotalService {
    private GiLoger logger = GwLoger.getLoger(GdLcTotalService.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    private MinIOService minIOService;
    @Value(value="${project.applicationType}")
    protected String applicationType;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    private ExecutorService executor = Executors.newCachedThreadPool();
    @Resource
    TaskRecordService taskRecordService;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    SysConfigRepository configRepository;
    @Autowired
    RegionService regionService;
    @Autowired
    MTskTaskBizService tskTaskBizService;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    RedisTemplate redisTemplate;
    public String tableConditionSql = "";
    public String lrlcTemplateId = "b5dee4b2-8b06-414a-b182-2715079afe93";

    public String createGdLrLcTotal(TskTaskBiz tskTaskBiz, String xzqdm, Long userId, String conditionSql, String shhj, String shzt, String shsjStart, String shsjEnd) throws Exception {
        int i;
        this.tableConditionSql = conditionSql;
        JSONObject paramObject = new JSONObject();
        String paramKey = "";
        if (this.redisTemplate.hasKey((Object)(tskTaskBiz.getId() + "_GdLrLcParamObject")).booleanValue()) {
            paramObject = (JSONObject)this.redisTemplate.opsForValue().get((Object)(tskTaskBiz.getId() + "_GdLrLcParamObject"));
        } else {
            paramObject.put(this.tableConditionSql, (Object)(tskTaskBiz.getId() + "_GdLrLcParamObject_" + paramObject.size()));
            this.redisTemplate.opsForValue().set((Object)(tskTaskBiz.getId() + "_GdLrLcParamObject"), (Object)paramObject, 21600L, TimeUnit.SECONDS);
        }
        if (paramObject.containsKey((Object)this.tableConditionSql)) {
            paramKey = paramObject.getString(this.tableConditionSql);
        } else {
            paramKey = tskTaskBiz.getId() + "_GdLrLcParamObject_" + paramObject.size();
            paramObject.put(this.tableConditionSql, (Object)paramKey);
            this.redisTemplate.opsForValue().set((Object)(tskTaskBiz.getId() + "_GdLrLcParamObject"), (Object)paramObject, 21600L, TimeUnit.SECONDS);
        }
        TbtskObjectinfo tbtskObjectinfo = null;
        if (tskTaskBiz != null && StringUtils.isNotBlank((CharSequence)tskTaskBiz.getTableId())) {
            tbtskObjectinfo = this.tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        }
        SysConfig config = this.configRepository.queryByKey("xzqCode");
        String provinceCode = config.getValue().substring(0, 3) + "%";
        List result = new ArrayList();
        if (this.redisTemplate.hasKey((Object)"region_all").booleanValue()) {
            result = (List)this.redisTemplate.opsForValue().get((Object)"region_all");
        } else {
            result = this.regionService.queryAllRegionAndCode(provinceCode);
            this.redisTemplate.opsForValue().set((Object)"region_all", result, 30L, TimeUnit.DAYS);
        }
        ArrayList cRegions = new ArrayList();
        String includeRegion = "500100\u3001500200\u3001500000";
        if (StringUtils.isBlank((CharSequence)xzqdm) || xzqdm.equals("500000")) {
            for (i = 0; i < result.size(); ++i) {
                if (includeRegion.indexOf(((Region)result.get(i)).getCode()) != -1) continue;
                cRegions.add(result.get(i));
            }
        } else {
            for (i = 0; i < result.size(); ++i) {
                if (xzqdm.indexOf(((Region)result.get(i)).getCode()) == -1 || includeRegion.indexOf(((Region)result.get(i)).getCode()) != -1) continue;
                cRegions.add(result.get(i));
            }
        }
        String path = "";
        try {
            ArrayList<GdLrLcTotalEntity> gdLrLcTotalList = new ArrayList<GdLrLcTotalEntity>();
            for (int i2 = 0; i2 < cRegions.size(); ++i2) {
                GdLrLcTotalEntity gdLrLcTotalEntity = new GdLrLcTotalEntity();
                if (StringUtils.isNotBlank((CharSequence)paramKey) && this.redisTemplate.hasKey((Object)(paramKey + "_LC_" + ((Region)cRegions.get(i2)).getCode())).booleanValue()) {
                    gdLrLcTotalEntity = (GdLrLcTotalEntity)this.redisTemplate.opsForValue().get((Object)(paramKey + "_LC_" + ((Region)cRegions.get(i2)).getCode()));
                } else {
                    gdLrLcTotalEntity.setXzqdm(((Region)cRegions.get(i2)).getCode());
                    gdLrLcTotalEntity.setXzqmc(((Region)cRegions.get(i2)).getName());
                    this.getGdLrLcTotalData(tbtskObjectinfo, gdLrLcTotalEntity);
                    this.redisTemplate.opsForValue().set((Object)(paramKey + "_LC_" + ((Region)cRegions.get(i2)).getCode()), (Object)gdLrLcTotalEntity, 21600L, TimeUnit.SECONDS);
                }
                gdLrLcTotalEntity.setOrder(i2 + 1);
                gdLrLcTotalList.add(gdLrLcTotalEntity);
            }
            path = this.createGdLrLcTotalExcel(gdLrLcTotalList, shhj, shzt, shsjStart, shsjEnd);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u5bfc\u51fa\u5931\u8d25");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createGdLrLcTotalExcel(List<GdLrLcTotalEntity> gdLrLcTotalList, String shhj, String shzt, String shsjStart, String shsjEnd) throws Exception {
        ClassPathResource xftbmx = new ClassPathResource("/excel/\u8015\u5730\u6d41\u5165\u6d41\u51fa\u7cfb\u7edf\u6293\u53d6\u6c47\u603b\u8868\u6a21\u677f.xls");
        InputStream gdlrlcInputStream = xftbmx.getInputStream();
        File gdlrlcFile = File.createTempFile("template_gdlrlc_copy", ".xls");
        try {
            FileUtils.copyInputStreamToFile((InputStream)gdlrlcInputStream, (File)gdlrlcFile);
        }
        finally {
            IOUtils.closeQuietly((InputStream)gdlrlcInputStream);
        }
        String srcFileName = gdlrlcFile.getAbsolutePath();
        String ouputFile = this.uploadDir + File.separator + "excel";
        String ouputPath = this.uploadDir + File.separator + "excel" + File.separator + ("\u8015\u5730\u6d41\u51fa\u7cfb\u7edf\u6293\u53d6\u6c47\u603b\u8868_" + System.currentTimeMillis() + ".xls");
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<Map<String, String>> listMap = new ArrayList<Map<String, String>>();
            for (int i = 0; i < gdLrLcTotalList.size(); ++i) {
                Map<String, String> cmap = GdLcTotalService.beanToMap(gdLrLcTotalList.get(i));
                listMap.add(cmap);
            }
            map.put("maplist", listMap);
            map.put("shhj", shhj);
            map.put("shzt", "\u901a\u8fc7");
            map.put("shsjStart", shsjStart);
            map.put("shsjEnd", shsjEnd);
            TemplateExportParams params = new TemplateExportParams(srcFileName, new Integer[0]);
            Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, map);
            File savefile = new File(ouputFile);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(ouputPath);
            workbook.write((OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return ouputPath;
    }

    public static Map<String, String> beanToMap(Object object) throws IllegalAccessException {
        Field[] fields;
        HashMap<String, String> map = new HashMap<String, String>();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(object).toString());
        }
        return map;
    }

    public void getGdLrLcTotalData(TbtskObjectinfo tbtskObjectinfo, GdLrLcTotalEntity gdLrLcTotalEntity) throws Exception {
        boolean isSplited = false;
        if (tbtskObjectinfo.getfIsspatial() != null && tbtskObjectinfo.getfIsspatial().equals(1) && StringUtils.isNotBlank((CharSequence)tbtskObjectinfo.getSplitTableName())) {
            isSplited = true;
        }
        String tableName = tbtskObjectinfo.getfTablename();
        String childTableName = tbtskObjectinfo.getSplitTableName();
        Integer integer = tbtskObjectinfo.getfIsspatial();
        String hfzygdSql = this.getHfzygdSql(tableName, gdLrLcTotalEntity, isSplited, false);
        String wfwgzygdSql = this.getWfwgzygdSql(tableName, gdLrLcTotalEntity, isSplited, false);
        String gdflhSql = this.getGdflhSql(tableName, gdLrLcTotalEntity, isSplited, false);
        String allSql = hfzygdSql + " UNION ALL " + wfwgzygdSql + " UNION ALL " + gdflhSql;
        List result = this.jdbcTemplate.queryForList(allSql);
        if (integer != null && integer.equals(1) && StringUtils.isNotBlank((CharSequence)childTableName)) {
            String childhfzygdSql = this.getHfzygdSql(childTableName, gdLrLcTotalEntity, isSplited, true);
            String childwfwgzygdSql = this.getWfwgzygdSql(childTableName, gdLrLcTotalEntity, isSplited, true);
            String childgdflhSql = this.getGdflhSql(childTableName, gdLrLcTotalEntity, isSplited, true);
            String childallSql = childhfzygdSql + " UNION ALL " + childwfwgzygdSql + " UNION ALL " + childgdflhSql;
            List childresult = this.jdbcTemplate.queryForList(childallSql);
            for (Map map : result) {
                String name = map.get("name").toString();
                double sum = Double.parseDouble(map.get("sum").toString());
                List filterMap = childresult.stream().filter(u -> u.get("name").toString().equals(name)).collect(Collectors.toList());
                if (filterMap == null || filterMap.size() < 0) continue;
                double childSum = Double.parseDouble(((Map)filterMap.get(0)).get("sum").toString());
                double allSum = sum + childSum;
                map.put(name, allSum);
            }
        }
        JSONObject jobj = new JSONObject();
        for (Map data : result) {
            jobj.put(data.get("name").toString(), data.get("sum"));
        }
        gdLrLcTotalEntity.setHfzygdxj(Double.valueOf(jobj.getDouble("hfzygdxj")) + Double.valueOf(jobj.getDouble("hfjsyd")));
        gdLrLcTotalEntity.setHfczjyqjc(Double.valueOf(jobj.getDouble("hfczjyqjc")).doubleValue());
        gdLrLcTotalEntity.setHfjtjs(Double.valueOf(jobj.getDouble("hfjtjs")).doubleValue());
        gdLrLcTotalEntity.setHflsyd(Double.valueOf(jobj.getDouble("hflsyd")).doubleValue());
        gdLrLcTotalEntity.setHfnfjs(Double.valueOf(jobj.getDouble("hfnfjs")).doubleValue());
        gdLrLcTotalEntity.setWfczzzjsyfw(Double.valueOf(jobj.getDouble("wfczzzjsyfw")).doubleValue());
        gdLrLcTotalEntity.setWfckyd(Double.valueOf(jobj.getDouble("wfckyd")).doubleValue());
        gdLrLcTotalEntity.setHfqtjs(new BigDecimal(gdLrLcTotalEntity.getHfzygdxj() - gdLrLcTotalEntity.getHfczjyqjc() - gdLrLcTotalEntity.getHfjtjs() - gdLrLcTotalEntity.getHflsyd() - gdLrLcTotalEntity.getHfnfjs() - Double.valueOf(jobj.getDouble("hfryjsyd"))).setScale(2, RoundingMode.HALF_UP).doubleValue());
        gdLrLcTotalEntity.setWfwgzygdxj(Double.valueOf(jobj.getDouble("wfwgzygdxj")).doubleValue());
        gdLrLcTotalEntity.setWfjtjs(Double.valueOf(jobj.getDouble("wfjtjs")).doubleValue());
        gdLrLcTotalEntity.setWfggfwjcssjs(Double.valueOf(jobj.getDouble("wfggfwjcssjs")).doubleValue());
        gdLrLcTotalEntity.setWfyqwpxj(Double.valueOf(jobj.getDouble("wfyqwpxj")).doubleValue());
        gdLrLcTotalEntity.setWfnfjs(Double.valueOf(jobj.getDouble("wfnfjs")).doubleValue());
        gdLrLcTotalEntity.setWfqtjs(new BigDecimal(gdLrLcTotalEntity.getWfwgzygdxj() - gdLrLcTotalEntity.getWfjtjs() - gdLrLcTotalEntity.getWfggfwjcssjs() - gdLrLcTotalEntity.getWfyqwpxj() - gdLrLcTotalEntity.getWfnfjs()).setScale(2, RoundingMode.HALF_UP).doubleValue());
        gdLrLcTotalEntity.setGdflhxj(Double.valueOf(jobj.getDouble("gdflhxj")).doubleValue());
        gdLrLcTotalEntity.setFlncdl(Double.valueOf(jobj.getDouble("flncdl")).doubleValue());
        gdLrLcTotalEntity.setFlssnyd(Double.valueOf(jobj.getDouble("flssnyd")).doubleValue());
        gdLrLcTotalEntity.setFlskjs(Double.valueOf(jobj.getDouble("flskjs")).doubleValue());
        gdLrLcTotalEntity.setFlgqjs(Double.valueOf(jobj.getDouble("flgqjs")).doubleValue());
        gdLrLcTotalEntity.setFlbwld(Double.valueOf(jobj.getDouble("flbwld")).doubleValue());
        gdLrLcTotalEntity.setFlbwyd(Double.valueOf(jobj.getDouble("flbwyd")).doubleValue());
        gdLrLcTotalEntity.setFlbwkt(Double.valueOf(jobj.getDouble("flbwkt")).doubleValue());
        gdLrLcTotalEntity.setFlbwqt(new BigDecimal(gdLrLcTotalEntity.getGdflhxj() - gdLrLcTotalEntity.getFlncdl() - gdLrLcTotalEntity.getFlssnyd() - gdLrLcTotalEntity.getFlskjs() - gdLrLcTotalEntity.getFlgqjs() - gdLrLcTotalEntity.getFlbwld() - gdLrLcTotalEntity.getFlbwyd() - gdLrLcTotalEntity.getFlbwkt()).setScale(2, RoundingMode.HALF_UP).doubleValue());
        gdLrLcTotalEntity.setGdzbphxj(0.0);
        gdLrLcTotalEntity.setZbtdzl(0.0);
        gdLrLcTotalEntity.setZbncjsydfk(0.0);
        gdLrLcTotalEntity.setGdjcphxj(0.0);
        gdLrLcTotalEntity.setJcldzzwgd(0.0);
        gdLrLcTotalEntity.setJcydzzwgd(0.0);
        gdLrLcTotalEntity.setJcktsmzzwgd(0.0);
        gdLrLcTotalEntity.setJcqtnydzzwgd(0.0);
        gdLrLcTotalEntity.setQtxzxj(0.0);
        gdLrLcTotalEntity.setQtbmxzgd(0.0);
        gdLrLcTotalEntity.setQtnmzzkkgd(0.0);
        gdLrLcTotalEntity.setQtlcgddzg(0.0);
        gdLrLcTotalEntity.setHj(gdLrLcTotalEntity.getHfzygdxj() + gdLrLcTotalEntity.getWfwgzygdxj() + gdLrLcTotalEntity.getGdflhxj());
        gdLrLcTotalEntity.setGdlrzj(new BigDecimal(gdLrLcTotalEntity.getQtxzxj() + gdLrLcTotalEntity.getGdjcphxj() + gdLrLcTotalEntity.getGdzbphxj()).setScale(2, RoundingMode.HALF_UP).doubleValue());
        gdLrLcTotalEntity.setYdgdzjl(Math.abs(gdLrLcTotalEntity.getGdlrzj()) - Math.abs(gdLrLcTotalEntity.getHj()));
    }

    public String getHfzygdSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity, boolean isSplited, boolean isChildTable) throws Exception {
        if (gdLrLcTotalEntity.getXzqdm() == null) {
            throw new Exception("\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String commSql = "";
        commSql = " f_zglx = '\u5408\u6cd5\u5360\u7528\u8015\u5730' and f_sfysx = '\u5177\u5907\u624b\u7eed' and f_rdwgdlc = '\u662f' and f_status >= 10 and f_xzqdmsys like '" + gdLrLcTotalEntity.getXzqdm() + "%' ";
        String isSplitedFilter = "";
        if (!isChildTable && isSplited) {
            isSplitedFilter = " and  (f_issplitted <> '1' or f_issplitted is null) ";
            commSql = commSql + isSplitedFilter;
        }
        String hfzygdxjSql = this.getSelectSql("f_gdzymj", "hfzygdxj", tableName) + commSql;
        String hfczjyqjcSql = this.getSelectSql("f_gdzymj", "hfczjyqjc", tableName) + commSql + " and (f_xzyjdl in ('08','09','10','11') or f_xzejdl in ('0701','0702','1301','1303','1304','1306','1309','1311','1313','1401','1402','1403')) ";
        String jtjsSql = this.getSelectSql("f_gdzymj", "hfjtjs", tableName) + commSql + " and (f_xzyjdl = '12' or f_sjyjydlx = '12') ";
        String nfjsSql = this.getSelectSql("f_gdzymj", "hfnfjs", tableName) + commSql + " and f_xzejdl in ('0703','0704') ";
        String lsydSql = this.getSelectSql("f_gdzymj", "hflsyd", tableName) + commSql + " and ( f_xzyjdl = '18' and (f_sjyjydlx != '12' and f_sjejydlx != '1501' )) ";
        String qtjsSql = this.getSelectSql("f_gdzymj", "hfqtjs", tableName) + commSql + " and (f_xzejdl in ('1312','1404','1501','1503','1505','1506','1507') or f_sjejydlx = '1501' or f_xzyjdl = '20') ";
        String jsydSql = "";
        String ryjsydSql = "";
        jsydSql = this.getSelectSql("f_gdzymj", "hfjsyd", tableName) + " f_zglx = '\u5408\u6cd5\u5360\u7528\u8015\u5730' and f_rdwgdlc = '\u662f' and f_status >= 10 and f_xzqdmsys = '" + gdLrLcTotalEntity.getXzqdm() + "'  and  f_xzejdl = '1501' " + isSplitedFilter;
        ryjsydSql = this.getSelectSql("f_gdzymj", "hfryjsyd", tableName) + " f_zglx = '\u5408\u6cd5\u5360\u7528\u8015\u5730' and f_sfysx = '\u5177\u5907\u624b\u7eed' and f_rdwgdlc = '\u662f' and f_status >= 10 and f_xzqdmsys = '" + gdLrLcTotalEntity.getXzqdm() + "'  and  f_xzejdl = '1501' " + isSplitedFilter;
        String allSql = hfzygdxjSql + " UNION ALL " + hfczjyqjcSql + " UNION ALL " + jtjsSql + " UNION ALL " + nfjsSql + " UNION ALL " + lsydSql + " UNION ALL " + jsydSql + " UNION ALL " + ryjsydSql + " UNION ALL " + qtjsSql;
        return allSql;
    }

    public String getWfwgzygdSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity, boolean isSplited, boolean isChildTable) throws Exception {
        if (gdLrLcTotalEntity.getXzqdm() == null) {
            throw new Exception("\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String commSql = "";
        commSql = " f_zglx = '\u65e0\u624b\u7eed\u5360\u7528\u8015\u5730' and f_sfysx = '\u4e0d\u5177\u5907\u624b\u7eed' and f_rdwgdlc = '\u662f' and f_status >= 10  and f_xzqdmsys like '" + gdLrLcTotalEntity.getXzqdm() + "%'";
        String isSplitedFilter = "";
        if (!isChildTable && isSplited) {
            isSplitedFilter = " and  (f_issplitted <> '1' or f_issplitted is null) ";
            commSql = commSql + isSplitedFilter;
        }
        String wfwgzygdxj = this.getSelectSql("f_gdzymj", "wfwgzygdxj", tableName) + commSql;
        String wfjtjsSql = this.getSelectSql("f_gdzymj", "wfjtjs", tableName) + commSql + " and ( f_xzyjdl = '12' or f_sjyjydlx = '12' ) ";
        String wfggfwjcssjsSql = this.getSelectSql("f_gdzymj", "wfggfwjcssjs", tableName) + commSql + " and (f_xzyjdl = '08' or f_xzejdl in ('1301','1303','1304','1306','1309','1313','1403') ) ";
        String wfyqwpxjSql = this.getSelectSql("f_gdzymj", "wfyqwpxj", tableName) + commSql + " and ( f_xzejdl = '1001' or f_sjejydlx = '1001' )  and f_sfgyyq='\u662f' ";
        String wfnfjsSql = this.getSelectSql("f_gdzymj", "wfnfjs", tableName) + commSql + " and  ( f_xzejdl in ('0703','0704') or f_sjejydlx in ('0704','0703')) ";
        String wfczzzjsyfw = this.getSelectSql("f_gdzymj", "wfczzzjsyfw", tableName) + commSql + " and  ( f_xzyjdl = '09' or f_xzyjdl = '11' or f_xzejdl in ('0701','0702') or f_sjyjydlx = '09' or f_sjyjydlx = '11' or f_sjyjydlx in ('0701','0702') ) ";
        String wflhzj = this.getSelectSql("f_gdzymj", "wflhzj", tableName) + commSql + " and  (f_xzejdl in ('1401','1402','1404')  or f_sjyjydlx in ('1401','1402','1404') ) ";
        String wfckyd = this.getSelectSql("f_gdzymj", "wfckyd", tableName) + commSql + " and  (f_xzejdl = '1002' or f_sjejydlx = '1002' ) ";
        String wfqtjsSql = this.getSelectSql("f_gdzymj", "wfqtjs", tableName) + commSql + " and (f_xzejdl in ('1311','1312','1503','1505','1506','1507') or f_sjejydlx in ('1311','1312','1503','1505','1506','1507') or f_xzyjdl in ('20') or f_sjejydlx in ('20','26'))  ";
        String allSql = wfwgzygdxj + " UNION ALL " + wfjtjsSql + " UNION ALL " + wfggfwjcssjsSql + " UNION ALL " + wfyqwpxjSql + " UNION ALL " + wfnfjsSql + " UNION ALL " + wfqtjsSql + " UNION ALL " + wflhzj + " UNION ALL " + wfckyd + " UNION ALL " + wfczzzjsyfw;
        return allSql;
    }

    public String getGdflhSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity, boolean isSplited, boolean isChildTable) throws Exception {
        if (gdLrLcTotalEntity.getXzqdm() == null) {
            throw new Exception("\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String commSql = "";
        commSql = " f_zglx = '\u8015\u5730\u975e\u7cae\u5316' and f_status >=10  and f_rdwgdlc = '\u662f' and f_xzqdmsys like '" + gdLrLcTotalEntity.getXzqdm() + "%'";
        String isSplitedFilter = "";
        if (!isChildTable && isSplited) {
            isSplitedFilter = " and  (f_issplitted <> '1' or f_issplitted is null) ";
            commSql = commSql + isSplitedFilter;
        }
        String gdflhxj = this.getSelectSql("f_gdzymj", "gdflhxj", tableName) + commSql;
        String flncdlSql = this.getSelectSql("f_gdzymj", "flncdl", tableName) + commSql + " and f_xzejdl='0601' ";
        String flssnydSql = this.getSelectSql("f_gdzymj", "flssnyd", tableName) + commSql + " and f_xzejdl in ('0602','0603','0604') ";
        String flskjsSql = this.getSelectSql("f_gdzymj", "flskjs", tableName) + commSql + " and f_xzejdl='1703' ";
        String flgqjsSql = this.getSelectSql("f_gdzymj", "flgqjs", tableName) + commSql + " and  f_xzejdl ='1705' ";
        String flbwldSql = this.getSelectSql("f_gdzymj", "flbwld", tableName) + commSql + " and f_xzyjdl ='03' ";
        String flbwydSql = this.getSelectSql("f_gdzymj", "flbwyd", tableName) + commSql + " and f_xzyjdl ='02' ";
        String flbwktSql = this.getSelectSql("f_gdzymj", "flbwkt", tableName) + commSql + " and f_xzejdl = '1704' ";
        String flbwqtSql = this.getSelectSql("f_gdzymj", "flbwqt", tableName) + commSql + " and f_xzyjdl not in ('02','03') and f_xzejdl not in ('0602','0603','0604','1703','1704','1705') ";
        String allSql = gdflhxj + " UNION ALL " + flncdlSql + " UNION ALL " + flssnydSql + " UNION ALL " + flskjsSql + " UNION ALL " + flgqjsSql + " UNION ALL " + flbwldSql + " UNION ALL " + flbwydSql + " UNION ALL " + flbwktSql + " UNION ALL " + flbwqtSql;
        return allSql;
    }

    public String getSelectSql(String sumName, String colName, String tableName) {
        String selectSql = "";
        selectSql = this.tableConditionSql.equals("") ? " select COALESCE(sum(" + sumName + "),0)  as sum, '" + colName + "' as name from " + tableName + " where " : " select COALESCE(sum(" + sumName + "),0)  as sum, '" + colName + "' as name from ( select tb.* from " + tableName + " as tb " + this.tableConditionSql + ") t where ";
        return selectSql;
    }

    public DataDownloadRecord downloadGdLrLcTotalExcel(TaskQueryParameter parameter, Long userId) {
        String taskId = parameter.getTaskId();
        DataDownloadRecord record = this.dataDownloadRecordService.buildDataDownloadRecordBaseInfo(taskId, null, userId.longValue());
        record.setName("\u8015\u5730\u6d41\u5165\u6d41\u51fa\u6c47\u603b(" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + ")");
        this.dataDownloadRecordService.save(record);
        if (this.redisTemplate.hasKey((Object)record.getId()).booleanValue()) {
            this.redisTemplate.delete((Object)record.getId());
        }
        this.redisTemplate.opsForValue().set((Object)record.getId(), (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)record), 2L, TimeUnit.DAYS);
        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(StringUtils.isNotBlank((CharSequence)taskId) ? taskId : "");
        attachParameter.setTbIds(StringUtils.isNotBlank((CharSequence)parameter.getTbIds()) ? parameter.getTbIds() : "");
        attachParameter.setTbNames("");
        attachParameter.setUserId(userId);
        attachParameter.setCondition(JSONObject.toJSONString((Object)parameter));
        attachParameter.setBizType("statistics");
        attachParameter.setRecordId(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{record.getId()}) ? record.getId() : "");
        attachParameter.setDownloadType(Integer.valueOf(0));
        attachParameter.setDataType("gdLrLcRecord");
        String parameterString = JSONObject.toJSONString((Object)attachParameter);
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(parameterString);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(Integer.valueOf(1));
        taskRecord.setBizId(taskId);
        taskRecord.setUserid(userId);
        this.taskRecordService.save(taskRecord);
        return record;
    }

    public void runDownloadGdLrLcTotalExcel(TaskRecord taskRecord, DownloadParameter downloadParameter) throws Exception {
        DataDownloadRecord dataDownloadRecord = null;
        try {
            Object value = this.redisTemplate.opsForValue().get((Object)downloadParameter.getRecordId());
            if (value != null && (dataDownloadRecord = (DataDownloadRecord)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)value.toString()), DataDownloadRecord.class)) != null) {
                if (this.dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)) {
                    throw new Exception("\u7528\u6237\u53d6\u6d88\u4e86\u4e0b\u8f7d\u4efb\u52a1");
                }
                String condition = downloadParameter.getCondition();
                TaskQueryParameter parameter = (TaskQueryParameter)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)condition), TaskQueryParameter.class);
                TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(parameter.getTaskId());
                Pair<String, String> queryParamPair = this.tskTaskBizService.parseQueryParameter(parameter);
                String conditionSql = " where " + (String)queryParamPair.getRight();
                String path = this.createGdLrLcTotal(tskTaskBiz, parameter.getRegionCode(), parameter.getUserId(), conditionSql, "", "", "", "");
                File srcFile = new File(path);
                this.logger.info("\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d \u5f00\u59cb\u4e0a\u4f20\u5230obs " + path, new Object[0]);
                String resultUrl = "";
                resultUrl = "lan".equals(this.applicationType) ? this.uploadFileToDisk(taskRecord.getUserid(), srcFile) : this.uploadFileToCloudDisk(taskRecord.getUserid(), srcFile);
                if (this.dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)) {
                    throw new Exception("\u7528\u6237\u53d6\u6d88\u4e86\u4e0b\u8f7d\u4efb\u52a1");
                }
                Double fileSize = (double)srcFile.length() / 1024.0;
                dataDownloadRecord.setAttachSize(fileSize);
                dataDownloadRecord.setUrl(resultUrl);
                dataDownloadRecord.setEndTime(new Date());
                dataDownloadRecord.setState(DataDownloadStateEnum.FINISTHE);
                this.dataDownloadRecordService.save(dataDownloadRecord);
                srcFile.delete();
            }
        }
        catch (Exception e) {
            dataDownloadRecord.setEndTime(new Date());
            dataDownloadRecord.setState(DataDownloadStateEnum.FAILED);
            dataDownloadRecord.setErrorMsg(e.getMessage());
            this.dataDownloadRecordService.update(dataDownloadRecord);
            throw e;
        }
    }

    private String uploadFileToCloudDisk(Long userId, File file) {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        return this.ossOperatorService.sendObject2Oss(sendObjName, file);
    }

    private String uploadFileToDisk(Long userId, File file) throws Exception {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        String resultUrl = "";
        File destFile = new File(this.applicationType, "media/" + file.getName());
        FileUtils.copyFile((File)file, (File)destFile);
        resultUrl = "media/" + sendObjName;
        return resultUrl;
    }
}

