/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.statistics;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.model.statistics.dto.GdLrLcTotalEntity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Constants;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="GdLrLcTotalService")
public class GdLrLcTotalService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="{project.uploadDir}")
    protected String uploadDir;
    private ExecutorService executor = Executors.newCachedThreadPool();
    @Autowired
    SysConfigRepository configRepository;
    @Autowired
    RegionService regionService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    RedisTemplate redisTemplate;
    public String tableConditionSql = "";

    public String createGdLrLcTotal(TskTaskBiz tskTaskBiz, String xzqdm, Long userId, String conditionSql, String shhj, String shzt, String shsjStart, String shsjEnd) throws Exception {
        int i;
        this.tableConditionSql = conditionSql;
        TbtskObjectinfo tbtskObjectinfo = null;
        if (tskTaskBiz != null && StringUtils.isNotBlank((CharSequence)tskTaskBiz.getTableId())) {
            tbtskObjectinfo = this.tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        }
        Boolean isLrlc = false;
        SysConfig config = this.configRepository.queryByKey("xzqCode");
        String provinceCode = config.getValue().substring(0, 3) + "%";
        List result = this.regionService.queryAllRegions(provinceCode);
        ArrayList cRegions = new ArrayList();
        String includeRegion = "500100\u3001500200\u3001500000";
        if (xzqdm.equals("") || xzqdm.equals("500000")) {
            for (i = 0; i < result.size(); ++i) {
                if (includeRegion.indexOf(((Region)result.get(i)).getCode()) != -1) continue;
                cRegions.add(result.get(i));
            }
        } else {
            for (i = 0; i < result.size(); ++i) {
                if (xzqdm.indexOf(((Region)result.get(i)).getCode()) == -1 || includeRegion.indexOf(((Region)result.get(i)).getCode()) != -1) continue;
                cRegions.add(result.get(i));
            }
        }
        String path = "";
        try {
            ArrayList<GdLrLcTotalEntity> gdLrLcTotalList = new ArrayList<GdLrLcTotalEntity>();
            for (int i2 = 0; i2 < cRegions.size(); ++i2) {
                GdLrLcTotalEntity gdLrLcTotalEntity = new GdLrLcTotalEntity();
                if (this.redisTemplate.hasKey((Object)(tbtskObjectinfo.getfTablename() + "_" + ((Region)cRegions.get(i2)).getCode())).booleanValue()) {
                    gdLrLcTotalEntity = (GdLrLcTotalEntity)this.redisTemplate.opsForValue().get((Object)(tbtskObjectinfo.getfTablename() + "_" + ((Region)cRegions.get(i2)).getCode()));
                } else {
                    gdLrLcTotalEntity.setXzqdm(((Region)cRegions.get(i2)).getCode());
                    gdLrLcTotalEntity.setXzqmc(((Region)cRegions.get(i2)).getName());
                    this.getGdLrLcTotalData(tbtskObjectinfo.getfTablename(), gdLrLcTotalEntity, isLrlc);
                    this.redisTemplate.opsForValue().set((Object)(tbtskObjectinfo.getfTablename() + "_" + ((Region)cRegions.get(i2)).getCode()), (Object)gdLrLcTotalEntity, 10L, TimeUnit.SECONDS);
                }
                gdLrLcTotalEntity.setOrder(i2 + 1);
                gdLrLcTotalList.add(gdLrLcTotalEntity);
            }
            path = this.createGdLrLcTotalExcel(gdLrLcTotalList, shhj, shzt, shsjStart, shsjEnd);
        }
        catch (Exception e) {
            throw new Exception("\u5bfc\u51fa\u5931\u8d25");
        }
        return path;
    }

    public String createGdLrLcTotalExcel(List<GdLrLcTotalEntity> gdLrLcTotalList, String shhj, String shzt, String shsjStart, String shsjEnd) throws Exception {
        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String pathRoot = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        String srcFileName = pathRoot + "excel" + File.separator + "\u8015\u5730\u6d41\u5165\u6d41\u51fa\u7cfb\u7edf\u6293\u53d6\u6c47\u603b\u8868\u6a21\u677f.xls";
        String ouputFile = this.uploadDir + File.separator + "excel";
        String ouputPath = this.uploadDir + File.separator + "excel" + File.separator + ("\u8015\u5730\u6d41\u5165\u6d41\u51fa\u7cfb\u7edf\u6293\u53d6\u6c47\u603b\u8868_" + System.currentTimeMillis() + ".xls");
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<Map<String, String>> listMap = new ArrayList<Map<String, String>>();
            for (int i = 0; i < gdLrLcTotalList.size(); ++i) {
                Map<String, String> cmap = GdLrLcTotalService.beanToMap(gdLrLcTotalList.get(i));
                listMap.add(cmap);
            }
            map.put("maplist", listMap);
            map.put("shhj", shhj);
            map.put("shzt", "\u901a\u8fc7");
            map.put("shsjStart", shsjStart);
            map.put("shsjEnd", shsjEnd);
            TemplateExportParams params = new TemplateExportParams(srcFileName, new Integer[0]);
            Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, map);
            File savefile = new File(ouputFile);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(ouputPath);
            workbook.write((OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return ouputPath;
    }

    public static Map<String, String> beanToMap(Object object) throws IllegalAccessException {
        Field[] fields;
        HashMap<String, String> map = new HashMap<String, String>();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(object).toString());
        }
        return map;
    }

    public void getGdLrLcTotalData(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity, Boolean isLrlc) throws Exception {
        String hfzygdSql = this.getHfzygdSql(tableName, gdLrLcTotalEntity, isLrlc);
        String wfwgzygdSql = this.getWfwgzygdSql(tableName, gdLrLcTotalEntity, isLrlc);
        String gdflhSql = this.getGdflhSql(tableName, gdLrLcTotalEntity, isLrlc);
        String gdzbphSql = this.getGdzbphSql(tableName, gdLrLcTotalEntity, isLrlc);
        String gdjcphSql = this.getGdjcphSql(tableName, gdLrLcTotalEntity, isLrlc);
        String qtxzSql = this.getQtxzSql(tableName, gdLrLcTotalEntity, isLrlc);
        String allSql = hfzygdSql + " UNION ALL " + wfwgzygdSql + " UNION ALL " + gdflhSql + " UNION ALL " + gdzbphSql + " UNION ALL " + gdjcphSql + " UNION ALL " + qtxzSql;
        List result = this.jdbcTemplate.queryForList(allSql);
        JSONObject jobj = new JSONObject();
        for (Map data : result) {
            jobj.put(data.get("name").toString(), data.get("sum"));
        }
        gdLrLcTotalEntity.setHfzygdxj(Double.valueOf(jobj.getDouble("hfzygdxj")) + Double.valueOf(jobj.getDouble("hfjsyd")));
        gdLrLcTotalEntity.setHfczjyqjc(Double.valueOf(jobj.getDouble("hfczjyqjc")).doubleValue());
        gdLrLcTotalEntity.setHfjtjs(Double.valueOf(jobj.getDouble("hfjtjs")).doubleValue());
        gdLrLcTotalEntity.setHflsyd(Double.valueOf(jobj.getDouble("hflsyd")).doubleValue());
        gdLrLcTotalEntity.setHfnfjs(Double.valueOf(jobj.getDouble("hfnfjs")).doubleValue());
        gdLrLcTotalEntity.setHfqtjs(new BigDecimal(gdLrLcTotalEntity.getHfzygdxj() - gdLrLcTotalEntity.getHfczjyqjc() - gdLrLcTotalEntity.getHfjtjs() - gdLrLcTotalEntity.getHflsyd() - gdLrLcTotalEntity.getHfnfjs() - Double.valueOf(jobj.getDouble("hfryjsyd"))).setScale(2, RoundingMode.HALF_UP).doubleValue());
        gdLrLcTotalEntity.setWfwgzygdxj(Double.valueOf(jobj.getDouble("wfwgzygdxj")).doubleValue());
        gdLrLcTotalEntity.setWfjtjs(Double.valueOf(jobj.getDouble("wfjtjs")).doubleValue());
        gdLrLcTotalEntity.setWfggfwjcssjs(Double.valueOf(jobj.getDouble("wfggfwjcssjs")).doubleValue());
        gdLrLcTotalEntity.setWfyqwpxj(Double.valueOf(jobj.getDouble("wfyqwpxj")).doubleValue());
        gdLrLcTotalEntity.setWfnfjs(Double.valueOf(jobj.getDouble("wfnfjs")).doubleValue());
        gdLrLcTotalEntity.setWfqtjs(new BigDecimal(gdLrLcTotalEntity.getWfwgzygdxj() - gdLrLcTotalEntity.getWfjtjs() - gdLrLcTotalEntity.getWfggfwjcssjs() - gdLrLcTotalEntity.getWfyqwpxj() - gdLrLcTotalEntity.getWfnfjs()).setScale(2, RoundingMode.HALF_UP).doubleValue());
        gdLrLcTotalEntity.setGdflhxj(Double.valueOf(jobj.getDouble("gdflhxj")).doubleValue());
        gdLrLcTotalEntity.setFlncdl(Double.valueOf(jobj.getDouble("flncdl")).doubleValue());
        gdLrLcTotalEntity.setFlssnyd(Double.valueOf(jobj.getDouble("flssnyd")).doubleValue());
        gdLrLcTotalEntity.setFlskjs(Double.valueOf(jobj.getDouble("flskjs")).doubleValue());
        gdLrLcTotalEntity.setFlgqjs(Double.valueOf(jobj.getDouble("flgqjs")).doubleValue());
        gdLrLcTotalEntity.setFlbwld(Double.valueOf(jobj.getDouble("flbwld")).doubleValue());
        gdLrLcTotalEntity.setFlbwyd(Double.valueOf(jobj.getDouble("flbwyd")).doubleValue());
        gdLrLcTotalEntity.setFlbwkt(Double.valueOf(jobj.getDouble("flbwkt")).doubleValue());
        gdLrLcTotalEntity.setFlbwqt(new BigDecimal(gdLrLcTotalEntity.getGdflhxj() - gdLrLcTotalEntity.getFlncdl() - gdLrLcTotalEntity.getFlssnyd() - gdLrLcTotalEntity.getFlskjs() - gdLrLcTotalEntity.getFlgqjs() - gdLrLcTotalEntity.getFlbwld() - gdLrLcTotalEntity.getFlbwyd() - gdLrLcTotalEntity.getFlbwkt()).setScale(2, RoundingMode.HALF_UP).doubleValue());
        gdLrLcTotalEntity.setGdzbphxj(Double.valueOf(jobj.getDouble("gdzbphxj")).doubleValue());
        gdLrLcTotalEntity.setZbtdzl(Double.valueOf(jobj.getDouble("zbtdzl")).doubleValue());
        gdLrLcTotalEntity.setZbncjsydfk(Double.valueOf(jobj.getDouble("zbncjsydfk")).doubleValue());
        gdLrLcTotalEntity.setGdjcphxj(Double.valueOf(jobj.getDouble("gdjcphxj")).doubleValue());
        gdLrLcTotalEntity.setJcldzzwgd(Double.valueOf(jobj.getDouble("jcldzzwgd")).doubleValue());
        gdLrLcTotalEntity.setJcydzzwgd(Double.valueOf(jobj.getDouble("jcydzzwgd")).doubleValue());
        gdLrLcTotalEntity.setJcktsmzzwgd(Double.valueOf(jobj.getDouble("jcktsmzzwgd")).doubleValue());
        gdLrLcTotalEntity.setJcqtnydzzwgd(Double.valueOf(jobj.getDouble("jcqtnydzzwgd")).doubleValue());
        gdLrLcTotalEntity.setQtxzxj(Double.valueOf(jobj.getDouble("qtxzxj")).doubleValue());
        gdLrLcTotalEntity.setQtbmxzgd(Double.valueOf(jobj.getDouble("qtbmxzgd")).doubleValue());
        gdLrLcTotalEntity.setQtnmzzkkgd(Double.valueOf(jobj.getDouble("qtnmzzkkgd")).doubleValue());
        gdLrLcTotalEntity.setQtlcgddzg(Double.valueOf(jobj.getDouble("qtlcgddzg")).doubleValue());
        gdLrLcTotalEntity.setHj(gdLrLcTotalEntity.getHfzygdxj() + gdLrLcTotalEntity.getWfwgzygdxj() + gdLrLcTotalEntity.getGdflhxj());
        gdLrLcTotalEntity.setGdlrzj(new BigDecimal(gdLrLcTotalEntity.getQtxzxj() + gdLrLcTotalEntity.getGdjcphxj() + gdLrLcTotalEntity.getGdzbphxj()).setScale(2, RoundingMode.HALF_UP).doubleValue());
        gdLrLcTotalEntity.setYdgdzjl(Math.abs(gdLrLcTotalEntity.getGdlrzj()) - Math.abs(gdLrLcTotalEntity.getHj()));
    }

    public String getHfzygdSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity, Boolean isLrlc) throws Exception {
        if (gdLrLcTotalEntity.getXzqdm() == null) {
            throw new Exception("\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String commSql = "";
        commSql = isLrlc != false ? " f_gdldfx = 'LC' and f_zglx = '\u5408\u6cd5\u5360\u7528\u8015\u5730' and f_sfysx = '\u5177\u5907\u624b\u7eed' and f_rdwgdlc = '\u662f' and f_status = 4 and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "' " : " f_zglx = '\u5408\u6cd5\u5360\u7528\u8015\u5730' and f_sfysx = '\u5177\u5907\u624b\u7eed' and f_rdwgdlc = '\u662f' and f_status = 4 and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "' ";
        String hfzygdxjSql = this.getSelectSql("f_tbmj", "hfzygdxj", tableName) + commSql;
        String hfczjyqjcSql = this.getSelectSql("f_tbmj", "hfczjyqjc", tableName) + commSql + " and (f_xzyjdl in ('08','09','10','11') or f_xzejdl in ('0701','0702','1301','1303','1304','1306','1309','1311','1313','1401','1402','1403')) ";
        String jtjsSql = this.getSelectSql("f_tbmj", "hfjtjs", tableName) + commSql + " and (f_xzyjdl = '12' or f_sjyjydlx = '12') ";
        String nfjsSql = this.getSelectSql("f_tbmj", "hfnfjs", tableName) + commSql + " and f_xzejdl in ('0703','0704') ";
        String lsydSql = this.getSelectSql("f_tbmj", "hflsyd", tableName) + commSql + " and ( f_xzyjdl = '18' and (f_sjyjydlx != '12' or f_sjejydlx != '1501' )) ";
        String qtjsSql = this.getSelectSql("f_tbmj", "hfqtjs", tableName) + commSql + " and (f_xzejdl in ('1312','1404','1501','1503','1505','1506','1507') or f_sjejydlx = '1501' or f_xzyjdl = '20') ";
        String jsydSql = "";
        String ryjsydSql = "";
        if (isLrlc.booleanValue()) {
            jsydSql = this.getSelectSql("f_tbmj", "hfjsyd", tableName) + " f_gdldfx = 'LC' and f_zglx = '\u5408\u6cd5\u5360\u7528\u8015\u5730' and f_rdwgdlc = '\u662f' and f_status = 4 and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "'  and  f_xzejdl = '1501' ";
            ryjsydSql = this.getSelectSql("f_tbmj", "hfryjsyd", tableName) + " f_gdldfx = 'LC' and f_zglx = '\u5408\u6cd5\u5360\u7528\u8015\u5730' and f_sfysx = '\u5177\u5907\u624b\u7eed' and f_rdwgdlc = '\u662f' and f_status = 4 and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "'  and  f_xzejdl = '1501' ";
        } else {
            jsydSql = this.getSelectSql("f_tbmj", "hfjsyd", tableName) + " f_zglx = '\u5408\u6cd5\u5360\u7528\u8015\u5730' and f_rdwgdlc = '\u662f' and f_status = 4 and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "'  and  f_xzejdl = '1501' ";
            ryjsydSql = this.getSelectSql("f_tbmj", "hfryjsyd", tableName) + " f_zglx = '\u5408\u6cd5\u5360\u7528\u8015\u5730' and f_sfysx = '\u5177\u5907\u624b\u7eed' and f_rdwgdlc = '\u662f' and f_status = 4 and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "'  and  f_xzejdl = '1501' ";
        }
        String allSql = hfzygdxjSql + " UNION ALL " + hfczjyqjcSql + " UNION ALL " + jtjsSql + " UNION ALL " + nfjsSql + " UNION ALL " + lsydSql + " UNION ALL " + jsydSql + " UNION ALL " + ryjsydSql + " UNION ALL " + qtjsSql;
        return allSql;
    }

    public String getWfwgzygdSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity, Boolean isLrlc) throws Exception {
        if (gdLrLcTotalEntity.getXzqdm() == null) {
            throw new Exception("\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String commSql = "";
        commSql = isLrlc != false ? " f_gdldfx = 'LC' and f_zglx = '\u65e0\u624b\u7eed\u5360\u7528\u8015\u5730' and f_sfysx = '\u4e0d\u5177\u5907\u624b\u7eed' and f_rdwgdlc = '\u662f' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "'" : " f_zglx = '\u65e0\u624b\u7eed\u5360\u7528\u8015\u5730' and f_sfysx = '\u4e0d\u5177\u5907\u624b\u7eed' and f_rdwgdlc = '\u662f' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "'";
        String wfwgzygdxj = this.getSelectSql("f_tbmj", "wfwgzygdxj", tableName) + commSql;
        String wfjtjsSql = this.getSelectSql("f_tbmj", "wfjtjs", tableName) + commSql + " and ( f_xzyjdl = '12' or f_sjyjydlx = '12' ) ";
        String wfggfwjcssjsSql = this.getSelectSql("f_tbmj", "wfggfwjcssjs", tableName) + commSql + " and (f_xzyjdl = '08' or f_xzejdl in ('1301','1303','1304','1306','1309','1313','1403') ) ";
        String wfyqwpxjSql = this.getSelectSql("f_tbmj", "wfyqwpxj", tableName) + commSql + " and ( f_xzejdl = '1001' or f_sjejydlx = '1001' )  and f_sfgyyq='\u662f' ";
        String wfnfjsSql = this.getSelectSql("f_tbmj", "wfnfjs", tableName) + commSql + " and  ( f_xzejdl in ('0703','0704') or f_sjejydlx in ('0704','0703')) ";
        String wfqtjsSql = this.getSelectSql("f_tbmj", "wfqtjs", tableName) + commSql + " and (f_xzejdl in ('1311','1312','1503','1505','1506','1507') or f_sjejydlx in ('1311','1312','1503','1505','1506','1507') or f_xzyjdl in ('20') or f_sjejydlx in ('20','26'))  ";
        String allSql = wfwgzygdxj + " UNION ALL " + wfjtjsSql + " UNION ALL " + wfggfwjcssjsSql + " UNION ALL " + wfyqwpxjSql + " UNION ALL " + wfnfjsSql + " UNION ALL " + wfqtjsSql;
        return allSql;
    }

    public String getGdflhSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity, Boolean isLrlc) throws Exception {
        if (gdLrLcTotalEntity.getXzqdm() == null) {
            throw new Exception("\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String commSql = "";
        commSql = isLrlc != false ? " f_gdldfx='LC' and f_zglx = '\u8015\u5730\u975e\u7cae\u5316' and f_status = 4  and f_rdwgdlc = '\u662f' and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "'" : " f_zglx = '\u8015\u5730\u975e\u7cae\u5316' and f_status = 4  and f_rdwgdlc = '\u662f' and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "'";
        String gdflhxj = this.getSelectSql("f_tbmj", "gdflhxj", tableName) + commSql;
        String flncdlSql = this.getSelectSql("f_tbmj", "flncdl", tableName) + commSql + " and f_xzejdl='0601' ";
        String flssnydSql = this.getSelectSql("f_tbmj", "flssnyd", tableName) + commSql + " and f_xzejdl in ('0602','0603','0604') ";
        String flskjsSql = this.getSelectSql("f_tbmj", "flskjs", tableName) + commSql + " and f_xzejdl='1703' ";
        String flgqjsSql = this.getSelectSql("f_tbmj", "flgqjs", tableName) + commSql + " and  f_xzejdl ='1705' ";
        String flbwldSql = this.getSelectSql("f_tbmj", "flbwld", tableName) + commSql + " and f_xzyjdl ='03' ";
        String flbwydSql = this.getSelectSql("f_tbmj", "flbwyd", tableName) + commSql + " and f_xzyjdl ='02' ";
        String flbwktSql = this.getSelectSql("f_tbmj", "flbwkt", tableName) + commSql + " and f_xzejdl = '1704' ";
        String flbwqtSql = this.getSelectSql("f_tbmj", "flbwqt", tableName) + commSql + " and f_xzyjdl not in ('02','03') and f_xzejdl not in ('0602','0603','0604','1703','1704','1705') ";
        String allSql = gdflhxj + " UNION ALL " + flncdlSql + " UNION ALL " + flssnydSql + " UNION ALL " + flskjsSql + " UNION ALL " + flgqjsSql + " UNION ALL " + flbwldSql + " UNION ALL " + flbwydSql + " UNION ALL " + flbwktSql + " UNION ALL " + flbwqtSql;
        return allSql;
    }

    public String getGdzbphSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity, Boolean isLrlc) throws Exception {
        if (gdLrLcTotalEntity.getXzqdm() == null) {
            throw new Exception("\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String commSql = "";
        commSql = isLrlc != false ? " f_gdldfx = 'LR' and f_xzgdly = '\u8015\u5730\u5360\u8865\u5e73\u8861\u65b0\u589e\u8015\u5730' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "'" : "  f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "'";
        String gdzbphxj = this.getSelectSql("f_tbmj", "gdzbphxj", tableName) + commSql;
        String zbtdzlSql = this.getSelectSql("f_tbmj", "zbtdzl", tableName) + commSql + " and f_xzgdlyej = '\u571f\u5730\u6574\u7406' ";
        String zbncjsydfkSql = this.getSelectSql("f_tbmj", "zbncjsydfk", tableName) + commSql + " and f_xzgdlyej = '\u519c\u6751\u5efa\u8bbe\u7528\u5730\u590d\u57a6' ";
        String allSql = gdzbphxj + " UNION ALL " + zbtdzlSql + " UNION ALL " + zbncjsydfkSql;
        return allSql;
    }

    public String getGdjcphSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity, Boolean isLrlc) throws Exception {
        if (gdLrLcTotalEntity.getXzqdm() == null) {
            throw new Exception("\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String commSql = "";
        commSql = isLrlc != false ? " f_gdldfx = 'LR' and f_xzgdly = '\u8015\u5730\u8fdb\u51fa\u5e73\u8861\u65b0\u589e\u8015\u5730' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "'" : " f_xzgdly = '\u8015\u5730\u8fdb\u51fa\u5e73\u8861\u65b0\u589e\u8015\u5730' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "'";
        String gdjcphxjSql = this.getSelectSql("f_tbmj", "gdjcphxj", tableName) + commSql;
        String jcldzzwgdSql = this.getSelectSql("f_tbmj", "jcldzzwgd", tableName) + commSql + " and f_xzgdlyej = '\u6797\u5730\u6574\u6cbb\u4e3a\u8015\u5730' ";
        String jcydzzwgdSql = this.getSelectSql("f_tbmj", "jcydzzwgd", tableName) + commSql + " and f_xzgdlyej = '\u56ed\u5730\u6574\u6cbb\u4e3a\u8015\u5730' ";
        String jcktsmzzwgdSql = this.getSelectSql("f_tbmj", "jcktsmzzwgd", tableName) + commSql + " and f_xzgdlyej = '\u5751\u5858\u6c34\u9762\u6574\u6cbb\u4e3a\u8015\u5730' ";
        String jcqtnydzzwgdSql = this.getSelectSql("f_tbmj", "jcqtnydzzwgd", tableName) + commSql + " and f_xzgdlyej = '\u5176\u4ed6\u519c\u7528\u5730\u6574\u6cbb\u4e3a\u8015\u5730' ";
        String allSql = gdjcphxjSql + " UNION ALL " + jcldzzwgdSql + " UNION ALL " + jcydzzwgdSql + " UNION ALL " + jcktsmzzwgdSql + " UNION ALL " + jcqtnydzzwgdSql;
        return allSql;
    }

    public String getQtxzSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity, Boolean isLrlc) throws Exception {
        if (gdLrLcTotalEntity.getXzqdm() == null) {
            throw new Exception("\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String commSql = "";
        commSql = isLrlc != false ? " f_gdldfx = 'LR' and f_xzgdly = '\u5176\u4ed6\u65b0\u589e' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "'" : " f_xzgdly = '\u5176\u4ed6\u65b0\u589e' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm() + "'";
        String qtxzxjSql = this.getSelectSql("f_tbmj", "qtxzxj", tableName) + commSql;
        String qtbmxzgdSql = this.getSelectSql("f_tbmj", "qtbmxzgd", tableName) + commSql + " and f_xzgdlyej = '\u5176\u4ed6\u90e8\u95e8\u65b0\u589e\u8015\u5730' ";
        String qtnmzzkkgdSql = this.getSelectSql("f_tbmj", "qtnmzzkkgd", tableName) + commSql + " and f_xzgdlyej = '\u519c\u6c11\u81ea\u4e3b\u5f00\u57a6\u8015\u5730' ";
        String qtlcgddzgSql = this.getSelectSql("f_tbmj", "qtlcgddzg", tableName) + commSql + " and f_xzgdlyej='\u8015\u5730\u6574\u6539\u6062\u590d' ";
        String allSql = qtxzxjSql + " UNION ALL " + qtbmxzgdSql + " UNION ALL " + qtnmzzkkgdSql + " UNION ALL " + qtlcgddzgSql;
        return allSql;
    }

    public String getSelectSql(String sumName, String colName, String tableName) {
        String selectSql = "";
        selectSql = this.tableConditionSql.equals("") ? " select COALESCE(sum(" + sumName + "),0)  as sum, '" + colName + "' as name from " + tableName + " where " : " select COALESCE(sum(" + sumName + "),0)  as sum, '" + colName + "' as name from ( select tb.* from " + tableName + " as tb " + this.tableConditionSql + ") t where ";
        return selectSql;
    }
}

