/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.statistics;

import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.datacq.LogService;
import com.geoway.landteam.landcloud.service.statistics.GdLrLcTotalService;
import com.geoway.landteam.landcloud.service.statistics.SeasonDao;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.postgresql.util.PGobject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="JdjcStatisticsService")
public class JdjcStatisticsService {
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    SeasonDao seasonDao;
    @Autowired
    private SysConfigRepository configRepository;
    @Autowired
    RegionService regionService;
    @Autowired
    private LogService logService;
    @Autowired
    private GdLrLcTotalService gdLrLcTotalService;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private GiLoger logger = GwLoger.getLoger(this.getClass());

    public List<Map<String, Object>> statisticYSTB(String quarterName) {
        return this.seasonDao.getYsBh(quarterName);
    }

    public List<Map<String, Object>> statisticYSTB(String quarterName, String xzqName) {
        return this.seasonDao.getYsBh(quarterName, xzqName);
    }

    public List<Map<String, Object>> statisticYSWF(String quarterName) {
        return this.seasonDao.getYsWf(quarterName);
    }

    public List<Map<String, Object>> statisticYSWF(String quarterName, String xzqName) {
        return this.seasonDao.getYsWf(quarterName, xzqName);
    }

    public Map<String, Object> statisticsSxsj(String quarterName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Map<String, Object>> temp = this.seasonDao.getSxsj(quarterName);
        for (Map<String, Object> item : temp) {
            String key = ((PGobject)item.get("f_sxbh")).getValue();
            if (result.containsKey(key)) {
                Map cur = (Map)result.get(key);
                long curCount = (Long)cur.get("f_count");
                BigDecimal curArea = (BigDecimal)cur.get("f_area");
                long count = (Long)item.get("f_count");
                BigDecimal area = (BigDecimal)item.get("f_area");
                item.put("f_count", count + curCount);
                item.put("f_area", curArea.add(area));
                result.put(key, item);
                continue;
            }
            result.put(key, item);
        }
        return result;
    }

    public Map<String, Object> statisticsSxsj(String quarterName, String xzqName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Map<String, Object>> temp = this.seasonDao.getSxsj(quarterName, xzqName);
        for (Map<String, Object> item : temp) {
            String key = ((PGobject)item.get("f_sxbh")).getValue();
            if (result.containsKey(key)) {
                Map cur = (Map)result.get(key);
                long curCount = (Long)cur.get("f_count");
                BigDecimal curArea = (BigDecimal)cur.get("f_area");
                long count = (Long)item.get("f_count");
                BigDecimal area = (BigDecimal)item.get("f_area");
                item.put("f_count", count + curCount);
                item.put("f_area", curArea.add(area));
                result.put(key, item);
                continue;
            }
            result.put(key, item);
        }
        return result;
    }

    public List<String> getAllQuarterName() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("2020\u5e74\u7b2c2\u5b63\u5ea6");
        result.add("2020\u5e74\u7b2c3\u5b63\u5ea6");
        result.add("2020\u5e74\u7b2c4\u5b63\u5ea6");
        result.add("2021\u5e74\u7b2c1\u5b63\u5ea6");
        result.add("2021\u5e74\u7b2c2\u5b63\u5ea6");
        result.add("2021\u5e74\u7b2c3\u5b63\u5ea6");
        return result;
    }

    public List<Map<String, Object>> allQuarterSpot() {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        List<String> allQuarterNameList = this.getAllQuarterName();
        for (String name : allQuarterNameList) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            Integer yswfCount = this.seasonDao.getYsWfCount(name);
            Integer ysbhCount = this.seasonDao.getYsBhCount(name);
            obj.put("yswf", yswfCount);
            obj.put("ysbh", ysbhCount);
            obj.put("quarterName", name);
            resultMap.add(obj);
        }
        return resultMap;
    }

    public List<Map<String, Object>> allQuarterSpot(String xzqName) {
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
        List<String> allQuarterNameList = this.getAllQuarterName();
        for (String name : allQuarterNameList) {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            Integer yswfCount = this.seasonDao.getYsWfCount(name, xzqName);
            Integer ysbhCount = this.seasonDao.getYsBhCount(name, xzqName);
            obj.put("yswf", yswfCount);
            obj.put("ysbh", ysbhCount);
            obj.put("quarterName", name);
            resultMap.add(obj);
        }
        return resultMap;
    }

    public Map<String, Integer> quarterSpotStatistics(String quarterName) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        resultMap.put("ysbh", this.seasonDao.getYsBhCount(quarterName));
        resultMap.put("yswf", this.seasonDao.getYsWfCount(quarterName));
        return resultMap;
    }

    public Map<String, Integer> quarterSpotStatistics(String quarterName, String xzqName) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        resultMap.put("ysbh", this.seasonDao.getYsBhCount(quarterName, xzqName));
        resultMap.put("yswf", this.seasonDao.getYsWfCount(quarterName, xzqName));
        return resultMap;
    }

    public Map<String, Object> statisticsQuerterTask(String quarterName) {
        Map<String, Object> resultMap = this.seasonDao.getQuerterTask(quarterName);
        return resultMap;
    }

    public Map<String, Object> statisticsQuerterTask(String quarterName, String xzqName) {
        Map<String, Object> resultMap = this.seasonDao.getQuerterTask(quarterName, xzqName);
        return resultMap;
    }

    public List<Map<String, Object>> statisticXzqTask(String quarterName) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> statusCountList = this.seasonDao.getAllXzqStatusCount(quarterName);
        List<Map<String, Object>> finishCountList = this.seasonDao.getFinishXzqStatusCount(quarterName);
        for (int i = 0; i < statusCountList.size(); ++i) {
            Long fCount;
            HashMap<String, Object> map = new HashMap<String, Object>();
            Long sCount = (Long)statusCountList.get(i).get("count");
            Long percent = 0L;
            map.put("xzqmc", statusCountList.get(i).get("xzqmc"));
            if (i < finishCountList.size()) {
                fCount = (Long)statusCountList.get(i).get("count");
                percent = fCount / sCount * 100L;
            } else {
                fCount = sCount;
                percent = 100L;
            }
            map.put("total", sCount);
            map.put("assigncount", fCount);
            map.put("percent", percent);
            resultList.add(map);
        }
        return resultList;
    }
}

