/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.statistics.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.pub.DataDownloadDailyTaskService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.dto.EasyUIResponse;
import com.geoway.landteam.landcloud.model.statistics.dto.CommonNum;
import com.geoway.landteam.landcloud.model.statistics.dto.Gztj;
import com.geoway.landteam.landcloud.model.statistics.dto.HeatMap;
import com.geoway.landteam.landcloud.model.statistics.dto.Wyjd;
import com.geoway.landteam.landcloud.service.statistics.CgjcService;
import com.geoway.landteam.landcloud.service.util.ShapeFile2Geo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

@Service
public class CgjcServiceImpl
implements CgjcService {
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private TbtskObjectinfoRepository objectinfoRepository;
    @Autowired
    private TskTaskBizRepository tbTaskBizRepository;
    @Autowired
    DataDownloadDailyTaskService dataDownloadDailyTaskService;

    @Override
    public List<HeatMap> getByWkt(String name, String wkt, Integer num, Double xmin, Double xmax, Double ymin, Double ymax, String isYswt) {
        List<TbtskObjectinfo> tableList = this.getTables(name);
        if (tableList.isEmpty()) {
            return null;
        }
        String queryFieldSql = " f_id,st_geomfromtext('POINT(' || f_lon || ' ' || f_lat || ')') as f_shape,f_lon,f_lat";
        String datasql = this.getTableSql(tableList, queryFieldSql, null);
        if (isYswt.equals("1")) {
            datasql = datasql + "  where f_yswt = '1' ";
        }
        if (!StringUtils.isEmpty((CharSequence)wkt)) {
            datasql = "select * from (" + datasql + ") w";
            datasql = datasql + " where ST_Contains( ST_GeometryFromText('" + wkt + "'), f_shape)";
        } else {
            datasql = "select * from (" + datasql + ") w";
            datasql = datasql + " where f_lon > " + ymin + " and f_lon < " + ymax + " and f_lat > " + xmin + " and f_lat < " + xmax;
        }
        Long count = this.getCount(datasql);
        Integer clusterNum = 100;
        if (null != num && count >= (long)num.intValue()) {
            clusterNum = num;
        } else if (count <= 10L) {
            clusterNum = Integer.valueOf(count.toString());
        } else if (count < 50L) {
            clusterNum = 10;
        } else if (count < 150L) {
            clusterNum = 30;
        } else if (count < 250L) {
            clusterNum = 50;
        }
        datasql = "SELECT f_lon,f_lat,ST_ClusterKMeans(t1.f_shape, " + clusterNum + ") over () AS cid from (" + datasql + ") t1";
        List list = this.jdbcTemplate.queryForList(datasql);
        HashMap dataMap = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            Map obj = (Map)list.get(i);
            Integer cid = (Integer)obj.get("cid");
            BigDecimal lon = (BigDecimal)obj.get("f_lon");
            BigDecimal lat = (BigDecimal)obj.get("f_lat");
            HeatMap heatMap = new HeatMap(lon, lat, Integer.valueOf(0));
            if (dataMap.containsKey(cid)) {
                ((List)dataMap.get(cid)).add(heatMap);
                continue;
            }
            ArrayList<HeatMap> tempList = new ArrayList<HeatMap>();
            tempList.add(heatMap);
            dataMap.put(cid, tempList);
        }
        ArrayList<HeatMap> result = new ArrayList<HeatMap>();
        for (Map.Entry entry : dataMap.entrySet()) {
            List obj = (List)entry.getValue();
            Integer size = obj.size();
            BigDecimal lon = new BigDecimal(0);
            BigDecimal lat = new BigDecimal(0);
            for (int j = 0; j < obj.size(); ++j) {
                lon = lon.add(((HeatMap)obj.get(j)).getLon());
                lat = lat.add(((HeatMap)obj.get(j)).getLat());
            }
            lon = lon.divide(new BigDecimal(size), 8, RoundingMode.DOWN);
            lat = lat.divide(new BigDecimal(size), 8, RoundingMode.DOWN);
            HeatMap heatMap = new HeatMap(lon, lat, size);
            result.add(heatMap);
        }
        return result;
    }

    @Override
    public Map<String, Long> getStatisticsByLevel(String name, Integer level, String isYswt) {
        List<TbtskObjectinfo> tableList = this.getTables(name);
        if (tableList.isEmpty()) {
            return null;
        }
        String queryFieldSql = " f_xzqdmsys ";
        String datasql = this.getTableSql(tableList, queryFieldSql, null);
        if (isYswt.equals("1")) {
            datasql = datasql + "  where f_yswt = '1' ";
        }
        String length = "7";
        if (level == 2) {
            length = "10";
        }
        datasql = "select substring(f_xzqdmsys, 0,  " + length + ") as code,count(*) as codecount from (" + datasql + ") t GROUP BY substring(f_xzqdmsys, 0, " + length + ")";
        List dataList = this.jdbcTemplate.queryForList(datasql);
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (int i = 0; i < dataList.size(); ++i) {
            String code = (String)((Map)dataList.get(i)).get("code");
            Long count = (Long)((Map)dataList.get(i)).get("codecount");
            result.put(code, count);
        }
        return result;
    }

    @Override
    public EasyUIResponse getStatisticsByPage(HttpServletRequest request, String name, Integer page, Integer pageSize, Boolean shp, String tbbh, String xzqmc, String bhlx, String jzqk, String wkt, String ztfx, String zdgkq, String sxws, String xzmc) {
        List<Map<String, Object>> tableList = this.getBizAndTables(name);
        if (tableList.isEmpty()) {
            EasyUIResponse response = new EasyUIResponse();
            response.setTotal(Long.valueOf(0L));
            response.setRows(new ArrayList());
            return response;
        }
        ShapeFile2Geo shapeFile2Geo = new ShapeFile2Geo(this.uploadDir);
        Map<String, Object> map = shapeFile2Geo.parsingShapeFile(request);
        if (map.get("shpfile") != null) {
            wkt = map.get("shpfile").toString();
        }
        List<String> tbbhs = this.parseExcel(request);
        String sql = this.getSql(tbbh, xzqmc, bhlx, jzqk, wkt, ztfx, zdgkq, sxws, tableList, tbbhs, true, xzmc);
        Long count = this.getCount(sql);
        Integer offset = pageSize * (page - 1);
        String datasql = "select * from (" + sql + ")t limit " + pageSize + " offset " + offset;
        List dataList = this.jdbcTemplate.queryForList(datasql);
        if (null != shp && shp.booleanValue() && !dataList.isEmpty()) {
            int i;
            String sql2 = "";
            String ids = "";
            for (i = 0; i < dataList.size(); ++i) {
                ids = ids + "'" + ((Map)dataList.get(i)).get("f_id").toString() + "'";
                if (i == dataList.size() - 1) continue;
                ids = ids + ",";
            }
            for (i = 0; i < tableList.size(); ++i) {
                String tablename = (String)tableList.get(i).get("f_tablename");
                String biz = (String)tableList.get(i).get("f_id");
                sql2 = sql2 + " SELECT f_tbbh,f_xzqmc1 as f_xzqmc,f_bhlx,f_committime,f_id,f_yswf,f_status,'" + biz + "' as bizid, st_astext(f_shape) as shape , '" + tablename + "' as tablename ,EXISTS (SELECT null from tb_app_media m WHERE t.f_id=m.f_galleryid and f_type=1) as photo,EXISTS (SELECT null from tb_app_media m WHERE t.f_id=m.f_galleryid and f_type=2) as video,EXISTS (SELECT null from tb_app_media m WHERE t.f_id=m.f_galleryid and f_type=3) as audio,EXISTS (SELECT null from tb_drone d WHERE t.f_id=d.f_jctbid and d.f_format='jpg') as dronev, EXISTS (SELECT null from tb_drone d WHERE t.f_id=d.f_jctbid and d.f_format='mp4') as dronep ";
                sql2 = sql2 + " FROM " + tablename + " t";
                sql2 = sql2 + " where f_id in (" + ids + ") ";
                if (i == tableList.size() - 1) continue;
                sql2 = sql2 + " UNION ALL ";
            }
            dataList = this.jdbcTemplate.queryForList(sql2);
        }
        EasyUIResponse response = new EasyUIResponse();
        response.setTotal(count);
        response.setRows(dataList);
        return response;
    }

    @Override
    public EasyUIResponse getYswtStatisticsByPage(HttpServletRequest request, String name, Integer page, Integer pageSize, Boolean shp, String tbbh, String xzqmc, String bhlx, String jzqk, String wkt, String ztfx, String zdgkq, String sxws, Integer wtfl, String xzmc) {
        List<Map<String, Object>> tableList = this.getBizAndTables(name);
        if (tableList.isEmpty()) {
            EasyUIResponse response = new EasyUIResponse();
            response.setTotal(Long.valueOf(0L));
            response.setRows(new ArrayList());
            return response;
        }
        ShapeFile2Geo shapeFile2Geo = new ShapeFile2Geo(this.uploadDir);
        Map<String, Object> map = shapeFile2Geo.parsingShapeFile(request);
        if (map.get("shpfile") != null) {
            wkt = map.get("shpfile").toString();
        }
        List<String> tbbhs = this.parseExcel(request);
        String sql = this.getYswtSql(tbbh, xzqmc, bhlx, jzqk, wkt, ztfx, zdgkq, sxws, tableList, tbbhs, wtfl, xzmc);
        Long count = this.getCount(sql);
        Integer offset = pageSize * (page - 1);
        String datasql = "select * from (" + sql + ")t limit " + pageSize + " offset " + offset;
        List dataList = this.jdbcTemplate.queryForList(datasql);
        if (null != shp && shp.booleanValue() && !dataList.isEmpty()) {
            int i;
            String sql2 = "";
            String ids = "";
            for (i = 0; i < dataList.size(); ++i) {
                ids = ids + "'" + ((Map)dataList.get(i)).get("f_id").toString() + "'";
                if (i == dataList.size() - 1) continue;
                ids = ids + ",";
            }
            for (i = 0; i < tableList.size(); ++i) {
                String tablename = (String)tableList.get(i).get("f_tablename");
                String biz = (String)tableList.get(i).get("f_id");
                sql2 = sql2 + " SELECT f_tbbh,f_xzqmc1 as f_xzqmc,f_bhlx,f_committime,f_id,f_yswf,f_status,f_jbntmj,f_sthxzymj,f_zrbhdmj,f_zygdmj,f_xzmc,'" + biz + "' as bizid, st_astext(f_shape) as shape , '" + tablename + "' as tablename ";
                sql2 = sql2 + " FROM " + tablename + " t";
                sql2 = sql2 + " where f_id in (" + ids + ") ";
                if (i == tableList.size() - 1) continue;
                sql2 = sql2 + " UNION ALL ";
            }
            dataList = this.jdbcTemplate.queryForList(sql2);
        }
        EasyUIResponse response = new EasyUIResponse();
        response.setTotal(count);
        response.setRows(dataList);
        return response;
    }

    private List<String> parseExcel(HttpServletRequest request) {
        ArrayList<String> tbbhs = new ArrayList<String>();
        try {
            CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
            if (multipartResolver.isMultipart(request)) {
                MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
                Iterator iter = multiRequest.getFileNames();
                while (iter.hasNext()) {
                    MultipartFile multipartFile = multiRequest.getFile((String)iter.next());
                    if (multipartFile == null || !multipartFile.getOriginalFilename().contains("xls")) continue;
                    File excelFile = null;
                    File dir = new File(this.uploadDir);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    excelFile = File.createTempFile("tmp", ".xlsm", dir);
                    FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)excelFile);
                    Workbook workbook = null;
                    FileOutputStream out = null;
                    Object is = null;
                    File file = new File(excelFile.getAbsolutePath());
                    FileInputStream inputStream = new FileInputStream(file);
                    File parentFile = file.getParentFile();
                    if (parentFile != null && !parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    workbook = WorkbookFactory.create((InputStream)inputStream);
                    ((InputStream)inputStream).close();
                    Sheet sheet = workbook.getSheetAt(0);
                    Row row = sheet.getRow(0);
                    int rowCount = sheet.getPhysicalNumberOfRows();
                    for (int i = 1; i < rowCount; ++i) {
                        row = sheet.getRow(i);
                        if (row == null) continue;
                        try {
                            Cell cell = row.getCell(0);
                            String cellValue = cell.getStringCellValue();
                            if (!StringUtils.isNotBlank((CharSequence)cellValue)) continue;
                            tbbhs.add(cellValue);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    out = new FileOutputStream(file);
                    workbook.write((OutputStream)out);
                    out.flush();
                    ((OutputStream)out).close();
                    try {
                        if (!excelFile.exists()) continue;
                        excelFile.delete();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tbbhs;
    }

    @Override
    public List<Map<String, Object>> getDataByWkt(String name, String wkt) {
        List<Map<String, Object>> tableList = this.getBizAndTables(name);
        if (tableList.isEmpty()) {
            return null;
        }
        String sql = "";
        for (int i = 0; i < tableList.size(); ++i) {
            String tablename = (String)tableList.get(i).get("f_tablename");
            String biz = (String)tableList.get(i).get("f_id");
            String bizname = (String)tableList.get(i).get("f_name");
            sql = sql + " SELECT f_id as id,st_astext(f_shape) as shape, f_tbbh, f_tbmj, f_status,'" + biz + "' as bizid, '" + bizname + "' as name ,'" + tablename + "' as tablename ";
            sql = sql + " FROM " + tablename;
            if (!StringUtils.isEmpty((CharSequence)wkt)) {
                sql = sql + " where st_contains(ST_GeomFromText('" + wkt + "'),f_shape)";
            }
            if (i == tableList.size() - 1) continue;
            sql = sql + " UNION ALL ";
        }
        return this.jdbcTemplate.queryForList(sql);
    }

    @Override
    public String getLastSeasion() {
        String lastSeasion = this.tbTaskBizRepository.getLastSeasion();
        return lastSeasion != null ? lastSeasion : "";
    }

    @Override
    public void downloadAll(HttpServletRequest request, String name, String tbbh, String xzqmc, String bhlx, String jzqk, String wkt, String ztfx, String zdgkq, String sxws, Long userId) throws Exception {
        List<Map<String, Object>> tableList = this.getBizAndTables(name);
        if (tableList.isEmpty()) {
            return;
        }
        List<String> tbbhs = this.parseExcel(request);
        String bizid = (String)tableList.get(0).get("f_id");
        String sql = this.getSql(tbbh, xzqmc, bhlx, jzqk, wkt, ztfx, zdgkq, sxws, tableList, tbbhs, false, null);
        List dataList = this.jdbcTemplate.queryForList(sql);
        if (dataList.size() >= 1000) {
            throw new Exception("\u4e0d\u652f\u6301\u5927\u4e8e1000\u4e2a\u56fe\u6591\u7684\u6210\u679c\u4e0b\u8f7d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String tbIds = "";
        for (int i = 0; i < dataList.size(); ++i) {
            Map obj = (Map)dataList.get(i);
            String tbid = (String)obj.get("f_id");
            tbIds = tbIds + tbid;
            if (i == dataList.size() - 1) continue;
            tbIds = tbIds + ",";
        }
        this.dataDownloadDailyTaskService.downloadGeometry(bizid, tbIds, userId, "attach", true, Integer.valueOf(2));
    }

    private String getSql(String tbbh, String xzqmc, String bhlx, String jzqk, String wkt, String ztfx, String zdgkq, String sxws, List<Map<String, Object>> tableList, List<String> tbbhs, boolean media, String xzmc) {
        String sql = "";
        for (int i = 0; i < tableList.size(); ++i) {
            String tablename = (String)tableList.get(i).get("f_tablename");
            String biz = (String)tableList.get(i).get("f_id");
            sql = sql + " SELECT f_tbbh,f_xzqmc1 as f_xzqmc,f_xzqdm,f_bhlx,f_yswf,f_status,f_committime,f_id,'" + biz + "' as bizid ,'" + tablename + "' as tablename ";
            if (!StringUtils.isEmpty((CharSequence)wkt)) {
                sql = sql + ",st_geomfromtext('POINT(' || f_lon || ' ' || f_lat || ')') as center";
            }
            if (!StringUtils.isEmpty((CharSequence)ztfx)) {
                sql = sql + ",f_ztfx";
            }
            if (!StringUtils.isEmpty((CharSequence)sxws)) {
                sql = sql + ",f_sxws";
            }
            if (!StringUtils.isEmpty((CharSequence)zdgkq)) {
                sql = sql + ",f_yjjbntzy,f_sthxzymj,f_zrbhdzym,f_zrbhd_n1 ";
            }
            if (media) {
                sql = sql + ",EXISTS (SELECT null from tb_app_media m WHERE t.f_id=m.f_galleryid and f_type=1) as photo,EXISTS (SELECT null from tb_app_media m WHERE t.f_id=m.f_galleryid and f_type=2) as video,EXISTS (SELECT null from tb_app_media m WHERE t.f_id=m.f_galleryid and f_type=3) as audio,EXISTS (SELECT null from tb_drone d WHERE t.f_id=d.f_jctbid and d.f_format='jpg') as dronev, EXISTS (SELECT null from tb_drone d WHERE t.f_id=d.f_jctbid and d.f_format='mp4') as dronep ";
            }
            sql = sql + " FROM " + tablename + " t";
            if (i == tableList.size() - 1) continue;
            sql = sql + " UNION ALL ";
        }
        if (!(StringUtils.isEmpty((CharSequence)tbbh) && StringUtils.isEmpty((CharSequence)xzqmc) && StringUtils.isEmpty((CharSequence)bhlx) && StringUtils.isEmpty((CharSequence)ztfx) && StringUtils.isEmpty((CharSequence)jzqk) && StringUtils.isEmpty((CharSequence)zdgkq) && StringUtils.isEmpty((CharSequence)sxws) && StringUtils.isEmpty((CharSequence)wkt) && tbbhs.isEmpty())) {
            sql = " select * from (" + sql + ") t2 ";
            boolean isfirst = true;
            if (!StringUtils.isEmpty((CharSequence)tbbh)) {
                sql = sql + " where t2.f_tbbh like '%" + tbbh + "%' ";
                isfirst = false;
            }
            if (!StringUtils.isEmpty((CharSequence)xzqmc)) {
                if (!isfirst) {
                    sql = sql + " and ";
                } else {
                    sql = sql + " where ";
                    isfirst = false;
                }
                sql = sql + "t2.f_xzqdm in ('" + xzqmc.replace(",", "','") + "')";
            }
            if (!StringUtils.isEmpty((CharSequence)bhlx)) {
                if (!isfirst) {
                    sql = sql + " and ";
                } else {
                    sql = sql + " where ";
                    isfirst = false;
                }
                sql = sql + " t2.f_bhlx = '" + bhlx + "' ";
            }
            if (!StringUtils.isEmpty((CharSequence)wkt)) {
                if (!isfirst) {
                    sql = sql + " and ";
                } else {
                    sql = sql + " where ";
                    isfirst = false;
                }
                sql = sql + " ST_Contains( ST_GeometryFromText('" + wkt + "'), t2.center)";
            }
            if (!StringUtils.isEmpty((CharSequence)ztfx)) {
                if (!isfirst) {
                    sql = sql + " and ";
                } else {
                    sql = sql + " where ";
                    isfirst = false;
                }
                sql = sql + " t2.f_ztfx = '" + ztfx + "' ";
            }
            if (!StringUtils.isEmpty((CharSequence)zdgkq)) {
                ArrayList<String> tempSql = new ArrayList<String>();
                JSONObject params = JSONObject.parseObject((String)zdgkq);
                String filterCompare = params.getString("filterCompare");
                JSONArray paramsList = params.getJSONArray("list");
                for (Object o : paramsList) {
                    if ("1".equals(o.toString())) {
                        tempSql.add(" (t2.f_yjjbntzy > 0) ");
                        continue;
                    }
                    if ("2".equals(o.toString())) {
                        tempSql.add(" (t2.f_sthxzymj > 0) ");
                        continue;
                    }
                    if ("3".equals(o.toString())) {
                        tempSql.add(" (t2.f_zrbhdzym > 0) ");
                        continue;
                    }
                    if (!"4".equals(o.toString())) continue;
                    tempSql.add(" (t2.f_zrbhd_n1 is not null) ");
                }
                if (!tempSql.isEmpty()) {
                    if (!isfirst) {
                        sql = sql + " and ";
                    } else {
                        sql = sql + " where ";
                        isfirst = false;
                    }
                    sql = sql + "(" + StringUtils.join(tempSql, (String)filterCompare) + ")";
                }
            }
            if (!StringUtils.isEmpty((CharSequence)sxws)) {
                sql = !isfirst ? sql + " and " : sql + " where ";
                sql = sql + " t2.f_sxws = '" + sxws + "' ";
            }
            if (!tbbhs.isEmpty()) {
                sql = !isfirst ? sql + " and " : sql + " where ";
                sql = sql + " t2.f_tbbh in ('" + StringUtils.join(tbbhs, (String)"','") + "') ";
            }
            if (StringUtils.isNotEmpty((CharSequence)jzqk)) {
                sql = !isfirst ? sql + " and " : sql + " where ";
                String[] jzqks = jzqk.split(",");
                ArrayList<String> tempSql = new ArrayList<String>();
                if (jzqk.contains("0")) {
                    tempSql.add(" t2.f_status<4");
                }
                if (jzqk.contains("1")) {
                    tempSql.add(" t2.f_status=4 and t2.f_bhlx is null");
                }
                if (jzqk.contains("2")) {
                    tempSql.add(" t2.f_status=4 and t2.f_bhlx is not null and  (not exists (select null from tb_app_media m where t2.f_id=m.f_galleryid) and not exists (select null from tb_drone d where t2.f_id=d.f_jctbid))");
                }
                if (jzqk.contains("3")) {
                    tempSql.add(" t2.f_status=4 and t2.f_bhlx is not null and  (exists (select null from tb_app_media m where t2.f_id=m.f_galleryid) or exists (select null from tb_drone d where t2.f_id=d.f_jctbid))");
                }
                sql = sql + " (" + StringUtils.join(tempSql, (String)" or ") + " ) ";
            }
        }
        return sql;
    }

    private String getYswtSql(String tbbh, String xzqmc, String bhlx, String jzqk, String wkt, String ztfx, String zdgkq, String sxws, List<Map<String, Object>> tableList, List<String> tbbhs, Integer wtfl, String xzmc) {
        String sql = "";
        for (int i = 0; i < tableList.size(); ++i) {
            String tablename = (String)tableList.get(i).get("f_tablename");
            String biz = (String)tableList.get(i).get("f_id");
            sql = sql + " SELECT f_tbbh,f_xzqmc1 as f_xzqmc,f_xzqdm,f_bhlx,f_jbntmj,f_sthxzymj,f_zrbhdmj,f_zygdmj,f_xzmc,f_id,f_yswt,'" + biz + "' as bizid ,'" + tablename + "' as tablename";
            if (!StringUtils.isEmpty((CharSequence)wkt)) {
                sql = sql + ",st_geomfromtext('POINT(' || f_lon || ' ' || f_lat || ')') as center";
            }
            if (!StringUtils.isEmpty((CharSequence)ztfx)) {
                sql = sql + ",f_ztfx";
            }
            if (!StringUtils.isEmpty((CharSequence)sxws)) {
                sql = sql + ",f_sxws";
            }
            if (!StringUtils.isEmpty((CharSequence)zdgkq)) {
                sql = sql + "";
            }
            sql = sql + " FROM " + tablename + " t";
            if (i == tableList.size() - 1) continue;
            sql = sql + " UNION ALL ";
        }
        sql = " select * from (" + sql + ") t2 where t2.f_yswt='1' ";
        if (!(StringUtils.isEmpty((CharSequence)tbbh) && StringUtils.isEmpty((CharSequence)xzqmc) && StringUtils.isEmpty((CharSequence)bhlx) && StringUtils.isEmpty((CharSequence)ztfx) && StringUtils.isEmpty((CharSequence)jzqk) && StringUtils.isEmpty((CharSequence)zdgkq) && StringUtils.isEmpty((CharSequence)sxws) && StringUtils.isEmpty((CharSequence)wkt) && tbbhs.isEmpty() && wtfl == null && StringUtils.isEmpty((CharSequence)xzmc))) {
            if (!StringUtils.isEmpty((CharSequence)tbbh)) {
                sql = sql + " AND t2.f_tbbh like '%" + tbbh + "%' ";
            }
            if (!StringUtils.isEmpty((CharSequence)xzqmc)) {
                sql = sql + " AND (t2.f_xzqdm = '" + xzqmc + "' or t2.f_xzmc like '%" + xzqmc + "%' )";
            }
            if (!StringUtils.isEmpty((CharSequence)xzmc)) {
                sql = sql + " AND t2.f_xzmc like '%" + xzmc + "%'";
            }
            if (!StringUtils.isEmpty((CharSequence)bhlx)) {
                sql = sql + " AND t2.f_bhlx = '" + bhlx + "' ";
            }
            if (!StringUtils.isEmpty((CharSequence)wkt)) {
                sql = sql + " AND ST_Contains( ST_GeometryFromText('" + wkt + "'), t2.center)";
            }
            if (!StringUtils.isEmpty((CharSequence)ztfx)) {
                sql = sql + " AND t2.f_ztfx = '" + ztfx + "' ";
            }
            if (!StringUtils.isEmpty((CharSequence)zdgkq)) {
                ArrayList<String> tempSql = new ArrayList<String>();
                JSONObject params = JSONObject.parseObject((String)zdgkq);
                String filterCompare = params.getString("filterCompare");
                JSONArray paramsList = params.getJSONArray("list");
                for (Object o : paramsList) {
                    if ("1".equals(o.toString())) {
                        tempSql.add(" (t2.f_yjjbntzy > 0) ");
                        continue;
                    }
                    if ("2".equals(o.toString())) {
                        tempSql.add(" (t2.f_sthxzymj > 0) ");
                        continue;
                    }
                    if ("3".equals(o.toString())) {
                        tempSql.add(" (t2.f_zrbhdzym > 0) ");
                        continue;
                    }
                    if (!"4".equals(o.toString())) continue;
                    tempSql.add(" (t2.f_zrbhd_n1 is not null) ");
                }
                if (!tempSql.isEmpty()) {
                    sql = sql + "AND (" + StringUtils.join(tempSql, (String)filterCompare) + ")";
                }
            }
            if (!StringUtils.isEmpty((CharSequence)sxws)) {
                sql = sql + " AND t2.f_sxws = '" + sxws + "' ";
            }
            if (wtfl != null && (wtfl & 1) == 1) {
                sql = sql + " AND t2.f_zygdmj > 0 ";
            }
            if (wtfl != null && (wtfl & 2) == 2) {
                sql = sql + " AND t2.f_jbntmj > 0 ";
            }
            if (wtfl != null && (wtfl & 4) == 4) {
                sql = sql + " AND t2.f_sthxzymj > 0 ";
            }
            if (wtfl != null && (wtfl & 8) == 8) {
                sql = sql + " AND t2.f_zrbhdmj > 0 ";
            }
            if (!tbbhs.isEmpty()) {
                sql = sql + " AND t2.f_tbbh in ('" + StringUtils.join(tbbhs, (String)"','") + "') ";
            }
            if (StringUtils.isNotEmpty((CharSequence)jzqk)) {
                String[] jzqks = jzqk.split(",");
                ArrayList<String> tempSql = new ArrayList<String>();
                if (jzqk.contains("0")) {
                    tempSql.add(" t2.f_status<4");
                }
                if (jzqk.contains("1")) {
                    tempSql.add(" t2.f_status=4 and t2.f_bhlx is null");
                }
                if (jzqk.contains("2")) {
                    tempSql.add(" t2.f_status=4 and t2.f_bhlx is not null and  (not exists (select null from tb_app_media m where t2.f_id=m.f_galleryid) and not exists (select null from tb_drone d where t2.f_id=d.f_jctbid))");
                }
                if (jzqk.contains("3")) {
                    tempSql.add(" t2.f_status=4 and t2.f_bhlx is not null and  (exists (select null from tb_app_media m where t2.f_id=m.f_galleryid) or exists (select null from tb_drone d where t2.f_id=d.f_jctbid))");
                }
                sql = sql + " AND (" + StringUtils.join(tempSql, (String)" or ") + " ) ";
            }
        }
        return sql;
    }

    @Override
    public Gztj getStatistics(String seasons, String xzqdms) {
        int i;
        List<TbtskObjectinfo> tableList = this.getTablesBySeasons(seasons);
        if (tableList.isEmpty()) {
            return null;
        }
        String queryFieldSql = " f_status,f_cgsh,f_yswf,f_xzqdm ";
        String sql = this.getTableSql(tableList, queryFieldSql, xzqdms);
        String submitSql = "select count(*) as f_sum, f_status, f_xzqdm from (" + sql + ") t group by f_status, f_xzqdm";
        List submitList = this.jdbcTemplate.queryForList(submitSql);
        String queryFieldSql2 = " f_id ";
        String sql2 = this.getTableSql(tableList, queryFieldSql2, xzqdms);
        String mediaSql = "select count(*) as f_sum, f_type from tb_app_media where f_galleryid in (" + sql2 + ") group by f_type";
        List mediaList = this.jdbcTemplate.queryForList(mediaSql);
        String wrjSql = "select count(*) as f_sum from tb_drone where f_jctbid in (" + sql2 + ")";
        Map wrjMap = this.jdbcTemplate.queryForMap(wrjSql);
        String cgshSql = "select count(*) as f_sum, f_cgsh from (" + sql + ")t group by f_cgsh";
        List cgshList = this.jdbcTemplate.queryForList(cgshSql);
        String yswfSql = "select count(*) as f_sum, f_status, f_xzqdm from (" + this.getTableSql(tableList, queryFieldSql, null) + ")t where f_yswf = '1' or f_yswf = '\u662f' group by f_status, f_xzqdm";
        List yswfList = this.jdbcTemplate.queryForList(yswfSql);
        String wysql = "";
        for (int i2 = 0; i2 < tableList.size(); ++i2) {
            String signField = this.getSignField(tableList.get(i2).getfTablename());
            String tablename = tableList.get(i2).getfTablename();
            wysql = wysql + " select count(*) as f_sum,f_xzqdm from " + tablename + " where " + signField + " is not null and " + signField + " != '' ";
            if (!StringUtils.isEmpty((CharSequence)xzqdms)) {
                wysql = wysql + " and f_xzqdm in (" + this.getINsql(xzqdms) + ")";
            }
            wysql = wysql + " GROUP BY f_xzqdm";
            if (i2 == tableList.size() - 1) continue;
            wysql = wysql + " UNION ALL ";
        }
        List wyList = this.jdbcTemplate.queryForList(wysql);
        Long sum = 0L;
        Long submitNum = 0L;
        Long unSubmitNum = 0L;
        Long unSend = 0L;
        HashMap<String, Wyjd> wyjdMap = new HashMap<String, Wyjd>();
        for (int i3 = 0; i3 < submitList.size(); ++i3) {
            Map obj = (Map)submitList.get(i3);
            Integer status = (Integer)obj.get("f_status");
            Long f_sum = (Long)obj.get("f_sum");
            String code = (String)obj.get("f_xzqdm");
            sum = sum + f_sum;
            if (4 == status) {
                submitNum = submitNum + f_sum;
            } else if (2 == status) {
                unSubmitNum = unSubmitNum + f_sum;
            } else {
                unSend = unSend + f_sum;
            }
            if (!StringUtils.isEmpty((CharSequence)xzqdms)) continue;
            this.createWyjd(wyjdMap, status, f_sum, code);
        }
        if (!StringUtils.isEmpty((CharSequence)xzqdms)) {
            String wyjdSql = "select count(*) as f_sum, f_status, f_xzqdm from (" + this.getTableSql(tableList, queryFieldSql, null) + ") t group by f_status, f_xzqdm";
            List wyjdList = this.jdbcTemplate.queryForList(wyjdSql);
            for (int i4 = 0; i4 < wyjdList.size(); ++i4) {
                Map obj = (Map)wyjdList.get(i4);
                Integer status = (Integer)obj.get("f_status");
                Long f_sum = (Long)obj.get("f_sum");
                String code = (String)obj.get("f_xzqdm");
                this.createWyjd(wyjdMap, status, f_sum, code);
            }
        }
        Long zp = 0L;
        Long sp = 0L;
        Long yp = 0L;
        Long wrj = (Long)wrjMap.get("f_sum");
        for (int i5 = 0; i5 < mediaList.size(); ++i5) {
            Map obj = (Map)mediaList.get(i5);
            Long f_sum = (Long)obj.get("f_sum");
            Integer type = (Integer)obj.get("f_type");
            if (1 == type) {
                zp = zp + f_sum;
                continue;
            }
            if (2 == type) {
                sp = sp + f_sum;
                continue;
            }
            if (3 != type) continue;
            yp = yp + f_sum;
        }
        ArrayList<CommonNum> cgshResultList = new ArrayList<CommonNum>();
        Long cgshSum = 0L;
        for (i = 0; i < cgshList.size(); ++i) {
            Map obj = (Map)cgshList.get(i);
            Long f_sum = (Long)obj.get("f_sum");
            if (null == obj.get("f_cgsh")) continue;
            String type = obj.get("f_cgsh").toString();
            cgshSum = cgshSum + f_sum;
            CommonNum cgsh = new CommonNum();
            cgsh.setName(this.getCgshByType(type));
            cgsh.setNum(f_sum);
            cgshResultList.add(cgsh);
        }
        for (i = 0; i < cgshResultList.size(); ++i) {
            Long num = ((CommonNum)cgshResultList.get(i)).getNum();
            BigDecimal percent = BigDecimal.valueOf(num * 100L).divide(BigDecimal.valueOf(cgshSum), 2, RoundingMode.DOWN);
            ((CommonNum)cgshResultList.get(i)).setPercent(percent);
        }
        ArrayList<Wyjd> wyjdList = new ArrayList<Wyjd>();
        this.processWyjd(yswfList, wyjdMap);
        Long wySum = 0L;
        for (int i6 = 0; i6 < wyList.size(); ++i6) {
            Map obj = (Map)wyList.get(i6);
            Long f_sum = (Long)obj.get("f_sum");
            String code = (String)obj.get("f_xzqdm");
            Wyjd wyjd = new Wyjd();
            if (wyjdMap.containsKey(code)) {
                wyjd = (Wyjd)wyjdMap.get(code);
            }
            wyjd.setNum5(f_sum);
            wyjdMap.put(code, wyjd);
            wySum = wySum + f_sum;
        }
        this.getPercent(wyjdMap, wyjdList);
        Long cyry = 0L;
        List<CommonNum> cyryList = this.getCyry2(seasons);
        for (int i7 = 0; i7 < cyryList.size(); ++i7) {
            cyry = cyry + cyryList.get(i7).getNum();
        }
        Gztj gztj = new Gztj();
        gztj.setJctb(sum);
        gztj.setCyry(cyry);
        gztj.setWysl(wySum);
        gztj.setYtj(submitNum);
        gztj.setWtj(unSubmitNum);
        gztj.setWxf(unSend);
        gztj.setZp(zp);
        gztj.setSp(sp);
        gztj.setYp(yp);
        gztj.setWrj(wrj);
        gztj.setCgsh(cgshResultList);
        gztj.setWyjd(wyjdList);
        gztj.setQxcyry(cyryList);
        return gztj;
    }

    private void createWyjd(Map<String, Wyjd> wyjdMap, Integer status, Long f_sum, String code) {
        Wyjd wyjd = new Wyjd();
        if (wyjdMap.containsKey(code)) {
            wyjd = wyjdMap.get(code);
        }
        wyjd.setNum1(Long.valueOf(wyjd.getNum1() + f_sum));
        if (4 == status) {
            wyjd.setNum2(Long.valueOf(wyjd.getNum2() + f_sum));
        }
        wyjdMap.put(code, wyjd);
    }

    private void processWyjd(List<Map<String, Object>> yswfList, Map<String, Wyjd> wyjdMap) {
        for (int i = 0; i < yswfList.size(); ++i) {
            Map<String, Object> obj = yswfList.get(i);
            Integer status = (Integer)obj.get("f_status");
            Long f_sum = (Long)obj.get("f_sum");
            String code = (String)obj.get("f_xzqdm");
            Wyjd wyjd = new Wyjd();
            if (wyjdMap.containsKey(code)) {
                wyjd = wyjdMap.get(code);
            }
            if (4 == status) {
                wyjd.setNum4(f_sum);
            } else {
                wyjd.setNum3(Long.valueOf(wyjd.getNum3() + f_sum));
            }
            wyjdMap.put(code, wyjd);
        }
    }

    private void getPercent(Map<String, Wyjd> wyjdMap, List<Wyjd> wyjdList) {
        for (Map.Entry<String, Wyjd> entry : wyjdMap.entrySet()) {
            String code = entry.getKey();
            Wyjd wyjd = entry.getValue();
            wyjd.setXzqdm(code);
            wyjd.setNum3(Long.valueOf(wyjd.getNum3() + wyjd.getNum4()));
            BigDecimal num6 = wyjd.getNum3() == 0L ? new BigDecimal(100) : new BigDecimal(wyjd.getNum4() * 100L).divide(new BigDecimal(wyjd.getNum3()), 2, RoundingMode.DOWN);
            BigDecimal num7 = new BigDecimal(wyjd.getNum2() * 100L).divide(new BigDecimal(wyjd.getNum1()), 2, RoundingMode.DOWN);
            wyjd.setNum6(num6);
            wyjd.setNum7(num7);
            wyjdList.add(wyjd);
        }
    }

    @Override
    public List<Map<String, Object>> getWyjd(String name) {
        String code;
        Long f_sum;
        List<TbtskObjectinfo> tableList = this.getTables(name);
        if (tableList.isEmpty()) {
            return null;
        }
        String queryFieldSql = " f_status,f_cgsh,f_yswf,f_xzqmc1 as f_xzqdm ";
        String sql = this.getTableSql(tableList, queryFieldSql, null);
        String submitSql = "select count(*) as f_sum, f_status, f_xzqdm from (" + sql + ") t group by f_status, f_xzqdm";
        List submitList = this.jdbcTemplate.queryForList(submitSql);
        String yswfSql = "select count(*) as f_sum, f_status, f_xzqdm from (" + sql + ")t where f_yswf = '1' or f_yswf = '\u662f' group by f_status, f_xzqdm";
        List yswfList = this.jdbcTemplate.queryForList(yswfSql);
        String wysql = "";
        String signField = this.getSignField(tableList.get(0).getfTablename());
        for (int i = 0; i < tableList.size(); ++i) {
            String tablename = tableList.get(i).getfTablename();
            wysql = wysql + " select count(*) as f_sum, f_xzqmc1 as f_xzqdm from " + tablename + " where " + signField + " is not null and " + signField + " != '' GROUP BY f_xzqmc1";
            if (i == tableList.size() - 1) continue;
            wysql = wysql + " UNION ALL ";
        }
        List wyList = this.jdbcTemplate.queryForList(wysql);
        HashMap<String, Wyjd> wyjdMap = new HashMap<String, Wyjd>();
        for (int i = 0; i < submitList.size(); ++i) {
            Map obj = (Map)submitList.get(i);
            Integer status = (Integer)obj.get("f_status");
            f_sum = (Long)obj.get("f_sum");
            code = (String)obj.get("f_xzqdm");
            this.createWyjd(wyjdMap, status, f_sum, code);
        }
        ArrayList<Wyjd> wyjdList = new ArrayList<Wyjd>();
        this.processWyjd(yswfList, wyjdMap);
        for (int i = 0; i < wyList.size(); ++i) {
            Map obj = (Map)wyList.get(i);
            f_sum = (Long)obj.get("f_sum");
            code = (String)obj.get("f_xzqdm");
            Wyjd wyjd = new Wyjd();
            if (wyjdMap.containsKey(code)) {
                wyjd = (Wyjd)wyjdMap.get(code);
            }
            wyjd.setNum5(f_sum);
            wyjdMap.put(code, wyjd);
        }
        this.getPercent(wyjdMap, wyjdList);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < wyjdList.size(); ++i) {
            Wyjd temp = (Wyjd)wyjdList.get(i);
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("xzqmc", temp.getXzqdm());
            obj.put("total", temp.getNum1());
            obj.put("assigncount", temp.getNum2());
            obj.put("yswfcount", temp.getNum3());
            obj.put("dwshccount", temp.getNum4());
            obj.put("wyhccount", temp.getNum5());
            obj.put("dwshcpercent", temp.getNum6());
            obj.put("zpercent", temp.getNum7());
            result.add(obj);
        }
        return result;
    }

    private String getTableSql(List<TbtskObjectinfo> list, String queryFieldSql, String xzqdms) {
        String datasql = "";
        for (int i = 0; i < list.size(); ++i) {
            String tablename = list.get(i).getfTablename();
            datasql = datasql + " SELECT " + queryFieldSql + " FROM " + tablename;
            if (!StringUtils.isEmpty((CharSequence)xzqdms)) {
                datasql = datasql + " where f_xzqdm in (" + this.getINsql(xzqdms) + ")";
            }
            if (i == list.size() - 1) continue;
            datasql = datasql + " UNION ALL ";
        }
        return datasql;
    }

    private List<TbtskObjectinfo> getTables(String name) {
        name = name + "%";
        return this.objectinfoRepository.getObjectbyName(name);
    }

    private List<TbtskObjectinfo> getTablesBySeasons(String seasons) {
        return this.objectinfoRepository.getListbyDesc(Arrays.asList(seasons.split(",")), "CGJC_JDJC");
    }

    private List<Map<String, Object>> getBizAndTables(String name) {
        name = name + "%";
        String sql = "select t1.f_tablename,t2.f_id,t2.f_name from tbtsk_objectinfo t1, tbtsk_task_biz t2 where t1.f_id = t2.f_tableid and t2.f_name like '" + name + "' and t2.f_isdel is null";
        return this.jdbcTemplate.queryForList(sql);
    }

    private Long getCount(String sql) {
        String countSql = "select count(*) as num from (" + sql + ")t";
        Map countMap = this.jdbcTemplate.queryForMap(countSql);
        Long count = (Long)countMap.get("num");
        return count;
    }

    private List<CommonNum> getCyry(String name) {
        name = name + "%";
        List list = this.tbTaskBizRepository.findLikeName(name);
        String sql = "";
        for (int i = 0; i < list.size(); ++i) {
            String[] names = ((TskTaskBiz)list.get(i)).getName().split("-");
            if (names.length < 2) continue;
            String regionName = names[1];
            String bizid = ((TskTaskBiz)list.get(i)).getId();
            sql = sql + " select * from (select count(distinct f_userid)::BIGINT as f_sum from tbsys_user_biz2 where f_bizid = '" + bizid + "')t1, (select '" + regionName + "'::text as f_name)t2 ";
            if (i == list.size() - 1) continue;
            sql = sql + " UNION ALL ";
        }
        List dataList = this.jdbcTemplate.queryForList(sql);
        ArrayList<CommonNum> resultList = new ArrayList<CommonNum>();
        for (int i = 0; i < dataList.size(); ++i) {
            Map obj = (Map)dataList.get(i);
            Long num = (Long)obj.get("f_sum");
            String regionName = (String)obj.get("f_name");
            CommonNum commom = new CommonNum();
            commom.setName(regionName);
            commom.setNum(num);
            resultList.add(commom);
        }
        return resultList;
    }

    private List<CommonNum> getCyry2(String seasons) {
        String sql = "select t3.f_sum,t4.f_regioncode from (select count(*) as f_sum, f_organizationid from (select DISTINCT f_userid from tbsys_user_biz2 where f_bizid in (select f_id from tbtsk_task_biz where f_desc in (" + this.getINsql(seasons) + ") and f_busicode = '" + "CGJC_JDJC" + "'))t1, uis_userorganization t2 where t1.f_userid = t2.f_userid GROUP BY t2.f_organizationid)t3, uis_organization t4 where t4.f_id = t3.f_organizationid;";
        List dataList = this.jdbcTemplate.queryForList(sql);
        ArrayList<CommonNum> resultList = new ArrayList<CommonNum>();
        for (int i = 0; i < dataList.size(); ++i) {
            Map obj = (Map)dataList.get(i);
            Long num = (Long)obj.get("f_sum");
            String regionName = (String)obj.get("f_regioncode");
            if ("500000".equals(regionName)) continue;
            CommonNum commom = new CommonNum();
            commom.setName(regionName);
            commom.setNum(num);
            resultList.add(commom);
        }
        return resultList;
    }

    private String getSignField(String tablename) {
        String sql = "select f_fieldname from tbtsk_fields where f_tablename = '" + tablename + "' and f_fieldtype = '10';";
        List list = this.jdbcTemplate.queryForList(sql);
        return (String)((Map)list.get(0)).get("f_fieldname");
    }

    private String getCgshByType(String key) {
        switch (key) {
            case "1": {
                return "\u6838\u67e5\u4fe1\u606f\u5b8c\u5584";
            }
            case "2": {
                return "\u6838\u67e5\u4fe1\u606f\u4e0d\u5b8c\u5584";
            }
            case "3": {
                return "\u65e0\u6838\u67e5\u4fe1\u606f";
            }
            case "4": {
                return "\u6838\u5fc3\u533a\u975e\u519c\u6751\u9053\u8def\u56fe\u6591\u672a\u4e3e\u8bc1";
            }
        }
        return key;
    }

    private String getINsql(String data) {
        String[] array = data.split(",");
        String result = "";
        for (int i = 0; i < array.length; ++i) {
            result = result + "'" + array[i] + "'";
            if (i == array.length - 1) continue;
            result = result + ",";
        }
        return result;
    }
}

