/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.statistics.impl;

import com.geoway.landteam.customtask.util.ExcelUtil;
import com.geoway.landteam.landcloud.model.statistics.dto.DlgqStatistics;
import com.geoway.landteam.landcloud.service.statistics.DlgqService;
import com.geoway.landteam.landcloud.service.thirddata.utils.FileUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class DlgqServiceImpl
implements DlgqService {
    private final Integer TYPE1 = 1;
    private final Integer TYPE2 = 2;
    private final Integer TYPE3 = 3;
    private final Integer TYPE4 = 4;
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    private GiLoger logger = GwLoger.getLoger(DlgqServiceImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public byte[] exportStatistics(String fileName) throws Exception {
        List<Map<String, Object>> tableList = this.getTable();
        String unionSql = this.unionSql(tableList);
        HashMap<String, DlgqStatistics> resultData = new HashMap<String, DlgqStatistics>();
        this.addZydw(resultData, tableList);
        this.sumTb(resultData, unionSql, this.TYPE1);
        this.sumTb(resultData, unionSql, this.TYPE2);
        this.sumMedia(resultData, unionSql);
        this.sumCyry(resultData, unionSql);
        List<Map<String, Object>> excelData = this.process(resultData);
        String col = "xzqmc,tb,tj,zp,cyry,zydw,percent";
        String colName = "\u533a\u53bf\u540d\u79f0,\u56fe\u6591\u4e2a\u6570,\u5df2\u63d0\u4ea4\uff08\u4f5c\u4e1a\uff09\u56fe\u6591\u6570,\u7167\u7247\u6570,\u53c2\u4e0e\u4eba\u5458\u6570\u91cf,\u4f5c\u4e1a\u5355\u4f4d,\u603b\u8fdb\u5ea6\uff08\u5df2\u63d0\u4ea4\u56fe\u6591\u6570/\u56fe\u6591\u4e2a\u6570\uff09\uff08%\uff09";
        String sheetName = "\u7edf\u8ba1\u8868";
        String filePath = ExcelUtil.CreateExcel(excelData, (String)this.uploadDir, (String)fileName, (String)col, (String)colName, (String)sheetName);
        byte[] fileByte = new byte[1024];
        fileByte = FileUtil.readFileByte(filePath);
        return fileByte;
    }

    private List<Map<String, Object>> getTable() {
        String sql = "select t1.f_userid,t2.f_tablename from (select f_tableid,f_userid from tbtsk_task_biz where f_busicode = 'DLGQJC' and f_isdel is null and f_total > 0   AND f_userid not in (SELECT u.f_userid||'' FROM tbsys_user u LEFT JOIN uis_userorganization uo on u.f_userid=uo.f_userid\nLEFT JOIN uis_organization o on o.f_id=uo.f_organizationid\nWHERE o.f_name ='\u91cd\u5e86\u5e02\u89c4\u5212\u548c\u81ea\u7136\u8d44\u6e90\u8c03\u67e5\u76d1\u6d4b\u9662'))t1, tbtsk_objectinfo t2 where t1.f_tableid = t2.f_id;";
        return this.jdbcTemplate.queryForList(sql);
    }

    private void addZydw(Map<String, DlgqStatistics> resultData, List<Map<String, Object>> tableList) {
        for (int i = 0; i < tableList.size(); ++i) {
            Map<String, Object> obj = tableList.get(i);
            String userid = (String)obj.get("f_userid");
            String tableName = (String)obj.get("f_tablename");
            List<String> xzqmcList = this.getDictinctXzq(tableName);
            xzqmcList.forEach(item -> {
                DlgqStatistics statistics = null;
                if (resultData.containsKey(item)) {
                    statistics = (DlgqStatistics)resultData.get(item);
                } else {
                    statistics = new DlgqStatistics(item);
                    resultData.put((String)item, statistics);
                }
                statistics.getZydw().add(userid);
            });
        }
    }

    private List<String> getDictinctXzq(String tableName) {
        String sql = "select distinct f_xzqmc1 from " + tableName + " where f_xzqmc1 not in ('\u91cd\u5e86\u5e02(\u53bf)', '\u6cbf\u6cb3\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf', '\u6b66\u80dc\u53bf', '\u5229\u5ddd\u5e02')";
        List data = this.jdbcTemplate.queryForList(sql);
        ArrayList<String> result = new ArrayList<String>();
        data.forEach(item -> {
            String xzqmc = (String)item.get("f_xzqmc1");
            result.add(xzqmc);
        });
        return result;
    }

    private String unionSql(List<Map<String, Object>> tableList) {
        String sql = "";
        for (int i = 0; i < tableList.size(); ++i) {
            Map<String, Object> obj = tableList.get(i);
            String tableName = (String)obj.get("f_tablename");
            if (i != 0) {
                sql = sql + " union all";
            }
            sql = sql + " select f_id, f_status, f_xzqmc1, f_userid from " + tableName;
        }
        return sql;
    }

    private void sumTb(Map<String, DlgqStatistics> resultData, String unionSql, Integer type) {
        String sql = "select count(*) as f_count,f_xzqmc1 from (" + unionSql + ") t ";
        if (this.TYPE1 == type) {
            sql = sql + " where f_status = '4' ";
        }
        sql = sql + " GROUP BY f_xzqmc1";
        this.addData(resultData, sql, type);
    }

    private void sumMedia(Map<String, DlgqStatistics> resultData, String unionSql) {
        String sql = "";
        sql = sql + "select count(t2.f_galleryid) as f_count,f_xzqmc1 from (select f_galleryid from tb_app_media where f_galleryid in(select t.f_id from (";
        sql = sql + unionSql;
        sql = sql + ") t where f_status = 4) and f_type = 1 )t2,(";
        sql = sql + unionSql;
        sql = sql + ")t3 where t2.f_galleryid = t3.f_id GROUP BY t3.f_xzqmc1";
        this.addData(resultData, sql, this.TYPE3);
    }

    private void sumCyry(Map<String, DlgqStatistics> resultData, String unionSql) {
        String sql = "select count(distinct f_userid) as f_count,f_xzqmc1 from (" + unionSql + ") t GROUP BY f_xzqmc1";
        this.addData(resultData, sql, this.TYPE4);
    }

    private void addData(Map<String, DlgqStatistics> resultData, String sql, Integer type) {
        List dataList = this.jdbcTemplate.queryForList(sql);
        dataList.forEach(item -> {
            String xzqmc = (String)item.get("f_xzqmc1");
            Long count = (Long)item.get("f_count");
            if (resultData.containsKey(xzqmc)) {
                DlgqStatistics obj = (DlgqStatistics)resultData.get(xzqmc);
                if (type == this.TYPE1) {
                    obj.setTj(Integer.valueOf(obj.getTj() + Integer.valueOf(count.toString())));
                } else if (type == this.TYPE2) {
                    obj.setTb(Integer.valueOf(obj.getTb() + Integer.valueOf(count.toString())));
                } else if (type == this.TYPE3) {
                    obj.setZp(Integer.valueOf(obj.getZp() + Integer.valueOf(count.toString())));
                } else if (type == this.TYPE4) {
                    obj.setCyry(Integer.valueOf(obj.getCyry() + Integer.valueOf(count.toString())));
                }
            }
        });
    }

    private List<Map<String, Object>> process(Map<String, DlgqStatistics> resultData) {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        resultData.forEach((key, value) -> {
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("xzqmc", value.getXzqmc());
            obj.put("tb", value.getTb());
            obj.put("tj", value.getTj());
            obj.put("zp", value.getZp());
            obj.put("cyry", value.getCyry());
            obj.put("zydw", this.getZydw(value.getZydw()));
            obj.put("percent", new BigDecimal(value.getTj() * 100).divide(new BigDecimal(value.getTb()), 2, RoundingMode.HALF_UP));
            data.add(obj);
        });
        return data;
    }

    private String getZydw(Set<String> userSet) {
        String insql = StringUtils.join(userSet, (String)",");
        insql = insql.replace(",", "','");
        insql = "'" + insql + "'";
        String sql = "select distinct f_name from uis_organization where f_id in (select f_organizationid from uis_userorganization where f_userid in (" + insql + "));";
        List dataList = this.jdbcTemplate.queryForList(sql);
        HashSet result = new HashSet();
        dataList.forEach(item -> result.add((String)item.get("f_name")));
        return StringUtils.join(result, (String)",");
    }
}

