/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.statistics.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.dao.pub.ViewFxyjDao;
import com.geoway.landteam.landcloud.model.cffx.enm.WtTypeEnum;
import com.geoway.landteam.landcloud.model.cffx.enm.YjStateEnum;
import com.geoway.landteam.landcloud.model.statistics.dto.StaticFxyjYzb;
import com.geoway.landteam.landcloud.model.statistics.entity.StaticFxyjYjbb;
import com.geoway.landteam.landcloud.model.statistics.entity.StaticFxyjYjbb2;
import com.geoway.landteam.landcloud.model.statistics.entity.ViewFxyj;
import com.geoway.landteam.landcloud.repository.pub.StaticFxyjYjbb2Repository;
import com.geoway.landteam.landcloud.repository.pub.StaticFxyjYjbbRepository;
import com.geoway.landteam.landcloud.servface.statistics.StaticFxyjYjbbService;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class StaticFxyjYjbbServiceImpl
implements StaticFxyjYjbbService {
    @Autowired
    StaticFxyjYjbbRepository staticFxyjYjbbRepository;
    @Autowired
    StaticFxyjYjbb2Repository staticFxyjYjbb2Repository;
    @Autowired
    ViewFxyjDao viewFxyjDao;
    @Autowired
    RegionService regionService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Value(value="${project.uploadDir}")
    protected String uploadDir;

    public void batchSaveStaticFxyjYjbb(List<StaticFxyjYjbb> staticFxyjYjbbList) {
        this.staticFxyjYjbbRepository.saveAll(staticFxyjYjbbList);
    }

    public void batchSaveStaticFxyjYjbb2(List<StaticFxyjYjbb2> staticFxyjYjbbList) {
        this.staticFxyjYjbb2Repository.saveAll(staticFxyjYjbbList);
    }

    public void insertStatisticData() throws Exception {
        Calendar instance = Calendar.getInstance();
        String year = instance.get(1) + "";
        List viewListByTime = this.viewFxyjDao.getViewListByTime(year + "01", year + "12");
        List<StaticFxyjYjbb> result = this.dealViewToStaticFxyjYjbb(viewListByTime);
        this.batchSaveStaticFxyjYjbb(result);
    }

    public void insertNdtjStatisticData() throws Exception {
        Calendar instance = Calendar.getInstance();
        String year = instance.get(1) + "";
        List viewListByTime = this.viewFxyjDao.getViewListByTime(year + "01", year + "12");
        List<StaticFxyjYjbb2> result = this.dealViewToStaticFxyjYjbb2(viewListByTime);
        this.batchSaveStaticFxyjYjbb2(result);
    }

    public HashMap<String, Object> getGcpjStatistic(String year) {
        List<StaticFxyjYjbb> collect1 = this.getGcpjAndYjtxBb(year, "");
        int gfx = 0;
        int jgfx = 0;
        int zfx = 0;
        int jdfx = 0;
        int dfx = 0;
        int i = 0;
        for (StaticFxyjYjbb staticFxyjYjbb : collect1) {
            double sumScore = Double.valueOf(staticFxyjYjbb.getFSumscore());
            if (sumScore >= 74.5) {
                ++dfx;
            } else if (sumScore >= 52.8 && sumScore <= 65.0) {
                ++jdfx;
            } else if (sumScore >= 48.8 && sumScore <= 52.5) {
                ++zfx;
            } else if (sumScore >= 38.3 && sumScore < 44.8) {
                ++jgfx;
            } else if (sumScore <= 37.5) {
                ++gfx;
            }
            if (++i <= 8) {
                staticFxyjYjbb.setColor(YjStateEnum.lv.getCode());
                continue;
            }
            if (i <= 16) {
                staticFxyjYjbb.setColor(YjStateEnum.qing.getCode());
                continue;
            }
            if (i <= 24) {
                staticFxyjYjbb.setColor(YjStateEnum.huang.getCode());
                continue;
            }
            if (i <= 32) {
                staticFxyjYjbb.setColor(YjStateEnum.cheng.getCode());
                continue;
            }
            staticFxyjYjbb.setColor(YjStateEnum.hong.getCode());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gfx", gfx);
        map.put("jgfx", jgfx);
        map.put("zfx", zfx);
        map.put("jdfx", jdfx);
        map.put("dfx", dfx);
        map.put("gcpjAndYjtxBbList", collect1);
        return map;
    }

    public HashMap<String, Object> getYjtxStatistic(String year) {
        List<StaticFxyjYjbb> gcpjAndYjtxBbList = this.getGcpjAndYjtxBb(year, "2");
        int gfx = 0;
        int jgfx = 0;
        int zfx = 0;
        int jdfx = 0;
        int dfx = 0;
        boolean i = false;
        ArrayList qxfxqkList = new ArrayList();
        for (StaticFxyjYjbb staticFxyjYjbb : gcpjAndYjtxBbList) {
            int fYjtxPm = Integer.parseInt(staticFxyjYjbb.getFYjtxPm());
            String color = "";
            if (fYjtxPm <= 8) {
                color = "5";
                ++dfx;
            } else if (fYjtxPm <= 16) {
                color = "4";
                ++jdfx;
            } else if (fYjtxPm <= 24) {
                color = "3";
                ++zfx;
            } else if (fYjtxPm <= 32) {
                color = "2";
                ++jgfx;
            } else {
                color = "1";
                ++gfx;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("xzqdm", staticFxyjYjbb.getFXzqdm());
            map.put("xzqmc", staticFxyjYjbb.getFXzqmc());
            ArrayList fxTypeList = new ArrayList();
            map.put("yjsx", staticFxyjYjbb.getFYjtxYj());
            map.put("color", color);
            map.put("fzgPercent", staticFxyjYjbb.getFYjtxSumyzgpercent());
            qxfxqkList.add(map);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gfx", gfx);
        map.put("jgfx", jgfx);
        map.put("zfx", zfx);
        map.put("jdfx", jdfx);
        map.put("dfx", dfx);
        map.put("qxfxqkList", qxfxqkList);
        return map;
    }

    public HashMap<String, Object> getZBStatistic() {
        String regionSql = " select tr.f_xzqdm ,tr.f_xzqmc  from tb_region tr  where f_pcode in('500100','500200');";
        List regions = this.jdbcTemplate.queryForList(regionSql);
        JSONArray results = new JSONArray();
        for (Map region : regions) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("f_xzqdm", (Object)region.get("f_xzqdm").toString());
            jsonObject.put("f_xzqmc", (Object)region.get("f_xzqmc").toString());
            jsonObject.put("newTbmj", (Object)0);
            jsonObject.put("oldTbmj", (Object)0);
            jsonObject.put("rate", (Object)0);
            jsonObject.put("ypfjsx", (Object)"");
            results.add((Object)jsonObject);
        }
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String year = sdf.format(date);
        String sql1 = "select f_xzqdm ,f_xzqmc ,SUBSTRING(f_xfsj,1,4) as f_xfsj,count(1),sum(f_tbmj) as f_tbmj from business_apps_zhjg.view_fxyj  group by f_xzqdm ,f_xzqmc ,SUBSTRING(f_xfsj,1,4) ";
        List map1s = this.jdbcTemplate.queryForList(sql1);
        for (Map map : map1s) {
            String f_xzqdm = map.get("f_xzqdm").toString();
            String f_xfsj = map.get("f_xfsj").toString();
            Double f_tbmj = Double.parseDouble(map.get("f_tbmj").toString());
            for (int i = 0; i < results.size(); ++i) {
                JSONObject jsonObject = results.getJSONObject(i);
                String xzqdm = jsonObject.getString("f_xzqdm");
                if (!xzqdm.equals(f_xzqdm)) continue;
                if (f_xfsj.equals(year)) {
                    jsonObject.put("newTbmj", (Object)(jsonObject.getDoubleValue("newTbmj") + f_tbmj));
                } else {
                    jsonObject.put("oldTbmj", (Object)(jsonObject.getDoubleValue("oldTbmj") + f_tbmj));
                }
                double number = (jsonObject.getDoubleValue("oldTbmj") - jsonObject.getDoubleValue("newTbmj")) / jsonObject.getDoubleValue("oldTbmj");
                jsonObject.put("rate", (Object)number);
            }
        }
        String sql2 = "select f_ypfjsx,f_xzqdm,count(1) from business_apps_zhjg.view_fxyj  group by f_ypfjsx,f_xzqdm ";
        List map2s = this.jdbcTemplate.queryForList(sql2);
        for (Map map : map2s) {
            if (map.get("f_ypfjsx") == null) continue;
            String f_xzqdm = map.get("f_xzqdm").toString();
            String f_ypfjsx = map.get("f_ypfjsx").toString();
            String count = map.get("count").toString();
            for (int i = 0; i < results.size(); ++i) {
                JSONObject jsonObject = results.getJSONObject(i);
                String xzqdm = jsonObject.getString("f_xzqdm");
                if (!xzqdm.equals(f_xzqdm)) continue;
                jsonObject.put("ypfjsx", (Object)(StringUtils.isBlank((CharSequence)jsonObject.getString("ypfjsx")) ? f_ypfjsx + "(" + count + ")" : jsonObject.getString("ypfjsx") + "\u3001" + f_ypfjsx + "(" + count + ")"));
            }
        }
        int gfx = 0;
        int jgfx = 0;
        int zfx = 0;
        int jdfx = 0;
        int dfx = 0;
        for (int i = 0; i < results.size(); ++i) {
            JSONObject jsonObject = results.getJSONObject(i);
            Double rate = jsonObject.getDoubleValue("rate");
            if (rate >= 0.75) {
                ++jgfx;
                jsonObject.put("color", (Object)"\u8f83\u9ad8\u98ce\u9669");
            } else if (0.75 < rate && rate <= 0.5) {
                ++zfx;
                jsonObject.put("color", (Object)"\u4e2d\u98ce\u9669");
            } else if (0.5 < rate && rate <= 0.25) {
                ++jdfx;
                jsonObject.put("color", (Object)"\u8f83\u4f4e\u98ce\u9669");
            } else if (0.25 < rate && rate <= 0.0) {
                ++dfx;
                jsonObject.put("color", (Object)"\u4f4e\u98ce\u9669");
            } else {
                ++gfx;
                jsonObject.put("color", (Object)"\u9ad8\u98ce\u9669");
            }
            BigDecimal two11 = new BigDecimal(rate);
            double three11 = two11.setScale(2, 4).doubleValue();
            jsonObject.put("rate", (Object)three11);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gfx", gfx);
        map.put("jgfx", jgfx);
        map.put("zfx", zfx);
        map.put("jdfx", jdfx);
        map.put("dfx", dfx);
        map.put("qjzbqkList", results);
        return map;
    }

    private String calculatorFzgPercent(StaticFxyjYjbb staticFxyjYjbb) {
        int A = Integer.parseInt(staticFxyjYjbb.getFFnhWfwgnum());
        double M1 = Double.parseDouble(staticFxyjYjbb.getFFnhwfwgmj());
        int B = Integer.parseInt(staticFxyjYjbb.getFYjjbntflhWfwgnum());
        double M2 = Double.parseDouble(staticFxyjYjbb.getFYjjbntflhwfwgmj());
        int C = Integer.parseInt(staticFxyjYjbb.getFFnhYzgnum());
        double M3 = Double.parseDouble(staticFxyjYjbb.getFFnhyzgmj());
        int D = Integer.parseInt(staticFxyjYjbb.getFYjjbntflhYzgnum());
        double M4 = Double.parseDouble(staticFxyjYjbb.getFYjjbntflhyzgmj());
        double fnhPercent = 0.0;
        double flhPercent = 0.0;
        if (A != 0) {
            fnhPercent += (double)(C / A) * 0.3;
        }
        if (M1 != 0.0) {
            fnhPercent += M3 / M1 * 0.7;
        }
        if (B != 0) {
            flhPercent += (double)(D / B) * 0.3;
        }
        if (M2 != 0.0) {
            flhPercent += M4 / M2 * 0.7;
        }
        return new BigDecimal((fnhPercent + flhPercent) / 2.0).setScale(2, 4).toString();
    }

    public HashMap<String, Object> getNdkhStatistic(String year) {
        List<StaticFxyjYjbb2> collect1 = this.getNdkhBb(year);
        int gfx = 0;
        int jgfx = 0;
        int zfx = 0;
        int jdfx = 0;
        int dfx = 0;
        int i = 0;
        for (StaticFxyjYjbb2 staticFxyjYjbb2 : collect1) {
            double sumScore = Double.valueOf(staticFxyjYjbb2.getFKhdf());
            if (sumScore >= 97.6) {
                ++dfx;
            } else if (sumScore >= 92.8 && sumScore <= 97.1) {
                ++jdfx;
            } else if (sumScore >= 90.0 && sumScore <= 92.6) {
                ++zfx;
            } else if (sumScore >= 83.7 && sumScore < 89.9) {
                ++jgfx;
            } else if (sumScore <= 83.4) {
                ++gfx;
            }
            if (++i <= 8) {
                staticFxyjYjbb2.setColor(YjStateEnum.lv.getCode());
                continue;
            }
            if (i <= 16) {
                staticFxyjYjbb2.setColor(YjStateEnum.qing.getCode());
                continue;
            }
            if (i <= 24) {
                staticFxyjYjbb2.setColor(YjStateEnum.huang.getCode());
                continue;
            }
            if (i <= 32) {
                staticFxyjYjbb2.setColor(YjStateEnum.cheng.getCode());
                continue;
            }
            staticFxyjYjbb2.setColor(YjStateEnum.hong.getCode());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gfx", gfx);
        map.put("jgfx", jgfx);
        map.put("zfx", zfx);
        map.put("jdfx", jdfx);
        map.put("dfx", dfx);
        map.put("ndkhBbList", collect1);
        return map;
    }

    public HashMap<String, Object> getYBZStatistic(String year, boolean isContainSum) {
        List<StaticFxyjYzb> collect1 = this.getYbzBb(year, isContainSum);
        int gfx = 0;
        int jgfx = 0;
        int zfx = 0;
        int jdfx = 0;
        int dfx = 0;
        for (StaticFxyjYzb staticFxyjYjbb : collect1) {
            int i = staticFxyjYjbb.getPm();
            if (i == 0) continue;
            if (i <= 8) {
                ++dfx;
                staticFxyjYjbb.setColor(YjStateEnum.lv.getCode());
                continue;
            }
            if (i <= 16) {
                ++jdfx;
                staticFxyjYjbb.setColor(YjStateEnum.qing.getCode());
                continue;
            }
            if (i <= 24) {
                ++zfx;
                staticFxyjYjbb.setColor(YjStateEnum.huang.getCode());
                continue;
            }
            if (i <= 32) {
                ++jgfx;
                staticFxyjYjbb.setColor(YjStateEnum.cheng.getCode());
                continue;
            }
            ++gfx;
            staticFxyjYjbb.setColor(YjStateEnum.hong.getCode());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gfx", gfx);
        map.put("jgfx", jgfx);
        map.put("zfx", zfx);
        map.put("jdfx", jdfx);
        map.put("dfx", dfx);
        map.put("ybzBbList", collect1);
        return map;
    }

    private List<StaticFxyjYzb> getYbzBb(String selectYear, boolean isContainSum) {
        Calendar instance = Calendar.getInstance();
        int year = instance.get(1);
        List nowData = this.viewFxyjDao.getViewListByTime(year + "01", year + "12");
        Map<String, List<ViewFxyj>> nowXzqdmAndList = nowData.stream().collect(Collectors.groupingBy(ViewFxyj::getFXzqdm));
        HashMap<String, StaticFxyjYzb> nowMap = new HashMap<String, StaticFxyjYzb>();
        for (Map.Entry<String, List<ViewFxyj>> stringListEntry : nowXzqdmAndList.entrySet()) {
            StaticFxyjYzb staticFxyjYzb = new StaticFxyjYzb();
            List<ViewFxyj> value = stringListEntry.getValue();
            List collect = value.stream().filter(u -> "\u662f".equals(u.getFSfwfwgwt())).collect(Collectors.toList());
            int size = collect.size();
            double sum = collect.stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getFGdmj())).mapToDouble(u -> Double.valueOf(u.getFGdmj())).sum();
            staticFxyjYzb.setXzqdm(value.get(0).getFXzqdm());
            staticFxyjYzb.setXzqmc(value.get(0).getFXzqmc());
            staticFxyjYzb.setXzwtWtqkNum(size);
            staticFxyjYzb.setXzwtWtqkMj(new BigDecimal(sum).setScale(2, 4).toString());
            List collect2 = value.stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getFZglsqk())).collect(Collectors.toList());
            int size2 = collect2.size();
            double sum2 = collect2.stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getFGdmj())).mapToDouble(u -> Double.valueOf(u.getFGdmj())).sum();
            staticFxyjYzb.setXzwtWtzgNum(size2);
            staticFxyjYzb.setXzwtWtzgMj(new BigDecimal(sum2).setScale(2, 4).toString());
            nowMap.put(stringListEntry.getKey(), staticFxyjYzb);
        }
        String hisStartTime = "197001";
        String hisEndTime = year - 1 + "12";
        if (StringUtils.isNotBlank((CharSequence)selectYear)) {
            hisStartTime = selectYear + "01";
            hisEndTime = selectYear + "12";
        }
        List historyData = this.viewFxyjDao.getViewListByTime(hisStartTime, hisEndTime);
        Map<String, List<ViewFxyj>> hisXzqdmAndList = historyData.stream().collect(Collectors.groupingBy(ViewFxyj::getFXzqdm));
        HashMap<String, StaticFxyjYzb> hisMap = new HashMap<String, StaticFxyjYzb>();
        for (Map.Entry<String, List<ViewFxyj>> stringListEntry : hisXzqdmAndList.entrySet()) {
            StaticFxyjYzb staticFxyjYzb = new StaticFxyjYzb();
            List<ViewFxyj> value = stringListEntry.getValue();
            List collect = value.stream().filter(u -> "\u662f".equals(u.getFSfwfwgwt())).collect(Collectors.toList());
            int size = collect.size();
            double sum = collect.stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getFGdmj())).mapToDouble(u -> Double.valueOf(u.getFGdmj())).sum();
            staticFxyjYzb.setXzqdm(value.get(0).getFXzqdm());
            staticFxyjYzb.setXzqmc(value.get(0).getFXzqmc());
            staticFxyjYzb.setXzwtWtqkNum(size);
            staticFxyjYzb.setXzwtWtqkMj(new BigDecimal(sum).setScale(2, 4).toString());
            List collect2 = value.stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getFZglsqk())).collect(Collectors.toList());
            int size2 = collect2.size();
            double sum2 = collect2.stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getFGdmj())).mapToDouble(u -> Double.valueOf(u.getFGdmj())).sum();
            staticFxyjYzb.setXzwtWtzgNum(size2);
            staticFxyjYzb.setXzwtWtzgMj(new BigDecimal(sum2).setScale(2, 4).toString());
            hisMap.put(stringListEntry.getKey(), staticFxyjYzb);
        }
        List<StaticFxyjYzb> list = this.combineNowAndHis(nowMap, hisMap, isContainSum);
        for (StaticFxyjYzb staticFxyjYzb : list) {
            staticFxyjYzb.setXzwtWtzgPercent(staticFxyjYzb.getXzwtWtzgPercent() + "%");
            staticFxyjYzb.setClwtWtzgPercent(staticFxyjYzb.getClwtWtzgPercent() + "%");
            staticFxyjYzb.setPercent(staticFxyjYzb.getPercent() + "%");
        }
        return list;
    }

    private List<StaticFxyjYzb> combineNowAndHis(HashMap<String, StaticFxyjYzb> nowMap, HashMap<String, StaticFxyjYzb> hisMap, boolean isContainSum) {
        Set<String> all = nowMap.keySet();
        Set<String> his = hisMap.keySet();
        his.addAll(all);
        ArrayList<StaticFxyjYzb> list = new ArrayList<StaticFxyjYzb>();
        for (String s : his) {
            StaticFxyjYzb item = new StaticFxyjYzb();
            StaticFxyjYzb xzwt = nowMap.get(s);
            StaticFxyjYzb clwt = hisMap.get(s);
            if (xzwt != null) {
                item.setXzqdm(xzwt.getXzqdm());
                item.setXzqmc(xzwt.getXzqmc());
                item.setXzwtWtqkNum(xzwt.getXzwtWtqkNum());
                item.setXzwtWtqkMj(StringUtils.isNotBlank((CharSequence)xzwt.getXzwtWtqkMj()) ? xzwt.getXzwtWtqkMj() : "0.0");
                item.setXzwtWtzgNum(xzwt.getXzwtWtzgNum());
                item.setXzwtWtzgMj(StringUtils.isNotBlank((CharSequence)xzwt.getXzwtWtzgMj()) ? xzwt.getXzwtWtzgMj() : "0.0");
            } else {
                item.setXzwtWtqkMj("0.0");
                item.setXzwtWtzgMj("0.0");
            }
            if (clwt != null) {
                item.setXzqdm(clwt.getXzqdm());
                item.setXzqmc(clwt.getXzqmc());
                item.setClwtWtqkNum(clwt.getClwtWtqkNum());
                item.setClwtWtqkMj(StringUtils.isNotBlank((CharSequence)clwt.getClwtWtqkMj()) ? clwt.getClwtWtqkMj() : "0.0");
                item.setClwtWtzgNum(clwt.getClwtWtzgNum());
                item.setClwtWtzgMj(StringUtils.isNotBlank((CharSequence)clwt.getClwtWtzgMj()) ? clwt.getClwtWtzgMj() : "0.0");
            } else {
                item.setClwtWtqkMj("0.0");
                item.setClwtWtzgMj("0.0");
            }
            list.add(item);
        }
        if (isContainSum) {
            int xzNum = list.stream().mapToInt(u -> u.getXzwtWtqkNum()).sum();
            double xzMj = list.stream().mapToDouble(u -> Double.parseDouble(u.getXzwtWtqkMj())).sum();
            int xzZgNum = list.stream().mapToInt(u -> u.getXzwtWtzgNum()).sum();
            double xzZgMj = list.stream().mapToDouble(u -> Double.parseDouble(u.getXzwtWtzgMj())).sum();
            int clNum = list.stream().mapToInt(u -> u.getClwtWtqkNum()).sum();
            double clMj = list.stream().mapToDouble(u -> Double.parseDouble(u.getClwtWtqkMj())).sum();
            int clZgNum = list.stream().mapToInt(u -> u.getClwtWtzgNum()).sum();
            double clZgMj = list.stream().mapToDouble(u -> Double.parseDouble(u.getClwtWtzgMj())).sum();
            StaticFxyjYzb item = new StaticFxyjYzb();
            item.setXzqdm("500000");
            item.setXzqmc("\u91cd\u5e86\u5e02");
            item.setXzwtWtqkNum(xzNum);
            item.setXzwtWtqkMj(new BigDecimal(xzMj).setScale(2, 4).toString());
            item.setXzwtWtzgNum(xzZgNum);
            item.setXzwtWtzgMj(new BigDecimal(xzZgMj).setScale(2, 4).toString());
            item.setClwtWtqkNum(clNum);
            item.setClwtWtqkMj(new BigDecimal(clMj).setScale(2, 4).toString());
            item.setClwtWtzgNum(clZgNum);
            item.setClwtWtzgMj(new BigDecimal(clZgMj).setScale(2, 4).toString());
            list.add(item);
        }
        list.forEach(u -> {
            int F = u.getXzwtWtzgNum();
            int D = u.getXzwtWtqkNum();
            double G = Double.parseDouble(u.getXzwtWtzgMj());
            double E = Double.parseDouble(u.getXzwtWtqkMj());
            double H = 0.0;
            H = D == 0 || E == 0.0 ? 1.0 : (double)(F / D) * 0.3 + G / E * 0.7;
            u.setXzwtWtzgPercent(new BigDecimal(H * 100.0).setScale(2, 4).toString());
            int K = u.getClwtWtzgNum();
            int I = u.getClwtWtqkNum();
            double L = Double.parseDouble(u.getClwtWtzgMj());
            double J = Double.parseDouble(u.getClwtWtqkMj());
            double M = 0.0;
            M = I == 0 || J == 0.0 ? 1.0 : (double)(K / I) * 0.3 + L / J * 0.7;
            u.setClwtWtzgPercent(new BigDecimal(M * 100.0).setScale(2, 4).toString());
            double percent = H * 0.5 + M * 0.5;
            u.setPercent(new BigDecimal(percent * 100.0).setScale(2, 4).toString());
        });
        List result = list.stream().sorted((o1, o2) -> {
            if (Double.parseDouble(o1.getPercent()) >= Double.parseDouble(o2.getPercent())) {
                return 1;
            }
            return -1;
        }).collect(Collectors.toList());
        if (isContainSum) {
            List<StaticFxyjYzb> collect = result.stream().filter(u -> !u.getXzqdm().equals("500000")).collect(Collectors.toList());
            StaticFxyjYzb cq = (StaticFxyjYzb)result.stream().filter(u -> u.getXzqdm().equals("500000")).collect(Collectors.toList()).get(0);
            collect.add(cq);
            Collections.reverse(collect);
            int i = 0;
            for (StaticFxyjYzb staticFxyjYzb : collect) {
                staticFxyjYzb.setPm(i);
                staticFxyjYzb.setXh(i + "");
                ++i;
            }
            return collect;
        }
        Collections.reverse(list);
        int i = 1;
        for (StaticFxyjYzb staticFxyjYzb : list) {
            staticFxyjYzb.setPm(i);
            staticFxyjYzb.setXh(i + "");
            ++i;
        }
        return list;
    }

    private List<StaticFxyjYjbb2> dealViewToStaticFxyjYjbb2(List<ViewFxyj> viewListByTime) {
        viewListByTime.stream().forEach(u -> {
            if (StringUtils.isBlank((CharSequence)u.getFGdmj())) {
                u.setFGdmj("0");
            }
            if (StringUtils.isBlank((CharSequence)u.getFYjjbntmj())) {
                u.setFYjjbntmj("0");
            }
        });
        Map<String, List<ViewFxyj>> collect = viewListByTime.stream().collect(Collectors.groupingBy(ViewFxyj::getFXzqdm));
        ArrayList<StaticFxyjYjbb2> result = new ArrayList<StaticFxyjYjbb2>();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        for (Map.Entry<String, List<ViewFxyj>> stringListEntry : collect.entrySet()) {
            List<ViewFxyj> value = stringListEntry.getValue();
            StaticFxyjYjbb2 staticFxyjYjbb = new StaticFxyjYjbb2();
            List zdwt = WtTypeEnum.getCodeList((String)"zddx");
            List zdwtList = value.stream().filter(u -> zdwt.indexOf(u.getFWtlx()) != -1).collect(Collectors.toList());
            staticFxyjYjbb.setFFxwtZddxmj(String.valueOf(new BigDecimal(zdwtList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, 4)));
            staticFxyjYjbb.setFFxwtZddxscore(String.valueOf(new BigDecimal(Double.valueOf(staticFxyjYjbb.getFFxwtZddxmj()) * 0.1).setScale(2, 4)));
            List wfwg = WtTypeEnum.getCodeList((String)"fnh");
            List wfwgList = value.stream().filter(u -> wfwg.indexOf(u.getFWtlx()) != -1).collect(Collectors.toList());
            staticFxyjYjbb.setFFxwtWfwgmj(String.valueOf(new BigDecimal(wfwgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, 4)));
            staticFxyjYjbb.setFFxwtWfwgscore(String.valueOf(new BigDecimal(Double.valueOf(staticFxyjYjbb.getFFxwtWfwgmj()) * 0.05).setScale(2, 4)));
            List gdflh = WtTypeEnum.getCodeList((String)"flh");
            List gdflhList = value.stream().filter(u -> gdflh.indexOf(u.getFWtlx()) != -1).collect(Collectors.toList());
            staticFxyjYjbb.setFFxwtGdflhmj(String.valueOf(new BigDecimal(gdflhList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, 4)));
            staticFxyjYjbb.setFFxwtGdflhscore(String.valueOf(new BigDecimal(Double.valueOf(staticFxyjYjbb.getFFxwtGdflhmj()) * 0.01).setScale(2, 4)));
            double fxwtScore = Double.valueOf(staticFxyjYjbb.getFFxwtZddxscore()) + Double.valueOf(staticFxyjYjbb.getFFxwtWfwgscore()) + Double.valueOf(staticFxyjYjbb.getFFxwtGdflhscore());
            staticFxyjYjbb.setFFxwtScore(String.valueOf(new BigDecimal(fxwtScore).setScale(2, 4)));
            List zdwtYzgList = zdwtList.stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getFZglsqk())).collect(Collectors.toList());
            staticFxyjYjbb.setFWtzgZddxmj(String.valueOf(new BigDecimal(zdwtYzgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, 4)));
            staticFxyjYjbb.setFWtzgZddxscore(String.valueOf(new BigDecimal(Double.valueOf(staticFxyjYjbb.getFWtzgZddxmj()) * 0.08).setScale(2, 4)));
            List wfwgYzgList = wfwgList.stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getFZglsqk())).collect(Collectors.toList());
            staticFxyjYjbb.setFWtzgWfwgmj(String.valueOf(new BigDecimal(wfwgYzgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, 4)));
            staticFxyjYjbb.setFWtzgWfwgscore(String.valueOf(new BigDecimal(Double.valueOf(staticFxyjYjbb.getFFxwtWfwgmj()) * 0.04).setScale(2, 4)));
            List gdflhYzgList = gdflhList.stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getFZglsqk())).collect(Collectors.toList());
            staticFxyjYjbb.setFWtzgGdflhmj(String.valueOf(new BigDecimal(gdflhYzgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, 4)));
            staticFxyjYjbb.setFWtzgGdflhscore(String.valueOf(new BigDecimal(Double.valueOf(staticFxyjYjbb.getFFxwtGdflhmj()) * 0.008).setScale(2, 4)));
            double wtzgScore = Double.valueOf(staticFxyjYjbb.getFWtzgZddxscore()) + Double.valueOf(staticFxyjYjbb.getFWtzgWfwgscore()) + Double.valueOf(staticFxyjYjbb.getFWtzgGdflhscore());
            staticFxyjYjbb.setFWtzgScore(String.valueOf(new BigDecimal(wtzgScore).setScale(2, 4)));
            staticFxyjYjbb.setFId(UUID.randomUUID().toString());
            staticFxyjYjbb.setFXzqdm(stringListEntry.getKey());
            staticFxyjYjbb.setFXzqmc(value.get(0).getFXzqmc());
            double sumScore = 100.0 - fxwtScore + wtzgScore;
            staticFxyjYjbb.setFKhdf(String.valueOf(new BigDecimal(sumScore).setScale(2, 4)));
            staticFxyjYjbb.setFCreatetime(timestamp);
            result.add(staticFxyjYjbb);
        }
        List<StaticFxyjYjbb2> collect1 = result.stream().sorted((o1, o2) -> {
            if (Double.valueOf(o1.getFKhdf()) >= Double.valueOf(o2.getFKhdf())) {
                return -1;
            }
            return 1;
        }).collect(Collectors.toList());
        int i = 0;
        for (StaticFxyjYjbb2 staticFxyjYjbb2 : collect1) {
            staticFxyjYjbb2.setFPm(String.valueOf(++i));
        }
        return collect1;
    }

    public List<StaticFxyjYjbb> getGcpjAndYjtxBb(String year, String type) {
        String time = year + "-12-31 23:59:59";
        List<Object> collect1 = null;
        List staticFxyjYjbbs = this.staticFxyjYjbbRepository.queryRecentList(time);
        collect1 = "2".equals(type) ? staticFxyjYjbbs.stream().sorted((o1, o2) -> {
            if (Double.valueOf(o1.getFYjtxPm()) >= Double.valueOf(o2.getFYjtxPm())) {
                return 1;
            }
            return -1;
        }).collect(Collectors.toList()) : staticFxyjYjbbs.stream().sorted((o1, o2) -> {
            if (Double.valueOf(o1.getFSumscore()) >= Double.valueOf(o2.getFSumscore())) {
                return -1;
            }
            return 1;
        }).collect(Collectors.toList());
        int i = 0;
        for (StaticFxyjYjbb staticFxyjYjbb : collect1) {
            staticFxyjYjbb.setXh(++i + "");
        }
        return collect1;
    }

    public List<StaticFxyjYjbb2> getNdkhBb(String year) {
        String time = year + "-12-31 23:59:59";
        List staticFxyjYjbbs = this.staticFxyjYjbb2Repository.queryRecentList(time);
        List<StaticFxyjYjbb2> collect1 = staticFxyjYjbbs.stream().sorted((o1, o2) -> {
            if (Double.valueOf(o1.getFKhdf()) >= Double.valueOf(o2.getFKhdf())) {
                return -1;
            }
            return 1;
        }).collect(Collectors.toList());
        int i = 0;
        for (StaticFxyjYjbb2 staticFxyjYjbb2 : collect1) {
            staticFxyjYjbb2.setXh(++i + "");
        }
        return collect1;
    }

    private List<StaticFxyjYjbb> dealViewToStaticFxyjYjbb(List<ViewFxyj> viewListByTime) throws Exception {
        viewListByTime.stream().forEach(u -> {
            if (StringUtils.isBlank((CharSequence)u.getFGdmj())) {
                u.setFGdmj("0");
            }
            if (StringUtils.isBlank((CharSequence)u.getFYjjbntmj())) {
                u.setFYjjbntmj("0");
            }
        });
        Map<String, List<ViewFxyj>> collect = viewListByTime.stream().collect(Collectors.groupingBy(ViewFxyj::getFXzqdm));
        ArrayList<StaticFxyjYjbb> result = new ArrayList<StaticFxyjYjbb>();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        for (Map.Entry<String, List<ViewFxyj>> stringListEntry : collect.entrySet()) {
            List<ViewFxyj> value = stringListEntry.getValue();
            StaticFxyjYjbb staticFxyjYjbb = new StaticFxyjYjbb();
            staticFxyjYjbb.setFId(UUID.randomUUID().toString());
            staticFxyjYjbb.setFXzqdm(stringListEntry.getKey());
            staticFxyjYjbb.setFXzqmc(value.get(0).getFXzqmc());
            List zdwt = WtTypeEnum.getCodeList((String)"zddx");
            List zdwtList = value.stream().filter(u -> zdwt.indexOf(u.getFWtlx()) != -1).collect(Collectors.toList());
            List zdwtYzgList = zdwtList.stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getFZglsqk())).collect(Collectors.toList());
            staticFxyjYjbb.setFZddxnum(String.valueOf(zdwtList.size()));
            staticFxyjYjbb.setFZddxwfwgmj(String.valueOf(new BigDecimal(zdwtList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, 4)));
            staticFxyjYjbb.setFZddxyzgmj(String.valueOf(new BigDecimal(zdwtYzgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, 4)));
            String zddxyj = zdwtList.size() > 0 ? YjStateEnum.hong.getCode() : YjStateEnum.lv.getCode();
            staticFxyjYjbb.setFZddxyj(zddxyj);
            List fnh = WtTypeEnum.getCodeList((String)"fnh");
            List fnhList = value.stream().filter(u -> fnh.indexOf(u.getFWtlx()) != -1).collect(Collectors.toList());
            List fnhYzgList = fnhList.stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getFZglsqk())).collect(Collectors.toList());
            staticFxyjYjbb.setFFnhwfwgmj(String.valueOf(new BigDecimal(fnhList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, 4)));
            staticFxyjYjbb.setFFnhyzgmj(String.valueOf(new BigDecimal(fnhYzgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, 4)));
            staticFxyjYjbb.setFFnhyj(YjStateEnum.getYjCodeByMj((String)"fnhmj", (double)Double.valueOf(staticFxyjYjbb.getFFnhwfwgmj())));
            staticFxyjYjbb.setFFnhWfwgnum(fnhList.size() + "");
            staticFxyjYjbb.setFFnhYzgnum(fnhYzgList.size() + "");
            List flh = WtTypeEnum.getCodeList((String)"flh");
            List flhList = value.stream().filter(u -> flh.indexOf(u.getFWtlx()) != -1).collect(Collectors.toList());
            List flhYzgList = flhList.stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getFZglsqk())).collect(Collectors.toList());
            staticFxyjYjbb.setFYjjbntflhwfwgmj(String.valueOf(new BigDecimal(flhList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFYjjbntmj())).sum()).setScale(2, 4)));
            staticFxyjYjbb.setFYjjbntflhyzgmj(String.valueOf(new BigDecimal(flhYzgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFYjjbntmj())).sum()).setScale(2, 4)));
            staticFxyjYjbb.setFYjjbntflhyj(YjStateEnum.getYjCodeByMj((String)"yjjbntflhmj", (double)Double.valueOf(staticFxyjYjbb.getFYjjbntflhwfwgmj())));
            staticFxyjYjbb.setFYjjbntflhWfwgnum(flhList.size() + "");
            staticFxyjYjbb.setFYjjbntflhYzgnum(flhYzgList.size() + "");
            double fnhScore = 25.0 - Double.valueOf(staticFxyjYjbb.getFFnhwfwgmj()) * 0.05;
            double flhScore = 25.0 - Double.valueOf(staticFxyjYjbb.getFYjjbntflhwfwgmj()) * 0.01;
            double fnhPercent = 0.0;
            fnhPercent = fnhList.size() == 0 ? 0.0 : (double)fnhYzgList.size() * 1.0 / (double)fnhList.size();
            double flhPercent = 0.0;
            flhPercent = flhList.size() == 0 ? 0.0 : (double)flhYzgList.size() * 1.0 / (double)flhList.size();
            double fnhZgScore = 25.0 * fnhPercent;
            double flhZgScore = 25.0 * flhPercent;
            staticFxyjYjbb.setFYtzlpjfnh(String.valueOf(new BigDecimal(fnhScore).setScale(2, 4)));
            staticFxyjYjbb.setFYtzlpjyjjbntflh(String.valueOf(new BigDecimal(flhScore).setScale(2, 4)));
            staticFxyjYjbb.setFWfzgpjfnhpercent(String.valueOf(new BigDecimal(fnhPercent).setScale(2, 4)));
            staticFxyjYjbb.setFWfzgpjyjjbntflhpercent(String.valueOf(new BigDecimal(flhPercent).setScale(2, 4)));
            staticFxyjYjbb.setFWfzgpjfnhscore(String.valueOf(new BigDecimal(fnhZgScore).setScale(2, 4)));
            staticFxyjYjbb.setFWfzgpjyjjbntflhscore(String.valueOf(new BigDecimal(flhZgScore).setScale(2, 4)));
            double sumScore = Double.valueOf(staticFxyjYjbb.getFYtzlpjfnh()) + Double.valueOf(staticFxyjYjbb.getFYtzlpjyjjbntflh()) + Double.valueOf(staticFxyjYjbb.getFWfzgpjfnhscore()) + Double.valueOf(staticFxyjYjbb.getFWfzgpjyjjbntflhscore());
            staticFxyjYjbb.setFSumscore(String.valueOf(new BigDecimal(sumScore).setScale(2, 4)));
            String hightPriority = YjStateEnum.getHightPriority((String)YjStateEnum.getHightPriority((String)staticFxyjYjbb.getFZddxyj(), (String)staticFxyjYjbb.getFFnhyj()), (String)staticFxyjYjbb.getFYjjbntflhyj());
            staticFxyjYjbb.setFYj(hightPriority);
            staticFxyjYjbb.setFCreatetime(timestamp);
            int A = fnhList.size();
            double B = Double.parseDouble(staticFxyjYjbb.getFFnhwfwgmj());
            int C = flhList.size();
            double D = Double.parseDouble(new BigDecimal(flhList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, 4).toString());
            int I = fnhYzgList.size();
            double J = Double.parseDouble(staticFxyjYjbb.getFFnhyzgmj());
            int K = flhYzgList.size();
            double L = Double.parseDouble(new BigDecimal(flhYzgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, 4).toString());
            staticFxyjYjbb.setFWfqkXzwtFnhnum(A + "");
            staticFxyjYjbb.setFWfqkXzwtFnhmj(String.valueOf(new BigDecimal(B).setScale(2, 4)));
            staticFxyjYjbb.setFWfqkXzwtFlhnum(String.valueOf(new BigDecimal(C).setScale(2, 4)));
            staticFxyjYjbb.setFWfqkXzwtFlhmj(String.valueOf(new BigDecimal(D).setScale(2, 4)));
            staticFxyjYjbb.setFZgqkXzwtFnhnum(String.valueOf(new BigDecimal(I).setScale(2, 4)));
            staticFxyjYjbb.setFZgqkXzwtFnhmj(String.valueOf(new BigDecimal(J).setScale(2, 4)));
            staticFxyjYjbb.setFZgqkXzwtFlhnum(String.valueOf(new BigDecimal(K).setScale(2, 4)));
            staticFxyjYjbb.setFZgqkXzwtFlhmj(String.valueOf(new BigDecimal(L).setScale(2, 4)));
            staticFxyjYjbb.setFWfqkXzwtSumnum(String.valueOf(new BigDecimal(A + C).setScale(2, 4)));
            staticFxyjYjbb.setFWfqkXzwtSummj(String.valueOf(new BigDecimal(B + D).setScale(2, 4)));
            staticFxyjYjbb.setFZgqkXzwtSumnum(String.valueOf(new BigDecimal(I + K).setScale(2, 4)));
            staticFxyjYjbb.setFZgqkXzwtSummj(String.valueOf(new BigDecimal(J + L).setScale(2, 4)));
            double T = 0.0;
            if (A + C != 0) {
                T += (double)((I + K) / (A + C)) * 0.3;
            }
            if (B + D != 0.0) {
                T += (J + L) / (B + D) * 0.7;
            }
            staticFxyjYjbb.setFZgqkXzwtSumyzgpercent(String.valueOf(new BigDecimal(T).setScale(2, 4)));
            double fnhyzgPercent = T;
            if (A != 0) {
                fnhyzgPercent += (double)(I / A) * 0.3;
            }
            if (B != 0.0) {
                fnhyzgPercent += J / B * 0.7;
            }
            staticFxyjYjbb.setFZgqkXzwtFnhyzgpercent(String.valueOf(new BigDecimal(fnhyzgPercent).setScale(2, 4)));
            double flhyzgPercent = 0.0;
            if (C != 0) {
                flhyzgPercent += (double)(K / C) * 0.3;
            }
            if (D != 0.0) {
                flhyzgPercent += L / D * 0.7;
            }
            staticFxyjYjbb.setFZgqkXzwtFlhyzgpercent(String.valueOf(new BigDecimal(flhyzgPercent).setScale(2, 4)));
            staticFxyjYjbb.setFWfqkXzwtFlhynmj(staticFxyjYjbb.getFYjjbntflhwfwgmj());
            boolean F = false;
            staticFxyjYjbb.setFYjtxSumyzgpercent(String.valueOf(new BigDecimal(T * 0.5 + (double)F * 0.5).setScale(2, 4)));
            String yjType = this.getYjType(value, staticFxyjYjbb);
            staticFxyjYjbb.setFYjtxYj(yjType);
            result.add(staticFxyjYjbb);
        }
        List<StaticFxyjYjbb> collect1 = result.stream().sorted((o1, o2) -> {
            if (Double.valueOf(o1.getFYjtxSumyzgpercent()) >= Double.valueOf(o2.getFYjtxSumyzgpercent())) {
                return -1;
            }
            return 1;
        }).collect(Collectors.toList());
        int i = 0;
        for (StaticFxyjYjbb staticFxyjYjbb : collect1) {
            staticFxyjYjbb.setFYjtxPm(++i + "");
        }
        return collect1;
    }

    private String getYjType(List<ViewFxyj> value, StaticFxyjYjbb staticFxyjYjbb) {
        double fWfqkXzwtFlhynmj;
        double fWfqkXzwtFnhmj;
        String str = "";
        List gywt = WtTypeEnum.getCodeList((String)"yjtxgywt");
        List gywtList = value.stream().filter(u -> gywt.indexOf(u.getFWtlx()) != -1).collect(Collectors.toList());
        if (gywtList != null && gywtList.size() > 0) {
            str = str + "\u516c\u56ed\u95ee\u9898(" + gywtList.size() + "),";
        }
        if ((fWfqkXzwtFnhmj = Double.parseDouble(staticFxyjYjbb.getFWfqkXzwtFnhmj())) >= 100.0) {
            str = str + "\u201c\u975e\u519c\u5316\u201d\u95ee\u9898\u9884\u8b66\uff08" + fWfqkXzwtFnhmj + "\u4ea9\uff09,";
        }
        if ((fWfqkXzwtFlhynmj = Double.parseDouble(staticFxyjYjbb.getFWfqkXzwtFlhynmj())) >= 350.0) {
            str = str + "\u201c\u975e\u7cae\u5316\u201d\u95ee\u9898\u9884\u8b66\uff08" + fWfqkXzwtFnhmj + "\u4ea9\uff09,";
        }
        if (StringUtils.isNotBlank((CharSequence)str)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static void main(String[] args) {
        String str = "\u516c\u56ed\u95ee\u9898,";
        if (StringUtils.isNotBlank((CharSequence)str)) {
            str = str.substring(0, str.length() - 1);
        }
        System.out.println("-----------------");
    }

    public void downloadNdkhBbExcel(HttpServletResponse response, String year) throws Exception {
        List<StaticFxyjYjbb2> result = this.getNdkhBb(year);
        this.downloadGcpjAndYjtx(response, result, "\u4e94\u8272\u56fe\u5e74\u5ea6\u8003\u6838\u62a5\u8868");
    }

    public void downloadYBZBbExcel(HttpServletResponse response, String year) throws Exception {
        List<StaticFxyjYzb> ybzBb = this.getYbzBb(year, true);
        this.downloadYBZBb(response, ybzBb, "\u4e94\u8272\u56fe\u4e00\u672c\u8d26");
    }

    private String downloadYBZBb(HttpServletResponse response, List<StaticFxyjYzb> ybzBb, String fileName) throws Exception {
        StaticFxyjYzb cq = (StaticFxyjYzb)ybzBb.stream().filter(u -> u.getXzqdm().equals("500000")).collect(Collectors.toList()).get(0);
        List list = ybzBb.stream().filter(u -> !u.getXzqdm().equals("500000")).collect(Collectors.toList());
        ClassPathResource wst = new ClassPathResource("/static/excel/" + fileName + ".xlsx");
        File wstFile = File.createTempFile("template_STSONG_copy", ".xlsx");
        FileUtils.copyInputStreamToFile((InputStream)wst.getInputStream(), (File)wstFile);
        String srcFileName = wstFile.getAbsolutePath();
        String ouputPath = this.uploadDir + File.separator + "excel" + File.separator + (fileName + System.currentTimeMillis() + ".xlsx");
        try {
            response.setContentType("application/vnd.ms-excel");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String excelfileName = URLEncoder.encode(fileName + "_" + System.currentTimeMillis(), "utf-8");
            response.setHeader("Content-disposition", "attachment;fileName=" + excelfileName + ".xls");
            ServletOutputStream out = response.getOutputStream();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("list", list);
            map.put("cqwtnum", cq.getXzwtWtqkNum());
            map.put("cqwtmj", cq.getXzwtWtqkMj());
            map.put("cqzgnum", cq.getXzwtWtzgNum());
            map.put("cqzgmj", cq.getXzwtWtzgMj());
            map.put("cqzgpercent", cq.getXzwtWtzgPercent());
            map.put("cqwtnum2", cq.getClwtWtqkNum());
            map.put("cqwtmj2", cq.getClwtWtqkMj());
            map.put("cqzgnum2", cq.getClwtWtzgNum());
            map.put("cqzgmj2", cq.getClwtWtzgMj());
            map.put("cqzgpercent2", cq.getClwtWtzgPercent());
            map.put("percent", cq.getPercent());
            TemplateExportParams params = new TemplateExportParams(srcFileName, new Integer[0]);
            params.setColForEach(true);
            Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, map);
            workbook.write((OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return ouputPath;
    }

    public void downloadGcpjAndYjtxBbExcel(HttpServletResponse response, String year, String type) throws Exception {
        List<StaticFxyjYjbb> result = this.getGcpjAndYjtxBb(year, type);
        if ("2".equals(type)) {
            this.downloadGcpjAndYjtx(response, result, "\u4e94\u8272\u56fe\u9884\u8b66\u63d0\u9192\u62a5\u8868");
        } else {
            for (StaticFxyjYjbb staticFxyjYjbb : result) {
                staticFxyjYjbb.setFYj(YjStateEnum.getByCode((String)staticFxyjYjbb.getFYj()).getDesc());
                staticFxyjYjbb.setFZddxyj(YjStateEnum.getByCode((String)staticFxyjYjbb.getFZddxyj()).getDesc());
                staticFxyjYjbb.setFFnhyj(YjStateEnum.getByCode((String)staticFxyjYjbb.getFFnhyj()).getDesc());
                staticFxyjYjbb.setFYjjbntflhyj(YjStateEnum.getByCode((String)staticFxyjYjbb.getFYjjbntflhyj()).getDesc());
            }
            this.downloadGcpjAndYjtx(response, result, "\u4e94\u8272\u56fe\u8fc7\u7a0b\u8bc4\u4ef7\u62a5\u8868");
        }
    }

    public <T> String downloadGcpjAndYjtx(HttpServletResponse response, List<T> staticFxyjYjbbList, String fileName) throws Exception {
        ClassPathResource wst = new ClassPathResource("/static/excel/" + fileName + ".xlsx");
        File wstFile = File.createTempFile("template_STSONG_copy", ".xlsx");
        FileUtils.copyInputStreamToFile((InputStream)wst.getInputStream(), (File)wstFile);
        String srcFileName = wstFile.getAbsolutePath();
        String ouputPath = this.uploadDir + File.separator + "excel" + File.separator + (fileName + System.currentTimeMillis() + ".xlsx");
        try {
            response.setContentType("application/vnd.ms-excel");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String excelfileName = URLEncoder.encode(fileName + System.currentTimeMillis(), "utf-8");
            response.setHeader("Content-disposition", "attachment;fileName=" + excelfileName + ".xls");
            ServletOutputStream out = response.getOutputStream();
            HashMap<String, List<T>> map = new HashMap<String, List<T>>();
            map.put("list", staticFxyjYjbbList);
            TemplateExportParams params = new TemplateExportParams(srcFileName, new Integer[0]);
            Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, map);
            workbook.write((OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return ouputPath;
    }
}

