/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.suishoupai.impl;

import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.repository.base.AppBasicRepository;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.servface.base.AppBasicService;
import com.geoway.landteam.landcloud.servface.base.dto.AppBasicSimpleInfo;
import com.geoway.landteam.landcloud.servface.suishoupai.JctbService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JctbServiceImpl
implements JctbService {
    @Resource
    AppBasicService appBasicService;
    @Resource
    Organization2UserRepository organization2UserDao;
    @Autowired
    AppBasicRepository appBasicDao;

    public Page<AppBasic> getMyDeletedList(String userIds, String page, String rows, String filterParam, String sortParam) {
        Page basics;
        int start = Integer.valueOf(page) - 1;
        int limit = Integer.valueOf(rows);
        if (StringUtils.isEmpty((CharSequence)filterParam)) {
            filterParam = "";
        }
        if (StringUtils.isEmpty((CharSequence)sortParam)) {
            sortParam = "SORT_deleteTime_DESC";
        }
        if ((basics = this.appBasicService.getPageByFilter(filterParam = filterParam + ";Q_isDeleted_N_EQ=1;Q_userid_S_IN=" + userIds, sortParam, start, Integer.valueOf(limit))) != null) {
            for (AppBasic basic : basics) {
                String gid = basic.getId();
                basic.setCurMedia(this.appBasicService.getFirstPhont(gid));
            }
        }
        return basics;
    }

    @Transactional(rollbackFor={Exception.class})
    public int cleanRecycleBin(String userId) throws Exception {
        String sortParam = "SORT_deleteTime_DESC";
        String filterParam = "Q_isDeleted_N_EQ=1;Q_userid_S_IN=" + userId;
        Page basics = this.appBasicService.getPageByFilter(filterParam, sortParam, 0, Integer.valueOf(1000));
        int count = 0;
        if (basics != null) {
            for (AppBasic appBasic : basics) {
                this.appBasicService.shiftDeleteByIds(appBasic.getId());
                ++count;
            }
        }
        return count;
    }

    public Page<AppBasic> getWorkGroupAppBasics(Long userId, String workGroupId, int start, int limit) throws Exception {
        String sortParam = "SORT_createtime_DESC";
        String filterParam = "Q_isDeleted_N_EQ=0;Q_userid_S_EQ=" + workGroupId;
        return this.appBasicService.getPageByFilter(filterParam, sortParam, start, Integer.valueOf(limit));
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteInWorkGroup(Long userId, String workGroupId, String ids) throws Exception {
        this.checkWorkGroupAdmin(userId, workGroupId);
        return this.appBasicService.deleteByIds(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public int recoverInWorkGroup(Long userId, String workGroupId, String ids) throws Exception {
        return this.appBasicService.recoverByIds(ids);
    }

    public int shiftDeleteInWorkGroup(Long userId, String workGroupId, String ids) throws Exception {
        this.checkWorkGroupAdmin(userId, workGroupId);
        return this.appBasicService.shiftDeleteByIds(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public int cleanWorkGroupRecycleBin(Long userId) throws Exception {
        throw new RuntimeException("\u8be5\u65b9\u6cd5\u4e0d\u505a\u5b9e\u73b0 \uff0c\u5e94\u4f7f\u7528cleanWorkGroupRecycleBin(List<String> groupsList)  \u65b9\u6cd5");
    }

    @Transactional(rollbackFor={Exception.class})
    public int cleanWorkGroupRecycleBin(List<String> groupsList) throws Exception {
        String groupsIds = StringUtils.join(groupsList, (CharSequence)",");
        return this.cleanRecycleBin(groupsIds);
    }

    public Page<AppBasic> getWorkGroupDeletedList(Long userId, String page, String rows, String filterParam, String sortParam, String workGroupIds) throws Exception {
        return this.getMyDeletedList(workGroupIds, page, rows, filterParam, sortParam);
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteInOrganization(Long userId, String ids) throws Exception {
        this.checkIdsBelongOrg(userId, ids);
        this.checkLiaison(userId);
        return this.appBasicService.deleteByIds(ids);
    }

    public Page<AppBasic> getOrgDeletedList(Long userId, int start, int limit, String filterParam, String sortParam, String organizationId) {
        this.checkLiaison(userId);
        organizationId = this.completeOrgId(userId, organizationId);
        filterParam = filterParam + "Q_isDeleted_N_EQ=1;Q_userid_S_EQ=" + organizationId;
        Page appBasics = this.appBasicService.getPageByFilter(filterParam, sortParam, start, Integer.valueOf(limit));
        for (AppBasic appBasic : appBasics) {
            appBasic.setCurMedia(this.appBasicService.getFirstPhont(appBasic.getId()));
        }
        return appBasics;
    }

    public int recoverInOrg(Long userId, String ids) throws Exception {
        this.checkIdsBelongOrg(userId, ids);
        this.checkLiaison(userId);
        return this.appBasicService.recoverByIds(ids);
    }

    protected void checkWorkGroupAdmin(Long userId, String workGroupId) throws Exception {
    }

    protected void checkWorkGroupsAdmin(Long userId, String workGroupIds) throws Exception {
        String[] workGroups = workGroupIds.split(",");
        for (int i = 0; i < workGroups.length; ++i) {
            this.checkWorkGroupAdmin(userId, workGroups[i]);
        }
    }

    protected void checkIdsBelongOrg(Long userId, String ids) throws Exception {
        String[] idArr;
        List list = this.organization2UserDao.queryByUserId(userId);
        if (list.isEmpty()) {
            throw new RuntimeException("\u65e0\u5355\u4f4d");
        }
        String organizationId = ((Organization2User)list.get(0)).getOrganizationId();
        for (String id : idArr = ids.split(",")) {
            AppBasic appBasic = this.appBasicDao.findById((Object)id).orElse(null);
            if (appBasic != null && organizationId.equals(appBasic.getUserid())) continue;
            throw new RuntimeException("\u968f\u624b\u62cdid\u6709\u8bef");
        }
    }

    public int cleanOrgRecycleBin(Long userId, String organizationId) throws Exception {
        this.checkLiaison(userId);
        organizationId = this.completeOrgId(userId, organizationId);
        return this.cleanRecycleBin(organizationId);
    }

    public int recoverAllInOrg(Long userId, String organizationId) {
        this.checkLiaison(userId);
        organizationId = this.completeOrgId(userId, organizationId);
        return this.appBasicDao.recoverAllInOrg(organizationId);
    }

    public int recoverAllInGroup(Long userId) {
        throw new RuntimeException("\u65b9\u6cd5\u6682\u65f6\u672a\u505a\u5b9e\u73b0");
    }

    private String completeOrgId(Long userId, String organizationId) {
        if (StringUtils.isBlank((CharSequence)organizationId)) {
            List list = this.organization2UserDao.queryByUserId(userId);
            if (list.isEmpty()) {
                throw new RuntimeException("\u7528\u6237\u65e0\u5355\u4f4d");
            }
            return ((Organization2User)list.get(0)).getOrganizationId();
        }
        return organizationId;
    }

    private void checkLiaison(Long userId) {
    }

    public void updateAppBasic(AppBasicSimpleInfo appBasicSimpleInfo) {
        String appBasicId = appBasicSimpleInfo.getId();
        if (StringUtils.isBlank((CharSequence)appBasicId)) {
            throw new RuntimeException("\u968f\u624b\u62cdid\u6709\u8bef");
        }
        AppBasic appBasic = this.appBasicDao.findById((Object)appBasicId).orElse(null);
        BeanUtil.copyProperties((Object)appBasicSimpleInfo, (Object)appBasic, (String[])BeanUtil.getNullPropertyNames((Object)appBasicSimpleInfo));
        appBasic.setTime(new Date());
        this.appBasicDao.save((Object)appBasic);
    }
}

