/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.sync;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.repository.user.UserAreaRepository;
import com.geoway.landteam.landcloud.model.giht.entity.TbGjhtAssign;
import com.geoway.landteam.landcloud.model.giht.entity.TbGjhtThInfo;
import com.geoway.landteam.landcloud.repository.gjht.TbGjhtAssignRepository;
import com.geoway.landteam.landcloud.repository.gjht.TbGjhtThInfoRepository;
import com.geoway.landteam.landcloud.service.customtask.task.GjhtAssignService;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class SynchroService {
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Resource
    DataBizService dataBizService;
    @Autowired
    RedisTemplate redisTemplate;
    @Resource
    TbtskObjectinfoService tbtskObjectinfoService;
    @Resource
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    UserAreaRepository userAreaDao;
    @Resource
    GjhtAssignService gjhtAssignService;
    @Autowired
    TbGjhtAssignRepository tbGjhtAssignRepository;
    @Autowired
    TbGjhtThInfoRepository tbGjhtThInfoRepository;
    @Value(value="${project.uploadDir}")
    String uploadDir;
    @Value(value="${gjck.url}")
    protected String gjckUrl;
    @Value(value="${gjck.key}")
    protected String gjckKey;
    @Value(value="${gjck.secret}")
    protected String gjckSecret;

    public void getDataSynchro() {
    }

    public String getToken() throws Exception {
        String token = "";
        try {
            String accessToken;
            if (this.redisTemplate.opsForValue().get((Object)"sync_token") != null) {
                token = this.redisTemplate.opsForValue().get((Object)"sync_token").toString();
                return token;
            }
            String url = this.gjckUrl + "/mdc/v1/auth/tokenByKey";
            JSONObject result = new JSONObject();
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost httpPost = new HttpPost();
            httpPost.setURI(URI.create(url));
            httpPost.setHeader("Content-Type", "application/json");
            JSONObject param = new JSONObject();
            param.put("appKey", (Object)this.gjckKey);
            param.put("appSecret", (Object)this.gjckSecret);
            httpPost.setEntity((HttpEntity)new StringEntity(JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "UTF-8"));
            org.apache.http.HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            String httpEntityContent = SynchroService.getHttpEntityContent(response);
            result = JSONObject.parseObject((String)httpEntityContent);
            if (!result.containsKey((Object)"status") || !"true".equalsIgnoreCase(result.getString("status"))) {
                System.out.println("\u83b7\u53d6token\u51fa\u9519\uff1a" + result.getString("msg"));
                throw new Exception("\u83b7\u53d6token\u51fa\u9519\uff1a" + result.getString("msg"));
            }
            JSONObject resData = result.getJSONObject("data");
            token = accessToken = resData.getString("accessToken");
            this.redisTemplate.opsForValue().set((Object)"sync_token", (Object)accessToken, 50L, TimeUnit.MINUTES);
        }
        catch (Exception ex) {
            System.out.println("\u83b7\u53d6token\u51fa\u9519\uff1a" + ex.getMessage());
            throw new Exception("\u83b7\u53d6token\u51fa\u9519:" + ex.getMessage());
        }
        return token;
    }

    public static String getHttpEntityContent(org.apache.http.HttpResponse response) throws Exception {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream is = entity.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String line = br.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line + "\n");
                line = br.readLine();
            }
            br.close();
            is.close();
            return sb.toString();
        }
        return "";
    }

    private void queryDatasByXzqdm(String token, String bizId, String version, String tableName, List<TbtskFields> allFields, Integer pageNum, String newVersion) {
        block9: {
            try {
                RestTemplate restTemplate = new RestTemplate();
                String url = this.gjckUrl + "/mdc/taskData/queryDataByRegion";
                JSONObject result = new JSONObject();
                CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                HttpPost httpPost = new HttpPost();
                httpPost.setURI(URI.create(url));
                httpPost.setHeader("sysToken", token);
                httpPost.setHeader("Content-Type", "application/json");
                JSONObject param = new JSONObject();
                param.put("bizId", (Object)bizId);
                param.put("xzqdm", (Object)"220000");
                param.put("pageNum", (Object)pageNum);
                param.put("pageSize", (Object)"50");
                param.put("version", (Object)version);
                httpPost.setEntity((HttpEntity)new StringEntity(JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "UTF-8"));
                org.apache.http.HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                String httpEntityContent = SynchroService.getHttpEntityContent(response);
                result = JSONObject.parseObject((String)httpEntityContent);
                if (result.containsKey((Object)"status") && "true".equalsIgnoreCase(result.getString("status"))) {
                    if (pageNum == 1) {
                        newVersion = String.valueOf(System.currentTimeMillis());
                    }
                    JSONObject resData = result.getJSONObject("data");
                    JSONArray fields = resData.getJSONArray("head");
                    JSONArray insertDatas = resData.getJSONArray("body");
                    Integer totalNum = resData.getInteger("total");
                    for (int i = 0; i < insertDatas.size(); ++i) {
                        JSONArray items = insertDatas.getJSONArray(i);
                        HashMap<String, Object> insertItem = new HashMap<String, Object>();
                        for (int j = 0; j < fields.size(); ++j) {
                            String fieldName = fields.getJSONObject(j).getString("code");
                            boolean hasIt = false;
                            for (TbtskFields allField : allFields) {
                                if (!allField.getfFieldname().equalsIgnoreCase(fieldName)) continue;
                                hasIt = true;
                                break;
                            }
                            if (!hasIt) continue;
                            insertItem.put(fieldName, items.get(j));
                        }
                        String whereSql = " f_id='" + insertItem.get("f_id").toString() + "' ";
                        if (this.dataBizService.getCount(tableName, whereSql) != 0) continue;
                        this.dataBizService.insertData(tableName, insertItem, "f_shape");
                    }
                    if (insertDatas.size() > 0 && totalNum > pageNum * 50) {
                        Integer n = pageNum;
                        Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
                        this.queryDatasByXzqdm(token, bizId, version, tableName, allFields, pageNum, newVersion);
                    } else {
                        this.redisTemplate.opsForValue().set((Object)bizId, (Object)newVersion);
                    }
                    break block9;
                }
                throw new Exception("\u62c9\u53d6\u56fd\u5bb6\u6570\u636e\u51fa\u9519\uff1a" + result.getString("msg"));
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    public void analysisTask(String assignUrl) throws Exception {
        HttpURLConnection httpURLConnection = null;
        TbGjhtAssign assign = this.tbGjhtAssignRepository.findLastUrl(assignUrl);
        if (assign.getSfcl() != null && assign.getSfcl() == 1) {
            System.out.println("\u5f53\u524d\u8bb0\u5f55\u6700\u65b0\u5185\u5bb9\u5df2\u5b8c\u6210\u89e3\u6790\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c\uff01");
            return;
        }
        String xfUrl = assign.getUrl();
        String zipPsw = assign.getZip_pwd();
        URL url = new URL(xfUrl);
        URLConnection urlConnection = url.openConnection();
        httpURLConnection = (HttpURLConnection)urlConnection;
        httpURLConnection.setConnectTimeout(600000);
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setRequestProperty("Charset", "UTF-8");
        httpURLConnection.connect();
        File zipFile = null;
        File dir = new File(this.uploadDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        zipFile = File.createTempFile("tmp", ".zip", dir);
        FileUtils.copyInputStreamToFile((InputStream)httpURLConnection.getInputStream(), (File)zipFile);
        String zipName = zipFile.getAbsolutePath();
        String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
        Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)zipPsw);
        String sql = "select * from tb_gjht_fieldmapping";
        List fieldMappings = this.jdbcTemplate.queryForList(sql);
        Integer num = this.analysisWpdb(unzipFileDir, fieldMappings, assign);
        assign.setSfcl(Integer.valueOf(1));
        assign.setClsj(new Date());
        String errmsg = "";
        Integer gjjg = 0;
        try {
            if (StringUtils.isBlank((CharSequence)this.gjhtAssignService.getKeyPublic()) || StringUtils.isBlank((CharSequence)this.gjhtAssignService.getKeyPrivate()) || StringUtils.isBlank((CharSequence)this.gjhtAssignService.getGtUrl())) {
                System.out.println("\u6ca1\u6709\u516c\u94a5\u6216\u6ca1\u6709\u79c1\u94a5\u6216\u6ca1\u6709\u670d\u52a1\u5730\u5740\u914d\u7f6e\u4fe1\u606f\uff01");
                return;
            }
            SM2 sm2 = new SM2(this.gjhtAssignService.getKeyPrivate(), this.gjhtAssignService.getKeyPublic());
            sm2.usePlainEncoding();
            byte[] sm4Key = SecureUtil.generateKey((String)"SM4").getEncoded();
            String token = this.gjhtAssignService.getToken(sm2);
            if (StringUtils.isBlank((CharSequence)token)) {
                return;
            }
            String secret = this.gjhtAssignService.getSecret(sm2, sm4Key);
            if (StringUtils.isBlank((CharSequence)secret)) {
                return;
            }
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("x-lc-secret", secret);
            headerMap.put("x-lc-token", token);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            StringBuilder dataBuilder = new StringBuilder();
            dataBuilder.append("\"code\"").append(":").append("\"" + assign.getCode() + "\"");
            dataBuilder.append("\"regioncode\"").append(":").append("\"" + assign.getXzqdm() + "\"");
            dataBuilder.append("\"hash\"").append(":").append("\"" + assign.getMd5() + "\"");
            dataBuilder.append("\"count\"").append(":").append("\"" + num + "\"");
            dataBuilder.append("\"entrytime\"").append(":").append("\"" + df.format(new Date()) + "\"");
            dataBuilder.append("\"status\"").append(":").append("1");
            dataBuilder.append("\"message\"").append(":").append("\u5165\u5e93\u6210\u529f");
            String dataEncrypt = this.gjhtAssignService.getEncrypt(dataBuilder.toString(), sm4Key);
            HttpResponse httpResponse = ((HttpRequest)HttpUtil.createPost((String)(this.gjhtAssignService.getGtUrl() + "/DataExchange/feedback")).addHeaders(headerMap)).body("{" + dataEncrypt + "}").execute();
            if (ObjectUtils.isEmpty((Object)httpResponse)) {
                return;
            }
            String result = httpResponse.body();
            String xLcSecret = httpResponse.header("x-lc-secret");
            JSONObject resultJsonObject = JSONObject.parseObject((String)result);
            String rssultSecretData = "";
            if (ObjectUtils.isNotEmpty((Object)resultJsonObject) && ObjectUtils.isNotEmpty((Object)resultJsonObject.get((Object)"code")) && resultJsonObject.get((Object)"code").toString().equals("200") && ObjectUtils.isNotEmpty((Object)resultJsonObject.get((Object)"data"))) {
                rssultSecretData = resultJsonObject.get((Object)"data").toString();
            }
            if (StringUtils.isNotBlank((CharSequence)xLcSecret) && StringUtils.isNotBlank((CharSequence)rssultSecretData)) {
                String data = this.gjhtAssignService.getDecrypt(sm2, rssultSecretData, xLcSecret);
                if (StringUtils.isNotBlank((CharSequence)xLcSecret)) {
                    resultJsonObject.put("data", (Object)("{" + data + "}"));
                }
                System.out.println("data = " + data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        assign.setGjjg(gjjg);
        assign.setGjmsg(errmsg);
        assign.setGjsj(new Date());
        assign.setClgs(num);
        this.tbGjhtAssignRepository.save((Object)assign);
    }

    public Integer analysisWpdb(String filePath, List<Map<String, Object>> fieldMappings, TbGjhtAssign assign) throws Exception {
        URL url = null;
        File file = null;
        file = new File(filePath);
        File[] content = file.listFiles();
        int ln = content.length;
        for (int j = 0; j < ln; ++j) {
            if (!content[j].getName().endsWith(".db")) continue;
            url = content[j].toURI().toURL();
            break;
        }
        SqlliteConnTool connPool = new SqlliteConnTool(url.toString());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = null;
        String sql = "select * from wpzftb";
        rs = statement.executeQuery(sql);
        String inserTableName = "";
        Integer num = 0;
        ArrayList<String> tbbsms = new ArrayList<String>();
        while (rs.next()) {
            Object glField;
            Object fieldName;
            HashMap<String, Object> inserMap = new HashMap<String, Object>();
            String xzqdmVal = "";
            for (Map<String, Object> fieldMapping : fieldMappings) {
                Object valObj;
                String glFieldName;
                String fieldType;
                block42: {
                    fieldName = fieldMapping.get("f_fieldname").toString();
                    glField = fieldMapping.get("f_glfieldname");
                    fieldType = fieldMapping.get("f_fieldtype").toString();
                    glFieldName = "";
                    if (glField == null) {
                        String glfieldid = fieldMapping.get("f_glfieldid").toString();
                        TbtskFields curField = (TbtskFields)this.tbtskFieldsRepository.getOne((Object)glfieldid);
                        glFieldName = curField.getfFieldname();
                        if (StringUtils.isBlank((CharSequence)inserTableName)) {
                            inserTableName = curField.getfTablename();
                        }
                    } else {
                        glFieldName = glField.toString();
                    }
                    valObj = null;
                    try {
                        valObj = rs.getObject((String)fieldName);
                        if (!((String)fieldName).equalsIgnoreCase("tbbsm") || tbbsms.indexOf(valObj.toString()) >= 0) break block42;
                        tbbsms.add(valObj.toString());
                    }
                    catch (Exception ex) {
                        continue;
                    }
                }
                if (valObj == null) continue;
                if (fieldType.equalsIgnoreCase("1") || fieldType.equalsIgnoreCase("2")) {
                    inserMap.put(glFieldName, valObj.toString());
                } else if (fieldType.equalsIgnoreCase("3") || fieldType.equalsIgnoreCase("7")) {
                    inserMap.put(glFieldName, Double.valueOf(valObj.toString()));
                } else if (fieldType.equalsIgnoreCase("9")) {
                    inserMap.put(glFieldName, valObj.toString());
                } else if (fieldType.equalsIgnoreCase("8")) {
                    inserMap.put(glFieldName, Integer.valueOf(valObj.toString()));
                }
                if (!StringUtils.isBlank((CharSequence)xzqdmVal) || ((String)fieldName).indexOf("xzqdm") <= -1) continue;
                xzqdmVal = valObj.toString();
            }
            if (inserMap.containsKey("f_shape") && inserMap.get("f_shape") != null && !inserMap.get("f_shape").toString().contains("SRID=4490")) {
                inserMap.put("f_shape", "SRID=4490;" + inserMap.get("f_shape"));
            }
            if (!inserMap.containsKey("f_createtime") || inserMap.get("f_createtime") != null) {
                Date date = new Date();
                inserMap.put("f_createtime", date.getTime());
            }
            String tbbsm = inserMap.get("f_tbbh").toString();
            List items = this.dataBizService.queryDataBySql("select f_id from " + inserTableName + " where f_id='" + tbbsm + "'");
            inserMap.put("f_id", tbbsm);
            if (xzqdmVal.length() == 6) {
                xzqdmVal = xzqdmVal + "000000";
            } else if (xzqdmVal.length() == 9) {
                xzqdmVal = xzqdmVal + "000";
            }
            inserMap.put("f_xzqdmsys", xzqdmVal);
            inserMap.put("f_xzqdm", xzqdmVal.substring(0, 6));
            if (items.size() == 0) {
                inserMap.put("f_status", 1);
                this.dataBizService.insertData(inserTableName, inserMap, "f_shape");
            } else {
                this.dataBizService.updateData(inserTableName, inserMap, " f_id='" + tbbsm + "'");
            }
            fieldName = num;
            num = num + 1;
            glField = num;
            System.out.println("\u5f53\u524d\u5305" + assign.getUrl() + ",\u4e0b\u53d1\u65f6\u95f4" + assign.getXfsj() + ",\u5171" + assign.getNum() + "\u6761\u6570\u636e\uff0c\u5df2\u5904\u7406" + num + "\u6761");
        }
        boolean djbExist = SqlliteConnTool.isTableExists((Statement)statement, (String)"wpzftb_thpwinfo");
        if (djbExist) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sql = "select * from wpzftb_thpwinfo";
            rs = statement.executeQuery(sql);
            while (rs.next()) {
                String sign = "";
                if (rs.getObject("sign") != null) {
                    sign = rs.getString("sign");
                }
                String tbbsm = "";
                if (rs.getObject("tbbsm") != null) {
                    tbbsm = rs.getString("tbbsm");
                }
                String jcbh = "";
                if (rs.getObject("jcbh") != null) {
                    jcbh = rs.getString("jcbh");
                }
                TbGjhtThInfo tbInfo = new TbGjhtThInfo();
                List items = this.tbGjhtThInfoRepository.queryByParams(tbbsm, jcbh, sign);
                if (items.size() > 0) {
                    tbInfo = (TbGjhtThInfo)items.get(0);
                } else {
                    tbInfo.setId(UUID.randomUUID().toString());
                    tbInfo.setTbbsm(tbbsm);
                    tbInfo.setJcbh(jcbh);
                }
                if (rs.getObject("tbbsm") != null) {
                    tbInfo.setTbbsm(rs.getString("tbbsm"));
                }
                if (rs.getObject("jcbh") != null) {
                    tbInfo.setJcbh(rs.getString("jcbh"));
                }
                if (rs.getObject("pzwh") != null) {
                    tbInfo.setPzwh(rs.getString("pzwh"));
                }
                if (rs.getObject("pzsj") != null) {
                    String pzsjStr = rs.getString("pzsj");
                    tbInfo.setPzsj(df.parse(pzsjStr));
                }
                if (rs.getObject("pzmj") != null) {
                    tbInfo.setPzmj(Double.valueOf(rs.getDouble("pzmj")));
                }
                if (rs.getObject("pznydmj") != null) {
                    tbInfo.setPznydmj(Double.valueOf(rs.getDouble("pznydmj")));
                }
                if (rs.getObject("pzgdmj") != null) {
                    tbInfo.setPzgdmj(Double.valueOf(rs.getDouble("pzgdmj")));
                }
                if (rs.getObject("pzyjjbntmj") != null) {
                    tbInfo.setPzyjjbntmj(Double.valueOf(rs.getDouble("pzyjjbntmj")));
                }
                if (rs.getObject("pwlx") != null) {
                    tbInfo.setPwejlx(rs.getString("pwlx"));
                }
                if (rs.getObject("pwejlx") != null) {
                    tbInfo.setPwejlx(rs.getString("pwejlx"));
                }
                if (rs.getObject("xmmc") != null) {
                    tbInfo.setXmmc(rs.getString("xmmc"));
                }
                if (rs.getObject("pzjsydmj") != null) {
                    tbInfo.setPzjsydmj(Double.valueOf(rs.getDouble("pzjsydmj")));
                }
                if (rs.getObject("pzwlymj") != null) {
                    tbInfo.setPzwlymj(Double.valueOf(rs.getDouble("pzwlymj")));
                }
                tbInfo.setSign(sign);
                this.tbGjhtThInfoRepository.save((Object)tbInfo);
            }
        }
        connPool.closeAll(connection, statement, rs);
        return num;
    }
}

