/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.NjWwInteractionHandle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.csvreader.CsvReader;
import com.geoway.landteam.customtask.repository.task.BizAreaRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.constants.UpResultEnum;
import com.geoway.landteam.customtask.task.constants.UpResultErrorEnum;
import com.geoway.landteam.customtask.task.entity.BizArea;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.model.sysinteraction.entity.TbSysInteractionFieldMap;
import com.geoway.landteam.landcloud.model.sysinteraction.entity.TbSysInteractionRecord;
import com.geoway.landteam.landcloud.model.sysinteraction.entity.TbSysinteractionWwAnalyseMap;
import com.geoway.landteam.landcloud.repository.sysinteraction.SysInteractionFieldMapRepository;
import com.geoway.landteam.landcloud.repository.sysinteraction.SysInteractionRecordRepository;
import com.geoway.landteam.landcloud.repository.sysinteraction.SysInteractionWwAnalyseMapRepository;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionFactory.InteractionReceiveInterface;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.geotools.geometry.jts.WKBReader;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class NjWwInteractionReceive
implements InteractionReceiveInterface {
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    TbtskFieldsService tbtskFieldsService;
    @Autowired
    SysInteractionFieldMapRepository sysInteractionFieldMapRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    BizAreaRepository bizAreaRepository;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    SysInteractionRecordRepository sysInteractionRecordRepository;
    @Autowired
    SysInteractionWwAnalyseMapRepository sysInteractionWwAnalyseMapRepository;
    @Autowired
    RegionService regionService;
    private Boolean isAuthentication = false;
    public int allline = 0;
    public int maxSql = 150;
    public int updateLine = 0;
    public int addLine = 0;

    @Override
    public Boolean authentication() throws Exception {
        return this.isAuthentication;
    }

    @Override
    public Boolean handleReceiveData(Object object, String taskCode) throws Exception {
        if (taskCode.equals("wwTaskHandleDataReceive")) {
            TbSysInteractionRecord tbSysInteractionRecord = (TbSysInteractionRecord)object;
            return this.handleWwDataReceiveTask(tbSysInteractionRecord);
        }
        return false;
    }

    public boolean handleWwDataReceiveTask(TbSysInteractionRecord tbSysInteractionRecord) throws Exception {
        this.allline = 0;
        this.updateLine = 0;
        this.addLine = 0;
        TskTaskBiz tbtskTaskBiz = this.tskTaskBizService.findByTaskId(tbSysInteractionRecord.getTaskid());
        TbtskObjectinfo tbtskObjectinfo = this.tbtskObjectinfoService.getObjectbyID(tbtskTaskBiz.getTableId());
        String tableName = tbtskObjectinfo.getfTablename();
        List fields = this.tbtskFieldsService.getAllFieldsByTableID(tbtskTaskBiz.getTableId());
        List tbSysInteractionFieldMaps = this.sysInteractionFieldMapRepository.getSysInteractionFieldMapByTaskCode(tbSysInteractionRecord.getTaskcode());
        Map<String, Object> effectField = this.getEffectField(fields, tbSysInteractionFieldMaps);
        List bizAreas = this.bizAreaRepository.findByBizId(tbtskTaskBiz.getId());
        Set<String> areaCodes = bizAreas.stream().map(BizArea::getArea).collect(Collectors.toSet());
        if (areaCodes.size() <= 0) {
            SysConfig xzqCode = this.sysConfigService.findOne("xzqCode");
            areaCodes.add(xzqCode.getValue());
        }
        JSONObject cJson = JSONObject.parseObject((String)tbSysInteractionRecord.getContent());
        CsvReader csvReader = new CsvReader(cJson.getString("\u6587\u4ef6\u5730\u5740"), ',', Charset.forName("UTF-8"));
        csvReader.readHeaders();
        String[] headers = csvReader.getHeaders();
        HashMap<String, Integer> hIndex = new HashMap<String, Integer>();
        for (int i = 0; i < headers.length; ++i) {
            hIndex.put(headers[i], i);
        }
        int cline = 0;
        HashMap<String, String[]> dataCache = new HashMap<String, String[]>();
        String tbids = "";
        while (csvReader.readRecord()) {
            ++this.allline;
            if (++cline < this.maxSql) {
                dataCache.put(csvReader.get("tbid"), csvReader.getValues());
                tbids = tbids + "'" + csvReader.get("tbid") + "',";
                continue;
            }
            tbids = tbids.substring(0, tbids.length() - 1);
            this.addOrUpdate(dataCache, tbids, tableName, hIndex, tbtskTaskBiz, tbtskObjectinfo, effectField, "101", fields, areaCodes);
            cline = 0;
            tbids = "";
            dataCache.clear();
            System.gc();
        }
        if (tbids.length() != 0) {
            tbids = tbids.substring(0, tbids.length() - 1);
        }
        if (dataCache.size() != 0) {
            this.addOrUpdate(dataCache, tbids, tableName, hIndex, tbtskTaskBiz, tbtskObjectinfo, effectField, "101", fields, areaCodes);
        }
        tbSysInteractionRecord.setStatus(1);
        cJson.put("\u603b\u56fe\u6591\u6570", (Object)this.allline);
        cJson.put("\u66f4\u65b0\u56fe\u6591", (Object)this.updateLine);
        cJson.put("\u6dfb\u52a0\u56fe\u6591", (Object)this.addLine);
        tbSysInteractionRecord.setContent(cJson.toString());
        tbSysInteractionRecord.setBackresult("\u5bfc\u5165\u6570\u636e\u6210\u529f\uff01\uff01");
        this.sysInteractionRecordRepository.save((Object)tbSysInteractionRecord);
        tbtskTaskBiz.setAllCount(Integer.valueOf(this.allline));
        this.tskTaskBizService.save(tbtskTaskBiz);
        return true;
    }

    public void addOrUpdate(Map<String, String[]> dataCache, String tbids, String tablename, Map<String, Integer> hIndex, TskTaskBiz tskTaskBiz, TbtskObjectinfo table, Map<String, Object> effectField, String userId, List<TbtskFields> allFields, Set<String> areaCodes) throws Exception {
        ArrayList<Map<String, Object>> addDataCacheList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> updateDataCacheList = new ArrayList<Map<String, Object>>();
        String filterSql = " SELECT array_to_string(array_agg(a.f_id),',') as existids FROM ( SELECT f_id , 1 AS group    FROM  " + tablename + "   WHERE  f_id in (" + tbids + ")   ) a GROUP BY a.group;";
        String existids = "";
        try {
            Map existidsMap = this.jdbcTemplate.queryForMap(filterSql);
            existids = existidsMap.get("existids").toString();
        }
        catch (Exception existidsMap) {
            // empty catch block
        }
        List wwAnalyseMapList = this.sysInteractionWwAnalyseMapRepository.getWwAnalyseFieldMapByTemplateid(tskTaskBiz.getTemplateId());
        HashMap<String, TbSysinteractionWwAnalyseMap> wwAnalyseMap = new HashMap<String, TbSysinteractionWwAnalyseMap>();
        wwAnalyseMapList.stream().forEach(obj -> wwAnalyseMap.put(obj.getSupertag(), (TbSysinteractionWwAnalyseMap)obj));
        for (String key : dataCache.keySet()) {
            if (existids.indexOf(key) != -1) {
                updateDataCacheList.add(this.getUpdateData(effectField, hIndex, table, allFields, dataCache.get(key), wwAnalyseMap));
                continue;
            }
            addDataCacheList.add(this.getInsertData(hIndex, tskTaskBiz, table, dataCache.get(key), effectField, userId, allFields, areaCodes, wwAnalyseMap));
        }
        if (addDataCacheList.size() != 0) {
            this.dataBizService.insertDatasBatch(tablename, addDataCacheList, "f_shape");
            this.addLine += addDataCacheList.size();
        }
        if (updateDataCacheList.size() != 0) {
            this.dataBizService.updateDataBatch(tablename, updateDataCacheList);
            this.updateLine += updateDataCacheList.size();
        }
    }

    public Map<String, Object> getEffectField(List<TbtskFields> fields, List<TbSysInteractionFieldMap> tbSysInteractionFieldMaps) {
        HashMap<String, Object> effectFields = new HashMap<String, Object>();
        for (int i = 0; i < tbSysInteractionFieldMaps.size(); ++i) {
            TbSysInteractionFieldMap cTbSysInteractionFieldMap = tbSysInteractionFieldMaps.get(i);
            if (cTbSysInteractionFieldMap.getMapfield() == null || cTbSysInteractionFieldMap.getMapfield() == "") continue;
            String[] cMapfield = cTbSysInteractionFieldMap.getMapfield().split(",");
            for (int j = 0; j < cMapfield.length; ++j) {
                int finalJ = j;
                if (!fields.stream().anyMatch(f -> f.getfFieldname().equals(cMapfield[finalJ]))) continue;
                effectFields.put(cMapfield[finalJ], cTbSysInteractionFieldMap);
            }
        }
        return effectFields;
    }

    public Map<String, Object> getUpdateData(Map<String, Object> effectField, Map<String, Integer> hIndex, TbtskObjectinfo table, List<TbtskFields> allFields, String[] rows, Map<String, TbSysinteractionWwAnalyseMap> wwAnalyseMap) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String fieldName = "";
        String fieldType = "";
        String alias = "";
        Map<String, String> tagMap = this.getTagListJosnMap(rows, hIndex, wwAnalyseMap);
        for (TbtskFields field : allFields) {
            fieldName = field.getfFieldname();
            fieldType = field.getfFieldtype();
            fieldType = TskTaskBizDBUtil.getDBType((String)fieldType);
            if (effectField.get(fieldName) != null) {
                TbSysInteractionFieldMap tbSysInteractionFieldMap = (TbSysInteractionFieldMap)effectField.get(fieldName);
                this.addDatatoMap(map, rows[hIndex.get(tbSysInteractionFieldMap.getField())], fieldType, fieldName, alias, field.getfNullable(), field.getfOrder(), null);
                continue;
            }
            if (tagMap.get(fieldName) == null) continue;
            this.addDatatoMap(map, tagMap.get(fieldName), fieldType, fieldName, alias, field.getfNullable(), field.getfOrder(), null);
        }
        return map;
    }

    public Map<String, Object> getInsertData(Map<String, Integer> hIndex, TskTaskBiz tskTaskBiz, TbtskObjectinfo table, String[] rows, Map<String, Object> effectField, String userId, List<TbtskFields> allFields, Set<String> areaCodes, Map<String, TbSysinteractionWwAnalyseMap> wwAnalyseMap) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> fieldDefault = new ArrayList<String>();
        String fieldName = "";
        String fieldType = "";
        String alias = "";
        Integer outWork = -1;
        StringBuilder stringBuilder = new StringBuilder();
        String ismy = "f_ismy";
        for (TbtskFields field : allFields) {
            if ("f_ismycreate".equals(field.getfFieldname())) {
                ismy = "f_ismycreate";
            }
            fieldName = field.getfFieldname();
            fieldType = field.getfFieldtype();
            String dValue = null;
            try {
                dValue = JSONObject.parseObject((String)field.getfDefaultvalue()).getString("value");
            }
            catch (Exception exception) {
                // empty catch block
            }
            fieldType = TskTaskBizDBUtil.getDBType((String)fieldType);
            alias = field.getfAlias();
            outWork = field.getfIsOutwork();
            if (fieldName.equals("f_lat") || fieldName.equals("f_lon") || fieldName.equals("f_lat_b") || fieldName.equals("f_lon_b") || fieldName.equals("f_lat_g") || fieldName.equals("f_lon_g") || fieldName.equals("f_shape1")) continue;
            if (table.getfTableversion() == 3 && field.getfDefaultvalue() != null && !"".equalsIgnoreCase(field.getfDefaultvalue())) {
                fieldDefault.add(fieldName);
            }
            map.put(fieldName, dValue);
            boolean isOut = (field.getfFieldInnerOuterSys() & 2) == 2;
            Map<String, String> tagMap = this.getTagListJosnMap(rows, hIndex, wwAnalyseMap);
            if (effectField.get(fieldName) != null) {
                TbSysInteractionFieldMap tbSysInteractionFieldMap = (TbSysInteractionFieldMap)effectField.get(fieldName);
                this.addDatatoMap(map, rows[hIndex.get(tbSysInteractionFieldMap.getField())], fieldType, fieldName, alias, isOut ? 1 : field.getfNullable(), field.getfOrder(), dValue);
                continue;
            }
            if (tagMap.get(fieldName) != null) {
                this.addDatatoMap(map, tagMap.get(fieldName), fieldType, fieldName, alias, field.getfNullable(), field.getfOrder(), null);
                continue;
            }
            this.addDatatoMap(map, null, fieldType, fieldName, alias, isOut ? 1 : field.getfNullable(), field.getfOrder(), dValue);
        }
        map.put("f_id", rows[hIndex.get("tbid")]);
        map.put("f_status", "1");
        map.put("f_createtime", System.currentTimeMillis() + "");
        map.put("f_userid", userId);
        map.put("f_shape", map.get("f_shape"));
        map.put(ismy, "0");
        if (map.containsKey("f_xzqdm") && StringUtils.isNotBlank((CharSequence)((String)map.get("f_xzqdm")))) {
            List sysFields;
            String xzqdm = (String)map.get("f_xzqdm");
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("xzqdm", xzqdm);
            String name = this.regionService.getName(xzqdm);
            if (StringUtils.isNotBlank((CharSequence)name)) {
                map.put("f_xzqmc1", name);
                if (map.containsKey("f_xzqmc") && StringUtils.isEmpty((CharSequence)((String)map.get("f_xzqmc")))) {
                    map.put("f_xzqmc", name);
                }
            }
            if ((sysFields = allFields.stream().filter(t -> "f_xzqdmsys".equalsIgnoreCase(t.getfFieldname())).collect(Collectors.toList())) != null && sysFields.size() > 0) {
                map.put("f_xzqdmsys", xzqdm + "000000");
            }
            return map;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("type", UpResultEnum.ERROR);
        result.put("error", UpResultErrorEnum.MISS_XZQDM_FIELD);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addDatatoMap(Map map, String value, String fieldType, String fieldName, String rname, Integer nullable, Integer order, String defaultValue) throws Exception {
        DecimalFormat format = new DecimalFormat("######0.0000000");
        switch (fieldType) {
            case "varchar": {
                String value1 = value;
                if (value1 == null || "null".equals(value1.toLowerCase()) || "".equals(value1)) {
                    if (order != null && nullable == 0) {
                        throw new Exception(rname + "\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    map.put(fieldName, StringUtils.isBlank((CharSequence)defaultValue) ? null : defaultValue);
                    return;
                }
                map.put(fieldName, value1);
                return;
            }
            case "decimal": {
                if ("f_lat".equals(fieldName) || "f_lon".equals(fieldName)) return;
                String tmp1 = value;
                if (tmp1 == null || "".equals(tmp1)) {
                    if (order != null && nullable == 0) {
                        throw new Exception(rname + "\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    map.put(fieldName, defaultValue);
                    return;
                }
                Double value2 = Double.valueOf(tmp1);
                map.put(fieldName, value2);
                return;
            }
            case "int4": {
                String tmp2 = value;
                if (tmp2 == null || "".equals(tmp2)) {
                    if (order != null && nullable == 0) {
                        throw new Exception(rname + "\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    map.put(fieldName, defaultValue);
                    return;
                }
                Integer value3 = Integer.valueOf(tmp2);
                map.put(fieldName, value3);
                return;
            }
            case "timestamp": {
                String tmp3 = value;
                if (tmp3 == null || "".equals(tmp3)) {
                    if (order != null && nullable == 0) {
                        throw new Exception(rname + "\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    map.put(fieldName, null);
                    return;
                }
                try {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    Date date = df.parse(tmp3);
                    Timestamp value5 = new Timestamp(date.getTime());
                    map.put(fieldName, value5);
                    return;
                }
                catch (ParseException e) {
                    DateTimeFormatter df = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                    LocalDateTime localDateTime = LocalDateTime.parse(tmp3, df);
                    Date date = Date.from(localDateTime.atZone(ZoneOffset.ofHours(8)).toInstant());
                    Timestamp value5 = new Timestamp(date.getTime());
                    map.put(fieldName, value5);
                }
                return;
            }
            case "text": {
                String value2 = value;
                if (value2 == null || "null".equals(value2.toLowerCase()) || "".equals(value2)) {
                    if (order != null && nullable == 0) {
                        throw new Exception(rname + "\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    map.put(fieldName, StringUtils.isBlank((CharSequence)defaultValue) ? null : defaultValue);
                    return;
                }
                map.put(fieldName, value2);
                return;
            }
            case "geometry": {
                if (value != null) {
                    WKBReader reader = new WKBReader();
                    Geometry geo = reader.read(WKBReader.hexToBytes((String)value));
                    if ("f_shape".equalsIgnoreCase(fieldName)) {
                        if (geo == null) return;
                        map.put(fieldName, WKTUtil.geomToWkt((Geometry)geo));
                        Point point = geo.getCentroid();
                        if (point != null) {
                            map.put("f_lat", format.format(point.getY()));
                            map.put("f_lon", format.format(point.getX()));
                            return;
                        }
                        map.put("f_lat", "0.0");
                        map.put("f_lon", "0.0");
                        return;
                    }
                    if (!"f_shape_g".equalsIgnoreCase(fieldName) && !"f_shape_b".equalsIgnoreCase(fieldName)) return;
                }
                map.put(fieldName, value);
                return;
            }
        }
    }

    public Map<String, String> getTagListJosnMap(String[] rows, Map<String, Integer> hIndex, Map<String, TbSysinteractionWwAnalyseMap> wwAnalyseMap) {
        String jsonStr = rows[hIndex.get("tagListJson")].replaceAll("\\|", ",");
        JSONArray jsonArray = JSONArray.parseArray((String)jsonStr, (Feature[])new Feature[0]);
        HashMap<String, String> tagMap = new HashMap<String, String>();
        if (jsonArray.size() != 0) {
            jsonArray.forEach(json -> {
                JSONObject jsonObj = JSONObject.parseObject((String)json.toString());
                TbSysinteractionWwAnalyseMap tbSysinteractionWwAnalyseMap = (TbSysinteractionWwAnalyseMap)wwAnalyseMap.get(jsonObj.getString("superTag"));
                if (tbSysinteractionWwAnalyseMap != null) {
                    if (jsonObj.getString("tagType").equals("0")) {
                        tagMap.put(tbSysinteractionWwAnalyseMap.getMapfield(), jsonObj.getString("areaTotal"));
                    } else {
                        tagMap.put(tbSysinteractionWwAnalyseMap.getMapfield(), jsonObj.getString("tag"));
                    }
                }
            });
        }
        return tagMap;
    }
}

