/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.sysinteraction;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.model.sysinteraction.entity.TbCompanyInteractionInfo;
import com.geoway.landteam.landcloud.model.sysinteraction.entity.TbSysInteractionRecord;
import com.geoway.landteam.landcloud.repository.sysinteraction.CompanyInteractionInfoRepository;
import com.geoway.landteam.landcloud.repository.sysinteraction.SysInteractionRecordRepository;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionFactory.AbstractSysInteractionFactory;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionFactory.InteractionSubmitInterface;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionProducer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class NjSysInteractionService {
    private String taskcode = "taskInfoCommit";
    @Autowired
    CompanyInteractionInfoRepository companyInteractionInfoRepository;
    @Autowired
    SysInteractionRecordRepository sysInteractionRecordRepository;
    @Autowired
    SysInteractionProducer sysInteractionProducer;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    private ExecutorService executor = Executors.newCachedThreadPool();

    public String sendTaskWithBack(final TskTaskBiz tskTaskBiz, final Boolean isCreate, final String businame, final String pm, final String mediaConfig) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                NjSysInteractionService.this.sendTaskInfo(tskTaskBiz, isCreate, businame, pm, mediaConfig);
            }
        });
        this.executor.execute(thread);
        return "\u5f00\u59cb\u63a8\u9001\u4fe1\u606f";
    }

    public void sendTaskInfo(TskTaskBiz tskTaskBiz, Boolean isCreate, String businame, String pm, String mediaConfig) {
        Map<String, String> sendData = this.getHandleData(tskTaskBiz, businame, mediaConfig);
        TbCompanyInteractionInfo tbCompanyInteractionInfo = pm.equals("0") ? this.companyInteractionInfoRepository.getByTaskCode(this.taskcode, "NJYG") : this.companyInteractionInfoRepository.getByTaskCode(this.taskcode, "NJWW");
        TbSysInteractionRecord tbSysInteractionRecord = new TbSysInteractionRecord();
        tbSysInteractionRecord.setCompanycode(tbCompanyInteractionInfo.getCompanycode());
        tbSysInteractionRecord.setCreatetime(new Date());
        tbSysInteractionRecord.setContent(JSONObject.toJSONString(sendData));
        tbSysInteractionRecord.setTaskid(tskTaskBiz.getId());
        tbSysInteractionRecord.setType(1);
        tbSysInteractionRecord.setTaskcode(tbCompanyInteractionInfo.getTaskcode());
        tbSysInteractionRecord = (TbSysInteractionRecord)this.sysInteractionRecordRepository.save((Object)tbSysInteractionRecord);
        try {
            AbstractSysInteractionFactory abstractSysInteractionFactory = this.sysInteractionProducer.getFactory(tbCompanyInteractionInfo.getCompanycode());
            InteractionSubmitInterface interactionSubmitInterface = abstractSysInteractionFactory.createInteractionSubmit();
            interactionSubmitInterface.getAuthentication();
            String response = interactionSubmitInterface.sendDataWithAuthentication(tbCompanyInteractionInfo.getSysurl(), "post", sendData);
            tbSysInteractionRecord.setStatus(1);
            tbSysInteractionRecord.setBackresult(response);
            tbSysInteractionRecord.setResponsetime(new Date());
            this.sysInteractionRecordRepository.save((Object)tbSysInteractionRecord);
        }
        catch (Exception e) {
            e.printStackTrace();
            tbSysInteractionRecord.setStatus(0);
            tbSysInteractionRecord.setBackresult(e.getMessage());
            tbSysInteractionRecord.setResponsetime(new Date());
            this.sysInteractionRecordRepository.save((Object)tbSysInteractionRecord);
        }
    }

    public Map<String, String> getHandleData(TskTaskBiz tskTaskBiz, String businame, String mediaConfig) {
        HashMap<String, String> data = new HashMap<String, String>();
        JSONObject config = JSONObject.parseObject((String)tskTaskBiz.getConfigArgs());
        JSONObject njConfig = config.getJSONObject("njConfig");
        data.put("taskid", tskTaskBiz.getId());
        data.put("taskname", tskTaskBiz.getName());
        SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        data.put("createtime", sdf3.format(tskTaskBiz.getCreateTime()));
        data.put("busicode", tskTaskBiz.getClassId().toString());
        String flowid = null;
        String flowname = null;
        if (mediaConfig != null && !mediaConfig.equals("")) {
            JSONObject json = JSONObject.parseObject((String)mediaConfig);
            flowid = json.getString("flowid");
            flowname = json.getString("flowname");
        }
        data.put("flowid", flowid);
        data.put("flowname", flowname);
        data.put("type", businame);
        data.put("jczq", njConfig.getString("jczq"));
        data.put("jcpc", njConfig.getString("jcpc"));
        data.put("qsxyxname", njConfig.getString("qsxyxname"));
        data.put("hsxyxname", njConfig.getString("hsxyxname"));
        data.put("year", njConfig.getString("year"));
        data.put("qsxyxid", njConfig.getString("qsxyxid"));
        data.put("hsxyxid", njConfig.getString("hsxyxid"));
        data.put("qsxyxImageDirectory", njConfig.getString("qsxyxImageDirectory"));
        data.put("hsxyxImageDirectory", njConfig.getString("hsxyxImageDirectory"));
        return data;
    }

    public void getYgImageList() {
        TbCompanyInteractionInfo tbCompanyInteractionInfo = this.companyInteractionInfoRepository.getByTaskCode("ygImageListReceive", "NJYG");
        TbSysInteractionRecord tbSysInteractionRecord = new TbSysInteractionRecord();
        tbSysInteractionRecord.setCompanycode(tbCompanyInteractionInfo.getCompanycode());
        tbSysInteractionRecord.setCreatetime(new Date());
        tbSysInteractionRecord.setType(1);
        tbSysInteractionRecord.setTaskcode(tbCompanyInteractionInfo.getTaskcode());
        tbSysInteractionRecord = (TbSysInteractionRecord)this.sysInteractionRecordRepository.save((Object)tbSysInteractionRecord);
        try {
            AbstractSysInteractionFactory abstractSysInteractionFactory = this.sysInteractionProducer.getFactory(tbCompanyInteractionInfo.getCompanycode());
            InteractionSubmitInterface interactionSubmitInterface = abstractSysInteractionFactory.createInteractionSubmit();
            interactionSubmitInterface.getAuthentication();
            String response = interactionSubmitInterface.sendDataWithAuthentication(tbCompanyInteractionInfo.getSysurl(), "get", null);
            tbSysInteractionRecord.setStatus(1);
            tbSysInteractionRecord.setBackresult(response);
            tbSysInteractionRecord.setResponsetime(new Date());
            this.sysInteractionRecordRepository.save((Object)tbSysInteractionRecord);
        }
        catch (Exception e) {
            tbSysInteractionRecord.setStatus(0);
            tbSysInteractionRecord.setBackresult(e.getMessage());
            tbSysInteractionRecord.setResponsetime(new Date());
            this.sysInteractionRecordRepository.save((Object)tbSysInteractionRecord);
        }
    }

    public void getYgFlowList() {
        TbCompanyInteractionInfo tbCompanyInteractionInfo = this.companyInteractionInfoRepository.getByTaskCode("ygFlowListReceive", "NJYG");
        TbSysInteractionRecord tbSysInteractionRecord = new TbSysInteractionRecord();
        tbSysInteractionRecord.setCompanycode(tbCompanyInteractionInfo.getCompanycode());
        tbSysInteractionRecord.setCreatetime(new Date());
        tbSysInteractionRecord.setType(1);
        tbSysInteractionRecord.setTaskcode(tbCompanyInteractionInfo.getTaskcode());
        tbSysInteractionRecord = (TbSysInteractionRecord)this.sysInteractionRecordRepository.save((Object)tbSysInteractionRecord);
        try {
            AbstractSysInteractionFactory abstractSysInteractionFactory = this.sysInteractionProducer.getFactory(tbCompanyInteractionInfo.getCompanycode());
            InteractionSubmitInterface interactionSubmitInterface = abstractSysInteractionFactory.createInteractionSubmit();
            interactionSubmitInterface.getAuthentication();
            String response = interactionSubmitInterface.sendDataWithAuthentication(tbCompanyInteractionInfo.getSysurl(), "get", null);
            tbSysInteractionRecord.setStatus(1);
            tbSysInteractionRecord.setBackresult(response);
            tbSysInteractionRecord.setResponsetime(new Date());
            this.sysInteractionRecordRepository.save((Object)tbSysInteractionRecord);
        }
        catch (Exception e) {
            tbSysInteractionRecord.setStatus(0);
            tbSysInteractionRecord.setBackresult(e.getMessage());
            tbSysInteractionRecord.setResponsetime(new Date());
            this.sysInteractionRecordRepository.save((Object)tbSysInteractionRecord);
        }
    }

    public String getYgFlowState(String processId) {
        TbCompanyInteractionInfo tbCompanyInteractionInfo = this.companyInteractionInfoRepository.getByTaskCode("ygFlowStateReceive", "NJYG");
        String response = null;
        try {
            AbstractSysInteractionFactory abstractSysInteractionFactory = this.sysInteractionProducer.getFactory(tbCompanyInteractionInfo.getCompanycode());
            InteractionSubmitInterface interactionSubmitInterface = abstractSysInteractionFactory.createInteractionSubmit();
            interactionSubmitInterface.getAuthentication();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("processId", processId);
            response = interactionSubmitInterface.sendDataWithAuthentication(tbCompanyInteractionInfo.getSysurl(), "get", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return response;
    }
}

