/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.sysinteraction;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.model.sysinteraction.entity.TbSysInteractionRecord;
import com.geoway.landteam.landcloud.repository.sysinteraction.SysInteractionRecordRepository;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionFactory.AbstractSysInteractionFactory;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionFactory.InteractionReceiveInterface;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionProducer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysInteractionReceiveService {
    @Value(value="${project.uploadDir}")
    protected String tempDir;
    @Autowired
    SysInteractionRecordRepository sysInteractionRecordRepository;
    @Autowired
    SysInteractionProducer sysInteractionProducer;

    public String uploadTemfile(MultipartFile file, String taskId) throws Exception {
        TbSysInteractionRecord tbSysInteractionRecord = new TbSysInteractionRecord();
        tbSysInteractionRecord.setTaskcode("wwTaskHandleDataReceive");
        tbSysInteractionRecord.setCreatetime(new Date());
        tbSysInteractionRecord.setCompanycode("NJWW");
        tbSysInteractionRecord.setType(2);
        tbSysInteractionRecord.setTaskid(taskId);
        this.sysInteractionRecordRepository.save((Object)tbSysInteractionRecord);
        try {
            Map<String, String> newFileInfo = this.uploadToLocal(file);
            JSONObject content = new JSONObject();
            content.put("\u6587\u4ef6\u540d", (Object)newFileInfo.get("filename"));
            content.put("\u6587\u4ef6\u5730\u5740", (Object)newFileInfo.get("newFileUrl"));
            content.put("\u6587\u4ef6\u5927\u5c0f", (Object)newFileInfo.get("filesize"));
            tbSysInteractionRecord.setContent(content.toString());
            tbSysInteractionRecord.setStatus(1);
            tbSysInteractionRecord.setBackresult("\u4e0a\u4f20\u6587\u4ef6\u6210\u529f,\u6b63\u5728\u89e3\u6790...");
            this.sysInteractionRecordRepository.save((Object)tbSysInteractionRecord);
            AbstractSysInteractionFactory abstractSysInteractionFactory = this.sysInteractionProducer.getFactory("NJWW");
            InteractionReceiveInterface interactionReceiveInterface = abstractSysInteractionFactory.createInteractionReceive();
            interactionReceiveInterface.authentication();
            interactionReceiveInterface.handleReceiveData(tbSysInteractionRecord, "wwTaskHandleDataReceive");
        }
        catch (Exception e) {
            e.printStackTrace();
            tbSysInteractionRecord.setStatus(0);
            tbSysInteractionRecord.setBackresult(e.getMessage());
            this.sysInteractionRecordRepository.save((Object)tbSysInteractionRecord);
        }
        return "\u4f20\u8f93\u6570\u636e\u5b8c\u6210";
    }

    public Map<String, String> uploadToLocal(MultipartFile file) throws Exception {
        if (file.isEmpty()) {
            throw new Exception("\u6587\u4ef6\u4e3a\u7a7a");
        }
        String filename = file.getOriginalFilename();
        Long filesize = file.getSize();
        Calendar now = Calendar.getInstance();
        String newFileName = System.currentTimeMillis() + "_" + filename;
        String dayDir = now.get(1) + "_" + (now.get(2) + 1) + "_" + now.get(5);
        String newFileUrl = this.tempDir + "/sysinteraction/" + "NJWW" + "/" + dayDir;
        File newFileDir = new File(newFileUrl);
        if (!newFileDir.exists()) {
            newFileDir.mkdirs();
        }
        try {
            int n;
            File newFile = new File(newFileDir, newFileName);
            InputStream isWithBuff = file.getInputStream();
            FileOutputStream fosWithBuff = new FileOutputStream(newFile);
            byte[] buff = new byte[8192];
            while ((n = isWithBuff.read(buff)) != -1) {
                fosWithBuff.write(buff, 0, n);
            }
            isWithBuff.close();
            fosWithBuff.close();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("filesize", filesize.toString());
        map.put("filename", filename);
        map.put("newFilename", newFileName);
        map.put("newFileUrl", newFileDir.getAbsolutePath() + "/" + newFileName);
        return map;
    }
}

