/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.taskStatisticalDay;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.dao.taskStatisticalDay.TaskStatisticalDayDao;
import com.geoway.landteam.landcloud.dao.taskStatisticalDay.TaskStatisticalDayResultDao;
import com.geoway.landteam.landcloud.dao.taskStatisticalDay.TaskStatisticalDayWjDao;
import com.geoway.landteam.landcloud.model.taskStatisticalDay.entity.TaskStatisticalDay;
import com.geoway.landteam.landcloud.model.taskStatisticalDay.entity.TaskStatisticalDayResult;
import com.geoway.landteam.landcloud.model.taskStatisticalDay.entity.TaskStatisticalDayWj;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.excel.EnumTextLocation;
import com.geoway.landteam.landcloud.service.util.excel.ExcelColData;
import com.geoway.landteam.landcloud.service.util.excel.ExcelRowData;
import com.geoway.landteam.landcloud.service.util.excel.ExcelUtil;
import com.gw.base.gpa.entity.GiEntityQueryable;
import com.gw.base.gpa.entity.GiEntitySaveable;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class MTaskStatisticalDayService {
    private final GiLoger logger = GwLoger.getLoger(MTaskStatisticalDayService.class);
    @Value(value="${project.tempDir}")
    String tempDir;
    @Resource
    TaskStatisticalDayWjDao taskStatisticalDayWjDao;
    @Resource
    TaskStatisticalDayDao taskStatisticalDayDao;
    @Resource
    TaskStatisticalDayResultDao taskStatisticalDayResultDao;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    public List<TaskStatisticalDay> getNeedDayStatistical() {
        return this.taskStatisticalDayDao.gwSearchAll();
    }

    public JSONObject getDayStatisticalPage(String taskId, Integer page, Integer size) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            taskId = null;
        }
        Integer totalCount = this.taskStatisticalDayResultDao.countForPage(taskId);
        List results = new ArrayList();
        if (totalCount > 0) {
            Integer offset = (page - 1) * size;
            results = this.taskStatisticalDayResultDao.selectByPage(taskId, offset, size);
            for (TaskStatisticalDayResult result : results) {
                result.setUrlDetail(this.temporarySignedUrlService.getTemporarySignedUrl(null, result.getUrlDetail(), null));
                result.setUrlHz(this.temporarySignedUrlService.getTemporarySignedUrl(null, result.getUrlHz(), null));
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("totalCount", (Object)totalCount);
        jsonObject.put("data", results);
        return jsonObject;
    }

    public void statistical(TaskStatisticalDay taskStatisticalDay) {
        TskTaskBiz task = this.tskTaskBizService.findByTaskId(taskStatisticalDay.getTaskId());
        if (task == null) {
            return;
        }
        TbtskObjectinfo objectinfo = this.tskTaskBizService.getTableByTableId(task.getTableId());
        if (objectinfo == null) {
            return;
        }
        try {
            File detailFile;
            String sql;
            String sql2;
            String sql3;
            JSONObject json = JSONObject.parseObject((String)taskStatisticalDay.getConfig());
            String dkmjField = json.getString("dkmjField");
            String gdmjField = json.getString("gdmjField");
            String dkbhField = json.getString("dkbhField");
            String jbntmjField = json.getString("jbntmjField");
            String sjhfxpdField = json.getString("sjhfxpdField");
            String zglsqkField = json.getString("zglsqkField");
            String sjrdzgqkField = json.getString("sjrdzgqkField");
            String sjzgqkpdField = json.getString("sjzgqkpdField");
            String cityEndTime = json.getString("cityEndTime");
            String provinceEndTime = json.getString("provinceEndTime");
            String tablename = objectinfo.getfTablename();
            String childTable = objectinfo.getSplitTableName();
            Calendar calendar = Calendar.getInstance();
            Date today = calendar.getTime();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String todayEndTime = df.format(today) + " " + cityEndTime;
            calendar.add(5, -1);
            Date yestoday = calendar.getTime();
            String yestodayStartTime = df.format(yestoday) + " " + cityEndTime;
            String provinceTodayEndTime = df.format(today) + " " + provinceEndTime;
            df = new SimpleDateFormat("MM\u6708dd\u65e5");
            String todayStr = df.format(today);
            String yestodayStr = df.format(yestoday);
            df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            Date provinceTodayEndTimeT = df.parse(provinceTodayEndTime);
            df = new SimpleDateFormat("yyyy");
            String year = df.format(today);
            TaskStatisticalDayResult seo = new TaskStatisticalDayResult();
            seo.setTaskId(taskStatisticalDay.getTaskId());
            seo.setTime(yestodayStartTime + "-" + todayEndTime);
            List exist = this.taskStatisticalDayResultDao.gwSearch((GiEntityQueryable)seo);
            if (exist != null && !exist.isEmpty()) {
                return;
            }
            List maps = null;
            if (StringUtils.isBlank((CharSequence)objectinfo.getSplitTableName())) {
                sql3 = String.format("with t1 as (select distinct(f_tbid) as f_tbid from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='\u5e02\u7ea7\u5ba1\u6838' and f_approve_time >= '%s' and f_approve_time <= '%s'),\n     t2 as (select '\u5ba1\u6838\u5df2\u901a\u8fc7' as f_type,f_tbid,f_approve_time as f_time from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='\u7701\u7ea7\u5ba1\u6838' and f_approve_time >= '%s' and f_approve_time <= '%s' and f_tbid in (select f_tbid from t1)),\n     t3 as (select '\u5ba1\u6838\u672a\u901a\u8fc7' as f_type,f_tbid,f_reject_time as f_time from tbtsk_reject_record trr  where f_taskid = '%s' and f_stepname  ='\u7701\u7ea7\u5ba1\u6838' and f_reject_time >= '%s' and f_reject_time <= '%s' and f_tbid in (select f_tbid from t1)),\n     t4 as (select * from (select f_type,f_tbid,f_time,row_number() over(partition by f_tbid order by f_tbid,f_time desc) as f_rnum from (select * from t2 union all select * from t3) tt  ) ss where f_rnum = 1),\n     t5 as (select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t1) and %s group by f_xzqdmcounty),\n     t6 as (select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t4 where f_type = '\u5ba1\u6838\u5df2\u901a\u8fc7') and %s group by f_xzqdmcounty),\n     t7 as (select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t4 where f_type = '\u5ba1\u6838\u672a\u901a\u8fc7') and %s group by f_xzqdmcounty),\n     t8 as (select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t1) and f_id not in (select f_tbid from t4 ) and %s group by f_xzqdmcounty),\n     t9 as (select f_xzqdm as f_xdm,f_xzqmc as f_xmc,f_pcode as f_sdm from tb_region where f_level = 3 and f_version in(select f_version from tbtsk_task_biz where f_id = '6b496e7b-d668-4302-bb24-7179d42c3f4c' )),\n     t10 as (select t9.f_xdm,t9.f_xmc,t9.f_sdm,tr.f_xzqmc as f_smc from t9 left join tb_region tr on t9.f_sdm = tr.f_xzqdm)\n     select t10.f_smc,t10.f_xdm,t10.f_xmc,\n     t5.f_count as f_count_hj,t5.f_dkmj as f_dkmj_hj,t5.f_gdmj as f_gdmj_hj,\n     t6.f_count as f_count_ws,t6.f_dkmj as f_dkmj_ws,t6.f_gdmj as f_gdmj_ws,\n     t7.f_count as f_count_pass,t7.f_dkmj as f_dkmj_pass,t7.f_gdmj as f_gdmj_pass,\n     t8.f_count as f_count_reject,t8.f_dkmj as f_dkmj_reject,t8.f_gdmj as f_gdmj_reject\n     from t10\n     left join t5 on t10.f_xdm = t5.f_xzqdmcounty\n     left join t6 on t10.f_xdm = t6.f_xzqdmcounty\n     left join t7 on t10.f_xdm = t7.f_xzqdmcounty\n     left join t8 on t10.f_xdm = t8.f_xzqdmcounty\n     order by t10.f_sdm,f_xdm", task.getId(), yestodayStartTime, todayEndTime, task.getId(), yestodayStartTime, provinceTodayEndTime, task.getId(), yestodayStartTime, provinceTodayEndTime, dkmjField, gdmjField, tablename, "f_sjhfxpd like '%\u8fdd\u6cd5%'", dkmjField, gdmjField, tablename, "f_sjhfxpd like '%\u8fdd\u6cd5%'", dkmjField, gdmjField, tablename, "f_sjhfxpd like '%\u8fdd\u6cd5%'", dkmjField, gdmjField, tablename, "f_sjhfxpd like '%\u8fdd\u6cd5%'");
                maps = this.jdbcTemplate.queryForList(sql3);
            } else {
                sql3 = String.format("with t1 as (select distinct(f_tbid) as f_tbid from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='\u5e02\u7ea7\u5ba1\u6838' and f_approve_time >= '%s' and f_approve_time <= '%s'),\n     t2 as (select '\u5ba1\u6838\u5df2\u901a\u8fc7' as f_type,f_tbid,f_approve_time as f_time from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='\u7701\u7ea7\u5ba1\u6838' and f_approve_time >= '%s' and f_approve_time <= '%s' and f_tbid in (select f_tbid from t1)),\n     t3 as (select '\u5ba1\u6838\u672a\u901a\u8fc7' as f_type,f_tbid,f_reject_time as f_time from tbtsk_reject_record trr  where f_taskid = '%s' and f_stepname  ='\u7701\u7ea7\u5ba1\u6838' and f_reject_time >= '%s' and f_reject_time <= '%s' and f_tbid in (select f_tbid from t1)),\n     t4 as (select * from (select f_type,f_tbid,f_time,row_number() over(partition by f_tbid order by f_tbid,f_time desc) as f_rnum from (select * from t2 union all select * from t3) tt  ) ss where f_rnum = 1),\n     t5 as (select f_xzqdmcounty,sum(f_count) as f_count,sum(f_dkmj) as f_dkmj,sum(f_gdmj) as f_gdmj from (\n            select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t1) and f_id not in (select f_xmid from %s) and %s group by f_xzqdmcounty\n            union all\n            select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t1)  and %s group by f_xzqdmcounty\n            ) t5_a group by f_xzqdmcounty\n            ),\n     t6 as  (select f_xzqdmcounty,sum(f_count) as f_count,sum(f_dkmj) as f_dkmj,sum(f_gdmj) as f_gdmj from (\n             select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t4 where f_type = '\u5ba1\u6838\u5df2\u901a\u8fc7') and f_id not in (select f_xmid from %s) and %s group by f_xzqdmcounty\n             union all\n             select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t4 where f_type = '\u5ba1\u6838\u5df2\u901a\u8fc7')  and %s group by f_xzqdmcounty\n             )t6_a group by f_xzqdmcounty\n             ),\n     t7 as (select f_xzqdmcounty,sum(f_count) as f_count,sum(f_dkmj) as f_dkmj,sum(f_gdmj) as f_gdmj from (\n            select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t4 where f_type = '\u5ba1\u6838\u672a\u901a\u8fc7') and f_id not in (select f_xmid from %s) and %s group by f_xzqdmcounty\n            union all\n            select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t4 where f_type = '\u5ba1\u6838\u672a\u901a\u8fc7') and %s group by f_xzqdmcounty\n            )t7_a group by f_xzqdmcounty\n            ),\n     t8 as (select f_xzqdmcounty,sum(f_count) as f_count,sum(f_dkmj) as f_dkmj,sum(f_gdmj) as f_gdmj from (\n            select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t1) and f_id not in (select f_tbid from t4 ) and f_id not in (select f_xmid from %s) and %s group by f_xzqdmcounty\n            union all\n            select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t1) and f_id not in (select f_tbid from t4 ) and %s group by f_xzqdmcounty\n            )t8_a group by f_xzqdmcounty\n            ),\n     t9 as (select f_xzqdm as f_xdm,f_xzqmc as f_xmc,f_pcode as f_sdm from tb_region where f_level = 3 and f_version in(select f_version from tbtsk_task_biz where f_id = '%s' )),\n     t10 as (select t9.f_xdm,t9.f_xmc,t9.f_sdm,tr.f_xzqmc as f_smc from t9 left join tb_region tr on t9.f_sdm = tr.f_xzqdm)\n     select t10.f_smc,t10.f_xdm,t10.f_xmc,\n     t5.f_count as f_count_hj,t5.f_dkmj as f_dkmj_hj,t5.f_gdmj as f_gdmj_hj,\n     t6.f_count as f_count_pass,t6.f_dkmj as f_dkmj_pass,t6.f_gdmj as f_gdmj_pass,\n     t7.f_count as f_count_reject,t7.f_dkmj as f_dkmj_reject,t7.f_gdmj as f_gdmj_reject,\n     t8.f_count as f_count_ws,t8.f_dkmj as f_dkmj_ws,t8.f_gdmj as f_gdmj_ws\n     from t10\n     left join t5 on t10.f_xdm = t5.f_xzqdmcounty\n     left join t6 on t10.f_xdm = t6.f_xzqdmcounty\n     left join t7 on t10.f_xdm = t7.f_xzqdmcounty\n     left join t8 on t10.f_xdm = t8.f_xzqdmcounty\n     order by t10.f_sdm,f_xdm\n     ", task.getId(), yestodayStartTime, todayEndTime, task.getId(), yestodayStartTime, provinceTodayEndTime, task.getId(), yestodayStartTime, provinceTodayEndTime, dkmjField, gdmjField, tablename, childTable, sjhfxpdField + " like '%\u8fdd\u6cd5%'", dkmjField, gdmjField, childTable, sjhfxpdField + " = '\u8fdd\u6cd5'", dkmjField, gdmjField, tablename, childTable, sjhfxpdField + " like '%\u8fdd\u6cd5%'", dkmjField, gdmjField, childTable, sjhfxpdField + " = '\u8fdd\u6cd5'", dkmjField, gdmjField, tablename, childTable, sjhfxpdField + " like '%\u8fdd\u6cd5%'", dkmjField, gdmjField, childTable, sjhfxpdField + " = '\u8fdd\u6cd5'", dkmjField, gdmjField, tablename, childTable, sjhfxpdField + " like '%\u8fdd\u6cd5%'", dkmjField, gdmjField, childTable, sjhfxpdField + " = '\u8fdd\u6cd5'", task.getId());
                maps = this.jdbcTemplate.queryForList(sql3);
            }
            List mapDetails = null;
            String configFields = dkbhField + "," + dkmjField + "," + gdmjField + "," + jbntmjField + "," + sjhfxpdField + "," + zglsqkField + "," + sjrdzgqkField + "," + sjzgqkpdField;
            if (StringUtils.isBlank((CharSequence)objectinfo.getSplitTableName())) {
                sql2 = String.format("with t0 as (select f_tbid,f_approve_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='\u5e02\u7ea7\u5ba1\u6838' and f_approve_time >= '%s' and f_approve_time <= '%s'),\n     t1 as (select * from (select f_tbid,f_approve_time, row_number() over(partition by f_tbid order by f_tbid,f_approve_time desc) as f_rnum  from t0) t1s where f_rnum = 1),\n     t2 as (select 'pass' as f_approve, f_tbid,f_approve_time as f_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='\u7701\u7ea7\u5ba1\u6838' and f_approve_time >= '%s' and f_approve_time <= '%s' and f_tbid in (select f_tbid from t1)),\n     t3 as (select 'unpass' as f_approve,f_tbid,f_reject_time as f_time  from tbtsk_reject_record trr  where f_taskid = '%s' and f_stepname  ='\u7701\u7ea7\u5ba1\u6838' and f_reject_time >= '%s' and f_reject_time <= '%s' and f_tbid in (select f_tbid from t1)),\n     t4 as (select * from (select f_approve,f_tbid,f_time,row_number() over(partition by f_tbid order by f_tbid,f_time desc) as f_rnum from (select * from t2 union all select * from t3) tt  ) ss where f_rnum = 1),\n     t5 as (select substring(f_xzqdmcounty,1,4)||'00' as f_xzqdmcity,f_xzqdmcounty,f_id,%s, case f_review_stage when 101 then '\u7701\u7ea7\u5df2\u5ba1\u6838' when 97 then '\u7701\u7ea7\u5f85\u5ba1\u6838' else '\u7701\u7ea7\u5f85\u5ba1\u6838' end as f_state from %s where f_id in (select f_tbid from t1) and %s),\n     t6 as (select t5.*,t1.f_approve_time as f_city_time,case t4.f_approve when 'pass' then '\u5ba1\u6838\u5df2\u901a\u8fc7' when 'unpass' then '\u5ba1\u6838\u672a\u901a\u8fc7' else '\u672a\u5ba1\u6838' end f_approve,t4.f_time as f_province_time from t5 left join t1 on t5.f_id = t1.f_tbid left join t4 on t5.f_id = t4.f_tbid)\n     select * from (select t6.*,tr.f_xzqmc as f_xzqmccounty,tr1.f_xzqmc as f_xzqmccity from t6 left join tb_region tr on t6.f_xzqdmcounty = tr.f_xzqdm left join tb_region tr1 on t6.f_xzqdmcity = tr1.f_xzqdm) tt  order by tt.f_xzqdmcity,tt.f_xzqdmcounty,f_approve\n     ", task.getId(), yestodayStartTime, todayEndTime, task.getId(), yestodayStartTime, provinceTodayEndTime, task.getId(), yestodayStartTime, provinceTodayEndTime, configFields, tablename, sjhfxpdField + " like '%\u8fdd\u6cd5%'");
                mapDetails = this.jdbcTemplate.queryForList(sql2);
            } else {
                sql2 = String.format("with t0 as (select f_tbid,f_approve_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='\u5e02\u7ea7\u5ba1\u6838' and f_approve_time >= '%s' and f_approve_time <= '%s'),\n     t1 as (select * from (select f_tbid,f_approve_time, row_number() over(partition by f_tbid order by f_tbid,f_approve_time desc) as f_rnum  from t0) t1s where f_rnum = 1),\n     t2 as (select 'pass' as f_approve, f_tbid,f_approve_time as f_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='\u7701\u7ea7\u5ba1\u6838' and f_approve_time >= '%s' and f_approve_time <= '%s' and f_tbid in (select f_tbid from t1)),\n     t3 as (select 'unpass' as f_approve,f_tbid,f_reject_time as f_time  from tbtsk_reject_record trr  where f_taskid = '%s' and f_stepname  ='\u7701\u7ea7\u5ba1\u6838' and f_reject_time >= '%s' and f_reject_time <= '%s' and f_tbid in (select f_tbid from t1)),\n     t4 as (select * from (select f_approve,f_tbid,f_time,row_number() over(partition by f_tbid order by f_tbid,f_time desc) as f_rnum from (select * from t2 union all select * from t3) tt  ) ss where f_rnum = 1),\n     t5 as (\n           select substring(f_xzqdmcounty,1,4)||'00' as f_xzqdmcity,f_xzqdmcounty,f_id,%s, case f_review_stage when 101 then '\u7701\u7ea7\u5df2\u5ba1\u6838' when 97 then '\u7701\u7ea7\u5f85\u5ba1\u6838' else '\u7701\u7ea7\u5f85\u5ba1\u6838' end as f_state from %s where f_id in (select f_tbid from t1) and f_id not in (select f_xmid from %s) and %s\n           union all\n           select substring(f_xzqdmcounty,1,4)||'00' as f_xzqdmcity,f_xzqdmcounty,f_id,%s, case f_review_stage when 101 then '\u7701\u7ea7\u5df2\u5ba1\u6838' when 97 then '\u7701\u7ea7\u5f85\u5ba1\u6838' else '\u7701\u7ea7\u5f85\u5ba1\u6838' end as f_state from %s where f_id in (select f_tbid from t1) and %s\n           ),\n     t6 as (select t5.*,t1.f_approve_time as f_city_time,case t4.f_approve when 'pass' then '\u5ba1\u6838\u5df2\u901a\u8fc7' when 'unpass' then '\u5ba1\u6838\u672a\u901a\u8fc7' else '\u672a\u5ba1\u6838' end f_approve,t4.f_time as f_province_time from t5 left join t1 on t5.f_id = t1.f_tbid left join t4 on t5.f_id = t4.f_tbid)\n     select * from (select t6.*,tr.f_xzqmc as f_xzqmccounty,tr1.f_xzqmc as f_xzqmccity from t6 left join tb_region tr on t6.f_xzqdmcounty = tr.f_xzqdm left join tb_region tr1 on t6.f_xzqdmcity = tr1.f_xzqdm) tt  order by tt.f_xzqdmcity,tt.f_xzqdmcounty,f_approve\n     ", task.getId(), yestodayStartTime, todayEndTime, task.getId(), yestodayStartTime, provinceTodayEndTime, task.getId(), yestodayStartTime, provinceTodayEndTime, configFields, tablename, childTable, sjhfxpdField + " like '%\u8fdd\u6cd5%'", configFields, childTable, sjhfxpdField + " = '\u8fdd\u6cd5'");
                mapDetails = this.jdbcTemplate.queryForList(sql2);
            }
            List mapWjs = null;
            if (StringUtils.isBlank((CharSequence)objectinfo.getSplitTableName())) {
                sql = String.format(" with t as (select f_tbid,f_wj_time from tb_task_statistical_day_wj where f_task_id = '%s'),\n     t0 as (select f_tbid,f_approve_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='\u5e02\u7ea7\u5ba1\u6838' and f_tbid in (select f_tbid from t)),\n     t1 as (select * from (select f_tbid,f_approve_time, row_number() over(partition by f_tbid order by f_tbid,f_approve_time desc) as f_rnum  from t0) t1s where f_rnum = 1),\n     t2 as (select 'pass' as f_approve, f_tbid,f_approve_time as f_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='\u7701\u7ea7\u5ba1\u6838' and f_tbid in (select f_tbid from t)),\n     t3 as (select 'unpass' as f_approve,f_tbid,f_reject_time as f_time  from tbtsk_reject_record trr  where f_taskid = '%s' and f_stepname  ='\u7701\u7ea7\u5ba1\u6838' and f_tbid in (select f_tbid from t)),\n     t4 as (select * from (select f_approve,f_tbid,f_time,row_number() over(partition by f_tbid order by f_tbid,f_time desc) as f_rnum from (select * from t2 union all select * from t3) tt  ) ss where f_rnum = 1),\n     t5 as (select substring(f_xzqdmcounty,1,4)||'00' as f_xzqdmcity,f_xzqdmcounty,f_id,%s, case f_review_stage when 101 then '\u7701\u7ea7\u5df2\u5ba1\u6838' when 97 then '\u7701\u7ea7\u5f85\u5ba1\u6838' else '\u7701\u7ea7\u5f85\u5ba1\u6838' end as f_state from %s where f_id in (select f_tbid from t1)),\n     t6 as (select t5.*,t1.f_approve_time as f_city_time,case t4.f_approve when 'pass' then '\u5ba1\u6838\u5df2\u901a\u8fc7' when 'unpass' then '\u5ba1\u6838\u672a\u901a\u8fc7' else '\u672a\u5ba1\u6838' end f_approve,t4.f_time as f_province_time from t5 left join t1 on t5.f_id = t1.f_tbid left join t4 on t5.f_id = t4.f_tbid)\n     select * from (select t6.*,tr.f_xzqmc as f_xzqmccounty,tr1.f_xzqmc as f_xzqmccity,t.f_wj_Time from t6 left join tb_region tr on t6.f_xzqdmcounty = tr.f_xzqdm left join tb_region tr1 on t6.f_xzqdmcity = tr1.f_xzqdm left join t on t6.f_id = t.f_tbid) tt order by tt.f_wj_Time, tt.f_xzqdmcity,tt.f_xzqdmcounty,tt.f_approve\n     ", task.getId(), task.getId(), task.getId(), task.getId(), configFields, tablename);
                mapWjs = this.jdbcTemplate.queryForList(sql);
            } else {
                sql = String.format("with t as (select f_tbid,f_wj_time from tb_task_statistical_day_wj where f_task_id = '%s'),\n     t0 as (select f_tbid,f_approve_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='\u5e02\u7ea7\u5ba1\u6838' and f_tbid in (select f_tbid from t)),\n     t1 as (select * from (select f_tbid,f_approve_time, row_number() over(partition by f_tbid order by f_tbid,f_approve_time desc) as f_rnum  from t0) t1s where f_rnum = 1),\n     t2 as (select 'pass' as f_approve, f_tbid,f_approve_time as f_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='\u7701\u7ea7\u5ba1\u6838' and f_tbid in (select f_tbid from t)),\n     t3 as (select 'unpass' as f_approve,f_tbid,f_reject_time as f_time  from tbtsk_reject_record trr  where f_taskid = '%s' and f_stepname  ='\u7701\u7ea7\u5ba1\u6838' and f_tbid in (select f_tbid from t)),\n     t4 as (select * from (select f_approve,f_tbid,f_time,row_number() over(partition by f_tbid order by f_tbid,f_time desc) as f_rnum from (select * from t2 union all select * from t3) tt  ) ss where f_rnum = 1),\n     t5 as (\n            select substring(f_xzqdmcounty,1,4)||'00' as f_xzqdmcity,f_xzqdmcounty,f_id,%s, case f_review_stage when 101 then '\u7701\u7ea7\u5df2\u5ba1\u6838' when 97 then '\u7701\u7ea7\u5f85\u5ba1\u6838' else '\u7701\u7ea7\u5f85\u5ba1\u6838' end as f_state from %s where f_id in (select f_tbid from t1) and f_id not in(select f_xmid from %s)\n            union all\n            select substring(f_xzqdmcounty,1,4)||'00' as f_xzqdmcity,f_xzqdmcounty,f_id,%s, case f_review_stage when 101 then '\u7701\u7ea7\u5df2\u5ba1\u6838' when 97 then '\u7701\u7ea7\u5f85\u5ba1\u6838' else '\u7701\u7ea7\u5f85\u5ba1\u6838' end as f_state from %s where f_id in (select f_tbid from t1)\n            ),\n     t6 as (select t5.*,t1.f_approve_time as f_city_time,case t4.f_approve when 'pass' then '\u5ba1\u6838\u5df2\u901a\u8fc7' when 'unpass' then '\u5ba1\u6838\u672a\u901a\u8fc7' else '\u672a\u5ba1\u6838' end f_approve,t4.f_time as f_province_time from t5 left join t1 on t5.f_id = t1.f_tbid left join t4 on t5.f_id = t4.f_tbid)\n     select * from (select t6.*,tr.f_xzqmc as f_xzqmccounty,tr1.f_xzqmc as f_xzqmccity,t.f_wj_Time from t6 left join tb_region tr on t6.f_xzqdmcounty = tr.f_xzqdm left join tb_region tr1 on t6.f_xzqdmcity = tr1.f_xzqdm left join t on t6.f_id = t.f_tbid) tt order by tt.f_wj_Time, tt.f_xzqdmcity,tt.f_xzqdmcounty,tt.f_approve\n    ", task.getId(), task.getId(), task.getId(), task.getId(), configFields, tablename, childTable, configFields, childTable);
                mapWjs = this.jdbcTemplate.queryForList(sql);
            }
            List<tempInfo> tempInfos = this.getTempInfo(maps);
            String hzb = this.getHZB(tempInfos, task, todayStr, yestodayStr, year);
            String detail = this.getDetail(mapDetails, mapWjs, task, dkbhField, dkmjField, gdmjField, jbntmjField, sjhfxpdField, zglsqkField, sjrdzgqkField, sjzgqkpdField, provinceTodayEndTimeT);
            String urlHz = null;
            String urlDetail = null;
            File hzFile = new File(hzb);
            if (hzFile.exists()) {
                String sendObj = "taskStatisticalDay/" + task + "/\u5e02\u7ea7\u62a5\u9001\u6574\u6539\u56fe\u6591\u7701\u7ea7\u5ba1\u6838\u8fdb\u5ea6\u60c5\u51b5\u7edf\u8ba1\u8868\uff08" + yestodayStr + "-" + todayStr + "\uff09.xlsx";
                urlHz = this.defaultOssOperatorService.sendObject2Oss(sendObj, hzFile);
                hzFile.delete();
            }
            if ((detailFile = new File(detail)).exists()) {
                String sendObj = "taskStatisticalDay/" + task + "/\u5e02\u7ea7\u62a5\u9001\u6574\u6539\u56fe\u6591\u7701\u7ea7\u5ba1\u6838\u8fdb\u5ea6\u60c5\u51b5\u6e05\u5355\u660e\u7ec6\u8868\uff08" + yestodayStr + "-" + todayStr + "\uff09.xlsx";
                urlDetail = this.defaultOssOperatorService.sendObject2Oss(sendObj, detailFile);
                detailFile.delete();
            }
            TaskStatisticalDayResult dayResult = new TaskStatisticalDayResult();
            dayResult.setTaskId(task.getId());
            dayResult.setUrlHz(urlHz);
            dayResult.setUrlDetail(urlDetail);
            dayResult.setCreateTime(new Date());
            dayResult.setId(UUID.randomUUID().toString());
            dayResult.setTimeEnd(provinceTodayEndTime);
            dayResult.setTime(yestodayStartTime + "-" + todayEndTime);
            this.taskStatisticalDayResultDao.gwAccess((GiEntitySaveable)dayResult);
        }
        catch (Exception ex) {
            this.logger.error("\u65e5\u7ed3\u7edf\u8ba1\u5931\u8d25" + ExceptionUtil.getErrorString(ex), new Object[0]);
        }
    }

    private List<tempInfo> getTempInfo(List<Map<String, Object>> maps) {
        if (maps == null || maps.isEmpty()) {
            return null;
        }
        ArrayList<tempInfo> results = new ArrayList<tempInfo>();
        for (Map<String, Object> map : maps) {
            String smc = map.get("f_smc") != null ? map.get("f_smc").toString() : "";
            String xdm = map.get("f_xdm") != null ? map.get("f_xdm").toString() : "";
            String xmc = map.get("f_xmc") != null ? map.get("f_xmc").toString() : "";
            Integer countHj = map.get("f_count_hj") != null ? Integer.parseInt(map.get("f_count_hj").toString()) : 0;
            BigDecimal dkmjHj = this.getBigDecimal(map, "f_dkmj_hj");
            BigDecimal gdmjHj = this.getBigDecimal(map, "f_gdmj_hj");
            Integer countWs = map.get("f_count_ws") != null ? Integer.parseInt(map.get("f_count_ws").toString()) : 0;
            BigDecimal dkmjWs = this.getBigDecimal(map, "f_dkmj_ws");
            BigDecimal gdmjWs = this.getBigDecimal(map, "f_gdmj_ws");
            Integer countPass = map.get("f_count_pass") != null ? Integer.parseInt(map.get("f_count_pass").toString()) : 0;
            BigDecimal dkmjPass = this.getBigDecimal(map, "f_dkmj_pass");
            BigDecimal gdmjPass = this.getBigDecimal(map, "f_gdmj_pass");
            Integer countUnPass = map.get("f_count_reject") != null ? Integer.parseInt(map.get("f_count_reject").toString()) : 0;
            BigDecimal dkmjUnPass = this.getBigDecimal(map, "f_dkmj_reject");
            BigDecimal gdmjUnPass = this.getBigDecimal(map, "f_gdmj_reject");
            tempInfo tempInfo2 = new tempInfo();
            tempInfo2.setSmc(smc);
            tempInfo2.setXdm(xdm);
            tempInfo2.setXmc(xmc);
            tempInfo2.setCountHj(countHj);
            tempInfo2.setDkmjHj(dkmjHj);
            tempInfo2.setGdmjHj(gdmjHj);
            tempInfo2.setCountWs(countWs);
            tempInfo2.setDkmjWs(dkmjWs);
            tempInfo2.setGdmjWs(gdmjWs);
            tempInfo2.setCountPass(countPass);
            tempInfo2.setDkmjPass(dkmjPass);
            tempInfo2.setGdmjPass(gdmjPass);
            tempInfo2.setCountUnPass(countUnPass);
            tempInfo2.setDkmjUnPass(dkmjUnPass);
            tempInfo2.setGdmjUnPass(gdmjUnPass);
            results.add(tempInfo2);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    private String getHZB(List<tempInfo> tempInfos, TskTaskBiz task, String todayStr, String yestodayStr, String year) throws Exception {
        ArrayList<ExcelRowData> rows = new ArrayList<ExcelRowData>();
        SXSSFWorkbook excelWorkBook = ExcelUtil.CreateSXSSExcel();
        Sheet excelSheet = ExcelUtil.createSheet(excelWorkBook, "\u8fdb\u5ea6\u60c5\u51b5\u7edf\u8ba1\u8868");
        ArrayList<Integer> colWidth = new ArrayList<Integer>();
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        for (int i = 0; i < colWidth.size(); ++i) {
            excelSheet.setColumnWidth(i, (Integer)colWidth.get(i) * 200);
        }
        int rowIndex = 0;
        String titleStr = year + "\u5e74\u65b0\u589e\u8fdd\u6cd5\u7528\u5730\u5e02\u7ea7\u62a5\u9001\u6574\u6539\u56fe\u6591\u7701\u7ea7\u5ba1\u6838\u8fdb\u5ea6\u60c5\u51b5\u7edf\u8ba1\u8868\uff08" + yestodayStr + "-" + todayStr + ")";
        ExcelColData title = new ExcelColData();
        title.setMergeCell(true);
        title.setBold(true);
        title.setValue(titleStr);
        title.setFontSize(20);
        title.setStartRow(0);
        title.setEndRow(0);
        title.setStartCol(0);
        title.setEndCol(14);
        title.setTextLocation(EnumTextLocation.middle);
        title.setColIndex(0);
        ArrayList<ExcelColData> row1 = new ArrayList<ExcelColData>();
        row1.add(title);
        ExcelRowData excelRow1 = new ExcelRowData();
        excelRow1.setColDataList(row1);
        excelRow1.setRowIndex(rowIndex);
        rows.add(excelRow1);
        ++rowIndex;
        ExcelColData colHeader1 = new ExcelColData();
        colHeader1.setMergeCell(true);
        colHeader1.setBold(false);
        colHeader1.setValue("\u5e02\u7ea7\u540d\u79f0");
        colHeader1.setFontSize(10);
        colHeader1.setStartRow(1);
        colHeader1.setEndRow(2);
        colHeader1.setStartCol(0);
        colHeader1.setEndCol(0);
        colHeader1.setTextLocation(EnumTextLocation.middle);
        colHeader1.setColIndex(0);
        ExcelColData colHeader2 = new ExcelColData();
        colHeader2.setMergeCell(true);
        colHeader2.setBold(false);
        colHeader2.setValue("\u884c\u653f\u4ee3\u7801");
        colHeader2.setFontSize(10);
        colHeader2.setStartRow(1);
        colHeader2.setEndRow(2);
        colHeader2.setStartCol(1);
        colHeader2.setEndCol(1);
        colHeader2.setTextLocation(EnumTextLocation.middle);
        colHeader2.setColIndex(1);
        ExcelColData colHeader3 = new ExcelColData();
        colHeader3.setMergeCell(true);
        colHeader3.setBold(false);
        colHeader3.setValue("\u53bf\u540d\u79f0");
        colHeader3.setFontSize(10);
        colHeader3.setStartRow(1);
        colHeader3.setEndRow(2);
        colHeader3.setStartCol(2);
        colHeader3.setEndCol(2);
        colHeader3.setTextLocation(EnumTextLocation.middle);
        colHeader3.setColIndex(2);
        ExcelColData colHeader4 = new ExcelColData();
        colHeader4.setMergeCell(true);
        colHeader4.setBold(false);
        colHeader4.setValue("\u5408\u8ba1");
        colHeader4.setFontSize(10);
        colHeader4.setStartRow(1);
        colHeader4.setEndRow(1);
        colHeader4.setStartCol(3);
        colHeader4.setEndCol(5);
        colHeader4.setTextLocation(EnumTextLocation.middle);
        colHeader4.setColIndex(3);
        ExcelColData colHeader5 = new ExcelColData();
        colHeader5.setMergeCell(true);
        colHeader5.setBold(false);
        colHeader5.setValue("\u5ba1\u6838\u672a\u901a\u8fc7");
        colHeader5.setFontSize(10);
        colHeader5.setStartRow(1);
        colHeader5.setEndRow(1);
        colHeader5.setStartCol(6);
        colHeader5.setEndCol(8);
        colHeader5.setTextLocation(EnumTextLocation.middle);
        colHeader5.setColIndex(6);
        ExcelColData colHeader6 = new ExcelColData();
        colHeader6.setMergeCell(true);
        colHeader6.setBold(false);
        colHeader6.setValue("\u5ba1\u6838\u901a\u8fc7");
        colHeader6.setFontSize(10);
        colHeader6.setStartRow(1);
        colHeader6.setEndRow(1);
        colHeader6.setStartCol(9);
        colHeader6.setEndCol(11);
        colHeader6.setTextLocation(EnumTextLocation.middle);
        colHeader6.setColIndex(9);
        ExcelColData colHeader7 = new ExcelColData();
        colHeader7.setMergeCell(true);
        colHeader7.setBold(false);
        colHeader7.setValue("\u672a\u5ba1\u6838");
        colHeader7.setFontSize(10);
        colHeader7.setStartRow(1);
        colHeader7.setEndRow(1);
        colHeader7.setStartCol(12);
        colHeader7.setEndCol(14);
        colHeader7.setTextLocation(EnumTextLocation.middle);
        colHeader7.setColIndex(12);
        ArrayList<ExcelColData> cols = new ArrayList<ExcelColData>();
        cols.add(colHeader1);
        cols.add(colHeader2);
        cols.add(colHeader3);
        cols.add(colHeader4);
        cols.add(colHeader5);
        cols.add(colHeader6);
        cols.add(colHeader7);
        ExcelRowData excelRowHeader = new ExcelRowData();
        excelRowHeader.setColDataList(cols);
        excelRowHeader.setRowIndex(rowIndex);
        rows.add(excelRowHeader);
        ++rowIndex;
        ExcelColData colHeader_4 = new ExcelColData();
        colHeader_4.setMergeCell(false);
        colHeader_4.setBold(false);
        colHeader_4.setValue("\u4e2a\u6570");
        colHeader_4.setFontSize(10);
        colHeader_4.setStartRow(2);
        colHeader_4.setEndRow(2);
        colHeader_4.setStartCol(3);
        colHeader_4.setEndCol(3);
        colHeader_4.setTextLocation(EnumTextLocation.middle);
        colHeader_4.setColIndex(3);
        ExcelColData colHeader_5 = new ExcelColData();
        colHeader_5.setMergeCell(false);
        colHeader_5.setBold(false);
        colHeader_5.setValue("\u9762\u79ef");
        colHeader_5.setFontSize(10);
        colHeader_5.setStartRow(2);
        colHeader_5.setEndRow(2);
        colHeader_5.setStartCol(4);
        colHeader_5.setEndCol(4);
        colHeader_5.setTextLocation(EnumTextLocation.middle);
        colHeader_5.setColIndex(4);
        ExcelColData colHeader_6 = new ExcelColData();
        colHeader_6.setMergeCell(false);
        colHeader_6.setBold(false);
        colHeader_6.setValue("\u8015\u5730");
        colHeader_6.setFontSize(10);
        colHeader_6.setStartRow(2);
        colHeader_6.setEndRow(2);
        colHeader_6.setStartCol(5);
        colHeader_6.setEndCol(5);
        colHeader_6.setTextLocation(EnumTextLocation.middle);
        colHeader_6.setColIndex(5);
        ExcelColData colHeader_7 = new ExcelColData();
        colHeader_7.setMergeCell(false);
        colHeader_7.setBold(false);
        colHeader_7.setValue("\u4e2a\u6570");
        colHeader_7.setFontSize(10);
        colHeader_7.setStartRow(2);
        colHeader_7.setEndRow(2);
        colHeader_7.setStartCol(6);
        colHeader_7.setEndCol(6);
        colHeader_7.setTextLocation(EnumTextLocation.middle);
        colHeader_7.setColIndex(6);
        ExcelColData colHeader_8 = new ExcelColData();
        colHeader_8.setMergeCell(false);
        colHeader_8.setBold(false);
        colHeader_8.setValue("\u9762\u79ef");
        colHeader_8.setFontSize(10);
        colHeader_8.setStartRow(2);
        colHeader_8.setEndRow(2);
        colHeader_8.setStartCol(7);
        colHeader_8.setEndCol(7);
        colHeader_8.setTextLocation(EnumTextLocation.middle);
        colHeader_8.setColIndex(7);
        ExcelColData colHeader_9 = new ExcelColData();
        colHeader_9.setMergeCell(false);
        colHeader_9.setBold(false);
        colHeader_9.setValue("\u8015\u5730");
        colHeader_9.setFontSize(10);
        colHeader_9.setStartRow(2);
        colHeader_9.setEndRow(2);
        colHeader_9.setStartCol(8);
        colHeader_9.setEndCol(8);
        colHeader_9.setTextLocation(EnumTextLocation.middle);
        colHeader_9.setColIndex(8);
        ExcelColData colHeader_10 = new ExcelColData();
        colHeader_10.setMergeCell(false);
        colHeader_10.setBold(false);
        colHeader_10.setValue("\u4e2a\u6570");
        colHeader_10.setFontSize(10);
        colHeader_10.setStartRow(2);
        colHeader_10.setEndRow(2);
        colHeader_10.setStartCol(9);
        colHeader_10.setEndCol(9);
        colHeader_10.setTextLocation(EnumTextLocation.middle);
        colHeader_10.setColIndex(9);
        ExcelColData colHeader_11 = new ExcelColData();
        colHeader_11.setMergeCell(false);
        colHeader_11.setBold(false);
        colHeader_11.setValue("\u9762\u79ef");
        colHeader_11.setFontSize(10);
        colHeader_11.setStartRow(2);
        colHeader_11.setEndRow(2);
        colHeader_11.setStartCol(10);
        colHeader_11.setEndCol(10);
        colHeader_11.setTextLocation(EnumTextLocation.middle);
        colHeader_11.setColIndex(10);
        ExcelColData colHeader_12 = new ExcelColData();
        colHeader_12.setMergeCell(false);
        colHeader_12.setBold(false);
        colHeader_12.setValue("\u8015\u5730");
        colHeader_12.setFontSize(10);
        colHeader_12.setStartRow(2);
        colHeader_12.setEndRow(2);
        colHeader_12.setStartCol(11);
        colHeader_12.setEndCol(11);
        colHeader_12.setTextLocation(EnumTextLocation.middle);
        colHeader_12.setColIndex(11);
        ExcelColData colHeader_13 = new ExcelColData();
        colHeader_13.setMergeCell(false);
        colHeader_13.setBold(false);
        colHeader_13.setValue("\u4e2a\u6570");
        colHeader_13.setFontSize(10);
        colHeader_13.setStartRow(2);
        colHeader_13.setEndRow(2);
        colHeader_13.setStartCol(12);
        colHeader_13.setEndCol(12);
        colHeader_13.setTextLocation(EnumTextLocation.middle);
        colHeader_13.setColIndex(12);
        ExcelColData colHeader_14 = new ExcelColData();
        colHeader_14.setMergeCell(false);
        colHeader_14.setBold(false);
        colHeader_14.setValue("\u9762\u79ef");
        colHeader_14.setFontSize(10);
        colHeader_14.setStartRow(2);
        colHeader_14.setEndRow(2);
        colHeader_14.setStartCol(13);
        colHeader_14.setEndCol(13);
        colHeader_14.setTextLocation(EnumTextLocation.middle);
        colHeader_14.setColIndex(13);
        ExcelColData colHeader_15 = new ExcelColData();
        colHeader_15.setMergeCell(false);
        colHeader_15.setBold(false);
        colHeader_15.setValue("\u8015\u5730");
        colHeader_15.setFontSize(10);
        colHeader_15.setStartRow(2);
        colHeader_15.setEndRow(2);
        colHeader_15.setStartCol(14);
        colHeader_15.setEndCol(14);
        colHeader_15.setTextLocation(EnumTextLocation.middle);
        colHeader_15.setColIndex(14);
        ArrayList<ExcelColData> headers = new ArrayList<ExcelColData>();
        headers.add(colHeader_4);
        headers.add(colHeader_5);
        headers.add(colHeader_6);
        headers.add(colHeader_7);
        headers.add(colHeader_8);
        headers.add(colHeader_9);
        headers.add(colHeader_10);
        headers.add(colHeader_11);
        headers.add(colHeader_12);
        headers.add(colHeader_13);
        headers.add(colHeader_14);
        headers.add(colHeader_15);
        ExcelRowData excelRowHeader2 = new ExcelRowData();
        excelRowHeader2.setColDataList(headers);
        excelRowHeader2.setRowIndex(rowIndex);
        rows.add(excelRowHeader2);
        ++rowIndex;
        if (tempInfos != null && !tempInfos.isEmpty()) {
            Integer countHj = tempInfos.stream().mapToInt(t -> ((tempInfo)t).countHj).sum();
            Integer countUnPass = tempInfos.stream().mapToInt(t -> ((tempInfo)t).countUnPass).sum();
            Integer countPass = tempInfos.stream().mapToInt(t -> ((tempInfo)t).countPass).sum();
            Integer countWs = tempInfos.stream().mapToInt(t -> ((tempInfo)t).countWs).sum();
            BigDecimal dkmjHj = MTaskStatisticalDayService.sumBigDecimalList(tempInfos.stream().map(tempInfo::getDkmjHj).collect(Collectors.toList()));
            BigDecimal dkmjUnPass = MTaskStatisticalDayService.sumBigDecimalList(tempInfos.stream().map(tempInfo::getDkmjUnPass).collect(Collectors.toList()));
            BigDecimal dkmjPass = MTaskStatisticalDayService.sumBigDecimalList(tempInfos.stream().map(tempInfo::getDkmjPass).collect(Collectors.toList()));
            BigDecimal dkmjWs = MTaskStatisticalDayService.sumBigDecimalList(tempInfos.stream().map(tempInfo::getDkmjWs).collect(Collectors.toList()));
            BigDecimal gdmjHj = MTaskStatisticalDayService.sumBigDecimalList(tempInfos.stream().map(tempInfo::getGdmjHj).collect(Collectors.toList()));
            BigDecimal gdmjUnPass = MTaskStatisticalDayService.sumBigDecimalList(tempInfos.stream().map(tempInfo::getGdmjUnPass).collect(Collectors.toList()));
            BigDecimal gdmjPass = MTaskStatisticalDayService.sumBigDecimalList(tempInfos.stream().map(tempInfo::getGdmjPass).collect(Collectors.toList()));
            BigDecimal gdmjWs = MTaskStatisticalDayService.sumBigDecimalList(tempInfos.stream().map(tempInfo::getGdmjWs).collect(Collectors.toList()));
            ExcelColData zj = new ExcelColData();
            zj.setMergeCell(true);
            zj.setBold(true);
            zj.setValue("\u603b\u8ba1");
            zj.setFontSize(11);
            zj.setStartRow(rowIndex);
            zj.setEndRow(rowIndex);
            zj.setStartCol(0);
            zj.setEndCol(2);
            zj.setTextLocation(EnumTextLocation.middle);
            zj.setColIndex(0);
            ArrayList<ExcelColData> zjCells = new ArrayList<ExcelColData>();
            zjCells.add(zj);
            ArrayList<Object> objs = new ArrayList<Object>();
            objs.add(countHj);
            objs.add(dkmjHj);
            objs.add(gdmjHj);
            objs.add(countUnPass);
            objs.add(dkmjUnPass);
            objs.add(gdmjUnPass);
            objs.add(countPass);
            objs.add(dkmjPass);
            objs.add(gdmjPass);
            objs.add(countWs);
            objs.add(dkmjWs);
            objs.add(gdmjWs);
            int colIndex = 3;
            for (Object obj : objs) {
                ExcelColData c = new ExcelColData();
                c.setMergeCell(false);
                c.setBold(true);
                c.setValue(obj.toString());
                c.setFontSize(11);
                c.setStartRow(rowIndex);
                c.setEndRow(rowIndex);
                c.setStartCol(colIndex);
                c.setEndCol(colIndex);
                c.setTextLocation(EnumTextLocation.middle);
                c.setColIndex(colIndex);
                ++colIndex;
                zjCells.add(c);
            }
            ExcelRowData excelRowZj = new ExcelRowData();
            excelRowZj.setColDataList(zjCells);
            excelRowZj.setRowIndex(rowIndex);
            rows.add(excelRowZj);
            ++rowIndex;
            Map mapTemps = tempInfos.stream().collect(Collectors.groupingBy(tempInfo::getSmc, LinkedHashMap::new, Collectors.toList()));
            int xh = 0;
            for (Map.Entry map : mapTemps.entrySet()) {
                boolean mark = false;
                ++xh;
                List temps = (List)map.getValue();
                for (tempInfo t2 : temps) {
                    colIndex = 0;
                    objs.clear();
                    objs.add(xh + (String)map.getKey());
                    objs.add(t2.getXdm());
                    objs.add(t2.getXmc());
                    objs.add(t2.getCountHj());
                    objs.add(t2.getDkmjHj());
                    objs.add(t2.getGdmjHj());
                    objs.add(t2.getCountUnPass());
                    objs.add(t2.getDkmjUnPass());
                    objs.add(t2.getGdmjUnPass());
                    objs.add(t2.getCountPass());
                    objs.add(t2.getDkmjPass());
                    objs.add(t2.getGdmjPass());
                    objs.add(t2.getCountWs());
                    objs.add(t2.getDkmjWs());
                    objs.add(t2.getGdmjWs());
                    ArrayList<ExcelColData> cells = new ArrayList<ExcelColData>();
                    int i = 0;
                    for (Object obj : objs) {
                        ExcelColData c;
                        if (++i == 1 && !mark) {
                            mark = true;
                            c = new ExcelColData();
                            c.setMergeCell(temps.size() > 1);
                            c.setBold(false);
                            c.setValue(obj.toString());
                            c.setFontSize(11);
                            c.setStartRow(rowIndex);
                            c.setEndRow(temps.size() + rowIndex - 1);
                            c.setStartCol(colIndex);
                            c.setEndCol(colIndex);
                            c.setTextLocation(EnumTextLocation.middle);
                            c.setColIndex(colIndex);
                            cells.add(c);
                        } else {
                            c = new ExcelColData();
                            c.setMergeCell(false);
                            c.setBold(false);
                            c.setValue(obj.toString());
                            c.setFontSize(11);
                            c.setStartRow(rowIndex);
                            c.setEndRow(rowIndex);
                            c.setStartCol(colIndex);
                            c.setEndCol(colIndex);
                            c.setTextLocation(EnumTextLocation.middle);
                            c.setColIndex(colIndex);
                            cells.add(c);
                        }
                        ++colIndex;
                    }
                    ExcelRowData excelRow = new ExcelRowData();
                    excelRow.setColDataList(cells);
                    excelRow.setRowIndex(rowIndex);
                    rows.add(excelRow);
                    ++rowIndex;
                }
                countHj = temps.stream().mapToInt(t -> ((tempInfo)t).countHj).sum();
                countUnPass = temps.stream().mapToInt(t -> ((tempInfo)t).countUnPass).sum();
                countPass = temps.stream().mapToInt(t -> ((tempInfo)t).countPass).sum();
                countWs = temps.stream().mapToInt(t -> ((tempInfo)t).countWs).sum();
                dkmjHj = MTaskStatisticalDayService.sumBigDecimalList(temps.stream().map(tempInfo::getDkmjHj).collect(Collectors.toList()));
                dkmjUnPass = MTaskStatisticalDayService.sumBigDecimalList(temps.stream().map(tempInfo::getDkmjUnPass).collect(Collectors.toList()));
                dkmjPass = MTaskStatisticalDayService.sumBigDecimalList(temps.stream().map(tempInfo::getDkmjPass).collect(Collectors.toList()));
                dkmjWs = MTaskStatisticalDayService.sumBigDecimalList(temps.stream().map(tempInfo::getDkmjWs).collect(Collectors.toList()));
                gdmjHj = MTaskStatisticalDayService.sumBigDecimalList(temps.stream().map(tempInfo::getGdmjHj).collect(Collectors.toList()));
                gdmjUnPass = MTaskStatisticalDayService.sumBigDecimalList(temps.stream().map(tempInfo::getGdmjUnPass).collect(Collectors.toList()));
                gdmjPass = MTaskStatisticalDayService.sumBigDecimalList(temps.stream().map(tempInfo::getGdmjPass).collect(Collectors.toList()));
                gdmjWs = MTaskStatisticalDayService.sumBigDecimalList(temps.stream().map(tempInfo::getGdmjWs).collect(Collectors.toList()));
                objs.clear();
                objs.add(xh + (String)map.getKey() + " \u6c47\u603b");
                objs.add(countHj);
                objs.add(dkmjHj);
                objs.add(gdmjHj);
                objs.add(countUnPass);
                objs.add(dkmjUnPass);
                objs.add(gdmjUnPass);
                objs.add(countPass);
                objs.add(dkmjPass);
                objs.add(gdmjPass);
                objs.add(countWs);
                objs.add(dkmjWs);
                objs.add(gdmjWs);
                colIndex = 3;
                ArrayList<ExcelColData> cells = new ArrayList<ExcelColData>();
                int i = 0;
                for (Object obj : objs) {
                    ExcelColData c;
                    if (++i == 1) {
                        c = new ExcelColData();
                        c.setMergeCell(true);
                        c.setBold(true);
                        c.setValue(obj.toString());
                        c.setFontSize(11);
                        c.setStartRow(rowIndex);
                        c.setEndRow(rowIndex);
                        c.setStartCol(0);
                        c.setEndCol(2);
                        c.setTextLocation(EnumTextLocation.middle);
                        c.setColIndex(0);
                        cells.add(c);
                        continue;
                    }
                    c = new ExcelColData();
                    c.setMergeCell(false);
                    c.setBold(true);
                    c.setValue(obj.toString());
                    c.setFontSize(11);
                    c.setStartRow(rowIndex);
                    c.setEndRow(rowIndex);
                    c.setStartCol(colIndex);
                    c.setEndCol(colIndex);
                    c.setTextLocation(EnumTextLocation.middle);
                    c.setColIndex(colIndex);
                    ++colIndex;
                    cells.add(c);
                }
                ExcelRowData excelRow = new ExcelRowData();
                excelRow.setColDataList(cells);
                excelRow.setRowIndex(rowIndex);
                rows.add(excelRow);
                ++rowIndex;
            }
        }
        ExcelUtil.write(excelSheet, rows);
        rows.clear();
        String report = this.tempDir + File.separator + task.getId() + "_" + System.currentTimeMillis() + ".xlsx";
        FileOutputStream os = null;
        try {
            File file = new File(report);
            os = new FileOutputStream(file);
            excelWorkBook.write((OutputStream)os);
        }
        catch (Exception ex) {
            this.logger.error("\u4fdd\u5b58excel\u5230\u672c\u5730\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (excelWorkBook != null) {
                excelWorkBook.close();
            }
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDetail(List<Map<String, Object>> maps, List<Map<String, Object>> mapWj, TskTaskBiz task, String dkbhField, String dkmjField, String gdmjField, String yjjbntmjField, String sjhfxpdField, String qxzgqkField, String sjrdzgqkField, String sjrdzgbzField, Date wjTime) throws Exception {
        String report;
        block21: {
            SXSSFWorkbook excelWorkBook;
            block20: {
                FileOutputStream fileOutputStream;
                ArrayList<ExcelRowData> rows = new ArrayList<ExcelRowData>();
                excelWorkBook = ExcelUtil.CreateSXSSExcel();
                Sheet excelSheet = ExcelUtil.createSheet(excelWorkBook, "\u5f53\u5929");
                ArrayList<Integer> colWidth = new ArrayList<Integer>();
                colWidth.add(20);
                colWidth.add(20);
                colWidth.add(20);
                colWidth.add(20);
                colWidth.add(40);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(60);
                for (int i = 0; i < colWidth.size(); ++i) {
                    excelSheet.setColumnWidth(i, (Integer)colWidth.get(i) * 200);
                }
                int rowIndex = 0;
                int colIndex = 0;
                ArrayList<String> headers = new ArrayList<String>();
                headers.add("\u5e02\u7ea7\u4ee3\u7801");
                headers.add("\u5e02\u7ea7\u540d\u79f0");
                headers.add("\u53bf\u7ea7\u4ee3\u7801");
                headers.add("\u53bf\u7ea7\u540d\u79f0");
                headers.add("\u5730\u5757\u7f16\u53f7");
                headers.add("\u9762\u79ef\uff08\u4ea9\uff09");
                headers.add("\u8015\u5730\uff08\u4ea9\uff09");
                headers.add("\u57fa\u672c\u519c\u7530\uff08\u4ea9\uff09");
                headers.add("\u7701\u7ea7\u5408\u6cd5\u6027\u5224\u5b9a");
                headers.add("\u533a\u53bf\u6574\u6539\u60c5\u51b5");
                headers.add("\u901a\u8fc7\u60c5\u51b5\u6807\u8bb0");
                headers.add("\u7701\u7ea7\u8ba4\u5b9a\u6574\u6539\u60c5\u51b5");
                headers.add("\u5e02\u7ea7\u5ba1\u6838\u901a\u8fc7\u65f6\u95f4");
                headers.add("\u7701\u7ea7\u5ba1\u6838\u5904\u7406\u65f6\u95f4");
                headers.add("\u56fe\u6591\u72b6\u6001");
                headers.add("\u5ba1\u6838\u610f\u89c1\uff08\u7701\u7ea7\u8ba4\u5b9a\u6574\u6539\u5907\u6ce8\uff09");
                ArrayList<ExcelColData> row1 = new ArrayList<ExcelColData>();
                for (String h : headers) {
                    ExcelColData title = new ExcelColData();
                    title.setMergeCell(false);
                    title.setBold(false);
                    title.setValue(h);
                    title.setFontSize(10);
                    title.setStartRow(rowIndex);
                    title.setEndRow(rowIndex);
                    title.setStartCol(colIndex);
                    title.setEndCol(colIndex);
                    title.setTextLocation(EnumTextLocation.middle);
                    title.setColIndex(colIndex);
                    ++colIndex;
                    row1.add(title);
                }
                ExcelRowData excelRow1 = new ExcelRowData();
                excelRow1.setColDataList(row1);
                excelRow1.setRowIndex(rowIndex);
                rows.add(excelRow1);
                ++rowIndex;
                ArrayList<TaskStatisticalDayWj> wjs = new ArrayList<TaskStatisticalDayWj>();
                Date now = new Date();
                for (Map<String, Object> map : maps) {
                    colIndex = 0;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    String id = this.getString(map, "f_id");
                    String approve = this.getString(map, "f_approve");
                    if ("\u672a\u5ba1\u6838".equals(approve)) {
                        TaskStatisticalDayWj wj = new TaskStatisticalDayWj();
                        wj.setTaskId(task.getId());
                        wj.setTbid(id);
                        long count = this.taskStatisticalDayWjDao.gwSearchCount((GiEntityQueryable)wj);
                        if (count == 0L) {
                            wj.setId(UUID.randomUUID().toString());
                            wj.setCreateTime(now);
                            wj.setWjTime(wjTime);
                            wjs.add(wj);
                        }
                    }
                    arrayList.add(this.getString(map, "f_xzqdmcity"));
                    arrayList.add(this.getString(map, "f_xzqmccity"));
                    arrayList.add(this.getString(map, "f_xzqdmcounty"));
                    arrayList.add(this.getString(map, "f_xzqmccounty"));
                    arrayList.add(this.getString(map, dkbhField));
                    arrayList.add(this.getString(map, dkmjField));
                    arrayList.add(this.getString(map, gdmjField));
                    arrayList.add(this.getString(map, yjjbntmjField));
                    arrayList.add(this.getString(map, sjhfxpdField));
                    arrayList.add(this.getString(map, qxzgqkField));
                    arrayList.add(approve);
                    arrayList.add(this.getString(map, sjrdzgqkField));
                    arrayList.add(this.getString(map, "f_city_time"));
                    arrayList.add(this.getString(map, "f_province_time"));
                    arrayList.add(this.getString(map, "f_state"));
                    arrayList.add(this.getString(map, sjrdzgbzField));
                    ArrayList<ExcelColData> row2 = new ArrayList<ExcelColData>();
                    for (String h : arrayList) {
                        ExcelColData title = new ExcelColData();
                        title.setMergeCell(false);
                        title.setBold(false);
                        title.setValue(h);
                        title.setFontSize(10);
                        title.setStartRow(rowIndex);
                        title.setEndRow(rowIndex);
                        title.setStartCol(colIndex);
                        title.setEndCol(colIndex);
                        title.setTextLocation(EnumTextLocation.middle);
                        title.setColIndex(colIndex);
                        if (h.equals("\u672a\u5ba1\u6838")) {
                            title.setColor(HSSFColor.HSSFColorPredefined.LIGHT_YELLOW.getIndex());
                        }
                        ++colIndex;
                        row2.add(title);
                    }
                    ExcelRowData excelRow2 = new ExcelRowData();
                    excelRow2.setColDataList(row2);
                    excelRow2.setRowIndex(rowIndex);
                    rows.add(excelRow2);
                    ++rowIndex;
                }
                if (!wjs.isEmpty()) {
                    this.taskStatisticalDayWjDao.insertBatch(wjs);
                }
                ExcelUtil.write(excelSheet, rows);
                rows.clear();
                colWidth.clear();
                Sheet excelWj = ExcelUtil.createSheet(excelWorkBook, "\u5386\u53f2\u672a\u7ed3");
                colWidth.add(20);
                colWidth.add(20);
                colWidth.add(20);
                colWidth.add(20);
                colWidth.add(40);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(30);
                colWidth.add(60);
                colWidth.add(30);
                for (int i = 0; i < colWidth.size(); ++i) {
                    excelWj.setColumnWidth(i, (Integer)colWidth.get(i) * 200);
                }
                rowIndex = 0;
                colIndex = 0;
                headers.clear();
                headers.add("\u5e02\u7ea7\u4ee3\u7801");
                headers.add("\u5e02\u7ea7\u540d\u79f0");
                headers.add("\u53bf\u7ea7\u4ee3\u7801");
                headers.add("\u53bf\u7ea7\u540d\u79f0");
                headers.add("\u5730\u5757\u7f16\u53f7");
                headers.add("\u9762\u79ef\uff08\u4ea9\uff09");
                headers.add("\u8015\u5730\uff08\u4ea9\uff09");
                headers.add("\u57fa\u672c\u519c\u7530\uff08\u4ea9\uff09");
                headers.add("\u7701\u7ea7\u5408\u6cd5\u6027\u5224\u5b9a");
                headers.add("\u533a\u53bf\u6574\u6539\u60c5\u51b5");
                headers.add("\u901a\u8fc7\u60c5\u51b5\u6807\u8bb0");
                headers.add("\u7701\u7ea7\u8ba4\u5b9a\u6574\u6539\u60c5\u51b5");
                headers.add("\u5e02\u7ea7\u5ba1\u6838\u901a\u8fc7\u65f6\u95f4");
                headers.add("\u7701\u7ea7\u5ba1\u6838\u5904\u7406\u65f6\u95f4");
                headers.add("\u56fe\u6591\u72b6\u6001");
                headers.add("\u5ba1\u6838\u610f\u89c1\uff08\u7701\u7ea7\u8ba4\u5b9a\u6574\u6539\u5907\u6ce8\uff09");
                headers.add("\u5269\u4f59\u60c5\u51b5");
                row1.clear();
                for (String string : headers) {
                    ExcelColData title = new ExcelColData();
                    title.setMergeCell(false);
                    title.setBold(false);
                    title.setValue(string);
                    title.setFontSize(10);
                    title.setStartRow(rowIndex);
                    title.setEndRow(rowIndex);
                    title.setStartCol(colIndex);
                    title.setEndCol(colIndex);
                    title.setTextLocation(EnumTextLocation.middle);
                    title.setColIndex(colIndex);
                    ++colIndex;
                    row1.add(title);
                }
                excelRow1 = new ExcelRowData();
                excelRow1.setColDataList(row1);
                excelRow1.setRowIndex(rowIndex);
                rows.add(excelRow1);
                ++rowIndex;
                for (Map map : mapWj) {
                    colIndex = 0;
                    ArrayList<String> cells = new ArrayList<String>();
                    cells.add(this.getString(map, "f_xzqdmcity"));
                    cells.add(this.getString(map, "f_xzqmccity"));
                    cells.add(this.getString(map, "f_xzqdmcounty"));
                    cells.add(this.getString(map, "f_xzqmccounty"));
                    cells.add(this.getString(map, dkbhField));
                    cells.add(this.getString(map, dkmjField));
                    cells.add(this.getString(map, gdmjField));
                    cells.add(this.getString(map, yjjbntmjField));
                    cells.add(this.getString(map, sjhfxpdField));
                    cells.add(this.getString(map, qxzgqkField));
                    cells.add(this.getString(map, "f_approve"));
                    cells.add(this.getString(map, sjrdzgqkField));
                    cells.add(this.getString(map, "f_city_time"));
                    cells.add(this.getString(map, "f_province_time"));
                    cells.add(this.getString(map, "f_state"));
                    cells.add(this.getString(map, sjrdzgbzField));
                    cells.add(this.getString(map, "f_wj_time"));
                    ArrayList<ExcelColData> row2 = new ArrayList<ExcelColData>();
                    for (String h : cells) {
                        ExcelColData title = new ExcelColData();
                        title.setMergeCell(false);
                        title.setBold(false);
                        title.setValue(h);
                        title.setFontSize(10);
                        title.setStartRow(rowIndex);
                        title.setEndRow(rowIndex);
                        title.setStartCol(colIndex);
                        title.setEndCol(colIndex);
                        title.setTextLocation(EnumTextLocation.middle);
                        title.setColIndex(colIndex);
                        ++colIndex;
                        row2.add(title);
                    }
                    ExcelRowData excelRow2 = new ExcelRowData();
                    excelRow2.setColDataList(row2);
                    excelRow2.setRowIndex(rowIndex);
                    rows.add(excelRow2);
                    ++rowIndex;
                }
                ExcelUtil.write(excelWj, rows);
                rows.clear();
                report = this.tempDir + File.separator + task.getId() + "_" + System.currentTimeMillis() + ".xlsx";
                FileOutputStream fileOutputStream2 = null;
                try {
                    File file = new File(report);
                    fileOutputStream = new FileOutputStream(file);
                    excelWorkBook.write((OutputStream)fileOutputStream);
                    if (fileOutputStream == null) break block20;
                }
                catch (Exception ex) {
                    this.logger.error("\u4fdd\u5b58excel\u5230\u672c\u5730\u5f02\u5e38" + ExceptionUtil.getErrorString(ex), new Object[0]);
                    break block21;
                }
                finally {
                    if (fileOutputStream2 != null) {
                        fileOutputStream2.close();
                    }
                    if (excelWorkBook != null) {
                        excelWorkBook.close();
                    }
                }
                fileOutputStream.close();
            }
            if (excelWorkBook != null) {
                excelWorkBook.close();
            }
        }
        return report;
    }

    private String getString(Map map, String key) {
        return map.get(key) != null ? map.get(key).toString() : "";
    }

    private BigDecimal getBigDecimal(Map map, String key) {
        String v = map.get(key) != null ? map.get(key).toString() : "0";
        BigDecimal decimal = new BigDecimal(v);
        return decimal;
    }

    public static BigDecimal sumBigDecimalList(List<BigDecimal> list) {
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal number : list) {
            sum = sum.add(number);
        }
        return sum;
    }

    private class tempInfo {
        private String smc;
        private String xdm;
        private String xmc;
        private Integer countHj;
        private BigDecimal dkmjHj;
        private BigDecimal gdmjHj;
        private Integer countWs;
        private BigDecimal dkmjWs;
        private BigDecimal gdmjWs;
        private Integer countPass;
        private BigDecimal dkmjPass;
        private BigDecimal gdmjPass;
        private Integer countUnPass;
        private BigDecimal dkmjUnPass;
        private BigDecimal gdmjUnPass;

        private tempInfo() {
        }

        public String getSmc() {
            return this.smc;
        }

        public void setSmc(String smc) {
            this.smc = smc;
        }

        public String getXdm() {
            return this.xdm;
        }

        public void setXdm(String xdm) {
            this.xdm = xdm;
        }

        public String getXmc() {
            return this.xmc;
        }

        public void setXmc(String xmc) {
            this.xmc = xmc;
        }

        public Integer getCountHj() {
            return this.countHj;
        }

        public void setCountHj(Integer countHj) {
            this.countHj = countHj;
        }

        public BigDecimal getDkmjHj() {
            return this.dkmjHj;
        }

        public void setDkmjHj(BigDecimal dkmjHj) {
            this.dkmjHj = dkmjHj;
        }

        public BigDecimal getGdmjHj() {
            return this.gdmjHj;
        }

        public void setGdmjHj(BigDecimal gdmjHj) {
            this.gdmjHj = gdmjHj;
        }

        public Integer getCountWs() {
            return this.countWs;
        }

        public void setCountWs(Integer countWs) {
            this.countWs = countWs;
        }

        public BigDecimal getDkmjWs() {
            return this.dkmjWs;
        }

        public void setDkmjWs(BigDecimal dkmjWs) {
            this.dkmjWs = dkmjWs;
        }

        public BigDecimal getGdmjWs() {
            return this.gdmjWs;
        }

        public void setGdmjWs(BigDecimal gdmjWs) {
            this.gdmjWs = gdmjWs;
        }

        public Integer getCountPass() {
            return this.countPass;
        }

        public void setCountPass(Integer countPass) {
            this.countPass = countPass;
        }

        public BigDecimal getDkmjPass() {
            return this.dkmjPass;
        }

        public void setDkmjPass(BigDecimal dkmjPass) {
            this.dkmjPass = dkmjPass;
        }

        public BigDecimal getGdmjPass() {
            return this.gdmjPass;
        }

        public void setGdmjPass(BigDecimal gdmjPass) {
            this.gdmjPass = gdmjPass;
        }

        public Integer getCountUnPass() {
            return this.countUnPass;
        }

        public void setCountUnPass(Integer countUnPass) {
            this.countUnPass = countUnPass;
        }

        public BigDecimal getDkmjUnPass() {
            return this.dkmjUnPass;
        }

        public void setDkmjUnPass(BigDecimal dkmjUnPass) {
            this.dkmjUnPass = dkmjUnPass;
        }

        public BigDecimal getGdmjUnPass() {
            return this.gdmjUnPass;
        }

        public void setGdmjUnPass(BigDecimal gdmjUnPass) {
            this.gdmjUnPass = gdmjUnPass;
        }
    }
}

