/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata;

import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.model.pub.entity.TbAttachFile;
import com.geoway.landteam.landcloud.repository.pub.AttachFileRepository;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

@Service(value="tbAttachFileService")
public class TbAttachFileService {
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Value(value="${project.import.media}")
    protected String mediaFolder;
    @Value(value="${project.applicationType}")
    protected String applicationType;
    @Autowired
    AttachFileRepository attachFileRepository;
    @Autowired
    private DefaultOssOperatorService stsService;

    public TbAttachFile findByTaskIdAndTbId(String taskId, String tbId) {
        return this.attachFileRepository.findByTaskIdAndTbId(taskId, tbId);
    }

    public TbAttachFile findOne(String id) {
        return this.attachFileRepository.findById((Object)id).orElse(null);
    }

    public void deletById(String id) {
        this.attachFileRepository.deleteById((Object)id);
    }

    public TbAttachFile findByTaskId(String taskId) {
        return this.attachFileRepository.findByTaskId(taskId);
    }

    public List<String> uploadTaskFile(HttpServletRequest request, String taskId, String tbId, Long userId, int level) throws Exception {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        ArrayList<String> result = new ArrayList<String>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                MultipartFile multipartFile = multiRequest.getFile((String)iter.next());
                if (multipartFile == null) continue;
                String multipartFileName = multipartFile.getOriginalFilename();
                File zipFile = null;
                File dir = new File(this.uploadDir + "/attachfile");
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                zipFile = new File(dir + "/" + multipartFileName);
                FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)zipFile);
                String zipName = zipFile.getAbsolutePath();
                String url = this.uploadFileToCloudDisk(userId, zipName, multipartFileName);
                FileUtils.deleteQuietly((File)zipFile);
                TbAttachFile attachFile = level == 0 ? this.findByTaskId(taskId) : this.findByTaskIdAndTbId(taskId, tbId);
                String fileName = multipartFileName;
                Integer type = this.getFileType(fileName);
                if (type > 2) {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u6587\u4ef6\u7c7b\u578b");
                }
                if (attachFile != null) {
                    attachFile.setFileName(fileName);
                    attachFile.setType(type);
                    attachFile.setUrl(url);
                } else {
                    attachFile = new TbAttachFile(taskId, tbId, url, fileName, new Date(), userId, type, Integer.valueOf(level));
                }
                this.attachFileRepository.save((Object)attachFile);
            }
        }
        return result;
    }

    private Integer getFileType(String fileName) {
        String subfix = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()).toLowerCase();
        String img = "bmp,jpg,png,gif,svg,raw,webp,jpeg";
        String zip = "zip,rar";
        String pdf = "pdf";
        if (img.contains(subfix)) {
            return 0;
        }
        if (pdf.contains(subfix)) {
            return 1;
        }
        if (zip.contains(subfix)) {
            return 2;
        }
        return 3;
    }

    public String uploadFileToCloudDisk(Long userId, String filePath, String fileName) throws IOException {
        if ("lan".equals(this.applicationType)) {
            String newMediaPath = this.mediaFolder + File.separator + "media" + File.separator + "attachFile" + File.separator + userId;
            File file = new File(newMediaPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            FileUtil.copyFile((String)filePath, (String)(newMediaPath + File.separator + fileName), (StandardCopyOption[])new StandardCopyOption[0]);
            return File.separator + "attachFile" + File.separator + userId + File.separator + fileName;
        }
        String sendObjName = "attachfile/upload/" + userId + "/" + fileName;
        String resultUrl = this.stsService.sendObject2Oss(sendObjName, filePath);
        return resultUrl;
    }

    public List<String> uploadMultiTaskFile(HttpServletRequest request, String bizId, String tbId, Long userId, int level) throws Exception {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        ArrayList<String> result = new ArrayList<String>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                MultipartFile multipartFile = multiRequest.getFile((String)iter.next());
                if (multipartFile == null) continue;
                String multipartFileName = multipartFile.getOriginalFilename();
                File zipFile = null;
                File dir = new File(this.uploadDir + "/attachfile");
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                zipFile = new File(dir + "/" + multipartFileName);
                FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)zipFile);
                String zipName = zipFile.getAbsolutePath();
                String url = this.uploadFileToCloudDisk(userId, zipName, multipartFileName);
                FileUtils.deleteQuietly((File)zipFile);
                TbAttachFile attachFile = new TbAttachFile();
                Integer type = this.getFileType(multipartFileName);
                attachFile = new TbAttachFile(bizId, tbId, url, multipartFileName, new Date(), userId, type, Integer.valueOf(level));
                this.attachFileRepository.save((Object)attachFile);
            }
        }
        return result;
    }

    public List<TbAttachFile> findMultiByTaskIdAndTbId(String bizId, String tbId) {
        return this.attachFileRepository.findMultiByTaskIdAndTbId(bizId, tbId);
    }

    public String getPathById(String id) {
        TbAttachFile file = this.attachFileRepository.findById((Object)id).orElse(null);
        if (file == null) {
            return null;
        }
        String path = file.getUrl();
        return this.mediaFolder + path;
    }
}

