/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.model.pub.constants.ApiNameType;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskApplicationApi;
import com.geoway.landteam.landcloud.repository.pub.TbtskApplicationApiRepository;
import com.geoway.landteam.landcloud.servface.datacq.LogService;
import com.geoway.landteam.landcloud.servface.datacq.TaskResouceService;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportDataService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportMessageService;
import com.geoway.landteam.landcloud.servface.thirddata.KflyRcxcService;
import com.geoway.landteam.landcloud.service.thirddata.utils.SqlUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class KflyRcxcServiceImpl
implements KflyRcxcService {
    @Value(value="${project.minioModel:}")
    protected String minioModel;
    @Value(value="${project.mediaUrlPrefix}")
    protected String mediaUrlPrefix;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private TbtskObjectinfoRepository objectinfoRepository;
    @Autowired
    private TbtskApplicationApiRepository tbtskApplicationApiDao;
    @Autowired
    private ExportDataService exportDataService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private TaskResouceService taskResouceService;
    @Autowired
    private LogService logService;
    @Autowired
    private ImportMessageService importMessageService;

    public void sign(String parentId) throws Exception {
        TbtskApplicationApi parentApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_gdxx[0], ApiNameType.kfly_gdxx[1]);
        TbtskApplicationApi childApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_jsydghxkz_zjl[0], ApiNameType.kfly_jsydghxkz_zjl[1]);
        TbtskObjectinfo parentTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)parentApi.getTableid()));
        TbtskObjectinfo childTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)childApi.getTableid()));
        TbtskObjectinfo toParentTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)parentApi.getAssigntotask()));
        TbtskObjectinfo toChildTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)childApi.getAssigntotask()));
        this.findChild(parentTableObj.getfTablename(), childTableObj.getfTablename(), parentId);
        this.copyData(toParentTableObj.getfTablename(), parentTableObj.getfTablename(), parentId);
        Map<String, String> parentIdMap = this.changeId(toParentTableObj.getfTablename(), parentId, null);
        List<String> childIds = this.getChildId(parentTableObj.getfTablename(), parentId, childTableObj.getfTablename());
        if (null != childIds && !childIds.isEmpty()) {
            this.copyData(toChildTableObj.getfTablename(), childTableObj.getfTablename(), StringUtils.join(childIds, (String)","));
            this.changeId(toChildTableObj.getfTablename(), StringUtils.join(childIds, (String)","), parentIdMap.get(parentId));
        }
    }

    private Boolean hasXmid(String parentTable, String parentId) {
        String sql = "select f_id from " + parentTable + " where f_id = '" + parentId + "' and f_xmid is null";
        List data = this.jdbcTemplate.queryForList(sql);
        if (data.isEmpty()) {
            return true;
        }
        return false;
    }

    private void findChild(String parentTable, String childTable, String parentId) {
        String xmidsql = "update " + parentTable + " set f_xmid = f_id where f_id = '" + parentId + "' and f_xmid is null";
        this.jdbcTemplate.execute(xmidsql);
        String sql = "update " + childTable + " t1 set f_xmid = t2.f_id from " + parentTable + " t2 where ST_Contains(t2.f_shape, t1.f_shape) and t1.f_xmid is null";
        this.jdbcTemplate.execute(sql);
    }

    private void copyData(String toTable, String fromTable, String fromIds) {
        String sql = "insert into " + toTable + " select * from " + fromTable + " where f_id in (" + SqlUtil.getInSql(fromIds) + ")";
        this.jdbcTemplate.execute(sql);
    }

    private Map<String, String> changeId(String tablename, String ids, String parentid) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        List<String> oldIdList = Arrays.asList(ids.split(","));
        Long time = System.currentTimeMillis();
        oldIdList.forEach(obj -> {
            String newId = UUID.randomUUID().toString();
            String sql = "";
            sql = StringUtils.isEmpty((CharSequence)parentid) ? "update " + tablename + " set f_id = '" + newId + "', f_xmid = '" + newId + "', f_createtime = '" + time + "' where f_id  = '" + obj + "' ;" : "update " + tablename + " set f_id = '" + newId + "', f_xmid = '" + parentid + "', f_createtime = '" + time + "' where f_id  = '" + obj + "' ;";
            this.jdbcTemplate.execute(sql);
            resultMap.put((String)obj, newId);
        });
        return resultMap;
    }

    private List<String> getChildId(String parentTablename, String parentId, String childTablename) {
        String sql = "select f_id from " + childTablename + " where f_xmid = '" + parentId + "'";
        List list = this.jdbcTemplate.queryForList(sql);
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        list.forEach(obj -> result.add((String)obj.get("f_id")));
        return result;
    }

    public List<Map<String, Object>> queryRcxcList(Integer page, Integer size, String whereSQL) {
        TbtskApplicationApi parentApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_gdxx[0], ApiNameType.kfly_gdxx[1]);
        TbtskApplicationApi childApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_jsydghxkz_zjl[0], ApiNameType.kfly_jsydghxkz_zjl[1]);
        TbtskObjectinfo parentTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)parentApi.getTableid()));
        TbtskObjectinfo childTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)childApi.getTableid()));
        TbtskObjectinfo toParentTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)parentApi.getAssigntotask()));
        TbtskObjectinfo toChildTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)childApi.getAssigntotask()));
        String sql = "select * from (select a.f_id as id,a.f_dzjgh,a.f_xmmc,a.f_tdmj,a.f_srr,a.f_ydkgsj,MAX(b.f_createtime) as f_createtime,count(b.f_jsztlx) AS xccs,a.f_xmid,MAX(b.f_jsztlx) as jsztlx,MAX(b.f_jsztdm) as f_jsztdm,a.f_sm,a.f_htbh,a.f_xzqdmsys,a.f_xmlx from " + parentTableObj.getfTablename() + " a left join " + toParentTableObj.getfTablename() + " b on a.f_dzjgh = b.f_dzjgh GROUP BY id,a.f_dzjgh,a.f_xmmc,a.f_tdmj,a.f_srr,a.f_ydkgsj,a.f_xmid,a.f_sm,a.f_htbh,a.f_xzqdmsys,a.f_xmlx order by a.f_xmid) foo" + whereSQL + " limit " + size + " offset " + page * size;
        List data = this.jdbcTemplate.queryForList(sql);
        return data;
    }

    public Map<String, Object> queryDataById(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TbtskApplicationApi parentApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_gdxx[0], ApiNameType.kfly_gdxx[1]);
        TbtskApplicationApi childApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_jsydghxkz_zjl[0], ApiNameType.kfly_jsydghxkz_zjl[1]);
        TbtskObjectinfo parentTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)parentApi.getTableid()));
        TbtskObjectinfo childTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)childApi.getTableid()));
        TbtskObjectinfo toParentTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)parentApi.getAssigntotask()));
        TbtskObjectinfo toChildTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)childApi.getAssigntotask()));
        String sql = "select * from " + parentTableObj.getfTablename() + " where f_id = '" + id + "'";
        Map baseData = this.jdbcTemplate.queryForMap(sql);
        String shpSql = "select st_astext(f_shape) as shape from " + parentTableObj.getfTablename() + " where f_id = '" + id + "'";
        Map shpData = this.jdbcTemplate.queryForMap(shpSql);
        baseData.remove("f_shape");
        result.put("base", baseData);
        result.put("shape", shpData);
        Object dzjgh = baseData.get("f_dzjgh");
        Object xmid = baseData.get("f_xmid");
        System.out.println(dzjgh);
        if (xmid != null) {
            String dzjghStr = dzjgh.toString();
            String ldSql = "select f_bjbh,f_dh,f_gcxkzh,f_qfrq,f_jsdw,f_wh,f_cs from " + childTableObj.getfTablename() + " where f_xmid = '" + xmid.toString() + "'";
            List ldData = this.jdbcTemplate.queryForList(ldSql);
            String jsxcSql = "select * from " + toParentTableObj.getfTablename() + " where f_dzjgh = '" + dzjghStr + "'";
            List jsxcData = this.jdbcTemplate.queryForList(jsxcSql);
            for (Map jsxcitem : jsxcData) {
                List<Map<String, Object>> zpList = this.queryFileById(jsxcitem.get("f_id").toString(), ".jpg");
                jsxcitem.put("xczp", zpList);
                List<Map<String, Object>> spList = this.queryFileById(jsxcitem.get("f_id").toString(), ".mp4");
                jsxcitem.put("xcsp", spList);
            }
            if (jsxcData.size() > 0) {
                String chXmid = ((Map)jsxcData.get(0)).get("f_xmid").toString();
                String ldxcSql = "select * from " + toChildTableObj.getfTablename() + " where f_xmid = '" + chXmid + "'";
                List ldxcData = this.jdbcTemplate.queryForList(ldxcSql);
                for (Map ldxcitem : ldxcData) {
                    List<Map<String, Object>> zpList = this.queryFileById(ldxcitem.get("f_id").toString(), ".jpg");
                    ldxcitem.put("xczp", zpList);
                    List<Map<String, Object>> spList = this.queryFileById(ldxcitem.get("f_id").toString(), ".mp4");
                    ldxcitem.put("xcsp", spList);
                }
                for (Map item : ldxcData) {
                    item.remove("f_shape");
                }
                result.put("ldxc", ldxcData);
            }
            for (Map item : jsxcData) {
                item.remove("f_shape");
            }
            result.put("ld", ldData);
            result.put("jsxc", jsxcData);
        }
        return result;
    }

    public JSONArray queryCirculationDataById(String id) {
        JSONArray result = new JSONArray();
        JSONObject object0 = new JSONObject();
        TbtskApplicationApi parentApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_gdxx[0], ApiNameType.kfly_gdxx[1]);
        TbtskApplicationApi childApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_jsydghxkz_zjl[0], ApiNameType.kfly_jsydghxkz_zjl[1]);
        TbtskObjectinfo parentTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)parentApi.getTableid()));
        TbtskObjectinfo childTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)childApi.getTableid()));
        TbtskObjectinfo toParentTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)parentApi.getAssigntotask()));
        TbtskObjectinfo toChildTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)childApi.getAssigntotask()));
        String sql = "select * from " + parentTableObj.getfTablename() + " where f_id = '" + id + "'";
        Map baseData = this.jdbcTemplate.queryForMap(sql);
        baseData.remove("f_shape");
        Object dzjgh = baseData.get("f_dzjgh");
        Object xmid = baseData.get("f_xmid");
        System.out.println(dzjgh);
        if (xmid != null) {
            String dzjghStr = dzjgh.toString();
            String jsxcSql = "select * from " + toParentTableObj.getfTablename() + " where f_dzjgh = '" + dzjghStr + "' order by f_createtime desc limit 1";
            List jsxcData = this.jdbcTemplate.queryForList(jsxcSql);
            for (Map item : jsxcData) {
                item.remove("f_shape");
                object0.put("data", JSONObject.parse((String)item.toString(), (Feature[])new Feature[0]));
            }
            result.add((Object)object0);
            if (jsxcData.size() > 0) {
                JSONObject objectld = new JSONObject();
                String chXmid = ((Map)jsxcData.get(0)).get("f_xmid").toString();
                String ldxcSql = "select * from " + toChildTableObj.getfTablename() + " where f_xmid = '" + chXmid + "'";
                List ldxcData = this.jdbcTemplate.queryForList(ldxcSql);
                for (Map item : ldxcData) {
                    item.remove("f_shape");
                    objectld.put("data", JSONObject.parse((String)item.toString(), (Feature[])new Feature[0]));
                    result.add((Object)objectld);
                }
            }
        }
        return result;
    }

    public List<Map<String, Object>> queryFileById(String id, String type) {
        String sql = "select * from tb_app_media where f_galleryid = '" + id + "' and f_serverpath like '%" + type + "'";
        List data = this.jdbcTemplate.queryForList(sql);
        for (Map item : data) {
            String path = item.get("f_serverpath").toString();
            item.put("id", "1");
            item.put("serverpath", "http://10.201.98.67:8090/" + path);
            item.put("username", item.get("f_username"));
            item.put("azimuth", item.get("f_azimuth"));
            item.put("time", item.get("f_time"));
            item.put("lat", item.get("f_lat"));
            item.put("lon", item.get("f_lon"));
            item.put("tablename", item.get("f_tablename"));
        }
        return data;
    }

    public Long queryRcxcCount(String whereSQL) {
        TbtskApplicationApi parentApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_gdxx[0], ApiNameType.kfly_gdxx[1]);
        TbtskApplicationApi childApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_jsydghxkz_zjl[0], ApiNameType.kfly_jsydghxkz_zjl[1]);
        TbtskObjectinfo parentTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)parentApi.getTableid()));
        TbtskObjectinfo childTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)childApi.getTableid()));
        TbtskObjectinfo toParentTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)parentApi.getAssigntotask()));
        TbtskObjectinfo toChildTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)childApi.getAssigntotask()));
        String sql = "select count(*) from (select a.f_id as id,a.f_dzjgh,a.f_xmmc,a.f_tdmj,a.f_srr,a.f_ydkgsj,MAX(b.f_createtime) as f_createtime,count(b.f_jsztlx) AS xccs,a.f_xmid,MAX(b.f_jsztlx) as jsztlx,MAX(b.f_jsztdm) as f_jsztdm,a.f_sm,a.f_htbh,a.f_xzqdmsys,a.f_xmlx from " + parentTableObj.getfTablename() + " a left join " + toParentTableObj.getfTablename() + " b on a.f_dzjgh = b.f_dzjgh GROUP BY id,a.f_dzjgh,a.f_xmmc,a.f_tdmj,a.f_srr,a.f_ydkgsj,a.f_xmid,a.f_sm,a.f_htbh,a.f_xzqdmsys,a.f_xmlx order by a.f_xmid) foo" + whereSQL;
        List data = this.jdbcTemplate.queryForList(sql);
        return Long.valueOf(((Map)data.get(0)).get("count").toString());
    }

    public void updateAudit(JSONArray arr) {
        TbtskApplicationApi parentApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_gdxx[0], ApiNameType.kfly_gdxx[1]);
        TbtskApplicationApi childApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_jsydghxkz_zjl[0], ApiNameType.kfly_jsydghxkz_zjl[1]);
        TbtskObjectinfo parentTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)parentApi.getTableid()));
        TbtskObjectinfo childTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)childApi.getTableid()));
        TbtskObjectinfo toParentTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)parentApi.getAssigntotask()));
        TbtskObjectinfo toChildTableObj = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)childApi.getAssigntotask()));
        for (int i = 0; i < arr.size(); ++i) {
            JSONObject object = arr.getJSONObject(i);
            JSONObject obj = object.getJSONObject("data");
            String type = object.getString("type");
            String tableName = "";
            if (type.equals("jsztxc")) {
                tableName = toParentTableObj.getfTablename();
            } else if (type.equals("ldxc")) {
                tableName = toChildTableObj.getfTablename();
            }
            if (tableName.equals("")) {
                return;
            }
            String sql = "update " + tableName + " set ";
            Iterator iterator = (Iterator)((Object)obj.keySet());
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = obj.getString(key);
                if (!key.contains("f_") || key.endsWith("sj") || key.endsWith("time") || value == null || value.equals("null")) continue;
                sql = sql + key + " = '" + value + "',";
            }
            sql = sql.substring(0, sql.length() - 1) + " where f_id = '" + obj.get((Object)"f_id") + "'";
            int row = this.jdbcTemplate.update(sql);
            System.out.println(row);
        }
    }

    public void resultCirculation(JSONArray arr) {
        int i;
        TbtskApplicationApi parentApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_gdxx[0], ApiNameType.kfly_gdxx[1]);
        TbtskApplicationApi childApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_jsydghxkz_zjl[0], ApiNameType.kfly_jsydghxkz_zjl[1]);
        String send = parentApi.getSend();
        if (StringUtils.isEmpty((CharSequence)send)) {
            return;
        }
        JSONObject sendConfig = JSONObject.parseObject((String)send);
        String configTableId = parentApi.getTableid();
        Map<String, String> parentMapping = this.getFieldMapping(configTableId);
        Map<String, String> childMapping = this.getFieldMapping(childApi.getTableid());
        if (null == parentMapping) {
            return;
        }
        JSONArray sendArray = new JSONArray();
        JSONObject pObj = new JSONObject();
        JSONArray chidrenArray = new JSONArray();
        for (i = 0; i < arr.size(); ++i) {
            JSONObject object = arr.getJSONObject(i);
            JSONObject tableObj = object.getJSONObject("data");
            if (i == 0) {
                try {
                    pObj = this.getSendData(tableObj, parentMapping, sendConfig);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                chidrenArray.add((Object)this.getSendData(tableObj, childMapping, sendConfig));
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        pObj.put("children", (Object)chidrenArray);
        sendArray.add((Object)pObj);
        for (i = 0; i < sendArray.size(); ++i) {
            JSONObject sendObj = sendArray.getJSONObject(i);
            this.importMessageService.sendMessageByConfig(sendConfig, sendObj);
        }
    }

    private Map<String, String> getFieldMapping(String tableid) {
        Map mapping = null;
        try {
            mapping = this.taskResouceService.getFiledMap(tableid, "1");
        }
        catch (Exception e) {
            return null;
        }
        return mapping;
    }

    private JSONObject getSendData(JSONObject obj, Map<String, String> fieldMapping, JSONObject sendConfig) throws SQLException {
        String shpType;
        JSONObject result = new JSONObject();
        for (Map.Entry<String, String> entry : fieldMapping.entrySet()) {
            if (entry.getKey().equals("f_shape")) continue;
            result.put(entry.getValue(), (Object)obj.getString(entry.getKey()));
        }
        if (sendConfig.containsKey((Object)"hasShp") && sendConfig.getBoolean("hasShp").booleanValue() && "wkt".equals(shpType = sendConfig.getString("shpType"))) {
            result.put("shape", (Object)obj.getString("f_shape"));
        }
        if (sendConfig.containsKey((Object)"hasMedia") && sendConfig.getBoolean("hasMedia").booleanValue()) {
            String f_id = obj.getString("f_id");
            JSONArray mediaArray = this.getMediaArray(f_id, sendConfig);
            result.put("media", (Object)mediaArray);
        }
        return result;
    }

    private JSONArray getMediaArray(String f_id, JSONObject sendConfig) throws SQLException {
        JSONArray result = new JSONArray();
        String sql = "select * from tb_app_media where f_galleryid = '" + f_id + "'";
        List data = this.jdbcTemplate.queryForList(sql);
        String[] fields = sendConfig.getString("mediaFields").split(",");
        for (Map item : data) {
            JSONObject obj = new JSONObject();
            for (int i = 0; i < fields.length; ++i) {
                String fieldname = fields[i];
                if ("f_serverpath".equals(fieldname)) {
                    String path = item.get(fieldname).toString();
                    String[] pathArray = path.split("media");
                    String resultPath = "";
                    if (pathArray.length != 2) {
                        resultPath = path;
                    } else if (!"true".equals(this.minioModel)) {
                        resultPath = this.mediaUrlPrefix + "/media" + pathArray[1];
                    }
                    obj.put("serverpath", (Object)resultPath);
                    continue;
                }
                obj.put(fieldname.split("f_")[1], (Object)item.get(fieldname).toString());
            }
            result.add((Object)obj);
        }
        return result;
    }
}

