/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.template;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTemplateRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.servface.taskTranslate.TaskBusiCodeApater2_0Service;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTemplate;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.task.entity.UserBiz2;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskApplicationApi;
import com.geoway.landteam.landcloud.repository.pub.TbtskApplicationApiRepository;
import com.geoway.landteam.landcloud.servface.datacq.TaskResouceService;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportDataService;
import com.geoway.landteam.landcloud.servface.thirddata.Processable;
import com.geoway.landteam.landcloud.servface.thirddata.TaskAndTbIdSetter;
import com.geoway.landteam.landcloud.servface.thirddata.TaskCreatable;
import com.geoway.landteam.landcloud.servface.thirddata.ThirdDataImportService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskTemplateService;
import com.geoway.landteam.landcloud.service.thirddata.Exception.FilterForbiddenException;
import com.geoway.landteam.landcloud.service.thirddata.utils.BysxzUtil;
import com.github.pagehelper.util.StringUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public abstract class AbstractThirdDataImportTemplate
implements ThirdDataImportService,
TaskAndTbIdSetter,
TaskCreatable,
Processable {
    private static final GiLoger logger = GwLoger.getLoger(AbstractThirdDataImportTemplate.class);
    protected TbtskApplicationApiRepository tbtskApplicationApiDao;
    protected TaskResouceService taskResouceService;
    protected DataBizService dataBizService;
    protected TbtskFieldsRepository tbtskFieldsRepository;
    protected TbtskObjectinfoService tbtskObjectinfoService;
    protected TskTaskBizRepository bizDao;
    protected ExportDataService exportDataService;
    protected TbtskTemplateRepository tbtskTemplateRepository;
    protected TskTaskBizRepository tskTaskBizRepository;
    protected TskTaskBizService tskTaskBizService;
    protected MTbtskTemplateService templateCQService;
    protected UserBiz2Repository userBiz2Repository;
    protected LandUserService landUserService;
    protected SysConfigService sysConfigService;
    protected TaskBusiCodeApater2_0Service taskBusiCodeApater2_0Service;
    protected TbtskApplicationApi applicationApi;

    @Autowired
    public void setTbtskTemplateRepository(TbtskTemplateRepository tbtskTemplateRepository) {
        this.tbtskTemplateRepository = tbtskTemplateRepository;
    }

    @Autowired
    public void setTskTaskBizRepository(TskTaskBizRepository tskTaskBizRepository) {
        this.tskTaskBizRepository = tskTaskBizRepository;
    }

    @Autowired
    public void setTskTaskBizService(TskTaskBizService tskTaskBizService) {
        this.tskTaskBizService = tskTaskBizService;
    }

    @Autowired
    public void setTemplateCQService(MTbtskTemplateService templateCQService) {
        this.templateCQService = templateCQService;
    }

    @Autowired
    public void setUserBiz2Repository(UserBiz2Repository userBiz2Repository) {
        this.userBiz2Repository = userBiz2Repository;
    }

    @Autowired
    public void setLandUserService(LandUserService landUserService) {
        this.landUserService = landUserService;
    }

    @Autowired
    public final void setTbtskApplicationApiDao(TbtskApplicationApiRepository tbtskApplicationApiDao) {
        this.tbtskApplicationApiDao = tbtskApplicationApiDao;
    }

    @Autowired
    public void setTaskResouceService(TaskResouceService taskResouceService) {
        this.taskResouceService = taskResouceService;
    }

    @Autowired
    public void setDataBizService(DataBizService dataBizService) {
        this.dataBizService = dataBizService;
    }

    @Autowired
    public void setTbtskFieldsRepository(TbtskFieldsRepository tbtskFieldsRepository) {
        this.tbtskFieldsRepository = tbtskFieldsRepository;
    }

    @Autowired
    public void setTbtskObjectinfoService(TbtskObjectinfoService tbtskObjectinfoService) {
        this.tbtskObjectinfoService = tbtskObjectinfoService;
    }

    @Autowired
    public void setBizDao(TskTaskBizRepository bizDao) {
        this.bizDao = bizDao;
    }

    @Autowired
    public void setExportDataService(ExportDataService exportDataService) {
        this.exportDataService = exportDataService;
    }

    @Autowired
    public void setSysConfigService(SysConfigService sysConfigService) {
        this.sysConfigService = sysConfigService;
    }

    @Autowired
    public void setTaskBusiCodeApater2_0Service(TaskBusiCodeApater2_0Service taskBusiCodeApater2_0Service) {
        this.taskBusiCodeApater2_0Service = taskBusiCodeApater2_0Service;
    }

    protected abstract String getApplicationCode();

    protected abstract String[] getApiConfig() throws Exception;

    @Transactional
    protected void createTask(JSONObject data, TbtskApplicationApi applicationApi) throws Exception {
        String objectid = applicationApi.getTableid();
        TbtskTemplate template = this.tbtskTemplateRepository.getByTableId(objectid);
        Assert.notNull((Object)template, (String)"\u672a\u627e\u5230\u4efb\u52a1\u6a21\u677f");
        String templateId = template.getId();
        String applicationcode = this.getApplicationCode();
        String xzqdm = this.getXzqdm(data);
        Assert.isTrue((xzqdm.length() >= 6 ? 1 : 0) != 0, (String)"\u884c\u653f\u533a\u4ee3\u7801\u5f02\u5e38");
        xzqdm = xzqdm.substring(0, 6);
        Assert.state((!xzqdm.endsWith("00") ? 1 : 0) != 0, (String)"\u884c\u653f\u533a\u7ea7\u522b\u975e\u533a\u53bf\u7ea7");
        String name = this.createTaskName(data);
        Long userId = applicationApi.getAdmin();
        Boolean newRow = false;
        String id = this.queryExistTaskId(xzqdm, templateId);
        TskTaskBiz tskTaskBiz = new TskTaskBiz();
        if (!StringUtil.isEmpty((String)id)) {
            tskTaskBiz = this.tskTaskBizService.findByTaskId(id);
            this.setTaskId(tskTaskBiz.getId());
            tskTaskBiz.setIsDel(Integer.valueOf(0));
            return;
        }
        newRow = true;
        tskTaskBiz.setType("2");
        tskTaskBiz.setFinish(Integer.valueOf(0));
        tskTaskBiz.setCreateTime(new Date());
        tskTaskBiz.setIsPublic(Integer.valueOf(0));
        tskTaskBiz.setTotal(Integer.valueOf(0));
        tskTaskBiz.setAssignCount(Integer.valueOf(0));
        tskTaskBiz.setStatus("1");
        Boolean unique = this.tskTaskBizService.checkTaskName(name, tskTaskBiz.getId(), "") == false;
        Assert.isTrue((boolean)unique, (String)"\u4efb\u52a1\u540d\u79f0\u91cd\u590d");
        tskTaskBiz.setSource("");
        tskTaskBiz.setName(name);
        int year = new Date().getYear();
        tskTaskBiz.setStartTime(new Date(year, 0, 1));
        tskTaskBiz.setEndTime(new Date(year + 1, 0, 1));
        tskTaskBiz.setUserId(userId.toString());
        tskTaskBiz.setGranularity(Integer.valueOf(3));
        tskTaskBiz.setMode(Integer.valueOf(1));
        Long classId = this.taskBusiCodeApater2_0Service.getClassIdByCode(applicationcode);
        if (StringUtils.isNotEmpty((CharSequence)applicationcode) && classId != null) {
            tskTaskBiz.setClassId(classId);
        }
        tskTaskBiz = this.tskTaskBizService.save(tskTaskBiz);
        if (StringUtils.isNotEmpty((CharSequence)templateId)) {
            tskTaskBiz.setAllowNew("1");
            tskTaskBiz.setNeedSign("1");
            tskTaskBiz.setAllowEdit("1");
            tskTaskBiz.setRedoAble(Integer.valueOf(1));
            tskTaskBiz.setPicConfig("");
            tskTaskBiz.setPicIsDefault(Integer.valueOf(1));
            this.templateCQService.instantiateTemplate(tskTaskBiz, templateId);
            tskTaskBiz = this.tskTaskBizService.saveRegions(tskTaskBiz, xzqdm);
            this.tskTaskBizService.finishCreateTsk(tskTaskBiz, userId);
        }
        if (newRow.booleanValue()) {
            UserBiz2 ub = new UserBiz2();
            ub.setUserId(userId);
            ub.setBizId(tskTaskBiz.getId());
            ub.setRole(Integer.valueOf(0));
            this.userBiz2Repository.save((Object)ub);
            this.exportDataService.export(tskTaskBiz.getId(), null, Boolean.valueOf(false), Boolean.valueOf(false), null, null, null);
        }
        this.setTaskId(tskTaskBiz.getId());
    }

    protected abstract void customFieldFormat(JSONObject var1, Map<String, Object> var2) throws Exception;

    public void authorize() throws FilterForbiddenException, Exception {
    }

    public String pretreatData(String data, TbtskApplicationApi applicationApi) throws Exception {
        return data;
    }

    public JSONArray formatData(String jsonStr, TbtskApplicationApi applicationApi) throws Exception {
        jsonStr = jsonStr.trim().replaceAll("^\\{", "[{").replaceAll("\\}$", "}]");
        return JSONArray.parseArray((String)jsonStr, (Feature[])new Feature[0]);
    }

    public TbtskApplicationApi getConfig() throws Exception {
        String apiname;
        if (this.applicationApi != null) {
            return this.applicationApi;
        }
        String namespace = this.getApiConfig()[0];
        TbtskApplicationApi api = this.tbtskApplicationApiDao.queryApplicationApi(namespace, apiname = this.getApiConfig()[1]);
        if (api == null) {
            throw new Exception("\u83b7\u53d6\u5173\u8054\u914d\u7f6e\u5931\u8d25");
        }
        return api;
    }

    protected String saveData(JSONArray array, TbtskApplicationApi applicationApi) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject object = array.getJSONObject(i);
            String fid = this.saveOneData(object, applicationApi);
            if ("".equals(fid)) continue;
            if (sb.length() == 0) {
                sb.append(fid);
                continue;
            }
            sb.append(",").append(fid);
        }
        this.setTbid(sb.toString());
        return sb.toString();
    }

    protected void exportData(String ids, TbtskApplicationApi applicationApi) throws Exception {
        if (!"".equals(ids)) {
            TskTaskBiz task = this.bizDao.getByTableId(this.getTableInfo(applicationApi).getfId());
            this.exportDataService.export(task.getId(), ids, Boolean.valueOf(false), Boolean.valueOf(false), null, "wydc", null);
        }
    }

    protected void resolveSystemField(Map map, String id) {
        if (map != null) {
            map.put("f_id", id);
            map.put("f_status", "1");
            map.put("f_createtime", System.currentTimeMillis() + "");
            map.put("f_userid", this.applicationApi.getAdmin());
            String xzqdmsys = (String)map.get("f_xzqdmsys");
            if (map.containsKey("f_xzqdm") && StringUtils.isBlank((CharSequence)xzqdmsys)) {
                String xzqdm = (String)map.get("f_xzqdm");
                map.put("f_xzqdmsys", xzqdm + "000000");
            }
        }
    }

    public final void importData(String jsonStr) throws FilterForbiddenException, Exception {
        this.authorize();
        this.applicationApi = this.getConfig();
        jsonStr = this.pretreatData(jsonStr, this.applicationApi);
        JSONArray jsonArr = this.formatData(jsonStr, this.applicationApi);
        String ids = this.saveData(jsonArr, this.applicationApi);
        this.exportData(ids, this.applicationApi);
    }

    private void reflectFields(JSONObject object, Map<String, String> mapping, List<TbtskFields> allFields, HashMap<String, Object> map, Map data) throws Exception {
        ArrayList list = new ArrayList();
        allFields.forEach(e -> list.add(e.getfFieldname()));
        for (TbtskFields field : allFields) {
            String str;
            String fieldName = field.getfFieldname();
            String fieldType = field.getfFieldtype();
            Integer outWork = field.getfIsOutwork();
            String type = TskTaskBizDBUtil.getDBType((String)fieldType);
            Integer nullable = null == outWork ? field.getfNullable() : Integer.valueOf(outWork == 1 ? 1 : field.getfNullable());
            Integer order = field.getfOrder();
            if (mapping.containsKey(fieldName) && StringUtils.isNotEmpty((CharSequence)(str = mapping.get(fieldName)))) {
                BysxzUtil.addDatatoMap(map, type, str, fieldName, nullable, order, object);
                continue;
            }
            if (data != null || "f_index".equalsIgnoreCase(fieldName) || fieldName.equals("f_lat") || fieldName.equals("f_lon")) continue;
            String value = field.getfDefaultvalue();
            if (type.equals(TskTaskBizDBUtil.getDBType((String)"5"))) {
                value = null;
            }
            map.put(fieldName, value);
            BysxzUtil.addDatatoMap(map, type, fieldName, fieldName, nullable, order, object);
        }
    }

    private String saveOneData(JSONObject object, TbtskApplicationApi applicationApi) throws Exception {
        String tableid = applicationApi.getTableid();
        if (1 == Optional.ofNullable(applicationApi.getAutoCreate()).orElse(0)) {
            this.createTask(object, applicationApi);
        } else {
            TskTaskBiz biz = this.tskTaskBizService.findByTableId(tableid);
            this.setTaskId(biz.getId());
        }
        Map mapping = this.taskResouceService.getFiledMap(tableid);
        TbtskObjectinfo table = this.getTableInfo(applicationApi);
        List allFields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(applicationApi.getTableid());
        String primary = applicationApi.getPrimary();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map dataMap = null;
        if (!StringUtils.isEmpty((CharSequence)primary)) {
            dataMap = this.dataBizService.selectByID(table.getfTablename(), primary, "'" + object.getString((String)mapping.get(primary)) + "'");
        }
        String f_id = "";
        this.reflectFields(object, mapping, allFields, map, dataMap);
        if (dataMap == null) {
            f_id = map.containsKey("tbid") && map.get("tbid") != null && !StringUtils.isEmpty((CharSequence)map.get("tbid").toString()) ? map.get("tbid").toString() : (map.containsKey("f_id") && map.get("f_id") != null && !StringUtils.isEmpty((CharSequence)map.get("f_id").toString()) ? map.get("f_id").toString() : UUID.randomUUID().toString());
        } else {
            f_id = (String)dataMap.get("f_id");
            if (object.containsKey((Object)"sendto") && !StringUtils.isEmpty((CharSequence)object.getString("sendto")) && mapping.containsKey("f_sendto")) {
                map.put("f_sendto", object.getString("sendto"));
            }
        }
        this.customFieldFormat(object, map);
        if (dataMap == null) {
            this.resolveSystemField(map, f_id);
            this.dataBizService.insertData(table.getfTablename(), map, "f_shape");
        } else {
            this.dataBizService.updateData(table.getfTablename(), map, primary + "='" + object.getString((String)mapping.get(primary)) + "'");
        }
        return f_id;
    }

    private TbtskObjectinfo getTableInfo(TbtskApplicationApi applicationApi) {
        if (1 == Optional.ofNullable(applicationApi.getAutoCreate()).orElse(0)) {
            Assert.notNull((Object)this.getTaskId());
            TskTaskBiz biz = (TskTaskBiz)this.bizDao.findById((Object)this.getTaskId()).orElseThrow(RuntimeException::new);
            return this.tbtskObjectinfoService.getObjectByTableId(biz.getTableId());
        }
        return this.tbtskObjectinfoService.getObjectByTableId(applicationApi.getTableid());
    }

    private String queryExistTaskId(String xzqdm, String templateId) throws Exception {
        Date currentDate = new Date();
        return this.tskTaskBizRepository.findBizByYearXzqAndTemplate(currentDate, xzqdm, templateId);
    }

    public String getData(String source) {
        return null;
    }

    public String formatData(String String2) {
        return null;
    }
}

