/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import com.alibaba.fastjson.JSONObject;
import com.dps.GPSUtil.GPSInfo;
import com.dps.GPSUtil.GPSUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class BysxzUtil {
    private static GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);

    public static void addDatatoMap(Map map, String fieldType, String rname, String fieldName, Integer nullable, Integer order, JSONObject object) throws Exception {
        DecimalFormat format = new DecimalFormat("######0.0000000");
        switch (fieldType) {
            case "varchar": {
                String value1 = BysxzUtil.getStrValue(object, rname);
                if (value1 == null || "null".equals(value1.toLowerCase()) || "".equals(value1)) {
                    if (order != null && nullable == 0) {
                        map.put(fieldName, "");
                        break;
                    }
                    map.put(fieldName, null);
                    break;
                }
                map.put(fieldName, value1);
                break;
            }
            case "decimal": {
                if ("f_lat".equals(fieldName) || "f_lon".equals(fieldName)) break;
                String tmp1 = BysxzUtil.getStrValue(object, rname);
                if (tmp1 == null || BysxzUtil.isMessyCode(tmp1) || "".equals(tmp1)) {
                    if (order != null && nullable == 0) {
                        map.put(fieldName, 0.0);
                        break;
                    }
                    map.put(fieldName, 0);
                    break;
                }
                Double value2 = Double.valueOf(tmp1);
                map.put(fieldName, value2);
                break;
            }
            case "int4": {
                String tmp2 = BysxzUtil.getStrValue(object, rname);
                if (tmp2 == null || BysxzUtil.isMessyCode(tmp2) || "".equals(tmp2)) {
                    if (order != null && nullable == 0) {
                        map.put(fieldName, 0);
                        break;
                    }
                    map.put(fieldName, 0);
                    break;
                }
                Integer value3 = Integer.valueOf(tmp2);
                map.put(fieldName, value3);
                break;
            }
            case "timestamp": {
                String tmp3 = BysxzUtil.getStrValue(object, rname);
                if (tmp3 == null || BysxzUtil.isMessyCode(tmp3) || "".equals(tmp3) || "0".equals(tmp3)) {
                    map.put(fieldName, null);
                    break;
                }
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                Date date = df.parse(tmp3);
                Timestamp value5 = new Timestamp(date.getTime());
                map.put(fieldName, value5);
                break;
            }
            case "text": {
                String value2 = BysxzUtil.getStrValue(object, rname);
                if (value2 == null || "null".equals(value2.toLowerCase()) || "".equals(value2)) {
                    if (order != null && nullable == 0) {
                        map.put(fieldName, "");
                        break;
                    }
                    map.put(fieldName, null);
                    break;
                }
                map.put(fieldName, value2);
                break;
            }
            case "geometry": {
                String wkt = BysxzUtil.getStrValue(object, rname);
                if (StringUtils.isEmpty((CharSequence)wkt)) {
                    map.put(fieldName, null);
                    break;
                }
                Geometry geo = WKTUtil.wktToGeom((String)BysxzUtil.getStrValue(object, rname));
                if ("f_shape".equalsIgnoreCase(fieldName)) {
                    if (geo == null) break;
                    map.put(fieldName, WKTUtil.geomToWkt((Geometry)geo));
                    map.put("f_shape1", WKTUtil.geomToWkt((Geometry)geo));
                    Point point = geo.getCentroid();
                    if (point != null) {
                        map.put("f_lat", format.format(point.getY()));
                        map.put("f_lon", format.format(point.getX()));
                        break;
                    }
                    map.put("f_lat", "0.0");
                    map.put("f_lon", "0.0");
                    break;
                }
                if ("f_shape_g".equalsIgnoreCase(fieldName)) {
                    Geometry geometry_g = BysxzUtil.convertGeometry(geo, 1);
                    map.put("f_shape_g", WKTUtil.geomToWkt((Geometry)geometry_g));
                    Point point_g = geometry_g.getCentroid();
                    if (point_g != null) {
                        map.put("f_lat_g", format.format(point_g.getY()));
                        map.put("f_lon_g", format.format(point_g.getX()));
                        break;
                    }
                    map.put("f_lat_g", "0.0");
                    map.put("f_lon_g", "0.0");
                    break;
                }
                if (!"f_shape_b".equalsIgnoreCase(fieldName)) break;
                Geometry geometry_b = BysxzUtil.convertGeometry(geo, 2);
                map.put("f_shape_b", WKTUtil.geomToWkt((Geometry)geometry_b));
                Point point_b = geometry_b.getCentroid();
                if (point_b != null) {
                    map.put("f_lat_b", format.format(point_b.getY()));
                    map.put("f_lon_b", format.format(point_b.getX()));
                    break;
                }
                map.put("f_lat_b", "0.0");
                map.put("f_lon_b", "0.0");
                break;
            }
        }
    }

    public static String getStrValue(JSONObject obj, String fieldName) {
        String val = "";
        try {
            if (obj != null && !obj.equals((Object)"")) {
                val = obj.getString(fieldName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static boolean isMessyCode(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != '\ufffd') continue;
            return true;
        }
        return false;
    }

    private static Geometry convertGeometry(Geometry geometry, int type) {
        Polygon result = null;
        if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry;
            Polygon[] garray = new Polygon[multiPolygon.getNumGeometries()];
            for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                Polygon polygon = (Polygon)multiPolygon.getGeometryN(i);
                garray[i] = BysxzUtil.convertPolygon((Geometry)polygon, type);
            }
            result = geometryFactory.createMultiPolygon(garray);
        } else if (geometry instanceof Geometry) {
            result = BysxzUtil.convertPolygon(geometry, type);
        }
        return result;
    }

    private static Polygon convertPolygon(Geometry geometry, int type) {
        Coordinate[] coords = new Coordinate[geometry.getCoordinates().length];
        if (geometry instanceof Polygon) {
            Polygon pg = (Polygon)geometry;
            LinearRing exteriorRing = pg.getExteriorRing();
            LinearRing lineString = BysxzUtil.convertLineString((LineString)exteriorRing, type);
            LinearRing[] holes = new LinearRing[pg.getNumInteriorRing()];
            for (int i = 0; i < pg.getNumInteriorRing(); ++i) {
                LinearRing lineString1;
                LinearRing interiorRingN = pg.getInteriorRingN(i);
                holes[i] = lineString1 = BysxzUtil.convertLineString((LineString)interiorRingN, type);
            }
            Polygon polygon = geometryFactory.createPolygon(lineString, holes);
            return polygon;
        }
        return null;
    }

    private static LinearRing convertLineString(LineString geometry, int type) {
        Coordinate[] coords = new Coordinate[geometry.getCoordinates().length];
        for (int i = 0; i < geometry.getCoordinates().length; ++i) {
            GPSInfo gpsInfo;
            if (type == 1) {
                gpsInfo = GPSUtil.WGS84_To_GCJ02((double)geometry.getCoordinates()[i].y, (double)geometry.getCoordinates()[i].x);
                coords[i] = new Coordinate(gpsInfo.GetLon(), gpsInfo.GetLat());
                continue;
            }
            if (type != 2) continue;
            gpsInfo = GPSUtil.WGS84_To_GCJ02((double)geometry.getCoordinates()[i].y, (double)geometry.getCoordinates()[i].x);
            gpsInfo = GPSUtil.GCJ02_To_BD09((double)gpsInfo.GetLat(), (double)gpsInfo.GetLon());
            coords[i] = new Coordinate(gpsInfo.GetLon(), gpsInfo.GetLat());
        }
        return geometryFactory.createLinearRing(coords);
    }
}

