/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class EsriGeoJsonUtil {
    public static String esri2geo(String ersiJson) {
        Map geoMap = EsriGeoJsonUtil.esri2geomap(ersiJson);
        return new JSONObject(geoMap).toString();
    }

    public static Map esri2geomap(String ersiJson) {
        HashMap<String, Object> geoMap = new HashMap<String, Object>();
        try {
            Object crs;
            ArrayList geoFs = new ArrayList();
            geoMap.put("type", "FeatureCollection");
            Map esriMap = (Map)JSON.parse((String)ersiJson, (Feature[])new Feature[0]);
            Object esriFs = esriMap.get("features");
            if (esriFs instanceof List) {
                esriFs = (List)esriFs;
                for (int i = 0; i < ((List)esriFs).size(); ++i) {
                    Map esriF = (Map)((List)esriFs).get(i);
                    HashMap<String, Object> geoF = new HashMap<String, Object>();
                    geoF.put("type", "Feature");
                    geoF.put("properties", esriF.get("attributes"));
                    Map geometry = (Map)esriF.get("geometry");
                    if (null != geometry.get("x")) {
                        geoF.put("geometry", EsriGeoJsonUtil.geoPoint(geometry));
                    } else if (null != geometry.get("points")) {
                        geoF.put("geometry", EsriGeoJsonUtil.geoPoints(geometry));
                    } else if (null != geometry.get("paths")) {
                        geoF.put("geometry", EsriGeoJsonUtil.geoLine(geometry));
                    } else if (null != geometry.get("rings")) {
                        geoF.put("geometry", EsriGeoJsonUtil.geoPoly(geometry));
                    }
                    geoFs.add(geoF);
                }
                geoMap.put("features", geoFs);
            }
            if ((crs = esriMap.get("spatialReference")) instanceof Map) {
                Map esriObject = (Map)crs;
                Integer crsid = (Integer)esriObject.get("wkid");
                HashMap<String, Object> crsObject = new HashMap<String, Object>();
                crsObject.put("type", "name");
                HashMap<String, String> crsName = new HashMap<String, String>();
                crsName.put("name", "EPSG:" + crsid);
                crsObject.put("properties", crsName);
                geoMap.put("crs", crsObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return geoMap;
    }

    public static String geo2ersi(String geoJson, String idAttribute) {
        Map esriMap = new HashMap();
        try {
            Map geoMap = (Map)JSON.parse((String)geoJson, (Feature[])new Feature[0]);
            esriMap = EsriGeoJsonUtil.getEsriGeo(geoMap, idAttribute);
            HashMap<String, Integer> spatialReference = new HashMap<String, Integer>();
            spatialReference.put("wkid", 4326);
            esriMap.put("spatialReference", spatialReference);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new JSONObject(esriMap).toString();
    }

    public static Map getEsriGeo(Map geoMap, String idAttribute) {
        String type;
        HashMap<String, Object> esriMap = new HashMap<String, Object>();
        idAttribute = StringUtils.isNotEmpty((CharSequence)idAttribute) ? idAttribute : "OBJECTID";
        switch (type = geoMap.get("type").toString()) {
            case "Point": {
                List coords = (List)geoMap.get("coordinates");
                esriMap.put("x", coords.get(0));
                esriMap.put("y", coords.get(1));
                break;
            }
            case "MultiPoint": {
                esriMap.put("points", geoMap.get("coordinates"));
                break;
            }
            case "LineString": {
                ArrayList coordsList = new ArrayList();
                coordsList.add(geoMap.get("coordinates"));
                esriMap.put("paths", coordsList);
                break;
            }
            case "MultiLineString": {
                esriMap.put("paths", geoMap.get("coordinates"));
                break;
            }
            case "Polygon": {
                List coordinates = (List)geoMap.get("coordinates");
                List<List<List<Number>>> rings = EsriGeoJsonUtil.orientRings(coordinates);
                esriMap.put("rings", rings);
                break;
            }
            case "MultiPolygon": {
                List mcoordinates = (List)geoMap.get("coordinates");
                List<List<List<Number>>> mrings = EsriGeoJsonUtil.flattenMultiPolygonRings(mcoordinates);
                esriMap.put("rings", mrings);
                break;
            }
            case "Feature": {
                if (null != geoMap.get("geometry")) {
                    Map geometry = EsriGeoJsonUtil.getEsriGeo((Map)geoMap.get("geometry"), idAttribute);
                    esriMap.put("geometry", geometry);
                }
                if (null == geoMap.get("properties")) break;
                Map properties = (Map)geoMap.get("properties");
                if (null != geoMap.get("id")) {
                    properties.put(idAttribute, geoMap.get("id"));
                }
                esriMap.put("attributes", properties);
                break;
            }
            case "FeatureCollection": {
                ArrayList<Map> esriFs = new ArrayList<Map>();
                List features = (List)geoMap.get("features");
                for (int i = 0; i < features.size(); ++i) {
                    esriFs.add(EsriGeoJsonUtil.getEsriGeo((Map)features.get(i), idAttribute));
                }
                esriMap.put("features", esriFs);
                esriMap.put("geometryType", "esriGeometryPolygon");
                break;
            }
            case "GeometryCollection": {
                ArrayList<Map> esriFsc = new ArrayList<Map>();
                List geometries = (List)geoMap.get("geometries");
                for (int i = 0; i < geometries.size(); ++i) {
                    esriFsc.add(EsriGeoJsonUtil.getEsriGeo((Map)geometries.get(i), idAttribute));
                }
                esriMap.put("geometries", esriFsc);
                esriMap.put("geometryType", "esriGeometryPolygon");
            }
        }
        return esriMap;
    }

    public static Map geoPoint(Map<String, Object> geometry) {
        HashMap<String, Object> geo = new HashMap<String, Object>();
        geo.put("type", "point");
        BigDecimal x = (BigDecimal)geometry.get("x");
        BigDecimal y = (BigDecimal)geometry.get("y");
        ArrayList<BigDecimal> coords = new ArrayList<BigDecimal>();
        coords.add(x);
        coords.add(y);
        geo.put("coordinates", coords);
        return geo;
    }

    public static Map geoPoints(Map<String, Object> geometry) {
        HashMap<String, Object> geo = new HashMap<String, Object>();
        List points = (List)geometry.get("points");
        if (points.size() == 1) {
            geo.put("type", "Point");
            geo.put("coordinates", points.get(0));
        } else {
            geo.put("type", "MultiPoint");
            geo.put("coordinates", points);
        }
        return geo;
    }

    public static Map geoLine(Map<String, Object> geometry) {
        HashMap<String, Object> geo = new HashMap<String, Object>();
        List paths = (List)geometry.get("paths");
        if (paths.size() == 1) {
            geo.put("type", "LineString");
            geo.put("coordinates", paths.get(0));
        } else {
            geo.put("type", "MultiLineString");
            geo.put("coordinates", paths);
        }
        return geo;
    }

    public static Map geoPoly(Map<String, Object> geometry) {
        HashMap<String, Object> geo = new HashMap<String, Object>();
        List rings = (List)geometry.get("rings");
        if (rings.size() == 1) {
            geo.put("type", "Polygon");
            geo.put("coordinates", rings);
        } else {
            ArrayList coords = new ArrayList();
            String type = "";
            int len = coords.size() - 1;
            for (int i = 0; i < rings.size(); ++i) {
                if (EsriGeoJsonUtil.ringIsClockwise((List)rings.get(i))) {
                    ArrayList item = new ArrayList();
                    item.add(rings.get(i));
                    coords.add(item);
                    ++len;
                    continue;
                }
                ((List)coords.get(len)).add(rings.get(i));
            }
            type = coords.size() == 1 ? "Polygon" : "MultiPolygon";
            geo.put("type", type);
            geo.put("coordinates", coords.size() == 1 ? coords.get(0) : coords);
        }
        return geo;
    }

    public static boolean ringIsClockwise(List<List<Number>> rings) {
        double total = 0.0;
        List<Number> pt1 = null;
        List<Number> pt2 = null;
        for (int i = 0; i < rings.size() - 1; ++i) {
            pt1 = rings.get(i);
            pt2 = rings.get(i + 1);
            total += (pt2.get(0).doubleValue() - pt1.get(0).doubleValue()) * (pt2.get(1).doubleValue() + pt1.get(1).doubleValue());
        }
        return total >= 0.0;
    }

    public static List<List<List<Number>>> orientRings(List<List<List<Number>>> polygon) {
        ArrayList<List<List<Number>>> ringsList = new ArrayList<List<List<Number>>>();
        List<List<Number>> outerRing = EsriGeoJsonUtil.closeRing(polygon.get(0));
        if (outerRing.size() >= 4) {
            if (!EsriGeoJsonUtil.ringIsClockwise(outerRing)) {
                Collections.reverse(outerRing);
            }
            ringsList.add(outerRing);
            polygon.remove(0);
            for (int i = 0; i < polygon.size(); ++i) {
                List<List<Number>> hole = EsriGeoJsonUtil.closeRing(polygon.get(i));
                if (hole.size() < 4) continue;
                if (EsriGeoJsonUtil.ringIsClockwise(hole)) {
                    Collections.reverse(hole);
                }
                ringsList.add(hole);
            }
        }
        return ringsList;
    }

    public static List<List<Number>> closeRing(List<List<Number>> coords) {
        if (!EsriGeoJsonUtil.pointsEqual(coords.get(0), coords.get(coords.size() - 1))) {
            coords.add(coords.get(0));
        }
        return coords;
    }

    public static boolean pointsEqual(List<Number> a, List<Number> b) {
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).doubleValue() - b.get(i).doubleValue() == 0.0) continue;
            return false;
        }
        return true;
    }

    public static List<List<List<Number>>> flattenMultiPolygonRings(List<List<List<List<Number>>>> rings) {
        ArrayList<List<List<Number>>> polygonList = new ArrayList<List<List<Number>>>();
        for (int i = 0; i < rings.size(); ++i) {
            List<List<List<Number>>> polygons = EsriGeoJsonUtil.orientRings(rings.get(i));
            for (int x = polygons.size() - 1; x >= 0; --x) {
                List<List<Number>> polygon = polygons.get(x);
                polygonList.add(polygon);
            }
        }
        return polygonList;
    }
}

