/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ExportFileUtil {
    public static boolean deleteFileAndDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = ExportFileUtil.deleteFileAndDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static List<String> findFiles(String baseDirName, String targetFileName) {
        ArrayList<String> fileList = new ArrayList<String>();
        String tempName = null;
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            System.out.println("\u6587\u4ef6\u67e5\u627e\u5931\u8d25\uff1a" + baseDirName + "\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\uff01");
        } else {
            String[] filelist = baseDir.list();
            for (int i = 0; i < filelist.length; ++i) {
                File readfile = new File(baseDirName + File.separator + filelist[i]);
                if (!readfile.isDirectory()) {
                    tempName = readfile.getName();
                    if (!ExportFileUtil.wildcardMatch(targetFileName, tempName)) continue;
                    fileList.add(readfile.getAbsolutePath());
                    continue;
                }
                if (!readfile.isDirectory()) continue;
                fileList.addAll(ExportFileUtil.findFiles(baseDirName + File.separator + filelist[i], targetFileName));
            }
        }
        return fileList;
    }

    private static boolean wildcardMatch(String pattern, String str) {
        int patternLength = pattern.length();
        int strLength = str.length();
        int strIndex = 0;
        for (int patternIndex = 0; patternIndex < patternLength; ++patternIndex) {
            char ch = pattern.charAt(patternIndex);
            if (ch == '*') {
                while (strIndex < strLength) {
                    if (ExportFileUtil.wildcardMatch(pattern.substring(patternIndex + 1), str.substring(strIndex))) {
                        return true;
                    }
                    ++strIndex;
                }
                continue;
            }
            if (ch == '?') {
                if (++strIndex <= strLength) continue;
                return false;
            }
            if (strIndex >= strLength || ch != str.charAt(strIndex)) {
                return false;
            }
            ++strIndex;
        }
        return strIndex == strLength;
    }
}

