/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class FileUtil {
    public static boolean deleteFileAndDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtil.deleteFileAndDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static List<String> findFiles(String baseDirName, String targetFileName) {
        ArrayList<String> fileList = new ArrayList<String>();
        String tempName = null;
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            System.out.println("\u6587\u4ef6\u67e5\u627e\u5931\u8d25\uff1a" + baseDirName + "\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\uff01");
        } else {
            String[] filelist = baseDir.list();
            for (int i = 0; i < filelist.length; ++i) {
                File readfile = new File(baseDirName + File.separator + filelist[i]);
                if (!readfile.isDirectory()) {
                    tempName = readfile.getName();
                    if (!FileUtil.wildcardMatch(targetFileName, tempName)) continue;
                    fileList.add(readfile.getAbsolutePath());
                    continue;
                }
                if (!readfile.isDirectory()) continue;
                fileList.addAll(FileUtil.findFiles(baseDirName + File.separator + filelist[i], targetFileName));
            }
        }
        return fileList;
    }

    private static boolean wildcardMatch(String pattern, String str) {
        int patternLength = pattern.length();
        int strLength = str.length();
        int strIndex = 0;
        for (int patternIndex = 0; patternIndex < patternLength; ++patternIndex) {
            char ch = pattern.charAt(patternIndex);
            if (ch == '*') {
                while (strIndex < strLength) {
                    if (FileUtil.wildcardMatch(pattern.substring(patternIndex + 1), str.substring(strIndex))) {
                        return true;
                    }
                    ++strIndex;
                }
                continue;
            }
            if (ch == '?') {
                if (++strIndex <= strLength) continue;
                return false;
            }
            if (strIndex >= strLength || ch != str.charAt(strIndex)) {
                return false;
            }
            ++strIndex;
        }
        return strIndex == strLength;
    }

    public static List<String> findDirectorys(String baseDirName, String targetFileName) {
        ArrayList<String> fileList = new ArrayList<String>();
        String tempName = null;
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            System.out.println("\u6587\u4ef6\u67e5\u627e\u5931\u8d25\uff1a" + baseDirName + "\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\uff01");
        } else {
            String[] filelist = baseDir.list();
            for (int i = 0; i < filelist.length; ++i) {
                File readfile = new File(baseDirName + File.separator + filelist[i]);
                tempName = readfile.getName();
                if (FileUtil.wildcardMatch(targetFileName, tempName)) {
                    fileList.add(readfile.getAbsolutePath());
                    continue;
                }
                if (!readfile.isDirectory()) continue;
                fileList.addAll(FileUtil.findDirectorys(baseDirName + File.separator + filelist[i], targetFileName));
            }
        }
        return fileList;
    }

    public static void copyFile(String inFilePath, String outFilePath) throws IOException {
        File in = new File(inFilePath);
        File out = new File(outFilePath);
        if (!out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
            out.createNewFile();
        }
        FileUtil.copyFileUsingFileStreams(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingFileStreams(File in, File out) throws IOException {
        InputStream input = null;
        OutputStream output = null;
        try {
            int bytesRead;
            input = new FileInputStream(in);
            output = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            while ((bytesRead = input.read(buf)) > 0) {
                output.write(buf, 0, bytesRead);
            }
        }
        finally {
            input.close();
            output.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileByte(String file) throws IOException {
        byte[] bytes = null;
        ByteArrayOutputStream byteOut = null;
        FileInputStream fileInsS = null;
        try {
            int len;
            File f = new File(file);
            fileInsS = new FileInputStream(f);
            byte[] buffer = new byte[1024];
            byteOut = new ByteArrayOutputStream();
            while ((len = fileInsS.read(buffer)) != -1) {
                byteOut.write(buffer, 0, len);
            }
            byteOut.flush();
            bytes = byteOut != null ? byteOut.toByteArray() : null;
        }
        finally {
            if (fileInsS != null) {
                fileInsS.close();
            }
            if (byteOut != null) {
                byteOut.close();
            }
        }
        return bytes;
    }

    public static void downloadExcelFile(HttpServletResponse resp, byte[] fileBytes, String fileName) throws IOException {
        resp.setContentType("application/vnd.ms-excel;charset=UTF-8");
        resp.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        FileUtil.processingByte(resp, fileBytes);
    }

    public static void downloadJsonFile(HttpServletResponse resp, byte[] fileBytes, String fileName) throws IOException {
        resp.setHeader("content-type", "application/json");
        resp.setContentType("application/octet-stream");
        resp.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        FileUtil.processingByte(resp, fileBytes);
    }

    public static void downloadXmlFile(HttpServletResponse resp, byte[] fileBytes, String fileName) throws IOException {
        resp.setHeader("content-type", "application/octet-stream");
        resp.setContentType("application/octet-stream");
        resp.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        FileUtil.processingByte(resp, fileBytes);
    }

    public static void processingByte(HttpServletResponse resp, byte[] fileBytes) throws IOException {
        byte[] buff = new byte[1024];
        ServletOutputStream outputStream = null;
        try (BufferedInputStream bufferedInputStream = null;){
            outputStream = resp.getOutputStream();
            bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(fileBytes), fileBytes.length);
            int num = bufferedInputStream.read(buff);
            while (num != -1) {
                outputStream.write(buff, 0, num);
                outputStream.flush();
                num = bufferedInputStream.read(buff);
            }
        }
    }
}

