/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.geojson.GeoJSON;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeoUtils {
    public static GiLoger logger = GwLoger.getLoger(GeoUtils.class);

    public static Geometry geojsonToGeom(String geojson) throws Exception {
        GeometryJSON geometryJSON = new GeometryJSON(8);
        Geometry geometry = geometryJSON.read((Object)geojson);
        return geometry;
    }

    public static Geometry geojson2Geom(String geojson) throws Exception {
        FeatureJSON fjson_15 = new FeatureJSON(new GeometryJSON(8));
        FeatureCollection featureCollection = fjson_15.readFeatureCollection((Object)geojson);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        GeoJSON.write((Object)featureCollection, (Object)ostream);
        SimpleFeatureIterator iterator = (SimpleFeatureIterator)featureCollection.features();
        ArrayList<Polygon> geometriesList = new ArrayList<Polygon>();
        while (iterator.hasNext()) {
            SimpleFeature simpleFeature = (SimpleFeature)iterator.next();
            Polygon geom = (Polygon)simpleFeature.getDefaultGeometry();
            geometriesList.add(geom);
        }
        if (geometriesList.isEmpty()) {
            return null;
        }
        if (geometriesList.size() == 1) {
            return (Geometry)geometriesList.get(0);
        }
        GeometryFactory factory = new GeometryFactory();
        Polygon[] geometries = new Polygon[geometriesList.size()];
        for (int i = 0; i < geometriesList.size(); ++i) {
            geometries[i] = (Polygon)geometriesList.get(i);
        }
        MultiPolygon multiPolygon = new MultiPolygon(geometries, factory);
        iterator.close();
        return multiPolygon;
    }

    public static Geometry geojson2Geom4490(String geojson) throws Exception {
        return GeoUtils.geojson2Geom4490(geojson, true);
    }

    public static Geometry geojson2Geom4490(String geojson, boolean revert) throws Exception {
        List<Geometry> geoms = GeoUtils.geojson2Geoms4490(geojson, revert);
        ArrayList<Polygon> geometriesList = new ArrayList<Polygon>();
        for (Geometry geometry : geoms) {
            Polygon geom = (Polygon)geometry;
            geometriesList.add(geom);
        }
        if (geometriesList.isEmpty()) {
            return null;
        }
        if (geometriesList.size() == 1) {
            return (Geometry)geometriesList.get(0);
        }
        GeometryFactory factory = new GeometryFactory();
        Polygon[] geometries = new Polygon[geometriesList.size()];
        for (int i = 0; i < geometriesList.size(); ++i) {
            geometries[i] = (Polygon)geometriesList.get(i);
        }
        MultiPolygon multiPolygon = new MultiPolygon(geometries, factory);
        return multiPolygon;
    }

    public static List<Geometry> geojson2Geoms(String geojson) throws Exception {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        FeatureJSON fjson_15 = new FeatureJSON(new GeometryJSON(8));
        FeatureCollection featureCollection = fjson_15.readFeatureCollection((Object)geojson);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        GeoJSON.write((Object)featureCollection, (Object)ostream);
        SimpleFeatureIterator iterator = (SimpleFeatureIterator)featureCollection.features();
        while (iterator.hasNext()) {
            SimpleFeature simpleFeature = (SimpleFeature)iterator.next();
            Geometry geom = (Geometry)simpleFeature.getDefaultGeometry();
            geoms.add(geom);
        }
        iterator.close();
        return geoms;
    }

    public static List<Geometry> geojson2Geoms4490(String geojson) throws Exception {
        return GeoUtils.geojson2Geoms4490(geojson, true);
    }

    public static List<Geometry> geojson2Geoms4490(String geojson, boolean revert) throws Exception {
        Map geojsonMap = (Map)JSONObject.parseObject((String)geojson, Map.class);
        String crs = "EPSG:4490";
        String rex = "epsg.*([1-9]*?)";
        Pattern pattern = Pattern.compile(rex);
        if (geojsonMap.containsKey("crs") && null != geojsonMap.get("crs")) {
            JSONObject obj;
            Map crsMap = (Map)geojsonMap.get("crs");
            String EPSG = ((String)((Map)crsMap.get("properties")).get("name")).toLowerCase();
            Matcher matcher = pattern.matcher(EPSG);
            if (matcher.find()) {
                crs = "EPSG:" + matcher.group().replaceAll("[^0-9]", "");
            }
            if (!crs.equals("EPSG:4490") && (obj = JSONObject.parseObject((String)geojson)).getString("features") != null) {
                JSONArray feas = obj.getJSONArray("features");
                for (int i = 0; i < feas.size(); ++i) {
                    String type;
                    JSONObject geoObj;
                    JSONObject feaobj = feas.getJSONObject(i);
                    if (feaobj.getString("geometry") == null || !(geoObj = feaobj.getJSONObject("geometry")).containsKey((Object)"type") || !(type = geoObj.getString("type")).equals("Polygon")) continue;
                    JSONArray coordinates = geoObj.getJSONArray("coordinates");
                    if (revert) {
                        JSONArray coordinatesf = GeoUtils.reverCoordinates(coordinates);
                        geoObj.put("coordinates", (Object)coordinatesf);
                        continue;
                    }
                    geoObj.put("coordinates", (Object)coordinates);
                }
                geojson = obj.toJSONString();
            }
        }
        List<Geometry> geoms = GeoUtils.geojson2Geoms(geojson);
        ArrayList<Geometry> newgeoms = new ArrayList<Geometry>();
        for (Geometry geom : geoms) {
            if (!crs.equals("EPSG:4490")) {
                MathTransform transform_1 = CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)crs), (CoordinateReferenceSystem)CRS.decode((String)"EPSG:4490"), (boolean)true);
                geom = JTS.transform((Geometry)geom, (MathTransform)transform_1);
                String geojsonzh = GeoUtils.getgeojson(geom);
                JSONObject obj = JSONObject.parseObject((String)geojsonzh);
                JSONArray coordinates = obj.getJSONArray("coordinates");
                if (revert) {
                    JSONArray coordinatesf = GeoUtils.reverCoordinates(coordinates);
                    obj.put("coordinates", (Object)coordinatesf);
                } else {
                    obj.put("coordinates", (Object)coordinates);
                }
                geojsonzh = obj.toJSONString();
                geom = GeoUtils.geojsonToGeom(geojsonzh);
            }
            newgeoms.add(geom);
        }
        return newgeoms;
    }

    public static JSONArray reverCoordinates(JSONArray coordinates) {
        JSONArray coordinatesf = new JSONArray();
        for (int m = 0; m < coordinates.size(); ++m) {
            JSONArray coordinate = coordinates.getJSONArray(m);
            JSONArray coordinatef = new JSONArray();
            for (int n = 0; n < coordinate.size(); ++n) {
                JSONArray point = coordinate.getJSONArray(n);
                JSONArray pointf = new JSONArray();
                pointf.add(0, (Object)point.getBigDecimal(1));
                pointf.add(1, (Object)point.getBigDecimal(0));
                coordinatef.add((Object)pointf);
            }
            coordinatesf.add((Object)coordinatef);
        }
        return coordinatesf;
    }

    public static String getgeojson(Geometry geometry) throws IOException {
        String geojson = "";
        StringWriter writer = new StringWriter();
        GeometryJSON g = new GeometryJSON(15);
        g.write(geometry, (Object)writer);
        geojson = writer.toString();
        return geojson;
    }

    public static List<Geometry> geojson2Geom4496(String geojson) throws Exception {
        Map crsMap;
        String EPSG;
        Matcher matcher;
        Map geojsonMap = (Map)JSONObject.parseObject((String)geojson, Map.class);
        String crs = "EPSG:4490";
        String rex = "epsg.*([1-9]*?)";
        Pattern pattern = Pattern.compile(rex);
        if (geojsonMap.containsKey("crs") && null != geojsonMap.get("crs") && (matcher = pattern.matcher(EPSG = ((String)((Map)(crsMap = (Map)geojsonMap.get("crs")).get("properties")).get("name")).toLowerCase())).find()) {
            crs = "EPSG:" + matcher.group().replaceAll("[^0-9]", "");
        }
        List<Geometry> geoms = GeoUtils.geojson2Geoms(geojson);
        ArrayList<Geometry> newgeoms = new ArrayList<Geometry>();
        for (Geometry geom : geoms) {
            boolean geographicFlag = true;
            if (geom.getCentroid() != null) {
                int X;
                double centerX = geom.getCentroid().getX();
                NumberFormat nf = NumberFormat.getInstance();
                nf.setGroupingUsed(false);
                String xstr = nf.format(centerX);
                if (xstr.indexOf(".") > -1) {
                    xstr = xstr.substring(0, xstr.indexOf("."));
                }
                if ((X = Integer.parseInt(xstr)) > 180 || X < -180) {
                    geographicFlag = false;
                }
            }
            if (geographicFlag) {
                MathTransform transform_1 = CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)crs), (CoordinateReferenceSystem)CRS.decode((String)"EPSG:4496"), (boolean)true);
                geom = JTS.transform((Geometry)geom, (MathTransform)transform_1);
            }
            newgeoms.add(geom);
        }
        return newgeoms;
    }

    public static Geometry getAreaGeometry(Geometry geom) throws FactoryException, TransformException {
        String crs = "EPSG:4490";
        MathTransform transform_1 = CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)crs), (CoordinateReferenceSystem)CRS.decode((String)"EPSG:4496"), (boolean)true);
        geom = JTS.transform((Geometry)geom, (MathTransform)transform_1);
        return geom;
    }

    public static Integer getCrsByLon(Double lon, Integer zoning) {
        Integer zoningNum = (int)((lon + 1.5) / 3.0);
        Integer crsId = zoning == 3 ? Integer.valueOf(4513 + zoningNum - 25) : Integer.valueOf(4491 + zoningNum - 25);
        return crsId;
    }

    public static Geometry geoTransform(Geometry geom, String fromCrsWkt, String toCrs) throws FactoryException, TransformException {
        MathTransform transform_1 = CRS.findMathTransform((CoordinateReferenceSystem)CRS.parseWKT((String)fromCrsWkt), (CoordinateReferenceSystem)CRS.decode((String)toCrs), (boolean)true);
        geom = JTS.transform((Geometry)geom, (MathTransform)transform_1);
        return geom;
    }
}

