/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;

public class GeometryClockwiseUtil {
    public static Geometry EnclockwiseGeometry(Geometry geom) {
        Object geometry;
        if ("multipolygon".equalsIgnoreCase(geom.getGeometryType())) {
            Polygon[] polygons = new Polygon[geom.getNumGeometries()];
            for (int j = 0; j < polygons.length; ++j) {
                polygons[j] = GeometryClockwiseUtil.clockwiseSortPolygonCoords((Polygon)geom.getGeometryN(j));
            }
            geometry = new GeometryFactory(new PrecisionModel(), 4490).createMultiPolygon(polygons);
        } else {
            geometry = "polygon".equalsIgnoreCase(geom.getGeometryType()) ? GeometryClockwiseUtil.clockwiseSortPolygonCoords((Polygon)geom) : geom;
        }
        return geometry;
    }

    public static Polygon clockwiseSortPolygonCoords(Polygon poly) {
        Coordinate[] coordinates = poly.getCoordinates();
        ArrayList<Coordinate> lc = new ArrayList<Coordinate>(Arrays.asList(coordinates));
        if (!((Coordinate)lc.get(lc.size() - 1)).equals2D((Coordinate)lc.get(0))) {
            lc.set(lc.size() - 1, (Coordinate)lc.get(0));
        }
        if (!GeometryClockwiseUtil.ringIsClockwise(coordinates)) {
            Collections.reverse(lc);
        }
        coordinates = lc.toArray(coordinates);
        return new GeometryFactory(new PrecisionModel(), 4490).createPolygon(coordinates);
    }

    public static Boolean coordCmp(Coordinate a, Coordinate b, Coordinate center) {
        double det = (a.x - center.x) * (b.y - center.y) - (b.x - center.x) * (a.y - center.x);
        return det <= 0.0;
    }

    public static boolean ringIsClockwise(Coordinate[] rings) {
        double total = 0.0;
        Coordinate pt1 = null;
        Coordinate pt2 = null;
        for (int i = 0; i < rings.length - 1; ++i) {
            pt1 = rings[i];
            pt2 = rings[i + 1];
            total += (pt2.x - pt1.x) * (pt2.y + pt1.y);
        }
        return total >= 0.0;
    }
}

