/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import java.nio.charset.CodingErrorAction;
import org.apache.http.Consts;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpClientPool {
    private static final int GET_MAP_MAX_CONN = 200;
    private static final int GET_MAP_MAX_ROUTE_CONN = 10;
    private static final int MAX_CONN = 200;
    private static final int MAX_ROUTE_CONN = 20;
    private static PoolingHttpClientConnectionManager httpConnectionManager = new PoolingHttpClientConnectionManager();
    private static CloseableHttpClient httpClient;

    public static synchronized CloseableHttpClient getHttpClient() {
        if (httpClient == null) {
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)httpConnectionManager).build();
        }
        return httpClient;
    }

    public static synchronized CloseableHttpClient buildHttpClient(int conn, int routeConn) {
        CloseableHttpClient httpClient = null;
        PoolingHttpClientConnectionManager getMapHttpConnectionManager = new PoolingHttpClientConnectionManager();
        getMapHttpConnectionManager.setMaxTotal(conn);
        getMapHttpConnectionManager.setDefaultMaxPerRoute(routeConn);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).build();
        getMapHttpConnectionManager.setDefaultConnectionConfig(connectionConfig);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)getMapHttpConnectionManager).build();
        return httpClient;
    }

    public static synchronized CloseableHttpClient buildHttpClientByParm(int conn, int routeConn, int soTimeout, boolean soKeepAlive) {
        CloseableHttpClient httpClient = null;
        PoolingHttpClientConnectionManager getMapHttpConnectionManager = new PoolingHttpClientConnectionManager();
        getMapHttpConnectionManager.setMaxTotal(conn);
        getMapHttpConnectionManager.setDefaultMaxPerRoute(routeConn);
        getMapHttpConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(soTimeout).setSoKeepAlive(soKeepAlive).build());
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).build();
        getMapHttpConnectionManager.setDefaultConnectionConfig(connectionConfig);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)getMapHttpConnectionManager).build();
        return httpClient;
    }

    static {
        httpConnectionManager.setMaxTotal(200);
        httpConnectionManager.setDefaultMaxPerRoute(20);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).build();
        httpConnectionManager.setDefaultConnectionConfig(connectionConfig);
    }
}

