/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.service.thirddata.utils.MyX509TrustManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class HttpConnectionUtilCQ {
    private static String keyStoreFile;
    private static String keyStorePass;

    @Value(value="${security.keyStoreFile:}")
    public void setKeyStoreFile(String keyStoreFile) {
        HttpConnectionUtilCQ.keyStoreFile = keyStoreFile;
    }

    @Value(value="${security.keyStorePassWord:}")
    public void setKeyStorePass(String keyStorePass) {
        HttpConnectionUtilCQ.keyStorePass = keyStorePass;
    }

    public static String AccessUrl(String url, String postString) throws IOException {
        String result;
        block10: {
            result = null;
            HttpURLConnection conn = null;
            OutputStream os = null;
            InputStream is = null;
            try {
                String line;
                URL postUrl = new URL(url);
                conn = (HttpURLConnection)postUrl.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setUseCaches(false);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                conn.setConnectTimeout(30000);
                conn.setReadTimeout(300000);
                os = conn.getOutputStream();
                os.write(postString.getBytes("utf-8"));
                os.flush();
                int code = conn.getResponseCode();
                conn.getHeaderFields();
                conn.getContentLength();
                if (code == 200) {
                    String line2;
                    is = conn.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
                    StringBuffer buffer = new StringBuffer();
                    while ((line2 = reader.readLine()) != null) {
                        buffer.append(line2);
                    }
                    result = buffer.toString();
                    break block10;
                }
                is = conn.getErrorStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
                StringBuffer buffer = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    buffer.append(line);
                }
                throw new IOException(buffer.toString());
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (os != null) {
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("message", (Object)postString);
        json.put("result", (Object)result);
        return json.toJSONString();
    }

    public static String doPostFormdata(String url, Map<String, String> data) throws Exception {
        return HttpConnectionUtilCQ.doPostFormdata(url, data, null, null, null);
    }

    public static String doPostFormdata(String url, Map<String, String> data, Map<String, String> header) throws Exception {
        return HttpConnectionUtilCQ.doPostFormdata(url, data, header, null, null);
    }

    public static String doPostFormdata(String url, Map<String, String> data, Map<String, String> header, File file, String filekey) throws Exception {
        HttpHeaders requestHeaders = new HttpHeaders();
        if (null != header) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                requestHeaders.add(entry.getKey(), entry.getValue());
            }
        }
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        if (null != data) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                requestBody.add((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        if (null != file) {
            FileSystemResource resource = new FileSystemResource(file);
            requestBody.add((Object)filekey, (Object)resource);
        }
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((Object)requestBody, (MultiValueMap)requestHeaders);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        return (String)responseEntity.getBody();
    }

    public static String doPostJson(String url, String json, Map<String, String> header) throws Exception {
        TrustManager[] tm = new TrustManager[]{new MyX509TrustManager(keyStoreFile, keyStorePass)};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tm, new SecureRandom());
        CloseableHttpClient client = HttpClients.custom().setSSLHostnameVerifier((host, session) -> true).setSslcontext(sslContext).build();
        HttpPost post = new HttpPost(url);
        String result = null;
        try {
            if (null != header) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            ByteArrayEntity entity = new ByteArrayEntity(json.getBytes("UTF-8"));
            entity.setContentType("application/json");
            post.setEntity((HttpEntity)entity);
            HttpResponse res = client.execute((HttpUriRequest)post);
            if (res.getStatusLine().getStatusCode() == 200) {
                result = EntityUtils.toString((HttpEntity)res.getEntity());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static String postFormDataHttps(String url, Map<String, String> data) throws Exception {
        return HttpConnectionUtilCQ.postFormDataHttps(url, data, null);
    }

    public static String postFormDataHttps(String url, Map<String, String> data, Map<String, String> header) throws Exception {
        HttpResponse response;
        TrustManager[] tm = new TrustManager[]{new MyX509TrustManager(keyStoreFile, keyStorePass)};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tm, new SecureRandom());
        CloseableHttpClient client = HttpClients.custom().setSSLHostnameVerifier((host, session) -> true).setSslcontext(sslContext).build();
        HttpPost post = new HttpPost(url);
        if (null != header) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                post.addHeader(entry.getKey(), entry.getValue());
            }
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        if (null != data) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                params.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        if (params.size() > 0) {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, "UTF-8");
            post.setEntity((HttpEntity)entity);
        }
        if ((response = client.execute((HttpUriRequest)post)) != null && response.getStatusLine().getStatusCode() == 200) {
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        throw new Exception("Https Response Failed :" + response.getStatusLine().getStatusCode());
    }

    public static String postMultipartHttps(String url, Map<String, String> data, Map<String, String> header, File file, String filekey) throws Exception {
        TrustManager[] tm = new TrustManager[]{new MyX509TrustManager(keyStoreFile, keyStorePass)};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tm, new SecureRandom());
        CloseableHttpClient client = HttpClients.custom().setSSLHostnameVerifier((host, session) -> true).setSslcontext(sslContext).build();
        HttpPost post = new HttpPost(url);
        if (null != header) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                post.addHeader(entry.getKey(), entry.getValue());
            }
        }
        MultipartEntityBuilder entity = MultipartEntityBuilder.create();
        entity.setCharset(Charset.forName("UTF-8"));
        if (null != data) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                entity.addTextBody(entry.getKey(), entry.getValue());
            }
        }
        if (file != null) {
            entity.addPart(filekey, (ContentBody)new FileBody(file, ContentType.APPLICATION_OCTET_STREAM));
        }
        HttpEntity httpEntity = entity.build();
        post.setEntity(httpEntity);
        HttpResponse response = client.execute((HttpUriRequest)post);
        if (response != null && response.getStatusLine().getStatusCode() == 200) {
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        throw new Exception("Https Response Failed :" + response.getStatusLine().getStatusCode());
    }
}

