/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    public static final String CONTENT_TYPE_JSON_CHARSET_UTF8 = "application/json;charset=utf-8";
    public static final String CHARSET_UTF8 = "UTF-8";

    public static String JsonPostInvoke(String url, String jsonString) throws Exception {
        CloseableHttpClient httpClient = HttpUtil.buildHttpClient(false);
        HttpPost method = new HttpPost(url);
        if (StringUtils.isNotBlank((CharSequence)jsonString)) {
            StringEntity entity = new StringEntity(jsonString, CHARSET_UTF8);
            entity.setContentEncoding(CHARSET_UTF8);
            entity.setContentType(CONTENT_TYPE_JSON_CHARSET_UTF8);
            method.setEntity((HttpEntity)entity);
        }
        HttpResponse result = httpClient.execute((HttpUriRequest)method);
        String data = EntityUtils.toString((HttpEntity)result.getEntity());
        method.releaseConnection();
        return data;
    }

    public static String sentFormPost(String url, JSONObject jsonObject) throws IOException {
        String param = "";
        if (null != jsonObject && !jsonObject.isEmpty()) {
            for (Map.Entry entry : jsonObject.entrySet()) {
                param = param + "&" + entry.getKey() + "=" + entry.getValue();
            }
        }
        StringEntity httpEntity = new StringEntity(param, ContentType.create((String)"application/x-www-form-urlencoded", (String)"utf-8"));
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)httpEntity);
        post.setHeader("Authorization", "Basic YWRtaW46Z2Vvc2VydmVy");
        String result = HttpUtil.executeRequest((HttpRequestBase)post, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeRequest(HttpRequestBase httpUriRequest, HttpContext context) {
        String result = "";
        CloseableHttpClient httpClient = HttpUtil.buildHttpClient(false);
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpUriRequest, context);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)CHARSET_UTF8);
                entity.getContent().close();
            }
            response.close();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            httpUriRequest.releaseConnection();
        }
        return result;
    }

    public static String GetInvoke(String url) throws Exception {
        CloseableHttpClient httpClient = HttpUtil.buildHttpClient(false);
        HttpGet method = new HttpGet(url);
        HttpResponse result = httpClient.execute((HttpUriRequest)method);
        String data = EntityUtils.toString((HttpEntity)result.getEntity());
        method.releaseConnection();
        return data;
    }

    public static CloseableHttpClient buildHttpClient(boolean isMultiThread) {
        CloseableHttpClient client = isMultiThread ? HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).build() : HttpClientBuilder.create().build();
        return client;
    }
}

