/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.landcloud.service.thirddata.utils.GeoUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;

public class JinAoGeoJsonUtil {
    public static Geometry rings2Geometry(String jaJson) throws Exception {
        String json = JinAoGeoJsonUtil.rings2geojson(jaJson);
        return GeoUtils.geojson2Geom(json);
    }

    public static String rings2geojson(String jaJson) {
        Map geoMap = JinAoGeoJsonUtil.rings2geomap(jaJson);
        return new JSONObject(geoMap).toString();
    }

    public static Map rings2geomap(String jaJson) {
        HashMap<String, Object> geoMap = new HashMap<String, Object>();
        try {
            ArrayList geoFs = new ArrayList();
            geoMap.put("type", "FeatureCollection");
            Map jaMap = (Map)JSON.parse((String)jaJson, (Feature[])new Feature[0]);
            HashMap<String, Object> geoF = new HashMap<String, Object>();
            geoF.put("type", "Feature");
            geoF.put("properties", new HashMap());
            geoF.put("geometry", JinAoGeoJsonUtil.geoPoly(jaMap));
            geoFs.add(geoF);
            geoMap.put("features", geoFs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return geoMap;
    }

    public static Map geoPoly(Map<String, Object> geometry) {
        HashMap<String, Object> geo = new HashMap<String, Object>();
        List rings = (List)geometry.get("rings");
        if (rings.size() == 1) {
            geo.put("type", "Polygon");
            geo.put("coordinates", rings);
        } else {
            ArrayList coords = new ArrayList();
            String type = "";
            int len = coords.size() - 1;
            for (int i = 0; i < rings.size(); ++i) {
                if (JinAoGeoJsonUtil.ringIsClockwise((List)rings.get(i))) {
                    ArrayList item = new ArrayList();
                    item.add(rings.get(i));
                    coords.add(item);
                    ++len;
                    continue;
                }
                ((List)coords.get(len)).add(rings.get(i));
            }
            type = coords.size() == 1 ? "Polygon" : "MultiPolygon";
            geo.put("type", type);
            geo.put("coordinates", coords.size() == 1 ? coords.get(0) : coords);
        }
        return geo;
    }

    public static boolean ringIsClockwise(List<List<Number>> rings) {
        double total = 0.0;
        List<Number> pt1 = null;
        List<Number> pt2 = null;
        for (int i = 0; i < rings.size() - 1; ++i) {
            pt1 = rings.get(i);
            pt2 = rings.get(i + 1);
            total += (pt2.get(0).doubleValue() - pt1.get(0).doubleValue()) * (pt2.get(1).doubleValue() + pt1.get(1).doubleValue());
        }
        return total >= 0.0;
    }
}

