/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class JwtUtils {
    private JwtUtils() {
    }

    public static String createJWT(String id, String subject, String secret, long ttlMillis) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        SecretKey secretKey = JwtUtils.generalKey(secret);
        if (secretKey == null) {
            return null;
        }
        JwtBuilder builder = Jwts.builder().setId(id).setSubject(subject).setIssuer("user").setIssuedAt(now).signWith(signatureAlgorithm, (Key)secretKey);
        if (ttlMillis >= 0L) {
            long expMillis = nowMillis + ttlMillis;
            Date expDate = new Date(expMillis);
            builder.setExpiration(expDate);
        }
        return builder.compact();
    }

    public static SecretKey generalKey(String appSecret) {
        byte[] encodedKey = appSecret.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec key = new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
        return key;
    }

    public static void main(String[] args) {
        String token = JwtUtils.createJWT("1", "gwb86b9abb1-d888-482e-80fe-a731b604ba16", "a82a71f8-2221-442b-9152-275012d1a946", 3600000L);
        System.out.println(token);
    }
}

