/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.model.datacq.analyze.CommonInfoCQ;
import com.geoway.landteam.landcloud.model.datacq.analyze.DzfxInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.LandType;
import com.geoway.landteam.landcloud.model.datacq.analyze.LandUseGrade;
import com.geoway.landteam.landcloud.model.datacq.analyze.OwnerDetailInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.Ownership;
import com.geoway.landteam.landcloud.model.datacq.analyze.ProjectInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.SpbaInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.TdghInfo;
import com.itextpdf.text.Image;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PdfAnalyzeUtil {
    public static void ParseCQ(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String tn = tableName.toLowerCase();
            System.out.println("table:" + tn);
            switch (tn) {
                case "tdqs": {
                    info.tdqsInfos = PdfAnalyzeUtil.ParseJsyd(db, tableName, "QSXZ", null);
                    break;
                }
                case "tdqs_image": {
                    info.tdqsImg = PdfAnalyzeUtil.GetImageByBlob(db, tableName, null);
                    break;
                }
                case "image_analyze": {
                    info.ownershipImg = PdfAnalyzeUtil.GetImageByBlob(db, tableName, null);
                    break;
                }
                case "jbntbhq": {
                    info.jbntArea = PdfAnalyzeUtil.getMj(db, tableName, null);
                    break;
                }
                case "jbntbhq_image": {
                    info.jbntImg = PdfAnalyzeUtil.GetImageByBlob(db, tableName, null);
                    break;
                }
                case "jsydgzq": {
                    info.jsydInfos = PdfAnalyzeUtil.ParseJsyd(db, tableName, "GZQLXDM", null);
                    Double jsydArea = 0.0;
                    for (int i = 0; i < info.jsydInfos.size(); ++i) {
                        jsydArea = jsydArea + ((CommonInfoCQ)info.jsydInfos.get((int)i)).area;
                    }
                    info.jsydgzqArea = jsydArea;
                    break;
                }
                case "jsydgzq_image": {
                    info.jsydgzqImg = PdfAnalyzeUtil.GetImageByBlob(db, tableName, null);
                    break;
                }
                case "zrbhd": {
                    info.zrbhdInfos = PdfAnalyzeUtil.ParseJsyd(db, tableName, "TYPE", null);
                    break;
                }
                case "zrbhd_image": {
                    info.zrbhdImg = PdfAnalyzeUtil.GetImageByBlob(db, tableName, null);
                    break;
                }
                case "sthx": {
                    info.sthxArea = PdfAnalyzeUtil.getMj(db, tableName, null);
                    break;
                }
                case "sthx_image": {
                    info.sthxImg = PdfAnalyzeUtil.GetImageByBlob(db, tableName, null);
                    break;
                }
                case "czkfbj": {
                    info.czkfArea = PdfAnalyzeUtil.getMj(db, tableName, null);
                    break;
                }
                case "czkfbj_image": {
                    info.czkfImg = PdfAnalyzeUtil.GetImageByBlob(db, tableName, null);
                    break;
                }
                case "cgtdghdl": {
                    info.cghInfos = PdfAnalyzeUtil.ParseJsyd(db, tableName, "CGHDLMC", null);
                    break;
                }
                case "cgtdghdl_image": {
                    info.cghImg = PdfAnalyzeUtil.GetImageByBlob(db, tableName, null);
                    break;
                }
                case "tdghdl": {
                    info.tdghCqInfos = PdfAnalyzeUtil.ParseJsyd(db, tableName, "GHDLMC", null);
                    break;
                }
                case "tdghdl_image": {
                    info.tdghCqImg = PdfAnalyzeUtil.GetImageByBlob(db, tableName, null);
                    break;
                }
                case "dzzhgyfq": {
                    info.dzzhArea = PdfAnalyzeUtil.getMj(db, tableName, null);
                    break;
                }
                case "dzzhgyfq_image": {
                    info.dzzhImg = PdfAnalyzeUtil.GetImageByBlob(db, tableName, null);
                    break;
                }
                case "sd": {
                    info.cqsdInfos = PdfAnalyzeUtil.ParseJsyd(db, tableName, "\u6e7f\u5730\u578b", null);
                    break;
                }
                case "sd_image": {
                    info.cqsdImg = PdfAnalyzeUtil.GetImageByBlob(db, tableName, null);
                    break;
                }
                case "tdlyxz_image": {
                    info.tdlyxzImg = PdfAnalyzeUtil.GetImageByBlob(db, tableName, 1);
                    break;
                }
                case "tdlyxz": {
                    info.tdlyxzInfos = PdfAnalyzeUtil.ParseJsyd(db, tableName, "DLBM", null);
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static List<CommonInfoCQ> ParseJsyd(SqlliteConnTool db, String tableName, String typeField, String areaField) {
        ArrayList<CommonInfoCQ> list = new ArrayList<CommonInfoCQ>();
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return null;
            }
            if (StringUtils.isEmpty((CharSequence)areaField)) {
                areaField = "mj";
            }
            ResultSet set = result.getResultSet();
            while (set.next()) {
                CommonInfoCQ infoCQ = new CommonInfoCQ();
                double mj = set.getDouble(areaField) * 666.6666;
                String type = set.getString(typeField);
                infoCQ.area = mj;
                infoCQ.type = type;
                list.add(infoCQ);
            }
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return list;
    }

    protected static Image GetImageByBlob(SqlliteConnTool db, String tableName, Integer imageType) {
        try {
            byte[] imgBytes;
            ResultSetInfo info;
            Image img = null;
            String sql = "select layer_pic from " + tableName;
            if (null != imageType) {
                sql = sql + " where image_type = " + imageType;
            }
            if ((info = db.doQuery(sql)) == null) {
                return null;
            }
            ResultSet set = info.getResultSet();
            if (set.next() && (imgBytes = set.getBytes("layer_pic")) != null) {
                img = Image.getInstance((byte[])imgBytes);
            }
            info.Close();
            return img;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return null;
        }
    }

    protected static double getMj(SqlliteConnTool db, String tableName, String fieldName) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return 0.0;
            }
            double area = 0.0;
            ResultSet set = result.getResultSet();
            if (StringUtils.isEmpty((CharSequence)fieldName)) {
                fieldName = "mj";
            }
            while (set.next()) {
                double mj = set.getDouble(fieldName) * 666.6666;
                area += mj;
            }
            result.Close();
            return area;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return 0.0;
        }
    }

    public static void Parse(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String tn = tableName.toLowerCase();
            System.out.println("table:" + tn);
            switch (tn) {
                case "landtype_analyze": {
                    PdfAnalyzeUtil.ParseLandType(db, tableName, info);
                    break;
                }
                case "landtype_analyze_image": {
                    PdfAnalyzeUtil.ParseLandTypeImage(db, tableName, info);
                    break;
                }
                case "ownership_analyze": {
                    PdfAnalyzeUtil.ParseOwnerShip(db, tableName, info);
                    break;
                }
                case "ownership_analyze_image": {
                    PdfAnalyzeUtil.ParseOwnerShipImage(db, tableName, info);
                    break;
                }
                case "primefarm_analyze": {
                    PdfAnalyzeUtil.ParsePrimeFarm(db, tableName, info);
                    break;
                }
                case "primefarm_analyze_image": {
                    PdfAnalyzeUtil.ParsePrimeFarmImage(db, tableName, info);
                    break;
                }
                case "plan_analyze": {
                    PdfAnalyzeUtil.ParseTdgh(db, tableName, info);
                    break;
                }
                case "plan_analyze_image": {
                    PdfAnalyzeUtil.ParseTdghImage(db, tableName, info);
                    break;
                }
                case "spba_analyze": {
                    PdfAnalyzeUtil.ParseSpba(db, tableName, info);
                    break;
                }
                case "spba_analyze_image": {
                    PdfAnalyzeUtil.ParseSpbaImage(db, tableName, info);
                    break;
                }
                case "naturereserve_analyze": {
                    PdfAnalyzeUtil.ParseZrbhq(db, tableName, info);
                    break;
                }
                case "naturereserve_analyze_image": {
                    PdfAnalyzeUtil.ParseZrbhqImage(db, tableName, info);
                    break;
                }
                case "dzfx_analyze": {
                    PdfAnalyzeUtil.ParseDzfx(db, tableName, info);
                    break;
                }
                case "dzfx_analyze_image": {
                    PdfAnalyzeUtil.ParseDzfxImage(db, tableName, info);
                    break;
                }
                case "ecologicalland_analyze": {
                    PdfAnalyzeUtil.ParseEcologicalLand(db, tableName, info);
                    break;
                }
                case "ecologicalland_analyze_image": {
                    PdfAnalyzeUtil.ParseEcologicalLandImage(db, tableName, info);
                    break;
                }
                case "landprice_analyze": {
                    PdfAnalyzeUtil.ParseLandPrice(db, tableName, info);
                    break;
                }
                case "landprice_analyze_image": {
                    PdfAnalyzeUtil.ParseLandPriceImage(db, tableName, info);
                    break;
                }
                case "aggregate_analyze": {
                    PdfAnalyzeUtil.ParseLandUseGrade(db, tableName, info);
                    break;
                }
                case "aggregate_analyze_image": {
                    PdfAnalyzeUtil.ParseLandUseGradeImage(db, tableName, info);
                    break;
                }
                case "image_analyze": {
                    info.ownershipImgMeta = PdfAnalyzeUtil.GetImageMeta(db, "Image_Analyze");
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParseLandType(SqlliteConnTool db, String tableName, ProjectInfo info) throws SQLException {
        try {
            String sql;
            ResultSetInfo result;
            if (info.landTypes == null) {
                info.landTypes = new ArrayList();
            }
            if ((result = db.doQuery(sql = "select * from " + tableName)) == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            while (set.next()) {
                LandType land = new LandType();
                land.dlmc = set.getString("name");
                land.dlbm = set.getString("code");
                land.area = set.getDouble("mj") * 666.6666;
                info.landTypes.add(land);
            }
            Collections.sort(info.landTypes);
            Collections.reverse(info.landTypes);
            int count = 0;
            int leng = info.landTypes.size();
            String dlInfo = "";
            double otherArea = 0.0;
            for (LandType item : info.landTypes) {
                if (++count > 2) {
                    otherArea += item.area;
                    continue;
                }
                dlInfo = dlInfo + item.dlmc + PdfAnalyzeUtil.Round(item.area, 2) + "\u5e73\u65b9\u7c73";
                if (count >= leng) continue;
                dlInfo = dlInfo + "/";
            }
            if (otherArea > 0.0) {
                dlInfo = dlInfo + "\u5176\u4ed6" + PdfAnalyzeUtil.Round(otherArea, 2) + "\u5e73\u65b9\u7c73";
            }
            info.landtypeImgMeta = dlInfo;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParseLandTypeImage(SqlliteConnTool db, String tableName, ProjectInfo info) throws SQLException {
        Image img;
        info.landtypeImg = img = PdfAnalyzeUtil.GetImageByBlob(db, tableName, 0);
    }

    protected static void ParseOwnerShip(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql;
            ResultSetInfo result;
            if (info.ownerships == null) {
                info.ownerships = new ArrayList();
            }
            if ((result = db.doQuery(sql = "select * from " + tableName)) == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            while (set.next()) {
                Ownership owner = new Ownership();
                String code = set.getString("owner_dept_name");
                String name = set.getString("owner_dept_code");
                String jsonStr = set.getString("area_detail");
                double area = set.getDouble("mj") * 666.6666;
                OwnerDetailInfo detail = new OwnerDetailInfo(jsonStr);
                owner.qsmc = name;
                owner.qsdm = code;
                owner.area = area;
                owner.detail = detail;
                info.ownerships.add(owner);
            }
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParseOwnerShipImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.ownershipImg = img = PdfAnalyzeUtil.GetImageByBlob(db, tableName, 1);
    }

    protected static void ParsePrimeFarm(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double area = 0.0;
            ResultSet set = result.getResultSet();
            while (set.next()) {
                String type = set.getString("type");
                if (!"\u57fa\u672c\u519c\u7530".equals(type)) continue;
                double mj = set.getDouble("mj") * 666.6666;
                area += mj;
            }
            info.jbntArea = area;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParsePrimeFarmImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.jbntImg = img = PdfAnalyzeUtil.GetImageByBlob(db, tableName, 0);
    }

    protected static void ParseTdgh(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql;
            ResultSetInfo result;
            if (info.tdghInfos == null) {
                info.tdghInfos = new ArrayList();
            }
            if ((result = db.doQuery(sql = "select * from " + tableName)) == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            while (set.next()) {
                TdghInfo tdgh = new TdghInfo();
                tdgh.jsbm = set.getString("code");
                tdgh.jsmc = set.getString("type");
                tdgh.area = set.getDouble("mj") * 666.6666;
                info.tdghInfos.add(tdgh);
            }
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParseTdghImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.tdghImg = img = PdfAnalyzeUtil.GetImageByBlob(db, tableName, 0);
    }

    protected static void ParseSpba(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select license_number, sum(mj) approval_mj from " + tableName + " group by license_number";
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            ArrayList<SpbaInfo> spbaArr = new ArrayList<SpbaInfo>();
            while (set.next()) {
                SpbaInfo spba = new SpbaInfo();
                spba.area = set.getDouble("approval_mj");
                String license = set.getString("license_number") + "";
                if (license == null || license.isEmpty()) {
                    license = "\u672a\u77e5";
                }
                spba.license = license;
                spbaArr.add(spba);
            }
            info.spbaInfos = spbaArr;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParseSpbaImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.spbaImg = img = PdfAnalyzeUtil.GetImageByBlob(db, tableName, 0);
    }

    protected static void ParseZrbhq(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select sum(mj) from " + tableName;
            Object obj = db.queryScale(sql);
            if (obj != null) {
                double area = Double.valueOf(obj.toString());
                info.zrbhqArea = area;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParseZrbhqImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.zrbhqImg = img = PdfAnalyzeUtil.GetImageByBlob(db, tableName, 0);
    }

    protected static void ParseDzfx(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select level,sum(area) area from " + tableName + " group by level";
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            ArrayList<DzfxInfo> dzfxArr = new ArrayList<DzfxInfo>();
            while (set.next()) {
                DzfxInfo dzfx = new DzfxInfo();
                dzfx.area = set.getDouble("area");
                String level = set.getString("level") + "";
                if (level == null || level.isEmpty()) {
                    level = "\u672a\u77e5";
                }
                dzfx.level = level;
                dzfxArr.add(dzfx);
            }
            info.dzfxInfos = dzfxArr;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParseDzfxImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.dzfxImg = img = PdfAnalyzeUtil.GetImageByBlob(db, tableName, 0);
    }

    protected static void ParseEcologicalLand(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select sum(area) from" + tableName;
            Object obj = db.queryScale(sql);
            if (obj != null) {
                double area = Double.valueOf(obj.toString());
                info.sdArea = area;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParseEcologicalLandImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.sdImg = img = PdfAnalyzeUtil.GetImageByBlob(db, tableName, 0);
    }

    protected static void ParseLandPrice(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select sum(area) mj,sum(price) price from" + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            double mj = 0.0;
            double price = 0.0;
            while (set.next()) {
                mj = set.getDouble("mj") * 666.6666;
                price = set.getDouble("price");
            }
            info.landPrice = mj == 0.0 ? 0.0 : price / mj;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParseLandPriceImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.landPriceImg = img = PdfAnalyzeUtil.GetImageByBlob(db, tableName, 0);
    }

    protected static void ParseLandUseGrade(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select content from " + tableName + " where analyze_name ='\u571f\u5730\u5229\u7528\u7b49\u522b\u5206\u6790'";
            Object obj = db.queryScale(sql);
            if (obj == null) {
                return;
            }
            String jsonStr = obj.toString();
            List detail = JSONArray.parseArray((String)jsonStr, LandUseGrade.class);
            if (detail != null) {
                for (LandUseGrade lg : detail) {
                    lg.field1 = lg.field1.replace(",", "-");
                }
            }
            info.gradeInfos = (ArrayList)detail;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParseLandUseGradeImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.gradeImg = img = PdfAnalyzeUtil.GetImageByBlob(db, tableName, "\u571f\u5730\u5229\u7528\u7b49\u522b\u5206\u6790", 0);
    }

    protected static Image GetImageByBlob(SqlliteConnTool db, String tableName, String analyzeName, int imageType) {
        try {
            byte[] imgBytes;
            Image img = null;
            String sql = "select layer_pic from " + tableName + " where analyze_name = '" + analyzeName + "' and image_subtype = " + imageType;
            ResultSetInfo info = db.doQuery(sql);
            if (info == null) {
                return null;
            }
            ResultSet set = info.getResultSet();
            if (set.next() && (imgBytes = set.getBytes("layer_pic")) != null) {
                img = Image.getInstance((byte[])imgBytes);
            }
            info.Close();
            return img;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return null;
        }
    }

    public static String GetImageMeta(SqlliteConnTool db, String tableName) {
        String sql = "select meta_info from Image_Analyze where date is not null order by date desc limit 1";
        Object obj = db.queryScale(sql);
        if (obj == null) {
            return null;
        }
        String sjy = "";
        String sx = "";
        String jsonStr = obj.toString();
        JSONObject json = JSONObject.parseObject((String)jsonStr);
        if (json.containsKey((Object)"SJY")) {
            sjy = json.getString("SJY");
        }
        if (json.containsKey((Object)"SX")) {
            sx = json.getString("SX");
        }
        if (sjy == null || sjy.isEmpty()) {
            sjy = "\u672a\u77e5";
        }
        if (sx == null || sx.isEmpty()) {
            sx = "\u672a\u77e5";
        }
        String meta = "\u6570\u636e\u6e90\uff1a" + sjy + " \u65f6\u76f8\uff1a" + sx;
        return meta;
    }

    public static double Round(double value, int count) {
        String formate = "#.";
        for (int i = 0; i < count; ++i) {
            formate = formate + "0";
        }
        String temp = new DecimalFormat(formate).format(value);
        return Double.parseDouble(temp);
    }
}

