/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;

public class SmbUtil {
    private GiLoger logger = GwLoger.getLoger(SmbUtil.class);

    public static void putFile(String path, String toPath) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            File localFile = new File(path);
            SmbFile remoteFile = SmbUtil.connectFile(toPath);
            in = new BufferedInputStream(new FileInputStream(localFile));
            out = new BufferedOutputStream((OutputStream)new SmbFileOutputStream(remoteFile));
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = in.read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String getFile(String path, String toPath) throws IOException {
        BufferedInputStream in = null;
        ByteArrayOutputStream out = null;
        FileOutputStream fos = null;
        try {
            SmbFile remoteFile = SmbUtil.connectFile(path);
            in = new BufferedInputStream((InputStream)new SmbFileInputStream(remoteFile));
            out = new ByteArrayOutputStream((int)remoteFile.length());
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = ((InputStream)in).read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush();
            File file = new File(toPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            File outFile = new File(toPath + File.separator + remoteFile.getName());
            outFile.createNewFile();
            fos = new FileOutputStream(outFile);
            out.writeTo(fos);
            String string = toPath + File.separator + remoteFile.getName();
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void deleteFile(String path) throws IOException {
        SmbFile file = SmbUtil.connectFile(path);
        file.delete();
    }

    public static SmbFile connectFile(String path) throws IOException {
        SmbFile file = new SmbFile(path);
        file.connect();
        return file;
    }
}

