/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadLocalUtils<T> {
    private static final ThreadLocal<Map<String, Object>> threadLocal = new ThreadLocal(){

        protected Map<String, Object> initialValue() {
            return new ConcurrentHashMap<String, Object>();
        }
    };

    public static Map<String, Object> getThreadLocal() {
        return threadLocal.get();
    }

    public static <T> T get(String key) {
        Map<String, Object> map = threadLocal.get();
        return (T)map.get(key);
    }

    public static <T> T get(String key, T defaultValue) {
        Map<String, Object> map = threadLocal.get();
        return (T)(map.get(key) == null ? defaultValue : map.get(key));
    }

    public static void set(String key, Object value) {
        Map<String, Object> map = threadLocal.get();
        map.put(key, value);
    }

    public static void set(Map<String, Object> keyValueMap) {
        Map<String, Object> map = threadLocal.get();
        map.putAll(keyValueMap);
    }

    public static void remove() {
        threadLocal.remove();
    }

    public static <T> Map<String, T> fetchVarsByPrefix(String prefix) {
        ConcurrentHashMap<String, Object> vars = new ConcurrentHashMap<String, Object>();
        if (prefix == null) {
            return vars;
        }
        Map<String, Object> map = threadLocal.get();
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            String key = entry.getKey();
            if (!(key instanceof String) || !key.startsWith(prefix)) continue;
            vars.put(key, entry.getValue());
        }
        return vars;
    }

    public static <T> T remove(String key) {
        Map<String, Object> map = threadLocal.get();
        return (T)map.remove(key);
    }

    public static void clear(String prefix) {
        if (prefix == null) {
            return;
        }
        Map<String, Object> map = threadLocal.get();
        Set<Map.Entry<String, Object>> set = map.entrySet();
        ArrayList<String> removeKeys = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : set) {
            String key = entry.getKey();
            if (!(key instanceof String) || !key.startsWith(prefix)) continue;
            removeKeys.add(key);
        }
        for (String key : removeKeys) {
            map.remove(key);
        }
    }

    public static void clear() {
        Map<String, Object> map = threadLocal.get();
        map.clear();
    }
}

