/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;

public class ThumUtil {
    private GiLoger logger = GwLoger.getLoger(ThumUtil.class);

    public static void getThumImage(String fileUrl, String thumUrl, int width, int height, String imageName) {
        try {
            if (StringUtils.isBlank((CharSequence)fileUrl)) {
                return;
            }
            File file = new File(fileUrl);
            if (!file.canRead()) {
                return;
            }
            BufferedImage bufferedImage = ImageIO.read(file);
            if (null == bufferedImage) {
                return;
            }
            String suffix = StringUtils.substringAfterLast((String)file.getName(), (String)".");
            thumUrl = thumUrl + imageName;
            if (suffix != null && (suffix.trim().toLowerCase().endsWith("png") || suffix.trim().toLowerCase().endsWith("gif"))) {
                BufferedImage to = new BufferedImage(width, height, 1);
                Graphics2D g2d = to.createGraphics();
                to = g2d.getDeviceConfiguration().createCompatibleImage(width, height, 3);
                g2d.dispose();
                g2d = to.createGraphics();
                Image from = bufferedImage.getScaledInstance(width, height, 16);
                g2d.drawImage(from, 0, 0, null);
                g2d.dispose();
                ImageIO.write((RenderedImage)to, suffix, new File(thumUrl));
            } else {
                BufferedImage newImage = new BufferedImage(width, height, bufferedImage.getType());
                Graphics g = newImage.getGraphics();
                g.drawImage(bufferedImage, 0, 0, width, height, null);
                g.dispose();
                ImageIO.write((RenderedImage)newImage, suffix, new File(thumUrl));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

