/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.thirddata.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;

public class ZipUtils {
    private ZipEntry zipEntry;
    private static int bufSize;
    private byte[] buf;
    private int readedBytes;
    private String rootDir;

    public ZipUtils() {
        this(512);
    }

    public ZipUtils(int bufSize) {
        ZipUtils.bufSize = bufSize;
        this.buf = new byte[ZipUtils.bufSize];
    }

    public void unZip(String unZipfileName) {
        block12: {
            if (unZipfileName.endsWith(".zip")) {
                String f = unZipfileName.substring(0, unZipfileName.length() - 4);
                String rootName = "";
                f = f.replaceAll("\\\\", "/");
                rootName = f.substring(f.lastIndexOf("/") + 1);
                File ff = new File(f);
                try {
                    File zipFile = new File(unZipfileName);
                    if (zipFile.exists()) {
                        ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(new FileInputStream(unZipfileName)));
                        while ((this.zipEntry = zipIn.getNextEntry()) != null) {
                            String path = this.zipEntry.getName();
                            path = (path = path.replaceAll("\\\\", "/")).lastIndexOf("/") > -1 ? path.substring(0, path.lastIndexOf("/")) : "";
                            path = path.replaceFirst(rootName, "");
                            File file = new File(this.zipEntry.getName());
                            if (this.zipEntry.isDirectory()) {
                                file.mkdirs();
                            } else {
                                File parent = file.getParentFile();
                                if (parent != null && !parent.exists()) {
                                    parent.mkdirs();
                                }
                                if (!ff.exists()) {
                                    ff.mkdir();
                                }
                                File dir = null;
                                dir = StringUtils.isBlank((CharSequence)path) ? new File(f) : new File(f + "/" + path);
                                if (!dir.exists()) {
                                    dir.mkdirs();
                                }
                                FileOutputStream fileOut = StringUtils.isEmpty((CharSequence)path) ? new FileOutputStream(f + "/" + file.getName()) : new FileOutputStream(f + "/" + path + "/" + file.getName());
                                while ((this.readedBytes = zipIn.read(this.buf)) > 0) {
                                    fileOut.write(this.buf, 0, this.readedBytes);
                                }
                                fileOut.close();
                            }
                            zipIn.closeEntry();
                        }
                        System.out.println("\u89e3\u538b\u5b8c\u6210\uff01");
                        break block12;
                    }
                    System.err.println("zip\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
                }
                catch (Exception ioe) {
                    ioe.printStackTrace();
                }
            } else {
                System.err.println("\u60a8\u9009\u62e9\u7684\u6587\u4ef6\u4e0d\u662fzip\u6587\u4ef6\uff01");
            }
        }
    }

    public void doZip(String zipDirectory) {
        File zipDir = new File(zipDirectory);
        if (zipDir.exists()) {
            this.rootDir = zipDir.getName();
            String zipFileName = zipDirectory + ".zip";
            if (zipDir.isFile()) {
                zipFileName = zipDirectory.substring(0, zipDirectory.indexOf(".")) + ".zip";
            }
            try {
                ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFileName)));
                this.handleDir(zipDir, zipOut);
                zipOut.close();
                System.out.println("\u5b8c\u6210\uff01");
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println(" \u8bf7\u8f93\u5165\u6b63\u786e\u7684\u6587\u4ef6\u8def\u5f84\uff01");
            }
        } else {
            System.err.println("\u60a8\u8f93\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDir(File dir, ZipOutputStream zipOut) throws IOException {
        FileInputStream fileIn = null;
        File[] files = null;
        if (dir.isDirectory()) {
            files = dir.listFiles();
            if (null != files && files.length == 0) {
                zipOut.putNextEntry(new ZipEntry(dir.toString() + "/"));
                zipOut.closeEntry();
            } else {
                for (File fileName : files) {
                    if (fileName.isDirectory()) {
                        this.handleDir(fileName, zipOut);
                        continue;
                    }
                    try {
                        fileIn = new FileInputStream(fileName);
                        String name = dir.getName();
                        String path = dir.getPath();
                        path = path.substring(path.indexOf(this.rootDir));
                        zipOut.putNextEntry(new ZipEntry(path + "/" + fileName.getName().toString()));
                        while ((this.readedBytes = fileIn.read(this.buf)) > 0) {
                            zipOut.write(this.buf, 0, this.readedBytes);
                        }
                        zipOut.closeEntry();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (fileIn != null) {
                            try {
                                fileIn.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        } else if (dir.isFile()) {
            fileIn = new FileInputStream(dir);
            String name = dir.getName();
            String path = dir.getPath();
            zipOut.putNextEntry(new ZipEntry(dir.getName().toString()));
            while ((this.readedBytes = fileIn.read(this.buf)) > 0) {
                zipOut.write(this.buf, 0, this.readedBytes);
            }
            zipOut.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decompressZip(String zipPath, String descDir) throws Exception {
        File zipFile = new File(zipPath);
        boolean flag = false;
        File pathFile = new File(descDir);
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                String zipEntryName = entry.getName();
                InputStream in = zip.getInputStream(entry);
                String outPath = (descDir + zipEntryName).replace("/", File.separator);
                File file = new File(outPath.substring(0, outPath.lastIndexOf(File.separator)));
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (new File(outPath).isDirectory()) continue;
                FileOutputStream out = new FileOutputStream(outPath);
                byte[] buf1 = new byte[2048];
                while ((len = in.read(buf1)) > 0) {
                    ((OutputStream)out).write(buf1, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
            }
            flag = true;
            zip.close();
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipFiles(List<File> srcFiles, File zipFile) {
        if (!zipFile.exists()) {
            try {
                zipFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileOutputStream = new FileOutputStream(zipFile);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            ZipEntry zipEntry = null;
            for (int i = 0; i < srcFiles.size(); ++i) {
                int len;
                fileInputStream = new FileInputStream(srcFiles.get(i));
                zipEntry = new ZipEntry(srcFiles.get(i).getName());
                zipOutputStream.putNextEntry(zipEntry);
                byte[] buffer = new byte[1024];
                while ((len = fileInputStream.read(buffer)) > 0) {
                    zipOutputStream.write(buffer, 0, len);
                }
            }
            zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fileInputStream.close();
                zipOutputStream.close();
                fileOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

