/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.tieta;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.landteam.landcloud.model.tieta.dto.CameraInfo;
import com.geoway.landteam.landcloud.model.tieta.dto.CamerasData;
import com.geoway.landteam.landcloud.model.tieta.dto.FaceLibResponseDTO;
import com.geoway.landteam.landcloud.model.tieta.dto.GetCamerasResponseDTO;
import com.geoway.landteam.landcloud.model.tieta.dto.LocationResponseDTO;
import com.geoway.landteam.landcloud.model.tieta.dto.PtzControlResponseDTO;
import com.geoway.landteam.landcloud.model.tieta.dto.RootRegionResponseDTO;
import com.geoway.landteam.landcloud.model.tieta.dto.TalkURLResponseDTO;
import com.geoway.landteam.landcloud.model.tieta.dto.TreeCodeResponseDTO;
import com.geoway.landteam.landcloud.model.tieta.entity.TbCameraInfo;
import com.geoway.landteam.landcloud.model.tieta.paramter.CameraParamter;
import com.geoway.landteam.landcloud.model.tieta.paramter.PtzControlParamter;
import com.geoway.landteam.landcloud.model.tieta.paramter.QueryParameter;
import com.geoway.landteam.landcloud.model.tieta.paramter.TreeCodeParamter;
import com.geoway.landteam.landcloud.repository.tieta.TbCameraInfoRepository;
import com.geoway.landteam.landcloud.servface.tieta.TietaService;
import com.google.gson.Gson;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.hikvision.artemis.sdk.ArtemisHttpUtil;
import com.hikvision.artemis.sdk.config.ArtemisConfig;
import com.hikvision.artemis.sdk.constant.Constants;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class TietaServiceImpl
implements TietaService {
    private final GiLoger logger = GwLoger.getLoger(TietaServiceImpl.class);
    private static final String API_URL = "https://10.6.220.20:1443/artemis";
    @Value(value="${artemis.appKey}")
    private String appKey;
    @Value(value="${artemis.appSecret}")
    private String appSecret;
    @Value(value="${artemis.host}")
    private String host;
    @Value(value="${artemis.path}")
    private String artemisPath;
    @Value(value="${artemis.httpProtocol}")
    private String httpProtocol;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TbCameraInfoRepository tbCameraInfoRepository;

    public GetCamerasResponseDTO getCamerasData(CameraParamter cameraParamter) throws Exception {
        if (ObjectUtils.isEmpty((Object)cameraParamter)) {
            return null;
        }
        Gson gson = new Gson();
        String body = gson.toJson((Object)cameraParamter);
        String getCamsApi = "/api/resource/v1/cameras";
        GetCamerasResponseDTO getCamerasResponseDTO = this.executeArtemisRequest("/api/resource/v1/cameras", body, GetCamerasResponseDTO.class);
        if (ObjectUtils.isNotEmpty((Object)getCamerasResponseDTO) && getCamerasResponseDTO.getCode().equals("0")) {
            return getCamerasResponseDTO;
        }
        return null;
    }

    public TalkURLResponseDTO getEncodingDevices(String cameraIndexCode) throws Exception {
        if (StringUtils.isEmpty((CharSequence)cameraIndexCode)) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("cameraIndexCode", cameraIndexCode);
        paramMap.put("protocol", "hls");
        String body = JSON.toJSON(paramMap).toString();
        String getCamsApi = "/api/video/v1/cameras/previewURLs";
        TalkURLResponseDTO talkURLResponseDTO = this.executeArtemisRequest("/api/video/v1/cameras/previewURLs", body, TalkURLResponseDTO.class);
        if (ObjectUtils.isNotEmpty((Object)talkURLResponseDTO) && talkURLResponseDTO.getCode().equals("0")) {
            if (ObjectUtils.isNotEmpty((Object)talkURLResponseDTO.getData()) && StringUtils.isNotBlank((CharSequence)talkURLResponseDTO.getData().getUrl())) {
                String originalUrl = talkURLResponseDTO.getData().getUrl();
                URL url = new URL(originalUrl);
                if (StringUtils.isNotBlank((CharSequence)this.host)) {
                    String originalHostAndPort = url.getHost() + ":" + url.getPort();
                    String newUrl = originalUrl.replace(originalHostAndPort, this.host);
                    talkURLResponseDTO.getData().setUrl(newUrl);
                }
            }
            return talkURLResponseDTO;
        }
        return null;
    }

    public FaceLibResponseDTO getFaceDB(String personLibIds) throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("personLibIds", personLibIds);
        String body = JSON.toJSON(paramMap).toString();
        String getCamsApi = "/api/aiapplication/v2/face/faceLib/getPersonLib";
        FaceLibResponseDTO faceLibResponseDTO = this.executeArtemisRequest("/api/aiapplication/v2/face/faceLib/getPersonLib", body, FaceLibResponseDTO.class);
        if (ObjectUtils.isNotEmpty((Object)faceLibResponseDTO) && faceLibResponseDTO.getCode().equals("0")) {
            return faceLibResponseDTO;
        }
        return null;
    }

    public TreeCodeResponseDTO getAllTreeCode(TreeCodeParamter treeCodeParamter) throws Exception {
        if (ObjectUtils.isEmpty((Object)treeCodeParamter)) {
            return null;
        }
        Gson gson = new Gson();
        String body = gson.toJson((Object)treeCodeParamter);
        String getCamsApi = "/api/aiapplication/v2/face/queryPersonByAttrWithPage";
        TreeCodeResponseDTO treeCodeResponseDTO = this.executeArtemisRequest("/api/aiapplication/v2/face/queryPersonByAttrWithPage", body, TreeCodeResponseDTO.class);
        if (ObjectUtils.isNotEmpty((Object)treeCodeResponseDTO) && treeCodeResponseDTO.getCode().equals("0")) {
            return treeCodeResponseDTO;
        }
        return null;
    }

    public RootRegionResponseDTO getRootRegion(String treeCode) throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("treeCode", treeCode);
        String body = JSON.toJSON(paramMap).toString();
        String getCamsApi = "/api/resource/v1/regions/root";
        RootRegionResponseDTO rootRegionResponseDTO = this.executeArtemisRequest("/api/resource/v1/regions/root", body, RootRegionResponseDTO.class);
        if (ObjectUtils.isNotEmpty((Object)rootRegionResponseDTO) && rootRegionResponseDTO.getCode().equals("0")) {
            return rootRegionResponseDTO;
        }
        return null;
    }

    public RootRegionResponseDTO getSubRegion(String parentIndexCode, String treeCode) throws Exception {
        if (StringUtils.isBlank((CharSequence)parentIndexCode)) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("parentIndexCode", parentIndexCode);
        paramMap.put("treeCode", treeCode);
        String body = JSON.toJSON(paramMap).toString();
        String getCamsApi = "/api/resource/v1/regions/subRegions";
        RootRegionResponseDTO rootRegionResponseDTO = this.executeArtemisRequest("/api/resource/v1/regions/subRegions", body, RootRegionResponseDTO.class);
        if (ObjectUtils.isNotEmpty((Object)rootRegionResponseDTO) && rootRegionResponseDTO.getCode().equals("0")) {
            return rootRegionResponseDTO;
        }
        return null;
    }

    public PtzControlResponseDTO setPtzControl(PtzControlParamter ptzControlParamter) throws Exception {
        if (ObjectUtils.isEmpty((Object)ptzControlParamter) || StringUtils.isBlank((CharSequence)ptzControlParamter.getCameraIndexCode())) {
            return null;
        }
        Gson gson = new Gson();
        String body = gson.toJson((Object)ptzControlParamter);
        String getCamsApi = "/api/video/v1/ptzs/controlling";
        PtzControlResponseDTO ptzControlResponseDTO = this.executeArtemisRequest("/api/video/v1/ptzs/controlling", body, PtzControlResponseDTO.class);
        if (ObjectUtils.isNotEmpty((Object)ptzControlResponseDTO) && ptzControlResponseDTO.getCode().equals("0")) {
            return ptzControlResponseDTO;
        }
        return null;
    }

    public LocationResponseDTO getrRegionByLonLat(String lon, String lat) throws Exception {
        if (StringUtils.isBlank((CharSequence)lon) || StringUtils.isBlank((CharSequence)lat)) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("latitude", lat);
        paramMap.put("longitude", lon);
        String body = JSON.toJSON(paramMap).toString();
        String getCamsApi = "/api/iland/v1/place/location";
        LocationResponseDTO locationResponseDTO = this.executeArtemisRequest("/api/iland/v1/place/location", body, LocationResponseDTO.class);
        if (ObjectUtils.isNotEmpty((Object)locationResponseDTO) && locationResponseDTO.getCode().equals("0")) {
            return locationResponseDTO;
        }
        return null;
    }

    public void startCameraImport() throws Exception {
        AtomicInteger processedCount = new AtomicInteger(0);
        this.jdbcTemplate.execute("delete from tb_camera_info ");
        this.createCamerasToDBRecursive(1, 1000, 0, processedCount);
        this.jdbcTemplate.execute("UPDATE tb_camera_info SET f_shape = ST_SetSRID(ST_MakePoint(longitude, latitude), 4490)  ");
    }

    public Pair<Long, List<TbCameraInfo>> queryTbCameraInfoForList(QueryParameter param) throws Exception {
        if (ObjectUtils.isEmpty((Object)param.getPage())) {
            param.setPage(Integer.valueOf(1));
        }
        if (ObjectUtils.isEmpty((Object)param.getRows())) {
            param.setRows(Integer.valueOf(20));
        }
        Integer offset = (param.getPage() - 1) * param.getRows();
        List tbCameraInfos = null;
        Long count = 0L;
        if (ObjectUtils.isNotEmpty((Object)param.getLat()) && ObjectUtils.isNotEmpty((Object)param.getLon()) && ObjectUtils.isNotEmpty((Object)param.getMetre())) {
            tbCameraInfos = this.tbCameraInfoRepository.findByNearParameter(param.getName(), param.getStatus(), param.getRows(), offset, param.getLon(), param.getLat(), param.getMetre());
            count = this.tbCameraInfoRepository.findCountByNearParameter(param.getName(), param.getStatus(), param.getLon(), param.getLat(), param.getMetre());
        } else {
            tbCameraInfos = this.tbCameraInfoRepository.findByParameter(param.getName(), param.getStatus(), param.getRows(), offset);
            count = this.tbCameraInfoRepository.findCountByParameter(param.getName(), param.getStatus());
        }
        return Pair.of((Object)count, (Object)tbCameraInfos);
    }

    public Pair<Long, List<TbCameraInfo>> queryAllList() throws Exception {
        List tbCameraInfos = this.tbCameraInfoRepository.findAllList();
        Long count = this.tbCameraInfoRepository.findAllCount();
        return Pair.of((Object)count, (Object)tbCameraInfos);
    }

    public List<TbCameraInfo> queryNearList(Double lon, Double lat, Integer metre) throws Exception {
        List cameraInfoList = null;
        if (ObjectUtils.isNotEmpty((Object)lon) && ObjectUtils.isNotEmpty((Object)lat) && ObjectUtils.isNotEmpty((Object)metre)) {
            cameraInfoList = this.tbCameraInfoRepository.findNearList(lon, lat, metre);
        }
        return cameraInfoList;
    }

    public TbCameraInfo queryTbCameraInfoById(String id) {
        TbCameraInfo tbCameraInfo = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            tbCameraInfo = this.tbCameraInfoRepository.findTbCameraInfoById(id);
        }
        return tbCameraInfo;
    }

    public Pair<List<Map<String, Object>>, List<Map<String, Object>>> statisticsTieta(String xzqhCode) {
        String sql = "";
        sql = " select tb.f_xzqdm, tb.f_centerx, tb.f_centery, tt.num from tb_region tb, (select substring(xzqh_code,0,7) as xzqdm, count(1) as num from tb_camera_info where xzqh_code is not null and xzqh_code <> '' group by substring(xzqh_code,0,7)) tt where tb.f_xzqdm = tt.xzqdm ";
        List mapList = this.jdbcTemplate.queryForList(sql);
        sql = "select status, count(1) from tb_camera_info where status is not null and status <> '' group by status ";
        List statusMapLists = this.jdbcTemplate.queryForList(sql);
        if (ObjectUtils.isNotEmpty((Object)statusMapLists)) {
            HashMap<String, Object> map;
            boolean onLine = false;
            boolean offLine = false;
            for (Map map2 : statusMapLists) {
                String key = (String)map2.get("status");
                if (key.equals("1")) {
                    map2.put("status", "\u5728\u7ebf");
                    onLine = true;
                }
                if (!key.equals("0")) continue;
                map2.put("status", "\u79bb\u7ebf");
                offLine = true;
            }
            if (!onLine) {
                map = new HashMap<String, Object>();
                map.put("status", "\u5728\u7ebf");
                map.put("count", 0);
                statusMapLists.add(map);
            }
            if (!offLine) {
                map = new HashMap();
                map.put("status", "\u79bb\u7ebf");
                map.put("count", 0);
                statusMapLists.add(map);
            }
        }
        return Pair.of((Object)mapList, (Object)statusMapLists);
    }

    public void createCamerasToDBRecursive(int pageIndex, int pageSize, int total, AtomicInteger processedCount) throws Exception {
        if (total > 0 && processedCount.get() >= total) {
            System.out.println("\u6444\u50cf\u5934\u6570\u636e\u5bfc\u5165\u5b8c\u6210,\u603b\u6570\uff1a" + total);
            return;
        }
        CameraParamter cameraParamter = new CameraParamter();
        cameraParamter.setPageNo(Integer.valueOf(pageIndex));
        cameraParamter.setPageSize(Integer.valueOf(pageSize));
        cameraParamter.setTreeCode("0");
        try {
            GetCamerasResponseDTO camerasResponseDTO = this.getCamerasData(cameraParamter);
            if (ObjectUtils.isNotEmpty((Object)camerasResponseDTO)) {
                CamerasData camerasData = camerasResponseDTO.getData();
                if (ObjectUtils.isNotEmpty((Object)camerasData)) {
                    List cameraInfoList;
                    if (total == 0) {
                        total = camerasData.getTotal();
                    }
                    if (ObjectUtils.isEmpty((Object)(cameraInfoList = camerasData.getList()))) {
                        System.out.println("\u5f53\u524d\u9875\u6ca1\u6709\u6570\u636e\uff0cpageIndex:" + pageIndex);
                        return;
                    }
                    for (CameraInfo cameraInfo : cameraInfoList) {
                        Object data;
                        LocationResponseDTO locationResponseDTO;
                        String placeCode = "";
                        String placeName = "";
                        if (ObjectUtils.isNotEmpty((Object)cameraInfo.getLatitude()) && ObjectUtils.isNotEmpty((Object)cameraInfo.getLongitude()) && ObjectUtils.isNotEmpty((Object)(locationResponseDTO = this.getrRegionByLonLat(cameraInfo.getLongitude() + "", cameraInfo.getLatitude() + ""))) && locationResponseDTO.getCode().equals("0") && ObjectUtils.isNotEmpty((Object)(data = locationResponseDTO.getData()))) {
                            Map map = (Map)data;
                            placeCode = (String)map.get("placeCode");
                            placeName = (String)map.get("placeName");
                        }
                        String sql = "INSERT INTO tb_camera_info (camera_index_code, gb_index_code, name, device_index_code, longitude, latitude, altitude, pixel, camera_type, camera_type_name, install_place, matrix_code, chan_num, viewshed, capability_set, capability_set_name, intelligent_set, intelligent_set_name, record_location, record_location_name, ptz_controller, ptz_controller_name, device_resource_type, device_resource_type_name, channel_type, channel_type_name, trans_type, trans_type_name, update_time, unit_index_code, treaty_type, treaty_type_name, create_time, status, status_name,is_cascade,external_index_code, ptz_controller_set_name, record_location_set_name, xzqh_code) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                        this.jdbcTemplate.update(sql, new Object[]{cameraInfo.getCameraIndexCode(), cameraInfo.getGbIndexCode(), cameraInfo.getName(), cameraInfo.getDeviceIndexCode(), cameraInfo.getLongitude(), cameraInfo.getLatitude(), cameraInfo.getAltitude(), cameraInfo.getPixel(), cameraInfo.getCameraType(), cameraInfo.getCameraTypeName(), cameraInfo.getInstallPlace(), cameraInfo.getMatrixCode(), cameraInfo.getChanNum(), cameraInfo.getViewshed(), cameraInfo.getCapabilitySet(), cameraInfo.getCapabilitySetName(), cameraInfo.getIntelligentSet(), cameraInfo.getIntelligentSetName(), cameraInfo.getRecordLocation(), cameraInfo.getRecordLocationName(), cameraInfo.getPtzController(), cameraInfo.getPtzControllerName(), cameraInfo.getDeviceResourceType(), cameraInfo.getDeviceResourceTypeName(), cameraInfo.getChannelType(), cameraInfo.getChannelTypeName(), cameraInfo.getTransType(), cameraInfo.getTransTypeName(), cameraInfo.getUpdateTime(), cameraInfo.getUnitIndexCode(), cameraInfo.getTreatyType(), cameraInfo.getTreatyTypeName(), cameraInfo.getCreateTime(), cameraInfo.getStatus(), cameraInfo.getStatusName(), cameraInfo.getIsCascade(), cameraInfo.getExternalIndexCode(), cameraInfo.getPtzControllerSetName(), cameraInfo.getRecordLocationSetName(), placeCode});
                        processedCount.incrementAndGet();
                        System.out.println("\u5f53\u524d\u5904\u7406\u7b2c\uff1a" + processedCount.get() + "\u6761\uff0c \u603b\u6570\uff1a" + total);
                    }
                    this.createCamerasToDBRecursive(pageIndex + 1, pageSize, total, processedCount);
                } else {
                    System.out.println("CamerasData is empty");
                }
            } else {
                System.out.println("CamerasResponseDTO is empty");
            }
        }
        catch (Exception e) {
            this.logger.error("\u94c1\u5854\u6570\u636e\u7b2c{}\u6761\u3001\u5165\u5e93\u5931\u8d25\uff1a{}", new Object[]{pageIndex, e.getMessage()});
            System.err.println("Error processing page " + pageIndex + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private <T> T executeArtemisRequest(final String apiPath, String body, Class<T> responseType) throws Exception {
        ArtemisConfig config = new ArtemisConfig();
        config.setHost(this.host);
        config.setAppKey(this.appKey);
        config.setAppSecret(this.appSecret);
        HashMap<String, String> path = new HashMap<String, String>(2){
            {
                super(x0);
                this.put(TietaServiceImpl.this.httpProtocol + "://", TietaServiceImpl.this.artemisPath + apiPath);
            }
        };
        String result = ArtemisHttpUtil.doPostStringArtemis((ArtemisConfig)config, (Map)path, (String)body, null, null, (String)"application/json");
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (T)objectMapper.readValue(result, responseType);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u94c1\u5854\u63a5\u53e3\u8c03\u7528{}\u89e3\u6790\u5931\u8d25\uff1a{}", new Object[]{apiPath, result});
            throw new Exception("\u94c1\u5854\u63a5\u53e3\u8c03\u7528" + apiPath + "\u89e3\u6790\u5931\u8d25");
        }
    }

    static {
        Constants.DEFAULT_TIMEOUT = 10000;
        Constants.SOCKET_TIMEOUT = 60000;
    }
}

