/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.uis.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.cloudquery.model.pub.entity.RoleCloudQueryRel;
import com.geoway.landteam.cloudquery.repository.pub.RoleCloudQueryRelRepository;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserAddInfo;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserUpdateInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.CloudDiskOfOrg;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserApplication;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserBizSupervision;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.pub.CloudDiskOfOrgRepository;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OrganizationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UisApplicationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UserApplicationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UserBizSupervisionRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.OrganizationService;
import com.geoway.landteam.landcloud.core.service.base.ApplicationCodeService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.dao.uis.TbSyncUisNodeDao;
import com.geoway.landteam.landcloud.model.uis.dto.SyncUisNodeDTO;
import com.geoway.landteam.landcloud.model.uis.entity.SyncUisData;
import com.geoway.landteam.landcloud.model.uis.entity.TbSyncNode;
import com.geoway.landteam.landcloud.servface.uis.SyncUisService;
import com.geoway.landteam.landcloud.service.jms.constant.ActiveMQConstant;
import com.geoway.landteam.landcloud.service.jms.send.ProducerService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncUisServiceImpl
implements SyncUisService {
    private static final GiLoger log = GwLoger.getLoger();
    private static final String QUEUE_PRE_FIX = "SYNCUIS";
    protected String appkeys;
    @Resource
    ProducerService producerService;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    TbSyncUisNodeDao tbSyncUisNodeDao;
    @Resource
    UserApplicationRepository userApplicationDao;
    @Resource
    UisApplicationRepository UisApplicationDao;
    @Autowired
    UserBizSupervisionRepository userBizSupervisionDao;
    @Resource
    LandUserRepository landUserDao;
    @Resource
    OrganizationRepository organizationRepository;
    @Autowired
    CloudDiskOfOrgRepository cloudDiskOfOrgDao;
    @Autowired
    RoleCloudQueryRelRepository roleCloudQueryRelRepository;
    @Resource
    Organization2UserRepository organization2UserRepository;
    @Autowired
    ApplicationCodeService applicationCodeService;
    @Autowired
    OrganizationService organizationService;
    @Autowired
    LandUserService landUserService;
    @Resource
    LandUser2AreaRepository landUser2AreaDao;
    protected boolean enableSync;
    protected String appkey;

    public Map nodeRegister(SyncUisNodeDTO syncUisNodeDTO, long userId) {
        GutilAssert.notNull((Object)syncUisNodeDTO, (String)"parameter 'syncUisNodeDTO' must not be null .");
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("result", false);
        retVal.put("error", "");
        TbSyncNode node = new TbSyncNode();
        BeanUtil.copyProperties((Object)syncUisNodeDTO, (Object)node, (boolean)true);
        try {
            if (StringUtils.isBlank((CharSequence)node.getNodeAppKey()) || StringUtils.isBlank((CharSequence)node.getNodeFilter())) {
                retVal.put("error", "\u540c\u6b65\u8282\u70b9\u7684appkey\u6216filter\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                return retVal;
            }
            int count = this.tbSyncUisNodeDao.create(node);
            if (count == 1) {
                retVal.put("result", true);
            }
        }
        catch (Exception e) {
            retVal.put("error", e.getMessage());
        }
        return retVal;
    }

    public void publishSyncMsg(SyncUisData data, String regionFiler) {
        this.enableSync = (Boolean)ProjectConfig.getConfig((String)ProjectConfigEnum.ENABLE_SYNCUIS.getKey());
        if (!this.enableSync) {
            return;
        }
        GutilAssert.notNull((Object)data, (String)"parameter 'data' must not be null .");
        List syncNodeList = this.tbSyncUisNodeDao.queryAll();
        if (!GutilCollection.isEmpty((Collection)syncNodeList)) {
            for (TbSyncNode node : syncNodeList) {
                try {
                    String queueName = this.getQueueName(node);
                    String content = JSONObject.toJSONString((Object)data).toString();
                    log.info("\u53d1\u9001\u540c\u6b65\u6d88\u606f\u961f\u5217\u540d\u79f0\uff1a" + queueName + " \u5185\u5bb9\uff1a" + content, new Object[0]);
                    byte[] bytes = content.getBytes();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(ActiveMQConstant.SERVICE_NAME, "SYNCUIS-RECEIVE-MESSAGE");
                    map.put("data", bytes);
                    this.producerService.sendMapMessage2Queue(map, queueName);
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001\u540c\u6b65\u6d88\u606f\u5f02\u5e38\uff1a", new Object[]{e});
                }
            }
        }
    }

    public void publishSyncMsgNew(JSONObject data, String regionFiler) {
        this.enableSync = (Boolean)ProjectConfig.getConfig((String)ProjectConfigEnum.ENABLE_SYNCUIS.getKey());
        if (!this.enableSync) {
            return;
        }
        GutilAssert.notNull((Object)data, (String)"parameter 'data' must not be null .");
        List syncNodeList = this.tbSyncUisNodeDao.queryAll();
        if (!GutilCollection.isEmpty((Collection)syncNodeList)) {
            for (TbSyncNode node : syncNodeList) {
                try {
                    String queueName = this.getQueueName(node);
                    String content = JSONObject.toJSONString((Object)data).toString();
                    log.info("\u53d1\u9001\u540c\u6b65\u6d88\u606f\u961f\u5217\u540d\u79f0\uff1a" + queueName + " \u5185\u5bb9\uff1a" + content, new Object[0]);
                    byte[] bytes = content.getBytes();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put(ActiveMQConstant.SERVICE_NAME, "SYNCUIS-RECEIVE-MESSAGE");
                    map.put("data", bytes);
                    this.producerService.sendMapMessage2Queue(map, queueName);
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001\u540c\u6b65\u6d88\u606f\u5f02\u5e38\uff1a", new Object[]{e});
                }
            }
        }
    }

    public void subscribeSyncMsgNew(JSONObject data) throws Exception {
        this.enableSync = (Boolean)ProjectConfig.getConfig((String)ProjectConfigEnum.ENABLE_SYNCUIS.getKey());
        if (!this.enableSync) {
            return;
        }
        if (data != null) {
            LandUser userUpdateInfo;
            LandUser landUser;
            Object bean;
            if (data.get((Object)"type").equals("insert")) {
                Object bean2 = JSONObject.toJavaObject((JSON)data.getJSONObject("userInfo"), UserAddInfo.class);
                Object organizationBean = JSONObject.toJavaObject((JSON)data.getJSONObject("organization"), Organization.class);
                if (bean2 != null) {
                    try {
                        Organization organization;
                        UserAddInfo userAddInfo = (UserAddInfo)bean2;
                        if (organizationBean != null && (organization = (Organization)organizationBean) != null) {
                            Organization organizations = this.organizationRepository.queryByNameAndRegion(organization.getName(), organization.getRegionCode());
                            if (organizations == null) {
                                Organization org = this.organizationService.create(organization.getName(), organization.getRegionCode(), null, null, organization.getType());
                                userAddInfo.setDepNo(org.getId());
                            } else {
                                userAddInfo.setDepNo(organizations.getId());
                            }
                        }
                        userAddInfo.setId(null);
                        this.processSyncDataNew(userAddInfo);
                    }
                    catch (Exception e) {
                        log.error("Exception:" + e.getMessage(), new Object[0]);
                        throw e;
                    }
                }
            } else if (data.get((Object)"type").equals("delete")) {
                LandUser landUser2;
                LandUser landUser1;
                Object bean3 = JSONObject.toJavaObject((JSON)data.getJSONObject("user"), LandUser.class);
                if (bean3 != null && (landUser1 = this.landUserService.queryAppUserByUsernamePhone((landUser2 = (LandUser)bean3).getPhone())) != null) {
                    landUser2.setId(landUser1.getId());
                    this.landUserDao.save((Object)landUser2);
                }
            } else if (data.get((Object)"type").equals("update")) {
                Object bean4 = JSONObject.toJavaObject((JSON)data.getJSONObject("userInfo"), UserUpdateInfo.class);
                Object organizationBean = JSONObject.toJavaObject((JSON)data.getJSONObject("organization"), Organization.class);
                if (bean4 != null) {
                    LandUser landUser3;
                    Organization organization;
                    UserUpdateInfo userUpdateInfo2 = (UserUpdateInfo)bean4;
                    if (organizationBean != null && (organization = (Organization)organizationBean) != null) {
                        Organization organizations = this.organizationRepository.queryByNameAndRegion(organization.getName(), organization.getRegionCode());
                        if (organizations == null) {
                            Organization org = this.organizationService.create(organization.getName(), organization.getRegionCode(), null, null, organization.getType());
                            userUpdateInfo2.setDepNo(org.getId());
                        } else {
                            userUpdateInfo2.setDepNo(organizations.getId());
                        }
                    }
                    if ((landUser3 = this.landUserService.queryAppUserByUsernamePhone(userUpdateInfo2.getPhone())) != null) {
                        userUpdateInfo2.setUserId(landUser3.getId());
                        this.landUserService.updateUserByAdmin(userUpdateInfo2);
                        String config = userUpdateInfo2.getCloudQueryConfig();
                        this.roleCloudQueryRelRepository.deleteByUserId(userUpdateInfo2.getUserId().toString());
                        if (StringUtils.isNotBlank((CharSequence)config)) {
                            String[] strs = config.split(",");
                            ArrayList<RoleCloudQueryRel> list = new ArrayList<RoleCloudQueryRel>();
                            for (int i = 0; i < strs.length; ++i) {
                                RoleCloudQueryRel ucc = new RoleCloudQueryRel();
                                ucc.setUid(userUpdateInfo2.getUserId().toString());
                                ucc.setCid(strs[i].trim());
                                list.add(ucc);
                            }
                            this.roleCloudQueryRelRepository.saveAll(list);
                        }
                    }
                }
            } else if (data.get((Object)"type").equals("updatePassword") && (bean = JSONObject.toJavaObject((JSON)data.getJSONObject("landUser"), LandUser.class)) != null && (landUser = this.landUserService.queryAppUserByUsernamePhone((userUpdateInfo = (LandUser)bean).getPhone())) != null) {
                this.landUserService.updatePassword(landUser.getId(), userUpdateInfo.getPassword(), userUpdateInfo.getPswtip());
            }
        }
    }

    @Transactional
    public void processSyncDataNew(UserAddInfo userInfo) throws Exception {
        Object userAppLists;
        Object appIds;
        String[] tempKeys;
        List<String> keys;
        LandUser landUser = this.landUserService.addUser(userInfo);
        userInfo.setId(landUser.getId() + "");
        if (userInfo.getRoleIds().indexOf("10020") > -1) {
            Organization organization = this.organizationRepository.findById((Object)userInfo.getDepNo()).orElse(null);
            if (organization == null) {
                throw new RuntimeException("\u5355\u4f4d\u4e0d\u5b58\u5728");
            }
            CloudDiskOfOrg cloudDiskOfOrg = this.cloudDiskOfOrgDao.findById((Object)organization.getId()).orElse(null);
            if (cloudDiskOfOrg == null) {
                ArrayList<String> orgIdList = new ArrayList<String>();
                orgIdList.add(organization.getId());
            }
        }
        ArrayList<String> ywCodes = new ArrayList<String>();
        String zxyw = userInfo.getZxyw();
        if (StringUtils.isNotBlank((CharSequence)zxyw)) {
            String[] split = zxyw.split(",");
            if (zxyw.indexOf(";") > -1) {
                split = zxyw.split(";");
            }
            ArrayList<UserBizSupervision> userAppLists2 = new ArrayList<UserBizSupervision>();
            for (int i = 0; i < split.length; ++i) {
                ywCodes.add(split[i]);
                String uid = UUID.randomUUID().toString();
                UserBizSupervision userApp = new UserBizSupervision();
                userApp.setId(uid);
                userApp.setTaskcode(split[i]);
                userApp.setUserid(landUser.getId());
                userAppLists2.add(userApp);
            }
            this.userBizSupervisionDao.saveAll(userAppLists2);
        }
        this.appkey = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.OAUTH_APPKEY.getKey());
        this.appkeys = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.OAUTH_APPKEYS.getKey());
        if (ywCodes.size() > 0) {
            keys = this.applicationCodeService.getKeyByCode(ywCodes);
            if (keys.indexOf(this.appkey) < 0) {
                keys.add(this.appkey);
            }
            for (String tempKey : tempKeys = this.appkeys.split(",")) {
                if (keys.indexOf(tempKey) >= 0) continue;
                keys.add(tempKey);
            }
            appIds = this.UisApplicationDao.getIdByAppKey(keys);
            userAppLists = new ArrayList();
            Iterator userApp = appIds.iterator();
            while (userApp.hasNext()) {
                String key = (String)userApp.next();
                UserApplication userApp2 = new UserApplication();
                String uid = UUID.randomUUID().toString();
                userApp2.setId(uid);
                userApp2.setApplicationId(key);
                userApp2.setUserId(landUser.getId());
                userAppLists.add(userApp2);
            }
            if (userAppLists.size() > 0) {
                this.userApplicationDao.saveAll((Iterable)userAppLists);
            }
        } else {
            keys = new ArrayList();
            keys.add(this.appkey);
            tempKeys = this.appkeys.split(",");
            for (String tempKey : tempKeys) {
                if (keys.indexOf(tempKey) >= 0) continue;
                keys.add(tempKey);
            }
            appIds = this.UisApplicationDao.getIdByAppKey(keys);
            userAppLists = appIds.iterator();
            while (userAppLists.hasNext()) {
                String key = (String)userAppLists.next();
                UserApplication userApp = new UserApplication();
                String uid = UUID.randomUUID().toString();
                userApp.setId(uid);
                userApp.setApplicationId(key);
                userApp.setUserId(landUser.getId());
                this.userApplicationDao.save((Object)userApp);
            }
        }
        String config = userInfo.getCloudQueryConfig();
        if (StringUtils.isNotBlank((CharSequence)config)) {
            String[] strs = config.split(",");
            ArrayList<RoleCloudQueryRel> list = new ArrayList<RoleCloudQueryRel>();
            for (int i = 0; i < strs.length; ++i) {
                RoleCloudQueryRel ucc = new RoleCloudQueryRel();
                ucc.setUid(landUser.getId().toString());
                ucc.setCid(strs[i].trim());
                list.add(ucc);
            }
            this.roleCloudQueryRelRepository.saveAll(list);
        }
    }

    private String getQueueName(TbSyncNode node) {
        return String.format("%s|%s|%s", QUEUE_PRE_FIX, node.getNodeAppKey(), node.getNodeFilter());
    }

    public void subscribeSyncMsg(Object data) throws Exception {
        Object bean;
        this.enableSync = (Boolean)ProjectConfig.getConfig((String)ProjectConfigEnum.ENABLE_SYNCUIS.getKey());
        if (!this.enableSync) {
            return;
        }
        if (data != null && data instanceof JSONObject && (bean = JSONObject.toJavaObject((JSON)((JSONObject)data), SyncUisData.class)) != null) {
            SyncUisData syncUisData = (SyncUisData)bean;
            try {
                this.processSyncData(syncUisData);
            }
            catch (Exception e) {
                log.error("Exception:" + e.getMessage(), new Object[0]);
                throw e;
            }
        }
    }

    public List<String> getSyncUisQueueName() {
        LinkedList<String> result = new LinkedList<String>();
        List syncNodeList = this.tbSyncUisNodeDao.queryAll();
        if (!GutilCollection.isEmpty((Collection)syncNodeList)) {
            for (TbSyncNode node : syncNodeList) {
                String queueName = this.getQueueName(node);
                result.add(queueName);
            }
        }
        return result;
    }

    private void processSyncData(SyncUisData syncUisData) throws Exception {
        String msg = this.checkSyncData(syncUisData);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new RuntimeException(msg);
        }
        String sql = this.parseSyncData(syncUisData);
        this.jdbcTemplate.execute(sql);
    }

    private String parseSyncData(SyncUisData syncUisData) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (syncUisData.getOption().trim().toUpperCase()) {
            case "INSERT": {
                int i;
                stringBuilder.append(" INSERT INTO ").append(syncUisData.getTableName()).append(" ( ");
                for (i = 0; i < syncUisData.getColumnNames().size(); ++i) {
                    stringBuilder.append((String)syncUisData.getColumnNames().get(i));
                    if (i >= syncUisData.getColumnNames().size() - 1) continue;
                    stringBuilder.append(" , ");
                }
                stringBuilder.append(" ) ").append(" VALUES ( ");
                for (i = 0; i < syncUisData.getColumnValuesAfter().size(); ++i) {
                    String valueStr = this.getValueStr(syncUisData.getColumnValuesAfter().get(i), (String)syncUisData.getColumnTypes().get(i));
                    stringBuilder.append(valueStr);
                    if (i >= syncUisData.getColumnNames().size() - 1) continue;
                    stringBuilder.append(" , ");
                }
                stringBuilder.append(" );");
                break;
            }
            case "UPDATE": {
                stringBuilder.append(" UPDATE ").append(syncUisData.getTableName()).append(" SET ");
                for (int i = 0; i < syncUisData.getColumnNames().size(); ++i) {
                    stringBuilder.append((String)syncUisData.getColumnNames().get(i)).append(" = ");
                    String valueStr = this.getValueStr(syncUisData.getColumnValuesAfter().get(i), (String)syncUisData.getColumnTypes().get(i));
                    stringBuilder.append(valueStr);
                    if (i >= syncUisData.getColumnNames().size() - 1) continue;
                    stringBuilder.append(" , ");
                }
                stringBuilder.append(" WHERE ").append(syncUisData.getKeyName()).append(" = ");
                String keyValueStr = this.getValueStr(syncUisData.getKeyValue(), syncUisData.getKeyType());
                stringBuilder.append(keyValueStr);
                break;
            }
            case "DELETE": {
                stringBuilder.append(" DELETE FROM ").append(syncUisData.getTableName());
                stringBuilder.append(" WHERE ").append(syncUisData.getKeyName()).append(" = ");
                String keyValueStr = this.getValueStr(syncUisData.getKeyValue(), syncUisData.getKeyType());
                stringBuilder.append(keyValueStr);
                break;
            }
        }
        return stringBuilder.toString();
    }

    private String getValueStr(Object value, String type) {
        String result = "''";
        switch (type.trim().toUpperCase()) {
            case "NUMBER": {
                result = value.toString();
                break;
            }
            case "STRING": 
            case "GEOMETRY": {
                if (value == null) {
                    result = "''";
                    break;
                }
                result = "'" + value.toString() + "'";
                break;
            }
            case "DATETIME": {
                if (value == null) {
                    result = "''";
                    break;
                }
                result = "'" + value.toString() + "'";
                break;
            }
        }
        return result;
    }

    private String checkSyncData(SyncUisData syncUisData) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)syncUisData.getTableName())) {
            stringBuilder.append("[tableName]\u4e0d\u80fd\u4e3a\u7a7a\uff01/n");
        }
        if (StringUtils.isBlank((CharSequence)syncUisData.getOption())) {
            stringBuilder.append("[option]\u4e0d\u80fd\u4e3a\u7a7a\uff01/n");
        } else if (syncUisData.getOption().trim().equalsIgnoreCase("insert")) {
            this.checkDataColumns(syncUisData, stringBuilder);
        } else if (syncUisData.getOption().trim().equalsIgnoreCase("update")) {
            if (StringUtils.isBlank((CharSequence)syncUisData.getKeyName())) {
                stringBuilder.append("[keyName]\u4e0d\u80fd\u4e3a\u7a7a\uff01/n");
            }
            this.checkDataColumns(syncUisData, stringBuilder);
        } else if (syncUisData.getOption().trim().equalsIgnoreCase("delete")) {
            if (StringUtils.isBlank((CharSequence)syncUisData.getKeyName())) {
                stringBuilder.append("[keyName]\u4e0d\u80fd\u4e3a\u7a7a\uff01/n");
            }
        } else {
            stringBuilder.append("[option]\u4e0d\u5728\u503c\u57df\u8303\u56f4[insert\u3001update\u3001delete]\u5185\uff01/n");
        }
        return stringBuilder.toString();
    }

    private void checkDataColumns(SyncUisData syncUisData, StringBuilder stringBuilder) {
        if (GutilCollection.isEmpty((Collection)syncUisData.getColumnNames())) {
            stringBuilder.append("[columnNames]\u4e0d\u80fd\u4e3a\u7a7a\uff01/n");
        } else {
            for (String columnName : syncUisData.getColumnNames()) {
                if (!StringUtils.isBlank((CharSequence)columnName)) continue;
                stringBuilder.append("[columnNames]\u4e2d\u4e0d\u80fd\u5305\u542b\u7a7a\u5217\u540d\uff01/n");
                break;
            }
        }
        if (GutilCollection.isEmpty((Collection)syncUisData.getColumnTypes())) {
            stringBuilder.append("[columnTypes]\u4e0d\u80fd\u4e3a\u7a7a\uff01/n");
        } else {
            for (String columnType : syncUisData.getColumnTypes()) {
                if (StringUtils.isBlank((CharSequence)columnType)) {
                    stringBuilder.append("[columnTypes]\u4e2d\u4e0d\u80fd\u5305\u542b\u7a7a\u5217\u7c7b\u578b\uff01/n");
                    break;
                }
                if (columnType.equalsIgnoreCase("NUMBER") || columnType.equalsIgnoreCase("STRING") || columnType.equalsIgnoreCase("DATETIME") || columnType.equalsIgnoreCase("GEOMETRY")) continue;
                stringBuilder.append("[columnTypes]\u4e2d\u67d0\u5217\u7c7b\u578b\u4e0d\u5728\u503c\u57df\u8303\u56f4[NUMBER\u3001STRING\u3001DATETIME\u3001GEOMETRY]\u5185\uff01/n");
                break;
            }
        }
        if (GutilCollection.isEmpty((Collection)syncUisData.getColumnValuesAfter())) {
            stringBuilder.append("[columnValuesAfter]\u4e0d\u80fd\u4e3a\u7a7a\uff01/n");
        }
        if (syncUisData.getColumnNames().size() != syncUisData.getColumnTypes().size() || syncUisData.getColumnNames().size() != syncUisData.getColumnValuesAfter().size() || syncUisData.getColumnTypes().size() != syncUisData.getColumnValuesAfter().size()) {
            stringBuilder.append("[columnNames\u3001columnTypes\u3001columnValuesAfter]\u96c6\u5408\u7684\u957f\u5ea6\u4e0d\u4e00\u81f4\uff01/n");
        }
    }
}

