/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.user;

import com.geoway.landteam.landcloud.core.model.pub.entity.SysFaq;
import com.geoway.landteam.landcloud.core.model.user.entity.Feedback;
import com.geoway.landteam.landcloud.core.repository.pub.SysFaqRepository;
import com.geoway.landteam.landcloud.core.repository.user.FeedbackRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class FeedbackService {
    @Autowired
    FeedbackRepository feedbackDao;
    @Autowired
    SysFaqRepository sysFaqDao;

    public void addFeedback(Feedback feedback) {
        feedback.setStatus(Integer.valueOf(0));
        feedback.setCreatetime(new Date());
        this.feedbackDao.save((Object)feedback);
    }

    public Page<Feedback> getFeebackByCondition(final Long userId, final Integer status, final Integer level, Integer page, Integer pageSize, String sort, final String condition) {
        if (pageSize == null) {
            pageSize = 30;
        }
        PageRequest pageable = null;
        if (sort != null) {
            Sort orders = null;
            if ("asc".equals(sort)) {
                orders = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"createtime"});
            } else if ("desc".equals(sort)) {
                orders = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createtime"});
            }
            pageable = PageRequest.of((int)page, (int)pageSize, (Sort)orders);
        } else {
            pageable = PageRequest.of((int)page, (int)pageSize);
        }
        Page result = this.feedbackDao.findAll((Specification)new Specification<Feedback>(){

            public Predicate toPredicate(Root<Feedback> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Predicate predicate = null;
                if (userId != null) {
                    predicate = cb.equal((Expression)root.get("userId"), (Object)userId);
                }
                if (status != null) {
                    predicate = predicate == null ? cb.equal((Expression)root.get("status"), (Object)status) : cb.and((Expression)predicate, (Expression)cb.equal((Expression)root.get("status"), (Object)status));
                }
                if (level != null) {
                    predicate = predicate == null ? cb.equal((Expression)root.get("level"), (Object)level) : cb.and((Expression)predicate, (Expression)cb.equal((Expression)root.get("level"), (Object)level));
                }
                if (condition != null) {
                    predicate = predicate == null ? cb.or((Expression)cb.like(root.get("content").as(String.class), "%" + condition + "%"), (Expression)cb.like(root.get("username").as(String.class), "%" + condition + "%")) : cb.and((Expression)predicate, (Expression)cb.or((Expression)cb.like(root.get("content").as(String.class), "%" + condition + "%"), (Expression)cb.like(root.get("username").as(String.class), "%" + condition + "%")));
                }
                return predicate;
            }
        }, (Pageable)pageable);
        return result;
    }

    public List getStatusCountByGroup() {
        return this.feedbackDao.getStatusCountByGroup();
    }

    public void addAnswerForFeedback(int feedbackId, String answer) {
        this.feedbackDao.addAnswerForFeedback(feedbackId, answer, new Date());
    }

    public Feedback addAnswer(int feedbackId, String answer) {
        Feedback feedback = this.feedbackDao.findById((Object)feedbackId).orElse(null);
        if (feedback != null) {
            feedback.setStatus(Integer.valueOf(1));
            feedback.setAnswer(answer);
            feedback.setReplytime(new Date());
            this.feedbackDao.save((Object)feedback);
        }
        return feedback;
    }

    public String importJctb(String unzipFileDir) {
        File file = null;
        String result = "";
        try {
            file = new File(unzipFileDir);
            File[] content = file.listFiles();
            for (int j = 0; j < content.length; ++j) {
                String name = content[j].getName();
                if (!name.contains(".xlsx") && !name.contains(".xls")) continue;
                String path = content[j].getCanonicalPath();
                this.importTaskFromExcel(path);
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private void importTaskFromExcel(String excelFile) throws Exception {
        Workbook workbook = null;
        FileOutputStream out = null;
        Object is = null;
        File file = new File(excelFile);
        FileInputStream inputStream = new FileInputStream(file);
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        workbook = WorkbookFactory.create((InputStream)inputStream);
        ((InputStream)inputStream).close();
        Sheet sheet = workbook.getSheet("faq");
        Row row = sheet.getRow(0);
        int colNumber = row.getPhysicalNumberOfCells();
        int rowCount = sheet.getPhysicalNumberOfRows();
        this.sysFaqDao.deleteAll();
        for (int i = 1; i < rowCount; ++i) {
            row = sheet.getRow(i);
            if (row == null) continue;
            SysFaq faq = new SysFaq();
            for (int j = 0; j < colNumber; ++j) {
                String base64;
                String imgFile;
                Cell cell = row.getCell(j);
                String txt = this.findCellValue(cell);
                if (StringUtils.isBlank((CharSequence)txt)) continue;
                if (j == 0) {
                    faq.setSystem(Integer.valueOf(Integer.parseInt(txt)));
                    continue;
                }
                if (j == 1) {
                    faq.setModel(Integer.valueOf(Integer.parseInt(txt)));
                    continue;
                }
                if (j == 2) {
                    faq.setQuestionsort(Integer.valueOf(Integer.parseInt(txt)));
                    continue;
                }
                if (j == 3) {
                    faq.setQuestion(txt);
                    continue;
                }
                if (j == 4) {
                    faq.setAnswersort(Integer.valueOf(Integer.parseInt(txt)));
                    continue;
                }
                if (j == 5) {
                    faq.setAnswer(txt);
                    continue;
                }
                if (j == 6) {
                    imgFile = parentFile.getCanonicalPath() + File.separator + txt;
                    base64 = this.getImgStr(imgFile);
                    faq.setPicture("data:image/png;base64," + base64);
                    continue;
                }
                if (j == 7) {
                    faq.setAnswerbz(txt);
                    continue;
                }
                if (j == 8) {
                    faq.setExplain(txt);
                    continue;
                }
                if (j == 9) {
                    faq.setExplaindetails(txt);
                    continue;
                }
                if (j == 10) {
                    imgFile = parentFile.getCanonicalPath() + File.separator + txt;
                    base64 = this.getImgStr(imgFile);
                    faq.setExplainpic("data:image/png;base64," + base64);
                    continue;
                }
                if (j != 11) continue;
                faq.setExplainbz(txt);
            }
            this.sysFaqDao.save((Object)faq);
        }
        out = new FileOutputStream(file);
        workbook.write((OutputStream)out);
        out.flush();
        ((OutputStream)out).close();
    }

    private String findCellValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return "";
        }
        try {
            CellType cellType = cell.getCellType();
            switch (cellType) {
                case STRING: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                        cellValue = fmt.format(cell.getDateCellValue());
                        break;
                    }
                    cellValue = String.valueOf((long)cell.getNumericCellValue());
                    break;
                }
                case BOOLEAN: {
                    cellValue = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case BLANK: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case ERROR: {
                    cellValue = "\u9519\u8bef";
                    break;
                }
                case FORMULA: {
                    cellValue = "\u9519\u8bef";
                    break;
                }
                default: {
                    cellValue = "\u9519\u8bef";
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return cellValue.trim();
    }

    private String getImgStr(String imgFile) {
        FileInputStream in = null;
        byte[] data = null;
        String result = "";
        try {
            in = new FileInputStream(imgFile);
            if (in != null) {
                data = new byte[((InputStream)in).available()];
                ((InputStream)in).read(data);
                ((InputStream)in).close();
                result = new String(Base64.encodeBase64((byte[])data));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

