/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.user;

import com.geoway.landteam.customtask.service.task.TaskNoticeServiceImpl;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.user.entity.LandRegUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser2Area;
import com.geoway.landteam.landcloud.core.model.user.entity.UserAreaApply;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandRegUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserAreaApplyRepository;
import com.gw.base.data.GwValidateException;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MLandUserAreaService {
    @Autowired
    UserAreaApplyRepository userAreaApplyDao;
    @Autowired
    LandUser2AreaRepository landUser2AreaDao;
    @Autowired
    RegionRepository regionDao;
    @Autowired
    TaskNoticeServiceImpl noticeService;
    @Autowired
    LandRegUserRepository landRegDao;
    @Autowired
    RegionVersionRepository regionVersionRepository;

    public Page<UserAreaApply> queryByFilter(String filterParam, String sortParam, int start, int limit) {
        Page results = this.userAreaApplyDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return results;
    }

    public void avalArea(Long sendUserId, String id, int state) {
        boolean isExists;
        UserAreaApply userAreaApply = this.userAreaApplyDao.findById((Object)id).orElse(null);
        boolean bl = isExists = this.landUser2AreaDao.queryUserAreasIsExists(userAreaApply.getUserId(), userAreaApply.getApplyRegion()) > 0;
        if (state == 1 && !isExists) {
            LandUser2Area userArea = new LandUser2Area();
            userArea.setCreateTime(new Date());
            userArea.setRegionCode(userAreaApply.getApplyRegion());
            userArea.setUserId(userAreaApply.getUserId());
            userArea.setState(Integer.valueOf(1));
            this.landUser2AreaDao.save((Object)userArea);
        }
        userAreaApply.setState(Integer.valueOf(state));
        this.userAreaApplyDao.save((Object)userAreaApply);
        LandUser user = userAreaApply.getUser();
        RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
        String regionName = this.regionDao.getNameByCodeAndVersion(userAreaApply.getApplyRegion(), defaultVersion != null ? defaultVersion.getVersion() : "2018");
        String message = user.getName() + "\u4f60\u597d\uff1a\u4f60\u7533\u8bf7\u7684\u5de5\u4f5c\u533a\u57df\uff08" + regionName + "\uff09\u5df2\u7ecf\u5ba1\u6838\u901a\u8fc7";
        if (state == 1) {
            message = user.getName() + "\u4f60\u597d\uff1a\u4f60\u7533\u8bf7\u7684\u5de5\u4f5c\u533a\u57df\uff08" + regionName + "\uff09\u672a\u80fd\u5ba1\u6838\u901a\u8fc7";
        }
        this.noticeService.addTextNotice("\u533a\u57df\u7533\u8bf7\u7ed3\u679c\u901a\u77e5", message, sendUserId.longValue(), userAreaApply.getUserId().longValue());
    }

    public void addUserAreaApply(Long userId, String regionCode, String reason) throws Exception {
        int iExists = this.userAreaApplyDao.queryUserAreaApplyIsExists(userId, regionCode);
        if (iExists > 0) {
            throw new GwValidateException("\u8be5\u533a\u57df\u5df2\u7533\u8bf7");
        }
        int isApply = this.landUser2AreaDao.queryUserAreasIsApply(userId, regionCode);
        if (isApply > 0) {
            throw new GwValidateException("\u8be5\u533a\u57df\u5df2\u7533\u8bf7");
        }
        int isExists = this.landUser2AreaDao.queryUserAreasIsExists(userId, regionCode);
        LandRegUser regUser = this.landRegDao.findByUserID(userId);
        Date now = new Date();
        if (isExists == 0) {
            LandUser2Area userArea = new LandUser2Area();
            userArea.setRegionCode(regionCode);
            userArea.setUserId(userId);
            userArea.setState(Integer.valueOf(0));
            userArea.setCreateTime(now);
            this.landUser2AreaDao.save((Object)userArea);
        } else {
            this.landUser2AreaDao.updateStateByRegionAndUser(Integer.valueOf(0), now, userId, regionCode);
        }
        UserAreaApply apply = this.userAreaApplyDao.queryUserAreaApply(userId, regionCode);
        if (apply != null && (apply == null || apply.getState() != 2)) {
            throw new GwValidateException("\u8be5\u533a\u57df\u5df2\u7533\u8bf7");
        }
        UserAreaApply userAreaApply = new UserAreaApply();
        userAreaApply.setUserId(userId);
        userAreaApply.setApplyRegion(regionCode);
        userAreaApply.setReason(reason);
        userAreaApply.setCreateTime(new Date());
        this.userAreaApplyDao.save((Object)userAreaApply);
        LandRegUser landRegUser = this.landRegDao.findByUserID(userId);
    }

    public boolean findCountByUserId(Long userId) {
        return this.landUser2AreaDao.queryUserAreasCount(userId) > 0;
    }

    public List<Long> findUserIdByCodeAndState(String regionCode, Integer state) {
        List list = this.landUser2AreaDao.queryByCodeAndState(regionCode, state);
        return list;
    }

    public Integer queryUserAreasIsExists(Long userId, String regionCode) {
        return this.landUser2AreaDao.queryUserAreasIsExists(userId, regionCode);
    }
}

