/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.user;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.User2BizRepository;
import com.geoway.landteam.customtask.servface.task.TbtskUserManageAreaService;
import com.geoway.landteam.customtask.task.entity.User2Biz;
import com.geoway.landteam.landcloud.common.dto.EasyUIResponse;
import com.geoway.landteam.landcloud.common.support.jfunboxUtils.JFunBoxUserUtil;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.pub.dto.Third.UserGrant;
import com.geoway.landteam.landcloud.core.model.pub.dto.Third.UserIdCls;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserAddInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.AvalUser;
import com.geoway.landteam.landcloud.core.model.pub.entity.CloudDiskOfPerson;
import com.geoway.landteam.landcloud.core.model.pub.entity.Department;
import com.geoway.landteam.landcloud.core.model.pub.entity.Department2User;
import com.geoway.landteam.landcloud.core.model.pub.entity.GroupCloudDiskMember;
import com.geoway.landteam.landcloud.core.model.pub.entity.OptLog;
import com.geoway.landteam.landcloud.core.model.pub.entity.OrgCloudDiskMember;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.model.pub.entity.RegionUser;
import com.geoway.landteam.landcloud.core.model.pub.entity.Right;
import com.geoway.landteam.landcloud.core.model.pub.entity.UserCloudArea;
import com.geoway.landteam.landcloud.core.model.user.entity.LandRegUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser2Area;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUserDetail;
import com.geoway.landteam.landcloud.core.model.user.entity.SysRoleInfo;
import com.geoway.landteam.landcloud.core.model.user.entity.UserRoleInfo;
import com.geoway.landteam.landcloud.core.model.user.entity.UserRoleRight;
import com.geoway.landteam.landcloud.core.model.user.entity.YXUser;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.pub.AvalUserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.CloudDiskOfOrgRepository;
import com.geoway.landteam.landcloud.core.repository.pub.CloudDiskOfPersonRepository;
import com.geoway.landteam.landcloud.core.repository.pub.Department2UserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.DepartmentRepository;
import com.geoway.landteam.landcloud.core.repository.pub.DeviceRepository;
import com.geoway.landteam.landcloud.core.repository.pub.GroupCloudDiskMemberRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OptLogRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OrgCloudDiskMemberRepository;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OrganizationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.RegionUserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.RightRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UserApplicationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.UserCloudAreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.FriendsRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandRegUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2TypeRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserDetailRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRoleRepository;
import com.geoway.landteam.landcloud.core.repository.user.User2YXRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserProblemTypesRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserRoleInfoRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserRoleRightRepository;
import com.geoway.landteam.landcloud.core.repository.user.YXUserRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.LandRegUserService;
import com.geoway.landteam.landcloud.core.service.pub.impl.DepartmentServiceImpl;
import com.geoway.landteam.landcloud.core.service.user.LandUserAreaServiceImpl;
import com.geoway.landteam.landcloud.core.service.user.LandUserRoleServiceImpl;
import com.geoway.landteam.landcloud.core.service.util.CheckUtil;
import com.geoway.landteam.landcloud.core.service.util.LandUserBuilder;
import com.geoway.landteam.landcloud.servface.oauth.OauthOrganizationService;
import com.geoway.landteam.landcloud.servface.oauth.OauthUserService;
import com.geoway.landteam.platform.business.res3.api.bususer.reso.BusUserInfoReso;
import com.gw.base.Gw;
import com.gw.base.data.GwValidateException;
import com.gw.base.util.GutilStr;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class MLandUserService {
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    LandUserRepository landUserDao;
    @Autowired
    LandUserDetailRepository landUserDetailDao;
    @Autowired
    RegionVersionRepository regionVersionRepository;
    @Autowired
    LandRegUserRepository landRegUserDao;
    @Autowired
    RegionService regionService;
    @Autowired
    DeviceRepository deviceDao;
    @Autowired
    User2YXRepository user2YXDao;
    @Autowired
    LandUser2AreaRepository landUser2AreaDao;
    @Autowired
    RegionUserRepository regionUserDao;
    @Autowired
    RegionRepository regionDao;
    @Autowired
    LandUserRoleRepository landUserRoleDao;
    @Autowired
    AvalUserRepository avalUserDao;
    @Autowired
    LandUser2TypeRepository landUser2TypeDao;
    @Autowired
    UserProblemTypesRepository userProblemTypesDao;
    @Autowired
    RightRepository rightDao;
    @Autowired
    UserRoleRightRepository userRoleRightDao;
    @Autowired
    YXUserRepository yxUserRepository;
    @Autowired
    LandRegUserService landRegUserService;
    @Autowired
    LandUserAreaServiceImpl landUserAreaService;
    @Autowired
    OrganizationRepository organizationRepository;
    @Autowired
    Organization2UserRepository organization2UserDao;
    @Autowired
    Department2UserRepository department2UserDao;
    @Autowired
    DepartmentRepository departmentDao;
    @Autowired
    DepartmentServiceImpl departmentService;
    @Autowired
    FriendsRepository friendsDao;
    @Autowired
    UserCloudAreaRepository userCloudAreaDao;
    @Autowired
    UserApplicationRepository userApplicationRepository;
    @Autowired
    CloudDiskOfPersonRepository cloudDiskOfPersonDao;
    @Autowired
    CloudDiskOfOrgRepository cloudDiskOfOrgDao;
    @Autowired
    OrgCloudDiskMemberRepository orgCloudDiskMemberDao;
    @Autowired
    GroupCloudDiskMemberRepository groupCloudDiskMemberDao;
    @Autowired
    OptLogRepository optLogRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    UserRoleInfoRepository userRoleInfoDao;
    @Autowired
    LandUserRoleServiceImpl userRoleService;
    @Autowired
    User2BizRepository user2BizRepository;
    @Autowired
    DepartmentRepository departmentRepository;
    @Autowired
    TbtskUserManageAreaService tbtskUserManageAreaService;
    @Autowired
    OauthUserService oauthUserService;
    @Autowired
    OauthOrganizationService organizationService;
    static final String GLY_TABLE_NAME = "tbtsk_user_manage_area";
    static final String SHY_TABLE_NAME = "tbtsk_user_audit_area";
    static final String ZYY_TABLE_NAME = "tbtsk_right_area";
    static final String FHY_TABLE_NAME = "tbtsk_user_review_area";
    static final String CJSHY_TABLE_NAME = "tbtsk_super_user_audit_area";
    static final String SCY_TABLE_NAME = "tbtsk_user_upload_area";

    public LandUser queryUserByName(String name) {
        List users = this.landUserDao.queryUserByName(name);
        LandUser myUser = null;
        if (users.size() > 0) {
            myUser = (LandUser)users.get(0);
        }
        return myUser;
    }

    public LandUser queryUserByPhone(String name) {
        List users = this.landUserDao.queryUserByPhone(name);
        LandUser myUser = null;
        if (users.size() > 0) {
            myUser = (LandUser)users.get(0);
        }
        return myUser;
    }

    public RegionUser queryRegionUserByName(String name) {
        List users = this.regionUserDao.queryUserByName(name);
        RegionUser myUser = null;
        if (users.size() > 0) {
            myUser = (RegionUser)users.get(0);
        }
        return myUser;
    }

    public List<Long> queryUserIdByRnameAndRole(String name) {
        List userIds = this.landUserDao.queryUserIdByRnameAndRole(name);
        List<Long> result = new ArrayList<Long>();
        if (userIds.size() > 0) {
            result = this.landUserRoleDao.getUserByRoleAndUser(Long.valueOf(10004L), userIds);
        }
        return result;
    }

    public List<Long> queryUserIdByRname(String name) {
        List userIds = this.landUserDao.queryUserIdByRname("%" + name + "%");
        return userIds;
    }

    public Integer findRegUserStatus(String userName) {
        String filterParam = "Q_name_S_EQ=" + userName;
        List results = this.landRegUserDao.findAll((Specification)new QuerySpecification(filterParam));
        Integer tag = 1;
        if (results != null && results.size() > 0) {
            LandRegUser regUser = (LandRegUser)results.get(0);
            if (regUser.getState() == 0) {
                tag = 6;
            } else if (regUser.getState() == 2) {
                tag = 7;
            }
        }
        return tag;
    }

    public LandUser saveUser(LandUser user) {
        return (LandUser)this.landUserDao.save((Object)user);
    }

    public Page<LandUser> queryByFilter(String filterParam, String sortParam, int start, int limit) {
        Page results = this.landUserDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return results;
    }

    public List<UserGrant> getUserOnlyGrantBiz(String bizid, String name, int offset, int limit, String roleid, String regionCode, String orgName) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(UserGrant.class);
        String sql = "SELECT\n\tT.f_userid,\n\tT.f_username,\n\tT.isgran, \n\tT.f_depid,\n\tT.f_phonemobile,\n\tT.roles, \n\tT.f_rname, \n\tT.f_regioncode \nFROM\n\t(\nSELECT\n\tb.f_userid,\n\tb.f_username,\n\tb.f_rname,\n\tb.f_depid,\n\tb.f_phonemobile,\n\tC.f_regioncode,\n\tP.f_bizid,\n\tP.f_bizid ='" + bizid + "' AS isgran,\n\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \nFROM\n\ttbsys_user b\n\tLEFT JOIN ( SELECT * FROM tbsys_user_biz A WHERE A.f_bizid ='" + bizid + "' ) AS P ON P.f_userid = b.f_userid\n\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \nWHERE\n\tb.f_isdeleted <> '1' \n\t) AS T \nWHERE\n\tT.roles LIKE '%" + roleid + "%'\n\tAND T.f_bizid='" + bizid + "'\n\tAND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')\n\tAND T.f_regioncode like '" + regionCode + "'\n\tAND T.f_depid like '%" + orgName + "%'\n\tORDER BY\n\tT.f_username \n\tLIMIT " + limit + " OFFSET " + offset;
        return this.jdbcTemplate.query(sql, (RowMapper)rowMapper);
    }

    public Long getUserOnlyGrantBizCount(String bizid, String name, String roleid, String regionCode, String orgName) {
        String sql = "SELECT count(1)\nFROM\n\t(\nSELECT b\n\t.f_userid,\n\tb.f_username,\n\tb.f_rname,\n\tb.f_depid,\n\tb.f_phonemobile,\n\tC.f_regioncode,\n\tP.f_bizid,\n\tP.f_bizid='" + bizid + "' as isgrant,\n\tarray_to_string(( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid )), ',' ) AS roles \nFROM\n\ttbsys_user b \n\tLEFT JOIN (SELECT * FROM tbsys_user_biz A WHERE A.f_bizid='" + bizid + "') AS P ON P.f_userid = b.f_userid \n\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n  WHERE b.f_isdeleted<>'1'\n\t) AS T \nWHERE\n\tT.roles LIKE '%" + roleid + "%'\n\tAND T.f_bizid='" + bizid + "'\n\tAND T.f_regioncode like '" + regionCode + "'\n\tAND T.f_depid like '%" + orgName + "%'\n\tAND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')";
        return (Long)this.jdbcTemplate.queryForObject(sql, Long.class);
    }

    public List<UserGrant> getUserAllBiz(String bizid, String name, int offset, int limit, String roleid, String regionCode, String orgName) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(UserGrant.class);
        String sql = "SELECT\n\tT.f_userid,\n\tT.f_username,\n\tT.isgran, \n\tT.f_depid,\n\tT.f_phonemobile,\n\tT.roles, \n\tT.f_rname, \n\tT.f_regioncode \nFROM\n\t(\nSELECT\n\tb.f_userid,\n\tb.f_username,\n\tb.f_rname,\n\tb.f_depid,\n\tb.f_phonemobile,\n\tC.f_regioncode,\n\tP.f_bizid,\n\tP.f_bizid ='" + bizid + "' AS isgran,\n\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \nFROM\n\ttbsys_user b\n\tLEFT JOIN ( SELECT * FROM tbsys_user_biz A WHERE A.f_bizid ='" + bizid + "' ) AS P ON P.f_userid = b.f_userid\n\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \nWHERE\n\tb.f_isdeleted <> '1' \n\t) AS T \nWHERE\n\tT.roles LIKE '%" + roleid + "%' \n\tAND T.f_regioncode like '" + regionCode + "' \n\tAND T.f_depid like '%" + orgName + "%'\n\tAND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')\n\tORDER BY\n\tT.f_username \n\tLIMIT " + limit + " OFFSET " + offset;
        return this.jdbcTemplate.query(sql, (RowMapper)rowMapper);
    }

    public Long getUserAllBizCount(String bizid, String name, String roleid, String regionCode, String orgName) {
        String sql = "SELECT count(1)\nFROM\n\t(\nSELECT b\n\t.f_userid,\n\tb.f_username,\n\tb.f_rname,\n\tb.f_phonemobile,\n\tb.f_depid,\n\tC.f_regioncode,\n\tP.f_bizid,\n\tP.f_bizid='" + bizid + "' as isgrant,\n\tarray_to_string(( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid )), ',' ) AS roles \nFROM\n\ttbsys_user b \n\tLEFT JOIN (SELECT * FROM tbsys_user_biz A WHERE A.f_bizid='" + bizid + "') AS P ON P.f_userid = b.f_userid \n\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n  WHERE b.f_isdeleted<>'1'\n\t) AS T \nWHERE\n\tT.roles LIKE '%" + roleid + "%' \n\tAND T.f_regioncode like '" + regionCode + "' \n\tAND T.f_depid like '%" + orgName + "%'\n\tAND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')";
        return (Long)this.jdbcTemplate.queryForObject(sql, Long.class);
    }

    public List<UserIdCls> getUserIdByRoleAndRegion(String roleId, String regionCode) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(UserIdCls.class);
        String sql = "SELECT T\n\t.f_userid\nFROM\n\t(\nSELECT b\n\t.f_userid,\n\tb.f_username,\n\tb.f_rname,\n\tC.f_regioncode,\n\tarray_to_string(( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid )), ',' ) AS roles \nFROM\n\ttbsys_user b \n\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n\tJOIN tbsys_user_biz d on b.f_userid = d.f_userid  WHERE b.f_isdeleted <> '1' and d.f_bizid='6'\n\t) AS T \nwhere T.roles like '%" + roleId + "%' and T.f_regioncode='" + regionCode + "'";
        return this.jdbcTemplate.query(sql, (RowMapper)rowMapper);
    }

    public LandRegUser queryRegUserByName(String name) {
        List users = this.landRegUserDao.queryRegUserByName(name);
        LandRegUser myUser = null;
        if (users.size() > 0) {
            myUser = (LandRegUser)users.get(0);
        }
        return myUser;
    }

    public LandRegUser queryRegUserByPhone(String phone) {
        List users = this.landRegUserDao.queryRegUserByPhone(phone);
        LandRegUser myUser = null;
        if (users.size() > 0) {
            myUser = (LandRegUser)users.get(0);
        }
        return myUser;
    }

    public LandRegUser queryRegUserByUserOrPhone(String nameOrPhone) {
        List users = this.landRegUserDao.queryRegUserByNameOrPhone(nameOrPhone);
        LandRegUser myUser = null;
        if (users.size() > 0) {
            myUser = (LandRegUser)users.get(0);
        }
        return myUser;
    }

    public boolean findUserNameIsExists(String name) {
        List users = this.landUserDao.queryUserByName(name);
        if (users.size() > 0) {
            return true;
        }
        List regUsers = this.landRegUserDao.queryRightRegUserByName(name);
        return regUsers.size() > 0;
    }

    public boolean findPhoneIsExists(String phone) {
        List users = this.landUserDao.queryNormalUserByPhone(phone);
        if (users != null && users.size() > 0) {
            return true;
        }
        List regUsers = this.landRegUserDao.queryRegUserByPhone(phone);
        return regUsers != null && regUsers.size() > 0;
    }

    public List<String> queryUserAreas(Long userId) throws Exception {
        String regionCode = this.oauthUserService.getUserRegion(userId);
        ArrayList<String> regions = new ArrayList<String>();
        regions.add(regionCode);
        return regions;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateUserAreas(Long userId, List<String> regionCodes) {
        this.landUser2AreaDao.deleteAreaByUserId(userId);
        List userAreaList = regionCodes.stream().map(r -> {
            LandUser2Area userArea = new LandUser2Area();
            userArea.setRegionCode(r);
            userArea.setUserId(userId);
            userArea.setState(Integer.valueOf(1));
            userArea.setCreateTime(new Date());
            return userArea;
        }).collect(Collectors.toList());
        this.landUser2AreaDao.saveAll(userAreaList);
    }

    public Long findUserIdByName(String name) {
        List users = this.landUserDao.queryAppUserByName(name);
        if (users.size() == 1) {
            return ((LandUser)users.get(0)).getId();
        }
        if (users.size() == 0) {
            return null;
        }
        throw new RuntimeException("\u7528\u6237\u540d\u6709\u91cd\u590d");
    }

    public Page<RegionUser> queryRegionUserByFilter(String filterParam, String sortParam, int start, int limit, Integer rightType, boolean isContainsRole) {
        Page results = this.regionUserDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        if (isContainsRole && results != null && results.getSize() > 0) {
            for (RegionUser result : results) {
                Long userId = result.getId();
                List<SysRoleInfo> roles = this.getRoleByUser(userId, rightType);
                result.setRoles(roles);
            }
        }
        return results;
    }

    public LandUserDetail findUserDetail(Long id, Integer rightType) {
        Long approverId;
        LandUserDetail user;
        LandUserDetail userDetail = this.landUserDetailDao.findById((Object)id).orElse(null);
        if (userDetail.getIsdel() == 1) {
            return null;
        }
        LandRegUser regUser = this.landRegUserDao.findByUserID(id);
        if (regUser != null) {
            userDetail.setAppRoleId(regUser.getRoleIds());
        }
        List<SysRoleInfo> roles = this.getRoleByUser(id, rightType);
        userDetail.setRoles(roles);
        List problemTypes = this.userProblemTypesDao.getTypesByUserId(id);
        if (problemTypes != null && !problemTypes.isEmpty()) {
            userDetail.setProblemTypes(GutilStr.join((List)problemTypes, (CharSequence)","));
        } else {
            userDetail.setProblemTypes("");
        }
        AvalUser avalUser = this.avalUserDao.getAvalUserByUserId(id);
        if (avalUser != null && (user = (LandUserDetail)this.landUserDetailDao.findById((Object)(approverId = avalUser.getApproverId())).orElse(null)) != null) {
            userDetail.setApprover(user.getName());
        }
        return userDetail;
    }

    public LandUserDetail findUserRole(Long id, Integer rightType) {
        LandUserDetail userDetail = this.landUserDetailDao.findById((Object)id).orElse(null);
        if (userDetail == null) {
            return userDetail;
        }
        List<SysRoleInfo> roles = this.getRoleByUser(id, rightType);
        userDetail.setRoles(roles);
        List problemTypes = this.userProblemTypesDao.getTypesByUserId(id);
        if (problemTypes != null && !problemTypes.isEmpty()) {
            userDetail.setProblemTypes(GutilStr.join((List)problemTypes, (CharSequence)","));
        } else {
            userDetail.setProblemTypes("");
        }
        return userDetail;
    }

    public List<SysRoleInfo> getRoleByUser(Long userId, Integer rightType) {
        String filterParam = "Q_userId_N_EQ=" + userId + ";Q_visible_N_EQ=1";
        if (rightType != null) {
            filterParam = filterParam + ";Q_type_N_EQ=" + rightType;
            if (rightType == 1) {
                // empty if block
            }
        }
        String sortParam = "SORT_order_ASC;SORT_pid_ASC";
        List userRoleRights = this.userRoleRightDao.findAll((Specification)new QuerySpecification(filterParam), QueryParamUtil.parseSortParams((String)sortParam));
        HashMap rightData = new HashMap();
        for (UserRoleRight userRoleRight : userRoleRights) {
            Right right = new Right();
            right.setId(userRoleRight.getRightId());
            right.setCode(userRoleRight.getRightCode());
            right.setName(userRoleRight.getRightName());
            right.setStatus(userRoleRight.getStatus());
            right.setPid(userRoleRight.getPid());
            right.setOrder(userRoleRight.getOrder());
            right.setType(userRoleRight.getType());
            if (rightData.containsKey(userRoleRight.getRoleId())) {
                ((List)rightData.get(userRoleRight.getRoleId())).add(right);
                continue;
            }
            ArrayList<Right> rights = new ArrayList<Right>();
            rights.add(right);
            rightData.put(userRoleRight.getRoleId(), rights);
        }
        HashMap<Long, SysRoleInfo> dataMap = new HashMap<Long, SysRoleInfo>();
        ArrayList<SysRoleInfo> roles = new ArrayList<SysRoleInfo>();
        if (userRoleRights != null && !userRoleRights.isEmpty()) {
            SysRoleInfo role = null;
            for (UserRoleRight userRoleRight : userRoleRights) {
                if (dataMap.containsKey(userRoleRight.getRoleId())) continue;
                role = new SysRoleInfo();
                role.setId(userRoleRight.getRoleId().toString());
                role.setName(userRoleRight.getRoleName());
                role.setTag(userRoleRight.getTag());
                role.setVisible(userRoleRight.getVisible());
                if (rightData.containsKey(userRoleRight.getRoleId())) {
                    role.setRights((List)rightData.get(userRoleRight.getRoleId()));
                }
                dataMap.put(userRoleRight.getRoleId(), role);
                roles.add(role);
            }
        }
        return roles;
    }

    public LandUserDetail saveUserDetail(LandUserDetail detail) {
        LandUserDetail userDetail = null;
        if (detail.getId() == null) {
            userDetail = (LandUserDetail)this.landUserDetailDao.save((Object)detail);
        } else {
            userDetail = this.landUserDetailDao.findById((Object)detail.getId()).orElse(null);
            userDetail.setName(detail.getName());
            userDetail.setRname(detail.getName());
            userDetail.setDepId(detail.getDepId());
            userDetail.setState(detail.getState());
            userDetail.setSjsf(detail.getSjsf());
            this.landUserDetailDao.save((Object)userDetail);
        }
        if (GutilStr.isNotBlank((CharSequence)userDetail.getSjsf())) {
            String[] sjsfArr = userDetail.getSjsf().split(",");
            List usableAreas = this.landUser2AreaDao.queryUserAreas(userDetail.getId(), Integer.valueOf(1));
            List disabledAreas = this.landUser2AreaDao.queryUserAreas(userDetail.getId(), Integer.valueOf(0));
            ArrayList<String> newUsableAreas = new ArrayList<String>();
            ArrayList<LandUser2Area> newAreas = new ArrayList<LandUser2Area>();
            for (String regionCode : sjsfArr) {
                if (usableAreas.contains(regionCode)) {
                    usableAreas.remove(regionCode);
                    continue;
                }
                if (disabledAreas.contains(regionCode)) {
                    newUsableAreas.add(regionCode);
                    disabledAreas.remove(regionCode);
                    continue;
                }
                LandUser2Area userArea = new LandUser2Area();
                userArea.setCreateTime(new Date());
                userArea.setRegionCode(regionCode);
                userArea.setUserId(userDetail.getId());
                userArea.setState(Integer.valueOf(1));
                newAreas.add(userArea);
            }
            if (!newAreas.isEmpty()) {
                this.landUser2AreaDao.saveAll(newAreas);
            }
            if (!newUsableAreas.isEmpty()) {
                this.landUser2AreaDao.updateStateByRegionAndUser(Integer.valueOf(1), new Date(), userDetail.getId(), newUsableAreas);
            }
            if (!usableAreas.isEmpty()) {
                this.landUser2AreaDao.updateStateByRegionAndUser(Integer.valueOf(0), new Date(), userDetail.getId(), usableAreas);
            }
        }
        return userDetail;
    }

    public LandUserDetail saveUserDetail(LandUserDetail detail, String regionCode) {
        boolean isExists;
        LandUserDetail userDetail = (LandUserDetail)this.landUserDetailDao.save((Object)detail);
        boolean bl = isExists = this.landUser2AreaDao.queryUserAreasIsExists(userDetail.getId(), regionCode) > 0;
        if (!isExists) {
            LandUser2Area userArea = new LandUser2Area();
            userArea.setCreateTime(new Date());
            userArea.setRegionCode(regionCode);
            userArea.setUserId(userDetail.getId());
            userArea.setState(Integer.valueOf(1));
            this.landUser2AreaDao.save((Object)userArea);
        }
        this.landUserDao.updatePassword(userDetail.getId().longValue(), "e10adc3949ba59abbe56e057f20f883e");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 3);
        this.landUserDao.updatePwdExpirationTime(userDetail.getId().longValue(), calendar.getTime());
        return userDetail;
    }

    public void updatePassword(Long userId, String password, String pswtip) {
        this.landUserDao.updatePassword(userId.longValue(), password);
        if (pswtip != null && !pswtip.equals("")) {
            this.landUserDao.updatePwdTip(userId, pswtip);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 3);
        this.landUserDao.updatePwdExpirationTime(userId.longValue(), calendar.getTime());
        this.landRegUserDao.updatePassword(userId.longValue(), password);
    }

    public void updateRname(Long userId, String rname) {
        this.landUserDao.updateRname(userId.longValue(), rname);
        this.landRegUserDao.updateRname(userId.longValue(), rname);
    }

    public void updatePhone(String phone, Long id) {
        this.landUserDetailDao.updatePhone(phone, id);
    }

    public List<String> queryUserAreasPendingAval(Long userId) {
        return this.landUser2AreaDao.queryUserAreasPendingAval(userId);
    }

    public List<Long> queryUserByCode(List<String> codes) {
        return this.landUser2AreaDao.queryUserByCode(codes);
    }

    public void updateUserYhlb(Integer type, Integer yhlb, Long id) {
        if (yhlb != null) {
            // empty if block
        }
    }

    public void updateUserInfo(LandUser user) {
        this.landUserDao.save((Object)user);
    }

    public List<Long> queryUserIdByYhlbAndType(Integer yhlb, Long userId, Integer userType) {
        List<Long> result = null;
        if (yhlb != null && userType != null) {
            List code;
            List userIdList;
            ArrayList<Integer> yhlbs = new ArrayList<Integer>();
            yhlbs.add(1);
            yhlbs.add(2);
            yhlbs.add(3);
            if (yhlb == 1 || yhlb != 2 || (userIdList = this.landUser2AreaDao.queryUserByCode(code = this.landUser2AreaDao.queryAreas(userId))) == null || userIdList.size() > 0) {
                // empty if block
            }
        }
        return result;
    }

    public List<Long> getRepetition(List<Long> list1, List<Long> list2) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (Long integer : list2) {
            if (!list1.contains(integer)) continue;
            result.add(integer);
        }
        return result;
    }

    public LandUser queryUserById(Long userId) {
        return this.landUserDao.queryUserById(userId);
    }

    public LandUser queryUnDelUserById(Long userId) {
        return this.landUserDao.queryUnDelUserById(userId);
    }

    public List<LandUserDetail> queryListByFilter(String filterParam, String sortParam) {
        return this.landUserDetailDao.findAll((Specification)new QuerySpecification(filterParam), QueryParamUtil.parseSortParams((String)sortParam));
    }

    public List<RegionUser> queryRegionUserList(String filterParam, String sortParam) {
        return this.regionUserDao.findAll((Specification)new QuerySpecification(filterParam), QueryParamUtil.parseSortParams((String)sortParam));
    }

    public String findSjsf(long userId) {
        return this.regionUserDao.findSjsf(userId);
    }

    public List<LandUser> getMyColleagues(Long userid) throws Exception {
        LandUser landUser = this.landUserDao.findById((Object)userid).orElse(null);
        List<Object> users = new ArrayList<LandUser>();
        if (GutilStr.isNotBlank((CharSequence)landUser.getDepId())) {
            users = this.landUserDao.queryUsersByDeptid(landUser.getDepId(), userid);
        }
        if (!users.isEmpty()) {
            for (LandUser user : users) {
                YXUser yxUser = this.yxUserRepository.findById((Object)user.getId()).orElse(null);
                if (yxUser == null) continue;
                user.setAccid(yxUser.getAccid());
            }
        }
        return users;
    }

    public Page<LandUser> getMyColleagues1(Long ownerId, int start, int limit, String filterParam, String sortParam) throws Exception {
        List organization2Users = this.organization2UserDao.queryByUserId(ownerId);
        if (organization2Users.isEmpty()) {
            return this.landUserDao.findAll((Specification)new QuerySpecification("Q_id_N_EQ=-1"), (Pageable)PageRequest.of((int)0, (int)10, (Sort)QueryParamUtil.parseSortParams((String)"SORT_id_ASC")));
        }
        String organizationId = ((Organization2User)organization2Users.get(0)).getOrganizationId();
        List userIds = this.organization2UserDao.queryUserIdsByOrganizationId(organizationId);
        StringBuilder sb = new StringBuilder();
        for (Long userId : userIds) {
            sb.append(userId);
            sb.append(",");
        }
        filterParam = filterParam + ";Q_isdel_N_EQ=0;Q_id_N_NE=" + ownerId + ";Q_id_N_IN=" + sb.toString();
        Page<LandUser> myColleagues = this.queryByFilter(filterParam, sortParam, start, limit);
        for (LandUser myColleague : myColleagues) {
            YXUser yxUser = this.yxUserRepository.findOneByUserId(myColleague.getId());
            if (yxUser != null) {
                myColleague.setAccid(yxUser.getAccid());
            }
            Organization a = new Organization();
            a.setId(organizationId);
            myColleague.setOrganization(a);
            String roleids = "";
            List roleList = this.userRoleInfoDao.getRoleIdsByUserId(myColleague.getId());
            for (int i = 0; i < roleList.size(); ++i) {
                if (GutilStr.isNotBlank((CharSequence)roleids)) {
                    roleids = roleids + ",";
                }
                roleids = roleids + (String)roleList.get(i);
            }
            myColleague.setRoleIds(roleids);
        }
        return myColleagues;
    }

    public Map<String, Object> getMyCol(Long userId, int pageIndex, int rows, String colleaguesDep, String colleaguesName, String colleaguesCategory) throws Exception {
        Object bigDecimal;
        Object bigDecimals;
        HashMap<String, Object> map = new HashMap<String, Object>();
        List organization2Users = this.organization2UserDao.queryByUserId(userId);
        if (organization2Users.isEmpty()) {
            map.put("list", null);
            map.put("total", 0);
            map.put("filter", 0);
            return map;
        }
        String organizationId = ((Organization2User)organization2Users.get(0)).getOrganizationId();
        List totalUserIds = this.organization2UserDao.queryUserIdsByOrganizationId(organizationId).stream().filter(r -> !r.equals(userId)).collect(Collectors.toList());
        List<Object> userIds = new ArrayList();
        StringBuilder sb = new StringBuilder();
        if (!"".equals(colleaguesDep)) {
            bigDecimals = this.departmentDao.getUserIdByDepId(colleaguesDep, organizationId);
            if (colleaguesCategory == null) {
                Iterator iterator = bigDecimals.iterator();
                while (iterator.hasNext()) {
                    bigDecimal = (BigDecimal)iterator.next();
                    userIds.add(Long.parseLong(((BigDecimal)bigDecimal).toString()));
                }
            } else if ("".equals(colleaguesCategory)) {
                String string = "select g.userid from (select r.f_userid userid, string_agg(r.f_roleinfoid,',') agg from tbsys_user_roleinfo r where f_userid in( " + GutilStr.join((List)bigDecimals, (CharSequence)",") + " ) group by r.f_userid) g  where g.agg not like '%10020%' and g.agg not like '%10022%'";
                userIds = this.jdbcTemplate.queryForList(string, Long.class);
            } else {
                ArrayList<Long> arrayList = new ArrayList<Long>();
                bigDecimal = bigDecimals.iterator();
                while (bigDecimal.hasNext()) {
                    BigDecimal bigDecimal2 = (BigDecimal)bigDecimal.next();
                    arrayList.add(Long.parseLong(bigDecimal2.toString()));
                }
                userIds = this.userRoleInfoDao.queryUserIdsByUserIdAndRole(arrayList, colleaguesCategory);
            }
        } else if (colleaguesCategory == null) {
            userIds = this.organization2UserDao.queryUserIdsByOrganizationId(organizationId);
        } else if ("".equals(colleaguesCategory)) {
            String sql = "select g.userid from (select r.f_userid userid, string_agg(r.f_roleinfoid,',') agg from tbsys_user_roleinfo r where f_userid in( " + GutilStr.join(totalUserIds, (CharSequence)",") + " ) group by r.f_userid) g  where g.agg not like '%10020%' and g.agg not like '%10022%'";
            userIds = this.jdbcTemplate.queryForList(sql, Long.class);
        } else {
            bigDecimals = this.organization2UserDao.getUserIdsByOrgIdAndRoleId(organizationId, colleaguesCategory);
            Iterator iterator = bigDecimals.iterator();
            while (iterator.hasNext()) {
                bigDecimal = (BigDecimal)iterator.next();
                userIds.add(Long.parseLong(((BigDecimal)bigDecimal).toString()));
            }
        }
        userIds = userIds.stream().filter(r -> !r.equals(userId)).collect(Collectors.toList());
        for (Long l : userIds) {
            sb.append(l);
            sb.append(",");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" select g.agg,u.* from tbsys_user u, (select r.f_userid,string_agg(r.f_roleinfoid,',') agg from tbsys_user_roleinfo r where 1=1  ");
        if (!"".equals(sb.toString())) {
            stringBuilder.append(" and r.f_userid in ( " + sb.toString().substring(0, sb.toString().length() - 1) + " ) ");
        } else {
            stringBuilder.append(" and r.f_userid in ( 0 ) ");
        }
        stringBuilder.append(" group by r.f_userid ) g ");
        stringBuilder.append("where  u.f_isdeleted=0  and g.f_userid=u.f_userid ");
        if (!"".equals(colleaguesName)) {
            JSONObject jSONObject = JSONObject.parseObject((String)colleaguesName);
            if (jSONObject != null && jSONObject.get((Object)"type").equals("username")) {
                stringBuilder.append(" and  u.f_username like '%" + jSONObject.get((Object)"name") + "%' ");
            } else if (jSONObject != null && jSONObject.get((Object)"type").equals("rname")) {
                stringBuilder.append(" and u.f_rname like '%" + jSONObject.get((Object)"name") + "%' ");
            }
        }
        stringBuilder.append(" and u.f_userid != " + userId + " ");
        String string = stringBuilder.toString().replace("g.agg,u.*", "count(1)");
        Integer filter = (Integer)this.jdbcTemplate.queryForObject(string, Integer.class);
        stringBuilder.append("order by \n case \n\t\twhen g.agg like '%10022%' then '400'\n\t\twhen g.agg like '%10020%' then '300'\n\t\telse '200'\n end desc ");
        stringBuilder.append(" limit " + rows + " offset " + pageIndex * rows);
        String param = stringBuilder.toString();
        ArrayList<LandUser> myColleagues = new ArrayList<LandUser>();
        List list = this.jdbcTemplate.queryForList(stringBuilder.toString());
        for (Map userMap : list) {
            LandUser landUser = new LandUser();
            landUser.setId(Long.valueOf(userMap.get("f_userid").toString()));
            landUser.setName(userMap.get("f_username").toString());
            landUser.setRname(userMap.get("f_rname") != null ? userMap.get("f_rname").toString() : null);
            landUser.setIsdel(userMap.get("f_isdeleted") != null ? Integer.valueOf(userMap.get("f_isdeleted").toString()) : null);
            landUser.setPhone(userMap.get("f_phonemobile") != null ? userMap.get("f_phonemobile").toString() : null);
            landUser.setState(userMap.get("f_state") != null ? Integer.valueOf(userMap.get("f_state").toString()) : null);
            landUser.setDepId(userMap.get("f_depid") != null ? userMap.get("f_depid").toString() : null);
            landUser.setSjsf(userMap.get("f_sjsf") != null ? userMap.get("f_sjsf").toString() : null);
            myColleagues.add(landUser);
        }
        for (LandUser myColleague : myColleagues) {
            YXUser yxUser = this.yxUserRepository.findOneByUserId(myColleague.getId());
            if (yxUser != null) {
                myColleague.setAccid(yxUser.getAccid());
            }
            Organization a = new Organization();
            a.setId(organizationId);
            myColleague.setOrganization(a);
            String roleids = "";
            List roleList = this.userRoleInfoDao.getRoleIdsByUserId(myColleague.getId());
            for (int i = 0; i < roleList.size(); ++i) {
                if (GutilStr.isNotBlank((CharSequence)roleids)) {
                    roleids = roleids + ",";
                }
                roleids = roleids + (String)roleList.get(i);
            }
            myColleague.setRoleIds(roleids);
        }
        map.put("list", myColleagues);
        map.put("total", totalUserIds.size());
        map.put("filter", filter);
        return map;
    }

    public Page<LandUser> getUserOfSameDept(Long userid, String filterParam, String sortParam, int page, int size) throws Exception {
        LandUser landUser = this.landUserDao.findById((Object)userid).orElse(null);
        String depId = landUser.getDepId();
        if (GutilStr.isNotBlank((CharSequence)depId)) {
            List organizations = this.organizationRepository.queryOneByName(depId);
            if (organizations.isEmpty()) {
                throw new RuntimeException("\u5355\u4f4d\u6570\u636e\u5f02\u5e38, \u65e0\u5bf9\u5e94\u5355\u4f4d");
            }
            Organization organization = (Organization)organizations.get(0);
            filterParam = organization != null && organization.getLevel() != null && organization.getLevel() == 4 ? filterParam + ";Q_isdel_N_EQ=0;Q_sjsf_S_EQ=" + organization.getRegionCode() : filterParam + ";Q_isdel_N_EQ=0;Q_depId_S_EQ=" + depId;
            Page Colleagues = this.landUserDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)page, (int)size, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
            for (LandUser user : Colleagues) {
                List roles = this.userRoleInfoDao.getRoleIdsByUserId(user.getId());
                this.completeLandUserInfo(user, roles);
            }
            return Colleagues;
        }
        throw new RuntimeException("\u7ba1\u7406\u5458\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u5355\u4f4d");
    }

    public Map<String, Object> getUsersByOrgIdAndDepaId(String orgId, String depaId, int userType, String filterParam, String sortParam, String phone, int start, int limit, Date date, Integer state, String role) throws Exception {
        List<Object> idList = new ArrayList();
        if (GutilStr.isNotBlank((CharSequence)depaId)) {
            idList = this.department2UserDao.queryUserIdsByDepaId(depaId);
        } else {
            if (GutilStr.isBlank((CharSequence)orgId)) {
                throw new RuntimeException("\u90e8\u95e8\u548c\u5355\u4f4did\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            idList = this.getUserIdsByOrgIdAndUserType(orgId, userType);
        }
        if (idList.isEmpty()) {
            return null;
        }
        StringBuffer keyword = new StringBuffer("%");
        if (GutilStr.isNotBlank((CharSequence)filterParam) && filterParam.indexOf("Q_name_S_Lk=") != -1) {
            int index = filterParam.indexOf("=");
            keyword.append(filterParam.substring(index + 1));
        }
        keyword.append("%");
        List<LandUser> landUsers = new ArrayList();
        if (date == null) {
            List tempUserList = null;
            String sql = "select u.* from tbsys_user as u left join ( select t.f_userid userid,string_agg(t.f_roleinfoid,',') agg from tbsys_user_roleinfo as t   group by t.f_userid ) as g on g.userid = u.f_userid ";
            sql = sql + " where u.f_userid in (" + GutilStr.join(idList, (CharSequence)",") + " ) ";
            if (!role.equals("")) {
                if (role.equals("1")) {
                    sql = sql + " and ( g.agg  not like '%10022%' and g.agg  not like '%10020%' )";
                } else if (role.equals("2")) {
                    role = "10022";
                    sql = sql + " and g.agg like '%" + role + "%' ";
                } else {
                    role = "10020";
                    sql = sql + " and g.agg like '%" + role + "%'";
                }
            }
            sql = sql + " and u.f_isdeleted =0 and u.f_userid<>101 ";
            sql = sql + " and (u.f_username like '" + keyword + "' or u.f_phonemobile like '" + keyword + "')";
            if (state != null) {
                sql = sql + " and u.f_state=" + state + " ";
            }
            sql = sql + "order by case when g.agg like '%101%' then '400' when g.agg like '%10022%' then '300' when g.agg like '%10020%' then '200' else '100' end desc, u.f_rname asc";
            tempUserList = this.jdbcTemplate.queryForList(sql);
            LandUser user = null;
            for (Map map : tempUserList) {
                user = new LandUser();
                user.setId(Long.valueOf(map.get("f_userid").toString()));
                user.setRname(map.get("f_rname") != null ? map.get("f_rname").toString() : "");
                user.setName(map.get("f_username") != null ? map.get("f_username").toString() : "");
                user.setPhone(map.get("f_phonemobile") != null ? map.get("f_phonemobile").toString() : "");
                user.setDepId(map.get("f_depid") != null ? map.get("f_depid").toString() : "");
                user.setPost(map.get("f_post") != null ? map.get("f_post").toString() : null);
                user.setDeviceType(map.get("f_devicetype") != null ? Integer.valueOf(map.get("f_devicetype").toString()) : null);
                landUsers.add(user);
            }
        } else {
            landUsers = this.landUserDao.queryUserByIds4Time(idList, keyword.toString(), "%" + phone + "%", date);
        }
        LinkedHashSet set = new LinkedHashSet(landUsers);
        ArrayList users = new ArrayList(set);
        ArrayList<LandUser> result = new ArrayList<LandUser>();
        int currIdx = start > 0 ? start * limit : 0;
        for (int i = 0; i < limit && i < users.size() - currIdx; ++i) {
            LandUser user = new LandUserBuilder((LandUser)users.get(currIdx + i)).role().cloudArea().organization().department().regionFullName().build();
            if (GutilStr.isNotBlank((CharSequence)orgId)) {
                user.setDepNo(orgId);
            } else {
                Department department = this.departmentDao.findById((Object)depaId).orElse(null);
                if (department == null) {
                    throw new RuntimeException("\u90e8\u95e8id\u6709\u8bef");
                }
                user.setDepNo(department.getOrgId());
            }
            if (user.getPhone() != null && !user.getPhone().equals("") && user.getPhone().length() == 11) {
                user.setPhone(user.getPhone().substring(0, 3) + "****" + user.getPhone().substring(7));
            }
            result.add(user);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", users.size());
        map.put("content", result);
        return map;
    }

    public Map<String, Object> getUsersByRegionCode(String regionCode, String keyword, Integer state, String role, int start, int limit) throws Exception {
        ArrayList<LandUser> landUsers = new ArrayList<LandUser>();
        List tempUserList = null;
        String sql = "select u.* from tbsys_user as u,tbsys_user_area as ua,( select t.f_userid userid,string_agg(t.f_roleinfoid,',') agg from tbsys_user_roleinfo as t group by t.f_userid ) as g where g.userid = u.f_userid and u.f_userid = ua.f_userid ";
        String countsql = "select count(1) from tbsys_user as u,tbsys_user_area as ua,( select t.f_userid userid,string_agg(t.f_roleinfoid,',') agg from tbsys_user_roleinfo as t group by t.f_userid ) as g where g.userid = u.f_userid and u.f_userid = ua.f_userid ";
        if (!role.equals("")) {
            if (role.equals("1")) {
                sql = sql + " and ( g.agg  not like '%10022%' and g.agg  not like '%10020%' )";
                countsql = countsql + " and ( g.agg  not like '%10022%' and g.agg  not like '%10020%' )";
            } else if (role.equals("2")) {
                role = "10022";
                sql = sql + " and g.agg like '%" + role + "%' ";
                countsql = countsql + " and g.agg like '%" + role + "%' ";
            } else {
                role = "10020";
                sql = sql + " and g.agg like '%" + role + "%'";
                countsql = countsql + " and g.agg like '%" + role + "%'";
            }
        }
        sql = sql + " and u.f_isdeleted =0 and u.f_userid<>101 ";
        countsql = countsql + " and u.f_isdeleted =0 and u.f_userid<>101 ";
        if (!keyword.equals("")) {
            sql = sql + " and (u.f_username like '%" + keyword + "%' or u.f_phonemobile like '%" + keyword + "%')";
            countsql = countsql + " and (u.f_username like '%" + keyword + "%' or u.f_phonemobile like '%" + keyword + "%')";
        }
        if (state != null) {
            sql = sql + " and u.f_state=" + state + " ";
            countsql = countsql + " and u.f_state=" + state + " ";
        }
        if (regionCode != null) {
            sql = sql + " and ua.f_regioncode='" + regionCode + "' ";
            countsql = countsql + " and ua.f_regioncode='" + regionCode + "' ";
        }
        sql = sql + "order by case when g.agg like '%101%' then '400' when g.agg like '%10022%' then '300' when g.agg like '%10020%' then '200' else '100' end desc, u.f_rname asc";
        start = (start - 1) * limit;
        sql = sql + " limit " + limit + " offset " + start;
        tempUserList = this.jdbcTemplate.queryForList(sql);
        Integer count = (Integer)this.jdbcTemplate.queryForObject(countsql, Integer.class);
        for (Map map : tempUserList) {
            LandUser user = new LandUser();
            user.setId(Long.valueOf(map.get("f_userid").toString()));
            user.setRname(map.get("f_rname") != null ? map.get("f_rname").toString() : "");
            user.setName(map.get("f_username") != null ? map.get("f_username").toString() : "");
            user.setPhone(map.get("f_phonemobile") != null ? map.get("f_phonemobile").toString() : "");
            user.setDepId(map.get("f_depid") != null ? map.get("f_depid").toString() : "");
            user = new LandUserBuilder(user).role().cloudArea().organization().department().regionFullName().build();
            if (user.getPhone() != null && !user.getPhone().equals("") && user.getPhone().length() == 11) {
                user.setPhone(user.getPhone().substring(0, 3) + "****" + user.getPhone().substring(7));
            }
            landUsers.add(user);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", count);
        map.put("content", landUsers);
        return map;
    }

    public Map<String, Object> getHNUsersByRegionCode(String regionCode, String keyword, Integer state, String role, int start, int limit) throws Exception {
        ArrayList<LandUser> landUsers = new ArrayList<LandUser>();
        List tempUserList = null;
        String sql = "select u.f_userid,u.f_rname,u.f_username,u.f_post,u.f_phonemobile,g.agg,ua.f_regioncode from  tbsys_user as u,tbsys_user_area as ua,( select t.f_userid userid,string_agg(t.f_roleinfoid,',') agg from tbsys_user_roleinfo as t group by t.f_userid ) as g where g.userid = u.f_userid and u.f_userid = ua.f_userid ";
        String countsql = "select count(1) from tbsys_user as u,tbsys_user_area as ua,( select t.f_userid userid,string_agg(t.f_roleinfoid,',') agg from tbsys_user_roleinfo as t group by t.f_userid ) as g where g.userid = u.f_userid and u.f_userid = ua.f_userid ";
        if (!role.equals("") && role != null) {
            sql = sql + " and g.agg like '%" + role + "%'";
            countsql = countsql + " and g.agg like '%" + role + "%'";
        }
        sql = sql + " and u.f_isdeleted =0 and u.f_userid<>101 ";
        countsql = countsql + " and u.f_isdeleted =0 and u.f_userid<>101 ";
        if (!keyword.equals("")) {
            sql = sql + " and (u.f_username like '%" + keyword + "%' or u.f_phonemobile like '%" + keyword + "%')";
            countsql = countsql + " and (u.f_username like '%" + keyword + "%' or u.f_phonemobile like '%" + keyword + "%')";
        }
        if (state != null) {
            sql = sql + " and u.f_state=" + state + " ";
            countsql = countsql + " and u.f_state=" + state + " ";
        }
        if (regionCode != null) {
            if (regionCode.length() <= 6 && regionCode.endsWith("00")) {
                regionCode = regionCode.replace("00", "");
            }
            sql = sql + " and ua.f_regioncode like '" + regionCode + "%' ";
            countsql = countsql + " and ua.f_regioncode like '" + regionCode + "%'";
        }
        sql = sql + "order by case when g.agg like '%10038%' then '400' when g.agg like '%10039%' then '300' when g.agg like '%10031%' then '200' when g.agg like '%10032%' then '190' when g.agg like '%10033%' then '180' when g.agg like '%10034%' then '170' when g.agg like '%10035%' then '160' when g.agg like '%10036%' then '150' else '100' end desc, u.f_rname asc";
        start = (start - 1) * limit;
        sql = sql + " limit " + limit + " offset " + start;
        tempUserList = this.jdbcTemplate.queryForList(sql);
        Integer count = (Integer)this.jdbcTemplate.queryForObject(countsql, Integer.class);
        for (Map map : tempUserList) {
            LandUser user = new LandUser();
            user.setId(Long.valueOf(map.get("f_userid").toString()));
            user.setRname(map.get("f_rname") != null ? map.get("f_rname").toString() : "");
            user.setName(map.get("f_username") != null ? map.get("f_username").toString() : "");
            user.setPhone(map.get("f_phonemobile") != null ? map.get("f_phonemobile").toString() : "");
            user.setPost(map.get("f_post") != null ? map.get("f_post").toString() : "");
            user.setRoleIds(map.get("agg") != null ? map.get("agg").toString() : "");
            user.setRegionFullName(this.regionService.getName(map.get("f_regioncode").toString()));
            user = new LandUserBuilder(user).build();
            landUsers.add(user);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", count);
        map.put("content", landUsers);
        return map;
    }

    private List<Long> getUserIdsByOrgIdAndUserType(String orgId, int userType) {
        List idList = new ArrayList();
        if (userType == 0) {
            idList = this.organization2UserDao.queryUserIdsByOrganizationId(orgId);
        } else if (userType == 1) {
            idList = this.organization2UserDao.queryIdsOfUsedByOrgId(orgId);
        } else if (userType == 2) {
            idList = this.organization2UserDao.queryIdsOfNotUsedByOrgId(orgId);
        }
        return idList;
    }

    public Map<String, Object> getUsersByBizIdAndBizArea(String bizId, String name, String phone, String bizArea, int start, int limit) throws Exception {
        return this.getUsersByBizIdAndBizAreaAndBizRoleId(null, bizId, name, phone, bizArea, null, start, limit);
    }

    public Map<String, Object> getUsersByBizIdAndBizAreaAndBizRoleId(Long userId, String bizId, String name, String phone, String bizArea, String bizRoleId, int start, int limit) throws Exception {
        List<LandUser> list = null;
        Long count = 0L;
        boolean phoneFilter = false;
        String nameLike = "%" + name + "%";
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            if (!CheckUtil.isMobile((String)phone)) {
                throw new Exception("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            BusUserInfoReso busUserInfoReso = this.oauthUserService.getBusUserByPhone(phone);
            if (busUserInfoReso == null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("total", count);
                map.put("content", null);
                return map;
            }
            name = busUserInfoReso.getUserName();
            phoneFilter = true;
        }
        if (bizRoleId == null) {
            if (!phoneFilter) {
                list = this.landUserDao.getUsersByBizIdAndBizAreaAndNameLike(bizId, nameLike, bizArea, limit, start);
                count = this.landUserDao.getUsersByBizIdAndBizAreaAndNameLikeCount(bizId, nameLike, bizArea);
            } else {
                list = this.landUserDao.getUsersByBizIdAndBizAreaAndName(bizId, name, nameLike, bizArea, limit, start);
                count = this.landUserDao.getUsersByBizIdAndBizAreaAndNameCount(bizId, name, nameLike, bizArea);
            }
        } else {
            List<Object> regionAreas = new ArrayList();
            regionAreas = this.tbtskUserManageAreaService.listManageAreas(bizId, userId.toString()).stream().map(r -> r.getRegioncode()).collect(Collectors.toList());
            if (regionAreas.isEmpty()) {
                throw new GwValidateException("\u7528\u6237\u65e0\u672c\u4efb\u52a1\u7ba1\u7406\u533a");
            }
            list = this.createSQLByBizIdAndUserRole(bizId, bizRoleId, regionAreas, limit, start, name, nameLike);
            count = this.createSQLByBizIdAndUserRoleCount(bizId, bizRoleId, regionAreas, name, nameLike);
        }
        ArrayList<LandUser> result = new ArrayList<LandUser>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            BusUserInfoReso userReso;
            LandUser user = new LandUserBuilder(list.get(i)).hidePhone().build();
            if (StringUtils.isNotBlank((CharSequence)user.getSubjectUserId()) && (userReso = this.oauthUserService.getBusUser(user.getSubjectUserId())) != null) {
                user.setRname(userReso.getRealName());
                user.setPhone(userReso.getPhone());
                user.setRoleIds(this.oauthUserService.getRoleIdByOrgRole(userReso.getOrgRole(), userReso.getRegionCode()));
                user.setSjsf(userReso.getRegionCode());
                user.setRegionCode(userReso.getRegionCode());
                Organization org = new Organization();
                org.setId(userReso.getOrgId());
                org.setName(userReso.getOrgName());
                user.setOrganization(org);
                LandRegUserService landRegUserService = (LandRegUserService)Gw.beans.getBean(LandRegUserService.class);
                String xzqdm = userReso.getRegionCode();
                if (GutilStr.isNotBlank((CharSequence)xzqdm)) {
                    String fullRegionName = null;
                    try {
                        fullRegionName = landRegUserService.getMyRegionByCode(xzqdm).getFullName();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    user.setRegionFullName(fullRegionName);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)bizId)) {
                List user2Bizs = this.user2BizRepository.getByBizidAndUserid(bizId, user.getId());
                String bizRole = "";
                for (int j = 0; j < user2Bizs.size(); ++j) {
                    if (((User2Biz)user2Bizs.get(j)).getRole() == null) continue;
                    bizRole = StringUtils.isNotBlank((CharSequence)bizRole) ? bizRole + "," + ((User2Biz)user2Bizs.get(j)).getRole() : ((User2Biz)user2Bizs.get(j)).getRole() + "";
                }
                user.setBizRole(bizRole);
            }
            result.add(user);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", count);
        map.put("content", result);
        return map;
    }

    public Map<String, Object> getUsersByBizIdAndBizAreasAndBizRoleId(String bizId, String name, String phone, List<String> bizAreas, Integer bizRoleId, String orgId, int start, int limit) throws Exception {
        List list = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long count = 0L;
        if (bizAreas.size() < 1) {
            map.put("total", count);
            map.put("content", null);
            return map;
        }
        String bizAreaList = "(";
        for (String s : bizAreas) {
            Integer regionLevel = this.regionService.getRegionLevel(s, null);
            if (regionLevel == 0) {
                bizAreaList = bizAreaList + "|";
                continue;
            }
            if (regionLevel == 1) {
                bizAreaList = bizAreaList + s.substring(0, 2) + "|";
                continue;
            }
            if (regionLevel == 2) {
                bizAreaList = bizAreaList + s.substring(0, 4) + "|";
                continue;
            }
            bizAreaList = bizAreaList + s + "|";
        }
        if (bizRoleId == null) {
            if (GutilStr.isBlank((CharSequence)orgId)) {
                String s = bizAreaList.substring(0, bizAreaList.length() - 1) + ")%";
                list = this.landUserDao.getUsersByBizIdAndRightAreas(bizId, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%", limit, start);
                count = this.landUserDao.getUsersByBizIdAndRightAreasCount(bizId, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%");
            } else {
                list = this.landUserDao.getUsersByBizIdAndRightAreasAndOrgId(bizId, phone, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%", orgId, limit, start);
                count = this.landUserDao.getUsersByBizIdAndRightAreasAndOrgIdCount(bizId, phone, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%", orgId);
            }
        } else if (GutilStr.isBlank((CharSequence)orgId)) {
            list = this.landUserDao.getUsersByBizIdAndBizAreasAndBizRoleId(bizId, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%", bizRoleId, limit, start);
            count = this.landUserDao.getUsersByBizIdAndBizAreasAndBizRoleIdCount(bizId, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%", bizRoleId);
        } else {
            list = this.landUserDao.getUsersByBizIdAndBizAreasAndBizRoleIdAndOrgId(bizId, phone, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%", bizRoleId, orgId, limit, start);
            count = this.landUserDao.getUsersByBizIdAndBizAreasAndBizRoleIdAndOrgIdCount(bizId, phone, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%", bizRoleId, orgId);
        }
        ArrayList<LandUser> result = new ArrayList<LandUser>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            BusUserInfoReso userReso;
            LandUser user = new LandUserBuilder((LandUser)list.get(i)).regionFullName().organization().hidePhone().build();
            if (GutilStr.isNotBlank((CharSequence)user.getDepname())) {
                user.setDepId(user.getDepname());
            }
            if (StringUtils.isNotBlank((CharSequence)user.getSubjectUserId()) && (userReso = this.oauthUserService.getBusUser(user.getSubjectUserId())) != null) {
                user.setRname(userReso.getRealName());
                user.setPhone(userReso.getPhone());
            }
            result.add(user);
        }
        map.put("total", count);
        map.put("content", result);
        return map;
    }

    public EasyUIResponse getUsersHasOrgButDep(String orgId, String filterParam, int start, int limit, Date date) throws Exception {
        if (GutilStr.isBlank((CharSequence)orgId)) {
            throw new RuntimeException("\u5355\u4f4did\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuffer keyword = new StringBuffer("%");
        if (GutilStr.isNotBlank((CharSequence)filterParam) && filterParam.length() > 14) {
            keyword.append(filterParam, 13, filterParam.length() - 1);
        }
        keyword.append("%");
        List landUsers = null;
        Long count = 0L;
        if (date == null) {
            landUsers = this.landUserDao.hasOrgButDep(orgId, keyword.toString(), Integer.valueOf(start - 1), Integer.valueOf(limit));
            count = this.landUserDao.countUserhasOrgButDep(orgId, keyword.toString());
        } else {
            landUsers = this.landUserDao.hasOrgButDepTime(orgId, keyword.toString(), Integer.valueOf(start - 1), Integer.valueOf(limit), date);
            count = this.landUserDao.countUserhasOrgButDepTime(orgId, keyword.toString(), date);
        }
        for (LandUser user : landUsers) {
            List roles = this.userRoleInfoDao.getRoleIdsByUserId(user.getId());
            this.completeLandUserInfo(user, roles);
            user.setDepNo(orgId);
        }
        EasyUIResponse result = new EasyUIResponse();
        result.setRows(landUsers);
        result.setTotal(count);
        return result;
    }

    public Page<LandUser> queryAllUser(String filterParam, String sortParam, int page, int size) throws Exception {
        filterParam = filterParam + ";Q_isdel_N_EQ=0;Q_name_S_NE=admin;";
        Page allUsers = this.landUserDao.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)page, (int)size, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        for (LandUser user : allUsers) {
            List roles = this.userRoleInfoDao.getRoleIdsByUserId(user.getId());
            this.completeLandUserInfo(user, roles);
        }
        return allUsers;
    }

    public void completeLandUserInfo2(LandUser user, List<String> roles) throws Exception {
        if (roles.indexOf("10007") > -1) {
            user.setUserType("\u516c\u4f17\u7528\u6237");
        } else {
            user.setUserType("\u7ba1\u7406\u7528\u6237");
        }
        if (roles.indexOf("10012") > -1) {
            user.setRoleNames("\u56fd\u5bb6\u7ea7\u7528\u6237");
        } else if (roles.indexOf("10003") > -1) {
            user.setRoleNames("\u7701\u7ea7\u7528\u6237");
        } else if (roles.indexOf("10018") > -1) {
            user.setRoleNames("\u5e02\u7ea7\u7528\u6237");
        } else if (roles.indexOf("10019") > -1) {
            user.setRoleNames("\u53bf\u7ea7\u7528\u6237");
        }
        if (roles.indexOf("10020") > -1) {
            user.setLiaison(true);
        }
        user.setRoleIds(roles.stream().collect(Collectors.joining(",")));
        LandUser2Area user2Area = this.landUser2AreaDao.queryOneByUserId(user.getId());
        if (user2Area == null) {
            return;
        }
        String xzqdm = user2Area.getRegionCode();
        if (GutilStr.isNotBlank((CharSequence)xzqdm)) {
            String fullRegionName = this.landRegUserService.getMyRegionByCode(xzqdm).getFullName();
            user.setRegionFullName(fullRegionName);
        }
        List cloudArea = this.userCloudAreaDao.getCloudArea(user.getId());
        user.setCloudAreas(cloudArea);
    }

    public void completeLandUserInfo(LandUser user, List<String> roles) throws Exception {
        LandUser2Area user2Area;
        if (roles.contains("10007")) {
            user.setUserType("\u516c\u4f17\u7528\u6237");
        } else {
            user.setUserType("\u7ba1\u7406\u7528\u6237");
        }
        if (roles.contains("10012")) {
            user.setRoleNames("\u56fd\u5bb6\u7ea7\u7528\u6237");
        } else if (roles.contains("10003")) {
            user.setRoleNames("\u7701\u7ea7\u7528\u6237");
        } else if (roles.contains("10018")) {
            user.setRoleNames("\u5e02\u7ea7\u7528\u6237");
        } else if (roles.contains("10019")) {
            user.setRoleNames("\u53bf\u7ea7\u7528\u6237");
        }
        if (roles.contains("10020")) {
            user.setLiaison(true);
        }
        if ((user2Area = this.landUser2AreaDao.queryOneByUserId(user.getId())) == null) {
            return;
        }
        String xzqdm = user2Area.getRegionCode();
        if (GutilStr.isNotBlank((CharSequence)xzqdm)) {
            String fullRegionName = this.landRegUserService.getMyRegionByCode(xzqdm).getFullName();
            user.setRegionFullName(fullRegionName);
        }
        List cloudArea = this.userCloudAreaDao.getCloudArea(user.getId());
        user.setCloudAreas(cloudArea);
    }

    public void deleteUserByAdmin(Long userId, String deleteReason, Long operatorId) throws Exception {
        this.deleteUser(userId, deleteReason, operatorId);
    }

    public void deleteUserByLiaison(Long operatorId, Long userId, String deleteReason) throws Exception {
        List deleUsroldids = this.userRoleInfoDao.getRoleIdsByUserId(userId);
        List operatorRoleIds = this.userRoleInfoDao.getRoleIdsByUserId(operatorId);
        if (operatorRoleIds.indexOf("10022") < 0 && operatorRoleIds.indexOf("10020") < 0) {
            throw new RuntimeException("\u65e0\u6743\u9650");
        }
        if (deleUsroldids.indexOf("10022") > -1) {
            throw new RuntimeException("\u7ba1\u7406\u5458\u4e0d\u53ef\u88ab\u6ce8\u9500");
        }
        if (operatorRoleIds.indexOf("10020") > -1 && (deleUsroldids.indexOf("10022") > -1 || deleUsroldids.indexOf("10020") > -1)) {
            throw new RuntimeException("\u6743\u9650\u4e0d\u8db3");
        }
        this.deleteUser(userId, deleteReason, operatorId);
    }

    public void unregister(Long userId) {
        this.deleteUser(userId, "\u7528\u6237\u81ea\u4e3b\u6ce8\u9500", userId);
    }

    private void deleteUser(Long userId, String deleteReason, Long operatorId) {
        LandUser user = this.landUserDao.findById((Object)userId).orElse(null);
        user.setDeleteTime(new Date());
        user.setLogoffReson(deleteReason);
        JSONObject userJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)user));
        OptLog optLog = new OptLog();
        optLog.setData(userJson.toString());
        optLog.setOptTime(new Date());
        optLog.setOptType(Integer.valueOf(4));
        optLog.setUserId(operatorId);
        this.optLogRepository.save((Object)optLog);
        this.landUserDao.deleteById((Object)userId);
        this.landUserRoleDao.deleteByUserId(userId);
        this.userRoleInfoDao.deleteByUserId(userId);
        this.user2BizRepository.deleteByUserId(userId);
        this.landUser2AreaDao.deleteAreaByUserId(userId);
        this.userCloudAreaDao.delteByUserId(userId);
        this.organization2UserDao.deleteByUserId(userId);
        this.department2UserDao.deleteByUserId(userId);
        this.friendsDao.deleteByUserId(userId);
        this.landRegUserDao.deleteByUserId(userId);
        this.deleteCloudDiskOfPerson(userId);
        this.userApplicationRepository.deleteByUserid(userId);
        this.user2YXDao.deleteByUserId(userId);
    }

    private void deleteCloudDiskOfPerson(Long userId) {
        CloudDiskOfPerson cloudDiskOfPerson = this.cloudDiskOfPersonDao.findById((Object)userId).orElse(null);
        if (cloudDiskOfPerson == null) {
            return;
        }
        GroupCloudDiskMember groupCloudDiskMember = this.groupCloudDiskMemberDao.queryOneByUserId(userId);
        OrgCloudDiskMember orgCloudDiskMember = this.orgCloudDiskMemberDao.queryOneByUserId(userId);
        if (orgCloudDiskMember == null && groupCloudDiskMember == null) {
            try {
                JFunBoxUserUtil.deleteUser((long)cloudDiskOfPerson.getId());
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.cloudDiskOfPersonDao.deleteById((Object)userId);
        }
    }

    public void updateUserRoles(Long userId, String roleIds) throws Exception {
        String MouldId = "10026";
        if (GutilStr.isBlank((CharSequence)roleIds)) {
            throw new RuntimeException("\u89d2\u8272\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.userRoleInfoDao.deleteByUserIdExcept(userId, "10026");
        String[] roles = roleIds.split(",");
        if (roleIds.indexOf(";") > -1) {
            roles = roleIds.split(";");
        }
        for (String role : roles) {
            String uid = UUID.randomUUID().toString();
            UserRoleInfo userRole = new UserRoleInfo();
            userRole.setId(uid);
            userRole.setRoleinfoid(role);
            userRole.setUserid(userId);
            this.userRoleInfoDao.save((Object)userRole);
        }
    }

    public LandUser addUser(UserAddInfo userInfo) throws Exception {
        LandRegUser one;
        if (GutilStr.isNotBlank((CharSequence)userInfo.getId()) && userInfo.getPhone().contains("*")) {
            one = this.landRegUserDao.findById((Object)userInfo.getId()).orElse(null);
            userInfo.setPhone(one.getPhone());
        } else {
            String phoneStr = "^[1][3,4,5,6,7,8,9][0-9]{9}$";
            if (!userInfo.getPhone().matches(phoneStr)) {
                throw new RuntimeException("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
            }
            userInfo.setPhone(userInfo.getPhone());
        }
        if (userInfo.getPassword() != null && !userInfo.getPassword().equals("")) {
            userInfo.setPassword(userInfo.getPassword());
        } else {
            one = this.landRegUserDao.findById((Object)userInfo.getId()).orElse(null);
            userInfo.setPassword(one.getPassword());
        }
        if (GutilStr.isBlank((CharSequence)userInfo.getUsername())) {
            throw new RuntimeException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List userOfName = this.landUserDao.queryUserByName(userInfo.getUsername());
        if (!userOfName.isEmpty()) {
            throw new RuntimeException("\u8be5\u7528\u6237\u540d\u5df2\u88ab\u6ce8\u518c");
        }
        LandRegUser regUserOfName = this.landRegUserDao.findOneByName(userInfo.getUsername());
        if (userInfo.getId() != null && !userInfo.getUsername().equals(regUserOfName.getName())) {
            throw new RuntimeException("\u8be5\u7528\u6237\u540d\u5df2\u88ab\u6ce8\u518c");
        }
        if (userInfo.getId() == null && regUserOfName != null) {
            throw new RuntimeException("\u8be5\u7528\u6237\u540d\u5df2\u88ab\u6ce8\u518c");
        }
        if (GutilStr.isBlank((CharSequence)userInfo.getPassword()) && userInfo.getId() == null) {
            throw new RuntimeException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!GutilStr.isBlank((CharSequence)userInfo.getPhone())) {
            List landUsersOfPhone = this.landUserDao.queryNormalUserByPhone(userInfo.getPhone());
            if (!landUsersOfPhone.isEmpty()) {
                throw new RuntimeException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c\uff0c\u8bf7\u76f4\u63a5\u767b\u5f55");
            }
            LandRegUser regUserOfPhone = this.landRegUserDao.queryOneByPhoneNum(userInfo.getPhone());
            if (regUserOfPhone != null && !regUserOfPhone.getId().equals(userInfo.getId())) {
                throw new RuntimeException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c\uff0c\u8bf7\u76f4\u63a5\u767b\u5f55");
            }
        }
        if (GutilStr.isBlank((CharSequence)userInfo.getRoleIds())) {
            throw new RuntimeException("\u7528\u6237\u540d\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String depNo = userInfo.getDepNo();
        if (GutilStr.isEmpty((CharSequence)depNo)) {
            throw new RuntimeException("\u8bf7\u5148\u521b\u5efa\u5355\u4f4d");
        }
        Organization org = this.organizationRepository.findById((Object)depNo).orElse(null);
        if (org == null) {
            throw new RuntimeException("\u7528\u6237\u5355\u4f4d\u4e0d\u5b58\u5728");
        }
        LandUser user = new LandUser();
        user.setName(userInfo.getUsername());
        user.setRname(userInfo.getRname());
        user.setPost(userInfo.getPost());
        user.setEmail(userInfo.getEmail());
        user.setBusiness(userInfo.getBusiness());
        user.setQqNumber(userInfo.getQqNumber());
        user.setCreateTime(new Date());
        user.setDeviceType(userInfo.getDeviceType());
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, calendar.get(2) + 6);
        user.setPwdExpirationTime(calendar.getTime());
        user.setPassword(userInfo.getPassword());
        user.setDepId(org.getName());
        user.setState(Integer.valueOf(1));
        user.setIsdel(Integer.valueOf(0));
        user.setPhone(userInfo.getPhone());
        user.setDepname(userInfo.getDepname());
        user.setQqNumber(userInfo.getQqNumber());
        user.setPost(userInfo.getPost());
        user.setDeviceType(userInfo.getDeviceType());
        LandUser landUser = (LandUser)this.landUserDao.save((Object)user);
        String lsId = userInfo.getId();
        LandRegUser landRegUser = new LandRegUser();
        if (lsId != null && !lsId.equals("")) {
            landRegUser.setId(lsId);
        }
        landRegUser.setPassword(userInfo.getPassword());
        landRegUser.setName(userInfo.getUsername());
        landRegUser.setRname(userInfo.getRname());
        landRegUser.setPhone(userInfo.getPhone());
        landRegUser.setPostId(userInfo.getPost());
        landRegUser.setState(Integer.valueOf(1));
        landRegUser.setDepNo(userInfo.getDepNo());
        landRegUser.setCreateTime(userInfo.getCreateTime());
        landRegUser.setUserId(landUser.getId());
        landRegUser.setRegOri(userInfo.getRegOri());
        landRegUser.setOriId(userInfo.getOriId());
        landRegUser.setSjsf(userInfo.getRegionCode());
        landRegUser.setBusiness(userInfo.getBusiness());
        landRegUser.setRoleIds(userInfo.getRoleIds());
        landRegUser.setDepName(userInfo.getDepname());
        this.landRegUserDao.save((Object)landRegUser);
        String[] roles = userInfo.getRoleIds().split(",");
        if (userInfo.getRoleIds().indexOf(";") > -1) {
            roles = userInfo.getRoleIds().split(";");
        }
        for (String role : roles) {
            String uid = UUID.randomUUID().toString();
            UserRoleInfo userRole = new UserRoleInfo();
            userRole.setId(uid);
            userRole.setRoleinfoid(role);
            userRole.setUserid(landUser.getId());
            this.userRoleInfoDao.save((Object)userRole);
        }
        String regionCode = userInfo.getRegionCode();
        if (GutilStr.isNotBlank((CharSequence)regionCode)) {
            LandUser2Area landUser2Area = new LandUser2Area();
            landUser2Area.setUserId(landUser.getId());
            landUser2Area.setCreateTime(userInfo.getCreateTime());
            landUser2Area.setState(Integer.valueOf(1));
            landUser2Area.setRegionCode(regionCode);
            this.landUser2AreaDao.save((Object)landUser2Area);
        }
        if (GutilStr.isNotBlank((CharSequence)userInfo.getDepNo())) {
            Organization2User organization2User = new Organization2User();
            organization2User.setId(UUID.randomUUID().toString());
            organization2User.setOrganizationId(userInfo.getDepNo());
            organization2User.setUserId(landUser.getId());
            this.organization2UserDao.save((Object)organization2User);
        }
        if (GutilStr.isNotBlank((CharSequence)userInfo.getDepaId())) {
            Department2User department2User = new Department2User();
            department2User.setId(UUID.randomUUID().toString());
            department2User.setUserId(landUser.getId());
            department2User.setDepartmentId(userInfo.getDepaId());
            this.department2UserDao.save((Object)department2User);
        }
        if (GutilStr.isNotEmpty((CharSequence)userInfo.getCloudArea())) {
            Object[] cloudAreas = userInfo.getCloudArea().split(",");
            ArrayList cloudList = ListUtil.toList((Object[])cloudAreas);
            ArrayList<UserCloudArea> userCloudAreas = new ArrayList<UserCloudArea>();
            for (String cloud : cloudList) {
                UserCloudArea userCloudArea = new UserCloudArea();
                userCloudArea.setCode(cloud);
                userCloudArea.setUserId(landUser.getId());
                userCloudArea.setCreateTime(new Date());
                userCloudArea.setState(Integer.valueOf(1));
                userCloudAreas.add(userCloudArea);
            }
            this.userCloudAreaDao.saveAll(userCloudAreas);
        }
        return user;
    }

    public LandUser addUserThird(UserAddInfo userInfo, List<String> errorCodeList) throws Exception {
        String[] roles;
        List regUserOfNameList;
        Long userid = -1L;
        List userOfName = this.landUserDao.queryAppUserByUsernameOrPhone(userInfo.getUsername());
        if (!userOfName.isEmpty()) {
            errorCodeList.add("E00002");
            userid = ((LandUser)userOfName.get(0)).getId();
        }
        if ((regUserOfNameList = this.landRegUserDao.queryRegUserByNameOrPhone(userInfo.getUsername())) != null && regUserOfNameList.size() > 0) {
            if (!errorCodeList.contains("E00002")) {
                errorCodeList.add("E00002");
            }
            userid = ((LandRegUser)regUserOfNameList.get(0)).getUserId();
        }
        if (!GutilStr.isBlank((CharSequence)userInfo.getPhone())) {
            List regUserOfPhoneList;
            List landUsersOfPhone = this.landUserDao.queryAppUserByUsernameOrPhone(userInfo.getPhone());
            if (!landUsersOfPhone.isEmpty()) {
                errorCodeList.add("E00003");
            }
            if ((regUserOfPhoneList = this.landRegUserDao.queryRegUserByNameOrPhone(userInfo.getPhone())) != null && regUserOfPhoneList.size() > 0 && !errorCodeList.contains("E00003")) {
                errorCodeList.add("E00003");
            }
        }
        if (userid != null && userid > 0L) {
            List cloudArea;
            List roleList = this.userRoleService.findRoleIdsByUserId(userid);
            if (roleList.contains(10012L) && !userInfo.getRoleIds().contains("10012") || roleList.contains(10003L) && !userInfo.getRoleIds().contains("10003") || roleList.contains(10018L) && !userInfo.getRoleIds().contains("10018") || roleList.contains(10019L) && !userInfo.getRoleIds().contains("10019")) {
                errorCodeList.add("E00004");
            }
            if (!(cloudArea = this.landUser2AreaDao.queryAreas(userid)).contains(userInfo.getRegionCode())) {
                errorCodeList.add("E00005");
            }
            if (roleList.contains(10020L) && !userInfo.getRoleIds().contains("10020") || !roleList.contains(10020L) && userInfo.getRoleIds().contains("10020")) {
                errorCodeList.add("E00007");
            }
        }
        if (errorCodeList.size() > 0) {
            return null;
        }
        Organization org = this.organizationRepository.findById((Object)userInfo.getDepNo()).orElse(null);
        LandUser user = new LandUser();
        user.setName(userInfo.getUsername());
        user.setRname(userInfo.getRname());
        user.setPost(userInfo.getPost());
        user.setBusiness(userInfo.getBusiness());
        user.setQqNumber(userInfo.getQqNumber());
        user.setCreateTime(userInfo.getCreateTime());
        user.setPassword(userInfo.getPassword());
        user.setDepId(org.getName());
        user.setState(Integer.valueOf(1));
        user.setIsdel(Integer.valueOf(0));
        user.setPhone(userInfo.getPhone());
        LandUser landUser = (LandUser)this.landUserDao.save((Object)user);
        LandRegUser landRegUser = new LandRegUser();
        landRegUser.setName(userInfo.getUsername());
        landRegUser.setRname(userInfo.getRname());
        landRegUser.setPhone(userInfo.getPhone());
        landRegUser.setPostId(userInfo.getPost());
        landRegUser.setState(Integer.valueOf(1));
        landRegUser.setDepNo(userInfo.getDepNo());
        landRegUser.setCreateTime(userInfo.getCreateTime());
        landRegUser.setUserId(landUser.getId());
        landRegUser.setRegOri(userInfo.getRegOri());
        landRegUser.setOriId(userInfo.getOriId());
        this.landRegUserDao.save((Object)landRegUser);
        for (String role : roles = userInfo.getRoleIds().split(",")) {
            UserRoleInfo ur = new UserRoleInfo();
            ur.setId(UUID.randomUUID().toString());
            ur.setRoleinfoid(role);
            ur.setUserid(landUser.getId());
            this.userRoleInfoDao.save((Object)ur);
        }
        String regionCode = userInfo.getRegionCode();
        if (GutilStr.isNotBlank((CharSequence)regionCode)) {
            LandUser2Area landUser2Area = new LandUser2Area();
            landUser2Area.setUserId(landUser.getId());
            landUser2Area.setCreateTime(userInfo.getCreateTime());
            landUser2Area.setState(Integer.valueOf(1));
            landUser2Area.setRegionCode(regionCode);
            this.landUser2AreaDao.save((Object)landUser2Area);
        }
        if (GutilStr.isNotBlank((CharSequence)userInfo.getDepNo())) {
            Organization2User organization2User = new Organization2User();
            organization2User.setId(UUID.randomUUID().toString());
            organization2User.setOrganizationId(userInfo.getDepNo());
            organization2User.setUserId(landUser.getId());
            this.organization2UserDao.save((Object)organization2User);
        }
        if (GutilStr.isNotBlank((CharSequence)userInfo.getDepaId())) {
            Department2User department2User = new Department2User();
            department2User.setId(UUID.randomUUID().toString());
            department2User.setUserId(landUser.getId());
            department2User.setDepartmentId(userInfo.getDepaId());
            this.department2UserDao.save((Object)department2User);
        }
        if (GutilStr.isNotEmpty((CharSequence)userInfo.getCloudArea())) {
            Object[] cloudAreas = userInfo.getCloudArea().split(",");
            ArrayList cloudList = ListUtil.toList((Object[])cloudAreas);
            ArrayList<UserCloudArea> userCloudAreas = new ArrayList<UserCloudArea>();
            for (String cloud : cloudList) {
                UserCloudArea userCloudArea = new UserCloudArea();
                userCloudArea.setCode(cloud);
                userCloudArea.setUserId(landUser.getId());
                userCloudArea.setCreateTime(new Date());
                userCloudArea.setState(Integer.valueOf(1));
                userCloudAreas.add(userCloudArea);
            }
            this.userCloudAreaDao.saveAll(userCloudAreas);
        }
        return user;
    }

    public void resetPasswordByAdmin(String userId, String newPassword) throws Exception {
        LandUser user = this.landUserDao.findById((Object)Long.valueOf(userId)).orElse(null);
        if (GutilStr.isBlank((CharSequence)newPassword)) {
            throw new RuntimeException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 6);
        this.landUserDao.updatePwdExpirationTime(Long.valueOf(userId).longValue(), calendar.getTime());
        user.setPwdExpirationTime(calendar.getTime());
        user.setPassword(newPassword);
        this.landUserDao.save((Object)user);
    }

    public List<LandUser> getUserListByIds(List<Long> ids) {
        List landUsers = this.landUserDao.queryUserByIds(ids);
        return landUsers;
    }

    public String getReginCodeByUserId(Long userId) {
        LandUser2Area user2Area = this.landUser2AreaDao.queryOneByUserId(userId);
        if (user2Area != null) {
            return user2Area.getRegionCode();
        }
        return "";
    }

    public Region getRegion(String regionCode) {
        RegionVersion defaultVersion = this.regionVersionRepository.getRegionVersionByDefault();
        if (GutilStr.isBlank((CharSequence)regionCode)) {
            throw new RuntimeException("\u884c\u653f\u533a\u4ee3\u7801\u4e3a\u7a7a");
        }
        Region region = this.regionDao.findByCodeAndVersion(regionCode, defaultVersion != null ? defaultVersion.getVersion() : "2018");
        return region;
    }

    public void changeEmail(Long userId, String email) {
        LandUser one = this.landUserDao.findById((Object)userId).orElse(null);
        one.setEmail(email);
        this.landUserDao.save((Object)one);
        LandRegUser regUser = this.landRegUserDao.findOneByName(one.getName());
        if (regUser != null) {
            regUser.setEmail(email);
            this.landRegUserDao.save((Object)regUser);
        }
    }

    public void changeRname(Long userId, String rname) {
        LandUser one = this.landUserDao.findById((Object)userId).orElse(null);
        one.setRname(rname);
        this.landUserDao.save((Object)one);
        LandRegUser regUser = this.landRegUserDao.findOneByName(one.getName());
        if (regUser != null) {
            regUser.setRname(rname);
            this.landRegUserDao.save((Object)regUser);
        }
    }

    public void changePhone(Long userId, String phone) {
        LandUser one = this.landUserDao.findById((Object)userId).orElse(null);
        one.setPhone(phone);
        this.landUserDao.save((Object)one);
        LandRegUser regUser = this.landRegUserDao.findOneByName(one.getName());
        if (regUser != null) {
            regUser.setPhone(phone);
            this.landRegUserDao.save((Object)regUser);
        }
    }

    public List<LandUser> getMyPublicUsers(List<String> areas) {
        List users = this.landUserDao.queryUserByArea(areas, "\u793e\u4f1a\u516c\u4f17");
        return users;
    }

    private String createTaskZyqUserSql(String bizId, String region, String phone, String username, String area) {
        String sql = " from tbtsk_right_area_reg tr LEFT JOIN tbsys_user tu ON cast( tu.f_userid AS VARCHAR ) = tr.f_userid  LEFT JOIN tbsys_user_area ta ON tu.f_userid = ta.f_userid  JOIN tb_region tb on tb.f_xzqdm = ta.f_regioncode  where tr.f_status is null ";
        if (GutilStr.isNotBlank((CharSequence)region)) {
            sql = sql + " and ta.f_regioncode='" + region + "'";
        }
        if (GutilStr.isNotBlank((CharSequence)phone)) {
            sql = sql + " and tu.f_phonemobile like '%" + phone + "%'";
        }
        if (GutilStr.isNotBlank((CharSequence)username)) {
            sql = sql + " and tu.f_username like '%" + username + "%'";
        }
        if (GutilStr.isNotBlank((CharSequence)bizId)) {
            sql = sql + " and tr.f_taskid='" + bizId + "'";
        }
        if (GutilStr.isNotBlank((CharSequence)area) && !"1".equalsIgnoreCase(area)) {
            if (area.endsWith("0000")) {
                area = area.substring(0, 2);
            } else if (area.endsWith("00")) {
                area = area.substring(0, 4);
            }
            sql = sql + " and tr.f_xzqdm like '" + area + "%'";
        }
        return sql;
    }

    public List<Map<String, Object>> findTaskZyqUsers(String bizId, String region, String phone, String username, String area, int page, int pageSize) {
        String table = this.createTaskZyqUserSql(bizId, region, phone, username, area);
        String sql = "select tu.*,ta.f_regioncode,tb.f_xzqmc,tr.f_xzqdm as f_zyqdm,tr.f_id as f_regzyqid, tr.f_createtime as f_zyqsqsj " + table + " LIMIT " + pageSize + " OFFSET " + (page - 1) * pageSize;
        return this.jdbcTemplate.queryForList(sql);
    }

    public Long findCountTaskZyqUsers(String bizId, String region, String phone, String username, String area) {
        String table = this.createTaskZyqUserSql(bizId, region, phone, username, area);
        String sql = "select count(tu.*) " + table;
        return (Long)this.jdbcTemplate.queryForObject(sql, Long.class);
    }

    public Map<String, Object> getUsersByOrgIdAndRoleId(String orgId, String roleId, int userType, String userName, int start, int limit) throws Exception {
        if (GutilStr.isBlank((CharSequence)orgId)) {
            throw new RuntimeException("\u90e8\u95e8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (GutilStr.isBlank((CharSequence)userName)) {
            userName = "";
        }
        List<Long> idList = this.getUserIdsByOrgIdAndUserType(orgId, userType);
        List landUsers = new ArrayList();
        if (idList.isEmpty()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("total", 0);
            map.put("content", Collections.emptyList());
            return map;
        }
        landUsers = GutilStr.isBlank((CharSequence)roleId) ? this.landUserDao.queryUserByIds4(idList, "%" + userName + "%") : this.landUserDao.queryUserByIdsAndUserNameLikeAndRoleId(idList, "%" + userName + "%", roleId);
        LinkedHashSet set = new LinkedHashSet(landUsers);
        ArrayList users = new ArrayList(set);
        ArrayList<LandUser> result = new ArrayList<LandUser>();
        int currIdx = start > 0 ? start * limit : 0;
        for (int i = 0; i < limit && i < users.size() - currIdx; ++i) {
            LandUser user = new LandUserBuilder((LandUser)users.get(currIdx + i)).role().cloudArea().organization().regionFullName().build();
            if (GutilStr.isNotBlank((CharSequence)orgId)) {
                user.setDepNo(orgId);
            }
            result.add(user);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", users.size());
        map.put("content", result);
        return map;
    }

    public List<UserGrant> getUserOnlyGrantBizNew(String bizid, String name, int offset, int limit, String roleid, String regionCode, String orgName, String role, String phoneNumber, String regionFullName) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(UserGrant.class);
        StringBuffer sqlAll = new StringBuffer();
        String fieldSql = "SELECT T.f_userid,T.f_username,T.isgran,T.f_phonemobile,T.f_depid,T.roles,T.f_rname,T.f_regioncode";
        sqlAll.append(fieldSql);
        if (!role.equals("") && !role.equals("0")) {
            sqlAll.append(",T.f_role ");
        }
        String tableSql1 = " from (\nSELECT\n\tb.f_userid,\n\tb.f_username,\n\tb.f_rname,\n\tb.f_depid,\n\tb.f_phonemobile,\n\tC.f_regioncode,\n\tP.f_bizid,\n\tP.f_bizid ='7' AS isgran,\n\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \nFROM\n\ttbsys_user b\n\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid FROM tbsys_user_biz A WHERE A.f_bizid ='7') AS P ON P.f_userid = b.f_userid\n\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \nWHERE\n\tb.f_isdeleted <> '1' \n\t) AS T  WHERE  1=1 ";
        String tableSql2 = " from (\nSELECT\n\tb.f_userid,\n\tb.f_username,\n\tb.f_rname,\n\tb.f_depid,\n\tb.f_phonemobile,\n\tC.f_regioncode,\n\tP.f_bizid,\n\tP.f_role,\n\tP.f_bizid ='7' AS isgran,\n\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \nFROM\n\ttbsys_user b\n\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid,A.f_role FROM tbsys_user_biz A WHERE A.f_bizid ='7') AS P ON P.f_userid = b.f_userid\n\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \nWHERE\n\tb.f_isdeleted <> '1' \n\t) AS T  WHERE  1=1 ";
        if (!role.equals("") && !role.equals("0")) {
            sqlAll.append(tableSql2);
            if (role.equals("1")) {
                sqlAll.append("\tAND T.f_role in ( 1 ) \n");
            } else if (role.equals("3")) {
                sqlAll.append("\tAND T.f_role in ( 3 ) \n");
            } else if (role.equals("2")) {
                sqlAll.append("\tAND T.f_role in ( 2 ) \n");
            } else if (role.equals("4")) {
                sqlAll.append("\tAND T.f_role in ( 4 ) \n");
            }
        } else {
            sqlAll.append(tableSql1);
        }
        if (!roleid.equals("")) {
            sqlAll.append("AND T.roles LIKE '%" + roleid + "%'");
        }
        if (!name.equalsIgnoreCase("")) {
            sqlAll.append("AND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')");
        }
        if (!phoneNumber.equals("")) {
            sqlAll.append("AND T.f_phonemobile LIKE '%" + phoneNumber + "%'");
        }
        if (!regionCode.equals("")) {
            sqlAll.append("AND T.f_regioncode like '" + regionCode + "%'");
        }
        if (!orgName.equals("")) {
            sqlAll.append("AND T.f_depid like '%" + orgName + "%'");
        }
        if (!bizid.equals("")) {
            sqlAll.append("AND T.f_bizid='" + bizid + "'");
        }
        sqlAll.append(" ORDER BY T.f_username LIMIT " + limit + " OFFSET " + offset);
        return this.jdbcTemplate.query(sqlAll.toString(), (RowMapper)rowMapper);
    }

    public List<UserGrant> getUserAllBizNew(String bizid, String name, int offset, int limit, String roleid, String regionCode, String orgName, String role, String phoneNumber, String regionFullName, String source) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(UserGrant.class);
        StringBuffer sqlAll = new StringBuffer();
        String fieldSql = "SELECT T.f_userid,T.f_username,T.isgran,T.f_phonemobile,T.f_depid,T.roles,T.f_rname,T.f_regioncode";
        sqlAll.append(fieldSql);
        if (!role.equals("") && !role.equals("0")) {
            sqlAll.append(",T.f_role ");
        }
        String tableSql1 = " from (\nSELECT\n\tb.f_userid,\n\tb.f_username,\n\tb.f_rname,\n\tb.f_depid,\n\tb.f_phonemobile,\n\tC.f_regioncode,\n\tP.f_bizid,\n\tP.f_bizid ='7' AS isgran,\n\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \nFROM\n\ttbsys_user b\n\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid FROM tbsys_user_biz A) AS P ON P.f_userid = b.f_userid\n\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \nWHERE\n\tb.f_isdeleted <> '1' \n\t) AS T  WHERE  1=1 ";
        String tableSql2 = " from (\nSELECT\n\tb.f_userid,\n\tb.f_username,\n\tb.f_rname,\n\tb.f_depid,\n\tb.f_phonemobile,\n\tC.f_regioncode,\n\tP.f_bizid,\n\tP.f_role,\n\tP.f_bizid ='7' AS isgran,\n\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \nFROM\n\ttbsys_user b\n\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid,A.f_role FROM tbsys_user_biz A) AS P ON P.f_userid = b.f_userid\n\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \nWHERE\n\tb.f_isdeleted <> '1' \n\t) AS T  WHERE  1=1 ";
        if (!role.equals("") && !role.equals("0")) {
            sqlAll.append(tableSql2);
            if (role.equals("1")) {
                sqlAll.append("\tAND T.f_role in ( 1 ) \n");
            } else if (role.equals("3")) {
                sqlAll.append("\tAND T.f_role in ( 3 ) \n");
            } else if (role.equals("2")) {
                sqlAll.append("\tAND T.f_role in ( 2 ) \n");
            } else if (role.equals("4")) {
                sqlAll.append("\tAND T.f_role in ( 4 ) \n");
            }
        } else {
            sqlAll.append(tableSql1);
        }
        if (!roleid.equals("")) {
            sqlAll.append("AND T.roles LIKE '%" + roleid + "%'");
        }
        if (!name.equalsIgnoreCase("")) {
            sqlAll.append("AND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')");
        }
        if (!phoneNumber.equals("")) {
            sqlAll.append("AND T.f_phonemobile LIKE '%" + phoneNumber + "%'");
        }
        if (!regionCode.equals("")) {
            sqlAll.append("AND T.f_regioncode like '" + regionCode + "%'");
        }
        if (!orgName.equals("")) {
            sqlAll.append("AND T.f_depid like '%" + orgName + "%'");
        }
        if (source.equals("1")) {
            sqlAll.append("AND T.f_bizid='" + bizid + "'");
        } else if (source.equals("2")) {
            sqlAll.append("and not exists (select * from tbsys_user_biz AA WHERE AA.f_userid = T.f_userid AND AA.f_bizid ='7')");
        }
        sqlAll.append(" ORDER BY T.f_username LIMIT " + limit + " OFFSET " + offset);
        return this.jdbcTemplate.query(sqlAll.toString(), (RowMapper)rowMapper);
    }

    public Long getUserOnlyGrantBizCountNew(String bizid, String name, String roleid, String regionCode, String orgName, String role, String phoneNumber, String regionFullName) {
        StringBuffer sqlAll = new StringBuffer();
        String fieldSql = "SELECT count(1) ";
        sqlAll.append(fieldSql);
        String tableSql1 = " from (\nSELECT\n\tb.f_userid,\n\tb.f_username,\n\tb.f_rname,\n\tb.f_depid,\n\tb.f_phonemobile,\n\tC.f_regioncode,\n\tP.f_bizid,\n\tP.f_bizid ='7' AS isgran,\n\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \nFROM\n\ttbsys_user b\n\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid FROM tbsys_user_biz A WHERE A.f_bizid ='7') AS P ON P.f_userid = b.f_userid\n\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \nWHERE\n\tb.f_isdeleted <> '1' \n\t) AS T  WHERE  1=1 ";
        String tableSql2 = " from (\nSELECT\n\tb.f_userid,\n\tb.f_username,\n\tb.f_rname,\n\tb.f_depid,\n\tb.f_phonemobile,\n\tC.f_regioncode,\n\tP.f_bizid,\n\tP.f_role,\n\tP.f_bizid ='7' AS isgran,\n\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \nFROM\n\ttbsys_user b\n\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid,A.f_role FROM tbsys_user_biz A WHERE A.f_bizid ='7') AS P ON P.f_userid = b.f_userid\n\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \nWHERE\n\tb.f_isdeleted <> '1' \n\t) AS T  WHERE  1=1 ";
        if (!role.equals("") && !role.equals("0")) {
            sqlAll.append(tableSql2);
            if (role.equals("1")) {
                sqlAll.append("\tAND T.f_role in ( 1 ) \n");
            } else if (role.equals("3")) {
                sqlAll.append("\tAND T.f_role in ( 3 ) \n");
            } else if (role.equals("2")) {
                sqlAll.append("\tAND T.f_role in ( 2 ) \n");
            } else if (role.equals("4")) {
                sqlAll.append("\tAND T.f_role in ( 4 ) \n");
            }
        } else {
            sqlAll.append(tableSql1);
        }
        if (!roleid.equals("")) {
            sqlAll.append("AND T.roles LIKE '%" + roleid + "%'");
        }
        if (!name.equalsIgnoreCase("")) {
            sqlAll.append("AND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')");
        }
        if (!phoneNumber.equals("")) {
            sqlAll.append("AND T.f_phonemobile LIKE '%" + phoneNumber + "%'");
        }
        if (!regionCode.equals("")) {
            sqlAll.append("AND T.f_regioncode like '" + regionCode + "%'");
        }
        if (!orgName.equals("")) {
            sqlAll.append("AND T.f_depid like '%" + orgName + "%'");
        }
        if (!bizid.equals("")) {
            sqlAll.append("AND T.f_bizid='" + bizid + "'");
        }
        return (Long)this.jdbcTemplate.queryForObject(sqlAll.toString(), Long.class);
    }

    public Long getUserAllBizCountNew(String bizid, String name, String roleid, String regionCode, String orgName, String role, String phoneNumber, String regionFullName, String source) {
        StringBuffer sqlAll = new StringBuffer();
        String fieldSql = "SELECT count(1) ";
        sqlAll.append(fieldSql);
        String tableSql1 = " from (\nSELECT\n\tb.f_userid,\n\tb.f_username,\n\tb.f_rname,\n\tb.f_depid,\n\tb.f_phonemobile,\n\tC.f_regioncode,\n\tP.f_bizid,\n\tP.f_bizid ='7' AS isgran,\n\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \nFROM\n\ttbsys_user b\n\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid FROM tbsys_user_biz A ) AS P ON P.f_userid = b.f_userid\n\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \nWHERE\n\tb.f_isdeleted <> '1' \n\t) AS T  WHERE  1=1 ";
        String tableSql2 = " from (\nSELECT\n\tb.f_userid,\n\tb.f_username,\n\tb.f_rname,\n\tb.f_depid,\n\tb.f_phonemobile,\n\tC.f_regioncode,\n\tP.f_bizid,\n\tP.f_role,\n\tP.f_bizid ='7' AS isgran,\n\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \nFROM\n\ttbsys_user b\n\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid,A.f_role FROM tbsys_user_biz A ) AS P ON P.f_userid = b.f_userid\n\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \nWHERE\n\tb.f_isdeleted <> '1' \n\t) AS T  WHERE  1=1 ";
        if (!role.equals("") && !role.equals("0")) {
            sqlAll.append(tableSql2);
            if (role.equals("1")) {
                sqlAll.append("\tAND T.f_role in ( 1 ) \n");
            } else if (role.equals("3")) {
                sqlAll.append("\tAND T.f_role in ( 3 ) \n");
            } else if (role.equals("2")) {
                sqlAll.append("\tAND T.f_role in ( 2 ) \n");
            } else if (role.equals("4")) {
                sqlAll.append("\tAND T.f_role in ( 4 ) \n");
            }
        } else {
            sqlAll.append(tableSql1);
        }
        if (!roleid.equals("")) {
            sqlAll.append("AND T.roles LIKE '%" + roleid + "%'");
        }
        if (!name.equalsIgnoreCase("")) {
            sqlAll.append("AND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')");
        }
        if (!phoneNumber.equals("")) {
            sqlAll.append("AND T.f_phonemobile LIKE '%" + phoneNumber + "%'");
        }
        if (!regionCode.equals("")) {
            sqlAll.append("AND T.f_regioncode like '" + regionCode + "%'");
        }
        if (!orgName.equals("")) {
            sqlAll.append("AND T.f_depid like '%" + orgName + "%'");
        }
        if (source.equals("1")) {
            sqlAll.append("AND T.f_bizid='" + bizid + "'");
        } else if (source.equals("2")) {
            sqlAll.append("and not exists (select * from tbsys_user_biz AA WHERE AA.f_userid = T.f_userid AND AA.f_bizid ='7')");
        }
        return (Long)this.jdbcTemplate.queryForObject(sqlAll.toString(), Long.class);
    }

    private Long createSQLByBizIdAndUserRoleCount(String bizId, String role, List<String> region, String name, String nameLike) {
        String tableName = "";
        String tablefield = "c.f_regioncode";
        if (role.equals("1")) {
            tableName = GLY_TABLE_NAME;
        } else if (role.equals("2")) {
            tableName = SHY_TABLE_NAME;
        } else if (role.equals("3")) {
            tableName = ZYY_TABLE_NAME;
            tablefield = "c.f_xzqdm";
        } else if (role.equals("4")) {
            tableName = FHY_TABLE_NAME;
        } else if (role.equals("5")) {
            tableName = CJSHY_TABLE_NAME;
        } else if (role.equals("6")) {
            tableName = SCY_TABLE_NAME;
        }
        String regionStr = "";
        for (int i = 0; i < region.size(); ++i) {
            if (region.get(i).equals("1")) continue;
            regionStr = regionStr + " " + tablefield + " ";
            String tempRegion = "";
            tempRegion = region.get(i).endsWith("0000") && region.get(i).length() <= 6 ? region.get(i).substring(0, 2) + "%" : (region.get(i).endsWith("00") && region.get(i).length() <= 6 ? region.get(i).substring(0, 4) + "%" : region.get(i) + "%");
            regionStr = regionStr + "like '" + tempRegion + "'";
            if (i >= region.size() - 1) continue;
            regionStr = regionStr + " or ";
        }
        if (GutilStr.isNotBlank((CharSequence)regionStr)) {
            regionStr = " and ( " + regionStr + " ) ";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" select count(1) from ( ");
        stringBuffer.append("select distinct(u.*) from tbsys_user u,tbsys_user_biz2 b," + tableName + " c ");
        stringBuffer.append(" where u.f_userid = b.f_userid and b.f_userid = cast(c.f_userid as int8 ) and b.f_bizid = c.f_taskid and b.f_role=" + role + (StringUtils.isNotBlank((CharSequence)name) ? " and u.f_username = '" + name + "'" : "") + " and u.f_username like '" + nameLike + "' and b.f_bizid = '" + bizId + "' " + regionStr + " ) m");
        Long count = (Long)this.jdbcTemplate.queryForObject(stringBuffer.toString(), Long.class);
        return count;
    }

    private List<LandUser> createSQLByBizIdAndUserRole(String bizId, String role, List<String> region, int limit, int start, String name, String nameLike) {
        String tableName = "";
        String tablefield = "c.f_regioncode";
        if (role.equals("1")) {
            tableName = GLY_TABLE_NAME;
        } else if (role.equals("2")) {
            tableName = SHY_TABLE_NAME;
        } else if (role.equals("3")) {
            tableName = ZYY_TABLE_NAME;
            tablefield = "c.f_xzqdm";
        } else if (role.equals("4")) {
            tableName = FHY_TABLE_NAME;
        } else if (role.equals("5")) {
            tableName = CJSHY_TABLE_NAME;
        } else if (role.equals("6")) {
            tableName = SCY_TABLE_NAME;
        }
        String regionStr = "";
        for (int i = 0; i < region.size(); ++i) {
            if (region.get(i).equals("1")) continue;
            regionStr = regionStr + " " + tablefield + " ";
            String tempRegion = "";
            tempRegion = region.get(i).endsWith("0000") && region.get(i).length() <= 6 ? region.get(i).substring(0, 2) + "%" : (region.get(i).endsWith("00") && region.get(i).length() <= 6 ? region.get(i).substring(0, 4) + "%" : region.get(i) + "%");
            regionStr = regionStr + "like '" + tempRegion + "'";
            if (i >= region.size() - 1) continue;
            regionStr = regionStr + " or ";
        }
        if (GutilStr.isNotBlank((CharSequence)regionStr)) {
            regionStr = " and ( " + regionStr + " ) ";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select distinct(u.*) from tbsys_user u,tbsys_user_biz2 b," + tableName + " c ");
        stringBuffer.append(" where u.f_userid = b.f_userid and b.f_userid = cast(c.f_userid as int8 ) and b.f_bizid = c.f_taskid and b.f_role=" + role + (StringUtils.isNotBlank((CharSequence)name) ? " and u.f_username = '" + name + "'" : "") + " and u.f_username like '" + nameLike + "' and b.f_bizid = '" + bizId + "' " + regionStr + "limit " + limit + " offset " + start);
        List list = this.jdbcTemplate.queryForList(stringBuffer.toString());
        ArrayList<LandUser> landUsers = new ArrayList<LandUser>();
        for (Map map : list) {
            LandUser landUser = new LandUser();
            landUser.setId(Long.valueOf(map.get("f_userid").toString()));
            landUser.setName(map.get("f_username").toString());
            landUser.setSubjectUserId(map.get("f_subject_userid").toString());
            landUser.setMidUserId(map.get("f_mid_userid").toString());
            landUsers.add(landUser);
        }
        return landUsers;
    }
}

